% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_poly.R
\name{factor_poly}
\alias{factor_poly}
\alias{factor_poly.}
\title{Factor a polynomial}
\usage{
factor_poly(mpoly, code = FALSE)

factor_poly.(mpoly, code = FALSE, ...)
}
\arguments{
\item{mpoly}{a character parseable by \code{\link[mpoly:mp]{mpoly::mp()}}, an
\code{mpoly} object, or a pointer to a polynomial in M2}

\item{code}{return only the M2 code? (default: \code{FALSE})}

\item{...}{...}
}
\value{
a named list with elements \code{factor} (an
\code{mpolyList} object) and \code{power}, an integer
vector
}
\description{
Factor a polynomial
}
\examples{

\dontrun{ requires Macaulay2 be installed and an interactive session

##### basic usage
########################################

ring("x", "y", coefring = "QQ")
factor_poly("x^4 - y^4")

# reference function
factor_poly.("x^4 - y^4")


##### different inputs
########################################

# factor_poly accepts mpoly objects:
# remember you must create the ring first!
(p <- mp("x^4 - y^4"))
factor_poly.(p)
factor_poly(p)
mp("(x-y) (x+y) (x^2+y^2)")



##### other examples
########################################

ring("x","y", "z", coefring = "QQ")
(p <- mp("(x^2 - y) (x^2 + y) (x + y)^2 (x - z)^2"))
factor_poly.(p)
factor_poly(p)

(p <- mp("(x-1)^3 (y-1)^3"))
factor_poly.(p)
factor_poly(p)

}
}
