% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simplify.R
\name{Simplify}
\alias{Simplify}
\alias{simplifications}
\alias{Cache}
\alias{deCache}
\title{Symbollic simplification of an expression or function}
\usage{
Simplify(expr, env = parent.frame(), scache = new.env())

Cache(st, env = Leaves(st), prefix = "")

deCache(st)
}
\arguments{
\item{expr}{An expression to be simplified, expr can be
\itemize{
   \item an expression: \code{expression(x+x)}
   \item a string: \code{"x+x"}
   \item a function: \code{function(x) x+x}
   \item a right hand side of a formula: \code{~x+x}
   \item a language: \code{quote(x+x)}
}}

\item{env}{An environment in which a simplified function is created
if \code{expr} is a function. This argument is ignored in all other cases.}

\item{scache}{An environment where there is a list in which simplified expression are cached}

\item{st}{A language expression to be cached}

\item{prefix}{A string to start the names of the cache variables}
}
\value{
A simplified expression. The result is of the same type as
 \code{expr} except for formula, where a language is returned.
}
\description{
Symbollic simplification of an expression or function
}
\details{
An environment \code{simplifications} containing simplification rules, is exported in the namespace accessible by the user.
 Cache() is used to remove redundunt calculations by storing them in
 cache variables. Default parameters to Cache() does not have to be provided
 by user. deCache() makes the inverse job -- a series of assignements
 are replaced by only one big expression without assignement.
 Sometimes it is usefull to
 apply deChache() and only then pass its result to Cache().
}
\concept{symbolic simplification}
