#runas mandel(20,0.,0., 8)
#bench mandel(400,0.,0., 75)
#pythran export mandel(int, float, float, int)
def mandel(size, x_center, y_center, max_iteration):
    out= [ [ 0 for i in range(size) ] for j in range(size) ]
    for i in range(size):
        "omp parallel for"
        for j in range(size):
            x,y = ( x_center + 4.0*float(i-size/2)/size,
                      y_center + 4.0*float(j-size/2)/size
                    )

            a,b = (0.0, 0.0)
            iteration = 0

            while (a**2 + b**2 <= 4.0 and iteration < max_iteration):
                a,b = a**2 - b**2 + x, 2*a*b + y
                iteration += 1
            if iteration == max_iteration:
                color_value = 255
            else:
                color_value = iteration*10 % 255
            out[i][j]=color_value
    return out
