# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Dict, List, Literal, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AadConnectivityState(_serialization.Model):
    """Describes an Azure resource with kind.

    :ivar connectivity_state: The connectivity state of the external AAD solution. Known values
     are: "Discovered", "NotLicensed", and "Connected".
    :vartype connectivity_state: str or ~azure.mgmt.security.models.AadConnectivityStateEnum
    """

    _attribute_map = {
        "connectivity_state": {"key": "connectivityState", "type": "str"},
    }

    def __init__(
        self, *, connectivity_state: Optional[Union[str, "_models.AadConnectivityStateEnum"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword connectivity_state: The connectivity state of the external AAD solution. Known values
         are: "Discovered", "NotLicensed", and "Connected".
        :paramtype connectivity_state: str or ~azure.mgmt.security.models.AadConnectivityStateEnum
        """
        super().__init__(**kwargs)
        self.connectivity_state = connectivity_state


class Location(_serialization.Model):
    """Describes an Azure resource with location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    """

    _validation = {
        "location": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location: Optional[str] = None


class ExternalSecuritySolutionKind(_serialization.Model):
    """Describes an Azure resource with kind.

    :ivar kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
    :vartype kind: str or ~azure.mgmt.security.models.ExternalSecuritySolutionKindEnum
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(
        self, *, kind: Optional[Union[str, "_models.ExternalSecuritySolutionKindEnum"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
        :paramtype kind: str or ~azure.mgmt.security.models.ExternalSecuritySolutionKindEnum
        """
        super().__init__(**kwargs)
        self.kind = kind


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class ExternalSecuritySolution(Resource, ExternalSecuritySolutionKind, Location):
    """Represents a security solution external to Microsoft Defender for Cloud which sends information
    to an OMS workspace and whose data is displayed by Microsoft Defender for Cloud.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
    :vartype kind: str or ~azure.mgmt.security.models.ExternalSecuritySolutionKindEnum
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, kind: Optional[Union[str, "_models.ExternalSecuritySolutionKindEnum"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
        :paramtype kind: str or ~azure.mgmt.security.models.ExternalSecuritySolutionKindEnum
        """
        super().__init__(kind=kind, **kwargs)
        self.location: Optional[str] = None
        self.kind = kind
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class AadExternalSecuritySolution(ExternalSecuritySolution):
    """Represents an AAD identity protection solution which sends logs to an OMS workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
    :vartype kind: str or ~azure.mgmt.security.models.ExternalSecuritySolutionKindEnum
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The external security solution properties for AAD solutions.
    :vartype properties: ~azure.mgmt.security.models.AadSolutionProperties
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "AadSolutionProperties"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.ExternalSecuritySolutionKindEnum"]] = None,
        properties: Optional["_models.AadSolutionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
        :paramtype kind: str or ~azure.mgmt.security.models.ExternalSecuritySolutionKindEnum
        :keyword properties: The external security solution properties for AAD solutions.
        :paramtype properties: ~azure.mgmt.security.models.AadSolutionProperties
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class ExternalSecuritySolutionProperties(_serialization.Model):
    """The solution properties (correspond to the solution kind).

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar device_vendor:
    :vartype device_vendor: str
    :ivar device_type:
    :vartype device_type: str
    :ivar workspace: Represents an OMS workspace to which the solution is connected.
    :vartype workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "workspace": {"key": "workspace", "type": "ConnectedWorkspace"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        device_vendor: Optional[str] = None,
        device_type: Optional[str] = None,
        workspace: Optional["_models.ConnectedWorkspace"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword device_vendor:
        :paramtype device_vendor: str
        :keyword device_type:
        :paramtype device_type: str
        :keyword workspace: Represents an OMS workspace to which the solution is connected.
        :paramtype workspace: ~azure.mgmt.security.models.ConnectedWorkspace
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.device_vendor = device_vendor
        self.device_type = device_type
        self.workspace = workspace


class AadSolutionProperties(ExternalSecuritySolutionProperties, AadConnectivityState):
    """The external security solution properties for AAD solutions.

    :ivar connectivity_state: The connectivity state of the external AAD solution. Known values
     are: "Discovered", "NotLicensed", and "Connected".
    :vartype connectivity_state: str or ~azure.mgmt.security.models.AadConnectivityStateEnum
    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar device_vendor:
    :vartype device_vendor: str
    :ivar device_type:
    :vartype device_type: str
    :ivar workspace: Represents an OMS workspace to which the solution is connected.
    :vartype workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    """

    _attribute_map = {
        "connectivity_state": {"key": "connectivityState", "type": "str"},
        "additional_properties": {"key": "", "type": "{object}"},
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "workspace": {"key": "workspace", "type": "ConnectedWorkspace"},
    }

    def __init__(
        self,
        *,
        connectivity_state: Optional[Union[str, "_models.AadConnectivityStateEnum"]] = None,
        additional_properties: Optional[Dict[str, Any]] = None,
        device_vendor: Optional[str] = None,
        device_type: Optional[str] = None,
        workspace: Optional["_models.ConnectedWorkspace"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword connectivity_state: The connectivity state of the external AAD solution. Known values
         are: "Discovered", "NotLicensed", and "Connected".
        :paramtype connectivity_state: str or ~azure.mgmt.security.models.AadConnectivityStateEnum
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword device_vendor:
        :paramtype device_vendor: str
        :keyword device_type:
        :paramtype device_type: str
        :keyword workspace: Represents an OMS workspace to which the solution is connected.
        :paramtype workspace: ~azure.mgmt.security.models.ConnectedWorkspace
        """
        super().__init__(
            additional_properties=additional_properties,
            device_vendor=device_vendor,
            device_type=device_type,
            workspace=workspace,
            connectivity_state=connectivity_state,
            **kwargs
        )
        self.connectivity_state = connectivity_state
        self.additional_properties = additional_properties
        self.device_vendor = device_vendor
        self.device_type = device_type
        self.workspace = workspace


class Authentication(_serialization.Model):
    """The environment authentication details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AccessTokenAuthentication

    All required parameters must be populated in order to send to server.

    :ivar authentication_type: The authentication type. Required. Known values are: "awsCreds",
     "awsAssumeRole", and "gcpCredentials".
    :vartype authentication_type: str or ~azure.mgmt.security.models.AuthenticationType
    """

    _validation = {
        "authentication_type": {"required": True},
    }

    _attribute_map = {
        "authentication_type": {"key": "authenticationType", "type": "str"},
    }

    _subtype_map = {"authentication_type": {"AccessToken": "AccessTokenAuthentication"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.authentication_type: Optional[str] = None


class AccessTokenAuthentication(Authentication):
    """The environment authentication details.

    All required parameters must be populated in order to send to server.

    :ivar authentication_type: The authentication type. Required. Known values are: "awsCreds",
     "awsAssumeRole", and "gcpCredentials".
    :vartype authentication_type: str or ~azure.mgmt.security.models.AuthenticationType
    :ivar username: The user name that will be used while authenticating with the onboarded
     environment.
    :vartype username: str
    :ivar access_token: The access token that will be used while authenticating with the onboarded
     environment.
    :vartype access_token: str
    """

    _validation = {
        "authentication_type": {"required": True},
    }

    _attribute_map = {
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "access_token": {"key": "accessToken", "type": "str"},
    }

    def __init__(self, *, username: Optional[str] = None, access_token: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: The user name that will be used while authenticating with the onboarded
         environment.
        :paramtype username: str
        :keyword access_token: The access token that will be used while authenticating with the
         onboarded environment.
        :paramtype access_token: str
        """
        super().__init__(**kwargs)
        self.authentication_type: str = "AccessToken"
        self.username = username
        self.access_token = access_token


class ActionableRemediation(_serialization.Model):
    """Configuration payload for PR Annotations.

    :ivar state: ActionableRemediation Setting.
     None - the setting was never set.
     Enabled - ActionableRemediation is enabled.
     Disabled - ActionableRemediation is disabled. Known values are: "None", "Disabled", and
     "Enabled".
    :vartype state: str or ~azure.mgmt.security.models.ActionableRemediationState
    :ivar category_configurations: Gets or sets list of categories and severity levels.
    :vartype category_configurations: list[~azure.mgmt.security.models.CategoryConfiguration]
    :ivar branch_configuration: Repository branch configuration for PR Annotations.
    :vartype branch_configuration: ~azure.mgmt.security.models.TargetBranchConfiguration
    :ivar inherit_from_parent_state: Update Settings.

     Enabled - Resource should inherit configurations from parent.
     Disabled - Resource should not inherit configurations from parent. Known values are: "Disabled"
     and "Enabled".
    :vartype inherit_from_parent_state: str or ~azure.mgmt.security.models.InheritFromParentState
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "category_configurations": {"key": "categoryConfigurations", "type": "[CategoryConfiguration]"},
        "branch_configuration": {"key": "branchConfiguration", "type": "TargetBranchConfiguration"},
        "inherit_from_parent_state": {"key": "inheritFromParentState", "type": "str"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.ActionableRemediationState"]] = None,
        category_configurations: Optional[List["_models.CategoryConfiguration"]] = None,
        branch_configuration: Optional["_models.TargetBranchConfiguration"] = None,
        inherit_from_parent_state: Optional[Union[str, "_models.InheritFromParentState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: ActionableRemediation Setting.
         None - the setting was never set.
         Enabled - ActionableRemediation is enabled.
         Disabled - ActionableRemediation is disabled. Known values are: "None", "Disabled", and
         "Enabled".
        :paramtype state: str or ~azure.mgmt.security.models.ActionableRemediationState
        :keyword category_configurations: Gets or sets list of categories and severity levels.
        :paramtype category_configurations: list[~azure.mgmt.security.models.CategoryConfiguration]
        :keyword branch_configuration: Repository branch configuration for PR Annotations.
        :paramtype branch_configuration: ~azure.mgmt.security.models.TargetBranchConfiguration
        :keyword inherit_from_parent_state: Update Settings.

         Enabled - Resource should inherit configurations from parent.
         Disabled - Resource should not inherit configurations from parent. Known values are: "Disabled"
         and "Enabled".
        :paramtype inherit_from_parent_state: str or ~azure.mgmt.security.models.InheritFromParentState
        """
        super().__init__(**kwargs)
        self.state = state
        self.category_configurations = category_configurations
        self.branch_configuration = branch_configuration
        self.inherit_from_parent_state = inherit_from_parent_state


class CustomAlertRule(_serialization.Model):
    """A custom alert rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ListCustomAlertRule, ThresholdCustomAlertRule

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
    }

    _subtype_map = {
        "rule_type": {
            "ListCustomAlertRule": "ListCustomAlertRule",
            "ThresholdCustomAlertRule": "ThresholdCustomAlertRule",
        }
    }

    def __init__(self, *, is_enabled: bool, **kwargs: Any) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        """
        super().__init__(**kwargs)
        self.display_name: Optional[str] = None
        self.description: Optional[str] = None
        self.is_enabled = is_enabled
        self.rule_type: Optional[str] = None


class ThresholdCustomAlertRule(CustomAlertRule):
    """A custom alert rule that checks if a value (depends on the custom alert type) is within the
    given range.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    TimeWindowCustomAlertRule

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
    }

    _subtype_map = {"rule_type": {"TimeWindowCustomAlertRule": "TimeWindowCustomAlertRule"}}

    def __init__(self, *, is_enabled: bool, min_threshold: int, max_threshold: int, **kwargs: Any) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.rule_type: str = "ThresholdCustomAlertRule"
        self.min_threshold = min_threshold
        self.max_threshold = max_threshold


class TimeWindowCustomAlertRule(ThresholdCustomAlertRule):
    """A custom alert rule that checks if the number of activities (depends on the custom alert type)
    in a time window is within the given range.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ActiveConnectionsNotInAllowedRange, AmqpC2DMessagesNotInAllowedRange,
    AmqpC2DRejectedMessagesNotInAllowedRange, AmqpD2CMessagesNotInAllowedRange,
    DirectMethodInvokesNotInAllowedRange, FailedLocalLoginsNotInAllowedRange,
    FileUploadsNotInAllowedRange, HttpC2DMessagesNotInAllowedRange,
    HttpC2DRejectedMessagesNotInAllowedRange, HttpD2CMessagesNotInAllowedRange,
    MqttC2DMessagesNotInAllowedRange, MqttC2DRejectedMessagesNotInAllowedRange,
    MqttD2CMessagesNotInAllowedRange, QueuePurgesNotInAllowedRange, TwinUpdatesNotInAllowedRange,
    UnauthorizedOperationsNotInAllowedRange

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    _subtype_map = {
        "rule_type": {
            "ActiveConnectionsNotInAllowedRange": "ActiveConnectionsNotInAllowedRange",
            "AmqpC2DMessagesNotInAllowedRange": "AmqpC2DMessagesNotInAllowedRange",
            "AmqpC2DRejectedMessagesNotInAllowedRange": "AmqpC2DRejectedMessagesNotInAllowedRange",
            "AmqpD2CMessagesNotInAllowedRange": "AmqpD2CMessagesNotInAllowedRange",
            "DirectMethodInvokesNotInAllowedRange": "DirectMethodInvokesNotInAllowedRange",
            "FailedLocalLoginsNotInAllowedRange": "FailedLocalLoginsNotInAllowedRange",
            "FileUploadsNotInAllowedRange": "FileUploadsNotInAllowedRange",
            "HttpC2DMessagesNotInAllowedRange": "HttpC2DMessagesNotInAllowedRange",
            "HttpC2DRejectedMessagesNotInAllowedRange": "HttpC2DRejectedMessagesNotInAllowedRange",
            "HttpD2CMessagesNotInAllowedRange": "HttpD2CMessagesNotInAllowedRange",
            "MqttC2DMessagesNotInAllowedRange": "MqttC2DMessagesNotInAllowedRange",
            "MqttC2DRejectedMessagesNotInAllowedRange": "MqttC2DRejectedMessagesNotInAllowedRange",
            "MqttD2CMessagesNotInAllowedRange": "MqttD2CMessagesNotInAllowedRange",
            "QueuePurgesNotInAllowedRange": "QueuePurgesNotInAllowedRange",
            "TwinUpdatesNotInAllowedRange": "TwinUpdatesNotInAllowedRange",
            "UnauthorizedOperationsNotInAllowedRange": "UnauthorizedOperationsNotInAllowedRange",
        }
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(is_enabled=is_enabled, min_threshold=min_threshold, max_threshold=max_threshold, **kwargs)
        self.rule_type: str = "TimeWindowCustomAlertRule"
        self.time_window_size = time_window_size


class ActiveConnectionsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of active connections is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "ActiveConnectionsNotInAllowedRange"


class AdditionalData(_serialization.Model):
    """Details of the sub-assessment.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContainerRegistryVulnerabilityProperties, ServerVulnerabilityProperties,
    SqlServerVulnerabilityProperties

    All required parameters must be populated in order to send to server.

    :ivar assessed_resource_type: Sub-assessment resource type. Required. Known values are:
     "SqlServerVulnerability", "ContainerRegistryVulnerability", and "ServerVulnerability".
    :vartype assessed_resource_type: str or ~azure.mgmt.security.models.AssessedResourceType
    """

    _validation = {
        "assessed_resource_type": {"required": True},
    }

    _attribute_map = {
        "assessed_resource_type": {"key": "assessedResourceType", "type": "str"},
    }

    _subtype_map = {
        "assessed_resource_type": {
            "ContainerRegistryVulnerability": "ContainerRegistryVulnerabilityProperties",
            "ServerVulnerabilityAssessment": "ServerVulnerabilityProperties",
            "SqlServerVulnerability": "SqlServerVulnerabilityProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessed_resource_type: Optional[str] = None


class AdditionalWorkspacesProperties(_serialization.Model):
    """Properties of the additional workspaces.

    :ivar workspace: Workspace resource id.
    :vartype workspace: str
    :ivar type: Workspace type. "Sentinel"
    :vartype type: str or ~azure.mgmt.security.models.AdditionalWorkspaceType
    :ivar data_types: List of data types sent to workspace.
    :vartype data_types: list[str or ~azure.mgmt.security.models.AdditionalWorkspaceDataType]
    """

    _attribute_map = {
        "workspace": {"key": "workspace", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        workspace: Optional[str] = None,
        type: Union[str, "_models.AdditionalWorkspaceType"] = "Sentinel",
        data_types: Optional[List[Union[str, "_models.AdditionalWorkspaceDataType"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword workspace: Workspace resource id.
        :paramtype workspace: str
        :keyword type: Workspace type. "Sentinel"
        :paramtype type: str or ~azure.mgmt.security.models.AdditionalWorkspaceType
        :keyword data_types: List of data types sent to workspace.
        :paramtype data_types: list[str or ~azure.mgmt.security.models.AdditionalWorkspaceDataType]
        """
        super().__init__(**kwargs)
        self.workspace = workspace
        self.type = type
        self.data_types = data_types


class AdvancedThreatProtectionSetting(Resource):
    """The Advanced Threat Protection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_enabled: Indicates whether Advanced Threat Protection is enabled.
    :vartype is_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
    }

    def __init__(self, *, is_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_enabled: Indicates whether Advanced Threat Protection is enabled.
        :paramtype is_enabled: bool
        """
        super().__init__(**kwargs)
        self.is_enabled = is_enabled


class AgentlessConfiguration(_serialization.Model):
    """Details about Agentless configuration.

    :ivar agentless_enabled: Agentless Enablement states. Known values are: "Disabled", "Enabled",
     and "NotApplicable".
    :vartype agentless_enabled: str or ~azure.mgmt.security.models.AgentlessEnablement
    :ivar agentless_auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled",
     and "NotApplicable".
    :vartype agentless_auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
    :ivar scanners: Gets or sets the scanners for the connector.
    :vartype scanners: list[str]
    :ivar inventory_list_type: Types for inventory list. Known values are: "Inclusion" and
     "Exclusion".
    :vartype inventory_list_type: str or ~azure.mgmt.security.models.InventoryListKind
    :ivar inventory_list: Gets or sets the inventory list for inclusion or exclusion from
     Agentless.
     Will be ignored if agentless auto-discovery is enabled.
    :vartype inventory_list: list[~azure.mgmt.security.models.InventoryList]
    """

    _attribute_map = {
        "agentless_enabled": {"key": "agentlessEnabled", "type": "str"},
        "agentless_auto_discovery": {"key": "agentlessAutoDiscovery", "type": "str"},
        "scanners": {"key": "scanners", "type": "[str]"},
        "inventory_list_type": {"key": "inventoryListType", "type": "str"},
        "inventory_list": {"key": "inventoryList", "type": "[InventoryList]"},
    }

    def __init__(
        self,
        *,
        agentless_enabled: Optional[Union[str, "_models.AgentlessEnablement"]] = None,
        agentless_auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        scanners: Optional[List[str]] = None,
        inventory_list_type: Optional[Union[str, "_models.InventoryListKind"]] = None,
        inventory_list: Optional[List["_models.InventoryList"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword agentless_enabled: Agentless Enablement states. Known values are: "Disabled",
         "Enabled", and "NotApplicable".
        :paramtype agentless_enabled: str or ~azure.mgmt.security.models.AgentlessEnablement
        :keyword agentless_auto_discovery: AutoDiscovery states. Known values are: "Disabled",
         "Enabled", and "NotApplicable".
        :paramtype agentless_auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
        :keyword scanners: Gets or sets the scanners for the connector.
        :paramtype scanners: list[str]
        :keyword inventory_list_type: Types for inventory list. Known values are: "Inclusion" and
         "Exclusion".
        :paramtype inventory_list_type: str or ~azure.mgmt.security.models.InventoryListKind
        :keyword inventory_list: Gets or sets the inventory list for inclusion or exclusion from
         Agentless.
         Will be ignored if agentless auto-discovery is enabled.
        :paramtype inventory_list: list[~azure.mgmt.security.models.InventoryList]
        """
        super().__init__(**kwargs)
        self.agentless_enabled = agentless_enabled
        self.agentless_auto_discovery = agentless_auto_discovery
        self.scanners = scanners
        self.inventory_list_type = inventory_list_type
        self.inventory_list = inventory_list


class Alert(Resource):
    """Security alert.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar version: Schema version.
    :vartype version: str
    :ivar alert_type: Unique identifier for the detection logic (all alert instances from the same
     detection logic will have the same alertType).
    :vartype alert_type: str
    :ivar system_alert_id: Unique identifier for the alert.
    :vartype system_alert_id: str
    :ivar product_component_name: The name of Azure Security Center pricing tier which powering
     this alert. Learn more:
     https://docs.microsoft.com/en-us/azure/security-center/security-center-pricing.
    :vartype product_component_name: str
    :ivar alert_display_name: The display name of the alert.
    :vartype alert_display_name: str
    :ivar description: Description of the suspicious activity that was detected.
    :vartype description: str
    :ivar severity: The risk level of the threat that was detected. Learn more:
     https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified.
     Known values are: "Informational", "Low", "Medium", and "High".
    :vartype severity: str or ~azure.mgmt.security.models.AlertSeverity
    :ivar intent: The kill chain related intent behind the alert. For list of supported values, and
     explanations of Azure Security Center's supported kill chain intents. Known values are:
     "Unknown", "PreAttack", "InitialAccess", "Persistence", "PrivilegeEscalation",
     "DefenseEvasion", "CredentialAccess", "Discovery", "LateralMovement", "Execution",
     "Collection", "Exfiltration", "CommandAndControl", "Impact", "Probing", and "Exploitation".
    :vartype intent: str or ~azure.mgmt.security.models.Intent
    :ivar start_time_utc: The UTC time of the first event or activity included in the alert in
     ISO8601 format.
    :vartype start_time_utc: ~datetime.datetime
    :ivar end_time_utc: The UTC time of the last event or activity included in the alert in ISO8601
     format.
    :vartype end_time_utc: ~datetime.datetime
    :ivar resource_identifiers: The resource identifiers that can be used to direct the alert to
     the right product exposure group (tenant, workspace, subscription etc.). There can be multiple
     identifiers of different type per alert.
    :vartype resource_identifiers: list[~azure.mgmt.security.models.ResourceIdentifier]
    :ivar remediation_steps: Manual action items to take to remediate the alert.
    :vartype remediation_steps: list[str]
    :ivar vendor_name: The name of the vendor that raises the alert.
    :vartype vendor_name: str
    :ivar status: The life cycle status of the alert. Known values are: "Active", "InProgress",
     "Resolved", and "Dismissed".
    :vartype status: str or ~azure.mgmt.security.models.AlertStatus
    :ivar extended_links: Links related to the alert.
    :vartype extended_links: list[dict[str, str]]
    :ivar alert_uri: A direct link to the alert page in Azure Portal.
    :vartype alert_uri: str
    :ivar time_generated_utc: The UTC time the alert was generated in ISO8601 format.
    :vartype time_generated_utc: ~datetime.datetime
    :ivar product_name: The name of the product which published this alert (Microsoft Sentinel,
     Microsoft Defender for Identity, Microsoft Defender for Endpoint, Microsoft Defender for
     Office, Microsoft Defender for Cloud Apps, and so on).
    :vartype product_name: str
    :ivar processing_end_time_utc: The UTC processing end time of the alert in ISO8601 format.
    :vartype processing_end_time_utc: ~datetime.datetime
    :ivar entities: A list of entities related to the alert.
    :vartype entities: list[~azure.mgmt.security.models.AlertEntity]
    :ivar is_incident: This field determines whether the alert is an incident (a compound grouping
     of several alerts) or a single alert.
    :vartype is_incident: bool
    :ivar correlation_key: Key for corelating related alerts. Alerts with the same correlation key
     considered to be related.
    :vartype correlation_key: str
    :ivar extended_properties: Custom properties for the alert.
    :vartype extended_properties: dict[str, str]
    :ivar compromised_entity: The display name of the resource most related to this alert.
    :vartype compromised_entity: str
    :ivar techniques: kill chain related techniques behind the alert.
    :vartype techniques: list[str]
    :ivar sub_techniques: Kill chain related sub-techniques behind the alert.
    :vartype sub_techniques: list[str]
    :ivar supporting_evidence: Changing set of properties depending on the supportingEvidence type.
    :vartype supporting_evidence: ~azure.mgmt.security.models.AlertPropertiesSupportingEvidence
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "version": {"readonly": True},
        "alert_type": {"readonly": True},
        "system_alert_id": {"readonly": True},
        "product_component_name": {"readonly": True},
        "alert_display_name": {"readonly": True},
        "description": {"readonly": True},
        "severity": {"readonly": True},
        "intent": {"readonly": True},
        "start_time_utc": {"readonly": True},
        "end_time_utc": {"readonly": True},
        "resource_identifiers": {"readonly": True},
        "remediation_steps": {"readonly": True},
        "vendor_name": {"readonly": True},
        "status": {"readonly": True},
        "extended_links": {"readonly": True},
        "alert_uri": {"readonly": True},
        "time_generated_utc": {"readonly": True},
        "product_name": {"readonly": True},
        "processing_end_time_utc": {"readonly": True},
        "entities": {"readonly": True},
        "is_incident": {"readonly": True},
        "correlation_key": {"readonly": True},
        "compromised_entity": {"readonly": True},
        "techniques": {"readonly": True},
        "sub_techniques": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "alert_type": {"key": "properties.alertType", "type": "str"},
        "system_alert_id": {"key": "properties.systemAlertId", "type": "str"},
        "product_component_name": {"key": "properties.productComponentName", "type": "str"},
        "alert_display_name": {"key": "properties.alertDisplayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "intent": {"key": "properties.intent", "type": "str"},
        "start_time_utc": {"key": "properties.startTimeUtc", "type": "iso-8601"},
        "end_time_utc": {"key": "properties.endTimeUtc", "type": "iso-8601"},
        "resource_identifiers": {"key": "properties.resourceIdentifiers", "type": "[ResourceIdentifier]"},
        "remediation_steps": {"key": "properties.remediationSteps", "type": "[str]"},
        "vendor_name": {"key": "properties.vendorName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "extended_links": {"key": "properties.extendedLinks", "type": "[{str}]"},
        "alert_uri": {"key": "properties.alertUri", "type": "str"},
        "time_generated_utc": {"key": "properties.timeGeneratedUtc", "type": "iso-8601"},
        "product_name": {"key": "properties.productName", "type": "str"},
        "processing_end_time_utc": {"key": "properties.processingEndTimeUtc", "type": "iso-8601"},
        "entities": {"key": "properties.entities", "type": "[AlertEntity]"},
        "is_incident": {"key": "properties.isIncident", "type": "bool"},
        "correlation_key": {"key": "properties.correlationKey", "type": "str"},
        "extended_properties": {"key": "properties.extendedProperties", "type": "{str}"},
        "compromised_entity": {"key": "properties.compromisedEntity", "type": "str"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
        "sub_techniques": {"key": "properties.subTechniques", "type": "[str]"},
        "supporting_evidence": {"key": "properties.supportingEvidence", "type": "AlertPropertiesSupportingEvidence"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        extended_properties: Optional[Dict[str, str]] = None,
        supporting_evidence: Optional["_models.AlertPropertiesSupportingEvidence"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_properties: Custom properties for the alert.
        :paramtype extended_properties: dict[str, str]
        :keyword supporting_evidence: Changing set of properties depending on the supportingEvidence
         type.
        :paramtype supporting_evidence: ~azure.mgmt.security.models.AlertPropertiesSupportingEvidence
        """
        super().__init__(**kwargs)
        self.version: Optional[str] = None
        self.alert_type: Optional[str] = None
        self.system_alert_id: Optional[str] = None
        self.product_component_name: Optional[str] = None
        self.alert_display_name: Optional[str] = None
        self.description: Optional[str] = None
        self.severity: Optional[Union[str, "_models.AlertSeverity"]] = None
        self.intent: Optional[Union[str, "_models.Intent"]] = None
        self.start_time_utc: Optional[datetime.datetime] = None
        self.end_time_utc: Optional[datetime.datetime] = None
        self.resource_identifiers: Optional[List["_models.ResourceIdentifier"]] = None
        self.remediation_steps: Optional[List[str]] = None
        self.vendor_name: Optional[str] = None
        self.status: Optional[Union[str, "_models.AlertStatus"]] = None
        self.extended_links: Optional[List[Dict[str, str]]] = None
        self.alert_uri: Optional[str] = None
        self.time_generated_utc: Optional[datetime.datetime] = None
        self.product_name: Optional[str] = None
        self.processing_end_time_utc: Optional[datetime.datetime] = None
        self.entities: Optional[List["_models.AlertEntity"]] = None
        self.is_incident: Optional[bool] = None
        self.correlation_key: Optional[str] = None
        self.extended_properties = extended_properties
        self.compromised_entity: Optional[str] = None
        self.techniques: Optional[List[str]] = None
        self.sub_techniques: Optional[List[str]] = None
        self.supporting_evidence = supporting_evidence


class AlertEntity(_serialization.Model):
    """Changing set of properties depending on the entity type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of entity.
    :vartype type: str
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, JSON]] = None, **kwargs: Any) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type: Optional[str] = None


class AlertList(_serialization.Model):
    """List of security alerts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: describes security alert properties.
    :vartype value: list[~azure.mgmt.security.models.Alert]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Alert]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Alert"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: describes security alert properties.
        :paramtype value: list[~azure.mgmt.security.models.Alert]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AlertPropertiesSupportingEvidence(_serialization.Model):
    """Changing set of properties depending on the supportingEvidence type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar type: Type of the supportingEvidence.
    :vartype type: str
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, JSON]] = None, **kwargs: Any) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type: Optional[str] = None


class AlertSimulatorRequestProperties(_serialization.Model):
    """Describes properties of an alert simulation request.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AlertSimulatorBundlesRequestProperties

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar kind: The kind of alert simulation. Required. "Bundles"
    :vartype kind: str or ~azure.mgmt.security.models.KindEnum
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Bundles": "AlertSimulatorBundlesRequestProperties"}}

    def __init__(self, *, additional_properties: Optional[Dict[str, Any]] = None, **kwargs: Any) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.kind: Optional[str] = None


class AlertSimulatorBundlesRequestProperties(AlertSimulatorRequestProperties):
    """Simulate alerts according to this bundles.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar kind: The kind of alert simulation. Required. "Bundles"
    :vartype kind: str or ~azure.mgmt.security.models.KindEnum
    :ivar bundles: Bundles list.
    :vartype bundles: list[str or ~azure.mgmt.security.models.BundleType]
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "kind": {"key": "kind", "type": "str"},
        "bundles": {"key": "bundles", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        bundles: Optional[List[Union[str, "_models.BundleType"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword bundles: Bundles list.
        :paramtype bundles: list[str or ~azure.mgmt.security.models.BundleType]
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.kind: str = "Bundles"
        self.bundles = bundles


class AlertSimulatorRequestBody(_serialization.Model):
    """Alert Simulator request body.

    :ivar properties: Alert Simulator request body data.
    :vartype properties: ~azure.mgmt.security.models.AlertSimulatorRequestProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "AlertSimulatorRequestProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AlertSimulatorRequestProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Alert Simulator request body data.
        :paramtype properties: ~azure.mgmt.security.models.AlertSimulatorRequestProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AlertsSuppressionRule(Resource):
    """Describes the suppression rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar alert_type: Type of the alert to automatically suppress. For all alert types, use '*'.
    :vartype alert_type: str
    :ivar last_modified_utc: The last time this rule was modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar expiration_date_utc: Expiration date of the rule, if value is not provided or provided as
     null there will no expiration at all.
    :vartype expiration_date_utc: ~datetime.datetime
    :ivar reason: The reason for dismissing the alert.
    :vartype reason: str
    :ivar state: Possible states of the rule. Known values are: "Enabled", "Disabled", and
     "Expired".
    :vartype state: str or ~azure.mgmt.security.models.RuleState
    :ivar comment: Any comment regarding the rule.
    :vartype comment: str
    :ivar suppression_alerts_scope: The suppression conditions.
    :vartype suppression_alerts_scope: ~azure.mgmt.security.models.SuppressionAlertsScope
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_modified_utc": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "alert_type": {"key": "properties.alertType", "type": "str"},
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
        "expiration_date_utc": {"key": "properties.expirationDateUtc", "type": "iso-8601"},
        "reason": {"key": "properties.reason", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "comment": {"key": "properties.comment", "type": "str"},
        "suppression_alerts_scope": {"key": "properties.suppressionAlertsScope", "type": "SuppressionAlertsScope"},
    }

    def __init__(
        self,
        *,
        alert_type: Optional[str] = None,
        expiration_date_utc: Optional[datetime.datetime] = None,
        reason: Optional[str] = None,
        state: Optional[Union[str, "_models.RuleState"]] = None,
        comment: Optional[str] = None,
        suppression_alerts_scope: Optional["_models.SuppressionAlertsScope"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword alert_type: Type of the alert to automatically suppress. For all alert types, use '*'.
        :paramtype alert_type: str
        :keyword expiration_date_utc: Expiration date of the rule, if value is not provided or provided
         as null there will no expiration at all.
        :paramtype expiration_date_utc: ~datetime.datetime
        :keyword reason: The reason for dismissing the alert.
        :paramtype reason: str
        :keyword state: Possible states of the rule. Known values are: "Enabled", "Disabled", and
         "Expired".
        :paramtype state: str or ~azure.mgmt.security.models.RuleState
        :keyword comment: Any comment regarding the rule.
        :paramtype comment: str
        :keyword suppression_alerts_scope: The suppression conditions.
        :paramtype suppression_alerts_scope: ~azure.mgmt.security.models.SuppressionAlertsScope
        """
        super().__init__(**kwargs)
        self.alert_type = alert_type
        self.last_modified_utc: Optional[datetime.datetime] = None
        self.expiration_date_utc = expiration_date_utc
        self.reason = reason
        self.state = state
        self.comment = comment
        self.suppression_alerts_scope = suppression_alerts_scope


class AlertsSuppressionRulesList(_serialization.Model):
    """Suppression rules list for subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.security.models.AlertsSuppressionRule]
    :ivar next_link: URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AlertsSuppressionRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AlertsSuppressionRule"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.security.models.AlertsSuppressionRule]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class Setting(Resource):
    """The kind of the security setting.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AlertSyncSettings, DataExportSettings

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: the kind of the settings string. Required. Known values are: "DataExportSettings",
     "AlertSuppressionSetting", and "AlertSyncSettings".
    :vartype kind: str or ~azure.mgmt.security.models.SettingKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"AlertSyncSettings": "AlertSyncSettings", "DataExportSettings": "DataExportSettings"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class AlertSyncSettings(Setting):
    """Represents an alert sync setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: the kind of the settings string. Required. Known values are: "DataExportSettings",
     "AlertSuppressionSetting", and "AlertSyncSettings".
    :vartype kind: str or ~azure.mgmt.security.models.SettingKind
    :ivar enabled: Is the alert sync setting enabled.
    :vartype enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is the alert sync setting enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.kind: str = "AlertSyncSettings"
        self.enabled = enabled


class AllowedConnectionsList(_serialization.Model):
    """List of all possible traffic between Azure resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.AllowedConnectionsResource]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AllowedConnectionsResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.AllowedConnectionsResource"]] = None
        self.next_link: Optional[str] = None


class AllowedConnectionsResource(Resource, Location):
    """The resource whose properties describes the allowed traffic between Azure resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar calculated_date_time: The UTC time on which the allowed connections resource was
     calculated.
    :vartype calculated_date_time: ~datetime.datetime
    :ivar connectable_resources: List of connectable resources.
    :vartype connectable_resources: list[~azure.mgmt.security.models.ConnectableResource]
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "calculated_date_time": {"readonly": True},
        "connectable_resources": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "calculated_date_time": {"key": "properties.calculatedDateTime", "type": "iso-8601"},
        "connectable_resources": {"key": "properties.connectableResources", "type": "[ConnectableResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.calculated_date_time: Optional[datetime.datetime] = None
        self.connectable_resources: Optional[List["_models.ConnectableResource"]] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class ListCustomAlertRule(CustomAlertRule):
    """A List custom alert rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AllowlistCustomAlertRule, DenylistCustomAlertRule

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
    }

    _subtype_map = {
        "rule_type": {
            "AllowlistCustomAlertRule": "AllowlistCustomAlertRule",
            "DenylistCustomAlertRule": "DenylistCustomAlertRule",
        }
    }

    def __init__(self, *, is_enabled: bool, **kwargs: Any) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.rule_type: str = "ListCustomAlertRule"
        self.value_type: Optional[Union[str, "_models.ValueType"]] = None


class AllowlistCustomAlertRule(ListCustomAlertRule):
    """A custom alert rule that checks if a value (depends on the custom alert type) is allowed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConnectionFromIpNotAllowed, ConnectionToIpNotAllowed, LocalUserNotAllowed, ProcessNotAllowed

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :ivar allowlist_values: The values to allow. The format of the values depends on the rule type.
     Required.
    :vartype allowlist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "allowlist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "allowlist_values": {"key": "allowlistValues", "type": "[str]"},
    }

    _subtype_map = {
        "rule_type": {
            "ConnectionFromIpNotAllowed": "ConnectionFromIpNotAllowed",
            "ConnectionToIpNotAllowed": "ConnectionToIpNotAllowed",
            "LocalUserNotAllowed": "LocalUserNotAllowed",
            "ProcessNotAllowed": "ProcessNotAllowed",
        }
    }

    def __init__(self, *, is_enabled: bool, allowlist_values: List[str], **kwargs: Any) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword allowlist_values: The values to allow. The format of the values depends on the rule
         type. Required.
        :paramtype allowlist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.rule_type: str = "AllowlistCustomAlertRule"
        self.allowlist_values = allowlist_values


class AmqpC2DMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of cloud to device messages (AMQP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "AmqpC2DMessagesNotInAllowedRange"


class AmqpC2DRejectedMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of rejected cloud to device messages (AMQP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "AmqpC2DRejectedMessagesNotInAllowedRange"


class AmqpD2CMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device to cloud messages (AMQP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "AmqpD2CMessagesNotInAllowedRange"


class ApiCollection(Resource):
    """An API collection as represented by Microsoft Defender for APIs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Gets the provisioning state of the API collection. Known values are:
     "Succeeded", "Failed", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.ProvisioningState
    :ivar display_name: The display name of the API collection.
    :vartype display_name: str
    :ivar discovered_via: The resource Id of the resource from where this API collection was
     discovered.
    :vartype discovered_via: str
    :ivar base_url: The base URI for this API collection. All endpoints of this API collection
     extend this base URI.
    :vartype base_url: str
    :ivar number_of_api_endpoints: The number of API endpoints discovered in this API collection.
    :vartype number_of_api_endpoints: int
    :ivar number_of_inactive_api_endpoints: The number of API endpoints in this API collection that
     have not received any API traffic in the last 30 days.
    :vartype number_of_inactive_api_endpoints: int
    :ivar number_of_unauthenticated_api_endpoints: The number of API endpoints in this API
     collection that are unauthenticated.
    :vartype number_of_unauthenticated_api_endpoints: int
    :ivar number_of_external_api_endpoints: The number of API endpoints in this API collection for
     which API traffic from the internet was observed.
    :vartype number_of_external_api_endpoints: int
    :ivar number_of_api_endpoints_with_sensitive_data_exposed: The number of API endpoints in this
     API collection which are exposing sensitive data in their requests and/or responses.
    :vartype number_of_api_endpoints_with_sensitive_data_exposed: int
    :ivar sensitivity_label: The highest priority sensitivity label from Microsoft Purview in this
     API collection.
    :vartype sensitivity_label: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "display_name": {"readonly": True},
        "discovered_via": {"readonly": True},
        "base_url": {"readonly": True},
        "number_of_api_endpoints": {"readonly": True},
        "number_of_inactive_api_endpoints": {"readonly": True},
        "number_of_unauthenticated_api_endpoints": {"readonly": True},
        "number_of_external_api_endpoints": {"readonly": True},
        "number_of_api_endpoints_with_sensitive_data_exposed": {"readonly": True},
        "sensitivity_label": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "discovered_via": {"key": "properties.discoveredVia", "type": "str"},
        "base_url": {"key": "properties.baseUrl", "type": "str"},
        "number_of_api_endpoints": {"key": "properties.numberOfApiEndpoints", "type": "int"},
        "number_of_inactive_api_endpoints": {"key": "properties.numberOfInactiveApiEndpoints", "type": "int"},
        "number_of_unauthenticated_api_endpoints": {
            "key": "properties.numberOfUnauthenticatedApiEndpoints",
            "type": "int",
        },
        "number_of_external_api_endpoints": {"key": "properties.numberOfExternalApiEndpoints", "type": "int"},
        "number_of_api_endpoints_with_sensitive_data_exposed": {
            "key": "properties.numberOfApiEndpointsWithSensitiveDataExposed",
            "type": "int",
        },
        "sensitivity_label": {"key": "properties.sensitivityLabel", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.display_name: Optional[str] = None
        self.discovered_via: Optional[str] = None
        self.base_url: Optional[str] = None
        self.number_of_api_endpoints: Optional[int] = None
        self.number_of_inactive_api_endpoints: Optional[int] = None
        self.number_of_unauthenticated_api_endpoints: Optional[int] = None
        self.number_of_external_api_endpoints: Optional[int] = None
        self.number_of_api_endpoints_with_sensitive_data_exposed: Optional[int] = None
        self.sensitivity_label: Optional[str] = None


class ApiCollectionList(_serialization.Model):
    """Page of a list of API collections as represented by Microsoft Defender for APIs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: API collections in this page.
    :vartype value: list[~azure.mgmt.security.models.ApiCollection]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ApiCollection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ApiCollection"]] = None
        self.next_link: Optional[str] = None


class Application(Resource):
    """Security Application over a given scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: display name of the application.
    :vartype display_name: str
    :ivar description: description of the application.
    :vartype description: str
    :ivar source_resource_type: The application source, what it affects, e.g. Assessments.
     "Assessments"
    :vartype source_resource_type: str or ~azure.mgmt.security.models.ApplicationSourceResourceType
    :ivar condition_sets: The application conditionSets - see examples.
    :vartype condition_sets: list[JSON]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "source_resource_type": {"key": "properties.sourceResourceType", "type": "str"},
        "condition_sets": {"key": "properties.conditionSets", "type": "[object]"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        source_resource_type: Optional[Union[str, "_models.ApplicationSourceResourceType"]] = None,
        condition_sets: Optional[List[JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: display name of the application.
        :paramtype display_name: str
        :keyword description: description of the application.
        :paramtype description: str
        :keyword source_resource_type: The application source, what it affects, e.g. Assessments.
         "Assessments"
        :paramtype source_resource_type: str or
         ~azure.mgmt.security.models.ApplicationSourceResourceType
        :keyword condition_sets: The application conditionSets - see examples.
        :paramtype condition_sets: list[JSON]
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.source_resource_type = source_resource_type
        self.condition_sets = condition_sets


class ApplicationCondition(_serialization.Model):
    """Application's condition.

    :ivar property: The application Condition's Property, e.g. ID, see examples.
    :vartype property: str
    :ivar value: The application Condition's Value like IDs that contain some string, see examples.
    :vartype value: str
    :ivar operator: The application Condition's Operator, for example Contains for id or In for
     list of possible IDs, see examples. Known values are: "Contains", "Equals", "In", and "In".
    :vartype operator: str or ~azure.mgmt.security.models.ApplicationConditionOperator
    """

    _attribute_map = {
        "property": {"key": "property", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
    }

    def __init__(
        self,
        *,
        property: Optional[str] = None,  # pylint: disable=redefined-builtin
        value: Optional[str] = None,
        operator: Optional[Union[str, "_models.ApplicationConditionOperator"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword property: The application Condition's Property, e.g. ID, see examples.
        :paramtype property: str
        :keyword value: The application Condition's Value like IDs that contain some string, see
         examples.
        :paramtype value: str
        :keyword operator: The application Condition's Operator, for example Contains for id or In for
         list of possible IDs, see examples. Known values are: "Contains", "Equals", "In", and "In".
        :paramtype operator: str or ~azure.mgmt.security.models.ApplicationConditionOperator
        """
        super().__init__(**kwargs)
        self.property = property
        self.value = value
        self.operator = operator


class ApplicationsList(_serialization.Model):
    """Page of a security applications list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of applications in this page.
    :vartype value: list[~azure.mgmt.security.models.Application]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Application]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Application"]] = None
        self.next_link: Optional[str] = None


class ArcAutoProvisioning(_serialization.Model):
    """The ARC autoprovisioning configuration.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for servers Arc auto provisioning for a given environment.
    :vartype configuration: ~azure.mgmt.security.models.ArcAutoProvisioningConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "ArcAutoProvisioningConfiguration"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.ArcAutoProvisioningConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is arc auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: Configuration for servers Arc auto provisioning for a given
         environment.
        :paramtype configuration: ~azure.mgmt.security.models.ArcAutoProvisioningConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class ArcAutoProvisioningAws(ArcAutoProvisioning):
    """The ARC autoprovisioning configuration for an AWS environment.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for servers Arc auto provisioning for a given environment.
    :vartype configuration: ~azure.mgmt.security.models.ArcAutoProvisioningConfiguration
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "ArcAutoProvisioningConfiguration"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.ArcAutoProvisioningConfiguration"] = None,
        cloud_role_arn: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is arc auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: Configuration for servers Arc auto provisioning for a given
         environment.
        :paramtype configuration: ~azure.mgmt.security.models.ArcAutoProvisioningConfiguration
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(enabled=enabled, configuration=configuration, **kwargs)
        self.cloud_role_arn = cloud_role_arn


class ArcAutoProvisioningConfiguration(_serialization.Model):
    """Configuration for servers Arc auto provisioning for a given environment.

    :ivar proxy: Optional HTTP proxy endpoint to use for the Arc agent.
    :vartype proxy: str
    :ivar private_link_scope: Optional Arc private link scope resource id to link the Arc agent.
    :vartype private_link_scope: str
    """

    _attribute_map = {
        "proxy": {"key": "proxy", "type": "str"},
        "private_link_scope": {"key": "privateLinkScope", "type": "str"},
    }

    def __init__(self, *, proxy: Optional[str] = None, private_link_scope: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword proxy: Optional HTTP proxy endpoint to use for the Arc agent.
        :paramtype proxy: str
        :keyword private_link_scope: Optional Arc private link scope resource id to link the Arc agent.
        :paramtype private_link_scope: str
        """
        super().__init__(**kwargs)
        self.proxy = proxy
        self.private_link_scope = private_link_scope


class ArcAutoProvisioningGcp(ArcAutoProvisioning):
    """The ARC autoprovisioning configuration for an GCP environment.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for servers Arc auto provisioning for a given environment.
    :vartype configuration: ~azure.mgmt.security.models.ArcAutoProvisioningConfiguration
    """


class AscLocation(Resource):
    """The ASC location of the subscription is in the "name" field.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: An empty set of properties.
    :vartype properties: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(self, *, properties: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword properties: An empty set of properties.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.properties = properties


class AscLocationList(_serialization.Model):
    """List of locations where ASC saves your data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.AscLocation]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AscLocation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.AscLocation"]] = None
        self.next_link: Optional[str] = None


class AssessmentLinks(_serialization.Model):
    """Links relevant to the assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar azure_portal_uri: Link to assessment in Azure Portal.
    :vartype azure_portal_uri: str
    """

    _validation = {
        "azure_portal_uri": {"readonly": True},
    }

    _attribute_map = {
        "azure_portal_uri": {"key": "azurePortalUri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.azure_portal_uri: Optional[str] = None


class AssessmentStatus(_serialization.Model):
    """The result of the assessment.

    All required parameters must be populated in order to send to server.

    :ivar code: Programmatic code for the status of the assessment. Required. Known values are:
     "Healthy", "Unhealthy", and "NotApplicable".
    :vartype code: str or ~azure.mgmt.security.models.AssessmentStatusCode
    :ivar cause: Programmatic code for the cause of the assessment status.
    :vartype cause: str
    :ivar description: Human readable description of the assessment status.
    :vartype description: str
    """

    _validation = {
        "code": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "cause": {"key": "cause", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.AssessmentStatusCode"],
        cause: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Programmatic code for the status of the assessment. Required. Known values are:
         "Healthy", "Unhealthy", and "NotApplicable".
        :paramtype code: str or ~azure.mgmt.security.models.AssessmentStatusCode
        :keyword cause: Programmatic code for the cause of the assessment status.
        :paramtype cause: str
        :keyword description: Human readable description of the assessment status.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.cause = cause
        self.description = description


class AssessmentStatusResponse(AssessmentStatus):
    """The result of the assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar code: Programmatic code for the status of the assessment. Required. Known values are:
     "Healthy", "Unhealthy", and "NotApplicable".
    :vartype code: str or ~azure.mgmt.security.models.AssessmentStatusCode
    :ivar cause: Programmatic code for the cause of the assessment status.
    :vartype cause: str
    :ivar description: Human readable description of the assessment status.
    :vartype description: str
    :ivar first_evaluation_date: The time that the assessment was created and first evaluated.
     Returned as UTC time in ISO 8601 format.
    :vartype first_evaluation_date: ~datetime.datetime
    :ivar status_change_date: The time that the status of the assessment last changed. Returned as
     UTC time in ISO 8601 format.
    :vartype status_change_date: ~datetime.datetime
    """

    _validation = {
        "code": {"required": True},
        "first_evaluation_date": {"readonly": True},
        "status_change_date": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "cause": {"key": "cause", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "first_evaluation_date": {"key": "firstEvaluationDate", "type": "iso-8601"},
        "status_change_date": {"key": "statusChangeDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.AssessmentStatusCode"],
        cause: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Programmatic code for the status of the assessment. Required. Known values are:
         "Healthy", "Unhealthy", and "NotApplicable".
        :paramtype code: str or ~azure.mgmt.security.models.AssessmentStatusCode
        :keyword cause: Programmatic code for the cause of the assessment status.
        :paramtype cause: str
        :keyword description: Human readable description of the assessment status.
        :paramtype description: str
        """
        super().__init__(code=code, cause=cause, description=description, **kwargs)
        self.first_evaluation_date: Optional[datetime.datetime] = None
        self.status_change_date: Optional[datetime.datetime] = None


class AssignedAssessmentItem(_serialization.Model):
    """Describe the properties of a security assessment object reference (by key).

    :ivar assessment_key: Unique key to a security assessment object.
    :vartype assessment_key: str
    """

    _attribute_map = {
        "assessment_key": {"key": "assessmentKey", "type": "str"},
    }

    def __init__(self, *, assessment_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword assessment_key: Unique key to a security assessment object.
        :paramtype assessment_key: str
        """
        super().__init__(**kwargs)
        self.assessment_key = assessment_key


class AssignedStandardItem(_serialization.Model):
    """Describe the properties of a of a standard assignments object reference.

    :ivar id: Full resourceId of the Microsoft.Security/standard object.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Full resourceId of the Microsoft.Security/standard object.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class AtaExternalSecuritySolution(ExternalSecuritySolution):
    """Represents an ATA security solution which sends logs to an OMS workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
    :vartype kind: str or ~azure.mgmt.security.models.ExternalSecuritySolutionKindEnum
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The external security solution properties for ATA solutions.
    :vartype properties: ~azure.mgmt.security.models.AtaSolutionProperties
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "AtaSolutionProperties"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.ExternalSecuritySolutionKindEnum"]] = None,
        properties: Optional["_models.AtaSolutionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
        :paramtype kind: str or ~azure.mgmt.security.models.ExternalSecuritySolutionKindEnum
        :keyword properties: The external security solution properties for ATA solutions.
        :paramtype properties: ~azure.mgmt.security.models.AtaSolutionProperties
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class AtaSolutionProperties(ExternalSecuritySolutionProperties):
    """The external security solution properties for ATA solutions.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar device_vendor:
    :vartype device_vendor: str
    :ivar device_type:
    :vartype device_type: str
    :ivar workspace: Represents an OMS workspace to which the solution is connected.
    :vartype workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    :ivar last_event_received:
    :vartype last_event_received: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "workspace": {"key": "workspace", "type": "ConnectedWorkspace"},
        "last_event_received": {"key": "lastEventReceived", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        device_vendor: Optional[str] = None,
        device_type: Optional[str] = None,
        workspace: Optional["_models.ConnectedWorkspace"] = None,
        last_event_received: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword device_vendor:
        :paramtype device_vendor: str
        :keyword device_type:
        :paramtype device_type: str
        :keyword workspace: Represents an OMS workspace to which the solution is connected.
        :paramtype workspace: ~azure.mgmt.security.models.ConnectedWorkspace
        :keyword last_event_received:
        :paramtype last_event_received: str
        """
        super().__init__(
            additional_properties=additional_properties,
            device_vendor=device_vendor,
            device_type=device_type,
            workspace=workspace,
            **kwargs
        )
        self.last_event_received = last_event_received


class AttestationEvidence(_serialization.Model):
    """Describe the properties of a assignment attestation.

    :ivar description: The description of the evidence.
    :vartype description: str
    :ivar source_url: The source url of the evidence.
    :vartype source_url: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "source_url": {"key": "sourceUrl", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, source_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: The description of the evidence.
        :paramtype description: str
        :keyword source_url: The source url of the evidence.
        :paramtype source_url: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.source_url = source_url


class AuthenticationDetailsProperties(_serialization.Model):
    """Settings for cloud authentication management.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AwAssumeRoleAuthenticationDetailsProperties, AwsCredsAuthenticationDetailsProperties,
    GcpCredentialsDetailsProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar authentication_provisioning_state: State of the multi-cloud connector. Known values are:
     "Valid", "Invalid", "Expired", and "IncorrectPolicy".
    :vartype authentication_provisioning_state: str or
     ~azure.mgmt.security.models.AuthenticationProvisioningState
    :ivar granted_permissions: The permissions detected in the cloud account.
    :vartype granted_permissions: list[str or ~azure.mgmt.security.models.PermissionProperty]
    :ivar authentication_type: Connect to your cloud account, for AWS use either account
     credentials or role-based authentication. For GCP use account organization credentials.
     Required. Known values are: "awsCreds", "awsAssumeRole", and "gcpCredentials".
    :vartype authentication_type: str or ~azure.mgmt.security.models.AuthenticationType
    """

    _validation = {
        "authentication_provisioning_state": {"readonly": True},
        "granted_permissions": {"readonly": True},
        "authentication_type": {"required": True},
    }

    _attribute_map = {
        "authentication_provisioning_state": {"key": "authenticationProvisioningState", "type": "str"},
        "granted_permissions": {"key": "grantedPermissions", "type": "[str]"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
    }

    _subtype_map = {
        "authentication_type": {
            "awsAssumeRole": "AwAssumeRoleAuthenticationDetailsProperties",
            "awsCreds": "AwsCredsAuthenticationDetailsProperties",
            "gcpCredentials": "GcpCredentialsDetailsProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.authentication_provisioning_state: Optional[Union[str, "_models.AuthenticationProvisioningState"]] = None
        self.granted_permissions: Optional[List[Union[str, "_models.PermissionProperty"]]] = None
        self.authentication_type: Optional[str] = None


class Authorization(_serialization.Model):
    """Authorization payload.

    :ivar code: Gets or sets one-time OAuth code to exchange for refresh and access tokens.

     Only used during PUT/PATCH operations. The secret is cleared during GET.
    :vartype code: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Gets or sets one-time OAuth code to exchange for refresh and access tokens.

         Only used during PUT/PATCH operations. The secret is cleared during GET.
        :paramtype code: str
        """
        super().__init__(**kwargs)
        self.code = code


class Tags(_serialization.Model):
    """A list of key value pairs that describe the resource.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ETag(_serialization.Model):
    """Entity tag is used for comparing two or more entities from the same requested resource.

    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    """

    _attribute_map = {
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.etag = etag


class Kind(_serialization.Model):
    """Describes an Azure resource with kind.

    :ivar kind: Kind of the resource.
    :vartype kind: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.kind = kind


class AzureTrackedResourceLocation(_serialization.Model):
    """Describes an Azure resource with location.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location


class TrackedResource(Resource, AzureTrackedResourceLocation, Kind, ETag, Tags):
    """Describes an Azure tracked resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        """
        super().__init__(location=location, kind=kind, etag=etag, tags=tags, **kwargs)
        self.tags = tags
        self.etag = etag
        self.kind = kind
        self.location = location
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class Automation(TrackedResource):
    """The security automation resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: The security automation description.
    :vartype description: str
    :ivar is_enabled: Indicates whether the security automation is enabled.
    :vartype is_enabled: bool
    :ivar scopes: A collection of scopes on which the security automations logic is applied.
     Supported scopes are the subscription itself or a resource group under that subscription. The
     automation will only apply on defined scopes.
    :vartype scopes: list[~azure.mgmt.security.models.AutomationScope]
    :ivar sources: A collection of the source event types which evaluate the security automation
     set of rules.
    :vartype sources: list[~azure.mgmt.security.models.AutomationSource]
    :ivar actions: A collection of the actions which are triggered if all the configured rules
     evaluations, within at least one rule set, are true.
    :vartype actions: list[~azure.mgmt.security.models.AutomationAction]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "scopes": {"key": "properties.scopes", "type": "[AutomationScope]"},
        "sources": {"key": "properties.sources", "type": "[AutomationSource]"},
        "actions": {"key": "properties.actions", "type": "[AutomationAction]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        description: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        scopes: Optional[List["_models.AutomationScope"]] = None,
        sources: Optional[List["_models.AutomationSource"]] = None,
        actions: Optional[List["_models.AutomationAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        :keyword description: The security automation description.
        :paramtype description: str
        :keyword is_enabled: Indicates whether the security automation is enabled.
        :paramtype is_enabled: bool
        :keyword scopes: A collection of scopes on which the security automations logic is applied.
         Supported scopes are the subscription itself or a resource group under that subscription. The
         automation will only apply on defined scopes.
        :paramtype scopes: list[~azure.mgmt.security.models.AutomationScope]
        :keyword sources: A collection of the source event types which evaluate the security automation
         set of rules.
        :paramtype sources: list[~azure.mgmt.security.models.AutomationSource]
        :keyword actions: A collection of the actions which are triggered if all the configured rules
         evaluations, within at least one rule set, are true.
        :paramtype actions: list[~azure.mgmt.security.models.AutomationAction]
        """
        super().__init__(tags=tags, etag=etag, kind=kind, location=location, **kwargs)
        self.description = description
        self.is_enabled = is_enabled
        self.scopes = scopes
        self.sources = sources
        self.actions = actions


class AutomationAction(_serialization.Model):
    """The action that should be triggered.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AutomationActionEventHub, AutomationActionLogicApp, AutomationActionWorkspace

    All required parameters must be populated in order to send to server.

    :ivar action_type: The type of the action that will be triggered by the Automation. Required.
     Known values are: "Internal", "LogicApp", "EventHub", and "Workspace".
    :vartype action_type: str or ~azure.mgmt.security.models.ActionType
    """

    _validation = {
        "action_type": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
    }

    _subtype_map = {
        "action_type": {
            "EventHub": "AutomationActionEventHub",
            "LogicApp": "AutomationActionLogicApp",
            "Workspace": "AutomationActionWorkspace",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.action_type: Optional[str] = None


class AutomationActionEventHub(AutomationAction):
    """The target Event Hub to which event data will be exported. To learn more about Microsoft
    Defender for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar action_type: The type of the action that will be triggered by the Automation. Required.
     Known values are: "Internal", "LogicApp", "EventHub", and "Workspace".
    :vartype action_type: str or ~azure.mgmt.security.models.ActionType
    :ivar event_hub_resource_id: The target Event Hub Azure Resource ID.
    :vartype event_hub_resource_id: str
    :ivar sas_policy_name: The target Event Hub SAS policy name.
    :vartype sas_policy_name: str
    :ivar connection_string: The target Event Hub connection string (it will not be included in any
     response).
    :vartype connection_string: str
    :ivar is_trusted_service_enabled: Indicates whether the trusted service is enabled or not.
    :vartype is_trusted_service_enabled: bool
    """

    _validation = {
        "action_type": {"required": True},
        "sas_policy_name": {"readonly": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "event_hub_resource_id": {"key": "eventHubResourceId", "type": "str"},
        "sas_policy_name": {"key": "sasPolicyName", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
        "is_trusted_service_enabled": {"key": "isTrustedServiceEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        event_hub_resource_id: Optional[str] = None,
        connection_string: Optional[str] = None,
        is_trusted_service_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword event_hub_resource_id: The target Event Hub Azure Resource ID.
        :paramtype event_hub_resource_id: str
        :keyword connection_string: The target Event Hub connection string (it will not be included in
         any response).
        :paramtype connection_string: str
        :keyword is_trusted_service_enabled: Indicates whether the trusted service is enabled or not.
        :paramtype is_trusted_service_enabled: bool
        """
        super().__init__(**kwargs)
        self.action_type: str = "EventHub"
        self.event_hub_resource_id = event_hub_resource_id
        self.sas_policy_name: Optional[str] = None
        self.connection_string = connection_string
        self.is_trusted_service_enabled = is_trusted_service_enabled


class AutomationActionLogicApp(AutomationAction):
    """The logic app action that should be triggered. To learn more about Microsoft Defender for
    Cloud's Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore.

    All required parameters must be populated in order to send to server.

    :ivar action_type: The type of the action that will be triggered by the Automation. Required.
     Known values are: "Internal", "LogicApp", "EventHub", and "Workspace".
    :vartype action_type: str or ~azure.mgmt.security.models.ActionType
    :ivar logic_app_resource_id: The triggered Logic App Azure Resource ID. This can also reside on
     other subscriptions, given that you have permissions to trigger the Logic App.
    :vartype logic_app_resource_id: str
    :ivar uri: The Logic App trigger URI endpoint (it will not be included in any response).
    :vartype uri: str
    """

    _validation = {
        "action_type": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "logic_app_resource_id": {"key": "logicAppResourceId", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(
        self, *, logic_app_resource_id: Optional[str] = None, uri: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword logic_app_resource_id: The triggered Logic App Azure Resource ID. This can also reside
         on other subscriptions, given that you have permissions to trigger the Logic App.
        :paramtype logic_app_resource_id: str
        :keyword uri: The Logic App trigger URI endpoint (it will not be included in any response).
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.action_type: str = "LogicApp"
        self.logic_app_resource_id = logic_app_resource_id
        self.uri = uri


class AutomationActionWorkspace(AutomationAction):
    """The Log Analytics Workspace to which event data will be exported. Security alerts data will
    reside in the 'SecurityAlert' table and the assessments data will reside in the
    'SecurityRecommendation' table (under the 'Security'/'SecurityCenterFree' solutions). Note that
    in order to view the data in the workspace, the Security Center Log Analytics free/standard
    solution needs to be enabled on that workspace. To learn more about Microsoft Defender for
    Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore.

    All required parameters must be populated in order to send to server.

    :ivar action_type: The type of the action that will be triggered by the Automation. Required.
     Known values are: "Internal", "LogicApp", "EventHub", and "Workspace".
    :vartype action_type: str or ~azure.mgmt.security.models.ActionType
    :ivar workspace_resource_id: The fully qualified Log Analytics Workspace Azure Resource ID.
    :vartype workspace_resource_id: str
    """

    _validation = {
        "action_type": {"required": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "workspace_resource_id": {"key": "workspaceResourceId", "type": "str"},
    }

    def __init__(self, *, workspace_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword workspace_resource_id: The fully qualified Log Analytics Workspace Azure Resource ID.
        :paramtype workspace_resource_id: str
        """
        super().__init__(**kwargs)
        self.action_type: str = "Workspace"
        self.workspace_resource_id = workspace_resource_id


class AutomationList(_serialization.Model):
    """List of security automations response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of security automations under the given scope. Required.
    :vartype value: list[~azure.mgmt.security.models.Automation]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Automation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Automation"], **kwargs: Any) -> None:
        """
        :keyword value: The list of security automations under the given scope. Required.
        :paramtype value: list[~azure.mgmt.security.models.Automation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AutomationRuleSet(_serialization.Model):
    """A rule set which evaluates all its rules upon an event interception. Only when all the included
    rules in the rule set will be evaluated as 'true', will the event trigger the defined actions.

    :ivar rules:
    :vartype rules: list[~azure.mgmt.security.models.AutomationTriggeringRule]
    """

    _attribute_map = {
        "rules": {"key": "rules", "type": "[AutomationTriggeringRule]"},
    }

    def __init__(self, *, rules: Optional[List["_models.AutomationTriggeringRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword rules:
        :paramtype rules: list[~azure.mgmt.security.models.AutomationTriggeringRule]
        """
        super().__init__(**kwargs)
        self.rules = rules


class AutomationScope(_serialization.Model):
    """A single automation scope.

    :ivar description: The resources scope description.
    :vartype description: str
    :ivar scope_path: The resources scope path. Can be the subscription on which the automation is
     defined on or a resource group under that subscription (fully qualified Azure resource IDs).
    :vartype scope_path: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "scope_path": {"key": "scopePath", "type": "str"},
    }

    def __init__(self, *, description: Optional[str] = None, scope_path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword description: The resources scope description.
        :paramtype description: str
        :keyword scope_path: The resources scope path. Can be the subscription on which the automation
         is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
        :paramtype scope_path: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.scope_path = scope_path


class AutomationSource(_serialization.Model):
    """The source event types which evaluate the security automation set of rules. For example -
    security alerts and security assessments. To learn more about the supported security events
    data models schemas - please visit https://aka.ms/ASCAutomationSchemas.

    :ivar event_source: A valid event source type. Known values are: "Assessments",
     "AssessmentsSnapshot", "SubAssessments", "SubAssessmentsSnapshot", "Alerts", "SecureScores",
     "SecureScoresSnapshot", "SecureScoreControls", "SecureScoreControlsSnapshot",
     "RegulatoryComplianceAssessment", "RegulatoryComplianceAssessmentSnapshot", "AttackPaths", and
     "AttackPathsSnapshot".
    :vartype event_source: str or ~azure.mgmt.security.models.EventSource
    :ivar rule_sets: A set of rules which evaluate upon event interception. A logical disjunction
     is applied between defined rule sets (logical 'or').
    :vartype rule_sets: list[~azure.mgmt.security.models.AutomationRuleSet]
    """

    _attribute_map = {
        "event_source": {"key": "eventSource", "type": "str"},
        "rule_sets": {"key": "ruleSets", "type": "[AutomationRuleSet]"},
    }

    def __init__(
        self,
        *,
        event_source: Optional[Union[str, "_models.EventSource"]] = None,
        rule_sets: Optional[List["_models.AutomationRuleSet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword event_source: A valid event source type. Known values are: "Assessments",
         "AssessmentsSnapshot", "SubAssessments", "SubAssessmentsSnapshot", "Alerts", "SecureScores",
         "SecureScoresSnapshot", "SecureScoreControls", "SecureScoreControlsSnapshot",
         "RegulatoryComplianceAssessment", "RegulatoryComplianceAssessmentSnapshot", "AttackPaths", and
         "AttackPathsSnapshot".
        :paramtype event_source: str or ~azure.mgmt.security.models.EventSource
        :keyword rule_sets: A set of rules which evaluate upon event interception. A logical
         disjunction is applied between defined rule sets (logical 'or').
        :paramtype rule_sets: list[~azure.mgmt.security.models.AutomationRuleSet]
        """
        super().__init__(**kwargs)
        self.event_source = event_source
        self.rule_sets = rule_sets


class AutomationTriggeringRule(_serialization.Model):
    """A rule which is evaluated upon event interception. The rule is configured by comparing a
    specific value from the event model to an expected value. This comparison is done by using one
    of the supported operators set.

    :ivar property_j_path: The JPath of the entity model property that should be checked.
    :vartype property_j_path: str
    :ivar property_type: The data type of the compared operands (string, integer, floating point
     number or a boolean [true/false]]. Known values are: "String", "Integer", "Number", and
     "Boolean".
    :vartype property_type: str or ~azure.mgmt.security.models.PropertyType
    :ivar expected_value: The expected value.
    :vartype expected_value: str
    :ivar operator: A valid comparer operator to use. A case-insensitive comparison will be applied
     for String PropertyType. Known values are: "Equals", "GreaterThan", "GreaterThanOrEqualTo",
     "LesserThan", "LesserThanOrEqualTo", "NotEquals", "Contains", "StartsWith", and "EndsWith".
    :vartype operator: str or ~azure.mgmt.security.models.Operator
    """

    _attribute_map = {
        "property_j_path": {"key": "propertyJPath", "type": "str"},
        "property_type": {"key": "propertyType", "type": "str"},
        "expected_value": {"key": "expectedValue", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
    }

    def __init__(
        self,
        *,
        property_j_path: Optional[str] = None,
        property_type: Optional[Union[str, "_models.PropertyType"]] = None,
        expected_value: Optional[str] = None,
        operator: Optional[Union[str, "_models.Operator"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword property_j_path: The JPath of the entity model property that should be checked.
        :paramtype property_j_path: str
        :keyword property_type: The data type of the compared operands (string, integer, floating point
         number or a boolean [true/false]]. Known values are: "String", "Integer", "Number", and
         "Boolean".
        :paramtype property_type: str or ~azure.mgmt.security.models.PropertyType
        :keyword expected_value: The expected value.
        :paramtype expected_value: str
        :keyword operator: A valid comparer operator to use. A case-insensitive comparison will be
         applied for String PropertyType. Known values are: "Equals", "GreaterThan",
         "GreaterThanOrEqualTo", "LesserThan", "LesserThanOrEqualTo", "NotEquals", "Contains",
         "StartsWith", and "EndsWith".
        :paramtype operator: str or ~azure.mgmt.security.models.Operator
        """
        super().__init__(**kwargs)
        self.property_j_path = property_j_path
        self.property_type = property_type
        self.expected_value = expected_value
        self.operator = operator


class AutomationUpdateModel(Tags):
    """The update model of security automation resource.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar description: The security automation description.
    :vartype description: str
    :ivar is_enabled: Indicates whether the security automation is enabled.
    :vartype is_enabled: bool
    :ivar scopes: A collection of scopes on which the security automations logic is applied.
     Supported scopes are the subscription itself or a resource group under that subscription. The
     automation will only apply on defined scopes.
    :vartype scopes: list[~azure.mgmt.security.models.AutomationScope]
    :ivar sources: A collection of the source event types which evaluate the security automation
     set of rules.
    :vartype sources: list[~azure.mgmt.security.models.AutomationSource]
    :ivar actions: A collection of the actions which are triggered if all the configured rules
     evaluations, within at least one rule set, are true.
    :vartype actions: list[~azure.mgmt.security.models.AutomationAction]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "scopes": {"key": "properties.scopes", "type": "[AutomationScope]"},
        "sources": {"key": "properties.sources", "type": "[AutomationSource]"},
        "actions": {"key": "properties.actions", "type": "[AutomationAction]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        scopes: Optional[List["_models.AutomationScope"]] = None,
        sources: Optional[List["_models.AutomationSource"]] = None,
        actions: Optional[List["_models.AutomationAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        :keyword description: The security automation description.
        :paramtype description: str
        :keyword is_enabled: Indicates whether the security automation is enabled.
        :paramtype is_enabled: bool
        :keyword scopes: A collection of scopes on which the security automations logic is applied.
         Supported scopes are the subscription itself or a resource group under that subscription. The
         automation will only apply on defined scopes.
        :paramtype scopes: list[~azure.mgmt.security.models.AutomationScope]
        :keyword sources: A collection of the source event types which evaluate the security automation
         set of rules.
        :paramtype sources: list[~azure.mgmt.security.models.AutomationSource]
        :keyword actions: A collection of the actions which are triggered if all the configured rules
         evaluations, within at least one rule set, are true.
        :paramtype actions: list[~azure.mgmt.security.models.AutomationAction]
        """
        super().__init__(tags=tags, **kwargs)
        self.description = description
        self.is_enabled = is_enabled
        self.scopes = scopes
        self.sources = sources
        self.actions = actions


class AutomationValidationStatus(_serialization.Model):
    """The security automation model state property bag.

    :ivar is_valid: Indicates whether the model is valid or not.
    :vartype is_valid: bool
    :ivar message: The validation message.
    :vartype message: str
    """

    _attribute_map = {
        "is_valid": {"key": "isValid", "type": "bool"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, is_valid: Optional[bool] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword is_valid: Indicates whether the model is valid or not.
        :paramtype is_valid: bool
        :keyword message: The validation message.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.is_valid = is_valid
        self.message = message


class AutoProvisioningSetting(Resource):
    """Auto provisioning setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar auto_provision: Describes what kind of security agent provisioning action to take. Known
     values are: "On" and "Off".
    :vartype auto_provision: str or ~azure.mgmt.security.models.AutoProvision
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "auto_provision": {"key": "properties.autoProvision", "type": "str"},
    }

    def __init__(self, *, auto_provision: Optional[Union[str, "_models.AutoProvision"]] = None, **kwargs: Any) -> None:
        """
        :keyword auto_provision: Describes what kind of security agent provisioning action to take.
         Known values are: "On" and "Off".
        :paramtype auto_provision: str or ~azure.mgmt.security.models.AutoProvision
        """
        super().__init__(**kwargs)
        self.auto_provision = auto_provision


class AutoProvisioningSettingList(_serialization.Model):
    """List of all the auto provisioning settings response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of all the auto provisioning settings.
    :vartype value: list[~azure.mgmt.security.models.AutoProvisioningSetting]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AutoProvisioningSetting]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AutoProvisioningSetting"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of all the auto provisioning settings.
        :paramtype value: list[~azure.mgmt.security.models.AutoProvisioningSetting]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AwAssumeRoleAuthenticationDetailsProperties(AuthenticationDetailsProperties):  # pylint: disable=name-too-long
    """AWS cloud account connector based assume role, the role enables delegating access to your AWS
    resources. The role is composed of role Amazon Resource Name (ARN) and external ID. For more
    details, refer to :code:`<a
    href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user.html">Creating
    a Role to Delegate Permissions to an IAM User (write only)</a>`.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar authentication_provisioning_state: State of the multi-cloud connector. Known values are:
     "Valid", "Invalid", "Expired", and "IncorrectPolicy".
    :vartype authentication_provisioning_state: str or
     ~azure.mgmt.security.models.AuthenticationProvisioningState
    :ivar granted_permissions: The permissions detected in the cloud account.
    :vartype granted_permissions: list[str or ~azure.mgmt.security.models.PermissionProperty]
    :ivar authentication_type: Connect to your cloud account, for AWS use either account
     credentials or role-based authentication. For GCP use account organization credentials.
     Required. Known values are: "awsCreds", "awsAssumeRole", and "gcpCredentials".
    :vartype authentication_type: str or ~azure.mgmt.security.models.AuthenticationType
    :ivar account_id: The ID of the cloud account.
    :vartype account_id: str
    :ivar aws_assume_role_arn: Assumed role ID is an identifier that you can use to create
     temporary security credentials. Required.
    :vartype aws_assume_role_arn: str
    :ivar aws_external_id: A unique identifier that is required when you assume a role in another
     account. Required.
    :vartype aws_external_id: str
    """

    _validation = {
        "authentication_provisioning_state": {"readonly": True},
        "granted_permissions": {"readonly": True},
        "authentication_type": {"required": True},
        "account_id": {"readonly": True},
        "aws_assume_role_arn": {"required": True},
        "aws_external_id": {"required": True},
    }

    _attribute_map = {
        "authentication_provisioning_state": {"key": "authenticationProvisioningState", "type": "str"},
        "granted_permissions": {"key": "grantedPermissions", "type": "[str]"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "aws_assume_role_arn": {"key": "awsAssumeRoleArn", "type": "str"},
        "aws_external_id": {"key": "awsExternalId", "type": "str"},
    }

    def __init__(self, *, aws_assume_role_arn: str, aws_external_id: str, **kwargs: Any) -> None:
        """
        :keyword aws_assume_role_arn: Assumed role ID is an identifier that you can use to create
         temporary security credentials. Required.
        :paramtype aws_assume_role_arn: str
        :keyword aws_external_id: A unique identifier that is required when you assume a role in
         another account. Required.
        :paramtype aws_external_id: str
        """
        super().__init__(**kwargs)
        self.authentication_type: str = "awsAssumeRole"
        self.account_id: Optional[str] = None
        self.aws_assume_role_arn = aws_assume_role_arn
        self.aws_external_id = aws_external_id


class AwsCredsAuthenticationDetailsProperties(AuthenticationDetailsProperties):
    """AWS cloud account connector based credentials, the credentials is composed of access key ID and
    secret key, for more details, refer to :code:`<a
    href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_create.html">Creating an IAM
    User in Your AWS Account (write only)</a>`.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar authentication_provisioning_state: State of the multi-cloud connector. Known values are:
     "Valid", "Invalid", "Expired", and "IncorrectPolicy".
    :vartype authentication_provisioning_state: str or
     ~azure.mgmt.security.models.AuthenticationProvisioningState
    :ivar granted_permissions: The permissions detected in the cloud account.
    :vartype granted_permissions: list[str or ~azure.mgmt.security.models.PermissionProperty]
    :ivar authentication_type: Connect to your cloud account, for AWS use either account
     credentials or role-based authentication. For GCP use account organization credentials.
     Required. Known values are: "awsCreds", "awsAssumeRole", and "gcpCredentials".
    :vartype authentication_type: str or ~azure.mgmt.security.models.AuthenticationType
    :ivar account_id: The ID of the cloud account.
    :vartype account_id: str
    :ivar aws_access_key_id: Public key element of the AWS credential object (write only).
     Required.
    :vartype aws_access_key_id: str
    :ivar aws_secret_access_key: Secret key element of the AWS credential object (write only).
     Required.
    :vartype aws_secret_access_key: str
    """

    _validation = {
        "authentication_provisioning_state": {"readonly": True},
        "granted_permissions": {"readonly": True},
        "authentication_type": {"required": True},
        "account_id": {"readonly": True},
        "aws_access_key_id": {"required": True},
        "aws_secret_access_key": {"required": True},
    }

    _attribute_map = {
        "authentication_provisioning_state": {"key": "authenticationProvisioningState", "type": "str"},
        "granted_permissions": {"key": "grantedPermissions", "type": "[str]"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "aws_access_key_id": {"key": "awsAccessKeyId", "type": "str"},
        "aws_secret_access_key": {"key": "awsSecretAccessKey", "type": "str"},
    }

    def __init__(self, *, aws_access_key_id: str, aws_secret_access_key: str, **kwargs: Any) -> None:
        """
        :keyword aws_access_key_id: Public key element of the AWS credential object (write only).
         Required.
        :paramtype aws_access_key_id: str
        :keyword aws_secret_access_key: Secret key element of the AWS credential object (write only).
         Required.
        :paramtype aws_secret_access_key: str
        """
        super().__init__(**kwargs)
        self.authentication_type: str = "awsCreds"
        self.account_id: Optional[str] = None
        self.aws_access_key_id = aws_access_key_id
        self.aws_secret_access_key = aws_secret_access_key


class EnvironmentData(_serialization.Model):
    """The security connector environment data.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AwsEnvironmentData, AzureDevOpsScopeEnvironmentData, DockerHubEnvironmentData,
    GcpProjectEnvironmentData, GithubScopeEnvironmentData, GitlabScopeEnvironmentData,
    JFrogEnvironmentData

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", "GitlabScope",
     "DockerHubOrganization", and "JFrogArtifactory".
    :vartype environment_type: str or ~azure.mgmt.security.models.EnvironmentType
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
    }

    _subtype_map = {
        "environment_type": {
            "AwsAccount": "AwsEnvironmentData",
            "AzureDevOpsScope": "AzureDevOpsScopeEnvironmentData",
            "DockerHubOrganization": "DockerHubEnvironmentData",
            "GcpProject": "GcpProjectEnvironmentData",
            "GithubScope": "GithubScopeEnvironmentData",
            "GitlabScope": "GitlabScopeEnvironmentData",
            "JFrogArtifactory": "JFrogEnvironmentData",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.environment_type: Optional[str] = None


class AwsEnvironmentData(EnvironmentData):
    """The AWS connector environment data.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", "GitlabScope",
     "DockerHubOrganization", and "JFrogArtifactory".
    :vartype environment_type: str or ~azure.mgmt.security.models.EnvironmentType
    :ivar organizational_data: The AWS account's organizational data.
    :vartype organizational_data: ~azure.mgmt.security.models.AwsOrganizationalData
    :ivar regions: list of regions to scan.
    :vartype regions: list[str]
    :ivar account_name: The AWS account name.
    :vartype account_name: str
    :ivar scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
    :vartype scan_interval: int
    """

    _validation = {
        "environment_type": {"required": True},
        "account_name": {"readonly": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
        "organizational_data": {"key": "organizationalData", "type": "AwsOrganizationalData"},
        "regions": {"key": "regions", "type": "[str]"},
        "account_name": {"key": "accountName", "type": "str"},
        "scan_interval": {"key": "scanInterval", "type": "int"},
    }

    def __init__(
        self,
        *,
        organizational_data: Optional["_models.AwsOrganizationalData"] = None,
        regions: Optional[List[str]] = None,
        scan_interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword organizational_data: The AWS account's organizational data.
        :paramtype organizational_data: ~azure.mgmt.security.models.AwsOrganizationalData
        :keyword regions: list of regions to scan.
        :paramtype regions: list[str]
        :keyword scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
        :paramtype scan_interval: int
        """
        super().__init__(**kwargs)
        self.environment_type: str = "AwsAccount"
        self.organizational_data = organizational_data
        self.regions = regions
        self.account_name: Optional[str] = None
        self.scan_interval = scan_interval


class AwsOrganizationalData(_serialization.Model):
    """The AWS organization data.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AwsOrganizationalDataMember, AwsOrganizationalDataMaster

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.models.OrganizationMembershipType
    """

    _validation = {
        "organization_membership_type": {"required": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
    }

    _subtype_map = {
        "organization_membership_type": {
            "Member": "AwsOrganizationalDataMember",
            "Organization": "AwsOrganizationalDataMaster",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.organization_membership_type: Optional[str] = None


class AwsOrganizationalDataMaster(AwsOrganizationalData):
    """The AWS organization data for the master account.

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.models.OrganizationMembershipType
    :ivar stackset_name: If the multi cloud account is of membership type organization, this will
     be the name of the onboarding stackset.
    :vartype stackset_name: str
    :ivar excluded_account_ids: If the multi cloud account is of membership type organization, list
     of accounts excluded from offering.
    :vartype excluded_account_ids: list[str]
    """

    _validation = {
        "organization_membership_type": {"required": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
        "stackset_name": {"key": "stacksetName", "type": "str"},
        "excluded_account_ids": {"key": "excludedAccountIds", "type": "[str]"},
    }

    def __init__(
        self, *, stackset_name: Optional[str] = None, excluded_account_ids: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword stackset_name: If the multi cloud account is of membership type organization, this
         will be the name of the onboarding stackset.
        :paramtype stackset_name: str
        :keyword excluded_account_ids: If the multi cloud account is of membership type organization,
         list of accounts excluded from offering.
        :paramtype excluded_account_ids: list[str]
        """
        super().__init__(**kwargs)
        self.organization_membership_type: str = "Organization"
        self.stackset_name = stackset_name
        self.excluded_account_ids = excluded_account_ids


class AwsOrganizationalDataMember(AwsOrganizationalData):
    """The AWS organization data for the member account.

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.models.OrganizationMembershipType
    :ivar parent_hierarchy_id: If the multi cloud account is not of membership type organization,
     this will be the ID of the account's parent.
    :vartype parent_hierarchy_id: str
    """

    _validation = {
        "organization_membership_type": {"required": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
        "parent_hierarchy_id": {"key": "parentHierarchyId", "type": "str"},
    }

    def __init__(self, *, parent_hierarchy_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword parent_hierarchy_id: If the multi cloud account is not of membership type
         organization, this will be the ID of the account's parent.
        :paramtype parent_hierarchy_id: str
        """
        super().__init__(**kwargs)
        self.organization_membership_type: str = "Member"
        self.parent_hierarchy_id = parent_hierarchy_id


class ResourceAutoGenerated3(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class ProxyResource(ResourceAutoGenerated3):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """


class AzureDevOpsOrg(ProxyResource):
    """Azure DevOps Organization resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar properties: Azure DevOps Organization properties.
    :vartype properties: ~azure.mgmt.security.models.AzureDevOpsOrgProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureDevOpsOrgProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AzureDevOpsOrgProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Azure DevOps Organization properties.
        :paramtype properties: ~azure.mgmt.security.models.AzureDevOpsOrgProperties
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.properties = properties


class AzureDevOpsOrganizationConfiguration(_serialization.Model):
    """AzureDevOps Org Inventory Configuration.

    :ivar auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
     "NotApplicable".
    :vartype auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
    :ivar project_configs: AzureDevOps Project Inventory Configuration.
     Dictionary of AzureDevOps project name to desired project configuration.
     If AutoDiscovery is Enabled, this field should be empty or null.
    :vartype project_configs: dict[str,
     ~azure.mgmt.security.models.AzureDevOpsProjectConfiguration]
    """

    _attribute_map = {
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "project_configs": {"key": "projectConfigs", "type": "{AzureDevOpsProjectConfiguration}"},
    }

    def __init__(
        self,
        *,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        project_configs: Optional[Dict[str, "_models.AzureDevOpsProjectConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
         "NotApplicable".
        :paramtype auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
        :keyword project_configs: AzureDevOps Project Inventory Configuration.
         Dictionary of AzureDevOps project name to desired project configuration.
         If AutoDiscovery is Enabled, this field should be empty or null.
        :paramtype project_configs: dict[str,
         ~azure.mgmt.security.models.AzureDevOpsProjectConfiguration]
        """
        super().__init__(**kwargs)
        self.auto_discovery = auto_discovery
        self.project_configs = project_configs


class AzureDevOpsOrgListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.models.AzureDevOpsOrg]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsOrg]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AzureDevOpsOrg"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.models.AzureDevOpsOrg]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsOrgProperties(_serialization.Model):
    """Azure DevOps Organization properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets the resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets the time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.DevOpsProvisioningState
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
     is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
    :ivar actionable_remediation: Configuration payload for PR Annotations.
    :vartype actionable_remediation: ~azure.mgmt.security.models.ActionableRemediation
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
        "actionable_remediation": {"key": "actionableRemediation", "type": "ActionableRemediation"},
    }

    def __init__(
        self,
        *,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        actionable_remediation: Optional["_models.ActionableRemediation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
         is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
        :keyword actionable_remediation: Configuration payload for PR Annotations.
        :paramtype actionable_remediation: ~azure.mgmt.security.models.ActionableRemediation
        """
        super().__init__(**kwargs)
        self.provisioning_status_message: Optional[str] = None
        self.provisioning_status_update_time_utc: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None
        self.onboarding_state = onboarding_state
        self.actionable_remediation = actionable_remediation


class AzureDevOpsProject(ProxyResource):
    """Azure DevOps Project resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar properties: Azure DevOps Project properties.
    :vartype properties: ~azure.mgmt.security.models.AzureDevOpsProjectProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureDevOpsProjectProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AzureDevOpsProjectProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Azure DevOps Project properties.
        :paramtype properties: ~azure.mgmt.security.models.AzureDevOpsProjectProperties
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.properties = properties


class AzureDevOpsProjectConfiguration(_serialization.Model):
    """AzureDevOps Project Inventory Configuration.

    :ivar auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
     "NotApplicable".
    :vartype auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
    :ivar repository_configs: AzureDevOps Repository Inventory Configuration.
     Dictionary of AzureDevOps repository name to desired repository configuration.
     If AutoDiscovery is Enabled, this field should be null or empty.
    :vartype repository_configs: dict[str, ~azure.mgmt.security.models.BaseResourceConfiguration]
    """

    _attribute_map = {
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "repository_configs": {"key": "repositoryConfigs", "type": "{BaseResourceConfiguration}"},
    }

    def __init__(
        self,
        *,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        repository_configs: Optional[Dict[str, "_models.BaseResourceConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
         "NotApplicable".
        :paramtype auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
        :keyword repository_configs: AzureDevOps Repository Inventory Configuration.
         Dictionary of AzureDevOps repository name to desired repository configuration.
         If AutoDiscovery is Enabled, this field should be null or empty.
        :paramtype repository_configs: dict[str, ~azure.mgmt.security.models.BaseResourceConfiguration]
        """
        super().__init__(**kwargs)
        self.auto_discovery = auto_discovery
        self.repository_configs = repository_configs


class AzureDevOpsProjectListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.models.AzureDevOpsProject]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsProject]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AzureDevOpsProject"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.models.AzureDevOpsProject]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsProjectProperties(_serialization.Model):
    """Azure DevOps Project properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets the resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets the time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.DevOpsProvisioningState
    :ivar parent_org_name: Gets or sets parent Azure DevOps Organization name.
    :vartype parent_org_name: str
    :ivar project_id: Gets or sets Azure DevOps Project id.
    :vartype project_id: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
     is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
    :ivar actionable_remediation: Configuration payload for PR Annotations.
    :vartype actionable_remediation: ~azure.mgmt.security.models.ActionableRemediation
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "project_id": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "parent_org_name": {"key": "parentOrgName", "type": "str"},
        "project_id": {"key": "projectId", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
        "actionable_remediation": {"key": "actionableRemediation", "type": "ActionableRemediation"},
    }

    def __init__(
        self,
        *,
        parent_org_name: Optional[str] = None,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        actionable_remediation: Optional["_models.ActionableRemediation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword parent_org_name: Gets or sets parent Azure DevOps Organization name.
        :paramtype parent_org_name: str
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
         is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
        :keyword actionable_remediation: Configuration payload for PR Annotations.
        :paramtype actionable_remediation: ~azure.mgmt.security.models.ActionableRemediation
        """
        super().__init__(**kwargs)
        self.provisioning_status_message: Optional[str] = None
        self.provisioning_status_update_time_utc: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None
        self.parent_org_name = parent_org_name
        self.project_id: Optional[str] = None
        self.onboarding_state = onboarding_state
        self.actionable_remediation = actionable_remediation


class AzureDevOpsRepository(ProxyResource):
    """Azure DevOps Repository resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar properties: Azure DevOps Repository properties.
    :vartype properties: ~azure.mgmt.security.models.AzureDevOpsRepositoryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureDevOpsRepositoryProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AzureDevOpsRepositoryProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Azure DevOps Repository properties.
        :paramtype properties: ~azure.mgmt.security.models.AzureDevOpsRepositoryProperties
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.properties = properties


class AzureDevOpsRepositoryListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.models.AzureDevOpsRepository]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsRepository]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AzureDevOpsRepository"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.models.AzureDevOpsRepository]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsRepositoryProperties(_serialization.Model):
    """Azure DevOps Repository properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets the resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets the time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.DevOpsProvisioningState
    :ivar parent_org_name: Gets or sets parent Azure DevOps Organization name.
    :vartype parent_org_name: str
    :ivar parent_project_name: Gets or sets parent Azure DevOps Project name.
    :vartype parent_project_name: str
    :ivar repo_id: Gets or sets Azure DevOps Repository id.
    :vartype repo_id: str
    :ivar repo_url: Gets or sets Azure DevOps Repository url.
    :vartype repo_url: str
    :ivar visibility: Gets or sets Azure DevOps repository visibility, whether it is public or
     private etc.
    :vartype visibility: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
     is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
    :ivar actionable_remediation: Configuration payload for PR Annotations.
    :vartype actionable_remediation: ~azure.mgmt.security.models.ActionableRemediation
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "repo_id": {"readonly": True},
        "repo_url": {"readonly": True},
        "visibility": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "parent_org_name": {"key": "parentOrgName", "type": "str"},
        "parent_project_name": {"key": "parentProjectName", "type": "str"},
        "repo_id": {"key": "repoId", "type": "str"},
        "repo_url": {"key": "repoUrl", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
        "actionable_remediation": {"key": "actionableRemediation", "type": "ActionableRemediation"},
    }

    def __init__(
        self,
        *,
        parent_org_name: Optional[str] = None,
        parent_project_name: Optional[str] = None,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        actionable_remediation: Optional["_models.ActionableRemediation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword parent_org_name: Gets or sets parent Azure DevOps Organization name.
        :paramtype parent_org_name: str
        :keyword parent_project_name: Gets or sets parent Azure DevOps Project name.
        :paramtype parent_project_name: str
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
         is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
        :keyword actionable_remediation: Configuration payload for PR Annotations.
        :paramtype actionable_remediation: ~azure.mgmt.security.models.ActionableRemediation
        """
        super().__init__(**kwargs)
        self.provisioning_status_message: Optional[str] = None
        self.provisioning_status_update_time_utc: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None
        self.parent_org_name = parent_org_name
        self.parent_project_name = parent_project_name
        self.repo_id: Optional[str] = None
        self.repo_url: Optional[str] = None
        self.visibility: Optional[str] = None
        self.onboarding_state = onboarding_state
        self.actionable_remediation = actionable_remediation


class AzureDevOpsScopeEnvironmentData(EnvironmentData):
    """The AzureDevOps scope connector's environment data.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", "GitlabScope",
     "DockerHubOrganization", and "JFrogArtifactory".
    :vartype environment_type: str or ~azure.mgmt.security.models.EnvironmentType
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.environment_type: str = "AzureDevOpsScope"


class ResourceDetails(_serialization.Model):
    """Details of the resource that was assessed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureResourceDetails, OnPremiseResourceDetails

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.models.Source
    """

    _validation = {
        "source": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
    }

    _subtype_map = {"source": {"Azure": "AzureResourceDetails", "OnPremise": "OnPremiseResourceDetails"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source: Optional[str] = None


class AzureResourceDetails(ResourceDetails):
    """Details of the Azure resource that was assessed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.models.Source
    :ivar id: Azure resource Id of the assessed resource.
    :vartype id: str
    """

    _validation = {
        "source": {"required": True},
        "id": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source: str = "Azure"
        self.id: Optional[str] = None


class ResourceIdentifier(_serialization.Model):
    """A resource identifier for an alert which can be used to direct the alert to the right product
    exposure group (tenant, workspace, subscription etc.).

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureResourceIdentifier, LogAnalyticsIdentifier

    All required parameters must be populated in order to send to server.

    :ivar type: There can be multiple identifiers of different type per alert, this field specify
     the identifier type. Required. Known values are: "AzureResource" and "LogAnalytics".
    :vartype type: str or ~azure.mgmt.security.models.ResourceIdentifierType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"AzureResource": "AzureResourceIdentifier", "LogAnalytics": "LogAnalyticsIdentifier"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class AzureResourceIdentifier(ResourceIdentifier):
    """Azure resource identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: There can be multiple identifiers of different type per alert, this field specify
     the identifier type. Required. Known values are: "AzureResource" and "LogAnalytics".
    :vartype type: str or ~azure.mgmt.security.models.ResourceIdentifierType
    :ivar azure_resource_id: ARM resource identifier for the cloud resource being alerted on.
    :vartype azure_resource_id: str
    """

    _validation = {
        "type": {"required": True},
        "azure_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "azure_resource_id": {"key": "azureResourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: str = "AzureResource"
        self.azure_resource_id: Optional[str] = None


class AzureResourceLink(_serialization.Model):
    """Describes an Azure resource with kind.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None


class ResourceAutoGenerated(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class ServerVulnerabilityAssessmentsSetting(ResourceAutoGenerated):
    """A base vulnerability assessments setting on servers in the defined scope.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureServersSetting

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar kind: The kind of the server vulnerability assessments setting. Required.
     "AzureServersSetting"
    :vartype kind: str or ~azure.mgmt.security.models.ServerVulnerabilityAssessmentsSettingKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"AzureServersSetting": "AzureServersSetting"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class AzureServersSetting(ServerVulnerabilityAssessmentsSetting):
    """A vulnerability assessments setting on Azure servers in the defined scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar kind: The kind of the server vulnerability assessments setting. Required.
     "AzureServersSetting"
    :vartype kind: str or ~azure.mgmt.security.models.ServerVulnerabilityAssessmentsSettingKind
    :ivar selected_provider: The selected vulnerability assessments provider on Azure servers in
     the defined scope. "MdeTvm"
    :vartype selected_provider: str or
     ~azure.mgmt.security.models.ServerVulnerabilityAssessmentsAzureSettingSelectedProvider
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "selected_provider": {"key": "properties.selectedProvider", "type": "str"},
    }

    def __init__(
        self,
        *,
        selected_provider: Optional[
            Union[str, "_models.ServerVulnerabilityAssessmentsAzureSettingSelectedProvider"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword selected_provider: The selected vulnerability assessments provider on Azure servers in
         the defined scope. "MdeTvm"
        :paramtype selected_provider: str or
         ~azure.mgmt.security.models.ServerVulnerabilityAssessmentsAzureSettingSelectedProvider
        """
        super().__init__(**kwargs)
        self.kind: str = "AzureServersSetting"
        self.selected_provider = selected_provider


class Baseline(_serialization.Model):
    """Baseline details.

    :ivar expected_results: Expected results.
    :vartype expected_results: list[list[str]]
    :ivar updated_time: Baseline update time (UTC).
    :vartype updated_time: ~datetime.datetime
    """

    _attribute_map = {
        "expected_results": {"key": "expectedResults", "type": "[[str]]"},
        "updated_time": {"key": "updatedTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        expected_results: Optional[List[List[str]]] = None,
        updated_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword expected_results: Expected results.
        :paramtype expected_results: list[list[str]]
        :keyword updated_time: Baseline update time (UTC).
        :paramtype updated_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.expected_results = expected_results
        self.updated_time = updated_time


class BaselineAdjustedResult(_serialization.Model):
    """The rule result adjusted with baseline.

    :ivar baseline: Baseline details.
    :vartype baseline: ~azure.mgmt.security.models.Baseline
    :ivar status: The rule result status. Known values are: "NonFinding", "Finding", and
     "InternalError".
    :vartype status: str or ~azure.mgmt.security.models.RuleStatus
    :ivar results_not_in_baseline: Results the are not in baseline.
    :vartype results_not_in_baseline: list[list[str]]
    :ivar results_only_in_baseline: Results the are in baseline.
    :vartype results_only_in_baseline: list[list[str]]
    """

    _attribute_map = {
        "baseline": {"key": "baseline", "type": "Baseline"},
        "status": {"key": "status", "type": "str"},
        "results_not_in_baseline": {"key": "resultsNotInBaseline", "type": "[[str]]"},
        "results_only_in_baseline": {"key": "resultsOnlyInBaseline", "type": "[[str]]"},
    }

    def __init__(
        self,
        *,
        baseline: Optional["_models.Baseline"] = None,
        status: Optional[Union[str, "_models.RuleStatus"]] = None,
        results_not_in_baseline: Optional[List[List[str]]] = None,
        results_only_in_baseline: Optional[List[List[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword baseline: Baseline details.
        :paramtype baseline: ~azure.mgmt.security.models.Baseline
        :keyword status: The rule result status. Known values are: "NonFinding", "Finding", and
         "InternalError".
        :paramtype status: str or ~azure.mgmt.security.models.RuleStatus
        :keyword results_not_in_baseline: Results the are not in baseline.
        :paramtype results_not_in_baseline: list[list[str]]
        :keyword results_only_in_baseline: Results the are in baseline.
        :paramtype results_only_in_baseline: list[list[str]]
        """
        super().__init__(**kwargs)
        self.baseline = baseline
        self.status = status
        self.results_not_in_baseline = results_not_in_baseline
        self.results_only_in_baseline = results_only_in_baseline


class BaseResourceConfiguration(_serialization.Model):
    """Base Resource Inventory configuration changes.

    :ivar desired_onboarding_state: Onboarding states. Known values are: "Disabled" and "Enabled".
    :vartype desired_onboarding_state: str or ~azure.mgmt.security.models.DesiredOnboardingState
    """

    _attribute_map = {
        "desired_onboarding_state": {"key": "desiredOnboardingState", "type": "str"},
    }

    def __init__(
        self, *, desired_onboarding_state: Optional[Union[str, "_models.DesiredOnboardingState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword desired_onboarding_state: Onboarding states. Known values are: "Disabled" and
         "Enabled".
        :paramtype desired_onboarding_state: str or ~azure.mgmt.security.models.DesiredOnboardingState
        """
        super().__init__(**kwargs)
        self.desired_onboarding_state = desired_onboarding_state


class BenchmarkReference(_serialization.Model):
    """The benchmark references.

    :ivar benchmark: The benchmark name.
    :vartype benchmark: str
    :ivar reference: The benchmark reference.
    :vartype reference: str
    """

    _attribute_map = {
        "benchmark": {"key": "benchmark", "type": "str"},
        "reference": {"key": "reference", "type": "str"},
    }

    def __init__(self, *, benchmark: Optional[str] = None, reference: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword benchmark: The benchmark name.
        :paramtype benchmark: str
        :keyword reference: The benchmark reference.
        :paramtype reference: str
        """
        super().__init__(**kwargs)
        self.benchmark = benchmark
        self.reference = reference


class BlobsScanSummary(_serialization.Model):
    """A summary of the scan results of the blobs that were scanned.

    :ivar total_blobs_scanned: The total number of blobs that were scanned.
    :vartype total_blobs_scanned: int
    :ivar malicious_blobs_count: The number of malicious blobs that were detected during the scan.
    :vartype malicious_blobs_count: int
    :ivar skipped_blobs_count: The number of blobs that were skipped.
    :vartype skipped_blobs_count: int
    :ivar failed_blobs_count: The number of failed blob scans.
    :vartype failed_blobs_count: int
    :ivar scanned_blobs_in_gb: The number of gigabytes of data that were scanned.
    :vartype scanned_blobs_in_gb: float
    """

    _attribute_map = {
        "total_blobs_scanned": {"key": "totalBlobsScanned", "type": "int"},
        "malicious_blobs_count": {"key": "maliciousBlobsCount", "type": "int"},
        "skipped_blobs_count": {"key": "skippedBlobsCount", "type": "int"},
        "failed_blobs_count": {"key": "failedBlobsCount", "type": "int"},
        "scanned_blobs_in_gb": {"key": "scannedBlobsInGB", "type": "float"},
    }

    def __init__(
        self,
        *,
        total_blobs_scanned: Optional[int] = None,
        malicious_blobs_count: Optional[int] = None,
        skipped_blobs_count: Optional[int] = None,
        failed_blobs_count: Optional[int] = None,
        scanned_blobs_in_gb: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword total_blobs_scanned: The total number of blobs that were scanned.
        :paramtype total_blobs_scanned: int
        :keyword malicious_blobs_count: The number of malicious blobs that were detected during the
         scan.
        :paramtype malicious_blobs_count: int
        :keyword skipped_blobs_count: The number of blobs that were skipped.
        :paramtype skipped_blobs_count: int
        :keyword failed_blobs_count: The number of failed blob scans.
        :paramtype failed_blobs_count: int
        :keyword scanned_blobs_in_gb: The number of gigabytes of data that were scanned.
        :paramtype scanned_blobs_in_gb: float
        """
        super().__init__(**kwargs)
        self.total_blobs_scanned = total_blobs_scanned
        self.malicious_blobs_count = malicious_blobs_count
        self.skipped_blobs_count = skipped_blobs_count
        self.failed_blobs_count = failed_blobs_count
        self.scanned_blobs_in_gb = scanned_blobs_in_gb


class BuiltInInfoType(_serialization.Model):
    """Pre-configured sensitive information type.

    :ivar name: Display name of the info type.
    :vartype name: str
    :ivar id: Id of the info type.
    :vartype id: str
    :ivar type: Category of the built-in info type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Display name of the info type.
        :paramtype name: str
        :keyword id: Id of the info type.
        :paramtype id: str
        :keyword type: Category of the built-in info type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type


class CategoryConfiguration(_serialization.Model):
    """Severity level per category configuration for PR Annotations.

    :ivar minimum_severity_level: Gets or sets minimum severity level for a given category.
    :vartype minimum_severity_level: str
    :ivar category: Rule categories.
     Code - code scanning results.
     Artifact scanning results.
     Dependencies scanning results.
     IaC results.
     Secrets scanning results.
     Container scanning results. Known values are: "Code", "Artifacts", "Dependencies", "Secrets",
     "IaC", and "Containers".
    :vartype category: str or ~azure.mgmt.security.models.RuleCategory
    """

    _attribute_map = {
        "minimum_severity_level": {"key": "minimumSeverityLevel", "type": "str"},
        "category": {"key": "category", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum_severity_level: Optional[str] = None,
        category: Optional[Union[str, "_models.RuleCategory"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minimum_severity_level: Gets or sets minimum severity level for a given category.
        :paramtype minimum_severity_level: str
        :keyword category: Rule categories.
         Code - code scanning results.
         Artifact scanning results.
         Dependencies scanning results.
         IaC results.
         Secrets scanning results.
         Container scanning results. Known values are: "Code", "Artifacts", "Dependencies", "Secrets",
         "IaC", and "Containers".
        :paramtype category: str or ~azure.mgmt.security.models.RuleCategory
        """
        super().__init__(**kwargs)
        self.minimum_severity_level = minimum_severity_level
        self.category = category


class CefExternalSecuritySolution(ExternalSecuritySolution):
    """Represents a security solution which sends CEF logs to an OMS workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
    :vartype kind: str or ~azure.mgmt.security.models.ExternalSecuritySolutionKindEnum
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The external security solution properties for CEF solutions.
    :vartype properties: ~azure.mgmt.security.models.CefSolutionProperties
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "CefSolutionProperties"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.ExternalSecuritySolutionKindEnum"]] = None,
        properties: Optional["_models.CefSolutionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
        :paramtype kind: str or ~azure.mgmt.security.models.ExternalSecuritySolutionKindEnum
        :keyword properties: The external security solution properties for CEF solutions.
        :paramtype properties: ~azure.mgmt.security.models.CefSolutionProperties
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class CefSolutionProperties(ExternalSecuritySolutionProperties):
    """The external security solution properties for CEF solutions.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar device_vendor:
    :vartype device_vendor: str
    :ivar device_type:
    :vartype device_type: str
    :ivar workspace: Represents an OMS workspace to which the solution is connected.
    :vartype workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    :ivar hostname:
    :vartype hostname: str
    :ivar agent:
    :vartype agent: str
    :ivar last_event_received:
    :vartype last_event_received: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "workspace": {"key": "workspace", "type": "ConnectedWorkspace"},
        "hostname": {"key": "hostname", "type": "str"},
        "agent": {"key": "agent", "type": "str"},
        "last_event_received": {"key": "lastEventReceived", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        device_vendor: Optional[str] = None,
        device_type: Optional[str] = None,
        workspace: Optional["_models.ConnectedWorkspace"] = None,
        hostname: Optional[str] = None,
        agent: Optional[str] = None,
        last_event_received: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword device_vendor:
        :paramtype device_vendor: str
        :keyword device_type:
        :paramtype device_type: str
        :keyword workspace: Represents an OMS workspace to which the solution is connected.
        :paramtype workspace: ~azure.mgmt.security.models.ConnectedWorkspace
        :keyword hostname:
        :paramtype hostname: str
        :keyword agent:
        :paramtype agent: str
        :keyword last_event_received:
        :paramtype last_event_received: str
        """
        super().__init__(
            additional_properties=additional_properties,
            device_vendor=device_vendor,
            device_type=device_type,
            workspace=workspace,
            **kwargs
        )
        self.hostname = hostname
        self.agent = agent
        self.last_event_received = last_event_received


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.CloudErrorBody"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class CloudOffering(_serialization.Model):
    """The security offering details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CspmMonitorAwsOffering, CspmMonitorAzureDevOpsOffering, CspmMonitorDockerHubOffering,
    CspmMonitorGcpOffering, CspmMonitorGitLabOffering, CspmMonitorGithubOffering,
    CspmMonitorJFrogOffering, DefenderCspmAwsOffering, DefenderCspmDockerHubOffering,
    DefenderCspmGcpOffering, DefenderCspmJFrogOffering, DefenderForContainersAwsOffering,
    DefenderForContainersDockerHubOffering, DefenderForContainersGcpOffering,
    DefenderForContainersJFrogOffering, DefenderFoDatabasesAwsOffering,
    DefenderForDatabasesGcpOffering, DefenderForServersAwsOffering, DefenderForServersGcpOffering

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    _subtype_map = {
        "offering_type": {
            "CspmMonitorAws": "CspmMonitorAwsOffering",
            "CspmMonitorAzureDevOps": "CspmMonitorAzureDevOpsOffering",
            "CspmMonitorDockerHub": "CspmMonitorDockerHubOffering",
            "CspmMonitorGcp": "CspmMonitorGcpOffering",
            "CspmMonitorGitLab": "CspmMonitorGitLabOffering",
            "CspmMonitorGithub": "CspmMonitorGithubOffering",
            "CspmMonitorJFrog": "CspmMonitorJFrogOffering",
            "DefenderCspmAws": "DefenderCspmAwsOffering",
            "DefenderCspmDockerHub": "DefenderCspmDockerHubOffering",
            "DefenderCspmGcp": "DefenderCspmGcpOffering",
            "DefenderCspmJFrog": "DefenderCspmJFrogOffering",
            "DefenderForContainersAws": "DefenderForContainersAwsOffering",
            "DefenderForContainersDockerHub": "DefenderForContainersDockerHubOffering",
            "DefenderForContainersGcp": "DefenderForContainersGcpOffering",
            "DefenderForContainersJFrog": "DefenderForContainersJFrogOffering",
            "DefenderForDatabasesAws": "DefenderFoDatabasesAwsOffering",
            "DefenderForDatabasesGcp": "DefenderForDatabasesGcpOffering",
            "DefenderForServersAws": "DefenderForServersAwsOffering",
            "DefenderForServersGcp": "DefenderForServersGcpOffering",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: Optional[str] = None
        self.description: Optional[str] = None


class Compliance(Resource):
    """Compliance of a scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar assessment_timestamp_utc_date: The timestamp when the Compliance calculation was
     conducted.
    :vartype assessment_timestamp_utc_date: ~datetime.datetime
    :ivar resource_count: The resource count of the given subscription for which the Compliance
     calculation was conducted (needed for Management Group Compliance calculation).
    :vartype resource_count: int
    :ivar assessment_result: An array of segment, which is the actually the compliance assessment.
    :vartype assessment_result: list[~azure.mgmt.security.models.ComplianceSegment]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "assessment_timestamp_utc_date": {"readonly": True},
        "resource_count": {"readonly": True},
        "assessment_result": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "assessment_timestamp_utc_date": {"key": "properties.assessmentTimestampUtcDate", "type": "iso-8601"},
        "resource_count": {"key": "properties.resourceCount", "type": "int"},
        "assessment_result": {"key": "properties.assessmentResult", "type": "[ComplianceSegment]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessment_timestamp_utc_date: Optional[datetime.datetime] = None
        self.resource_count: Optional[int] = None
        self.assessment_result: Optional[List["_models.ComplianceSegment"]] = None


class ComplianceList(_serialization.Model):
    """List of Compliance objects response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Compliance objects.
    :vartype value: list[~azure.mgmt.security.models.Compliance]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Compliance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Compliance"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of Compliance objects.
        :paramtype value: list[~azure.mgmt.security.models.Compliance]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ComplianceResult(Resource):
    """a compliance result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_status: The status of the resource regarding a single assessment. Known values
     are: "Healthy", "NotApplicable", "OffByPolicy", and "NotHealthy".
    :vartype resource_status: str or ~azure.mgmt.security.models.ResourceStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_status": {"key": "properties.resourceStatus", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_status: Optional[Union[str, "_models.ResourceStatus"]] = None


class ComplianceResultList(_serialization.Model):
    """List of compliance results response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: List of compliance results. Required.
    :vartype value: list[~azure.mgmt.security.models.ComplianceResult]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ComplianceResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ComplianceResult"], **kwargs: Any) -> None:
        """
        :keyword value: List of compliance results. Required.
        :paramtype value: list[~azure.mgmt.security.models.ComplianceResult]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ComplianceSegment(_serialization.Model):
    """A segment of a compliance assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar segment_type: The segment type, e.g. compliant, non-compliance, insufficient coverage,
     N/A, etc.
    :vartype segment_type: str
    :ivar percentage: The size (%) of the segment.
    :vartype percentage: float
    """

    _validation = {
        "segment_type": {"readonly": True},
        "percentage": {"readonly": True},
    }

    _attribute_map = {
        "segment_type": {"key": "segmentType", "type": "str"},
        "percentage": {"key": "percentage", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.segment_type: Optional[str] = None
        self.percentage: Optional[float] = None


class Components1Uu4J47SchemasSecurityassessmentpropertiesbasePropertiesRiskPropertiesPathsItemsPropertiesEdgesItems(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Components1Uu4J47SchemasSecurityassessmentpropertiesbasePropertiesRiskPropertiesPathsItemsPropertiesEdgesItems.

    All required parameters must be populated in order to send to server.

    :ivar id: Edge identifier. Required.
    :vartype id: str
    :ivar target_id: Target node identifier. Required.
    :vartype target_id: str
    :ivar source_id: Source node identifier. Required.
    :vartype source_id: str
    """

    _validation = {
        "id": {"required": True},
        "target_id": {"required": True},
        "source_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "target_id": {"key": "targetId", "type": "str"},
        "source_id": {"key": "sourceId", "type": "str"},
    }

    def __init__(
        self, *, id: str, target_id: str, source_id: str, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Edge identifier. Required.
        :paramtype id: str
        :keyword target_id: Target node identifier. Required.
        :paramtype target_id: str
        :keyword source_id: Source node identifier. Required.
        :paramtype source_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.target_id = target_id
        self.source_id = source_id


class Condition(_serialization.Model):
    """Governance rule's condition.

    :ivar property: The governance rule Condition's Property, e.g. Severity or AssessmentKey, see
     examples.
    :vartype property: str
    :ivar value: The governance rule Condition's Value like severity Low, High or assessments keys,
     see examples.
    :vartype value: str
    :ivar operator: The governance rule Condition's Operator, for example Equals for severity or In
     for list of assessments, see examples. Known values are: "Equals", "In", and "In".
    :vartype operator: str or ~azure.mgmt.security.models.GovernanceRuleConditionOperator
    """

    _attribute_map = {
        "property": {"key": "property", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
    }

    def __init__(
        self,
        *,
        property: Optional[str] = None,  # pylint: disable=redefined-builtin
        value: Optional[str] = None,
        operator: Optional[Union[str, "_models.GovernanceRuleConditionOperator"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword property: The governance rule Condition's Property, e.g. Severity or AssessmentKey,
         see examples.
        :paramtype property: str
        :keyword value: The governance rule Condition's Value like severity Low, High or assessments
         keys, see examples.
        :paramtype value: str
        :keyword operator: The governance rule Condition's Operator, for example Equals for severity or
         In for list of assessments, see examples. Known values are: "Equals", "In", and "In".
        :paramtype operator: str or ~azure.mgmt.security.models.GovernanceRuleConditionOperator
        """
        super().__init__(**kwargs)
        self.property = property
        self.value = value
        self.operator = operator


class ConnectableResource(_serialization.Model):
    """Describes the allowed inbound and outbound traffic of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure resource id.
    :vartype id: str
    :ivar inbound_connected_resources: The list of Azure resources that the resource has inbound
     allowed connection from.
    :vartype inbound_connected_resources: list[~azure.mgmt.security.models.ConnectedResource]
    :ivar outbound_connected_resources: The list of Azure resources that the resource has outbound
     allowed connection to.
    :vartype outbound_connected_resources: list[~azure.mgmt.security.models.ConnectedResource]
    """

    _validation = {
        "id": {"readonly": True},
        "inbound_connected_resources": {"readonly": True},
        "outbound_connected_resources": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "inbound_connected_resources": {"key": "inboundConnectedResources", "type": "[ConnectedResource]"},
        "outbound_connected_resources": {"key": "outboundConnectedResources", "type": "[ConnectedResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.inbound_connected_resources: Optional[List["_models.ConnectedResource"]] = None
        self.outbound_connected_resources: Optional[List["_models.ConnectedResource"]] = None


class ConnectedResource(_serialization.Model):
    """Describes properties of a connected resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar connected_resource_id: The Azure resource id of the connected resource.
    :vartype connected_resource_id: str
    :ivar tcp_ports: The allowed tcp ports.
    :vartype tcp_ports: str
    :ivar udp_ports: The allowed udp ports.
    :vartype udp_ports: str
    """

    _validation = {
        "connected_resource_id": {"readonly": True},
        "tcp_ports": {"readonly": True},
        "udp_ports": {"readonly": True},
    }

    _attribute_map = {
        "connected_resource_id": {"key": "connectedResourceId", "type": "str"},
        "tcp_ports": {"key": "tcpPorts", "type": "str"},
        "udp_ports": {"key": "udpPorts", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.connected_resource_id: Optional[str] = None
        self.tcp_ports: Optional[str] = None
        self.udp_ports: Optional[str] = None


class ConnectedWorkspace(_serialization.Model):
    """Represents an OMS workspace to which the solution is connected.

    :ivar id: Azure resource ID of the connected OMS workspace.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Azure resource ID of the connected OMS workspace.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ConnectionFromIpNotAllowed(AllowlistCustomAlertRule):
    """Inbound connection from an ip that isn't allowed. Allow list consists of ipv4 or ipv6 range in
    CIDR notation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :ivar allowlist_values: The values to allow. The format of the values depends on the rule type.
     Required.
    :vartype allowlist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "allowlist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "allowlist_values": {"key": "allowlistValues", "type": "[str]"},
    }

    def __init__(self, *, is_enabled: bool, allowlist_values: List[str], **kwargs: Any) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword allowlist_values: The values to allow. The format of the values depends on the rule
         type. Required.
        :paramtype allowlist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, allowlist_values=allowlist_values, **kwargs)
        self.rule_type: str = "ConnectionFromIpNotAllowed"


class ConnectionToIpNotAllowed(AllowlistCustomAlertRule):
    """Outbound connection to an ip that isn't allowed. Allow list consists of ipv4 or ipv6 range in
    CIDR notation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :ivar allowlist_values: The values to allow. The format of the values depends on the rule type.
     Required.
    :vartype allowlist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "allowlist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "allowlist_values": {"key": "allowlistValues", "type": "[str]"},
    }

    def __init__(self, *, is_enabled: bool, allowlist_values: List[str], **kwargs: Any) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword allowlist_values: The values to allow. The format of the values depends on the rule
         type. Required.
        :paramtype allowlist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, allowlist_values=allowlist_values, **kwargs)
        self.rule_type: str = "ConnectionToIpNotAllowed"


class ConnectorSetting(Resource):
    """The connector setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar hybrid_compute_settings: Settings for hybrid compute management. These settings are
     relevant only for Arc autoProvision (Hybrid Compute).
    :vartype hybrid_compute_settings: ~azure.mgmt.security.models.HybridComputeSettingsProperties
    :ivar authentication_details: Settings for authentication management, these settings are
     relevant only for the cloud connector.
    :vartype authentication_details: ~azure.mgmt.security.models.AuthenticationDetailsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "hybrid_compute_settings": {
            "key": "properties.hybridComputeSettings",
            "type": "HybridComputeSettingsProperties",
        },
        "authentication_details": {
            "key": "properties.authenticationDetails",
            "type": "AuthenticationDetailsProperties",
        },
    }

    def __init__(
        self,
        *,
        hybrid_compute_settings: Optional["_models.HybridComputeSettingsProperties"] = None,
        authentication_details: Optional["_models.AuthenticationDetailsProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword hybrid_compute_settings: Settings for hybrid compute management. These settings are
         relevant only for Arc autoProvision (Hybrid Compute).
        :paramtype hybrid_compute_settings: ~azure.mgmt.security.models.HybridComputeSettingsProperties
        :keyword authentication_details: Settings for authentication management, these settings are
         relevant only for the cloud connector.
        :paramtype authentication_details: ~azure.mgmt.security.models.AuthenticationDetailsProperties
        """
        super().__init__(**kwargs)
        self.hybrid_compute_settings = hybrid_compute_settings
        self.authentication_details = authentication_details


class ConnectorSettingList(_serialization.Model):
    """For a subscription, list of all cloud account connectors and their settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of all the cloud account connector settings.
    :vartype value: list[~azure.mgmt.security.models.ConnectorSetting]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectorSetting]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ConnectorSetting"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of all the cloud account connector settings.
        :paramtype value: list[~azure.mgmt.security.models.ConnectorSetting]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ContainerRegistryVulnerabilityProperties(AdditionalData):
    """Additional context fields for container registry Vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar assessed_resource_type: Sub-assessment resource type. Required. Known values are:
     "SqlServerVulnerability", "ContainerRegistryVulnerability", and "ServerVulnerability".
    :vartype assessed_resource_type: str or ~azure.mgmt.security.models.AssessedResourceType
    :ivar type: Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information
     Gathered, Vulnerability.
    :vartype type: str
    :ivar cvss: Dictionary from cvss version to cvss details object.
    :vartype cvss: dict[str, ~azure.mgmt.security.models.CVSS]
    :ivar patchable: Indicates whether a patch is available or not.
    :vartype patchable: bool
    :ivar cve: List of CVEs.
    :vartype cve: list[~azure.mgmt.security.models.CVE]
    :ivar published_time: Published time.
    :vartype published_time: ~datetime.datetime
    :ivar vendor_references:
    :vartype vendor_references: list[~azure.mgmt.security.models.VendorReference]
    :ivar repository_name: Name of the repository which the vulnerable image belongs to.
    :vartype repository_name: str
    :ivar image_digest: Digest of the vulnerable image.
    :vartype image_digest: str
    """

    _validation = {
        "assessed_resource_type": {"required": True},
        "type": {"readonly": True},
        "cvss": {"readonly": True},
        "patchable": {"readonly": True},
        "cve": {"readonly": True},
        "published_time": {"readonly": True},
        "vendor_references": {"readonly": True},
        "repository_name": {"readonly": True},
        "image_digest": {"readonly": True},
    }

    _attribute_map = {
        "assessed_resource_type": {"key": "assessedResourceType", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "cvss": {"key": "cvss", "type": "{CVSS}"},
        "patchable": {"key": "patchable", "type": "bool"},
        "cve": {"key": "cve", "type": "[CVE]"},
        "published_time": {"key": "publishedTime", "type": "iso-8601"},
        "vendor_references": {"key": "vendorReferences", "type": "[VendorReference]"},
        "repository_name": {"key": "repositoryName", "type": "str"},
        "image_digest": {"key": "imageDigest", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessed_resource_type: str = "ContainerRegistryVulnerability"
        self.type: Optional[str] = None
        self.cvss: Optional[Dict[str, "_models.CVSS"]] = None
        self.patchable: Optional[bool] = None
        self.cve: Optional[List["_models.CVE"]] = None
        self.published_time: Optional[datetime.datetime] = None
        self.vendor_references: Optional[List["_models.VendorReference"]] = None
        self.repository_name: Optional[str] = None
        self.image_digest: Optional[str] = None


class CspmMonitorAwsOffering(CloudOffering):
    """The CSPM monitoring for AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar native_cloud_connection: The native cloud connection configuration.
    :vartype native_cloud_connection:
     ~azure.mgmt.security.models.CspmMonitorAwsOfferingNativeCloudConnection
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "native_cloud_connection": {
            "key": "nativeCloudConnection",
            "type": "CspmMonitorAwsOfferingNativeCloudConnection",
        },
    }

    def __init__(
        self,
        *,
        native_cloud_connection: Optional["_models.CspmMonitorAwsOfferingNativeCloudConnection"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword native_cloud_connection: The native cloud connection configuration.
        :paramtype native_cloud_connection:
         ~azure.mgmt.security.models.CspmMonitorAwsOfferingNativeCloudConnection
        """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorAws"
        self.native_cloud_connection = native_cloud_connection


class CspmMonitorAwsOfferingNativeCloudConnection(_serialization.Model):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class CspmMonitorAzureDevOpsOffering(CloudOffering):
    """The CSPM monitoring for AzureDevOps offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorAzureDevOps"


class CspmMonitorDockerHubOffering(CloudOffering):
    """The CSPM (Cloud security posture management) monitoring for Docker Hub offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorDockerHub"


class CspmMonitorGcpOffering(CloudOffering):
    """The CSPM monitoring for GCP offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar native_cloud_connection: The native cloud connection configuration.
    :vartype native_cloud_connection:
     ~azure.mgmt.security.models.CspmMonitorGcpOfferingNativeCloudConnection
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "native_cloud_connection": {
            "key": "nativeCloudConnection",
            "type": "CspmMonitorGcpOfferingNativeCloudConnection",
        },
    }

    def __init__(
        self,
        *,
        native_cloud_connection: Optional["_models.CspmMonitorGcpOfferingNativeCloudConnection"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword native_cloud_connection: The native cloud connection configuration.
        :paramtype native_cloud_connection:
         ~azure.mgmt.security.models.CspmMonitorGcpOfferingNativeCloudConnection
        """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorGcp"
        self.native_cloud_connection = native_cloud_connection


class CspmMonitorGcpOfferingNativeCloudConnection(_serialization.Model):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar workload_identity_provider_id: The GCP workload identity provider id for the offering.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this
     offering.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword workload_identity_provider_id: The GCP workload identity provider id for the offering.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         offering.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class CspmMonitorGithubOffering(CloudOffering):
    """The CSPM monitoring for github offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorGithub"


class CspmMonitorGitLabOffering(CloudOffering):
    """The CSPM (Cloud security posture management) monitoring for gitlab offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorGitLab"


class CspmMonitorJFrogOffering(CloudOffering):
    """The CSPM (Cloud security posture management) monitoring for JFrog Artifactory offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorJFrog"


class CustomAssessmentAutomation(Resource):
    """Custom Assessment Automation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar compressed_query: GZip encoded KQL query representing the assessment automation results
     required.
    :vartype compressed_query: str
    :ivar supported_cloud: Relevant cloud for the custom assessment automation. Known values are:
     "AWS" and "GCP".
    :vartype supported_cloud: str or ~azure.mgmt.security.models.SupportedCloudEnum
    :ivar severity: The severity to relate to the assessments generated by this assessment
     automation. Known values are: "High", "Medium", and "Low".
    :vartype severity: str or ~azure.mgmt.security.models.SeverityEnum
    :ivar display_name: The display name of the assessments generated by this assessment
     automation.
    :vartype display_name: str
    :ivar description: The description to relate to the assessments generated by this assessment
     automation.
    :vartype description: str
    :ivar remediation_description: The remediation description to relate to the assessments
     generated by this assessment automation.
    :vartype remediation_description: str
    :ivar assessment_key: The assessment metadata key used when an assessment is generated for this
     assessment automation.
    :vartype assessment_key: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "compressed_query": {"key": "properties.compressedQuery", "type": "str"},
        "supported_cloud": {"key": "properties.supportedCloud", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_description": {"key": "properties.remediationDescription", "type": "str"},
        "assessment_key": {"key": "properties.assessmentKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        compressed_query: Optional[str] = None,
        supported_cloud: Union[str, "_models.SupportedCloudEnum"] = "AWS",
        severity: Union[str, "_models.SeverityEnum"] = "Low",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        assessment_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword compressed_query: GZip encoded KQL query representing the assessment automation
         results required.
        :paramtype compressed_query: str
        :keyword supported_cloud: Relevant cloud for the custom assessment automation. Known values
         are: "AWS" and "GCP".
        :paramtype supported_cloud: str or ~azure.mgmt.security.models.SupportedCloudEnum
        :keyword severity: The severity to relate to the assessments generated by this assessment
         automation. Known values are: "High", "Medium", and "Low".
        :paramtype severity: str or ~azure.mgmt.security.models.SeverityEnum
        :keyword display_name: The display name of the assessments generated by this assessment
         automation.
        :paramtype display_name: str
        :keyword description: The description to relate to the assessments generated by this assessment
         automation.
        :paramtype description: str
        :keyword remediation_description: The remediation description to relate to the assessments
         generated by this assessment automation.
        :paramtype remediation_description: str
        :keyword assessment_key: The assessment metadata key used when an assessment is generated for
         this assessment automation.
        :paramtype assessment_key: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.compressed_query = compressed_query
        self.supported_cloud = supported_cloud
        self.severity = severity
        self.display_name = display_name
        self.description = description
        self.remediation_description = remediation_description
        self.assessment_key = assessment_key


class CustomAssessmentAutomationRequest(Resource):
    """Custom Assessment Automation request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar compressed_query: Base 64 encoded KQL query representing the assessment automation
     results required.
    :vartype compressed_query: str
    :ivar supported_cloud: Relevant cloud for the custom assessment automation. Known values are:
     "AWS" and "GCP".
    :vartype supported_cloud: str or ~azure.mgmt.security.models.SupportedCloudEnum
    :ivar severity: The severity to relate to the assessments generated by this assessment
     automation. Known values are: "High", "Medium", and "Low".
    :vartype severity: str or ~azure.mgmt.security.models.SeverityEnum
    :ivar display_name: The display name of the assessments generated by this assessment
     automation.
    :vartype display_name: str
    :ivar description: The description to relate to the assessments generated by this assessment
     automation.
    :vartype description: str
    :ivar remediation_description: The remediation description to relate to the assessments
     generated by this assessment automation.
    :vartype remediation_description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "compressed_query": {"key": "properties.compressedQuery", "type": "str"},
        "supported_cloud": {"key": "properties.supportedCloud", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_description": {"key": "properties.remediationDescription", "type": "str"},
    }

    def __init__(
        self,
        *,
        compressed_query: Optional[str] = None,
        supported_cloud: Union[str, "_models.SupportedCloudEnum"] = "AWS",
        severity: Union[str, "_models.SeverityEnum"] = "Low",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword compressed_query: Base 64 encoded KQL query representing the assessment automation
         results required.
        :paramtype compressed_query: str
        :keyword supported_cloud: Relevant cloud for the custom assessment automation. Known values
         are: "AWS" and "GCP".
        :paramtype supported_cloud: str or ~azure.mgmt.security.models.SupportedCloudEnum
        :keyword severity: The severity to relate to the assessments generated by this assessment
         automation. Known values are: "High", "Medium", and "Low".
        :paramtype severity: str or ~azure.mgmt.security.models.SeverityEnum
        :keyword display_name: The display name of the assessments generated by this assessment
         automation.
        :paramtype display_name: str
        :keyword description: The description to relate to the assessments generated by this assessment
         automation.
        :paramtype description: str
        :keyword remediation_description: The remediation description to relate to the assessments
         generated by this assessment automation.
        :paramtype remediation_description: str
        """
        super().__init__(**kwargs)
        self.compressed_query = compressed_query
        self.supported_cloud = supported_cloud
        self.severity = severity
        self.display_name = display_name
        self.description = description
        self.remediation_description = remediation_description


class CustomAssessmentAutomationsListResult(_serialization.Model):
    """A list of Custom Assessment Automations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of Custom Assessment Automations.
    :vartype value: list[~azure.mgmt.security.models.CustomAssessmentAutomation]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomAssessmentAutomation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.CustomAssessmentAutomation"]] = None
        self.next_link = next_link


class CustomEntityStoreAssignment(Resource):
    """Custom entity store assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar principal: The principal assigned with entity store. Format of principal is: [AAD
     type]=[PrincipalObjectId];[TenantId].
    :vartype principal: str
    :ivar entity_store_database_link: The link to entity store database.
    :vartype entity_store_database_link: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "principal": {"key": "properties.principal", "type": "str"},
        "entity_store_database_link": {"key": "properties.entityStoreDatabaseLink", "type": "str"},
    }

    def __init__(
        self, *, principal: Optional[str] = None, entity_store_database_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword principal: The principal assigned with entity store. Format of principal is: [AAD
         type]=[PrincipalObjectId];[TenantId].
        :paramtype principal: str
        :keyword entity_store_database_link: The link to entity store database.
        :paramtype entity_store_database_link: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.principal = principal
        self.entity_store_database_link = entity_store_database_link


class CustomEntityStoreAssignmentRequest(_serialization.Model):
    """describes the custom entity store assignment request.

    :ivar principal: The principal assigned with entity store. If not provided, will use caller
     principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId].
    :vartype principal: str
    """

    _attribute_map = {
        "principal": {"key": "properties.principal", "type": "str"},
    }

    def __init__(self, *, principal: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword principal: The principal assigned with entity store. If not provided, will use caller
         principal. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId].
        :paramtype principal: str
        """
        super().__init__(**kwargs)
        self.principal = principal


class CustomEntityStoreAssignmentsListResult(_serialization.Model):
    """A list of custom entity store assignments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of custom entity store assignments.
    :vartype value: list[~azure.mgmt.security.models.CustomEntityStoreAssignment]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomEntityStoreAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.CustomEntityStoreAssignment"]] = None
        self.next_link = next_link


class CustomRecommendation(Resource):
    """Custom Recommendation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar query: KQL query representing the Recommendation results required.
    :vartype query: str
    :ivar cloud_providers: List of all standard supported clouds.
    :vartype cloud_providers: list[str or
     ~azure.mgmt.security.models.RecommendationSupportedClouds]
    :ivar severity: The severity to relate to the assessments generated by this Recommendation.
     Known values are: "High", "Medium", and "Low".
    :vartype severity: str or ~azure.mgmt.security.models.SeverityEnum
    :ivar security_issue: The severity to relate to the assessments generated by this
     Recommendation. Known values are: "Vulnerability", "ExcessivePermissions", "AnonymousAccess",
     "NetworkExposure", "TrafficEncryption", and "BestPractices".
    :vartype security_issue: str or ~azure.mgmt.security.models.SecurityIssue
    :ivar display_name: The display name of the assessments generated by this Recommendation.
    :vartype display_name: str
    :ivar description: The description to relate to the assessments generated by this
     Recommendation.
    :vartype description: str
    :ivar remediation_description: The remediation description to relate to the assessments
     generated by this Recommendation.
    :vartype remediation_description: str
    :ivar assessment_key: The assessment metadata key used when an assessment is generated for this
     Recommendation.
    :vartype assessment_key: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "assessment_key": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "query": {"key": "properties.query", "type": "str"},
        "cloud_providers": {"key": "properties.cloudProviders", "type": "[str]"},
        "severity": {"key": "properties.severity", "type": "str"},
        "security_issue": {"key": "properties.securityIssue", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_description": {"key": "properties.remediationDescription", "type": "str"},
        "assessment_key": {"key": "properties.assessmentKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        cloud_providers: Optional[List[Union[str, "_models.RecommendationSupportedClouds"]]] = None,
        severity: Union[str, "_models.SeverityEnum"] = "Low",
        security_issue: Union[str, "_models.SecurityIssue"] = "BestPractices",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query: KQL query representing the Recommendation results required.
        :paramtype query: str
        :keyword cloud_providers: List of all standard supported clouds.
        :paramtype cloud_providers: list[str or
         ~azure.mgmt.security.models.RecommendationSupportedClouds]
        :keyword severity: The severity to relate to the assessments generated by this Recommendation.
         Known values are: "High", "Medium", and "Low".
        :paramtype severity: str or ~azure.mgmt.security.models.SeverityEnum
        :keyword security_issue: The severity to relate to the assessments generated by this
         Recommendation. Known values are: "Vulnerability", "ExcessivePermissions", "AnonymousAccess",
         "NetworkExposure", "TrafficEncryption", and "BestPractices".
        :paramtype security_issue: str or ~azure.mgmt.security.models.SecurityIssue
        :keyword display_name: The display name of the assessments generated by this Recommendation.
        :paramtype display_name: str
        :keyword description: The description to relate to the assessments generated by this
         Recommendation.
        :paramtype description: str
        :keyword remediation_description: The remediation description to relate to the assessments
         generated by this Recommendation.
        :paramtype remediation_description: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.query = query
        self.cloud_providers = cloud_providers
        self.severity = severity
        self.security_issue = security_issue
        self.display_name = display_name
        self.description = description
        self.remediation_description = remediation_description
        self.assessment_key: Optional[str] = None


class CustomRecommendationsList(_serialization.Model):
    """A list of Custom Recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of Custom Recommendations. Required.
    :vartype value: list[~azure.mgmt.security.models.CustomRecommendation]
    :ivar next_link: The link used to get the next page of operations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomRecommendation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The link used to get the next page of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.CustomRecommendation"]] = None
        self.next_link = next_link


class CVE(_serialization.Model):
    """CVE details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar title: CVE title.
    :vartype title: str
    :ivar link: Link url.
    :vartype link: str
    """

    _validation = {
        "title": {"readonly": True},
        "link": {"readonly": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "link": {"key": "link", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.title: Optional[str] = None
        self.link: Optional[str] = None


class CVSS(_serialization.Model):
    """CVSS details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar base: CVSS base.
    :vartype base: float
    """

    _validation = {
        "base": {"readonly": True},
    }

    _attribute_map = {
        "base": {"key": "base", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.base: Optional[float] = None


class DataExportSettings(Setting):
    """Represents a data export setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: the kind of the settings string. Required. Known values are: "DataExportSettings",
     "AlertSuppressionSetting", and "AlertSyncSettings".
    :vartype kind: str or ~azure.mgmt.security.models.SettingKind
    :ivar enabled: Is the data export setting enabled.
    :vartype enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is the data export setting enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.kind: str = "DataExportSettings"
        self.enabled = enabled


class DefenderCspmAwsOffering(CloudOffering):
    """The CSPM P1 for AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar vm_scanners: The Microsoft Defender for CSPM offering VM scanning configuration.
    :vartype vm_scanners: ~azure.mgmt.security.models.DefenderCspmAwsOfferingVmScanners
    :ivar data_sensitivity_discovery: The Microsoft Defender Data Sensitivity discovery
     configuration.
    :vartype data_sensitivity_discovery:
     ~azure.mgmt.security.models.DefenderCspmAwsOfferingDataSensitivityDiscovery
    :ivar databases_dspm: The databases DSPM configuration.
    :vartype databases_dspm: ~azure.mgmt.security.models.DefenderCspmAwsOfferingDatabasesDspm
    :ivar ciem: Defenders CSPM Permissions Management offering configurations.
    :vartype ciem: ~azure.mgmt.security.models.DefenderCspmAwsOfferingCiem
    :ivar mdc_containers_image_assessment: The Microsoft Defender container image assessment
     configuration.
    :vartype mdc_containers_image_assessment:
     ~azure.mgmt.security.models.DefenderCspmAwsOfferingMdcContainersImageAssessment
    :ivar mdc_containers_agentless_discovery_k8_s: The Microsoft Defender container agentless
     discovery K8s configuration.
    :vartype mdc_containers_agentless_discovery_k8_s:
     ~azure.mgmt.security.models.DefenderCspmAwsOfferingMdcContainersAgentlessDiscoveryK8S
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "vm_scanners": {"key": "vmScanners", "type": "DefenderCspmAwsOfferingVmScanners"},
        "data_sensitivity_discovery": {
            "key": "dataSensitivityDiscovery",
            "type": "DefenderCspmAwsOfferingDataSensitivityDiscovery",
        },
        "databases_dspm": {"key": "databasesDspm", "type": "DefenderCspmAwsOfferingDatabasesDspm"},
        "ciem": {"key": "ciem", "type": "DefenderCspmAwsOfferingCiem"},
        "mdc_containers_image_assessment": {
            "key": "mdcContainersImageAssessment",
            "type": "DefenderCspmAwsOfferingMdcContainersImageAssessment",
        },
        "mdc_containers_agentless_discovery_k8_s": {
            "key": "mdcContainersAgentlessDiscoveryK8s",
            "type": "DefenderCspmAwsOfferingMdcContainersAgentlessDiscoveryK8S",
        },
    }

    def __init__(
        self,
        *,
        vm_scanners: Optional["_models.DefenderCspmAwsOfferingVmScanners"] = None,
        data_sensitivity_discovery: Optional["_models.DefenderCspmAwsOfferingDataSensitivityDiscovery"] = None,
        databases_dspm: Optional["_models.DefenderCspmAwsOfferingDatabasesDspm"] = None,
        ciem: Optional["_models.DefenderCspmAwsOfferingCiem"] = None,
        mdc_containers_image_assessment: Optional["_models.DefenderCspmAwsOfferingMdcContainersImageAssessment"] = None,
        mdc_containers_agentless_discovery_k8_s: Optional[
            "_models.DefenderCspmAwsOfferingMdcContainersAgentlessDiscoveryK8S"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_scanners: The Microsoft Defender for CSPM offering VM scanning configuration.
        :paramtype vm_scanners: ~azure.mgmt.security.models.DefenderCspmAwsOfferingVmScanners
        :keyword data_sensitivity_discovery: The Microsoft Defender Data Sensitivity discovery
         configuration.
        :paramtype data_sensitivity_discovery:
         ~azure.mgmt.security.models.DefenderCspmAwsOfferingDataSensitivityDiscovery
        :keyword databases_dspm: The databases DSPM configuration.
        :paramtype databases_dspm: ~azure.mgmt.security.models.DefenderCspmAwsOfferingDatabasesDspm
        :keyword ciem: Defenders CSPM Permissions Management offering configurations.
        :paramtype ciem: ~azure.mgmt.security.models.DefenderCspmAwsOfferingCiem
        :keyword mdc_containers_image_assessment: The Microsoft Defender container image assessment
         configuration.
        :paramtype mdc_containers_image_assessment:
         ~azure.mgmt.security.models.DefenderCspmAwsOfferingMdcContainersImageAssessment
        :keyword mdc_containers_agentless_discovery_k8_s: The Microsoft Defender container agentless
         discovery K8s configuration.
        :paramtype mdc_containers_agentless_discovery_k8_s:
         ~azure.mgmt.security.models.DefenderCspmAwsOfferingMdcContainersAgentlessDiscoveryK8S
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderCspmAws"
        self.vm_scanners = vm_scanners
        self.data_sensitivity_discovery = data_sensitivity_discovery
        self.databases_dspm = databases_dspm
        self.ciem = ciem
        self.mdc_containers_image_assessment = mdc_containers_image_assessment
        self.mdc_containers_agentless_discovery_k8_s = mdc_containers_agentless_discovery_k8_s


class DefenderCspmAwsOfferingCiem(_serialization.Model):
    """Defenders CSPM Permissions Management offering configurations.

    :ivar ciem_discovery: Defender CSPM Permissions Management discovery configuration.
    :vartype ciem_discovery: ~azure.mgmt.security.models.DefenderCspmAwsOfferingCiemDiscovery
    :ivar ciem_oidc: AWS Defender CSPM Permissions Management OIDC (open id connect) connection
     configurations.
    :vartype ciem_oidc: ~azure.mgmt.security.models.DefenderCspmAwsOfferingCiemOidc
    """

    _attribute_map = {
        "ciem_discovery": {"key": "ciemDiscovery", "type": "DefenderCspmAwsOfferingCiemDiscovery"},
        "ciem_oidc": {"key": "ciemOidc", "type": "DefenderCspmAwsOfferingCiemOidc"},
    }

    def __init__(
        self,
        *,
        ciem_discovery: Optional["_models.DefenderCspmAwsOfferingCiemDiscovery"] = None,
        ciem_oidc: Optional["_models.DefenderCspmAwsOfferingCiemOidc"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ciem_discovery: Defender CSPM Permissions Management discovery configuration.
        :paramtype ciem_discovery: ~azure.mgmt.security.models.DefenderCspmAwsOfferingCiemDiscovery
        :keyword ciem_oidc: AWS Defender CSPM Permissions Management OIDC (open id connect) connection
         configurations.
        :paramtype ciem_oidc: ~azure.mgmt.security.models.DefenderCspmAwsOfferingCiemOidc
        """
        super().__init__(**kwargs)
        self.ciem_discovery = ciem_discovery
        self.ciem_oidc = ciem_oidc


class DefenderCspmAwsOfferingCiemDiscovery(_serialization.Model):
    """Defender CSPM Permissions Management discovery configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for Permissions Management discovery.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for Permissions Management discovery.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderCspmAwsOfferingCiemOidc(_serialization.Model):
    """AWS Defender CSPM Permissions Management OIDC (open id connect) connection configurations.

    :ivar cloud_role_arn: The cloud role ARN in AWS for Permissions Management used for oidc
     connection.
    :vartype cloud_role_arn: str
    :ivar azure_active_directory_app_name: the azure active directory app name used of
     authenticating against AWS.
    :vartype azure_active_directory_app_name: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
        "azure_active_directory_app_name": {"key": "azureActiveDirectoryAppName", "type": "str"},
    }

    def __init__(
        self,
        *,
        cloud_role_arn: Optional[str] = None,
        azure_active_directory_app_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for Permissions Management used for oidc
         connection.
        :paramtype cloud_role_arn: str
        :keyword azure_active_directory_app_name: the azure active directory app name used of
         authenticating against AWS.
        :paramtype azure_active_directory_app_name: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn
        self.azure_active_directory_app_name = azure_active_directory_app_name


class DefenderCspmAwsOfferingDatabasesDspm(_serialization.Model):
    """The databases DSPM configuration.

    :ivar enabled: Is databases DSPM protection enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is databases DSPM protection enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderCspmAwsOfferingDataSensitivityDiscovery(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender Data Sensitivity discovery configuration.

    :ivar enabled: Is Microsoft Defender Data Sensitivity discovery enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender Data Sensitivity discovery enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderCspmAwsOfferingMdcContainersAgentlessDiscoveryK8S(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender container agentless discovery K8s configuration.

    :ivar enabled: Is Microsoft Defender container agentless discovery K8s enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender container agentless discovery K8s enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderCspmAwsOfferingMdcContainersImageAssessment(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender container image assessment configuration.

    :ivar enabled: Is Microsoft Defender container image assessment enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender container image assessment enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class VmScannersBase(_serialization.Model):
    """A VM scanning configuration for a security offering of a given environment.

    :ivar enabled: Is VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for VM scanning.
    :vartype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "VmScannersBaseConfiguration"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.VmScannersBaseConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is VM scanning enabled.
        :paramtype enabled: bool
        :keyword configuration: Configuration for VM scanning.
        :paramtype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class VmScannersAws(VmScannersBase):
    """A VM scanning configuration for a security offering of a Aws environment.

    :ivar enabled: Is VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for VM scanning.
    :vartype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "VmScannersBaseConfiguration"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.VmScannersBaseConfiguration"] = None,
        cloud_role_arn: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is VM scanning enabled.
        :paramtype enabled: bool
        :keyword configuration: Configuration for VM scanning.
        :paramtype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(enabled=enabled, configuration=configuration, **kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderCspmAwsOfferingVmScanners(VmScannersAws):
    """The Microsoft Defender for CSPM offering VM scanning configuration.

    :ivar enabled: Is VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for VM scanning.
    :vartype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """


class DefenderCspmDockerHubOffering(CloudOffering):
    """The Defender for CSPM Docker Hub offering configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderCspmDockerHub"


class DefenderCspmGcpOffering(CloudOffering):
    """The CSPM P1 for GCP offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar ciem_discovery: GCP Defenders CSPM Permissions Management OIDC (Open ID connect)
     connection configurations.
    :vartype ciem_discovery: ~azure.mgmt.security.models.DefenderCspmGcpOfferingCiemDiscovery
    :ivar vm_scanners: The Microsoft Defender for CSPM VM scanning configuration.
    :vartype vm_scanners: ~azure.mgmt.security.models.DefenderCspmGcpOfferingVmScanners
    :ivar data_sensitivity_discovery: The Microsoft Defender Data Sensitivity discovery
     configuration.
    :vartype data_sensitivity_discovery:
     ~azure.mgmt.security.models.DefenderCspmGcpOfferingDataSensitivityDiscovery
    :ivar mdc_containers_image_assessment: The Microsoft Defender Container image assessment
     configuration.
    :vartype mdc_containers_image_assessment:
     ~azure.mgmt.security.models.DefenderCspmGcpOfferingMdcContainersImageAssessment
    :ivar mdc_containers_agentless_discovery_k8_s: The Microsoft Defender Container agentless
     discovery configuration.
    :vartype mdc_containers_agentless_discovery_k8_s:
     ~azure.mgmt.security.models.DefenderCspmGcpOfferingMdcContainersAgentlessDiscoveryK8S
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "ciem_discovery": {"key": "ciemDiscovery", "type": "DefenderCspmGcpOfferingCiemDiscovery"},
        "vm_scanners": {"key": "vmScanners", "type": "DefenderCspmGcpOfferingVmScanners"},
        "data_sensitivity_discovery": {
            "key": "dataSensitivityDiscovery",
            "type": "DefenderCspmGcpOfferingDataSensitivityDiscovery",
        },
        "mdc_containers_image_assessment": {
            "key": "mdcContainersImageAssessment",
            "type": "DefenderCspmGcpOfferingMdcContainersImageAssessment",
        },
        "mdc_containers_agentless_discovery_k8_s": {
            "key": "mdcContainersAgentlessDiscoveryK8s",
            "type": "DefenderCspmGcpOfferingMdcContainersAgentlessDiscoveryK8S",
        },
    }

    def __init__(
        self,
        *,
        ciem_discovery: Optional["_models.DefenderCspmGcpOfferingCiemDiscovery"] = None,
        vm_scanners: Optional["_models.DefenderCspmGcpOfferingVmScanners"] = None,
        data_sensitivity_discovery: Optional["_models.DefenderCspmGcpOfferingDataSensitivityDiscovery"] = None,
        mdc_containers_image_assessment: Optional["_models.DefenderCspmGcpOfferingMdcContainersImageAssessment"] = None,
        mdc_containers_agentless_discovery_k8_s: Optional[
            "_models.DefenderCspmGcpOfferingMdcContainersAgentlessDiscoveryK8S"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ciem_discovery: GCP Defenders CSPM Permissions Management OIDC (Open ID connect)
         connection configurations.
        :paramtype ciem_discovery: ~azure.mgmt.security.models.DefenderCspmGcpOfferingCiemDiscovery
        :keyword vm_scanners: The Microsoft Defender for CSPM VM scanning configuration.
        :paramtype vm_scanners: ~azure.mgmt.security.models.DefenderCspmGcpOfferingVmScanners
        :keyword data_sensitivity_discovery: The Microsoft Defender Data Sensitivity discovery
         configuration.
        :paramtype data_sensitivity_discovery:
         ~azure.mgmt.security.models.DefenderCspmGcpOfferingDataSensitivityDiscovery
        :keyword mdc_containers_image_assessment: The Microsoft Defender Container image assessment
         configuration.
        :paramtype mdc_containers_image_assessment:
         ~azure.mgmt.security.models.DefenderCspmGcpOfferingMdcContainersImageAssessment
        :keyword mdc_containers_agentless_discovery_k8_s: The Microsoft Defender Container agentless
         discovery configuration.
        :paramtype mdc_containers_agentless_discovery_k8_s:
         ~azure.mgmt.security.models.DefenderCspmGcpOfferingMdcContainersAgentlessDiscoveryK8S
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderCspmGcp"
        self.ciem_discovery = ciem_discovery
        self.vm_scanners = vm_scanners
        self.data_sensitivity_discovery = data_sensitivity_discovery
        self.mdc_containers_image_assessment = mdc_containers_image_assessment
        self.mdc_containers_agentless_discovery_k8_s = mdc_containers_agentless_discovery_k8_s


class DefenderCspmGcpOfferingCiemDiscovery(_serialization.Model):
    """GCP Defenders CSPM Permissions Management OIDC (Open ID connect) connection configurations.

    :ivar workload_identity_provider_id: The GCP workload identity provider id for Permissions
     Management offering.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for Permissions
     Management offering.
    :vartype service_account_email_address: str
    :ivar azure_active_directory_app_name: the azure active directory app name used of
     authenticating against GCP workload identity federation.
    :vartype azure_active_directory_app_name: str
    """

    _attribute_map = {
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
        "azure_active_directory_app_name": {"key": "azureActiveDirectoryAppName", "type": "str"},
    }

    def __init__(
        self,
        *,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        azure_active_directory_app_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword workload_identity_provider_id: The GCP workload identity provider id for Permissions
         Management offering.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for
         Permissions Management offering.
        :paramtype service_account_email_address: str
        :keyword azure_active_directory_app_name: the azure active directory app name used of
         authenticating against GCP workload identity federation.
        :paramtype azure_active_directory_app_name: str
        """
        super().__init__(**kwargs)
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address
        self.azure_active_directory_app_name = azure_active_directory_app_name


class DefenderCspmGcpOfferingDataSensitivityDiscovery(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender Data Sensitivity discovery configuration.

    :ivar enabled: Is Microsoft Defender Data Sensitivity discovery enabled.
    :vartype enabled: bool
    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender Data Sensitivity discovery enabled.
        :paramtype enabled: bool
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderCspmGcpOfferingMdcContainersAgentlessDiscoveryK8S(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender Container agentless discovery configuration.

    :ivar enabled: Is Microsoft Defender container agentless discovery enabled.
    :vartype enabled: bool
    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender container agentless discovery enabled.
        :paramtype enabled: bool
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderCspmGcpOfferingMdcContainersImageAssessment(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender Container image assessment configuration.

    :ivar enabled: Is Microsoft Defender container image assessment enabled.
    :vartype enabled: bool
    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender container image assessment enabled.
        :paramtype enabled: bool
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class VmScannersGcp(VmScannersBase):
    """A VM scanning configuration for a security offering of a GCP environment.

    :ivar enabled: Is VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for VM scanning.
    :vartype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
    """


class DefenderCspmGcpOfferingVmScanners(VmScannersGcp):
    """The Microsoft Defender for CSPM VM scanning configuration.

    :ivar enabled: Is VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for VM scanning.
    :vartype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
    """


class DefenderCspmJFrogOffering(CloudOffering):
    """The CSPM P1 for JFrog Artifactory offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar mdc_containers_image_assessment: The Microsoft Defender Container image assessment
     configuration.
    :vartype mdc_containers_image_assessment:
     ~azure.mgmt.security.models.DefenderCspmJFrogOfferingMdcContainersImageAssessment
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "mdc_containers_image_assessment": {
            "key": "mdcContainersImageAssessment",
            "type": "DefenderCspmJFrogOfferingMdcContainersImageAssessment",
        },
    }

    def __init__(
        self,
        *,
        mdc_containers_image_assessment: Optional[
            "_models.DefenderCspmJFrogOfferingMdcContainersImageAssessment"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mdc_containers_image_assessment: The Microsoft Defender Container image assessment
         configuration.
        :paramtype mdc_containers_image_assessment:
         ~azure.mgmt.security.models.DefenderCspmJFrogOfferingMdcContainersImageAssessment
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderCspmJFrog"
        self.mdc_containers_image_assessment = mdc_containers_image_assessment


class DefenderCspmJFrogOfferingMdcContainersImageAssessment(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender Container image assessment configuration.

    :ivar enabled: Is Microsoft Defender container image assessment enabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender container image assessment enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class DefenderFoDatabasesAwsOffering(CloudOffering):
    """The Defender for Databases AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar arc_auto_provisioning: The ARC autoprovisioning configuration.
    :vartype arc_auto_provisioning:
     ~azure.mgmt.security.models.DefenderFoDatabasesAwsOfferingArcAutoProvisioning
    :ivar rds: The RDS configuration.
    :vartype rds: ~azure.mgmt.security.models.DefenderFoDatabasesAwsOfferingRds
    :ivar databases_dspm: The databases data security posture management (DSPM) configuration.
    :vartype databases_dspm:
     ~azure.mgmt.security.models.DefenderFoDatabasesAwsOfferingDatabasesDspm
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "arc_auto_provisioning": {
            "key": "arcAutoProvisioning",
            "type": "DefenderFoDatabasesAwsOfferingArcAutoProvisioning",
        },
        "rds": {"key": "rds", "type": "DefenderFoDatabasesAwsOfferingRds"},
        "databases_dspm": {"key": "databasesDspm", "type": "DefenderFoDatabasesAwsOfferingDatabasesDspm"},
    }

    def __init__(
        self,
        *,
        arc_auto_provisioning: Optional["_models.DefenderFoDatabasesAwsOfferingArcAutoProvisioning"] = None,
        rds: Optional["_models.DefenderFoDatabasesAwsOfferingRds"] = None,
        databases_dspm: Optional["_models.DefenderFoDatabasesAwsOfferingDatabasesDspm"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword arc_auto_provisioning: The ARC autoprovisioning configuration.
        :paramtype arc_auto_provisioning:
         ~azure.mgmt.security.models.DefenderFoDatabasesAwsOfferingArcAutoProvisioning
        :keyword rds: The RDS configuration.
        :paramtype rds: ~azure.mgmt.security.models.DefenderFoDatabasesAwsOfferingRds
        :keyword databases_dspm: The databases data security posture management (DSPM) configuration.
        :paramtype databases_dspm:
         ~azure.mgmt.security.models.DefenderFoDatabasesAwsOfferingDatabasesDspm
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForDatabasesAws"
        self.arc_auto_provisioning = arc_auto_provisioning
        self.rds = rds
        self.databases_dspm = databases_dspm


class DefenderFoDatabasesAwsOfferingArcAutoProvisioning(ArcAutoProvisioningAws):  # pylint: disable=name-too-long
    """The ARC autoprovisioning configuration.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for servers Arc auto provisioning for a given environment.
    :vartype configuration: ~azure.mgmt.security.models.ArcAutoProvisioningConfiguration
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """


class DefenderFoDatabasesAwsOfferingDatabasesDspm(_serialization.Model):  # pylint: disable=name-too-long
    """The databases data security posture management (DSPM) configuration.

    :ivar enabled: Is databases data security posture management (DSPM) protection enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is databases data security posture management (DSPM) protection enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderFoDatabasesAwsOfferingRds(_serialization.Model):
    """The RDS configuration.

    :ivar enabled: Is RDS protection enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is RDS protection enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOffering(CloudOffering):
    """The Defender for Containers AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar kubernetes_service: The kubernetes service connection configuration.
    :vartype kubernetes_service:
     ~azure.mgmt.security.models.DefenderForContainersAwsOfferingKubernetesService
    :ivar kubernetes_data_collection: The kubernetes data collection connection configuration.
    :vartype kubernetes_data_collection:
     ~azure.mgmt.security.models.DefenderForContainersAwsOfferingKubernetesDataCollection
    :ivar cloud_watch_to_kinesis: The cloudwatch to kinesis connection configuration.
    :vartype cloud_watch_to_kinesis:
     ~azure.mgmt.security.models.DefenderForContainersAwsOfferingCloudWatchToKinesis
    :ivar kinesis_to_s3: The kinesis to s3 connection configuration.
    :vartype kinesis_to_s3: ~azure.mgmt.security.models.DefenderForContainersAwsOfferingKinesisToS3
    :ivar enable_audit_logs_auto_provisioning: Is audit logs data collection enabled.
    :vartype enable_audit_logs_auto_provisioning: bool
    :ivar enable_defender_agent_auto_provisioning: Is Microsoft Defender for Cloud Kubernetes agent
     auto provisioning enabled.
    :vartype enable_defender_agent_auto_provisioning: bool
    :ivar enable_policy_agent_auto_provisioning: Is Policy Kubernetes agent auto provisioning
     enabled.
    :vartype enable_policy_agent_auto_provisioning: bool
    :ivar kube_audit_retention_time: The retention time in days of kube audit logs set on the
     CloudWatch log group.
    :vartype kube_audit_retention_time: int
    :ivar data_collection_external_id: The externalId used by the data reader to prevent the
     confused deputy attack.
    :vartype data_collection_external_id: str
    :ivar mdc_containers_image_assessment: The Microsoft Defender container image assessment
     configuration.
    :vartype mdc_containers_image_assessment:
     ~azure.mgmt.security.models.DefenderForContainersAwsOfferingMdcContainersImageAssessment
    :ivar mdc_containers_agentless_discovery_k8_s: The Microsoft Defender container agentless
     discovery K8s configuration.
    :vartype mdc_containers_agentless_discovery_k8_s:
     ~azure.mgmt.security.models.DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S
    :ivar vm_scanners: The Microsoft Defender for Container K8s VM host scanning configuration.
    :vartype vm_scanners: ~azure.mgmt.security.models.DefenderForContainersAwsOfferingVmScanners
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "kubernetes_service": {"key": "kubernetesService", "type": "DefenderForContainersAwsOfferingKubernetesService"},
        "kubernetes_data_collection": {
            "key": "kubernetesDataCollection",
            "type": "DefenderForContainersAwsOfferingKubernetesDataCollection",
        },
        "cloud_watch_to_kinesis": {
            "key": "cloudWatchToKinesis",
            "type": "DefenderForContainersAwsOfferingCloudWatchToKinesis",
        },
        "kinesis_to_s3": {"key": "kinesisToS3", "type": "DefenderForContainersAwsOfferingKinesisToS3"},
        "enable_audit_logs_auto_provisioning": {"key": "enableAuditLogsAutoProvisioning", "type": "bool"},
        "enable_defender_agent_auto_provisioning": {"key": "enableDefenderAgentAutoProvisioning", "type": "bool"},
        "enable_policy_agent_auto_provisioning": {"key": "enablePolicyAgentAutoProvisioning", "type": "bool"},
        "kube_audit_retention_time": {"key": "kubeAuditRetentionTime", "type": "int"},
        "data_collection_external_id": {"key": "dataCollectionExternalId", "type": "str"},
        "mdc_containers_image_assessment": {
            "key": "mdcContainersImageAssessment",
            "type": "DefenderForContainersAwsOfferingMdcContainersImageAssessment",
        },
        "mdc_containers_agentless_discovery_k8_s": {
            "key": "mdcContainersAgentlessDiscoveryK8s",
            "type": "DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S",
        },
        "vm_scanners": {"key": "vmScanners", "type": "DefenderForContainersAwsOfferingVmScanners"},
    }

    def __init__(
        self,
        *,
        kubernetes_service: Optional["_models.DefenderForContainersAwsOfferingKubernetesService"] = None,
        kubernetes_data_collection: Optional["_models.DefenderForContainersAwsOfferingKubernetesDataCollection"] = None,
        cloud_watch_to_kinesis: Optional["_models.DefenderForContainersAwsOfferingCloudWatchToKinesis"] = None,
        kinesis_to_s3: Optional["_models.DefenderForContainersAwsOfferingKinesisToS3"] = None,
        enable_audit_logs_auto_provisioning: Optional[bool] = None,
        enable_defender_agent_auto_provisioning: Optional[bool] = None,
        enable_policy_agent_auto_provisioning: Optional[bool] = None,
        kube_audit_retention_time: Optional[int] = None,
        data_collection_external_id: Optional[str] = None,
        mdc_containers_image_assessment: Optional[
            "_models.DefenderForContainersAwsOfferingMdcContainersImageAssessment"
        ] = None,
        mdc_containers_agentless_discovery_k8_s: Optional[
            "_models.DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S"
        ] = None,
        vm_scanners: Optional["_models.DefenderForContainersAwsOfferingVmScanners"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_service: The kubernetes service connection configuration.
        :paramtype kubernetes_service:
         ~azure.mgmt.security.models.DefenderForContainersAwsOfferingKubernetesService
        :keyword kubernetes_data_collection: The kubernetes data collection connection configuration.
        :paramtype kubernetes_data_collection:
         ~azure.mgmt.security.models.DefenderForContainersAwsOfferingKubernetesDataCollection
        :keyword cloud_watch_to_kinesis: The cloudwatch to kinesis connection configuration.
        :paramtype cloud_watch_to_kinesis:
         ~azure.mgmt.security.models.DefenderForContainersAwsOfferingCloudWatchToKinesis
        :keyword kinesis_to_s3: The kinesis to s3 connection configuration.
        :paramtype kinesis_to_s3:
         ~azure.mgmt.security.models.DefenderForContainersAwsOfferingKinesisToS3
        :keyword enable_audit_logs_auto_provisioning: Is audit logs data collection enabled.
        :paramtype enable_audit_logs_auto_provisioning: bool
        :keyword enable_defender_agent_auto_provisioning: Is Microsoft Defender for Cloud Kubernetes
         agent auto provisioning enabled.
        :paramtype enable_defender_agent_auto_provisioning: bool
        :keyword enable_policy_agent_auto_provisioning: Is Policy Kubernetes agent auto provisioning
         enabled.
        :paramtype enable_policy_agent_auto_provisioning: bool
        :keyword kube_audit_retention_time: The retention time in days of kube audit logs set on the
         CloudWatch log group.
        :paramtype kube_audit_retention_time: int
        :keyword data_collection_external_id: The externalId used by the data reader to prevent the
         confused deputy attack.
        :paramtype data_collection_external_id: str
        :keyword mdc_containers_image_assessment: The Microsoft Defender container image assessment
         configuration.
        :paramtype mdc_containers_image_assessment:
         ~azure.mgmt.security.models.DefenderForContainersAwsOfferingMdcContainersImageAssessment
        :keyword mdc_containers_agentless_discovery_k8_s: The Microsoft Defender container agentless
         discovery K8s configuration.
        :paramtype mdc_containers_agentless_discovery_k8_s:
         ~azure.mgmt.security.models.DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S
        :keyword vm_scanners: The Microsoft Defender for Container K8s VM host scanning configuration.
        :paramtype vm_scanners: ~azure.mgmt.security.models.DefenderForContainersAwsOfferingVmScanners
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForContainersAws"
        self.kubernetes_service = kubernetes_service
        self.kubernetes_data_collection = kubernetes_data_collection
        self.cloud_watch_to_kinesis = cloud_watch_to_kinesis
        self.kinesis_to_s3 = kinesis_to_s3
        self.enable_audit_logs_auto_provisioning = enable_audit_logs_auto_provisioning
        self.enable_defender_agent_auto_provisioning = enable_defender_agent_auto_provisioning
        self.enable_policy_agent_auto_provisioning = enable_policy_agent_auto_provisioning
        self.kube_audit_retention_time = kube_audit_retention_time
        self.data_collection_external_id = data_collection_external_id
        self.mdc_containers_image_assessment = mdc_containers_image_assessment
        self.mdc_containers_agentless_discovery_k8_s = mdc_containers_agentless_discovery_k8_s
        self.vm_scanners = vm_scanners


class DefenderForContainersAwsOfferingCloudWatchToKinesis(_serialization.Model):  # pylint: disable=name-too-long
    """The cloudwatch to kinesis connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS used by CloudWatch to transfer data into
     Kinesis.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS used by CloudWatch to transfer data into
         Kinesis.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingKinesisToS3(_serialization.Model):  # pylint: disable=name-too-long
    """The kinesis to s3 connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS used by Kinesis to transfer data into S3.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS used by Kinesis to transfer data into S3.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingKubernetesDataCollection(_serialization.Model):  # pylint: disable=name-too-long
    """The kubernetes data collection connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature used for reading data.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature used for reading data.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingKubernetesService(_serialization.Model):  # pylint: disable=name-too-long
    """The kubernetes service connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature used for provisioning
     resources.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature used for provisioning
         resources.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The Microsoft Defender container agentless discovery K8s configuration.

    :ivar enabled: Is Microsoft Defender container agentless discovery K8s enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender container agentless discovery K8s enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingMdcContainersImageAssessment(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The Microsoft Defender container image assessment configuration.

    :ivar enabled: Is Microsoft Defender container image assessment enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender container image assessment enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingVmScanners(VmScannersAws):  # pylint: disable=name-too-long
    """The Microsoft Defender for Container K8s VM host scanning configuration.

    :ivar enabled: Is VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for VM scanning.
    :vartype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """


class DefenderForContainersDockerHubOffering(CloudOffering):
    """The Defender for containers Docker Hub offering configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForContainersDockerHub"


class DefenderForContainersGcpOffering(CloudOffering):
    """The containers GCP offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar native_cloud_connection: The native cloud connection configuration.
    :vartype native_cloud_connection:
     ~azure.mgmt.security.models.DefenderForContainersGcpOfferingNativeCloudConnection
    :ivar data_pipeline_native_cloud_connection: The native cloud connection configuration.
    :vartype data_pipeline_native_cloud_connection:
     ~azure.mgmt.security.models.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection
    :ivar enable_audit_logs_auto_provisioning: Is audit logs data collection enabled.
    :vartype enable_audit_logs_auto_provisioning: bool
    :ivar enable_defender_agent_auto_provisioning: Is Microsoft Defender for Cloud Kubernetes agent
     auto provisioning enabled.
    :vartype enable_defender_agent_auto_provisioning: bool
    :ivar enable_policy_agent_auto_provisioning: Is Policy Kubernetes agent auto provisioning
     enabled.
    :vartype enable_policy_agent_auto_provisioning: bool
    :ivar mdc_containers_image_assessment: The Microsoft Defender Container image assessment
     configuration.
    :vartype mdc_containers_image_assessment:
     ~azure.mgmt.security.models.DefenderForContainersGcpOfferingMdcContainersImageAssessment
    :ivar mdc_containers_agentless_discovery_k8_s: The Microsoft Defender Container agentless
     discovery configuration.
    :vartype mdc_containers_agentless_discovery_k8_s:
     ~azure.mgmt.security.models.DefenderForContainersGcpOfferingMdcContainersAgentlessDiscoveryK8S
    :ivar vm_scanners: The Microsoft Defender for Container K8s VM host scanning configuration.
    :vartype vm_scanners: ~azure.mgmt.security.models.DefenderForContainersGcpOfferingVmScanners
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "native_cloud_connection": {
            "key": "nativeCloudConnection",
            "type": "DefenderForContainersGcpOfferingNativeCloudConnection",
        },
        "data_pipeline_native_cloud_connection": {
            "key": "dataPipelineNativeCloudConnection",
            "type": "DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection",
        },
        "enable_audit_logs_auto_provisioning": {"key": "enableAuditLogsAutoProvisioning", "type": "bool"},
        "enable_defender_agent_auto_provisioning": {"key": "enableDefenderAgentAutoProvisioning", "type": "bool"},
        "enable_policy_agent_auto_provisioning": {"key": "enablePolicyAgentAutoProvisioning", "type": "bool"},
        "mdc_containers_image_assessment": {
            "key": "mdcContainersImageAssessment",
            "type": "DefenderForContainersGcpOfferingMdcContainersImageAssessment",
        },
        "mdc_containers_agentless_discovery_k8_s": {
            "key": "mdcContainersAgentlessDiscoveryK8s",
            "type": "DefenderForContainersGcpOfferingMdcContainersAgentlessDiscoveryK8S",
        },
        "vm_scanners": {"key": "vmScanners", "type": "DefenderForContainersGcpOfferingVmScanners"},
    }

    def __init__(
        self,
        *,
        native_cloud_connection: Optional["_models.DefenderForContainersGcpOfferingNativeCloudConnection"] = None,
        data_pipeline_native_cloud_connection: Optional[
            "_models.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection"
        ] = None,
        enable_audit_logs_auto_provisioning: Optional[bool] = None,
        enable_defender_agent_auto_provisioning: Optional[bool] = None,
        enable_policy_agent_auto_provisioning: Optional[bool] = None,
        mdc_containers_image_assessment: Optional[
            "_models.DefenderForContainersGcpOfferingMdcContainersImageAssessment"
        ] = None,
        mdc_containers_agentless_discovery_k8_s: Optional[
            "_models.DefenderForContainersGcpOfferingMdcContainersAgentlessDiscoveryK8S"
        ] = None,
        vm_scanners: Optional["_models.DefenderForContainersGcpOfferingVmScanners"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword native_cloud_connection: The native cloud connection configuration.
        :paramtype native_cloud_connection:
         ~azure.mgmt.security.models.DefenderForContainersGcpOfferingNativeCloudConnection
        :keyword data_pipeline_native_cloud_connection: The native cloud connection configuration.
        :paramtype data_pipeline_native_cloud_connection:
         ~azure.mgmt.security.models.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection
        :keyword enable_audit_logs_auto_provisioning: Is audit logs data collection enabled.
        :paramtype enable_audit_logs_auto_provisioning: bool
        :keyword enable_defender_agent_auto_provisioning: Is Microsoft Defender for Cloud Kubernetes
         agent auto provisioning enabled.
        :paramtype enable_defender_agent_auto_provisioning: bool
        :keyword enable_policy_agent_auto_provisioning: Is Policy Kubernetes agent auto provisioning
         enabled.
        :paramtype enable_policy_agent_auto_provisioning: bool
        :keyword mdc_containers_image_assessment: The Microsoft Defender Container image assessment
         configuration.
        :paramtype mdc_containers_image_assessment:
         ~azure.mgmt.security.models.DefenderForContainersGcpOfferingMdcContainersImageAssessment
        :keyword mdc_containers_agentless_discovery_k8_s: The Microsoft Defender Container agentless
         discovery configuration.
        :paramtype mdc_containers_agentless_discovery_k8_s:
         ~azure.mgmt.security.models.DefenderForContainersGcpOfferingMdcContainersAgentlessDiscoveryK8S
        :keyword vm_scanners: The Microsoft Defender for Container K8s VM host scanning configuration.
        :paramtype vm_scanners: ~azure.mgmt.security.models.DefenderForContainersGcpOfferingVmScanners
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForContainersGcp"
        self.native_cloud_connection = native_cloud_connection
        self.data_pipeline_native_cloud_connection = data_pipeline_native_cloud_connection
        self.enable_audit_logs_auto_provisioning = enable_audit_logs_auto_provisioning
        self.enable_defender_agent_auto_provisioning = enable_defender_agent_auto_provisioning
        self.enable_policy_agent_auto_provisioning = enable_policy_agent_auto_provisioning
        self.mdc_containers_image_assessment = mdc_containers_image_assessment
        self.mdc_containers_agentless_discovery_k8_s = mdc_containers_agentless_discovery_k8_s
        self.vm_scanners = vm_scanners


class DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar service_account_email_address: The data collection service account email address in GCP
     for this offering.
    :vartype service_account_email_address: str
    :ivar workload_identity_provider_id: The data collection GCP workload identity provider id for
     this offering.
    :vartype workload_identity_provider_id: str
    """

    _attribute_map = {
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_account_email_address: Optional[str] = None,
        workload_identity_provider_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_account_email_address: The data collection service account email address in
         GCP for this offering.
        :paramtype service_account_email_address: str
        :keyword workload_identity_provider_id: The data collection GCP workload identity provider id
         for this offering.
        :paramtype workload_identity_provider_id: str
        """
        super().__init__(**kwargs)
        self.service_account_email_address = service_account_email_address
        self.workload_identity_provider_id = workload_identity_provider_id


class DefenderForContainersGcpOfferingMdcContainersAgentlessDiscoveryK8S(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The Microsoft Defender Container agentless discovery configuration.

    :ivar enabled: Is Microsoft Defender container agentless discovery enabled.
    :vartype enabled: bool
    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender container agentless discovery enabled.
        :paramtype enabled: bool
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderForContainersGcpOfferingMdcContainersImageAssessment(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The Microsoft Defender Container image assessment configuration.

    :ivar enabled: Is Microsoft Defender container image assessment enabled.
    :vartype enabled: bool
    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender container image assessment enabled.
        :paramtype enabled: bool
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderForContainersGcpOfferingNativeCloudConnection(_serialization.Model):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar service_account_email_address: The service account email address in GCP for this
     offering.
    :vartype service_account_email_address: str
    :ivar workload_identity_provider_id: The GCP workload identity provider id for this offering.
    :vartype workload_identity_provider_id: str
    """

    _attribute_map = {
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_account_email_address: Optional[str] = None,
        workload_identity_provider_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_account_email_address: The service account email address in GCP for this
         offering.
        :paramtype service_account_email_address: str
        :keyword workload_identity_provider_id: The GCP workload identity provider id for this
         offering.
        :paramtype workload_identity_provider_id: str
        """
        super().__init__(**kwargs)
        self.service_account_email_address = service_account_email_address
        self.workload_identity_provider_id = workload_identity_provider_id


class DefenderForContainersGcpOfferingVmScanners(VmScannersGcp):  # pylint: disable=name-too-long
    """The Microsoft Defender for Container K8s VM host scanning configuration.

    :ivar enabled: Is VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for VM scanning.
    :vartype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
    """


class DefenderForContainersJFrogOffering(CloudOffering):
    """The Defender for Containers for JFrog Artifactory offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForContainersJFrog"


class DefenderForDatabasesGcpOffering(CloudOffering):
    """The Defender for Databases GCP offering configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar arc_auto_provisioning: The ARC autoprovisioning configuration.
    :vartype arc_auto_provisioning:
     ~azure.mgmt.security.models.DefenderForDatabasesGcpOfferingArcAutoProvisioning
    :ivar defender_for_databases_arc_auto_provisioning: The native cloud connection configuration.
    :vartype defender_for_databases_arc_auto_provisioning:
     ~azure.mgmt.security.models.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "arc_auto_provisioning": {
            "key": "arcAutoProvisioning",
            "type": "DefenderForDatabasesGcpOfferingArcAutoProvisioning",
        },
        "defender_for_databases_arc_auto_provisioning": {
            "key": "defenderForDatabasesArcAutoProvisioning",
            "type": "DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning",
        },
    }

    def __init__(
        self,
        *,
        arc_auto_provisioning: Optional["_models.DefenderForDatabasesGcpOfferingArcAutoProvisioning"] = None,
        defender_for_databases_arc_auto_provisioning: Optional[
            "_models.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword arc_auto_provisioning: The ARC autoprovisioning configuration.
        :paramtype arc_auto_provisioning:
         ~azure.mgmt.security.models.DefenderForDatabasesGcpOfferingArcAutoProvisioning
        :keyword defender_for_databases_arc_auto_provisioning: The native cloud connection
         configuration.
        :paramtype defender_for_databases_arc_auto_provisioning:
         ~azure.mgmt.security.models.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForDatabasesGcp"
        self.arc_auto_provisioning = arc_auto_provisioning
        self.defender_for_databases_arc_auto_provisioning = defender_for_databases_arc_auto_provisioning


class DefenderForDatabasesGcpOfferingArcAutoProvisioning(ArcAutoProvisioningGcp):  # pylint: disable=name-too-long
    """The ARC autoprovisioning configuration.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for servers Arc auto provisioning for a given environment.
    :vartype configuration: ~azure.mgmt.security.models.ArcAutoProvisioningConfiguration
    """


class DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar service_account_email_address: The service account email address in GCP for this
     offering.
    :vartype service_account_email_address: str
    :ivar workload_identity_provider_id: The GCP workload identity provider id for this offering.
    :vartype workload_identity_provider_id: str
    """

    _attribute_map = {
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_account_email_address: Optional[str] = None,
        workload_identity_provider_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_account_email_address: The service account email address in GCP for this
         offering.
        :paramtype service_account_email_address: str
        :keyword workload_identity_provider_id: The GCP workload identity provider id for this
         offering.
        :paramtype workload_identity_provider_id: str
        """
        super().__init__(**kwargs)
        self.service_account_email_address = service_account_email_address
        self.workload_identity_provider_id = workload_identity_provider_id


class DefenderForServersAwsOffering(CloudOffering):
    """The Defender for Servers AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar defender_for_servers: The Defender for servers connection configuration.
    :vartype defender_for_servers:
     ~azure.mgmt.security.models.DefenderForServersAwsOfferingDefenderForServers
    :ivar arc_auto_provisioning: The ARC autoprovisioning configuration.
    :vartype arc_auto_provisioning:
     ~azure.mgmt.security.models.DefenderForServersAwsOfferingArcAutoProvisioning
    :ivar va_auto_provisioning: The Vulnerability Assessment autoprovisioning configuration.
    :vartype va_auto_provisioning:
     ~azure.mgmt.security.models.DefenderForServersAwsOfferingVaAutoProvisioning
    :ivar mde_auto_provisioning: The Microsoft Defender for Endpoint autoprovisioning
     configuration.
    :vartype mde_auto_provisioning:
     ~azure.mgmt.security.models.DefenderForServersAwsOfferingMdeAutoProvisioning
    :ivar sub_plan: configuration for the servers offering subPlan.
    :vartype sub_plan: ~azure.mgmt.security.models.DefenderForServersAwsOfferingSubPlan
    :ivar vm_scanners: The Microsoft Defender for Server VM scanning configuration.
    :vartype vm_scanners: ~azure.mgmt.security.models.DefenderForServersAwsOfferingVmScanners
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "defender_for_servers": {
            "key": "defenderForServers",
            "type": "DefenderForServersAwsOfferingDefenderForServers",
        },
        "arc_auto_provisioning": {
            "key": "arcAutoProvisioning",
            "type": "DefenderForServersAwsOfferingArcAutoProvisioning",
        },
        "va_auto_provisioning": {
            "key": "vaAutoProvisioning",
            "type": "DefenderForServersAwsOfferingVaAutoProvisioning",
        },
        "mde_auto_provisioning": {
            "key": "mdeAutoProvisioning",
            "type": "DefenderForServersAwsOfferingMdeAutoProvisioning",
        },
        "sub_plan": {"key": "subPlan", "type": "DefenderForServersAwsOfferingSubPlan"},
        "vm_scanners": {"key": "vmScanners", "type": "DefenderForServersAwsOfferingVmScanners"},
    }

    def __init__(
        self,
        *,
        defender_for_servers: Optional["_models.DefenderForServersAwsOfferingDefenderForServers"] = None,
        arc_auto_provisioning: Optional["_models.DefenderForServersAwsOfferingArcAutoProvisioning"] = None,
        va_auto_provisioning: Optional["_models.DefenderForServersAwsOfferingVaAutoProvisioning"] = None,
        mde_auto_provisioning: Optional["_models.DefenderForServersAwsOfferingMdeAutoProvisioning"] = None,
        sub_plan: Optional["_models.DefenderForServersAwsOfferingSubPlan"] = None,
        vm_scanners: Optional["_models.DefenderForServersAwsOfferingVmScanners"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword defender_for_servers: The Defender for servers connection configuration.
        :paramtype defender_for_servers:
         ~azure.mgmt.security.models.DefenderForServersAwsOfferingDefenderForServers
        :keyword arc_auto_provisioning: The ARC autoprovisioning configuration.
        :paramtype arc_auto_provisioning:
         ~azure.mgmt.security.models.DefenderForServersAwsOfferingArcAutoProvisioning
        :keyword va_auto_provisioning: The Vulnerability Assessment autoprovisioning configuration.
        :paramtype va_auto_provisioning:
         ~azure.mgmt.security.models.DefenderForServersAwsOfferingVaAutoProvisioning
        :keyword mde_auto_provisioning: The Microsoft Defender for Endpoint autoprovisioning
         configuration.
        :paramtype mde_auto_provisioning:
         ~azure.mgmt.security.models.DefenderForServersAwsOfferingMdeAutoProvisioning
        :keyword sub_plan: configuration for the servers offering subPlan.
        :paramtype sub_plan: ~azure.mgmt.security.models.DefenderForServersAwsOfferingSubPlan
        :keyword vm_scanners: The Microsoft Defender for Server VM scanning configuration.
        :paramtype vm_scanners: ~azure.mgmt.security.models.DefenderForServersAwsOfferingVmScanners
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForServersAws"
        self.defender_for_servers = defender_for_servers
        self.arc_auto_provisioning = arc_auto_provisioning
        self.va_auto_provisioning = va_auto_provisioning
        self.mde_auto_provisioning = mde_auto_provisioning
        self.sub_plan = sub_plan
        self.vm_scanners = vm_scanners


class DefenderForServersAwsOfferingArcAutoProvisioning(ArcAutoProvisioningAws):  # pylint: disable=name-too-long
    """The ARC autoprovisioning configuration.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for servers Arc auto provisioning for a given environment.
    :vartype configuration: ~azure.mgmt.security.models.ArcAutoProvisioningConfiguration
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """


class DefenderForServersAwsOfferingDefenderForServers(_serialization.Model):  # pylint: disable=name-too-long
    """The Defender for servers connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForServersAwsOfferingMdeAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender for Endpoint autoprovisioning configuration.

    :ivar enabled: Is Microsoft Defender for Endpoint auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Microsoft Defender for Endpoint autoprovisioning.
    :vartype configuration: JSON
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "object"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, configuration: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender for Endpoint auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Microsoft Defender for Endpoint autoprovisioning.
        :paramtype configuration: JSON
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersAwsOfferingSubPlan(_serialization.Model):
    """configuration for the servers offering subPlan.

    :ivar type: The available sub plans. Known values are: "P1" and "P2".
    :vartype type: str or ~azure.mgmt.security.models.SubPlan
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.SubPlan"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The available sub plans. Known values are: "P1" and "P2".
        :paramtype type: str or ~azure.mgmt.security.models.SubPlan
        """
        super().__init__(**kwargs)
        self.type = type


class DefenderForServersAwsOfferingVaAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The Vulnerability Assessment autoprovisioning configuration.

    :ivar enabled: Is Vulnerability Assessment auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Vulnerability Assessment autoprovisioning.
    :vartype configuration:
     ~azure.mgmt.security.models.DefenderForServersAwsOfferingVaAutoProvisioningConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {
            "key": "configuration",
            "type": "DefenderForServersAwsOfferingVaAutoProvisioningConfiguration",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.DefenderForServersAwsOfferingVaAutoProvisioningConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Vulnerability Assessment auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Vulnerability Assessment autoprovisioning.
        :paramtype configuration:
         ~azure.mgmt.security.models.DefenderForServersAwsOfferingVaAutoProvisioningConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersAwsOfferingVaAutoProvisioningConfiguration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """configuration for Vulnerability Assessment autoprovisioning.

    :ivar type: The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or
     'Qualys'. Known values are: "Qualys" and "TVM".
    :vartype type: str or ~azure.mgmt.security.models.Type
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.Type"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or
         'Qualys'. Known values are: "Qualys" and "TVM".
        :paramtype type: str or ~azure.mgmt.security.models.Type
        """
        super().__init__(**kwargs)
        self.type = type


class DefenderForServersAwsOfferingVmScanners(VmScannersAws):
    """The Microsoft Defender for Server VM scanning configuration.

    :ivar enabled: Is VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for VM scanning.
    :vartype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """


class DefenderForServersGcpOffering(CloudOffering):
    """The Defender for Servers GCP offering configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "CspmMonitorGcp", "CspmMonitorGithub", "CspmMonitorAzureDevOps",
     "DefenderForServersGcp", "DefenderForContainersGcp", "DefenderForDatabasesGcp",
     "DefenderCspmAws", "DefenderCspmGcp", "CspmMonitorGitLab", "CspmMonitorDockerHub",
     "DefenderForContainersDockerHub", "DefenderCspmDockerHub", "CspmMonitorJFrog",
     "DefenderForContainersJFrog", and "DefenderCspmJFrog".
    :vartype offering_type: str or ~azure.mgmt.security.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar defender_for_servers: The Defender for servers connection configuration.
    :vartype defender_for_servers:
     ~azure.mgmt.security.models.DefenderForServersGcpOfferingDefenderForServers
    :ivar arc_auto_provisioning: The ARC autoprovisioning configuration.
    :vartype arc_auto_provisioning:
     ~azure.mgmt.security.models.DefenderForServersGcpOfferingArcAutoProvisioning
    :ivar va_auto_provisioning: The Vulnerability Assessment autoprovisioning configuration.
    :vartype va_auto_provisioning:
     ~azure.mgmt.security.models.DefenderForServersGcpOfferingVaAutoProvisioning
    :ivar mde_auto_provisioning: The Microsoft Defender for Endpoint autoprovisioning
     configuration.
    :vartype mde_auto_provisioning:
     ~azure.mgmt.security.models.DefenderForServersGcpOfferingMdeAutoProvisioning
    :ivar sub_plan: configuration for the servers offering subPlan.
    :vartype sub_plan: ~azure.mgmt.security.models.DefenderForServersGcpOfferingSubPlan
    :ivar vm_scanners: The Microsoft Defender for Server VM scanning configuration.
    :vartype vm_scanners: ~azure.mgmt.security.models.DefenderForServersGcpOfferingVmScanners
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "defender_for_servers": {
            "key": "defenderForServers",
            "type": "DefenderForServersGcpOfferingDefenderForServers",
        },
        "arc_auto_provisioning": {
            "key": "arcAutoProvisioning",
            "type": "DefenderForServersGcpOfferingArcAutoProvisioning",
        },
        "va_auto_provisioning": {
            "key": "vaAutoProvisioning",
            "type": "DefenderForServersGcpOfferingVaAutoProvisioning",
        },
        "mde_auto_provisioning": {
            "key": "mdeAutoProvisioning",
            "type": "DefenderForServersGcpOfferingMdeAutoProvisioning",
        },
        "sub_plan": {"key": "subPlan", "type": "DefenderForServersGcpOfferingSubPlan"},
        "vm_scanners": {"key": "vmScanners", "type": "DefenderForServersGcpOfferingVmScanners"},
    }

    def __init__(
        self,
        *,
        defender_for_servers: Optional["_models.DefenderForServersGcpOfferingDefenderForServers"] = None,
        arc_auto_provisioning: Optional["_models.DefenderForServersGcpOfferingArcAutoProvisioning"] = None,
        va_auto_provisioning: Optional["_models.DefenderForServersGcpOfferingVaAutoProvisioning"] = None,
        mde_auto_provisioning: Optional["_models.DefenderForServersGcpOfferingMdeAutoProvisioning"] = None,
        sub_plan: Optional["_models.DefenderForServersGcpOfferingSubPlan"] = None,
        vm_scanners: Optional["_models.DefenderForServersGcpOfferingVmScanners"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword defender_for_servers: The Defender for servers connection configuration.
        :paramtype defender_for_servers:
         ~azure.mgmt.security.models.DefenderForServersGcpOfferingDefenderForServers
        :keyword arc_auto_provisioning: The ARC autoprovisioning configuration.
        :paramtype arc_auto_provisioning:
         ~azure.mgmt.security.models.DefenderForServersGcpOfferingArcAutoProvisioning
        :keyword va_auto_provisioning: The Vulnerability Assessment autoprovisioning configuration.
        :paramtype va_auto_provisioning:
         ~azure.mgmt.security.models.DefenderForServersGcpOfferingVaAutoProvisioning
        :keyword mde_auto_provisioning: The Microsoft Defender for Endpoint autoprovisioning
         configuration.
        :paramtype mde_auto_provisioning:
         ~azure.mgmt.security.models.DefenderForServersGcpOfferingMdeAutoProvisioning
        :keyword sub_plan: configuration for the servers offering subPlan.
        :paramtype sub_plan: ~azure.mgmt.security.models.DefenderForServersGcpOfferingSubPlan
        :keyword vm_scanners: The Microsoft Defender for Server VM scanning configuration.
        :paramtype vm_scanners: ~azure.mgmt.security.models.DefenderForServersGcpOfferingVmScanners
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForServersGcp"
        self.defender_for_servers = defender_for_servers
        self.arc_auto_provisioning = arc_auto_provisioning
        self.va_auto_provisioning = va_auto_provisioning
        self.mde_auto_provisioning = mde_auto_provisioning
        self.sub_plan = sub_plan
        self.vm_scanners = vm_scanners


class DefenderForServersGcpOfferingArcAutoProvisioning(ArcAutoProvisioningGcp):  # pylint: disable=name-too-long
    """The ARC autoprovisioning configuration.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for servers Arc auto provisioning for a given environment.
    :vartype configuration: ~azure.mgmt.security.models.ArcAutoProvisioningConfiguration
    """


class DefenderForServersGcpOfferingDefenderForServers(_serialization.Model):  # pylint: disable=name-too-long
    """The Defender for servers connection configuration.

    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderForServersGcpOfferingMdeAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender for Endpoint autoprovisioning configuration.

    :ivar enabled: Is Microsoft Defender for Endpoint auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Microsoft Defender for Endpoint autoprovisioning.
    :vartype configuration: JSON
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "object"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, configuration: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender for Endpoint auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Microsoft Defender for Endpoint autoprovisioning.
        :paramtype configuration: JSON
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersGcpOfferingSubPlan(_serialization.Model):
    """configuration for the servers offering subPlan.

    :ivar type: The available sub plans. Known values are: "P1" and "P2".
    :vartype type: str or ~azure.mgmt.security.models.SubPlan
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.SubPlan"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The available sub plans. Known values are: "P1" and "P2".
        :paramtype type: str or ~azure.mgmt.security.models.SubPlan
        """
        super().__init__(**kwargs)
        self.type = type


class DefenderForServersGcpOfferingVaAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The Vulnerability Assessment autoprovisioning configuration.

    :ivar enabled: Is Vulnerability Assessment auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Vulnerability Assessment autoprovisioning.
    :vartype configuration:
     ~azure.mgmt.security.models.DefenderForServersGcpOfferingVaAutoProvisioningConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {
            "key": "configuration",
            "type": "DefenderForServersGcpOfferingVaAutoProvisioningConfiguration",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.DefenderForServersGcpOfferingVaAutoProvisioningConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Vulnerability Assessment auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Vulnerability Assessment autoprovisioning.
        :paramtype configuration:
         ~azure.mgmt.security.models.DefenderForServersGcpOfferingVaAutoProvisioningConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersGcpOfferingVaAutoProvisioningConfiguration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """configuration for Vulnerability Assessment autoprovisioning.

    :ivar type: The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or
     'Qualys'. Known values are: "Qualys" and "TVM".
    :vartype type: str or ~azure.mgmt.security.models.Type
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.Type"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or
         'Qualys'. Known values are: "Qualys" and "TVM".
        :paramtype type: str or ~azure.mgmt.security.models.Type
        """
        super().__init__(**kwargs)
        self.type = type


class DefenderForServersGcpOfferingVmScanners(VmScannersGcp):
    """The Microsoft Defender for Server VM scanning configuration.

    :ivar enabled: Is VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for VM scanning.
    :vartype configuration: ~azure.mgmt.security.models.VmScannersBaseConfiguration
    """


class DefenderForStorageSetting(Resource):
    """The Defender for Storage resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Defender for Storage resource properties.
    :vartype properties: ~azure.mgmt.security.models.DefenderForStorageSettingProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DefenderForStorageSettingProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.DefenderForStorageSettingProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Defender for Storage resource properties.
        :paramtype properties: ~azure.mgmt.security.models.DefenderForStorageSettingProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DefenderForStorageSettingProperties(_serialization.Model):
    """Defender for Storage resource properties.

    :ivar is_enabled: Indicates whether Defender for Storage is enabled on this storage account.
    :vartype is_enabled: bool
    :ivar malware_scanning: Properties of Malware Scanning.
    :vartype malware_scanning: ~azure.mgmt.security.models.MalwareScanningProperties
    :ivar sensitive_data_discovery: Properties of Sensitive Data Discovery.
    :vartype sensitive_data_discovery: ~azure.mgmt.security.models.SensitiveDataDiscoveryProperties
    :ivar override_subscription_level_settings: Indicates whether the settings defined for this
     storage account should override the settings defined for the subscription.
    :vartype override_subscription_level_settings: bool
    """

    _attribute_map = {
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "malware_scanning": {"key": "malwareScanning", "type": "MalwareScanningProperties"},
        "sensitive_data_discovery": {"key": "sensitiveDataDiscovery", "type": "SensitiveDataDiscoveryProperties"},
        "override_subscription_level_settings": {"key": "overrideSubscriptionLevelSettings", "type": "bool"},
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = None,
        malware_scanning: Optional["_models.MalwareScanningProperties"] = None,
        sensitive_data_discovery: Optional["_models.SensitiveDataDiscoveryProperties"] = None,
        override_subscription_level_settings: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Indicates whether Defender for Storage is enabled on this storage account.
        :paramtype is_enabled: bool
        :keyword malware_scanning: Properties of Malware Scanning.
        :paramtype malware_scanning: ~azure.mgmt.security.models.MalwareScanningProperties
        :keyword sensitive_data_discovery: Properties of Sensitive Data Discovery.
        :paramtype sensitive_data_discovery:
         ~azure.mgmt.security.models.SensitiveDataDiscoveryProperties
        :keyword override_subscription_level_settings: Indicates whether the settings defined for this
         storage account should override the settings defined for the subscription.
        :paramtype override_subscription_level_settings: bool
        """
        super().__init__(**kwargs)
        self.is_enabled = is_enabled
        self.malware_scanning = malware_scanning
        self.sensitive_data_discovery = sensitive_data_discovery
        self.override_subscription_level_settings = override_subscription_level_settings


class DenylistCustomAlertRule(ListCustomAlertRule):
    """A custom alert rule that checks if a value (depends on the custom alert type) is denied.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :ivar denylist_values: The values to deny. The format of the values depends on the rule type.
     Required.
    :vartype denylist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "denylist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "denylist_values": {"key": "denylistValues", "type": "[str]"},
    }

    def __init__(self, *, is_enabled: bool, denylist_values: List[str], **kwargs: Any) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword denylist_values: The values to deny. The format of the values depends on the rule
         type. Required.
        :paramtype denylist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.rule_type: str = "DenylistCustomAlertRule"
        self.denylist_values = denylist_values


class DeviceSecurityGroup(Resource):
    """The device security group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar threshold_rules: The list of custom alert threshold rules.
    :vartype threshold_rules: list[~azure.mgmt.security.models.ThresholdCustomAlertRule]
    :ivar time_window_rules: The list of custom alert time-window rules.
    :vartype time_window_rules: list[~azure.mgmt.security.models.TimeWindowCustomAlertRule]
    :ivar allowlist_rules: The allow-list custom alert rules.
    :vartype allowlist_rules: list[~azure.mgmt.security.models.AllowlistCustomAlertRule]
    :ivar denylist_rules: The deny-list custom alert rules.
    :vartype denylist_rules: list[~azure.mgmt.security.models.DenylistCustomAlertRule]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "threshold_rules": {"key": "properties.thresholdRules", "type": "[ThresholdCustomAlertRule]"},
        "time_window_rules": {"key": "properties.timeWindowRules", "type": "[TimeWindowCustomAlertRule]"},
        "allowlist_rules": {"key": "properties.allowlistRules", "type": "[AllowlistCustomAlertRule]"},
        "denylist_rules": {"key": "properties.denylistRules", "type": "[DenylistCustomAlertRule]"},
    }

    def __init__(
        self,
        *,
        threshold_rules: Optional[List["_models.ThresholdCustomAlertRule"]] = None,
        time_window_rules: Optional[List["_models.TimeWindowCustomAlertRule"]] = None,
        allowlist_rules: Optional[List["_models.AllowlistCustomAlertRule"]] = None,
        denylist_rules: Optional[List["_models.DenylistCustomAlertRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword threshold_rules: The list of custom alert threshold rules.
        :paramtype threshold_rules: list[~azure.mgmt.security.models.ThresholdCustomAlertRule]
        :keyword time_window_rules: The list of custom alert time-window rules.
        :paramtype time_window_rules: list[~azure.mgmt.security.models.TimeWindowCustomAlertRule]
        :keyword allowlist_rules: The allow-list custom alert rules.
        :paramtype allowlist_rules: list[~azure.mgmt.security.models.AllowlistCustomAlertRule]
        :keyword denylist_rules: The deny-list custom alert rules.
        :paramtype denylist_rules: list[~azure.mgmt.security.models.DenylistCustomAlertRule]
        """
        super().__init__(**kwargs)
        self.threshold_rules = threshold_rules
        self.time_window_rules = time_window_rules
        self.allowlist_rules = allowlist_rules
        self.denylist_rules = denylist_rules


class DeviceSecurityGroupList(_serialization.Model):
    """List of device security groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of device security group objects.
    :vartype value: list[~azure.mgmt.security.models.DeviceSecurityGroup]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeviceSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DeviceSecurityGroup"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of device security group objects.
        :paramtype value: list[~azure.mgmt.security.models.DeviceSecurityGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DevOpsCapability(_serialization.Model):
    """Details about DevOps capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets the name of the DevOps capability.
    :vartype name: str
    :ivar value: Gets the value of the DevOps capability.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.value: Optional[str] = None


class DevOpsConfiguration(ProxyResource):
    """DevOps Configuration resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar properties: DevOps Configuration properties.
    :vartype properties: ~azure.mgmt.security.models.DevOpsConfigurationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DevOpsConfigurationProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DevOpsConfigurationProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: DevOps Configuration properties.
        :paramtype properties: ~azure.mgmt.security.models.DevOpsConfigurationProperties
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.properties = properties


class DevOpsConfigurationListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.models.DevOpsConfiguration]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DevOpsConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DevOpsConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.models.DevOpsConfiguration]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DevOpsConfigurationProperties(_serialization.Model):
    """DevOps Configuration properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets the resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets the time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.DevOpsProvisioningState
    :ivar authorization: Authorization payload.
    :vartype authorization: ~azure.mgmt.security.models.Authorization
    :ivar auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
     "NotApplicable".
    :vartype auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
    :ivar top_level_inventory_list: List of top-level inventory to select when AutoDiscovery is
     disabled.
     This field is ignored when AutoDiscovery is enabled.
    :vartype top_level_inventory_list: list[str]
    :ivar capabilities: List of capabilities assigned to the DevOps configuration during the
     discovery process.
    :vartype capabilities: list[~azure.mgmt.security.models.DevOpsCapability]
    :ivar agentless_configuration: Details about Agentless configuration.
    :vartype agentless_configuration: ~azure.mgmt.security.models.AgentlessConfiguration
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "authorization": {"key": "authorization", "type": "Authorization"},
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "top_level_inventory_list": {"key": "topLevelInventoryList", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[DevOpsCapability]"},
        "agentless_configuration": {"key": "agentlessConfiguration", "type": "AgentlessConfiguration"},
    }

    def __init__(
        self,
        *,
        authorization: Optional["_models.Authorization"] = None,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        top_level_inventory_list: Optional[List[str]] = None,
        agentless_configuration: Optional["_models.AgentlessConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authorization: Authorization payload.
        :paramtype authorization: ~azure.mgmt.security.models.Authorization
        :keyword auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
         "NotApplicable".
        :paramtype auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
        :keyword top_level_inventory_list: List of top-level inventory to select when AutoDiscovery is
         disabled.
         This field is ignored when AutoDiscovery is enabled.
        :paramtype top_level_inventory_list: list[str]
        :keyword agentless_configuration: Details about Agentless configuration.
        :paramtype agentless_configuration: ~azure.mgmt.security.models.AgentlessConfiguration
        """
        super().__init__(**kwargs)
        self.provisioning_status_message: Optional[str] = None
        self.provisioning_status_update_time_utc: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None
        self.authorization = authorization
        self.auto_discovery = auto_discovery
        self.top_level_inventory_list = top_level_inventory_list
        self.capabilities: Optional[List["_models.DevOpsCapability"]] = None
        self.agentless_configuration = agentless_configuration


class DirectMethodInvokesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of direct method invokes is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "DirectMethodInvokesNotInAllowedRange"


class DiscoveredSecuritySolution(Resource, Location):
    """DiscoveredSecuritySolution.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar security_family: The security family of the discovered solution. Required. Known values
     are: "Waf", "Ngfw", "SaasWaf", and "Va".
    :vartype security_family: str or ~azure.mgmt.security.models.SecurityFamily
    :ivar offer: The security solutions' image offer. Required.
    :vartype offer: str
    :ivar publisher: The security solutions' image publisher. Required.
    :vartype publisher: str
    :ivar sku: The security solutions' image sku. Required.
    :vartype sku: str
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "security_family": {"required": True},
        "offer": {"required": True},
        "publisher": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "security_family": {"key": "properties.securityFamily", "type": "str"},
        "offer": {"key": "properties.offer", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "sku": {"key": "properties.sku", "type": "str"},
    }

    def __init__(
        self,
        *,
        security_family: Union[str, "_models.SecurityFamily"],
        offer: str,
        publisher: str,
        sku: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword security_family: The security family of the discovered solution. Required. Known
         values are: "Waf", "Ngfw", "SaasWaf", and "Va".
        :paramtype security_family: str or ~azure.mgmt.security.models.SecurityFamily
        :keyword offer: The security solutions' image offer. Required.
        :paramtype offer: str
        :keyword publisher: The security solutions' image publisher. Required.
        :paramtype publisher: str
        :keyword sku: The security solutions' image sku. Required.
        :paramtype sku: str
        """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.security_family = security_family
        self.offer = offer
        self.publisher = publisher
        self.sku = sku
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class DiscoveredSecuritySolutionList(_serialization.Model):
    """DiscoveredSecuritySolutionList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.DiscoveredSecuritySolution]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiscoveredSecuritySolution]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DiscoveredSecuritySolution"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.models.DiscoveredSecuritySolution]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DockerHubEnvironmentData(EnvironmentData):
    """The Docker Hub connector environment data.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", "GitlabScope",
     "DockerHubOrganization", and "JFrogArtifactory".
    :vartype environment_type: str or ~azure.mgmt.security.models.EnvironmentType
    :ivar authentication: The Docker Hub organization authentication details.
    :vartype authentication: ~azure.mgmt.security.models.Authentication
    :ivar scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
    :vartype scan_interval: int
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
        "authentication": {"key": "authentication", "type": "Authentication"},
        "scan_interval": {"key": "scanInterval", "type": "int"},
    }

    def __init__(
        self,
        *,
        authentication: Optional["_models.Authentication"] = None,
        scan_interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authentication: The Docker Hub organization authentication details.
        :paramtype authentication: ~azure.mgmt.security.models.Authentication
        :keyword scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
        :paramtype scan_interval: int
        """
        super().__init__(**kwargs)
        self.environment_type: str = "DockerHubOrganization"
        self.authentication = authentication
        self.scan_interval = scan_interval


class EdgeIdentifiers(_serialization.Model):
    """Represents an edge in the path.

    All required parameters must be populated in order to send to server.

    :ivar source: The source node of the edge. Required.
    :vartype source: str
    :ivar target: The target node of the edge. Required.
    :vartype target: str
    :ivar type: The type of the edge. Required.
    :vartype type: str
    """

    _validation = {
        "source": {"required": True},
        "target": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, source: str, target: str, type: str, **kwargs: Any) -> None:
        """
        :keyword source: The source node of the edge. Required.
        :paramtype source: str
        :keyword target: The target node of the edge. Required.
        :paramtype target: str
        :keyword type: The type of the edge. Required.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.source = source
        self.target = target
        self.type = type


class EnvironmentDetails(_serialization.Model):
    """The environment details of the resource.

    :ivar native_resource_id: The native resource id of the resource (in case of Azure - the
     resource Id, in case of MC - the native resource id).
    :vartype native_resource_id: str
    :ivar environment_hierarchy_id: The hierarchy id of the connector (in case of Azure - the
     subscription Id, in case of MC - the hierarchyId id).
    :vartype environment_hierarchy_id: str
    :ivar organizational_hierarchy_id: The organizational hierarchy id of the connector (in case of
     Azure - the subscription Id, in case of MC - the organizational hierarchyId id).
    :vartype organizational_hierarchy_id: str
    :ivar subscription_id: The subscription Id.
    :vartype subscription_id: str
    :ivar tenant_id: The tenant Id.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "native_resource_id": {"key": "nativeResourceId", "type": "str"},
        "environment_hierarchy_id": {"key": "environmentHierarchyId", "type": "str"},
        "organizational_hierarchy_id": {"key": "organizationalHierarchyId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        native_resource_id: Optional[str] = None,
        environment_hierarchy_id: Optional[str] = None,
        organizational_hierarchy_id: Optional[str] = None,
        subscription_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword native_resource_id: The native resource id of the resource (in case of Azure - the
         resource Id, in case of MC - the native resource id).
        :paramtype native_resource_id: str
        :keyword environment_hierarchy_id: The hierarchy id of the connector (in case of Azure - the
         subscription Id, in case of MC - the hierarchyId id).
        :paramtype environment_hierarchy_id: str
        :keyword organizational_hierarchy_id: The organizational hierarchy id of the connector (in case
         of Azure - the subscription Id, in case of MC - the organizational hierarchyId id).
        :paramtype organizational_hierarchy_id: str
        :keyword subscription_id: The subscription Id.
        :paramtype subscription_id: str
        :keyword tenant_id: The tenant Id.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.native_resource_id = native_resource_id
        self.environment_hierarchy_id = environment_hierarchy_id
        self.organizational_hierarchy_id = organizational_hierarchy_id
        self.subscription_id = subscription_id
        self.tenant_id = tenant_id


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorDetailAutoGenerated(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.models.ErrorDetailAutoGenerated]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetailAutoGenerated]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetailAutoGenerated"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorDetailAutoGenerated2(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.models.ErrorDetailAutoGenerated2]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetailAutoGenerated2]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetailAutoGenerated2"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.security.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.security.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.security.models.ErrorDetailAutoGenerated
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetailAutoGenerated"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetailAutoGenerated"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.security.models.ErrorDetailAutoGenerated
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated2(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.security.models.ErrorDetailAutoGenerated2
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetailAutoGenerated2"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetailAutoGenerated2"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.security.models.ErrorDetailAutoGenerated2
        """
        super().__init__(**kwargs)
        self.error = error


class ExecuteGovernanceRuleParams(_serialization.Model):
    """Governance rule execution parameters.

    :ivar override: Describe if governance rule should be override.
    :vartype override: bool
    """

    _attribute_map = {
        "override": {"key": "override", "type": "bool"},
    }

    def __init__(self, *, override: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword override: Describe if governance rule should be override.
        :paramtype override: bool
        """
        super().__init__(**kwargs)
        self.override = override


class Extension(_serialization.Model):
    """A plan's extension properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: The extension name. Supported values are: :code:`<br>`\\ :code:`<br>`\\
     **AgentlessDiscoveryForKubernetes** - Provides zero footprint, API-based discovery of
     Kubernetes clusters, their configurations and deployments. The collected data is used to create
     a contextualized security graph for Kubernetes clusters, provide risk hunting capabilities, and
     visualize risks and threats to  Kubernetes environments and workloads.\\ :code:`<br>`Available
     for CloudPosture plan and Containers plan.\\ :code:`<br>`\\ :code:`<br>`\\
     **OnUploadMalwareScanning** - Limits the GB to be scanned per month for each storage account
     within the subscription. Once this limit reached on a given storage account, Blobs won't be
     scanned during current calendar month.\\ :code:`<br>`Available for StorageAccounts plan
     (DefenderForStorageV2 sub plans).\\ :code:`<br>`\\ :code:`<br>`\\ **SensitiveDataDiscovery** -
     Sensitive data discovery identifies Blob storage container with sensitive data such as
     credentials, credit cards, and more, to help prioritize and investigate security events.\\
     :code:`<br>`Available for StorageAccounts plan (DefenderForStorageV2 sub plan) and CloudPosture
     plan.\\ :code:`<br>`\\ :code:`<br>`\\ **ContainerRegistriesVulnerabilityAssessments** -
     Provides vulnerability management for images stored in your container registries.\\
     :code:`<br>`Available for CloudPosture plan and Containers plan.\\ :code:`<br>`\\
     :code:`<br>`\\ **MdeDesignatedSubscription** - Direct onboarding is a seamless integration
     between Defender for Endpoint and Defender for Cloud that doesn’t require extra software
     deployment on your servers. The onboarded resources will be presented under a designated Azure
     Subscription you configure\\ :code:`<br>`Available for VirtualMachines plan (P1 and P2 sub
     plans).\\ :code:`<br>`\\ :code:`<br>`\\ **AgentlessVmScanning** - Scans your machines for
     installed software, vulnerabilities, malware and secret scanning without relying on agents or
     impacting machine performance. Learn more here
     https://learn.microsoft.com/en-us/azure/defender-for-cloud/concept-agentless-data-collection.\\
     :code:`<br>`Available for CloudPosture plan, VirtualMachines plan (P2 sub plan) and Containers
     plan.\\ :code:`<br>`\\ :code:`<br>`\\ **EntraPermissionsManagement** - Permissions Management
     provides Cloud Infrastructure Entitlement Management (CIEM) capabilities that helps
     organizations to manage and control user access and entitlements in their cloud infrastructure
     - important attack vector for cloud environments.\\ :code:`<br>`Permissions Management analyzes
     all permissions and active usage, and suggests recommendations to reduce permissions to enforce
     the principle of least privilege. Learn more here
     https://learn.microsoft.com/en-us/azure/defender-for-cloud/permissions-management.\\
     :code:`<br>`Available for CloudPosture plan. :code:`<br>`\\ :code:`<br>`\\
     **FileIntegrityMonitoring** - File integrity monitoring (FIM), examines operating system
     files.\\ :code:`<br>`Windows registries, Linux system files, in real time, for changes that
     might indicate an attack.\\ :code:`<br>`Available for VirtualMachines plan (P2 sub plan).
     :code:`<br>`\\ :code:`<br>`\\ **ContainerSensor** - The sensor is based on IG and provides a
     rich threat detection suite for Kubernetes clusters, nodes, and workloads, powered by Microsoft
     leading threat intelligence, provides mapping to MITRE ATT&CK framework.\\
     :code:`<br>`Available for Containers plan. :code:`<br>`\\ :code:`<br>`\\ **AIPromptEvidence** -
     Exposes the prompts passed between the user and the AI model as alert evidence. This helps
     classify and triage the alerts with relevant user context. The prompt snippets will include
     only segments of the user prompt or model response that were deemed suspicious and relevant for
     security classifications. The prompt evidence will be available through Defender portal as part
     of each alert.\\ :code:`<br>`Available for AI plan. :code:`<br>`\\ :code:`<br>`. Required.
    :vartype name: str
    :ivar is_enabled: Indicates whether the extension is enabled. Required. Known values are:
     "True" and "False".
    :vartype is_enabled: str or ~azure.mgmt.security.models.IsEnabled
    :ivar additional_extension_properties: Property values associated with the extension.
    :vartype additional_extension_properties: dict[str, any]
    :ivar operation_status: Optional. A status describing the success/failure of the extension's
     enablement/disablement operation.
    :vartype operation_status: ~azure.mgmt.security.models.OperationStatusAutoGenerated
    """

    _validation = {
        "name": {"required": True},
        "is_enabled": {"required": True},
        "operation_status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "str"},
        "additional_extension_properties": {"key": "additionalExtensionProperties", "type": "{object}"},
        "operation_status": {"key": "operationStatus", "type": "OperationStatusAutoGenerated"},
    }

    def __init__(
        self,
        *,
        name: str,
        is_enabled: Union[str, "_models.IsEnabled"],
        additional_extension_properties: Optional[Dict[str, Any]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The extension name. Supported values are: :code:`<br>`\\ :code:`<br>`\\
         **AgentlessDiscoveryForKubernetes** - Provides zero footprint, API-based discovery of
         Kubernetes clusters, their configurations and deployments. The collected data is used to create
         a contextualized security graph for Kubernetes clusters, provide risk hunting capabilities, and
         visualize risks and threats to  Kubernetes environments and workloads.\\ :code:`<br>`Available
         for CloudPosture plan and Containers plan.\\ :code:`<br>`\\ :code:`<br>`\\
         **OnUploadMalwareScanning** - Limits the GB to be scanned per month for each storage account
         within the subscription. Once this limit reached on a given storage account, Blobs won't be
         scanned during current calendar month.\\ :code:`<br>`Available for StorageAccounts plan
         (DefenderForStorageV2 sub plans).\\ :code:`<br>`\\ :code:`<br>`\\ **SensitiveDataDiscovery** -
         Sensitive data discovery identifies Blob storage container with sensitive data such as
         credentials, credit cards, and more, to help prioritize and investigate security events.\\
         :code:`<br>`Available for StorageAccounts plan (DefenderForStorageV2 sub plan) and CloudPosture
         plan.\\ :code:`<br>`\\ :code:`<br>`\\ **ContainerRegistriesVulnerabilityAssessments** -
         Provides vulnerability management for images stored in your container registries.\\
         :code:`<br>`Available for CloudPosture plan and Containers plan.\\ :code:`<br>`\\
         :code:`<br>`\\ **MdeDesignatedSubscription** - Direct onboarding is a seamless integration
         between Defender for Endpoint and Defender for Cloud that doesn’t require extra software
         deployment on your servers. The onboarded resources will be presented under a designated Azure
         Subscription you configure\\ :code:`<br>`Available for VirtualMachines plan (P1 and P2 sub
         plans).\\ :code:`<br>`\\ :code:`<br>`\\ **AgentlessVmScanning** - Scans your machines for
         installed software, vulnerabilities, malware and secret scanning without relying on agents or
         impacting machine performance. Learn more here
         https://learn.microsoft.com/en-us/azure/defender-for-cloud/concept-agentless-data-collection.\\
         :code:`<br>`Available for CloudPosture plan, VirtualMachines plan (P2 sub plan) and Containers
         plan.\\ :code:`<br>`\\ :code:`<br>`\\ **EntraPermissionsManagement** - Permissions Management
         provides Cloud Infrastructure Entitlement Management (CIEM) capabilities that helps
         organizations to manage and control user access and entitlements in their cloud infrastructure
         - important attack vector for cloud environments.\\ :code:`<br>`Permissions Management analyzes
         all permissions and active usage, and suggests recommendations to reduce permissions to enforce
         the principle of least privilege. Learn more here
         https://learn.microsoft.com/en-us/azure/defender-for-cloud/permissions-management.\\
         :code:`<br>`Available for CloudPosture plan. :code:`<br>`\\ :code:`<br>`\\
         **FileIntegrityMonitoring** - File integrity monitoring (FIM), examines operating system
         files.\\ :code:`<br>`Windows registries, Linux system files, in real time, for changes that
         might indicate an attack.\\ :code:`<br>`Available for VirtualMachines plan (P2 sub plan).
         :code:`<br>`\\ :code:`<br>`\\ **ContainerSensor** - The sensor is based on IG and provides a
         rich threat detection suite for Kubernetes clusters, nodes, and workloads, powered by Microsoft
         leading threat intelligence, provides mapping to MITRE ATT&CK framework.\\
         :code:`<br>`Available for Containers plan. :code:`<br>`\\ :code:`<br>`\\ **AIPromptEvidence** -
         Exposes the prompts passed between the user and the AI model as alert evidence. This helps
         classify and triage the alerts with relevant user context. The prompt snippets will include
         only segments of the user prompt or model response that were deemed suspicious and relevant for
         security classifications. The prompt evidence will be available through Defender portal as part
         of each alert.\\ :code:`<br>`Available for AI plan. :code:`<br>`\\ :code:`<br>`. Required.
        :paramtype name: str
        :keyword is_enabled: Indicates whether the extension is enabled. Required. Known values are:
         "True" and "False".
        :paramtype is_enabled: str or ~azure.mgmt.security.models.IsEnabled
        :keyword additional_extension_properties: Property values associated with the extension.
        :paramtype additional_extension_properties: dict[str, any]
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_enabled = is_enabled
        self.additional_extension_properties = additional_extension_properties
        self.operation_status: Optional["_models.OperationStatusAutoGenerated"] = None


class ExternalSecuritySolutionList(_serialization.Model):
    """ExternalSecuritySolutionList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.ExternalSecuritySolution]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExternalSecuritySolution]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ExternalSecuritySolution"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.models.ExternalSecuritySolution]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class FailedLocalLoginsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of failed local logins is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "FailedLocalLoginsNotInAllowedRange"


class FileUploadsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of file uploads is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "FileUploadsNotInAllowedRange"


class GcpCredentialsDetailsProperties(AuthenticationDetailsProperties):
    """GCP cloud account connector based service to service credentials, the credentials are composed
    of the organization ID and a JSON API key (write only).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar authentication_provisioning_state: State of the multi-cloud connector. Known values are:
     "Valid", "Invalid", "Expired", and "IncorrectPolicy".
    :vartype authentication_provisioning_state: str or
     ~azure.mgmt.security.models.AuthenticationProvisioningState
    :ivar granted_permissions: The permissions detected in the cloud account.
    :vartype granted_permissions: list[str or ~azure.mgmt.security.models.PermissionProperty]
    :ivar authentication_type: Connect to your cloud account, for AWS use either account
     credentials or role-based authentication. For GCP use account organization credentials.
     Required. Known values are: "awsCreds", "awsAssumeRole", and "gcpCredentials".
    :vartype authentication_type: str or ~azure.mgmt.security.models.AuthenticationType
    :ivar organization_id: The organization ID of the GCP cloud account. Required.
    :vartype organization_id: str
    :ivar type: Type field of the API key (write only). Required.
    :vartype type: str
    :ivar project_id: Project ID field of the API key (write only). Required.
    :vartype project_id: str
    :ivar private_key_id: Private key ID field of the API key (write only). Required.
    :vartype private_key_id: str
    :ivar private_key: Private key field of the API key (write only). Required.
    :vartype private_key: str
    :ivar client_email: Client email field of the API key (write only). Required.
    :vartype client_email: str
    :ivar client_id: Client ID field of the API key (write only). Required.
    :vartype client_id: str
    :ivar auth_uri: Auth URI field of the API key (write only). Required.
    :vartype auth_uri: str
    :ivar token_uri: Token URI field of the API key (write only). Required.
    :vartype token_uri: str
    :ivar auth_provider_x509_cert_url: Auth provider x509 certificate URL field of the API key
     (write only). Required.
    :vartype auth_provider_x509_cert_url: str
    :ivar client_x509_cert_url: Client x509 certificate URL field of the API key (write only).
     Required.
    :vartype client_x509_cert_url: str
    """

    _validation = {
        "authentication_provisioning_state": {"readonly": True},
        "granted_permissions": {"readonly": True},
        "authentication_type": {"required": True},
        "organization_id": {"required": True},
        "type": {"required": True},
        "project_id": {"required": True},
        "private_key_id": {"required": True},
        "private_key": {"required": True},
        "client_email": {"required": True},
        "client_id": {"required": True},
        "auth_uri": {"required": True},
        "token_uri": {"required": True},
        "auth_provider_x509_cert_url": {"required": True},
        "client_x509_cert_url": {"required": True},
    }

    _attribute_map = {
        "authentication_provisioning_state": {"key": "authenticationProvisioningState", "type": "str"},
        "granted_permissions": {"key": "grantedPermissions", "type": "[str]"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "organization_id": {"key": "organizationId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "project_id": {"key": "projectId", "type": "str"},
        "private_key_id": {"key": "privateKeyId", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
        "client_email": {"key": "clientEmail", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "auth_uri": {"key": "authUri", "type": "str"},
        "token_uri": {"key": "tokenUri", "type": "str"},
        "auth_provider_x509_cert_url": {"key": "authProviderX509CertUrl", "type": "str"},
        "client_x509_cert_url": {"key": "clientX509CertUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        organization_id: str,
        type: str,
        project_id: str,
        private_key_id: str,
        private_key: str,
        client_email: str,
        client_id: str,
        auth_uri: str,
        token_uri: str,
        auth_provider_x509_cert_url: str,
        client_x509_cert_url: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword organization_id: The organization ID of the GCP cloud account. Required.
        :paramtype organization_id: str
        :keyword type: Type field of the API key (write only). Required.
        :paramtype type: str
        :keyword project_id: Project ID field of the API key (write only). Required.
        :paramtype project_id: str
        :keyword private_key_id: Private key ID field of the API key (write only). Required.
        :paramtype private_key_id: str
        :keyword private_key: Private key field of the API key (write only). Required.
        :paramtype private_key: str
        :keyword client_email: Client email field of the API key (write only). Required.
        :paramtype client_email: str
        :keyword client_id: Client ID field of the API key (write only). Required.
        :paramtype client_id: str
        :keyword auth_uri: Auth URI field of the API key (write only). Required.
        :paramtype auth_uri: str
        :keyword token_uri: Token URI field of the API key (write only). Required.
        :paramtype token_uri: str
        :keyword auth_provider_x509_cert_url: Auth provider x509 certificate URL field of the API key
         (write only). Required.
        :paramtype auth_provider_x509_cert_url: str
        :keyword client_x509_cert_url: Client x509 certificate URL field of the API key (write only).
         Required.
        :paramtype client_x509_cert_url: str
        """
        super().__init__(**kwargs)
        self.authentication_type: str = "gcpCredentials"
        self.organization_id = organization_id
        self.type = type
        self.project_id = project_id
        self.private_key_id = private_key_id
        self.private_key = private_key
        self.client_email = client_email
        self.client_id = client_id
        self.auth_uri = auth_uri
        self.token_uri = token_uri
        self.auth_provider_x509_cert_url = auth_provider_x509_cert_url
        self.client_x509_cert_url = client_x509_cert_url


class GcpOrganizationalData(_serialization.Model):
    """The gcpOrganization data.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    GcpOrganizationalDataMember, GcpOrganizationalDataOrganization

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.models.OrganizationMembershipType
    """

    _validation = {
        "organization_membership_type": {"required": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
    }

    _subtype_map = {
        "organization_membership_type": {
            "Member": "GcpOrganizationalDataMember",
            "Organization": "GcpOrganizationalDataOrganization",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.organization_membership_type: Optional[str] = None


class GcpOrganizationalDataMember(GcpOrganizationalData):
    """The gcpOrganization data for the member account.

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.models.OrganizationMembershipType
    :ivar parent_hierarchy_id: If the multi cloud account is not of membership type organization,
     this will be the ID of the project's parent.
    :vartype parent_hierarchy_id: str
    :ivar management_project_number: The GCP management project number from organizational
     onboarding.
    :vartype management_project_number: str
    """

    _validation = {
        "organization_membership_type": {"required": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
        "parent_hierarchy_id": {"key": "parentHierarchyId", "type": "str"},
        "management_project_number": {"key": "managementProjectNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        parent_hierarchy_id: Optional[str] = None,
        management_project_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword parent_hierarchy_id: If the multi cloud account is not of membership type
         organization, this will be the ID of the project's parent.
        :paramtype parent_hierarchy_id: str
        :keyword management_project_number: The GCP management project number from organizational
         onboarding.
        :paramtype management_project_number: str
        """
        super().__init__(**kwargs)
        self.organization_membership_type: str = "Member"
        self.parent_hierarchy_id = parent_hierarchy_id
        self.management_project_number = management_project_number


class GcpOrganizationalDataOrganization(GcpOrganizationalData):
    """The gcpOrganization data for the parent account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.models.OrganizationMembershipType
    :ivar excluded_project_numbers: If the multi cloud account is of membership type organization,
     list of accounts excluded from offering.
    :vartype excluded_project_numbers: list[str]
    :ivar service_account_email_address: The service account email address which represents the
     organization level permissions container.
    :vartype service_account_email_address: str
    :ivar workload_identity_provider_id: The GCP workload identity provider id which represents the
     permissions required to auto provision security connectors.
    :vartype workload_identity_provider_id: str
    :ivar organization_name: GCP organization name.
    :vartype organization_name: str
    """

    _validation = {
        "organization_membership_type": {"required": True},
        "organization_name": {"readonly": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
        "excluded_project_numbers": {"key": "excludedProjectNumbers", "type": "[str]"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "organization_name": {"key": "organizationName", "type": "str"},
    }

    def __init__(
        self,
        *,
        excluded_project_numbers: Optional[List[str]] = None,
        service_account_email_address: Optional[str] = None,
        workload_identity_provider_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword excluded_project_numbers: If the multi cloud account is of membership type
         organization, list of accounts excluded from offering.
        :paramtype excluded_project_numbers: list[str]
        :keyword service_account_email_address: The service account email address which represents the
         organization level permissions container.
        :paramtype service_account_email_address: str
        :keyword workload_identity_provider_id: The GCP workload identity provider id which represents
         the permissions required to auto provision security connectors.
        :paramtype workload_identity_provider_id: str
        """
        super().__init__(**kwargs)
        self.organization_membership_type: str = "Organization"
        self.excluded_project_numbers = excluded_project_numbers
        self.service_account_email_address = service_account_email_address
        self.workload_identity_provider_id = workload_identity_provider_id
        self.organization_name: Optional[str] = None


class GcpProjectDetails(_serialization.Model):
    """The details about the project represented by the security connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar project_number: The unique GCP Project number.
    :vartype project_number: str
    :ivar project_id: The GCP Project id.
    :vartype project_id: str
    :ivar workload_identity_pool_id: The GCP workload identity federation pool id.
    :vartype workload_identity_pool_id: str
    :ivar project_name: GCP project name.
    :vartype project_name: str
    """

    _validation = {
        "workload_identity_pool_id": {"readonly": True},
        "project_name": {"readonly": True},
    }

    _attribute_map = {
        "project_number": {"key": "projectNumber", "type": "str"},
        "project_id": {"key": "projectId", "type": "str"},
        "workload_identity_pool_id": {"key": "workloadIdentityPoolId", "type": "str"},
        "project_name": {"key": "projectName", "type": "str"},
    }

    def __init__(
        self, *, project_number: Optional[str] = None, project_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword project_number: The unique GCP Project number.
        :paramtype project_number: str
        :keyword project_id: The GCP Project id.
        :paramtype project_id: str
        """
        super().__init__(**kwargs)
        self.project_number = project_number
        self.project_id = project_id
        self.workload_identity_pool_id: Optional[str] = None
        self.project_name: Optional[str] = None


class GcpProjectEnvironmentData(EnvironmentData):
    """The GCP project connector environment data.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", "GitlabScope",
     "DockerHubOrganization", and "JFrogArtifactory".
    :vartype environment_type: str or ~azure.mgmt.security.models.EnvironmentType
    :ivar organizational_data: The Gcp project's organizational data.
    :vartype organizational_data: ~azure.mgmt.security.models.GcpOrganizationalData
    :ivar project_details: The Gcp project's details.
    :vartype project_details: ~azure.mgmt.security.models.GcpProjectDetails
    :ivar scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
    :vartype scan_interval: int
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
        "organizational_data": {"key": "organizationalData", "type": "GcpOrganizationalData"},
        "project_details": {"key": "projectDetails", "type": "GcpProjectDetails"},
        "scan_interval": {"key": "scanInterval", "type": "int"},
    }

    def __init__(
        self,
        *,
        organizational_data: Optional["_models.GcpOrganizationalData"] = None,
        project_details: Optional["_models.GcpProjectDetails"] = None,
        scan_interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword organizational_data: The Gcp project's organizational data.
        :paramtype organizational_data: ~azure.mgmt.security.models.GcpOrganizationalData
        :keyword project_details: The Gcp project's details.
        :paramtype project_details: ~azure.mgmt.security.models.GcpProjectDetails
        :keyword scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
        :paramtype scan_interval: int
        """
        super().__init__(**kwargs)
        self.environment_type: str = "GcpProject"
        self.organizational_data = organizational_data
        self.project_details = project_details
        self.scan_interval = scan_interval


class GetSensitivitySettingsListResponse(_serialization.Model):
    """A list with a single sensitivity settings resource.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.GetSensitivitySettingsResponse]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GetSensitivitySettingsResponse]"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GetSensitivitySettingsResponse"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.models.GetSensitivitySettingsResponse]
        """
        super().__init__(**kwargs)
        self.value = value


class GetSensitivitySettingsResponse(_serialization.Model):
    """Data sensitivity settings for sensitive data discovery.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the sensitivity settings.
    :vartype id: str
    :ivar type: The type of the sensitivity settings.
    :vartype type: str
    :ivar name: The name of the sensitivity settings.
    :vartype name: str
    :ivar properties: The sensitivity settings properties.
    :vartype properties: ~azure.mgmt.security.models.GetSensitivitySettingsResponseProperties
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "GetSensitivitySettingsResponseProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.GetSensitivitySettingsResponseProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The sensitivity settings properties.
        :paramtype properties: ~azure.mgmt.security.models.GetSensitivitySettingsResponseProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.name: Optional[str] = None
        self.properties = properties


class GetSensitivitySettingsResponseProperties(_serialization.Model):
    """The sensitivity settings properties.

    :ivar sensitive_info_types_ids: List of selected sensitive info types' IDs.
    :vartype sensitive_info_types_ids: list[str]
    :ivar sensitivity_threshold_label_order: The order of the sensitivity threshold label. Any
     label at or above this order will be considered sensitive. If set to -1, sensitivity by labels
     is turned off.
    :vartype sensitivity_threshold_label_order: float
    :ivar sensitivity_threshold_label_id: The id of the sensitivity threshold label. Any label at
     or above this rank will be considered sensitive.
    :vartype sensitivity_threshold_label_id: str
    :ivar mip_information: Microsoft information protection built-in and custom information types,
     labels, and integration status.
    :vartype mip_information:
     ~azure.mgmt.security.models.GetSensitivitySettingsResponsePropertiesMipInformation
    """

    _attribute_map = {
        "sensitive_info_types_ids": {"key": "sensitiveInfoTypesIds", "type": "[str]"},
        "sensitivity_threshold_label_order": {"key": "sensitivityThresholdLabelOrder", "type": "float"},
        "sensitivity_threshold_label_id": {"key": "sensitivityThresholdLabelId", "type": "str"},
        "mip_information": {"key": "mipInformation", "type": "GetSensitivitySettingsResponsePropertiesMipInformation"},
    }

    def __init__(
        self,
        *,
        sensitive_info_types_ids: Optional[List[str]] = None,
        sensitivity_threshold_label_order: Optional[float] = None,
        sensitivity_threshold_label_id: Optional[str] = None,
        mip_information: Optional["_models.GetSensitivitySettingsResponsePropertiesMipInformation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sensitive_info_types_ids: List of selected sensitive info types' IDs.
        :paramtype sensitive_info_types_ids: list[str]
        :keyword sensitivity_threshold_label_order: The order of the sensitivity threshold label. Any
         label at or above this order will be considered sensitive. If set to -1, sensitivity by labels
         is turned off.
        :paramtype sensitivity_threshold_label_order: float
        :keyword sensitivity_threshold_label_id: The id of the sensitivity threshold label. Any label
         at or above this rank will be considered sensitive.
        :paramtype sensitivity_threshold_label_id: str
        :keyword mip_information: Microsoft information protection built-in and custom information
         types, labels, and integration status.
        :paramtype mip_information:
         ~azure.mgmt.security.models.GetSensitivitySettingsResponsePropertiesMipInformation
        """
        super().__init__(**kwargs)
        self.sensitive_info_types_ids = sensitive_info_types_ids
        self.sensitivity_threshold_label_order = sensitivity_threshold_label_order
        self.sensitivity_threshold_label_id = sensitivity_threshold_label_id
        self.mip_information = mip_information


class GetSensitivitySettingsResponsePropertiesMipInformation(_serialization.Model):  # pylint: disable=name-too-long
    """Microsoft information protection built-in and custom information types, labels, and integration
    status.

    :ivar mip_integration_status: Microsoft information protection integration status. Known values
     are: "Ok", "noConsent", "noAutoLabelingRules", and "noMipLabels".
    :vartype mip_integration_status: str or ~azure.mgmt.security.models.MipIntegrationStatus
    :ivar labels: List of Microsoft information protection sensitivity labels.
    :vartype labels: list[~azure.mgmt.security.models.Label]
    :ivar custom_info_types: List of custom user-defined information types.
    :vartype custom_info_types: list[~azure.mgmt.security.models.InfoType]
    :ivar built_in_info_types: List of pre-configured sensitive information types.
    :vartype built_in_info_types: list[~azure.mgmt.security.models.BuiltInInfoType]
    """

    _attribute_map = {
        "mip_integration_status": {"key": "mipIntegrationStatus", "type": "str"},
        "labels": {"key": "labels", "type": "[Label]"},
        "custom_info_types": {"key": "customInfoTypes", "type": "[InfoType]"},
        "built_in_info_types": {"key": "builtInInfoTypes", "type": "[BuiltInInfoType]"},
    }

    def __init__(
        self,
        *,
        mip_integration_status: Optional[Union[str, "_models.MipIntegrationStatus"]] = None,
        labels: Optional[List["_models.Label"]] = None,
        custom_info_types: Optional[List["_models.InfoType"]] = None,
        built_in_info_types: Optional[List["_models.BuiltInInfoType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mip_integration_status: Microsoft information protection integration status. Known
         values are: "Ok", "noConsent", "noAutoLabelingRules", and "noMipLabels".
        :paramtype mip_integration_status: str or ~azure.mgmt.security.models.MipIntegrationStatus
        :keyword labels: List of Microsoft information protection sensitivity labels.
        :paramtype labels: list[~azure.mgmt.security.models.Label]
        :keyword custom_info_types: List of custom user-defined information types.
        :paramtype custom_info_types: list[~azure.mgmt.security.models.InfoType]
        :keyword built_in_info_types: List of pre-configured sensitive information types.
        :paramtype built_in_info_types: list[~azure.mgmt.security.models.BuiltInInfoType]
        """
        super().__init__(**kwargs)
        self.mip_integration_status = mip_integration_status
        self.labels = labels
        self.custom_info_types = custom_info_types
        self.built_in_info_types = built_in_info_types


class GitHubOwner(ProxyResource):
    """GitHub Owner resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar properties: GitHub Owner properties.
    :vartype properties: ~azure.mgmt.security.models.GitHubOwnerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitHubOwnerProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitHubOwnerProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: GitHub Owner properties.
        :paramtype properties: ~azure.mgmt.security.models.GitHubOwnerProperties
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.properties = properties


class GitHubOwnerConfiguration(_serialization.Model):
    """GitHub Owner Inventory Configuration.

    :ivar auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
     "NotApplicable".
    :vartype auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
    :ivar repository_configs: GitHub Repository Inventory Configuration.
     Dictionary of GitHub repository name to desired repository configuration.
     If AutoDiscovery is Enabled, this field should be null or empty.
    :vartype repository_configs: dict[str, ~azure.mgmt.security.models.BaseResourceConfiguration]
    """

    _attribute_map = {
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "repository_configs": {"key": "repositoryConfigs", "type": "{BaseResourceConfiguration}"},
    }

    def __init__(
        self,
        *,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        repository_configs: Optional[Dict[str, "_models.BaseResourceConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
         "NotApplicable".
        :paramtype auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
        :keyword repository_configs: GitHub Repository Inventory Configuration.
         Dictionary of GitHub repository name to desired repository configuration.
         If AutoDiscovery is Enabled, this field should be null or empty.
        :paramtype repository_configs: dict[str, ~azure.mgmt.security.models.BaseResourceConfiguration]
        """
        super().__init__(**kwargs)
        self.auto_discovery = auto_discovery
        self.repository_configs = repository_configs


class GitHubOwnerListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.models.GitHubOwner]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitHubOwner]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GitHubOwner"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.models.GitHubOwner]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitHubOwnerProperties(_serialization.Model):
    """GitHub Owner properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets the resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets the time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.DevOpsProvisioningState
    :ivar owner_url: Gets or sets GitHub Owner url.
    :vartype owner_url: str
    :ivar git_hub_internal_id: Gets or sets internal GitHub id.
    :vartype git_hub_internal_id: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
     is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "owner_url": {"readonly": True},
        "git_hub_internal_id": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "owner_url": {"key": "ownerUrl", "type": "str"},
        "git_hub_internal_id": {"key": "gitHubInternalId", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
    }

    def __init__(
        self, *, onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
         is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
        """
        super().__init__(**kwargs)
        self.provisioning_status_message: Optional[str] = None
        self.provisioning_status_update_time_utc: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None
        self.owner_url: Optional[str] = None
        self.git_hub_internal_id: Optional[str] = None
        self.onboarding_state = onboarding_state


class GitHubRepository(ProxyResource):
    """GitHub Repository resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar properties: GitHub Repository properties.
    :vartype properties: ~azure.mgmt.security.models.GitHubRepositoryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitHubRepositoryProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitHubRepositoryProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: GitHub Repository properties.
        :paramtype properties: ~azure.mgmt.security.models.GitHubRepositoryProperties
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.properties = properties


class GitHubRepositoryListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.models.GitHubRepository]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitHubRepository]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.GitHubRepository"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.models.GitHubRepository]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitHubRepositoryProperties(_serialization.Model):
    """GitHub Repository properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets the resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets the time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.DevOpsProvisioningState
    :ivar repo_id: Gets or sets GitHub Repository id.

     This is a numeric id defined by Github.
     Eg: "123456".
    :vartype repo_id: str
    :ivar repo_name: Gets or sets GitHub Repository name.
     Eg: "new-repo-1".
    :vartype repo_name: str
    :ivar repo_full_name: Gets or sets GitHub Full Name.
     Repository name, prefixed with Owner name.
     Eg: "my-org/new-repo-1".
    :vartype repo_full_name: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
     is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
    :ivar repo_url: Gets or sets GitHub Repository url.
    :vartype repo_url: str
    :ivar parent_owner_name: Gets or sets parent GitHub Owner name.
    :vartype parent_owner_name: str
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "repo_id": {"readonly": True},
        "repo_name": {"readonly": True},
        "repo_full_name": {"readonly": True},
        "repo_url": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "repo_id": {"key": "repoId", "type": "str"},
        "repo_name": {"key": "repoName", "type": "str"},
        "repo_full_name": {"key": "repoFullName", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
        "repo_url": {"key": "repoUrl", "type": "str"},
        "parent_owner_name": {"key": "parentOwnerName", "type": "str"},
    }

    def __init__(
        self,
        *,
        onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None,
        parent_owner_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
         is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
        :keyword parent_owner_name: Gets or sets parent GitHub Owner name.
        :paramtype parent_owner_name: str
        """
        super().__init__(**kwargs)
        self.provisioning_status_message: Optional[str] = None
        self.provisioning_status_update_time_utc: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None
        self.repo_id: Optional[str] = None
        self.repo_name: Optional[str] = None
        self.repo_full_name: Optional[str] = None
        self.onboarding_state = onboarding_state
        self.repo_url: Optional[str] = None
        self.parent_owner_name = parent_owner_name


class GithubScopeEnvironmentData(EnvironmentData):
    """The github scope connector's environment data.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", "GitlabScope",
     "DockerHubOrganization", and "JFrogArtifactory".
    :vartype environment_type: str or ~azure.mgmt.security.models.EnvironmentType
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.environment_type: str = "GithubScope"


class GitLabGroup(ProxyResource):
    """GitLab Group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar properties: GitLab Group properties.
    :vartype properties: ~azure.mgmt.security.models.GitLabGroupProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitLabGroupProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitLabGroupProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: GitLab Group properties.
        :paramtype properties: ~azure.mgmt.security.models.GitLabGroupProperties
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.properties = properties


class GitLabGroupConfiguration(_serialization.Model):
    """GitLab Group Inventory Configuration.

    :ivar auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
     "NotApplicable".
    :vartype auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
    :ivar project_configs: GitLab Project Inventory Configuration.
     Dictionary of GitLab fully-qualified project name to desired project configuration.
     If AutoDiscovery is Enabled, this field should be null or empty.
    :vartype project_configs: dict[str, ~azure.mgmt.security.models.BaseResourceConfiguration]
    """

    _attribute_map = {
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "project_configs": {"key": "projectConfigs", "type": "{BaseResourceConfiguration}"},
    }

    def __init__(
        self,
        *,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        project_configs: Optional[Dict[str, "_models.BaseResourceConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_discovery: AutoDiscovery states. Known values are: "Disabled", "Enabled", and
         "NotApplicable".
        :paramtype auto_discovery: str or ~azure.mgmt.security.models.AutoDiscovery
        :keyword project_configs: GitLab Project Inventory Configuration.
         Dictionary of GitLab fully-qualified project name to desired project configuration.
         If AutoDiscovery is Enabled, this field should be null or empty.
        :paramtype project_configs: dict[str, ~azure.mgmt.security.models.BaseResourceConfiguration]
        """
        super().__init__(**kwargs)
        self.auto_discovery = auto_discovery
        self.project_configs = project_configs


class GitLabGroupListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.models.GitLabGroup]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitLabGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GitLabGroup"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.models.GitLabGroup]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitLabGroupProperties(_serialization.Model):
    """GitLab Group properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets the resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets the time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.DevOpsProvisioningState
    :ivar fully_qualified_name: Gets or sets the fully-qualified name of the Group object.

     This contains the entire namespace hierarchy where namespaces are separated by the '$'
     character.
    :vartype fully_qualified_name: str
    :ivar fully_qualified_friendly_name: Gets or sets the human readable fully-qualified name of
     the Group object.

     This contains the entire namespace hierarchy as seen on GitLab UI where namespaces are
     separated by the '/' character.
    :vartype fully_qualified_friendly_name: str
    :ivar url: Gets or sets the url of the GitLab Group.
    :vartype url: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
     is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "fully_qualified_name": {"readonly": True},
        "fully_qualified_friendly_name": {"readonly": True},
        "url": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "fully_qualified_name": {"key": "fullyQualifiedName", "type": "str"},
        "fully_qualified_friendly_name": {"key": "fullyQualifiedFriendlyName", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
    }

    def __init__(
        self, *, onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
         is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
        """
        super().__init__(**kwargs)
        self.provisioning_status_message: Optional[str] = None
        self.provisioning_status_update_time_utc: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None
        self.fully_qualified_name: Optional[str] = None
        self.fully_qualified_friendly_name: Optional[str] = None
        self.url: Optional[str] = None
        self.onboarding_state = onboarding_state


class GitLabProject(ProxyResource):
    """GitLab Project resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar properties: GitLab Project properties.
    :vartype properties: ~azure.mgmt.security.models.GitLabProjectProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitLabProjectProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitLabProjectProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: GitLab Project properties.
        :paramtype properties: ~azure.mgmt.security.models.GitLabProjectProperties
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.properties = properties


class GitLabProjectListResponse(_serialization.Model):
    """List of RP resources which supports pagination.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.security.models.GitLabProject]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitLabProject]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GitLabProject"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.security.models.GitLabProject]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitLabProjectProperties(_serialization.Model):
    """GitLab Project properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_status_message: Gets the resource status message.
    :vartype provisioning_status_message: str
    :ivar provisioning_status_update_time_utc: Gets the time when resource was last checked.
    :vartype provisioning_status_update_time_utc: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource.

     Pending - Provisioning pending.
     Failed - Provisioning failed.
     Succeeded - Successful provisioning.
     Canceled - Provisioning canceled.
     PendingDeletion - Deletion pending.
     DeletionSuccess - Deletion successful.
     DeletionFailure - Deletion failure. Known values are: "Succeeded", "Failed", "Canceled",
     "Pending", "PendingDeletion", "DeletionSuccess", and "DeletionFailure".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.DevOpsProvisioningState
    :ivar fully_qualified_name: Gets or sets the fully-qualified name of the project object.

     This contains the entire hierarchy where entities are separated by the '$' character.
    :vartype fully_qualified_name: str
    :ivar fully_qualified_friendly_name: Gets or sets the human readable fully-qualified name of
     the Project object.

     This contains the entire namespace hierarchy as seen on GitLab UI where entities are separated
     by the '/' character.
    :vartype fully_qualified_friendly_name: str
    :ivar fully_qualified_parent_group_name: Gets or sets the fully-qualified name of the project's
     parent group object.

     This contains the entire hierarchy where namespaces are separated by the '$' character.
    :vartype fully_qualified_parent_group_name: str
    :ivar url: Gets or sets the url of the GitLab Project.
    :vartype url: str
    :ivar onboarding_state: Details about resource onboarding status across all connectors.

     OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
     is only applicable to top-level resources.
     Onboarded - this resource has already been onboarded by the specified connector.
     NotOnboarded - this resource has not been onboarded to any connector.
     NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
     are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
    :vartype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
    """

    _validation = {
        "provisioning_status_message": {"readonly": True},
        "provisioning_status_update_time_utc": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "fully_qualified_name": {"readonly": True},
        "fully_qualified_friendly_name": {"readonly": True},
        "fully_qualified_parent_group_name": {"readonly": True},
        "url": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_status_message": {"key": "provisioningStatusMessage", "type": "str"},
        "provisioning_status_update_time_utc": {"key": "provisioningStatusUpdateTimeUtc", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "fully_qualified_name": {"key": "fullyQualifiedName", "type": "str"},
        "fully_qualified_friendly_name": {"key": "fullyQualifiedFriendlyName", "type": "str"},
        "fully_qualified_parent_group_name": {"key": "fullyQualifiedParentGroupName", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "onboarding_state": {"key": "onboardingState", "type": "str"},
    }

    def __init__(
        self, *, onboarding_state: Optional[Union[str, "_models.OnboardingState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword onboarding_state: Details about resource onboarding status across all connectors.

         OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
         is only applicable to top-level resources.
         Onboarded - this resource has already been onboarded by the specified connector.
         NotOnboarded - this resource has not been onboarded to any connector.
         NotApplicable - the onboarding state is not applicable to the current endpoint. Known values
         are: "NotApplicable", "OnboardedByOtherConnector", "Onboarded", and "NotOnboarded".
        :paramtype onboarding_state: str or ~azure.mgmt.security.models.OnboardingState
        """
        super().__init__(**kwargs)
        self.provisioning_status_message: Optional[str] = None
        self.provisioning_status_update_time_utc: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[Union[str, "_models.DevOpsProvisioningState"]] = None
        self.fully_qualified_name: Optional[str] = None
        self.fully_qualified_friendly_name: Optional[str] = None
        self.fully_qualified_parent_group_name: Optional[str] = None
        self.url: Optional[str] = None
        self.onboarding_state = onboarding_state


class GitlabScopeEnvironmentData(EnvironmentData):
    """The GitLab scope connector's environment data.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", "GitlabScope",
     "DockerHubOrganization", and "JFrogArtifactory".
    :vartype environment_type: str or ~azure.mgmt.security.models.EnvironmentType
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.environment_type: str = "GitlabScope"


class GovernanceAssignment(Resource):
    """Governance assignment over a given scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar owner: The Owner for the governance assignment - e.g. user@contoso.com - see example.
    :vartype owner: str
    :ivar remediation_due_date: The remediation due-date - after this date Secure Score will be
     affected (in case of  active grace-period).
    :vartype remediation_due_date: ~datetime.datetime
    :ivar remediation_eta: The ETA (estimated time of arrival) for remediation (optional), see
     example.
    :vartype remediation_eta: ~azure.mgmt.security.models.RemediationEta
    :ivar is_grace_period: Defines whether there is a grace period on the governance assignment.
    :vartype is_grace_period: bool
    :ivar governance_email_notification: The email notifications settings for the governance rule,
     states whether to disable notifications for mangers and owners.
    :vartype governance_email_notification: ~azure.mgmt.security.models.GovernanceEmailNotification
    :ivar additional_data: The additional data for the governance assignment - e.g. links to ticket
     (optional), see example.
    :vartype additional_data: ~azure.mgmt.security.models.GovernanceAssignmentAdditionalData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "owner": {"key": "properties.owner", "type": "str"},
        "remediation_due_date": {"key": "properties.remediationDueDate", "type": "iso-8601"},
        "remediation_eta": {"key": "properties.remediationEta", "type": "RemediationEta"},
        "is_grace_period": {"key": "properties.isGracePeriod", "type": "bool"},
        "governance_email_notification": {
            "key": "properties.governanceEmailNotification",
            "type": "GovernanceEmailNotification",
        },
        "additional_data": {"key": "properties.additionalData", "type": "GovernanceAssignmentAdditionalData"},
    }

    def __init__(
        self,
        *,
        owner: Optional[str] = None,
        remediation_due_date: Optional[datetime.datetime] = None,
        remediation_eta: Optional["_models.RemediationEta"] = None,
        is_grace_period: Optional[bool] = None,
        governance_email_notification: Optional["_models.GovernanceEmailNotification"] = None,
        additional_data: Optional["_models.GovernanceAssignmentAdditionalData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword owner: The Owner for the governance assignment - e.g. user@contoso.com - see example.
        :paramtype owner: str
        :keyword remediation_due_date: The remediation due-date - after this date Secure Score will be
         affected (in case of  active grace-period).
        :paramtype remediation_due_date: ~datetime.datetime
        :keyword remediation_eta: The ETA (estimated time of arrival) for remediation (optional), see
         example.
        :paramtype remediation_eta: ~azure.mgmt.security.models.RemediationEta
        :keyword is_grace_period: Defines whether there is a grace period on the governance assignment.
        :paramtype is_grace_period: bool
        :keyword governance_email_notification: The email notifications settings for the governance
         rule, states whether to disable notifications for mangers and owners.
        :paramtype governance_email_notification:
         ~azure.mgmt.security.models.GovernanceEmailNotification
        :keyword additional_data: The additional data for the governance assignment - e.g. links to
         ticket (optional), see example.
        :paramtype additional_data: ~azure.mgmt.security.models.GovernanceAssignmentAdditionalData
        """
        super().__init__(**kwargs)
        self.owner = owner
        self.remediation_due_date = remediation_due_date
        self.remediation_eta = remediation_eta
        self.is_grace_period = is_grace_period
        self.governance_email_notification = governance_email_notification
        self.additional_data = additional_data


class GovernanceAssignmentAdditionalData(_serialization.Model):
    """Describe the additional data of governance assignment - optional.

    :ivar ticket_number: Ticket number associated with this governance assignment.
    :vartype ticket_number: int
    :ivar ticket_link: Ticket link associated with this governance assignment - for example:
     https://snow.com.
    :vartype ticket_link: str
    :ivar ticket_status: The ticket status associated with this governance assignment - for
     example: Active.
    :vartype ticket_status: str
    """

    _validation = {
        "ticket_number": {"minimum": 0},
    }

    _attribute_map = {
        "ticket_number": {"key": "ticketNumber", "type": "int"},
        "ticket_link": {"key": "ticketLink", "type": "str"},
        "ticket_status": {"key": "ticketStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        ticket_number: Optional[int] = None,
        ticket_link: Optional[str] = None,
        ticket_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ticket_number: Ticket number associated with this governance assignment.
        :paramtype ticket_number: int
        :keyword ticket_link: Ticket link associated with this governance assignment - for example:
         https://snow.com.
        :paramtype ticket_link: str
        :keyword ticket_status: The ticket status associated with this governance assignment - for
         example: Active.
        :paramtype ticket_status: str
        """
        super().__init__(**kwargs)
        self.ticket_number = ticket_number
        self.ticket_link = ticket_link
        self.ticket_status = ticket_status


class GovernanceAssignmentsList(_serialization.Model):
    """Page of a governance assignments list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of governance assignments in this page.
    :vartype value: list[~azure.mgmt.security.models.GovernanceAssignment]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GovernanceAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.GovernanceAssignment"]] = None
        self.next_link: Optional[str] = None


class GovernanceEmailNotification(_serialization.Model):
    """The governance email weekly notification configuration.

    :ivar disable_manager_email_notification: Exclude manager from weekly email notification.
    :vartype disable_manager_email_notification: bool
    :ivar disable_owner_email_notification: Exclude  owner from weekly email notification.
    :vartype disable_owner_email_notification: bool
    """

    _attribute_map = {
        "disable_manager_email_notification": {"key": "disableManagerEmailNotification", "type": "bool"},
        "disable_owner_email_notification": {"key": "disableOwnerEmailNotification", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disable_manager_email_notification: Optional[bool] = None,
        disable_owner_email_notification: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disable_manager_email_notification: Exclude manager from weekly email notification.
        :paramtype disable_manager_email_notification: bool
        :keyword disable_owner_email_notification: Exclude  owner from weekly email notification.
        :paramtype disable_owner_email_notification: bool
        """
        super().__init__(**kwargs)
        self.disable_manager_email_notification = disable_manager_email_notification
        self.disable_owner_email_notification = disable_owner_email_notification


class GovernanceRule(Resource):
    """Governance rule over a given scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tenant_id: The tenantId (GUID).
    :vartype tenant_id: str
    :ivar display_name: Display name of the governance rule.
    :vartype display_name: str
    :ivar description: Description of the governance rule.
    :vartype description: str
    :ivar remediation_timeframe: Governance rule remediation timeframe - this is the time that will
     affect on the grace-period duration e.g. 7.00:00:00 - means 7 days.
    :vartype remediation_timeframe: str
    :ivar is_grace_period: Defines whether there is a grace period on the governance rule.
    :vartype is_grace_period: bool
    :ivar rule_priority: The governance rule priority, priority to the lower number. Rules with the
     same priority on the same scope will not be allowed.
    :vartype rule_priority: int
    :ivar is_disabled: Defines whether the rule is active/inactive.
    :vartype is_disabled: bool
    :ivar rule_type: The rule type of the governance rule, defines the source of the rule e.g.
     Integrated. Known values are: "Integrated" and "ServiceNow".
    :vartype rule_type: str or ~azure.mgmt.security.models.GovernanceRuleType
    :ivar source_resource_type: The governance rule source, what the rule affects, e.g.
     Assessments. "Assessments"
    :vartype source_resource_type: str or
     ~azure.mgmt.security.models.GovernanceRuleSourceResourceType
    :ivar excluded_scopes: Excluded scopes, filter out the descendants of the scope (on management
     scopes).
    :vartype excluded_scopes: list[str]
    :ivar condition_sets: The governance rule conditionSets - see examples.
    :vartype condition_sets: list[JSON]
    :ivar include_member_scopes: Defines whether the rule is management scope rule (master
     connector as a single scope or management scope).
    :vartype include_member_scopes: bool
    :ivar owner_source: The owner source for the governance rule - e.g. Manually by
     user@contoso.com - see example.
    :vartype owner_source: ~azure.mgmt.security.models.GovernanceRuleOwnerSource
    :ivar governance_email_notification: The email notifications settings for the governance rule,
     states whether to disable notifications for mangers and owners.
    :vartype governance_email_notification:
     ~azure.mgmt.security.models.GovernanceRuleEmailNotification
    :ivar metadata: The governance rule metadata.
    :vartype metadata: ~azure.mgmt.security.models.GovernanceRuleMetadata
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "tenant_id": {"readonly": True},
        "remediation_timeframe": {"pattern": r"^[0-9]+\.[0-9]{2}:[0-9]{2}:[0-9]{2}$"},
        "rule_priority": {"maximum": 1000, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_timeframe": {"key": "properties.remediationTimeframe", "type": "str"},
        "is_grace_period": {"key": "properties.isGracePeriod", "type": "bool"},
        "rule_priority": {"key": "properties.rulePriority", "type": "int"},
        "is_disabled": {"key": "properties.isDisabled", "type": "bool"},
        "rule_type": {"key": "properties.ruleType", "type": "str"},
        "source_resource_type": {"key": "properties.sourceResourceType", "type": "str"},
        "excluded_scopes": {"key": "properties.excludedScopes", "type": "[str]"},
        "condition_sets": {"key": "properties.conditionSets", "type": "[object]"},
        "include_member_scopes": {"key": "properties.includeMemberScopes", "type": "bool"},
        "owner_source": {"key": "properties.ownerSource", "type": "GovernanceRuleOwnerSource"},
        "governance_email_notification": {
            "key": "properties.governanceEmailNotification",
            "type": "GovernanceRuleEmailNotification",
        },
        "metadata": {"key": "properties.metadata", "type": "GovernanceRuleMetadata"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_timeframe: Optional[str] = None,
        is_grace_period: Optional[bool] = None,
        rule_priority: Optional[int] = None,
        is_disabled: Optional[bool] = None,
        rule_type: Optional[Union[str, "_models.GovernanceRuleType"]] = None,
        source_resource_type: Optional[Union[str, "_models.GovernanceRuleSourceResourceType"]] = None,
        excluded_scopes: Optional[List[str]] = None,
        condition_sets: Optional[List[JSON]] = None,
        include_member_scopes: Optional[bool] = None,
        owner_source: Optional["_models.GovernanceRuleOwnerSource"] = None,
        governance_email_notification: Optional["_models.GovernanceRuleEmailNotification"] = None,
        metadata: Optional["_models.GovernanceRuleMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the governance rule.
        :paramtype display_name: str
        :keyword description: Description of the governance rule.
        :paramtype description: str
        :keyword remediation_timeframe: Governance rule remediation timeframe - this is the time that
         will affect on the grace-period duration e.g. 7.00:00:00 - means 7 days.
        :paramtype remediation_timeframe: str
        :keyword is_grace_period: Defines whether there is a grace period on the governance rule.
        :paramtype is_grace_period: bool
        :keyword rule_priority: The governance rule priority, priority to the lower number. Rules with
         the same priority on the same scope will not be allowed.
        :paramtype rule_priority: int
        :keyword is_disabled: Defines whether the rule is active/inactive.
        :paramtype is_disabled: bool
        :keyword rule_type: The rule type of the governance rule, defines the source of the rule e.g.
         Integrated. Known values are: "Integrated" and "ServiceNow".
        :paramtype rule_type: str or ~azure.mgmt.security.models.GovernanceRuleType
        :keyword source_resource_type: The governance rule source, what the rule affects, e.g.
         Assessments. "Assessments"
        :paramtype source_resource_type: str or
         ~azure.mgmt.security.models.GovernanceRuleSourceResourceType
        :keyword excluded_scopes: Excluded scopes, filter out the descendants of the scope (on
         management scopes).
        :paramtype excluded_scopes: list[str]
        :keyword condition_sets: The governance rule conditionSets - see examples.
        :paramtype condition_sets: list[JSON]
        :keyword include_member_scopes: Defines whether the rule is management scope rule (master
         connector as a single scope or management scope).
        :paramtype include_member_scopes: bool
        :keyword owner_source: The owner source for the governance rule - e.g. Manually by
         user@contoso.com - see example.
        :paramtype owner_source: ~azure.mgmt.security.models.GovernanceRuleOwnerSource
        :keyword governance_email_notification: The email notifications settings for the governance
         rule, states whether to disable notifications for mangers and owners.
        :paramtype governance_email_notification:
         ~azure.mgmt.security.models.GovernanceRuleEmailNotification
        :keyword metadata: The governance rule metadata.
        :paramtype metadata: ~azure.mgmt.security.models.GovernanceRuleMetadata
        """
        super().__init__(**kwargs)
        self.tenant_id: Optional[str] = None
        self.display_name = display_name
        self.description = description
        self.remediation_timeframe = remediation_timeframe
        self.is_grace_period = is_grace_period
        self.rule_priority = rule_priority
        self.is_disabled = is_disabled
        self.rule_type = rule_type
        self.source_resource_type = source_resource_type
        self.excluded_scopes = excluded_scopes
        self.condition_sets = condition_sets
        self.include_member_scopes = include_member_scopes
        self.owner_source = owner_source
        self.governance_email_notification = governance_email_notification
        self.metadata = metadata


class GovernanceRuleEmailNotification(_serialization.Model):
    """The governance email weekly notification configuration.

    :ivar disable_manager_email_notification: Defines whether manager email notifications are
     disabled.
    :vartype disable_manager_email_notification: bool
    :ivar disable_owner_email_notification: Defines whether owner email notifications are disabled.
    :vartype disable_owner_email_notification: bool
    """

    _attribute_map = {
        "disable_manager_email_notification": {"key": "disableManagerEmailNotification", "type": "bool"},
        "disable_owner_email_notification": {"key": "disableOwnerEmailNotification", "type": "bool"},
    }

    def __init__(
        self,
        *,
        disable_manager_email_notification: Optional[bool] = None,
        disable_owner_email_notification: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disable_manager_email_notification: Defines whether manager email notifications are
         disabled.
        :paramtype disable_manager_email_notification: bool
        :keyword disable_owner_email_notification: Defines whether owner email notifications are
         disabled.
        :paramtype disable_owner_email_notification: bool
        """
        super().__init__(**kwargs)
        self.disable_manager_email_notification = disable_manager_email_notification
        self.disable_owner_email_notification = disable_owner_email_notification


class GovernanceRuleList(_serialization.Model):
    """Page of a governance rules list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of governance rules in this page.
    :vartype value: list[~azure.mgmt.security.models.GovernanceRule]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GovernanceRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.GovernanceRule"]] = None
        self.next_link: Optional[str] = None


class GovernanceRuleMetadata(_serialization.Model):
    """The governance rule metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_by: Governance rule Created by object id (GUID).
    :vartype created_by: str
    :ivar created_on: Governance rule creation date.
    :vartype created_on: ~datetime.datetime
    :ivar updated_by: Governance rule last updated by object id (GUID).
    :vartype updated_by: str
    :ivar updated_on: Governance rule last update date.
    :vartype updated_on: ~datetime.datetime
    """

    _validation = {
        "created_by": {"readonly": True},
        "created_on": {"readonly": True},
        "updated_by": {"readonly": True},
        "updated_on": {"readonly": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "updated_by": {"key": "updatedBy", "type": "str"},
        "updated_on": {"key": "updatedOn", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.created_by: Optional[str] = None
        self.created_on: Optional[datetime.datetime] = None
        self.updated_by: Optional[str] = None
        self.updated_on: Optional[datetime.datetime] = None


class GovernanceRuleOwnerSource(_serialization.Model):
    """Describe the owner source of governance rule.

    :ivar type: The owner type for the governance rule owner source. Known values are: "ByTag" and
     "Manually".
    :vartype type: str or ~azure.mgmt.security.models.GovernanceRuleOwnerSourceType
    :ivar value: The source value e.g. tag key like owner name or email address.
    :vartype value: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.GovernanceRuleOwnerSourceType"]] = None,
        value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The owner type for the governance rule owner source. Known values are: "ByTag"
         and "Manually".
        :paramtype type: str or ~azure.mgmt.security.models.GovernanceRuleOwnerSourceType
        :keyword value: The source value e.g. tag key like owner name or email address.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.value = value


class HealthDataClassification(_serialization.Model):
    """The classification of the health report.

    :ivar component: The component describes the name of the agent/service that scans the issue.
    :vartype component: str
    :ivar scenario: The scenario describes the health scenario issue of the component.
    :vartype scenario: str
    :ivar scope: The resource scope of the health report.
    :vartype scope: str
    """

    _attribute_map = {
        "component": {"key": "component", "type": "str"},
        "scenario": {"key": "scenario", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
    }

    def __init__(
        self,
        *,
        component: Optional[str] = None,
        scenario: Optional[str] = None,
        scope: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword component: The component describes the name of the agent/service that scans the issue.
        :paramtype component: str
        :keyword scenario: The scenario describes the health scenario issue of the component.
        :paramtype scenario: str
        :keyword scope: The resource scope of the health report.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.component = component
        self.scenario = scenario
        self.scope = scope


class HealthReport(Resource):
    """The health report resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_details: The resource details of the health report.
    :vartype resource_details: ~azure.mgmt.security.models.ResourceDetailsAutoGenerated
    :ivar environment_details: The environment details of the resource.
    :vartype environment_details: ~azure.mgmt.security.models.EnvironmentDetails
    :ivar health_data_classification: The classification of the health report.
    :vartype health_data_classification: ~azure.mgmt.security.models.HealthDataClassification
    :ivar status: The status of the health report.
    :vartype status: ~azure.mgmt.security.models.StatusAutoGenerated
    :ivar affected_defenders_plans: The affected defenders plans by unhealthy report.
    :vartype affected_defenders_plans: list[str]
    :ivar affected_defenders_sub_plans: The affected defenders sub plans by unhealthy report.
    :vartype affected_defenders_sub_plans: list[str]
    :ivar report_additional_data: Additional data for the given health report, this field can
     include more details on the resource and the health scenario.
    :vartype report_additional_data: dict[str, str]
    :ivar issues: A collection of the issues in the report.
    :vartype issues: list[~azure.mgmt.security.models.Issue]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "report_additional_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_details": {"key": "properties.resourceDetails", "type": "ResourceDetailsAutoGenerated"},
        "environment_details": {"key": "properties.environmentDetails", "type": "EnvironmentDetails"},
        "health_data_classification": {
            "key": "properties.healthDataClassification",
            "type": "HealthDataClassification",
        },
        "status": {"key": "properties.status", "type": "StatusAutoGenerated"},
        "affected_defenders_plans": {"key": "properties.affectedDefendersPlans", "type": "[str]"},
        "affected_defenders_sub_plans": {"key": "properties.affectedDefendersSubPlans", "type": "[str]"},
        "report_additional_data": {"key": "properties.reportAdditionalData", "type": "{str}"},
        "issues": {"key": "properties.issues", "type": "[Issue]"},
    }

    def __init__(
        self,
        *,
        resource_details: Optional["_models.ResourceDetailsAutoGenerated"] = None,
        environment_details: Optional["_models.EnvironmentDetails"] = None,
        health_data_classification: Optional["_models.HealthDataClassification"] = None,
        status: Optional["_models.StatusAutoGenerated"] = None,
        affected_defenders_plans: Optional[List[str]] = None,
        affected_defenders_sub_plans: Optional[List[str]] = None,
        issues: Optional[List["_models.Issue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: The resource details of the health report.
        :paramtype resource_details: ~azure.mgmt.security.models.ResourceDetailsAutoGenerated
        :keyword environment_details: The environment details of the resource.
        :paramtype environment_details: ~azure.mgmt.security.models.EnvironmentDetails
        :keyword health_data_classification: The classification of the health report.
        :paramtype health_data_classification: ~azure.mgmt.security.models.HealthDataClassification
        :keyword status: The status of the health report.
        :paramtype status: ~azure.mgmt.security.models.StatusAutoGenerated
        :keyword affected_defenders_plans: The affected defenders plans by unhealthy report.
        :paramtype affected_defenders_plans: list[str]
        :keyword affected_defenders_sub_plans: The affected defenders sub plans by unhealthy report.
        :paramtype affected_defenders_sub_plans: list[str]
        :keyword issues: A collection of the issues in the report.
        :paramtype issues: list[~azure.mgmt.security.models.Issue]
        """
        super().__init__(**kwargs)
        self.resource_details = resource_details
        self.environment_details = environment_details
        self.health_data_classification = health_data_classification
        self.status = status
        self.affected_defenders_plans = affected_defenders_plans
        self.affected_defenders_sub_plans = affected_defenders_sub_plans
        self.report_additional_data: Optional[Dict[str, str]] = None
        self.issues = issues


class HealthReportsList(_serialization.Model):
    """Page of health reports list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of health reports in this page.
    :vartype value: list[~azure.mgmt.security.models.HealthReport]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HealthReport]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.HealthReport"]] = None
        self.next_link: Optional[str] = None


class HttpC2DMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of cloud to device messages (HTTP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "HttpC2DMessagesNotInAllowedRange"


class HttpC2DRejectedMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of rejected cloud to device messages (HTTP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "HttpC2DRejectedMessagesNotInAllowedRange"


class HttpD2CMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device to cloud messages (HTTP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "HttpD2CMessagesNotInAllowedRange"


class HybridComputeSettingsProperties(_serialization.Model):
    """Settings for hybrid compute management.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar hybrid_compute_provisioning_state: State of the service principal and its secret. Known
     values are: "Valid", "Invalid", and "Expired".
    :vartype hybrid_compute_provisioning_state: str or
     ~azure.mgmt.security.models.HybridComputeProvisioningState
    :ivar auto_provision: Whether or not to automatically install Azure Arc (hybrid compute) agents
     on machines. Required. Known values are: "On" and "Off".
    :vartype auto_provision: str or ~azure.mgmt.security.models.AutoProvision
    :ivar resource_group_name: The name of the resource group where Arc (Hybrid Compute) connectors
     are connected.
    :vartype resource_group_name: str
    :ivar region: The location where the metadata of machines will be stored.
    :vartype region: str
    :ivar proxy_server: For a non-Azure machine that is not connected directly to the internet,
     specify a proxy server that the non-Azure machine can use.
    :vartype proxy_server: ~azure.mgmt.security.models.ProxyServerProperties
    :ivar service_principal: An object to access resources that are secured by an Azure AD tenant.
    :vartype service_principal: ~azure.mgmt.security.models.ServicePrincipalProperties
    """

    _validation = {
        "hybrid_compute_provisioning_state": {"readonly": True},
        "auto_provision": {"required": True},
    }

    _attribute_map = {
        "hybrid_compute_provisioning_state": {"key": "hybridComputeProvisioningState", "type": "str"},
        "auto_provision": {"key": "autoProvision", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "proxy_server": {"key": "proxyServer", "type": "ProxyServerProperties"},
        "service_principal": {"key": "servicePrincipal", "type": "ServicePrincipalProperties"},
    }

    def __init__(
        self,
        *,
        auto_provision: Union[str, "_models.AutoProvision"],
        resource_group_name: Optional[str] = None,
        region: Optional[str] = None,
        proxy_server: Optional["_models.ProxyServerProperties"] = None,
        service_principal: Optional["_models.ServicePrincipalProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auto_provision: Whether or not to automatically install Azure Arc (hybrid compute)
         agents on machines. Required. Known values are: "On" and "Off".
        :paramtype auto_provision: str or ~azure.mgmt.security.models.AutoProvision
        :keyword resource_group_name: The name of the resource group where Arc (Hybrid Compute)
         connectors are connected.
        :paramtype resource_group_name: str
        :keyword region: The location where the metadata of machines will be stored.
        :paramtype region: str
        :keyword proxy_server: For a non-Azure machine that is not connected directly to the internet,
         specify a proxy server that the non-Azure machine can use.
        :paramtype proxy_server: ~azure.mgmt.security.models.ProxyServerProperties
        :keyword service_principal: An object to access resources that are secured by an Azure AD
         tenant.
        :paramtype service_principal: ~azure.mgmt.security.models.ServicePrincipalProperties
        """
        super().__init__(**kwargs)
        self.hybrid_compute_provisioning_state: Optional[Union[str, "_models.HybridComputeProvisioningState"]] = None
        self.auto_provision = auto_provision
        self.resource_group_name = resource_group_name
        self.region = region
        self.proxy_server = proxy_server
        self.service_principal = service_principal


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value is "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Literal["SystemAssigned"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The identity type. Default value is "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type


class InformationProtectionKeyword(_serialization.Model):
    """The information type keyword.

    :ivar pattern: The keyword pattern.
    :vartype pattern: str
    :ivar custom: Indicates whether the keyword is custom or not.
    :vartype custom: bool
    :ivar can_be_numeric: Indicates whether the keyword can be applied on numeric types or not.
    :vartype can_be_numeric: bool
    :ivar excluded: Indicates whether the keyword is excluded or not.
    :vartype excluded: bool
    """

    _attribute_map = {
        "pattern": {"key": "pattern", "type": "str"},
        "custom": {"key": "custom", "type": "bool"},
        "can_be_numeric": {"key": "canBeNumeric", "type": "bool"},
        "excluded": {"key": "excluded", "type": "bool"},
    }

    def __init__(
        self,
        *,
        pattern: Optional[str] = None,
        custom: Optional[bool] = None,
        can_be_numeric: Optional[bool] = None,
        excluded: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pattern: The keyword pattern.
        :paramtype pattern: str
        :keyword custom: Indicates whether the keyword is custom or not.
        :paramtype custom: bool
        :keyword can_be_numeric: Indicates whether the keyword can be applied on numeric types or not.
        :paramtype can_be_numeric: bool
        :keyword excluded: Indicates whether the keyword is excluded or not.
        :paramtype excluded: bool
        """
        super().__init__(**kwargs)
        self.pattern = pattern
        self.custom = custom
        self.can_be_numeric = can_be_numeric
        self.excluded = excluded


class InformationProtectionPolicy(Resource):
    """Information protection policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar last_modified_utc: Describes the last UTC time the policy was modified.
    :vartype last_modified_utc: ~datetime.datetime
    :ivar version: Describes the version of the policy.
    :vartype version: str
    :ivar labels: Dictionary of sensitivity labels.
    :vartype labels: dict[str, ~azure.mgmt.security.models.SensitivityLabel]
    :ivar information_types: The sensitivity information types.
    :vartype information_types: dict[str, ~azure.mgmt.security.models.InformationType]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_modified_utc": {"readonly": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "last_modified_utc": {"key": "properties.lastModifiedUtc", "type": "iso-8601"},
        "version": {"key": "properties.version", "type": "str"},
        "labels": {"key": "properties.labels", "type": "{SensitivityLabel}"},
        "information_types": {"key": "properties.informationTypes", "type": "{InformationType}"},
    }

    def __init__(
        self,
        *,
        labels: Optional[Dict[str, "_models.SensitivityLabel"]] = None,
        information_types: Optional[Dict[str, "_models.InformationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword labels: Dictionary of sensitivity labels.
        :paramtype labels: dict[str, ~azure.mgmt.security.models.SensitivityLabel]
        :keyword information_types: The sensitivity information types.
        :paramtype information_types: dict[str, ~azure.mgmt.security.models.InformationType]
        """
        super().__init__(**kwargs)
        self.last_modified_utc: Optional[datetime.datetime] = None
        self.version: Optional[str] = None
        self.labels = labels
        self.information_types = information_types


class InformationProtectionPolicyList(_serialization.Model):
    """Information protection policies response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of information protection policies.
    :vartype value: list[~azure.mgmt.security.models.InformationProtectionPolicy]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InformationProtectionPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.InformationProtectionPolicy"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of information protection policies.
        :paramtype value: list[~azure.mgmt.security.models.InformationProtectionPolicy]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class InformationType(_serialization.Model):
    """The information type.

    :ivar display_name: The name of the information type.
    :vartype display_name: str
    :ivar description: The description of the information type.
    :vartype description: str
    :ivar order: The order of the information type.
    :vartype order: int
    :ivar recommended_label_id: The recommended label id to be associated with this information
     type.
    :vartype recommended_label_id: str
    :ivar enabled: Indicates whether the information type is enabled or not.
    :vartype enabled: bool
    :ivar custom: Indicates whether the information type is custom or not.
    :vartype custom: bool
    :ivar keywords: The information type keywords.
    :vartype keywords: list[~azure.mgmt.security.models.InformationProtectionKeyword]
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "recommended_label_id": {"key": "recommendedLabelId", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "custom": {"key": "custom", "type": "bool"},
        "keywords": {"key": "keywords", "type": "[InformationProtectionKeyword]"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        order: Optional[int] = None,
        recommended_label_id: Optional[str] = None,
        enabled: Optional[bool] = None,
        custom: Optional[bool] = None,
        keywords: Optional[List["_models.InformationProtectionKeyword"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: The name of the information type.
        :paramtype display_name: str
        :keyword description: The description of the information type.
        :paramtype description: str
        :keyword order: The order of the information type.
        :paramtype order: int
        :keyword recommended_label_id: The recommended label id to be associated with this information
         type.
        :paramtype recommended_label_id: str
        :keyword enabled: Indicates whether the information type is enabled or not.
        :paramtype enabled: bool
        :keyword custom: Indicates whether the information type is custom or not.
        :paramtype custom: bool
        :keyword keywords: The information type keywords.
        :paramtype keywords: list[~azure.mgmt.security.models.InformationProtectionKeyword]
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.order = order
        self.recommended_label_id = recommended_label_id
        self.enabled = enabled
        self.custom = custom
        self.keywords = keywords


class InfoType(_serialization.Model):
    """Custom user-defined information type.

    :ivar name: Display name of the info type.
    :vartype name: str
    :ivar id: Id of the info type.
    :vartype id: str
    :ivar description: Description of the info type.
    :vartype description: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Display name of the info type.
        :paramtype name: str
        :keyword id: Id of the info type.
        :paramtype id: str
        :keyword description: Description of the info type.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.description = description


class InventoryList(_serialization.Model):
    """Model for inventory to be included or excluded from Agentless.

    :ivar inventory_kind: Types for inventory kind. Known values are: "AzureDevOpsOrganization",
     "AzureDevOpsProject", "AzureDevOpsRepository", "GitHubOwner", and "GitHubRepository".
    :vartype inventory_kind: str or ~azure.mgmt.security.models.InventoryKind
    :ivar value: Gets or sets the value for inventory type.
    :vartype value: str
    """

    _attribute_map = {
        "inventory_kind": {"key": "inventoryKind", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        inventory_kind: Optional[Union[str, "_models.InventoryKind"]] = None,
        value: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword inventory_kind: Types for inventory kind. Known values are: "AzureDevOpsOrganization",
         "AzureDevOpsProject", "AzureDevOpsRepository", "GitHubOwner", and "GitHubRepository".
        :paramtype inventory_kind: str or ~azure.mgmt.security.models.InventoryKind
        :keyword value: Gets or sets the value for inventory type.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.inventory_kind = inventory_kind
        self.value = value


class TagsResource(_serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class IoTSecurityAggregatedAlert(Resource, TagsResource):
    """Security Solution Aggregated Alert information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar alert_type: Name of the alert type.
    :vartype alert_type: str
    :ivar alert_display_name: Display name of the alert type.
    :vartype alert_display_name: str
    :ivar aggregated_date_utc: Date of detection.
    :vartype aggregated_date_utc: ~datetime.date
    :ivar vendor_name: Name of the organization that raised the alert.
    :vartype vendor_name: str
    :ivar reported_severity: Assessed alert severity. Known values are: "Informational", "Low",
     "Medium", and "High".
    :vartype reported_severity: str or ~azure.mgmt.security.models.ReportedSeverity
    :ivar remediation_steps: Recommended steps for remediation.
    :vartype remediation_steps: str
    :ivar description: Description of the suspected vulnerability and meaning.
    :vartype description: str
    :ivar count: Number of alerts occurrences within the aggregated time window.
    :vartype count: int
    :ivar effected_resource_type: Azure resource ID of the resource that received the alerts.
    :vartype effected_resource_type: str
    :ivar system_source: The type of the alerted resource (Azure, Non-Azure).
    :vartype system_source: str
    :ivar action_taken: IoT Security solution alert response.
    :vartype action_taken: str
    :ivar log_analytics_query: Log analytics query for getting the list of affected devices/alerts.
    :vartype log_analytics_query: str
    :ivar top_devices_list: 10 devices with the highest number of occurrences of this alert type,
     on this day.
    :vartype top_devices_list:
     list[~azure.mgmt.security.models.IoTSecurityAggregatedAlertPropertiesTopDevicesListItem]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "alert_type": {"readonly": True},
        "alert_display_name": {"readonly": True},
        "aggregated_date_utc": {"readonly": True},
        "vendor_name": {"readonly": True},
        "reported_severity": {"readonly": True},
        "remediation_steps": {"readonly": True},
        "description": {"readonly": True},
        "count": {"readonly": True},
        "effected_resource_type": {"readonly": True},
        "system_source": {"readonly": True},
        "action_taken": {"readonly": True},
        "log_analytics_query": {"readonly": True},
        "top_devices_list": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "alert_type": {"key": "properties.alertType", "type": "str"},
        "alert_display_name": {"key": "properties.alertDisplayName", "type": "str"},
        "aggregated_date_utc": {"key": "properties.aggregatedDateUtc", "type": "date"},
        "vendor_name": {"key": "properties.vendorName", "type": "str"},
        "reported_severity": {"key": "properties.reportedSeverity", "type": "str"},
        "remediation_steps": {"key": "properties.remediationSteps", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "count": {"key": "properties.count", "type": "int"},
        "effected_resource_type": {"key": "properties.effectedResourceType", "type": "str"},
        "system_source": {"key": "properties.systemSource", "type": "str"},
        "action_taken": {"key": "properties.actionTaken", "type": "str"},
        "log_analytics_query": {"key": "properties.logAnalyticsQuery", "type": "str"},
        "top_devices_list": {
            "key": "properties.topDevicesList",
            "type": "[IoTSecurityAggregatedAlertPropertiesTopDevicesListItem]",
        },
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(tags=tags, **kwargs)
        self.tags = tags
        self.alert_type: Optional[str] = None
        self.alert_display_name: Optional[str] = None
        self.aggregated_date_utc: Optional[datetime.date] = None
        self.vendor_name: Optional[str] = None
        self.reported_severity: Optional[Union[str, "_models.ReportedSeverity"]] = None
        self.remediation_steps: Optional[str] = None
        self.description: Optional[str] = None
        self.count: Optional[int] = None
        self.effected_resource_type: Optional[str] = None
        self.system_source: Optional[str] = None
        self.action_taken: Optional[str] = None
        self.log_analytics_query: Optional[str] = None
        self.top_devices_list: Optional[List["_models.IoTSecurityAggregatedAlertPropertiesTopDevicesListItem"]] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class IoTSecurityAggregatedAlertList(_serialization.Model):
    """List of IoT Security solution aggregated alert data.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: List of aggregated alerts data. Required.
    :vartype value: list[~azure.mgmt.security.models.IoTSecurityAggregatedAlert]
    :ivar next_link: When there is too much alert data for one page, use this URI to fetch the next
     page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IoTSecurityAggregatedAlert]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IoTSecurityAggregatedAlert"], **kwargs: Any) -> None:
        """
        :keyword value: List of aggregated alerts data. Required.
        :paramtype value: list[~azure.mgmt.security.models.IoTSecurityAggregatedAlert]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class IoTSecurityAggregatedAlertPropertiesTopDevicesListItem(_serialization.Model):  # pylint: disable=name-too-long
    """IoTSecurityAggregatedAlertPropertiesTopDevicesListItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_id: Name of the device.
    :vartype device_id: str
    :ivar alerts_count: Number of alerts raised for this device.
    :vartype alerts_count: int
    :ivar last_occurrence: Most recent time this alert was raised for this device, on this day.
    :vartype last_occurrence: str
    """

    _validation = {
        "device_id": {"readonly": True},
        "alerts_count": {"readonly": True},
        "last_occurrence": {"readonly": True},
    }

    _attribute_map = {
        "device_id": {"key": "deviceId", "type": "str"},
        "alerts_count": {"key": "alertsCount", "type": "int"},
        "last_occurrence": {"key": "lastOccurrence", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.device_id: Optional[str] = None
        self.alerts_count: Optional[int] = None
        self.last_occurrence: Optional[str] = None


class IoTSecurityAggregatedRecommendation(Resource, TagsResource):
    """IoT Security solution recommendation information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar recommendation_name: Name of the recommendation.
    :vartype recommendation_name: str
    :ivar recommendation_display_name: Display name of the recommendation type.
    :vartype recommendation_display_name: str
    :ivar description: Description of the suspected vulnerability and meaning.
    :vartype description: str
    :ivar recommendation_type_id: Recommendation-type GUID.
    :vartype recommendation_type_id: str
    :ivar detected_by: Name of the organization that made the recommendation.
    :vartype detected_by: str
    :ivar remediation_steps: Recommended steps for remediation.
    :vartype remediation_steps: str
    :ivar reported_severity: Assessed recommendation severity. Known values are: "Informational",
     "Low", "Medium", and "High".
    :vartype reported_severity: str or ~azure.mgmt.security.models.ReportedSeverity
    :ivar healthy_devices: Number of healthy devices within the IoT Security solution.
    :vartype healthy_devices: int
    :ivar unhealthy_device_count: Number of unhealthy devices within the IoT Security solution.
    :vartype unhealthy_device_count: int
    :ivar log_analytics_query: Log analytics query for getting the list of affected devices/alerts.
    :vartype log_analytics_query: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "recommendation_display_name": {"readonly": True},
        "description": {"readonly": True},
        "recommendation_type_id": {"readonly": True},
        "detected_by": {"readonly": True},
        "remediation_steps": {"readonly": True},
        "reported_severity": {"readonly": True},
        "healthy_devices": {"readonly": True},
        "unhealthy_device_count": {"readonly": True},
        "log_analytics_query": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "recommendation_name": {"key": "properties.recommendationName", "type": "str"},
        "recommendation_display_name": {"key": "properties.recommendationDisplayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "recommendation_type_id": {"key": "properties.recommendationTypeId", "type": "str"},
        "detected_by": {"key": "properties.detectedBy", "type": "str"},
        "remediation_steps": {"key": "properties.remediationSteps", "type": "str"},
        "reported_severity": {"key": "properties.reportedSeverity", "type": "str"},
        "healthy_devices": {"key": "properties.healthyDevices", "type": "int"},
        "unhealthy_device_count": {"key": "properties.unhealthyDeviceCount", "type": "int"},
        "log_analytics_query": {"key": "properties.logAnalyticsQuery", "type": "str"},
    }

    def __init__(
        self, *, tags: Optional[Dict[str, str]] = None, recommendation_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword recommendation_name: Name of the recommendation.
        :paramtype recommendation_name: str
        """
        super().__init__(tags=tags, **kwargs)
        self.tags = tags
        self.recommendation_name = recommendation_name
        self.recommendation_display_name: Optional[str] = None
        self.description: Optional[str] = None
        self.recommendation_type_id: Optional[str] = None
        self.detected_by: Optional[str] = None
        self.remediation_steps: Optional[str] = None
        self.reported_severity: Optional[Union[str, "_models.ReportedSeverity"]] = None
        self.healthy_devices: Optional[int] = None
        self.unhealthy_device_count: Optional[int] = None
        self.log_analytics_query: Optional[str] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class IoTSecurityAggregatedRecommendationList(_serialization.Model):
    """List of IoT Security solution aggregated recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: List of aggregated recommendations data. Required.
    :vartype value: list[~azure.mgmt.security.models.IoTSecurityAggregatedRecommendation]
    :ivar next_link: When there is too much alert data for one page, use this URI to fetch the next
     page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IoTSecurityAggregatedRecommendation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IoTSecurityAggregatedRecommendation"], **kwargs: Any) -> None:
        """
        :keyword value: List of aggregated recommendations data. Required.
        :paramtype value: list[~azure.mgmt.security.models.IoTSecurityAggregatedRecommendation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class IoTSecurityAlertedDevice(_serialization.Model):
    """Statistical information about the number of alerts per device during last set number of days.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_id: Device identifier.
    :vartype device_id: str
    :ivar alerts_count: Number of alerts raised for this device.
    :vartype alerts_count: int
    """

    _validation = {
        "device_id": {"readonly": True},
        "alerts_count": {"readonly": True},
    }

    _attribute_map = {
        "device_id": {"key": "deviceId", "type": "str"},
        "alerts_count": {"key": "alertsCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.device_id: Optional[str] = None
        self.alerts_count: Optional[int] = None


class IoTSecurityDeviceAlert(_serialization.Model):
    """Statistical information about the number of alerts per alert type during last set number of
    days.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_display_name: Display name of the alert.
    :vartype alert_display_name: str
    :ivar reported_severity: Assessed Alert severity. Known values are: "Informational", "Low",
     "Medium", and "High".
    :vartype reported_severity: str or ~azure.mgmt.security.models.ReportedSeverity
    :ivar alerts_count: Number of alerts raised for this alert type.
    :vartype alerts_count: int
    """

    _validation = {
        "alert_display_name": {"readonly": True},
        "reported_severity": {"readonly": True},
        "alerts_count": {"readonly": True},
    }

    _attribute_map = {
        "alert_display_name": {"key": "alertDisplayName", "type": "str"},
        "reported_severity": {"key": "reportedSeverity", "type": "str"},
        "alerts_count": {"key": "alertsCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.alert_display_name: Optional[str] = None
        self.reported_severity: Optional[Union[str, "_models.ReportedSeverity"]] = None
        self.alerts_count: Optional[int] = None


class IoTSecurityDeviceRecommendation(_serialization.Model):
    """Statistical information about the number of recommendations per device, per recommendation
    type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar recommendation_display_name: Display name of the recommendation.
    :vartype recommendation_display_name: str
    :ivar reported_severity: Assessed recommendation severity. Known values are: "Informational",
     "Low", "Medium", and "High".
    :vartype reported_severity: str or ~azure.mgmt.security.models.ReportedSeverity
    :ivar devices_count: Number of devices with this recommendation.
    :vartype devices_count: int
    """

    _validation = {
        "recommendation_display_name": {"readonly": True},
        "reported_severity": {"readonly": True},
        "devices_count": {"readonly": True},
    }

    _attribute_map = {
        "recommendation_display_name": {"key": "recommendationDisplayName", "type": "str"},
        "reported_severity": {"key": "reportedSeverity", "type": "str"},
        "devices_count": {"key": "devicesCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.recommendation_display_name: Optional[str] = None
        self.reported_severity: Optional[Union[str, "_models.ReportedSeverity"]] = None
        self.devices_count: Optional[int] = None


class IoTSecuritySolutionAnalyticsModel(Resource):
    """Security analytics of your IoT Security solution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar metrics: Security analytics of your IoT Security solution.
    :vartype metrics: ~azure.mgmt.security.models.IoTSeverityMetrics
    :ivar unhealthy_device_count: Number of unhealthy devices within your IoT Security solution.
    :vartype unhealthy_device_count: int
    :ivar devices_metrics: List of device metrics by the aggregation date.
    :vartype devices_metrics:
     list[~azure.mgmt.security.models.IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem]
    :ivar top_alerted_devices: List of the 3 devices with the most alerts.
    :vartype top_alerted_devices: list[~azure.mgmt.security.models.IoTSecurityAlertedDevice]
    :ivar most_prevalent_device_alerts: List of the 3 most prevalent device alerts.
    :vartype most_prevalent_device_alerts: list[~azure.mgmt.security.models.IoTSecurityDeviceAlert]
    :ivar most_prevalent_device_recommendations: List of the 3 most prevalent device
     recommendations.
    :vartype most_prevalent_device_recommendations:
     list[~azure.mgmt.security.models.IoTSecurityDeviceRecommendation]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "metrics": {"readonly": True},
        "unhealthy_device_count": {"readonly": True},
        "devices_metrics": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "metrics": {"key": "properties.metrics", "type": "IoTSeverityMetrics"},
        "unhealthy_device_count": {"key": "properties.unhealthyDeviceCount", "type": "int"},
        "devices_metrics": {
            "key": "properties.devicesMetrics",
            "type": "[IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem]",
        },
        "top_alerted_devices": {"key": "properties.topAlertedDevices", "type": "[IoTSecurityAlertedDevice]"},
        "most_prevalent_device_alerts": {
            "key": "properties.mostPrevalentDeviceAlerts",
            "type": "[IoTSecurityDeviceAlert]",
        },
        "most_prevalent_device_recommendations": {
            "key": "properties.mostPrevalentDeviceRecommendations",
            "type": "[IoTSecurityDeviceRecommendation]",
        },
    }

    def __init__(
        self,
        *,
        top_alerted_devices: Optional[List["_models.IoTSecurityAlertedDevice"]] = None,
        most_prevalent_device_alerts: Optional[List["_models.IoTSecurityDeviceAlert"]] = None,
        most_prevalent_device_recommendations: Optional[List["_models.IoTSecurityDeviceRecommendation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword top_alerted_devices: List of the 3 devices with the most alerts.
        :paramtype top_alerted_devices: list[~azure.mgmt.security.models.IoTSecurityAlertedDevice]
        :keyword most_prevalent_device_alerts: List of the 3 most prevalent device alerts.
        :paramtype most_prevalent_device_alerts:
         list[~azure.mgmt.security.models.IoTSecurityDeviceAlert]
        :keyword most_prevalent_device_recommendations: List of the 3 most prevalent device
         recommendations.
        :paramtype most_prevalent_device_recommendations:
         list[~azure.mgmt.security.models.IoTSecurityDeviceRecommendation]
        """
        super().__init__(**kwargs)
        self.metrics: Optional["_models.IoTSeverityMetrics"] = None
        self.unhealthy_device_count: Optional[int] = None
        self.devices_metrics: Optional[
            List["_models.IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem"]
        ] = None
        self.top_alerted_devices = top_alerted_devices
        self.most_prevalent_device_alerts = most_prevalent_device_alerts
        self.most_prevalent_device_recommendations = most_prevalent_device_recommendations


class IoTSecuritySolutionAnalyticsModelList(_serialization.Model):
    """List of Security analytics of your IoT Security solution.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: List of Security analytics of your IoT Security solution. Required.
    :vartype value: list[~azure.mgmt.security.models.IoTSecuritySolutionAnalyticsModel]
    :ivar next_link: When there is too much alert data for one page, use this URI to fetch the next
     page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IoTSecuritySolutionAnalyticsModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IoTSecuritySolutionAnalyticsModel"], **kwargs: Any) -> None:
        """
        :keyword value: List of Security analytics of your IoT Security solution. Required.
        :paramtype value: list[~azure.mgmt.security.models.IoTSecuritySolutionAnalyticsModel]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem(
    _serialization.Model
):  # pylint: disable=name-too-long
    """IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem.

    :ivar date: Aggregation of IoT Security solution device alert metrics by date.
    :vartype date: ~datetime.datetime
    :ivar devices_metrics: Device alert count by severity.
    :vartype devices_metrics: ~azure.mgmt.security.models.IoTSeverityMetrics
    """

    _attribute_map = {
        "date": {"key": "date", "type": "iso-8601"},
        "devices_metrics": {"key": "devicesMetrics", "type": "IoTSeverityMetrics"},
    }

    def __init__(
        self,
        *,
        date: Optional[datetime.datetime] = None,
        devices_metrics: Optional["_models.IoTSeverityMetrics"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword date: Aggregation of IoT Security solution device alert metrics by date.
        :paramtype date: ~datetime.datetime
        :keyword devices_metrics: Device alert count by severity.
        :paramtype devices_metrics: ~azure.mgmt.security.models.IoTSeverityMetrics
        """
        super().__init__(**kwargs)
        self.date = date
        self.devices_metrics = devices_metrics


class IoTSecuritySolutionModel(Resource, TagsResource):
    """IoT Security solution configuration and resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar workspace: Workspace resource ID.
    :vartype workspace: str
    :ivar display_name: Resource display name.
    :vartype display_name: str
    :ivar status: Status of the IoT Security solution. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.security.models.SecuritySolutionStatus
    :ivar export: List of additional options for exporting to workspace data.
    :vartype export: list[str or ~azure.mgmt.security.models.ExportData]
    :ivar disabled_data_sources: Disabled data sources. Disabling these data sources compromises
     the system.
    :vartype disabled_data_sources: list[str or ~azure.mgmt.security.models.DataSource]
    :ivar iot_hubs: IoT Hub resource IDs.
    :vartype iot_hubs: list[str]
    :ivar user_defined_resources: Properties of the IoT Security solution's user defined resources.
    :vartype user_defined_resources: ~azure.mgmt.security.models.UserDefinedResourcesProperties
    :ivar auto_discovered_resources: List of resources that were automatically discovered as
     relevant to the security solution.
    :vartype auto_discovered_resources: list[str]
    :ivar recommendations_configuration: List of the configuration status for each recommendation
     type.
    :vartype recommendations_configuration:
     list[~azure.mgmt.security.models.RecommendationConfigurationProperties]
    :ivar unmasked_ip_logging_status: Unmasked IP address logging status. Known values are:
     "Disabled" and "Enabled".
    :vartype unmasked_ip_logging_status: str or ~azure.mgmt.security.models.UnmaskedIpLoggingStatus
    :ivar additional_workspaces: List of additional workspaces.
    :vartype additional_workspaces:
     list[~azure.mgmt.security.models.AdditionalWorkspacesProperties]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "auto_discovered_resources": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "workspace": {"key": "properties.workspace", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "export": {"key": "properties.export", "type": "[str]"},
        "disabled_data_sources": {"key": "properties.disabledDataSources", "type": "[str]"},
        "iot_hubs": {"key": "properties.iotHubs", "type": "[str]"},
        "user_defined_resources": {"key": "properties.userDefinedResources", "type": "UserDefinedResourcesProperties"},
        "auto_discovered_resources": {"key": "properties.autoDiscoveredResources", "type": "[str]"},
        "recommendations_configuration": {
            "key": "properties.recommendationsConfiguration",
            "type": "[RecommendationConfigurationProperties]",
        },
        "unmasked_ip_logging_status": {"key": "properties.unmaskedIpLoggingStatus", "type": "str"},
        "additional_workspaces": {"key": "properties.additionalWorkspaces", "type": "[AdditionalWorkspacesProperties]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        workspace: Optional[str] = None,
        display_name: Optional[str] = None,
        status: Union[str, "_models.SecuritySolutionStatus"] = "Enabled",
        export: Optional[List[Union[str, "_models.ExportData"]]] = None,
        disabled_data_sources: Optional[List[Union[str, "_models.DataSource"]]] = None,
        iot_hubs: Optional[List[str]] = None,
        user_defined_resources: Optional["_models.UserDefinedResourcesProperties"] = None,
        recommendations_configuration: Optional[List["_models.RecommendationConfigurationProperties"]] = None,
        unmasked_ip_logging_status: Union[str, "_models.UnmaskedIpLoggingStatus"] = "Disabled",
        additional_workspaces: Optional[List["_models.AdditionalWorkspacesProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The resource location.
        :paramtype location: str
        :keyword workspace: Workspace resource ID.
        :paramtype workspace: str
        :keyword display_name: Resource display name.
        :paramtype display_name: str
        :keyword status: Status of the IoT Security solution. Known values are: "Enabled" and
         "Disabled".
        :paramtype status: str or ~azure.mgmt.security.models.SecuritySolutionStatus
        :keyword export: List of additional options for exporting to workspace data.
        :paramtype export: list[str or ~azure.mgmt.security.models.ExportData]
        :keyword disabled_data_sources: Disabled data sources. Disabling these data sources compromises
         the system.
        :paramtype disabled_data_sources: list[str or ~azure.mgmt.security.models.DataSource]
        :keyword iot_hubs: IoT Hub resource IDs.
        :paramtype iot_hubs: list[str]
        :keyword user_defined_resources: Properties of the IoT Security solution's user defined
         resources.
        :paramtype user_defined_resources: ~azure.mgmt.security.models.UserDefinedResourcesProperties
        :keyword recommendations_configuration: List of the configuration status for each
         recommendation type.
        :paramtype recommendations_configuration:
         list[~azure.mgmt.security.models.RecommendationConfigurationProperties]
        :keyword unmasked_ip_logging_status: Unmasked IP address logging status. Known values are:
         "Disabled" and "Enabled".
        :paramtype unmasked_ip_logging_status: str or
         ~azure.mgmt.security.models.UnmaskedIpLoggingStatus
        :keyword additional_workspaces: List of additional workspaces.
        :paramtype additional_workspaces:
         list[~azure.mgmt.security.models.AdditionalWorkspacesProperties]
        """
        super().__init__(tags=tags, **kwargs)
        self.tags = tags
        self.location = location
        self.system_data: Optional["_models.SystemData"] = None
        self.workspace = workspace
        self.display_name = display_name
        self.status = status
        self.export = export
        self.disabled_data_sources = disabled_data_sources
        self.iot_hubs = iot_hubs
        self.user_defined_resources = user_defined_resources
        self.auto_discovered_resources: Optional[List[str]] = None
        self.recommendations_configuration = recommendations_configuration
        self.unmasked_ip_logging_status = unmasked_ip_logging_status
        self.additional_workspaces = additional_workspaces
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class IoTSecuritySolutionsList(_serialization.Model):
    """List of IoT Security solutions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: List of IoT Security solutions. Required.
    :vartype value: list[~azure.mgmt.security.models.IoTSecuritySolutionModel]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IoTSecuritySolutionModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IoTSecuritySolutionModel"], **kwargs: Any) -> None:
        """
        :keyword value: List of IoT Security solutions. Required.
        :paramtype value: list[~azure.mgmt.security.models.IoTSecuritySolutionModel]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class IoTSeverityMetrics(_serialization.Model):
    """IoT Security solution analytics severity metrics.

    :ivar high: Count of high severity alerts/recommendations.
    :vartype high: int
    :ivar medium: Count of medium severity alerts/recommendations.
    :vartype medium: int
    :ivar low: Count of low severity alerts/recommendations.
    :vartype low: int
    """

    _attribute_map = {
        "high": {"key": "high", "type": "int"},
        "medium": {"key": "medium", "type": "int"},
        "low": {"key": "low", "type": "int"},
    }

    def __init__(
        self, *, high: Optional[int] = None, medium: Optional[int] = None, low: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword high: Count of high severity alerts/recommendations.
        :paramtype high: int
        :keyword medium: Count of medium severity alerts/recommendations.
        :paramtype medium: int
        :keyword low: Count of low severity alerts/recommendations.
        :paramtype low: int
        """
        super().__init__(**kwargs)
        self.high = high
        self.medium = medium
        self.low = low


class Issue(_serialization.Model):
    """The issue that caused the resource to by unhealthy.

    All required parameters must be populated in order to send to server.

    :ivar issue_key: The unique issue key. Required.
    :vartype issue_key: str
    :ivar issue_name: The issue name.
    :vartype issue_name: str
    :ivar security_values: The affected security values that MDC offers that will be affected by
     the issue, for example: recommendations, alerts, etc.
    :vartype security_values: list[str]
    :ivar issue_description: The issue description.
    :vartype issue_description: str
    :ivar remediation_steps: Human readable description of what you should do to mitigate this
     health issue.
    :vartype remediation_steps: str
    :ivar remediation_script: The remediation script to solve this issue.
    :vartype remediation_script: str
    :ivar issue_additional_data: Additional data for the given issue. The additional data depends
     on the issue type.
    :vartype issue_additional_data: dict[str, str]
    """

    _validation = {
        "issue_key": {"required": True},
    }

    _attribute_map = {
        "issue_key": {"key": "issueKey", "type": "str"},
        "issue_name": {"key": "issueName", "type": "str"},
        "security_values": {"key": "securityValues", "type": "[str]"},
        "issue_description": {"key": "issueDescription", "type": "str"},
        "remediation_steps": {"key": "remediationSteps", "type": "str"},
        "remediation_script": {"key": "remediationScript", "type": "str"},
        "issue_additional_data": {"key": "issueAdditionalData", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        issue_key: str,
        issue_name: Optional[str] = None,
        security_values: Optional[List[str]] = None,
        issue_description: Optional[str] = None,
        remediation_steps: Optional[str] = None,
        remediation_script: Optional[str] = None,
        issue_additional_data: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword issue_key: The unique issue key. Required.
        :paramtype issue_key: str
        :keyword issue_name: The issue name.
        :paramtype issue_name: str
        :keyword security_values: The affected security values that MDC offers that will be affected by
         the issue, for example: recommendations, alerts, etc.
        :paramtype security_values: list[str]
        :keyword issue_description: The issue description.
        :paramtype issue_description: str
        :keyword remediation_steps: Human readable description of what you should do to mitigate this
         health issue.
        :paramtype remediation_steps: str
        :keyword remediation_script: The remediation script to solve this issue.
        :paramtype remediation_script: str
        :keyword issue_additional_data: Additional data for the given issue. The additional data
         depends on the issue type.
        :paramtype issue_additional_data: dict[str, str]
        """
        super().__init__(**kwargs)
        self.issue_key = issue_key
        self.issue_name = issue_name
        self.security_values = security_values
        self.issue_description = issue_description
        self.remediation_steps = remediation_steps
        self.remediation_script = remediation_script
        self.issue_additional_data = issue_additional_data


class JFrogEnvironmentData(EnvironmentData):
    """The JFrog Artifactory connector environment data.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", "GitlabScope",
     "DockerHubOrganization", and "JFrogArtifactory".
    :vartype environment_type: str or ~azure.mgmt.security.models.EnvironmentType
    :ivar scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
    :vartype scan_interval: int
    """

    _validation = {
        "environment_type": {"required": True},
        "scan_interval": {"maximum": 24, "minimum": 1},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
        "scan_interval": {"key": "scanInterval", "type": "int"},
    }

    def __init__(self, *, scan_interval: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
        :paramtype scan_interval: int
        """
        super().__init__(**kwargs)
        self.environment_type: str = "JFrogArtifactory"
        self.scan_interval = scan_interval


class JitNetworkAccessPoliciesList(_serialization.Model):
    """JitNetworkAccessPoliciesList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.JitNetworkAccessPolicy]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JitNetworkAccessPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.JitNetworkAccessPolicy"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.models.JitNetworkAccessPolicy]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class JitNetworkAccessPolicy(Resource, Kind, Location):
    """JitNetworkAccessPolicy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar virtual_machines: Configurations for Microsoft.Compute/virtualMachines resource type.
     Required.
    :vartype virtual_machines:
     list[~azure.mgmt.security.models.JitNetworkAccessPolicyVirtualMachine]
    :ivar requests:
    :vartype requests: list[~azure.mgmt.security.models.JitNetworkAccessRequest]
    :ivar provisioning_state: Gets the provisioning state of the Just-in-Time policy.
    :vartype provisioning_state: str
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_machines": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[JitNetworkAccessPolicyVirtualMachine]"},
        "requests": {"key": "properties.requests", "type": "[JitNetworkAccessRequest]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_machines: List["_models.JitNetworkAccessPolicyVirtualMachine"],
        kind: Optional[str] = None,
        requests: Optional[List["_models.JitNetworkAccessRequest"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword virtual_machines: Configurations for Microsoft.Compute/virtualMachines resource type.
         Required.
        :paramtype virtual_machines:
         list[~azure.mgmt.security.models.JitNetworkAccessPolicyVirtualMachine]
        :keyword requests:
        :paramtype requests: list[~azure.mgmt.security.models.JitNetworkAccessRequest]
        """
        super().__init__(kind=kind, **kwargs)
        self.location: Optional[str] = None
        self.kind = kind
        self.virtual_machines = virtual_machines
        self.requests = requests
        self.provisioning_state: Optional[str] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class JitNetworkAccessPolicyInitiatePort(_serialization.Model):
    """JitNetworkAccessPolicyInitiatePort.

    All required parameters must be populated in order to send to server.

    :ivar number: Required.
    :vartype number: int
    :ivar allowed_source_address_prefix: Source of the allowed traffic. If omitted, the request
     will be for the source IP address of the initiate request.
    :vartype allowed_source_address_prefix: str
    :ivar end_time_utc: The time to close the request in UTC. Required.
    :vartype end_time_utc: ~datetime.datetime
    """

    _validation = {
        "number": {"required": True, "maximum": 65535, "minimum": 0},
        "end_time_utc": {"required": True},
    }

    _attribute_map = {
        "number": {"key": "number", "type": "int"},
        "allowed_source_address_prefix": {"key": "allowedSourceAddressPrefix", "type": "str"},
        "end_time_utc": {"key": "endTimeUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        number: int,
        end_time_utc: datetime.datetime,
        allowed_source_address_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number: Required.
        :paramtype number: int
        :keyword allowed_source_address_prefix: Source of the allowed traffic. If omitted, the request
         will be for the source IP address of the initiate request.
        :paramtype allowed_source_address_prefix: str
        :keyword end_time_utc: The time to close the request in UTC. Required.
        :paramtype end_time_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.number = number
        self.allowed_source_address_prefix = allowed_source_address_prefix
        self.end_time_utc = end_time_utc


class JitNetworkAccessPolicyInitiateRequest(_serialization.Model):
    """JitNetworkAccessPolicyInitiateRequest.

    All required parameters must be populated in order to send to server.

    :ivar virtual_machines: A list of virtual machines & ports to open access for. Required.
    :vartype virtual_machines:
     list[~azure.mgmt.security.models.JitNetworkAccessPolicyInitiateVirtualMachine]
    :ivar justification: The justification for making the initiate request.
    :vartype justification: str
    """

    _validation = {
        "virtual_machines": {"required": True},
    }

    _attribute_map = {
        "virtual_machines": {"key": "virtualMachines", "type": "[JitNetworkAccessPolicyInitiateVirtualMachine]"},
        "justification": {"key": "justification", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_machines: List["_models.JitNetworkAccessPolicyInitiateVirtualMachine"],
        justification: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_machines: A list of virtual machines & ports to open access for. Required.
        :paramtype virtual_machines:
         list[~azure.mgmt.security.models.JitNetworkAccessPolicyInitiateVirtualMachine]
        :keyword justification: The justification for making the initiate request.
        :paramtype justification: str
        """
        super().__init__(**kwargs)
        self.virtual_machines = virtual_machines
        self.justification = justification


class JitNetworkAccessPolicyInitiateVirtualMachine(_serialization.Model):  # pylint: disable=name-too-long
    """JitNetworkAccessPolicyInitiateVirtualMachine.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID of the virtual machine that is linked to this policy. Required.
    :vartype id: str
    :ivar ports: The ports to open for the resource with the ``id``. Required.
    :vartype ports: list[~azure.mgmt.security.models.JitNetworkAccessPolicyInitiatePort]
    """

    _validation = {
        "id": {"required": True},
        "ports": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "ports": {"key": "ports", "type": "[JitNetworkAccessPolicyInitiatePort]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        ports: List["_models.JitNetworkAccessPolicyInitiatePort"],
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of the virtual machine that is linked to this policy. Required.
        :paramtype id: str
        :keyword ports: The ports to open for the resource with the ``id``. Required.
        :paramtype ports: list[~azure.mgmt.security.models.JitNetworkAccessPolicyInitiatePort]
        """
        super().__init__(**kwargs)
        self.id = id
        self.ports = ports


class JitNetworkAccessPolicyVirtualMachine(_serialization.Model):
    """JitNetworkAccessPolicyVirtualMachine.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID of the virtual machine that is linked to this policy. Required.
    :vartype id: str
    :ivar ports: Port configurations for the virtual machine. Required.
    :vartype ports: list[~azure.mgmt.security.models.JitNetworkAccessPortRule]
    :ivar public_ip_address: Public IP address of the Azure Firewall that is linked to this policy,
     if applicable.
    :vartype public_ip_address: str
    """

    _validation = {
        "id": {"required": True},
        "ports": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "ports": {"key": "ports", "type": "[JitNetworkAccessPortRule]"},
        "public_ip_address": {"key": "publicIpAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        ports: List["_models.JitNetworkAccessPortRule"],
        public_ip_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of the virtual machine that is linked to this policy. Required.
        :paramtype id: str
        :keyword ports: Port configurations for the virtual machine. Required.
        :paramtype ports: list[~azure.mgmt.security.models.JitNetworkAccessPortRule]
        :keyword public_ip_address: Public IP address of the Azure Firewall that is linked to this
         policy, if applicable.
        :paramtype public_ip_address: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.ports = ports
        self.public_ip_address = public_ip_address


class JitNetworkAccessPortRule(_serialization.Model):
    """JitNetworkAccessPortRule.

    All required parameters must be populated in order to send to server.

    :ivar number: Required.
    :vartype number: int
    :ivar protocol: Required. Known values are: "TCP", "UDP", and "*".
    :vartype protocol: str or ~azure.mgmt.security.models.ProtocolEnum
    :ivar allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes"
     parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
    :vartype allowed_source_address_prefix: str
    :ivar allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix"
     parameter.
    :vartype allowed_source_address_prefixes: list[str]
    :ivar max_request_access_duration: Maximum duration requests can be made for. In ISO 8601
     duration format. Minimum 5 minutes, maximum 1 day. Required.
    :vartype max_request_access_duration: str
    """

    _validation = {
        "number": {"required": True, "maximum": 65535, "minimum": 0},
        "protocol": {"required": True},
        "max_request_access_duration": {"required": True},
    }

    _attribute_map = {
        "number": {"key": "number", "type": "int"},
        "protocol": {"key": "protocol", "type": "str"},
        "allowed_source_address_prefix": {"key": "allowedSourceAddressPrefix", "type": "str"},
        "allowed_source_address_prefixes": {"key": "allowedSourceAddressPrefixes", "type": "[str]"},
        "max_request_access_duration": {"key": "maxRequestAccessDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        number: int,
        protocol: Union[str, "_models.ProtocolEnum"],
        max_request_access_duration: str,
        allowed_source_address_prefix: Optional[str] = None,
        allowed_source_address_prefixes: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number: Required.
        :paramtype number: int
        :keyword protocol: Required. Known values are: "TCP", "UDP", and "*".
        :paramtype protocol: str or ~azure.mgmt.security.models.ProtocolEnum
        :keyword allowed_source_address_prefix: Mutually exclusive with the
         "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example
         "192.168.0.3" or "192.168.0.0/16".
        :paramtype allowed_source_address_prefix: str
        :keyword allowed_source_address_prefixes: Mutually exclusive with the
         "allowedSourceAddressPrefix" parameter.
        :paramtype allowed_source_address_prefixes: list[str]
        :keyword max_request_access_duration: Maximum duration requests can be made for. In ISO 8601
         duration format. Minimum 5 minutes, maximum 1 day. Required.
        :paramtype max_request_access_duration: str
        """
        super().__init__(**kwargs)
        self.number = number
        self.protocol = protocol
        self.allowed_source_address_prefix = allowed_source_address_prefix
        self.allowed_source_address_prefixes = allowed_source_address_prefixes
        self.max_request_access_duration = max_request_access_duration


class JitNetworkAccessRequest(_serialization.Model):
    """JitNetworkAccessRequest.

    All required parameters must be populated in order to send to server.

    :ivar virtual_machines: Required.
    :vartype virtual_machines:
     list[~azure.mgmt.security.models.JitNetworkAccessRequestVirtualMachine]
    :ivar start_time_utc: The start time of the request in UTC. Required.
    :vartype start_time_utc: ~datetime.datetime
    :ivar requestor: The identity of the person who made the request. Required.
    :vartype requestor: str
    :ivar justification: The justification for making the initiate request.
    :vartype justification: str
    """

    _validation = {
        "virtual_machines": {"required": True},
        "start_time_utc": {"required": True},
        "requestor": {"required": True},
    }

    _attribute_map = {
        "virtual_machines": {"key": "virtualMachines", "type": "[JitNetworkAccessRequestVirtualMachine]"},
        "start_time_utc": {"key": "startTimeUtc", "type": "iso-8601"},
        "requestor": {"key": "requestor", "type": "str"},
        "justification": {"key": "justification", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_machines: List["_models.JitNetworkAccessRequestVirtualMachine"],
        start_time_utc: datetime.datetime,
        requestor: str,
        justification: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_machines: Required.
        :paramtype virtual_machines:
         list[~azure.mgmt.security.models.JitNetworkAccessRequestVirtualMachine]
        :keyword start_time_utc: The start time of the request in UTC. Required.
        :paramtype start_time_utc: ~datetime.datetime
        :keyword requestor: The identity of the person who made the request. Required.
        :paramtype requestor: str
        :keyword justification: The justification for making the initiate request.
        :paramtype justification: str
        """
        super().__init__(**kwargs)
        self.virtual_machines = virtual_machines
        self.start_time_utc = start_time_utc
        self.requestor = requestor
        self.justification = justification


class JitNetworkAccessRequestPort(_serialization.Model):
    """JitNetworkAccessRequestPort.

    All required parameters must be populated in order to send to server.

    :ivar number: Required.
    :vartype number: int
    :ivar allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes"
     parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
    :vartype allowed_source_address_prefix: str
    :ivar allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix"
     parameter.
    :vartype allowed_source_address_prefixes: list[str]
    :ivar end_time_utc: The date & time at which the request ends in UTC. Required.
    :vartype end_time_utc: ~datetime.datetime
    :ivar status: The status of the port. Required. Known values are: "Revoked" and "Initiated".
    :vartype status: str or ~azure.mgmt.security.models.Status
    :ivar status_reason: A description of why the ``status`` has its value. Required. Known values
     are: "Expired", "UserRequested", and "NewerRequestInitiated".
    :vartype status_reason: str or ~azure.mgmt.security.models.StatusReason
    :ivar mapped_port: The port which is mapped to this port's ``number`` in the Azure Firewall, if
     applicable.
    :vartype mapped_port: int
    """

    _validation = {
        "number": {"required": True, "maximum": 65535, "minimum": 0},
        "end_time_utc": {"required": True},
        "status": {"required": True},
        "status_reason": {"required": True},
    }

    _attribute_map = {
        "number": {"key": "number", "type": "int"},
        "allowed_source_address_prefix": {"key": "allowedSourceAddressPrefix", "type": "str"},
        "allowed_source_address_prefixes": {"key": "allowedSourceAddressPrefixes", "type": "[str]"},
        "end_time_utc": {"key": "endTimeUtc", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "status_reason": {"key": "statusReason", "type": "str"},
        "mapped_port": {"key": "mappedPort", "type": "int"},
    }

    def __init__(
        self,
        *,
        number: int,
        end_time_utc: datetime.datetime,
        status: Union[str, "_models.Status"],
        status_reason: Union[str, "_models.StatusReason"],
        allowed_source_address_prefix: Optional[str] = None,
        allowed_source_address_prefixes: Optional[List[str]] = None,
        mapped_port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number: Required.
        :paramtype number: int
        :keyword allowed_source_address_prefix: Mutually exclusive with the
         "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example
         "192.168.0.3" or "192.168.0.0/16".
        :paramtype allowed_source_address_prefix: str
        :keyword allowed_source_address_prefixes: Mutually exclusive with the
         "allowedSourceAddressPrefix" parameter.
        :paramtype allowed_source_address_prefixes: list[str]
        :keyword end_time_utc: The date & time at which the request ends in UTC. Required.
        :paramtype end_time_utc: ~datetime.datetime
        :keyword status: The status of the port. Required. Known values are: "Revoked" and "Initiated".
        :paramtype status: str or ~azure.mgmt.security.models.Status
        :keyword status_reason: A description of why the ``status`` has its value. Required. Known
         values are: "Expired", "UserRequested", and "NewerRequestInitiated".
        :paramtype status_reason: str or ~azure.mgmt.security.models.StatusReason
        :keyword mapped_port: The port which is mapped to this port's ``number`` in the Azure Firewall,
         if applicable.
        :paramtype mapped_port: int
        """
        super().__init__(**kwargs)
        self.number = number
        self.allowed_source_address_prefix = allowed_source_address_prefix
        self.allowed_source_address_prefixes = allowed_source_address_prefixes
        self.end_time_utc = end_time_utc
        self.status = status
        self.status_reason = status_reason
        self.mapped_port = mapped_port


class JitNetworkAccessRequestVirtualMachine(_serialization.Model):
    """JitNetworkAccessRequestVirtualMachine.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID of the virtual machine that is linked to this policy. Required.
    :vartype id: str
    :ivar ports: The ports that were opened for the virtual machine. Required.
    :vartype ports: list[~azure.mgmt.security.models.JitNetworkAccessRequestPort]
    """

    _validation = {
        "id": {"required": True},
        "ports": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "ports": {"key": "ports", "type": "[JitNetworkAccessRequestPort]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        ports: List["_models.JitNetworkAccessRequestPort"],
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of the virtual machine that is linked to this policy. Required.
        :paramtype id: str
        :keyword ports: The ports that were opened for the virtual machine. Required.
        :paramtype ports: list[~azure.mgmt.security.models.JitNetworkAccessRequestPort]
        """
        super().__init__(**kwargs)
        self.id = id
        self.ports = ports


class Label(_serialization.Model):
    """Microsoft information protection sensitivity label.

    :ivar name: The display name of the label.
    :vartype name: str
    :ivar id: The ID of the label.
    :vartype id: str
    :ivar order: Labels are ordered by sensitivity level. The higher the order of the label, the
     more sensitive it is.
    :vartype order: float
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "order": {"key": "order", "type": "float"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        order: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The display name of the label.
        :paramtype name: str
        :keyword id: The ID of the label.
        :paramtype id: str
        :keyword order: Labels are ordered by sensitivity level. The higher the order of the label, the
         more sensitive it is.
        :paramtype order: float
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.order = order


class LocalUserNotAllowed(AllowlistCustomAlertRule):
    """Login by a local user that isn't allowed. Allow list consists of login names to allow.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :ivar allowlist_values: The values to allow. The format of the values depends on the rule type.
     Required.
    :vartype allowlist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "allowlist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "allowlist_values": {"key": "allowlistValues", "type": "[str]"},
    }

    def __init__(self, *, is_enabled: bool, allowlist_values: List[str], **kwargs: Any) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword allowlist_values: The values to allow. The format of the values depends on the rule
         type. Required.
        :paramtype allowlist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, allowlist_values=allowlist_values, **kwargs)
        self.rule_type: str = "LocalUserNotAllowed"


class LogAnalyticsIdentifier(ResourceIdentifier):
    """Represents a Log Analytics workspace scope identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: There can be multiple identifiers of different type per alert, this field specify
     the identifier type. Required. Known values are: "AzureResource" and "LogAnalytics".
    :vartype type: str or ~azure.mgmt.security.models.ResourceIdentifierType
    :ivar workspace_id: The LogAnalytics workspace id that stores this alert.
    :vartype workspace_id: str
    :ivar workspace_subscription_id: The azure subscription id for the LogAnalytics workspace
     storing this alert.
    :vartype workspace_subscription_id: str
    :ivar workspace_resource_group: The azure resource group for the LogAnalytics workspace storing
     this alert.
    :vartype workspace_resource_group: str
    :ivar agent_id: (optional) The LogAnalytics agent id reporting the event that this alert is
     based on.
    :vartype agent_id: str
    """

    _validation = {
        "type": {"required": True},
        "workspace_id": {"readonly": True},
        "workspace_subscription_id": {
            "readonly": True,
            "pattern": r"^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$",
        },
        "workspace_resource_group": {"readonly": True},
        "agent_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "workspace_subscription_id": {"key": "workspaceSubscriptionId", "type": "str"},
        "workspace_resource_group": {"key": "workspaceResourceGroup", "type": "str"},
        "agent_id": {"key": "agentId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: str = "LogAnalytics"
        self.workspace_id: Optional[str] = None
        self.workspace_subscription_id: Optional[str] = None
        self.workspace_resource_group: Optional[str] = None
        self.agent_id: Optional[str] = None


class MalwareScan(_serialization.Model):
    """Describes the state of a malware scan operation.

    :ivar properties:
    :vartype properties: ~azure.mgmt.security.models.MalwareScanProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "MalwareScanProperties"},
    }

    def __init__(self, *, properties: Optional["_models.MalwareScanProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.security.models.MalwareScanProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class MalwareScanningProperties(_serialization.Model):
    """Properties of Malware Scanning.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar on_upload: Properties of On Upload malware scanning.
    :vartype on_upload: ~azure.mgmt.security.models.OnUploadProperties
    :ivar scan_results_event_grid_topic_resource_id: Optional. Resource id of an Event Grid Topic
     to send scan results to.
    :vartype scan_results_event_grid_topic_resource_id: str
    :ivar blob_scan_results_options: Optional. Write scan result on blobIndexTags by default. Known
     values are: "blobIndexTags" and "None".
    :vartype blob_scan_results_options: str or ~azure.mgmt.security.models.BlobScanResultsOptions
    :ivar operation_status: Upon failure or partial success. Additional data describing Malware
     Scanning enable/disable operation.
    :vartype operation_status: ~azure.mgmt.security.models.OperationStatus
    """

    _validation = {
        "operation_status": {"readonly": True},
    }

    _attribute_map = {
        "on_upload": {"key": "onUpload", "type": "OnUploadProperties"},
        "scan_results_event_grid_topic_resource_id": {"key": "scanResultsEventGridTopicResourceId", "type": "str"},
        "blob_scan_results_options": {"key": "blobScanResultsOptions", "type": "str"},
        "operation_status": {"key": "operationStatus", "type": "OperationStatus"},
    }

    def __init__(
        self,
        *,
        on_upload: Optional["_models.OnUploadProperties"] = None,
        scan_results_event_grid_topic_resource_id: Optional[str] = None,
        blob_scan_results_options: Optional[Union[str, "_models.BlobScanResultsOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword on_upload: Properties of On Upload malware scanning.
        :paramtype on_upload: ~azure.mgmt.security.models.OnUploadProperties
        :keyword scan_results_event_grid_topic_resource_id: Optional. Resource id of an Event Grid
         Topic to send scan results to.
        :paramtype scan_results_event_grid_topic_resource_id: str
        :keyword blob_scan_results_options: Optional. Write scan result on blobIndexTags by default.
         Known values are: "blobIndexTags" and "None".
        :paramtype blob_scan_results_options: str or ~azure.mgmt.security.models.BlobScanResultsOptions
        """
        super().__init__(**kwargs)
        self.on_upload = on_upload
        self.scan_results_event_grid_topic_resource_id = scan_results_event_grid_topic_resource_id
        self.blob_scan_results_options = blob_scan_results_options
        self.operation_status: Optional["_models.OperationStatus"] = None


class MalwareScanProperties(_serialization.Model):
    """MalwareScanProperties.

    :ivar scan_id: The identifier of the scan.
    :vartype scan_id: str
    :ivar scan_status: A status code of the scan operation.
    :vartype scan_status: str
    :ivar scan_status_message: A description of the status of the scan.
    :vartype scan_status_message: str
    :ivar scan_start_time: The time at which the scan had been initiated.
    :vartype scan_start_time: str
    :ivar scan_end_time: The time at which the scan has ended. Only available for a scan which has
     terminated.
    :vartype scan_end_time: str
    :ivar scan_summary: A summary of the scan results.
    :vartype scan_summary: ~azure.mgmt.security.models.ScanSummary
    """

    _attribute_map = {
        "scan_id": {"key": "scanId", "type": "str"},
        "scan_status": {"key": "scanStatus", "type": "str"},
        "scan_status_message": {"key": "scanStatusMessage", "type": "str"},
        "scan_start_time": {"key": "scanStartTime", "type": "str"},
        "scan_end_time": {"key": "scanEndTime", "type": "str"},
        "scan_summary": {"key": "scanSummary", "type": "ScanSummary"},
    }

    def __init__(
        self,
        *,
        scan_id: Optional[str] = None,
        scan_status: Optional[str] = None,
        scan_status_message: Optional[str] = None,
        scan_start_time: Optional[str] = None,
        scan_end_time: Optional[str] = None,
        scan_summary: Optional["_models.ScanSummary"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scan_id: The identifier of the scan.
        :paramtype scan_id: str
        :keyword scan_status: A status code of the scan operation.
        :paramtype scan_status: str
        :keyword scan_status_message: A description of the status of the scan.
        :paramtype scan_status_message: str
        :keyword scan_start_time: The time at which the scan had been initiated.
        :paramtype scan_start_time: str
        :keyword scan_end_time: The time at which the scan has ended. Only available for a scan which
         has terminated.
        :paramtype scan_end_time: str
        :keyword scan_summary: A summary of the scan results.
        :paramtype scan_summary: ~azure.mgmt.security.models.ScanSummary
        """
        super().__init__(**kwargs)
        self.scan_id = scan_id
        self.scan_status = scan_status
        self.scan_status_message = scan_status_message
        self.scan_start_time = scan_start_time
        self.scan_end_time = scan_end_time
        self.scan_summary = scan_summary


class MdeOnboardingData(Resource):
    """The resource of the configuration or data needed to onboard the machine to MDE.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar onboarding_package_windows: The onboarding package used to onboard Windows machines to
     MDE, coded in base64. This can also be used for onboarding using the dedicated VM Extension.
    :vartype onboarding_package_windows: bytes
    :ivar onboarding_package_linux: The onboarding package used to onboard Linux machines to MDE,
     coded in base64. This can also be used for onboarding using the dedicated VM Extension.
    :vartype onboarding_package_linux: bytes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "onboarding_package_windows": {"key": "properties.onboardingPackageWindows", "type": "bytearray"},
        "onboarding_package_linux": {"key": "properties.onboardingPackageLinux", "type": "bytearray"},
    }

    def __init__(
        self,
        *,
        onboarding_package_windows: Optional[bytes] = None,
        onboarding_package_linux: Optional[bytes] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword onboarding_package_windows: The onboarding package used to onboard Windows machines to
         MDE, coded in base64. This can also be used for onboarding using the dedicated VM Extension.
        :paramtype onboarding_package_windows: bytes
        :keyword onboarding_package_linux: The onboarding package used to onboard Linux machines to
         MDE, coded in base64. This can also be used for onboarding using the dedicated VM Extension.
        :paramtype onboarding_package_linux: bytes
        """
        super().__init__(**kwargs)
        self.onboarding_package_windows = onboarding_package_windows
        self.onboarding_package_linux = onboarding_package_linux


class MdeOnboardingDataList(_serialization.Model):
    """List of all MDE onboarding data resources.

    :ivar value: List of the resources of the configuration or data needed to onboard the machine
     to MDE.
    :vartype value: list[~azure.mgmt.security.models.MdeOnboardingData]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MdeOnboardingData]"},
    }

    def __init__(self, *, value: Optional[List["_models.MdeOnboardingData"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of the resources of the configuration or data needed to onboard the
         machine to MDE.
        :paramtype value: list[~azure.mgmt.security.models.MdeOnboardingData]
        """
        super().__init__(**kwargs)
        self.value = value


class MqttC2DMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of cloud to device messages (MQTT protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "MqttC2DMessagesNotInAllowedRange"


class MqttC2DRejectedMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of rejected cloud to device messages (MQTT protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "MqttC2DRejectedMessagesNotInAllowedRange"


class MqttD2CMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device to cloud messages (MQTT protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "MqttD2CMessagesNotInAllowedRange"


class NodeIdentifier(_serialization.Model):
    """Represents a node in the path.

    All required parameters must be populated in order to send to server.

    :ivar id: The unique identifier of the node. Required.
    :vartype id: str
    :ivar type: The type of the node. Required.
    :vartype type: str
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: str, type: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The unique identifier of the node. Required.
        :paramtype id: str
        :keyword type: The type of the node. Required.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type


class NotificationsSource(_serialization.Model):
    """A valid notification source type.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    NotificationsSourceAlert, NotificationsSourceAttackPath

    All required parameters must be populated in order to send to server.

    :ivar source_type: The source type that will trigger the notification. Required. Known values
     are: "Alert" and "AttackPath".
    :vartype source_type: str or ~azure.mgmt.security.models.SourceType
    """

    _validation = {
        "source_type": {"required": True},
    }

    _attribute_map = {
        "source_type": {"key": "sourceType", "type": "str"},
    }

    _subtype_map = {"source_type": {"Alert": "NotificationsSourceAlert", "AttackPath": "NotificationsSourceAttackPath"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source_type: Optional[str] = None


class NotificationsSourceAlert(NotificationsSource):
    """Alert notification source.

    All required parameters must be populated in order to send to server.

    :ivar source_type: The source type that will trigger the notification. Required. Known values
     are: "Alert" and "AttackPath".
    :vartype source_type: str or ~azure.mgmt.security.models.SourceType
    :ivar minimal_severity: Defines the minimal alert severity which will be sent as email
     notifications. Known values are: "High", "Medium", and "Low".
    :vartype minimal_severity: str or ~azure.mgmt.security.models.MinimalSeverity
    """

    _validation = {
        "source_type": {"required": True},
    }

    _attribute_map = {
        "source_type": {"key": "sourceType", "type": "str"},
        "minimal_severity": {"key": "minimalSeverity", "type": "str"},
    }

    def __init__(
        self, *, minimal_severity: Optional[Union[str, "_models.MinimalSeverity"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword minimal_severity: Defines the minimal alert severity which will be sent as email
         notifications. Known values are: "High", "Medium", and "Low".
        :paramtype minimal_severity: str or ~azure.mgmt.security.models.MinimalSeverity
        """
        super().__init__(**kwargs)
        self.source_type: str = "Alert"
        self.minimal_severity = minimal_severity


class NotificationsSourceAttackPath(NotificationsSource):
    """Attack path notification source.

    All required parameters must be populated in order to send to server.

    :ivar source_type: The source type that will trigger the notification. Required. Known values
     are: "Alert" and "AttackPath".
    :vartype source_type: str or ~azure.mgmt.security.models.SourceType
    :ivar minimal_risk_level: Defines the minimal attach path risk level which will be sent as
     email notifications. Known values are: "Critical", "High", "Medium", and "Low".
    :vartype minimal_risk_level: str or ~azure.mgmt.security.models.MinimalRiskLevel
    """

    _validation = {
        "source_type": {"required": True},
    }

    _attribute_map = {
        "source_type": {"key": "sourceType", "type": "str"},
        "minimal_risk_level": {"key": "minimalRiskLevel", "type": "str"},
    }

    def __init__(
        self, *, minimal_risk_level: Optional[Union[str, "_models.MinimalRiskLevel"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword minimal_risk_level: Defines the minimal attach path risk level which will be sent as
         email notifications. Known values are: "Critical", "High", "Medium", and "Low".
        :paramtype minimal_risk_level: str or ~azure.mgmt.security.models.MinimalRiskLevel
        """
        super().__init__(**kwargs)
        self.source_type: str = "AttackPath"
        self.minimal_risk_level = minimal_risk_level


class OnPremiseResourceDetails(ResourceDetails):
    """Details of the On Premise resource that was assessed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    OnPremiseSqlResourceDetails

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.models.Source
    :ivar workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
    :vartype workspace_id: str
    :ivar vmuuid: The unique Id of the machine. Required.
    :vartype vmuuid: str
    :ivar source_computer_id: The oms agent Id installed on the machine. Required.
    :vartype source_computer_id: str
    :ivar machine_name: The name of the machine. Required.
    :vartype machine_name: str
    """

    _validation = {
        "source": {"required": True},
        "workspace_id": {"required": True},
        "vmuuid": {"required": True},
        "source_computer_id": {"required": True},
        "machine_name": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "vmuuid": {"key": "vmuuid", "type": "str"},
        "source_computer_id": {"key": "sourceComputerId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
    }

    _subtype_map = {"source": {"OnPremiseSql": "OnPremiseSqlResourceDetails"}}

    def __init__(
        self, *, workspace_id: str, vmuuid: str, source_computer_id: str, machine_name: str, **kwargs: Any
    ) -> None:
        """
        :keyword workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
        :paramtype workspace_id: str
        :keyword vmuuid: The unique Id of the machine. Required.
        :paramtype vmuuid: str
        :keyword source_computer_id: The oms agent Id installed on the machine. Required.
        :paramtype source_computer_id: str
        :keyword machine_name: The name of the machine. Required.
        :paramtype machine_name: str
        """
        super().__init__(**kwargs)
        self.source: str = "OnPremise"
        self.workspace_id = workspace_id
        self.vmuuid = vmuuid
        self.source_computer_id = source_computer_id
        self.machine_name = machine_name


class OnPremiseSqlResourceDetails(OnPremiseResourceDetails):
    """Details of the On Premise Sql resource that was assessed.

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.models.Source
    :ivar workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
    :vartype workspace_id: str
    :ivar vmuuid: The unique Id of the machine. Required.
    :vartype vmuuid: str
    :ivar source_computer_id: The oms agent Id installed on the machine. Required.
    :vartype source_computer_id: str
    :ivar machine_name: The name of the machine. Required.
    :vartype machine_name: str
    :ivar server_name: The Sql server name installed on the machine. Required.
    :vartype server_name: str
    :ivar database_name: The Sql database name installed on the machine. Required.
    :vartype database_name: str
    """

    _validation = {
        "source": {"required": True},
        "workspace_id": {"required": True},
        "vmuuid": {"required": True},
        "source_computer_id": {"required": True},
        "machine_name": {"required": True},
        "server_name": {"required": True},
        "database_name": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "vmuuid": {"key": "vmuuid", "type": "str"},
        "source_computer_id": {"key": "sourceComputerId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
    }

    def __init__(
        self,
        *,
        workspace_id: str,
        vmuuid: str,
        source_computer_id: str,
        machine_name: str,
        server_name: str,
        database_name: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
        :paramtype workspace_id: str
        :keyword vmuuid: The unique Id of the machine. Required.
        :paramtype vmuuid: str
        :keyword source_computer_id: The oms agent Id installed on the machine. Required.
        :paramtype source_computer_id: str
        :keyword machine_name: The name of the machine. Required.
        :paramtype machine_name: str
        :keyword server_name: The Sql server name installed on the machine. Required.
        :paramtype server_name: str
        :keyword database_name: The Sql database name installed on the machine. Required.
        :paramtype database_name: str
        """
        super().__init__(
            workspace_id=workspace_id,
            vmuuid=vmuuid,
            source_computer_id=source_computer_id,
            machine_name=machine_name,
            **kwargs
        )
        self.source: str = "OnPremiseSql"
        self.server_name = server_name
        self.database_name = database_name


class OnUploadFilters(_serialization.Model):
    """Optional. Determine which blobs get scanned by On Upload malware scanning. An Or operation is
    performed between each filter type.

    :ivar exclude_blobs_with_prefix: Optional. A list of prefixes to exclude from on-upload malware
     scanning.
     Format: ``container-name/blob-name`` (start with the container name; do not include the storage
     account name).
     Exclude entire containers: Use prefix of container names you want to exclude without a trailing
     ``/``.
     Exclude a single container: Add a trailing slash ``/`` after the container name to avoid
     excluding other containers with similar prefixes.
    :vartype exclude_blobs_with_prefix: list[str]
    :ivar exclude_blobs_with_suffix: Optional. A list of suffixes to exclude from on-upload malware
     scanning. Suffixes match only the end of blob names, and should be used for file extensions or
     blob name endings only.
    :vartype exclude_blobs_with_suffix: list[str]
    :ivar exclude_blobs_larger_than: Optional. Specifies the maximum size in bytes for blobs to be
     scanned. This parameter accepts a single positive integer value. Blobs larger than this value
     will be excluded from scanning.
    :vartype exclude_blobs_larger_than: any
    """

    _attribute_map = {
        "exclude_blobs_with_prefix": {"key": "excludeBlobsWithPrefix", "type": "[str]"},
        "exclude_blobs_with_suffix": {"key": "excludeBlobsWithSuffix", "type": "[str]"},
        "exclude_blobs_larger_than": {"key": "excludeBlobsLargerThan", "type": "object"},
    }

    def __init__(
        self,
        *,
        exclude_blobs_with_prefix: Optional[List[str]] = None,
        exclude_blobs_with_suffix: Optional[List[str]] = None,
        exclude_blobs_larger_than: Optional[Any] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword exclude_blobs_with_prefix: Optional. A list of prefixes to exclude from on-upload
         malware scanning.
         Format: ``container-name/blob-name`` (start with the container name; do not include the storage
         account name).
         Exclude entire containers: Use prefix of container names you want to exclude without a trailing
         ``/``.
         Exclude a single container: Add a trailing slash ``/`` after the container name to avoid
         excluding other containers with similar prefixes.
        :paramtype exclude_blobs_with_prefix: list[str]
        :keyword exclude_blobs_with_suffix: Optional. A list of suffixes to exclude from on-upload
         malware scanning. Suffixes match only the end of blob names, and should be used for file
         extensions or blob name endings only.
        :paramtype exclude_blobs_with_suffix: list[str]
        :keyword exclude_blobs_larger_than: Optional. Specifies the maximum size in bytes for blobs to
         be scanned. This parameter accepts a single positive integer value. Blobs larger than this
         value will be excluded from scanning.
        :paramtype exclude_blobs_larger_than: any
        """
        super().__init__(**kwargs)
        self.exclude_blobs_with_prefix = exclude_blobs_with_prefix
        self.exclude_blobs_with_suffix = exclude_blobs_with_suffix
        self.exclude_blobs_larger_than = exclude_blobs_larger_than


class OnUploadProperties(_serialization.Model):
    """Properties of On Upload malware scanning.

    :ivar is_enabled: Indicates whether On Upload malware scanning should be enabled.
    :vartype is_enabled: bool
    :ivar cap_gb_per_month: Defines the max GB to be scanned per Month. Set to -1 if no capping is
     needed. If not specified, the default value is -1.
    :vartype cap_gb_per_month: int
    :ivar filters: Optional. Determine which blobs get scanned by On Upload malware scanning. An Or
     operation is performed between each filter type.
    :vartype filters: ~azure.mgmt.security.models.OnUploadFilters
    """

    _attribute_map = {
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "cap_gb_per_month": {"key": "capGBPerMonth", "type": "int"},
        "filters": {"key": "filters", "type": "OnUploadFilters"},
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = None,
        cap_gb_per_month: Optional[int] = None,
        filters: Optional["_models.OnUploadFilters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Indicates whether On Upload malware scanning should be enabled.
        :paramtype is_enabled: bool
        :keyword cap_gb_per_month: Defines the max GB to be scanned per Month. Set to -1 if no capping
         is needed. If not specified, the default value is -1.
        :paramtype cap_gb_per_month: int
        :keyword filters: Optional. Determine which blobs get scanned by On Upload malware scanning. An
         Or operation is performed between each filter type.
        :paramtype filters: ~azure.mgmt.security.models.OnUploadFilters
        """
        super().__init__(**kwargs)
        self.is_enabled = is_enabled
        self.cap_gb_per_month = cap_gb_per_month
        self.filters = filters


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.security.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.security.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Known values are: "Internal", "LogicApp", "EventHub", and "Workspace".
    :vartype action_type: str or ~azure.mgmt.security.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.security.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action: Optional[bool] = None
        self.display = display
        self.origin: Optional[Union[str, "_models.Origin"]] = None
        self.action_type: Optional[Union[str, "_models.ActionType"]] = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.security.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Operation"]] = None
        self.next_link: Optional[str] = None


class OperationResultAutoGenerated(_serialization.Model):
    """Long run operation status of governance rule over a given scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The status of the long run operation result of governance rule. Known values are:
     "Succeeded", "Failed", and "Canceled".
    :vartype status: str or ~azure.mgmt.security.models.OperationResult
    """

    _validation = {
        "status": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status: Optional[Union[str, "_models.OperationResult"]] = None


class OperationStatus(_serialization.Model):
    """A status describing the success/failure of the enablement/disablement operation.

    :ivar code: The operation status code.
    :vartype code: str
    :ivar message: Additional information regarding the success/failure of the operation.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: The operation status code.
        :paramtype code: str
        :keyword message: Additional information regarding the success/failure of the operation.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class OperationStatusAutoGenerated(_serialization.Model):
    """A status describing the success/failure of the extension's enablement/disablement operation.

    :ivar code: The operation status code. Known values are: "Succeeded" and "Failed".
    :vartype code: str or ~azure.mgmt.security.models.Code
    :ivar message: Additional information regarding the success/failure of the operation.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[Union[str, "_models.Code"]] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: The operation status code. Known values are: "Succeeded" and "Failed".
        :paramtype code: str or ~azure.mgmt.security.models.Code
        :keyword message: Additional information regarding the success/failure of the operation.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class OperationStatusResult(_serialization.Model):
    """The current status of an async operation.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar percent_complete: Percent of the operation that is complete.
    :vartype percent_complete: float
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar operations: The operations list.
    :vartype operations: list[~azure.mgmt.security.models.OperationStatusResult]
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.security.models.ErrorDetailAutoGenerated2
    """

    _validation = {
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "operations": {"key": "operations", "type": "[OperationStatusResult]"},
        "error": {"key": "error", "type": "ErrorDetailAutoGenerated2"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        percent_complete: Optional[float] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        operations: Optional[List["_models.OperationStatusResult"]] = None,
        error: Optional["_models.ErrorDetailAutoGenerated2"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword percent_complete: Percent of the operation that is complete.
        :paramtype percent_complete: float
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword operations: The operations list.
        :paramtype operations: list[~azure.mgmt.security.models.OperationStatusResult]
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.security.models.ErrorDetailAutoGenerated2
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.percent_complete = percent_complete
        self.start_time = start_time
        self.end_time = end_time
        self.operations = operations
        self.error = error


class PartialAssessmentProperties(_serialization.Model):
    """Describes properties of an assessment as related to the standard.

    :ivar assessment_key: The assessment key.
    :vartype assessment_key: str
    """

    _attribute_map = {
        "assessment_key": {"key": "assessmentKey", "type": "str"},
    }

    def __init__(self, *, assessment_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword assessment_key: The assessment key.
        :paramtype assessment_key: str
        """
        super().__init__(**kwargs)
        self.assessment_key = assessment_key


class Path(_serialization.Model):
    """Represents a path that composes the risk.

    All required parameters must be populated in order to send to server.

    :ivar id: Path ID. Required.
    :vartype id: str
    :ivar nodes: Path Nodes. Required.
    :vartype nodes: list[~azure.mgmt.security.models.NodeIdentifier]
    :ivar edges: Path Edges. Required.
    :vartype edges: list[~azure.mgmt.security.models.EdgeIdentifiers]
    """

    _validation = {
        "id": {"required": True},
        "nodes": {"required": True},
        "edges": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "nodes": {"key": "nodes", "type": "[NodeIdentifier]"},
        "edges": {"key": "edges", "type": "[EdgeIdentifiers]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        nodes: List["_models.NodeIdentifier"],
        edges: List["_models.EdgeIdentifiers"],
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Path ID. Required.
        :paramtype id: str
        :keyword nodes: Path Nodes. Required.
        :paramtype nodes: list[~azure.mgmt.security.models.NodeIdentifier]
        :keyword edges: Path Edges. Required.
        :paramtype edges: list[~azure.mgmt.security.models.EdgeIdentifiers]
        """
        super().__init__(**kwargs)
        self.id = id
        self.nodes = nodes
        self.edges = edges


class Pricing(Resource):
    """Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard
    tier offers advanced security capabilities, while the free tier offers basic security features.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar pricing_tier: Indicates whether the Defender plan is enabled on the selected scope.
     Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard
     tier offers advanced security capabilities, while the free tier offers basic security features.
     Known values are: "Free" and "Standard".
    :vartype pricing_tier: str or ~azure.mgmt.security.models.PricingTier
    :ivar sub_plan: The sub-plan selected for a Standard pricing configuration, when more than one
     sub-plan is available. Each sub-plan enables a set of security features. When not specified,
     full plan is applied. For VirtualMachines plan, available sub plans are 'P1' & 'P2', where for
     resource level only 'P1' sub plan is supported.
    :vartype sub_plan: str
    :ivar free_trial_remaining_time: The duration left for the subscriptions free trial period - in
     ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
    :vartype free_trial_remaining_time: ~datetime.timedelta
    :ivar enablement_time: Optional. If ``pricingTier`` is ``Standard`` then this property holds
     the date of the last time the ``pricingTier`` was set to ``Standard``\\ , when available (e.g
     2023-03-01T12:42:42.1921106Z).
    :vartype enablement_time: ~datetime.datetime
    :ivar enforce: If set to "False", it allows the descendants of this scope to override the
     pricing configuration set on this scope (allows setting inherited="False"). If set to "True",
     it prevents overrides and forces this pricing configuration on all the descendants of this
     scope. This field is only available for subscription-level pricing. Known values are: "False"
     and "True".
    :vartype enforce: str or ~azure.mgmt.security.models.Enforce
    :ivar inherited: "inherited" = "True" indicates that the current scope inherits its pricing
     configuration from its parent. The ID of the parent scope that provides the inherited
     configuration is displayed in the "inheritedFrom" field. On the other hand, "inherited" =
     "False" indicates that the current scope has its own pricing configuration explicitly set, and
     does not inherit from its parent. This field is read only and available only for resource-level
     pricing. Known values are: "True" and "False".
    :vartype inherited: str or ~azure.mgmt.security.models.Inherited
    :ivar inherited_from: The id of the scope inherited from. "Null" if not inherited. This field
     is only available for resource-level pricing.
    :vartype inherited_from: str
    :ivar resources_coverage_status: This field is available for subscription-level only, and
     reflects the coverage status of the resources under the subscription. Please note: The
     "pricingTier" field reflects the plan status of the subscription. However, since the plan
     status can also be defined at the resource level, there might be misalignment between the
     subscription's plan status and the resource status. This field helps indicate the coverage
     status of the resources. Known values are: "FullyCovered", "PartiallyCovered", and
     "NotCovered".
    :vartype resources_coverage_status: str or ~azure.mgmt.security.models.ResourcesCoverageStatus
    :ivar extensions: Optional. List of extensions offered under a plan.
    :vartype extensions: list[~azure.mgmt.security.models.Extension]
    :ivar deprecated: Optional. True if the plan is deprecated. If there are replacing plans they
     will appear in ``replacedBy`` property.
    :vartype deprecated: bool
    :ivar replaced_by: Optional. List of plans that replace this plan. This property exists only if
     this plan is deprecated.
    :vartype replaced_by: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "free_trial_remaining_time": {"readonly": True},
        "enablement_time": {"readonly": True},
        "inherited": {"readonly": True},
        "inherited_from": {"readonly": True},
        "resources_coverage_status": {"readonly": True},
        "deprecated": {"readonly": True},
        "replaced_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "pricing_tier": {"key": "properties.pricingTier", "type": "str"},
        "sub_plan": {"key": "properties.subPlan", "type": "str"},
        "free_trial_remaining_time": {"key": "properties.freeTrialRemainingTime", "type": "duration"},
        "enablement_time": {"key": "properties.enablementTime", "type": "iso-8601"},
        "enforce": {"key": "properties.enforce", "type": "str"},
        "inherited": {"key": "properties.inherited", "type": "str"},
        "inherited_from": {"key": "properties.inheritedFrom", "type": "str"},
        "resources_coverage_status": {"key": "properties.resourcesCoverageStatus", "type": "str"},
        "extensions": {"key": "properties.extensions", "type": "[Extension]"},
        "deprecated": {"key": "properties.deprecated", "type": "bool"},
        "replaced_by": {"key": "properties.replacedBy", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        pricing_tier: Optional[Union[str, "_models.PricingTier"]] = None,
        sub_plan: Optional[str] = None,
        enforce: Optional[Union[str, "_models.Enforce"]] = None,
        extensions: Optional[List["_models.Extension"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pricing_tier: Indicates whether the Defender plan is enabled on the selected scope.
         Microsoft Defender for Cloud is provided in two pricing tiers: free and standard. The standard
         tier offers advanced security capabilities, while the free tier offers basic security features.
         Known values are: "Free" and "Standard".
        :paramtype pricing_tier: str or ~azure.mgmt.security.models.PricingTier
        :keyword sub_plan: The sub-plan selected for a Standard pricing configuration, when more than
         one sub-plan is available. Each sub-plan enables a set of security features. When not
         specified, full plan is applied. For VirtualMachines plan, available sub plans are 'P1' & 'P2',
         where for resource level only 'P1' sub plan is supported.
        :paramtype sub_plan: str
        :keyword enforce: If set to "False", it allows the descendants of this scope to override the
         pricing configuration set on this scope (allows setting inherited="False"). If set to "True",
         it prevents overrides and forces this pricing configuration on all the descendants of this
         scope. This field is only available for subscription-level pricing. Known values are: "False"
         and "True".
        :paramtype enforce: str or ~azure.mgmt.security.models.Enforce
        :keyword extensions: Optional. List of extensions offered under a plan.
        :paramtype extensions: list[~azure.mgmt.security.models.Extension]
        """
        super().__init__(**kwargs)
        self.pricing_tier = pricing_tier
        self.sub_plan = sub_plan
        self.free_trial_remaining_time: Optional[datetime.timedelta] = None
        self.enablement_time: Optional[datetime.datetime] = None
        self.enforce = enforce
        self.inherited: Optional[Union[str, "_models.Inherited"]] = None
        self.inherited_from: Optional[str] = None
        self.resources_coverage_status: Optional[Union[str, "_models.ResourcesCoverageStatus"]] = None
        self.extensions = extensions
        self.deprecated: Optional[bool] = None
        self.replaced_by: Optional[List[str]] = None


class PricingList(_serialization.Model):
    """List of pricing configurations response.

    All required parameters must be populated in order to send to server.

    :ivar value: List of pricing configurations. Required.
    :vartype value: list[~azure.mgmt.security.models.Pricing]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Pricing]"},
    }

    def __init__(self, *, value: List["_models.Pricing"], **kwargs: Any) -> None:
        """
        :keyword value: List of pricing configurations. Required.
        :paramtype value: list[~azure.mgmt.security.models.Pricing]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateEndpoint(_serialization.Model):
    """The private endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for private endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None


class PrivateEndpointConnection(ResourceAutoGenerated):
    """The private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.security.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.security.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The private endpoint resource.
        :paramtype private_endpoint: ~azure.mgmt.security.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.security.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.group_ids: Optional[List[str]] = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connections associated with the specified resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.security.models.PrivateEndpointConnection]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.security.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class PrivateLinkParameters(_serialization.Model):
    """Parameter group.

    All required parameters must be populated in order to send to server.

    :ivar private_link_name: The name of the private link resource. Must be unique within the
     resource group and follow Azure naming conventions. Required.
    :vartype private_link_name: str
    """

    _validation = {
        "private_link_name": {
            "required": True,
            "max_length": 63,
            "min_length": 3,
            "pattern": r"^[A-Za-z0-9]+(?:-[A-Za-z0-9]+)*$",
        },
    }

    _attribute_map = {
        "private_link_name": {"key": "privateLinkName", "type": "str"},
    }

    def __init__(self, *, private_link_name: str, **kwargs: Any) -> None:
        """
        :keyword private_link_name: The name of the private link resource. Must be unique within the
         resource group and follow Azure naming conventions. Required.
        :paramtype private_link_name: str
        """
        super().__init__(**kwargs)
        self.private_link_name = private_link_name


class ResourceAutoGenerated2(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class TrackedResourceAutoGenerated(ResourceAutoGenerated2):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class PrivateLinkResource(TrackedResourceAutoGenerated):
    """A private link resource that enables secure, private connectivity to Microsoft Defender for
    Cloud services. This resource manages the lifecycle of private endpoint connections and
    provides the necessary infrastructure for private connectivity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: The current provisioning state of the private link resource.
     Indicates whether the resource is being created, updated, deleted, or has completed
     successfully. Known values are: "Succeeded", "Failed", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.ProvisioningState
    :ivar private_endpoint_connections: List of private endpoint connections associated with this
     private link. Each connection represents a private endpoint from a customer's virtual network.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.security.models.PrivateEndpointConnection]
    :ivar private_link_resources: List of private link resources available for connection. For
     Defender services, this typically includes the 'containers' group with 'api' and regional data
     endpoints.
    :vartype private_link_resources:
     list[~azure.mgmt.security.models.PrivateLinkResourceAutoGenerated]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "private_link_resources": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "private_link_resources": {
            "key": "properties.privateLinkResources",
            "type": "[PrivateLinkResourceAutoGenerated]",
        },
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None
        self.private_link_resources: Optional[List["_models.PrivateLinkResourceAutoGenerated"]] = None


class PrivateLinkResourceAutoGenerated(ResourceAutoGenerated):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id: Optional[str] = None
        self.required_members: Optional[List[str]] = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.security.models.PrivateLinkResourceAutoGenerated]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResourceAutoGenerated]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PrivateLinkResourceAutoGenerated"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.security.models.PrivateLinkResourceAutoGenerated]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.security.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or ~azure.mgmt.security.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class PrivateLinksList(_serialization.Model):
    """Paginated list of private link resources. Contains an array of private links and optional
    pagination information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of private links in this page. Required.
    :vartype value: list[~azure.mgmt.security.models.PrivateLinkResource]
    :ivar next_link: The URI to fetch the next page of private links. Present only when there are
     additional results available.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.PrivateLinkResource"]] = None
        self.next_link: Optional[str] = None


class PrivateLinkUpdate(_serialization.Model):
    """Request payload for updating a private link resource. Used in PATCH operations to update
    specific mutable properties without affecting the entire resource configuration.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ProcessNotAllowed(AllowlistCustomAlertRule):
    """Execution of a process that isn't allowed. Allow list consists of process names to allow.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.models.ValueType
    :ivar allowlist_values: The values to allow. The format of the values depends on the rule type.
     Required.
    :vartype allowlist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "allowlist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "allowlist_values": {"key": "allowlistValues", "type": "[str]"},
    }

    def __init__(self, *, is_enabled: bool, allowlist_values: List[str], **kwargs: Any) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword allowlist_values: The values to allow. The format of the values depends on the rule
         type. Required.
        :paramtype allowlist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, allowlist_values=allowlist_values, **kwargs)
        self.rule_type: str = "ProcessNotAllowed"


class ProxyServerProperties(_serialization.Model):
    """For a non-Azure machine that is not connected directly to the internet, specify a proxy server
    that the non-Azure machine can use.

    :ivar ip: Proxy server IP.
    :vartype ip: str
    :ivar port: Proxy server port.
    :vartype port: str
    """

    _attribute_map = {
        "ip": {"key": "ip", "type": "str"},
        "port": {"key": "port", "type": "str"},
    }

    def __init__(self, *, ip: Optional[str] = None, port: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip: Proxy server IP.
        :paramtype ip: str
        :keyword port: Proxy server port.
        :paramtype port: str
        """
        super().__init__(**kwargs)
        self.ip = ip
        self.port = port


class QueryCheck(_serialization.Model):
    """The rule query details.

    :ivar query: The rule query.
    :vartype query: str
    :ivar expected_result: Expected result.
    :vartype expected_result: list[list[str]]
    :ivar column_names: Column names of expected result.
    :vartype column_names: list[str]
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "expected_result": {"key": "expectedResult", "type": "[[str]]"},
        "column_names": {"key": "columnNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        expected_result: Optional[List[List[str]]] = None,
        column_names: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query: The rule query.
        :paramtype query: str
        :keyword expected_result: Expected result.
        :paramtype expected_result: list[list[str]]
        :keyword column_names: Column names of expected result.
        :paramtype column_names: list[str]
        """
        super().__init__(**kwargs)
        self.query = query
        self.expected_result = expected_result
        self.column_names = column_names


class QueuePurgesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device queue purges is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "QueuePurgesNotInAllowedRange"


class RecommendationConfigurationProperties(_serialization.Model):
    """The type of IoT Security recommendation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar recommendation_type: The type of IoT Security recommendation. Required. Known values are:
     "IoT_ACRAuthentication", "IoT_AgentSendsUnutilizedMessages", "IoT_Baseline",
     "IoT_EdgeHubMemOptimize", "IoT_EdgeLoggingOptions", "IoT_InconsistentModuleSettings",
     "IoT_InstallAgent", "IoT_IPFilter_DenyAll", "IoT_IPFilter_PermissiveRule", "IoT_OpenPorts",
     "IoT_PermissiveFirewallPolicy", "IoT_PermissiveInputFirewallRules",
     "IoT_PermissiveOutputFirewallRules", "IoT_PrivilegedDockerOptions", "IoT_SharedCredentials",
     and "IoT_VulnerableTLSCipherSuite".
    :vartype recommendation_type: str or ~azure.mgmt.security.models.RecommendationType
    :ivar name:
    :vartype name: str
    :ivar status: Recommendation status. When the recommendation status is disabled recommendations
     are not generated. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.security.models.RecommendationConfigStatus
    """

    _validation = {
        "recommendation_type": {"required": True},
        "name": {"readonly": True},
        "status": {"required": True},
    }

    _attribute_map = {
        "recommendation_type": {"key": "recommendationType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        recommendation_type: Union[str, "_models.RecommendationType"],
        status: Union[str, "_models.RecommendationConfigStatus"] = "Enabled",
        **kwargs: Any
    ) -> None:
        """
        :keyword recommendation_type: The type of IoT Security recommendation. Required. Known values
         are: "IoT_ACRAuthentication", "IoT_AgentSendsUnutilizedMessages", "IoT_Baseline",
         "IoT_EdgeHubMemOptimize", "IoT_EdgeLoggingOptions", "IoT_InconsistentModuleSettings",
         "IoT_InstallAgent", "IoT_IPFilter_DenyAll", "IoT_IPFilter_PermissiveRule", "IoT_OpenPorts",
         "IoT_PermissiveFirewallPolicy", "IoT_PermissiveInputFirewallRules",
         "IoT_PermissiveOutputFirewallRules", "IoT_PrivilegedDockerOptions", "IoT_SharedCredentials",
         and "IoT_VulnerableTLSCipherSuite".
        :paramtype recommendation_type: str or ~azure.mgmt.security.models.RecommendationType
        :keyword status: Recommendation status. When the recommendation status is disabled
         recommendations are not generated. Known values are: "Disabled" and "Enabled".
        :paramtype status: str or ~azure.mgmt.security.models.RecommendationConfigStatus
        """
        super().__init__(**kwargs)
        self.recommendation_type = recommendation_type
        self.name: Optional[str] = None
        self.status = status


class RegulatoryComplianceAssessment(Resource):
    """Regulatory compliance assessment details and state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: The description of the regulatory compliance assessment.
    :vartype description: str
    :ivar assessment_type: The expected type of assessment contained in the AssessmentDetailsLink.
    :vartype assessment_type: str
    :ivar assessment_details_link: Link to more detailed assessment results data. The response type
     will be according to the assessmentType field.
    :vartype assessment_details_link: str
    :ivar state: Aggregative state based on the assessment's scanned resources states. Known values
     are: "Passed", "Failed", "Skipped", and "Unsupported".
    :vartype state: str or ~azure.mgmt.security.models.State
    :ivar passed_resources: The given assessment's related resources count with passed state.
    :vartype passed_resources: int
    :ivar failed_resources: The given assessment's related resources count with failed state.
    :vartype failed_resources: int
    :ivar skipped_resources: The given assessment's related resources count with skipped state.
    :vartype skipped_resources: int
    :ivar unsupported_resources: The given assessment's related resources count with unsupported
     state.
    :vartype unsupported_resources: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
        "assessment_type": {"readonly": True},
        "assessment_details_link": {"readonly": True},
        "passed_resources": {"readonly": True},
        "failed_resources": {"readonly": True},
        "skipped_resources": {"readonly": True},
        "unsupported_resources": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "assessment_type": {"key": "properties.assessmentType", "type": "str"},
        "assessment_details_link": {"key": "properties.assessmentDetailsLink", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "passed_resources": {"key": "properties.passedResources", "type": "int"},
        "failed_resources": {"key": "properties.failedResources", "type": "int"},
        "skipped_resources": {"key": "properties.skippedResources", "type": "int"},
        "unsupported_resources": {"key": "properties.unsupportedResources", "type": "int"},
    }

    def __init__(self, *, state: Optional[Union[str, "_models.State"]] = None, **kwargs: Any) -> None:
        """
        :keyword state: Aggregative state based on the assessment's scanned resources states. Known
         values are: "Passed", "Failed", "Skipped", and "Unsupported".
        :paramtype state: str or ~azure.mgmt.security.models.State
        """
        super().__init__(**kwargs)
        self.description: Optional[str] = None
        self.assessment_type: Optional[str] = None
        self.assessment_details_link: Optional[str] = None
        self.state = state
        self.passed_resources: Optional[int] = None
        self.failed_resources: Optional[int] = None
        self.skipped_resources: Optional[int] = None
        self.unsupported_resources: Optional[int] = None


class RegulatoryComplianceAssessmentList(_serialization.Model):
    """List of regulatory compliance assessment response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.security.models.RegulatoryComplianceAssessment]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RegulatoryComplianceAssessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RegulatoryComplianceAssessment"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.security.models.RegulatoryComplianceAssessment]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class RegulatoryComplianceControl(Resource):
    """Regulatory compliance control details and state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: The description of the regulatory compliance control.
    :vartype description: str
    :ivar state: Aggregative state based on the control's supported assessments states. Known
     values are: "Passed", "Failed", "Skipped", and "Unsupported".
    :vartype state: str or ~azure.mgmt.security.models.State
    :ivar passed_assessments: The number of supported regulatory compliance assessments of the
     given control with a passed state.
    :vartype passed_assessments: int
    :ivar failed_assessments: The number of supported regulatory compliance assessments of the
     given control with a failed state.
    :vartype failed_assessments: int
    :ivar skipped_assessments: The number of supported regulatory compliance assessments of the
     given control with a skipped state.
    :vartype skipped_assessments: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
        "passed_assessments": {"readonly": True},
        "failed_assessments": {"readonly": True},
        "skipped_assessments": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "passed_assessments": {"key": "properties.passedAssessments", "type": "int"},
        "failed_assessments": {"key": "properties.failedAssessments", "type": "int"},
        "skipped_assessments": {"key": "properties.skippedAssessments", "type": "int"},
    }

    def __init__(self, *, state: Optional[Union[str, "_models.State"]] = None, **kwargs: Any) -> None:
        """
        :keyword state: Aggregative state based on the control's supported assessments states. Known
         values are: "Passed", "Failed", "Skipped", and "Unsupported".
        :paramtype state: str or ~azure.mgmt.security.models.State
        """
        super().__init__(**kwargs)
        self.description: Optional[str] = None
        self.state = state
        self.passed_assessments: Optional[int] = None
        self.failed_assessments: Optional[int] = None
        self.skipped_assessments: Optional[int] = None


class RegulatoryComplianceControlList(_serialization.Model):
    """List of regulatory compliance controls response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: List of regulatory compliance controls. Required.
    :vartype value: list[~azure.mgmt.security.models.RegulatoryComplianceControl]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RegulatoryComplianceControl]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RegulatoryComplianceControl"], **kwargs: Any) -> None:
        """
        :keyword value: List of regulatory compliance controls. Required.
        :paramtype value: list[~azure.mgmt.security.models.RegulatoryComplianceControl]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class RegulatoryComplianceStandard(Resource):
    """Regulatory compliance standard details and state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: Aggregative state based on the standard's supported controls states. Known values
     are: "Passed", "Failed", "Skipped", and "Unsupported".
    :vartype state: str or ~azure.mgmt.security.models.State
    :ivar passed_controls: The number of supported regulatory compliance controls of the given
     standard with a passed state.
    :vartype passed_controls: int
    :ivar failed_controls: The number of supported regulatory compliance controls of the given
     standard with a failed state.
    :vartype failed_controls: int
    :ivar skipped_controls: The number of supported regulatory compliance controls of the given
     standard with a skipped state.
    :vartype skipped_controls: int
    :ivar unsupported_controls: The number of regulatory compliance controls of the given standard
     which are unsupported by automated assessments.
    :vartype unsupported_controls: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "passed_controls": {"readonly": True},
        "failed_controls": {"readonly": True},
        "skipped_controls": {"readonly": True},
        "unsupported_controls": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "passed_controls": {"key": "properties.passedControls", "type": "int"},
        "failed_controls": {"key": "properties.failedControls", "type": "int"},
        "skipped_controls": {"key": "properties.skippedControls", "type": "int"},
        "unsupported_controls": {"key": "properties.unsupportedControls", "type": "int"},
    }

    def __init__(self, *, state: Optional[Union[str, "_models.State"]] = None, **kwargs: Any) -> None:
        """
        :keyword state: Aggregative state based on the standard's supported controls states. Known
         values are: "Passed", "Failed", "Skipped", and "Unsupported".
        :paramtype state: str or ~azure.mgmt.security.models.State
        """
        super().__init__(**kwargs)
        self.state = state
        self.passed_controls: Optional[int] = None
        self.failed_controls: Optional[int] = None
        self.skipped_controls: Optional[int] = None
        self.unsupported_controls: Optional[int] = None


class RegulatoryComplianceStandardList(_serialization.Model):
    """List of regulatory compliance standards response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.security.models.RegulatoryComplianceStandard]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RegulatoryComplianceStandard]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.RegulatoryComplianceStandard"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.security.models.RegulatoryComplianceStandard]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class Remediation(_serialization.Model):
    """Remediation details.

    :ivar description: Remediation description.
    :vartype description: str
    :ivar scripts: Remediation script.
    :vartype scripts: list[str]
    :ivar automated: Is remediation automated.
    :vartype automated: bool
    :ivar portal_link: Optional link to remediate in Azure Portal.
    :vartype portal_link: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "scripts": {"key": "scripts", "type": "[str]"},
        "automated": {"key": "automated", "type": "bool"},
        "portal_link": {"key": "portalLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        scripts: Optional[List[str]] = None,
        automated: Optional[bool] = None,
        portal_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Remediation description.
        :paramtype description: str
        :keyword scripts: Remediation script.
        :paramtype scripts: list[str]
        :keyword automated: Is remediation automated.
        :paramtype automated: bool
        :keyword portal_link: Optional link to remediate in Azure Portal.
        :paramtype portal_link: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.scripts = scripts
        self.automated = automated
        self.portal_link = portal_link


class RemediationEta(_serialization.Model):
    """The ETA (estimated time of arrival) for remediation.

    All required parameters must be populated in order to send to server.

    :ivar eta: ETA for remediation. Required.
    :vartype eta: ~datetime.datetime
    :ivar justification: Justification for change of Eta. Required.
    :vartype justification: str
    """

    _validation = {
        "eta": {"required": True},
        "justification": {"required": True},
    }

    _attribute_map = {
        "eta": {"key": "eta", "type": "iso-8601"},
        "justification": {"key": "justification", "type": "str"},
    }

    def __init__(self, *, eta: datetime.datetime, justification: str, **kwargs: Any) -> None:
        """
        :keyword eta: ETA for remediation. Required.
        :paramtype eta: ~datetime.datetime
        :keyword justification: Justification for change of Eta. Required.
        :paramtype justification: str
        """
        super().__init__(**kwargs)
        self.eta = eta
        self.justification = justification


class ResourceDetailsAutoGenerated(_serialization.Model):
    """The resource details of the health report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source: The status of the health report. Known values are: "Azure", "OnPremise", and
     "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.models.Source
    :ivar id: The azure id of the resource.
    :vartype id: str
    :ivar connector_id: The id of the connector.
    :vartype connector_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "connector_id": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "connector_id": {"key": "connectorId", "type": "str"},
    }

    def __init__(self, *, source: Optional[Union[str, "_models.Source"]] = None, **kwargs: Any) -> None:
        """
        :keyword source: The status of the health report. Known values are: "Azure", "OnPremise", and
         "OnPremiseSql".
        :paramtype source: str or ~azure.mgmt.security.models.Source
        """
        super().__init__(**kwargs)
        self.source = source
        self.id: Optional[str] = None
        self.connector_id: Optional[str] = None


class RuleResults(Resource):
    """Rule results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Rule results properties.
    :vartype properties: ~azure.mgmt.security.models.RuleResultsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "RuleResultsProperties"},
    }

    def __init__(self, *, properties: Optional["_models.RuleResultsProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Rule results properties.
        :paramtype properties: ~azure.mgmt.security.models.RuleResultsProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class RuleResultsInput(_serialization.Model):
    """Rule results input.

    :ivar latest_scan: Take results from latest scan.
    :vartype latest_scan: bool
    :ivar results: Expected results to be inserted into the baseline.
     Leave this field empty it LatestScan == true.
    :vartype results: list[list[str]]
    """

    _attribute_map = {
        "latest_scan": {"key": "latestScan", "type": "bool"},
        "results": {"key": "results", "type": "[[str]]"},
    }

    def __init__(
        self, *, latest_scan: Optional[bool] = None, results: Optional[List[List[str]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword latest_scan: Take results from latest scan.
        :paramtype latest_scan: bool
        :keyword results: Expected results to be inserted into the baseline.
         Leave this field empty it LatestScan == true.
        :paramtype results: list[list[str]]
        """
        super().__init__(**kwargs)
        self.latest_scan = latest_scan
        self.results = results


class RuleResultsProperties(_serialization.Model):
    """Rule results properties.

    :ivar results: Expected results in the baseline.
    :vartype results: list[list[str]]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[[str]]"},
    }

    def __init__(self, *, results: Optional[List[List[str]]] = None, **kwargs: Any) -> None:
        """
        :keyword results: Expected results in the baseline.
        :paramtype results: list[list[str]]
        """
        super().__init__(**kwargs)
        self.results = results


class RulesResults(_serialization.Model):
    """A list of rules results.

    :ivar value: List of rule results.
    :vartype value: list[~azure.mgmt.security.models.RuleResults]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RuleResults]"},
    }

    def __init__(self, *, value: Optional[List["_models.RuleResults"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of rule results.
        :paramtype value: list[~azure.mgmt.security.models.RuleResults]
        """
        super().__init__(**kwargs)
        self.value = value


class RulesResultsInput(_serialization.Model):
    """Rules results input.

    :ivar latest_scan: Take results from latest scan.
    :vartype latest_scan: bool
    :ivar results: Expected results to be inserted into the baseline.
     Leave this field empty it LatestScan == true.
    :vartype results: dict[str, list[list[str]]]
    """

    _attribute_map = {
        "latest_scan": {"key": "latestScan", "type": "bool"},
        "results": {"key": "results", "type": "{[[str]]}"},
    }

    def __init__(
        self, *, latest_scan: Optional[bool] = None, results: Optional[Dict[str, List[List[str]]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword latest_scan: Take results from latest scan.
        :paramtype latest_scan: bool
        :keyword results: Expected results to be inserted into the baseline.
         Leave this field empty it LatestScan == true.
        :paramtype results: dict[str, list[list[str]]]
        """
        super().__init__(**kwargs)
        self.latest_scan = latest_scan
        self.results = results


class Scan(Resource):
    """A vulnerability assessment scan record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: A vulnerability assessment scan record properties.
    :vartype properties: ~azure.mgmt.security.models.ScanProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ScanProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ScanProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: A vulnerability assessment scan record properties.
        :paramtype properties: ~azure.mgmt.security.models.ScanProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ScanProperties(_serialization.Model):
    """A vulnerability assessment scan record properties.

    :ivar trigger_type: The scan trigger type. Known values are: "OnDemand" and "Recurring".
    :vartype trigger_type: str or ~azure.mgmt.security.models.ScanTriggerType
    :ivar state: The scan status. Known values are: "Failed", "FailedToRun", "InProgress", and
     "Passed".
    :vartype state: str or ~azure.mgmt.security.models.ScanState
    :ivar server: The server name.
    :vartype server: str
    :ivar database: The database name.
    :vartype database: str
    :ivar sql_version: The SQL version.
    :vartype sql_version: str
    :ivar start_time: The scan start time (UTC).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Scan results are valid until end time (UTC).
    :vartype end_time: ~datetime.datetime
    :ivar high_severity_failed_rules_count: The number of failed rules with high severity.
    :vartype high_severity_failed_rules_count: int
    :ivar medium_severity_failed_rules_count: The number of failed rules with medium severity.
    :vartype medium_severity_failed_rules_count: int
    :ivar low_severity_failed_rules_count: The number of failed rules with low severity.
    :vartype low_severity_failed_rules_count: int
    :ivar total_passed_rules_count: The number of total passed rules.
    :vartype total_passed_rules_count: int
    :ivar total_failed_rules_count: The number of total failed rules.
    :vartype total_failed_rules_count: int
    :ivar total_rules_count: The number of total rules assessed.
    :vartype total_rules_count: int
    :ivar is_baseline_applied: Baseline created for this database, and has one or more rules.
    :vartype is_baseline_applied: bool
    :ivar last_scan_time: Last scan time.
    :vartype last_scan_time: ~datetime.datetime
    """

    _attribute_map = {
        "trigger_type": {"key": "triggerType", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "server": {"key": "server", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "sql_version": {"key": "sqlVersion", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "high_severity_failed_rules_count": {"key": "highSeverityFailedRulesCount", "type": "int"},
        "medium_severity_failed_rules_count": {"key": "mediumSeverityFailedRulesCount", "type": "int"},
        "low_severity_failed_rules_count": {"key": "lowSeverityFailedRulesCount", "type": "int"},
        "total_passed_rules_count": {"key": "totalPassedRulesCount", "type": "int"},
        "total_failed_rules_count": {"key": "totalFailedRulesCount", "type": "int"},
        "total_rules_count": {"key": "totalRulesCount", "type": "int"},
        "is_baseline_applied": {"key": "isBaselineApplied", "type": "bool"},
        "last_scan_time": {"key": "lastScanTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        trigger_type: Optional[Union[str, "_models.ScanTriggerType"]] = None,
        state: Optional[Union[str, "_models.ScanState"]] = None,
        server: Optional[str] = None,
        database: Optional[str] = None,
        sql_version: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        high_severity_failed_rules_count: Optional[int] = None,
        medium_severity_failed_rules_count: Optional[int] = None,
        low_severity_failed_rules_count: Optional[int] = None,
        total_passed_rules_count: Optional[int] = None,
        total_failed_rules_count: Optional[int] = None,
        total_rules_count: Optional[int] = None,
        is_baseline_applied: Optional[bool] = None,
        last_scan_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword trigger_type: The scan trigger type. Known values are: "OnDemand" and "Recurring".
        :paramtype trigger_type: str or ~azure.mgmt.security.models.ScanTriggerType
        :keyword state: The scan status. Known values are: "Failed", "FailedToRun", "InProgress", and
         "Passed".
        :paramtype state: str or ~azure.mgmt.security.models.ScanState
        :keyword server: The server name.
        :paramtype server: str
        :keyword database: The database name.
        :paramtype database: str
        :keyword sql_version: The SQL version.
        :paramtype sql_version: str
        :keyword start_time: The scan start time (UTC).
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Scan results are valid until end time (UTC).
        :paramtype end_time: ~datetime.datetime
        :keyword high_severity_failed_rules_count: The number of failed rules with high severity.
        :paramtype high_severity_failed_rules_count: int
        :keyword medium_severity_failed_rules_count: The number of failed rules with medium severity.
        :paramtype medium_severity_failed_rules_count: int
        :keyword low_severity_failed_rules_count: The number of failed rules with low severity.
        :paramtype low_severity_failed_rules_count: int
        :keyword total_passed_rules_count: The number of total passed rules.
        :paramtype total_passed_rules_count: int
        :keyword total_failed_rules_count: The number of total failed rules.
        :paramtype total_failed_rules_count: int
        :keyword total_rules_count: The number of total rules assessed.
        :paramtype total_rules_count: int
        :keyword is_baseline_applied: Baseline created for this database, and has one or more rules.
        :paramtype is_baseline_applied: bool
        :keyword last_scan_time: Last scan time.
        :paramtype last_scan_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.trigger_type = trigger_type
        self.state = state
        self.server = server
        self.database = database
        self.sql_version = sql_version
        self.start_time = start_time
        self.end_time = end_time
        self.high_severity_failed_rules_count = high_severity_failed_rules_count
        self.medium_severity_failed_rules_count = medium_severity_failed_rules_count
        self.low_severity_failed_rules_count = low_severity_failed_rules_count
        self.total_passed_rules_count = total_passed_rules_count
        self.total_failed_rules_count = total_failed_rules_count
        self.total_rules_count = total_rules_count
        self.is_baseline_applied = is_baseline_applied
        self.last_scan_time = last_scan_time


class ScanResult(Resource):
    """A vulnerability assessment scan result for a single rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: A vulnerability assessment scan result properties for a single rule.
    :vartype properties: ~azure.mgmt.security.models.ScanResultProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ScanResultProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ScanResultProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: A vulnerability assessment scan result properties for a single rule.
        :paramtype properties: ~azure.mgmt.security.models.ScanResultProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ScanResultProperties(_serialization.Model):
    """A vulnerability assessment scan result properties for a single rule.

    :ivar rule_id: The rule Id.
    :vartype rule_id: str
    :ivar status: The rule result status. Known values are: "NonFinding", "Finding", and
     "InternalError".
    :vartype status: str or ~azure.mgmt.security.models.RuleStatus
    :ivar is_trimmed: Indicated whether the results specified here are trimmed.
    :vartype is_trimmed: bool
    :ivar query_results: The results of the query that was run.
    :vartype query_results: list[list[str]]
    :ivar remediation: Remediation details.
    :vartype remediation: ~azure.mgmt.security.models.Remediation
    :ivar baseline_adjusted_result: The rule result adjusted with baseline.
    :vartype baseline_adjusted_result: ~azure.mgmt.security.models.BaselineAdjustedResult
    :ivar rule_metadata: vulnerability assessment rule metadata details.
    :vartype rule_metadata: ~azure.mgmt.security.models.VaRule
    """

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "is_trimmed": {"key": "isTrimmed", "type": "bool"},
        "query_results": {"key": "queryResults", "type": "[[str]]"},
        "remediation": {"key": "remediation", "type": "Remediation"},
        "baseline_adjusted_result": {"key": "baselineAdjustedResult", "type": "BaselineAdjustedResult"},
        "rule_metadata": {"key": "ruleMetadata", "type": "VaRule"},
    }

    def __init__(
        self,
        *,
        rule_id: Optional[str] = None,
        status: Optional[Union[str, "_models.RuleStatus"]] = None,
        is_trimmed: Optional[bool] = None,
        query_results: Optional[List[List[str]]] = None,
        remediation: Optional["_models.Remediation"] = None,
        baseline_adjusted_result: Optional["_models.BaselineAdjustedResult"] = None,
        rule_metadata: Optional["_models.VaRule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_id: The rule Id.
        :paramtype rule_id: str
        :keyword status: The rule result status. Known values are: "NonFinding", "Finding", and
         "InternalError".
        :paramtype status: str or ~azure.mgmt.security.models.RuleStatus
        :keyword is_trimmed: Indicated whether the results specified here are trimmed.
        :paramtype is_trimmed: bool
        :keyword query_results: The results of the query that was run.
        :paramtype query_results: list[list[str]]
        :keyword remediation: Remediation details.
        :paramtype remediation: ~azure.mgmt.security.models.Remediation
        :keyword baseline_adjusted_result: The rule result adjusted with baseline.
        :paramtype baseline_adjusted_result: ~azure.mgmt.security.models.BaselineAdjustedResult
        :keyword rule_metadata: vulnerability assessment rule metadata details.
        :paramtype rule_metadata: ~azure.mgmt.security.models.VaRule
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.status = status
        self.is_trimmed = is_trimmed
        self.query_results = query_results
        self.remediation = remediation
        self.baseline_adjusted_result = baseline_adjusted_result
        self.rule_metadata = rule_metadata


class ScanResults(_serialization.Model):
    """A list of vulnerability assessment scan results.

    :ivar value: List of vulnerability assessment scan results.
    :vartype value: list[~azure.mgmt.security.models.ScanResult]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ScanResult]"},
    }

    def __init__(self, *, value: Optional[List["_models.ScanResult"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of vulnerability assessment scan results.
        :paramtype value: list[~azure.mgmt.security.models.ScanResult]
        """
        super().__init__(**kwargs)
        self.value = value


class Scans(_serialization.Model):
    """A list of vulnerability assessment scan records.

    :ivar value: List of vulnerability assessment scan records.
    :vartype value: list[~azure.mgmt.security.models.Scan]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Scan]"},
    }

    def __init__(self, *, value: Optional[List["_models.Scan"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of vulnerability assessment scan records.
        :paramtype value: list[~azure.mgmt.security.models.Scan]
        """
        super().__init__(**kwargs)
        self.value = value


class ScanSummary(_serialization.Model):
    """A summary of the scan results.

    :ivar blobs: A summary of the scan results of the blobs that were scanned.
    :vartype blobs: ~azure.mgmt.security.models.BlobsScanSummary
    :ivar estimated_scan_cost_usd: The estimated cost of the scan. Only available for a scan which
     has terminated.
    :vartype estimated_scan_cost_usd: float
    """

    _attribute_map = {
        "blobs": {"key": "blobs", "type": "BlobsScanSummary"},
        "estimated_scan_cost_usd": {"key": "estimatedScanCostUSD", "type": "float"},
    }

    def __init__(
        self,
        *,
        blobs: Optional["_models.BlobsScanSummary"] = None,
        estimated_scan_cost_usd: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blobs: A summary of the scan results of the blobs that were scanned.
        :paramtype blobs: ~azure.mgmt.security.models.BlobsScanSummary
        :keyword estimated_scan_cost_usd: The estimated cost of the scan. Only available for a scan
         which has terminated.
        :paramtype estimated_scan_cost_usd: float
        """
        super().__init__(**kwargs)
        self.blobs = blobs
        self.estimated_scan_cost_usd = estimated_scan_cost_usd


class ScopeElement(_serialization.Model):
    """A more specific scope used to identify the alerts to suppress.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar field: The alert entity type to suppress by.
    :vartype field: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "field": {"key": "field", "type": "str"},
    }

    def __init__(
        self, *, additional_properties: Optional[Dict[str, Any]] = None, field: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword field: The alert entity type to suppress by.
        :paramtype field: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.field = field


class SecureScoreControlDefinitionItem(Resource):
    """Information about the security control.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User friendly display name of the control.
    :vartype display_name: str
    :ivar description: User friendly description of the control.
    :vartype description: str
    :ivar max_score: Maximum control score (0..10).
    :vartype max_score: int
    :ivar source: Source object from which the control was created.
    :vartype source: ~azure.mgmt.security.models.SecureScoreControlDefinitionSource
    :ivar assessment_definitions: Array of assessments metadata IDs that are included in this
     security control.
    :vartype assessment_definitions: list[~azure.mgmt.security.models.AzureResourceLink]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True, "max_length": 256},
        "max_score": {"readonly": True, "maximum": 10, "minimum": 0},
        "source": {"readonly": True},
        "assessment_definitions": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "max_score": {"key": "properties.maxScore", "type": "int"},
        "source": {"key": "properties.source", "type": "SecureScoreControlDefinitionSource"},
        "assessment_definitions": {"key": "properties.assessmentDefinitions", "type": "[AzureResourceLink]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name: Optional[str] = None
        self.description: Optional[str] = None
        self.max_score: Optional[int] = None
        self.source: Optional["_models.SecureScoreControlDefinitionSource"] = None
        self.assessment_definitions: Optional[List["_models.AzureResourceLink"]] = None


class SecureScoreControlDefinitionList(_serialization.Model):
    """List of security controls definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of security controls definition in this page.
    :vartype value: list[~azure.mgmt.security.models.SecureScoreControlDefinitionItem]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecureScoreControlDefinitionItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SecureScoreControlDefinitionItem"]] = None
        self.next_link: Optional[str] = None


class SecureScoreControlDefinitionSource(_serialization.Model):
    """The type of the security control (For example, BuiltIn).

    :ivar source_type: The type of security control (for example, BuiltIn). Known values are:
     "BuiltIn" and "Custom".
    :vartype source_type: str or ~azure.mgmt.security.models.ControlType
    """

    _attribute_map = {
        "source_type": {"key": "sourceType", "type": "str"},
    }

    def __init__(self, *, source_type: Optional[Union[str, "_models.ControlType"]] = None, **kwargs: Any) -> None:
        """
        :keyword source_type: The type of security control (for example, BuiltIn). Known values are:
         "BuiltIn" and "Custom".
        :paramtype source_type: str or ~azure.mgmt.security.models.ControlType
        """
        super().__init__(**kwargs)
        self.source_type = source_type


class SecureScoreControlDetails(Resource):
    """Details of the security control, its score, and the health status of the relevant resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User friendly display name of the control.
    :vartype display_name: str
    :ivar healthy_resource_count: Number of healthy resources in the control.
    :vartype healthy_resource_count: int
    :ivar unhealthy_resource_count: Number of unhealthy resources in the control.
    :vartype unhealthy_resource_count: int
    :ivar not_applicable_resource_count: Number of not applicable resources in the control.
    :vartype not_applicable_resource_count: int
    :ivar weight: The relative weight for this specific control in each of your subscriptions. Used
     when calculating an aggregated score for this control across all of your subscriptions.
    :vartype weight: int
    :ivar definition: Information about the security control.
    :vartype definition: ~azure.mgmt.security.models.SecureScoreControlDefinitionItem
    :ivar max: Maximum score available.
    :vartype max: int
    :ivar current: Current score.
    :vartype current: float
    :ivar percentage: Ratio of the current score divided by the maximum. Rounded to 4 digits after
     the decimal point.
    :vartype percentage: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "healthy_resource_count": {"readonly": True},
        "unhealthy_resource_count": {"readonly": True},
        "not_applicable_resource_count": {"readonly": True},
        "weight": {"readonly": True, "minimum": 0},
        "max": {"readonly": True, "minimum": 0},
        "current": {"readonly": True, "minimum": 0},
        "percentage": {"readonly": True, "maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "healthy_resource_count": {"key": "properties.healthyResourceCount", "type": "int"},
        "unhealthy_resource_count": {"key": "properties.unhealthyResourceCount", "type": "int"},
        "not_applicable_resource_count": {"key": "properties.notApplicableResourceCount", "type": "int"},
        "weight": {"key": "properties.weight", "type": "int"},
        "definition": {"key": "properties.definition", "type": "SecureScoreControlDefinitionItem"},
        "max": {"key": "properties.score.max", "type": "int"},
        "current": {"key": "properties.score.current", "type": "float"},
        "percentage": {"key": "properties.score.percentage", "type": "float"},
    }

    def __init__(
        self, *, definition: Optional["_models.SecureScoreControlDefinitionItem"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword definition: Information about the security control.
        :paramtype definition: ~azure.mgmt.security.models.SecureScoreControlDefinitionItem
        """
        super().__init__(**kwargs)
        self.display_name: Optional[str] = None
        self.healthy_resource_count: Optional[int] = None
        self.unhealthy_resource_count: Optional[int] = None
        self.not_applicable_resource_count: Optional[int] = None
        self.weight: Optional[int] = None
        self.definition = definition
        self.max: Optional[int] = None
        self.current: Optional[float] = None
        self.percentage: Optional[float] = None


class SecureScoreControlList(_serialization.Model):
    """List of security controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of security controls in this page.
    :vartype value: list[~azure.mgmt.security.models.SecureScoreControlDetails]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecureScoreControlDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SecureScoreControlDetails"]] = None
        self.next_link: Optional[str] = None


class SecureScoreControlScore(_serialization.Model):
    """Calculation result data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar max: Maximum control score (0..10).
    :vartype max: int
    :ivar current: Actual score for the control = (achieved points / total points) * max score. if
     total points is zeroed, the return number is 0.00.
    :vartype current: float
    :ivar percentage: Ratio of the current score divided by the maximum. Rounded to 4 digits after
     the decimal point.
    :vartype percentage: float
    """

    _validation = {
        "max": {"readonly": True, "maximum": 10, "minimum": 0},
        "current": {"readonly": True, "maximum": 10, "minimum": 0},
        "percentage": {"readonly": True, "maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "max": {"key": "max", "type": "int"},
        "current": {"key": "current", "type": "float"},
        "percentage": {"key": "percentage", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.max: Optional[int] = None
        self.current: Optional[float] = None
        self.percentage: Optional[float] = None


class SecureScoreItem(Resource):
    """Secure score item data model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: The initiative’s name.
    :vartype display_name: str
    :ivar weight: The relative weight for each subscription. Used when calculating an aggregated
     secure score for multiple subscriptions.
    :vartype weight: int
    :ivar max: Maximum score available.
    :vartype max: int
    :ivar current: Current score.
    :vartype current: float
    :ivar percentage: Ratio of the current score divided by the maximum. Rounded to 4 digits after
     the decimal point.
    :vartype percentage: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "weight": {"readonly": True, "minimum": 0},
        "max": {"readonly": True, "minimum": 0},
        "current": {"readonly": True, "minimum": 0},
        "percentage": {"readonly": True, "maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "weight": {"key": "properties.weight", "type": "int"},
        "max": {"key": "properties.score.max", "type": "int"},
        "current": {"key": "properties.score.current", "type": "float"},
        "percentage": {"key": "properties.score.percentage", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name: Optional[str] = None
        self.weight: Optional[int] = None
        self.max: Optional[int] = None
        self.current: Optional[float] = None
        self.percentage: Optional[float] = None


class SecureScoresList(_serialization.Model):
    """List of secure scores.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of secure scores in this page.
    :vartype value: list[~azure.mgmt.security.models.SecureScoreItem]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecureScoreItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SecureScoreItem"]] = None
        self.next_link: Optional[str] = None


class SecurityAssessment(Resource):
    """Security assessment on a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar risk: External model of risk result.
    :vartype risk: ~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRisk
    :ivar resource_details: Details of the resource that was assessed.
    :vartype resource_details: ~azure.mgmt.security.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.models.SecurityAssessmentPartnerData
    :ivar status: The result of the assessment.
    :vartype status: ~azure.mgmt.security.models.AssessmentStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "risk": {"key": "properties.risk", "type": "SecurityAssessmentPropertiesBaseRisk"},
        "resource_details": {"key": "properties.resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{str}"},
        "links": {"key": "properties.links", "type": "AssessmentLinks"},
        "metadata": {"key": "properties.metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "properties.partnersData", "type": "SecurityAssessmentPartnerData"},
        "status": {"key": "properties.status", "type": "AssessmentStatus"},
    }

    def __init__(
        self,
        *,
        risk: Optional["_models.SecurityAssessmentPropertiesBaseRisk"] = None,
        resource_details: Optional["_models.ResourceDetails"] = None,
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        status: Optional["_models.AssessmentStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword risk: External model of risk result.
        :paramtype risk: ~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRisk
        :keyword resource_details: Details of the resource that was assessed.
        :paramtype resource_details: ~azure.mgmt.security.models.ResourceDetails
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata: ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.models.SecurityAssessmentPartnerData
        :keyword status: The result of the assessment.
        :paramtype status: ~azure.mgmt.security.models.AssessmentStatus
        """
        super().__init__(**kwargs)
        self.risk = risk
        self.resource_details = resource_details
        self.display_name: Optional[str] = None
        self.additional_data = additional_data
        self.links: Optional["_models.AssessmentLinks"] = None
        self.metadata = metadata
        self.partners_data = partners_data
        self.status = status


class SecurityAssessmentList(_serialization.Model):
    """Page of a security assessments list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of security assessments in this page.
    :vartype value: list[~azure.mgmt.security.models.SecurityAssessmentResponse]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityAssessmentResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SecurityAssessmentResponse"]] = None
        self.next_link: Optional[str] = None


class SecurityAssessmentMetadata(Resource):
    """Security assessment metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition that turns this
     assessment calculation on.
    :vartype policy_definition_id: str
    :ivar description: Human readable description of the assessment.
    :vartype description: str
    :ivar remediation_description: Human readable description of what you should do to mitigate
     this security issue.
    :vartype remediation_description: str
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.security.models.Categories]
    :ivar severity: The severity level of the assessment. Known values are: "Low", "Medium", and
     "High".
    :vartype severity: str or ~azure.mgmt.security.models.Severity
    :ivar user_impact: The user impact of the assessment. Known values are: "Low", "Moderate", and
     "High".
    :vartype user_impact: str or ~azure.mgmt.security.models.UserImpact
    :ivar implementation_effort: The implementation effort required to remediate this assessment.
     Known values are: "Low", "Moderate", and "High".
    :vartype implementation_effort: str or ~azure.mgmt.security.models.ImplementationEffort
    :ivar threats:
    :vartype threats: list[str or ~azure.mgmt.security.models.Threats]
    :ivar preview: True if this assessment is in preview release status.
    :vartype preview: bool
    :ivar assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
     Custom if the assessment based on custom Azure Policy definition. Known values are: "BuiltIn",
     "CustomPolicy", "CustomerManaged", "BuiltInPolicy", "VerifiedPartner", "ManualBuiltInPolicy",
     "ManualBuiltIn", "ManualCustomPolicy", and "DynamicBuiltIn".
    :vartype assessment_type: str or ~azure.mgmt.security.models.AssessmentType
    :ivar partner_data: Describes the partner that created the assessment.
    :vartype partner_data: ~azure.mgmt.security.models.SecurityAssessmentMetadataPartnerData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "policy_definition_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "policy_definition_id": {"key": "properties.policyDefinitionId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_description": {"key": "properties.remediationDescription", "type": "str"},
        "categories": {"key": "properties.categories", "type": "[str]"},
        "severity": {"key": "properties.severity", "type": "str"},
        "user_impact": {"key": "properties.userImpact", "type": "str"},
        "implementation_effort": {"key": "properties.implementationEffort", "type": "str"},
        "threats": {"key": "properties.threats", "type": "[str]"},
        "preview": {"key": "properties.preview", "type": "bool"},
        "assessment_type": {"key": "properties.assessmentType", "type": "str"},
        "partner_data": {"key": "properties.partnerData", "type": "SecurityAssessmentMetadataPartnerData"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        categories: Optional[List[Union[str, "_models.Categories"]]] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        user_impact: Optional[Union[str, "_models.UserImpact"]] = None,
        implementation_effort: Optional[Union[str, "_models.ImplementationEffort"]] = None,
        threats: Optional[List[Union[str, "_models.Threats"]]] = None,
        preview: Optional[bool] = None,
        assessment_type: Optional[Union[str, "_models.AssessmentType"]] = None,
        partner_data: Optional["_models.SecurityAssessmentMetadataPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: User friendly display name of the assessment.
        :paramtype display_name: str
        :keyword description: Human readable description of the assessment.
        :paramtype description: str
        :keyword remediation_description: Human readable description of what you should do to mitigate
         this security issue.
        :paramtype remediation_description: str
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.security.models.Categories]
        :keyword severity: The severity level of the assessment. Known values are: "Low", "Medium", and
         "High".
        :paramtype severity: str or ~azure.mgmt.security.models.Severity
        :keyword user_impact: The user impact of the assessment. Known values are: "Low", "Moderate",
         and "High".
        :paramtype user_impact: str or ~azure.mgmt.security.models.UserImpact
        :keyword implementation_effort: The implementation effort required to remediate this
         assessment. Known values are: "Low", "Moderate", and "High".
        :paramtype implementation_effort: str or ~azure.mgmt.security.models.ImplementationEffort
        :keyword threats:
        :paramtype threats: list[str or ~azure.mgmt.security.models.Threats]
        :keyword preview: True if this assessment is in preview release status.
        :paramtype preview: bool
        :keyword assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
         Custom if the assessment based on custom Azure Policy definition. Known values are: "BuiltIn",
         "CustomPolicy", "CustomerManaged", "BuiltInPolicy", "VerifiedPartner", "ManualBuiltInPolicy",
         "ManualBuiltIn", "ManualCustomPolicy", and "DynamicBuiltIn".
        :paramtype assessment_type: str or ~azure.mgmt.security.models.AssessmentType
        :keyword partner_data: Describes the partner that created the assessment.
        :paramtype partner_data: ~azure.mgmt.security.models.SecurityAssessmentMetadataPartnerData
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.policy_definition_id: Optional[str] = None
        self.description = description
        self.remediation_description = remediation_description
        self.categories = categories
        self.severity = severity
        self.user_impact = user_impact
        self.implementation_effort = implementation_effort
        self.threats = threats
        self.preview = preview
        self.assessment_type = assessment_type
        self.partner_data = partner_data


class SecurityAssessmentMetadataPartnerData(_serialization.Model):
    """Describes the partner that created the assessment.

    All required parameters must be populated in order to send to server.

    :ivar partner_name: Name of the company of the partner. Required.
    :vartype partner_name: str
    :ivar product_name: Name of the product of the partner that created the assessment.
    :vartype product_name: str
    :ivar secret: Secret to authenticate the partner and verify it created the assessment - write
     only. Required.
    :vartype secret: str
    """

    _validation = {
        "partner_name": {"required": True},
        "secret": {"required": True},
    }

    _attribute_map = {
        "partner_name": {"key": "partnerName", "type": "str"},
        "product_name": {"key": "productName", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(self, *, partner_name: str, secret: str, product_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword partner_name: Name of the company of the partner. Required.
        :paramtype partner_name: str
        :keyword product_name: Name of the product of the partner that created the assessment.
        :paramtype product_name: str
        :keyword secret: Secret to authenticate the partner and verify it created the assessment -
         write only. Required.
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.partner_name = partner_name
        self.product_name = product_name
        self.secret = secret


class SecurityAssessmentMetadataProperties(_serialization.Model):
    """Describes properties of an assessment metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: User friendly display name of the assessment. Required.
    :vartype display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition that turns this
     assessment calculation on.
    :vartype policy_definition_id: str
    :ivar description: Human readable description of the assessment.
    :vartype description: str
    :ivar remediation_description: Human readable description of what you should do to mitigate
     this security issue.
    :vartype remediation_description: str
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.security.models.Categories]
    :ivar severity: The severity level of the assessment. Required. Known values are: "Low",
     "Medium", and "High".
    :vartype severity: str or ~azure.mgmt.security.models.Severity
    :ivar user_impact: The user impact of the assessment. Known values are: "Low", "Moderate", and
     "High".
    :vartype user_impact: str or ~azure.mgmt.security.models.UserImpact
    :ivar implementation_effort: The implementation effort required to remediate this assessment.
     Known values are: "Low", "Moderate", and "High".
    :vartype implementation_effort: str or ~azure.mgmt.security.models.ImplementationEffort
    :ivar threats:
    :vartype threats: list[str or ~azure.mgmt.security.models.Threats]
    :ivar preview: True if this assessment is in preview release status.
    :vartype preview: bool
    :ivar assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
     Custom if the assessment based on custom Azure Policy definition. Required. Known values are:
     "BuiltIn", "CustomPolicy", "CustomerManaged", "BuiltInPolicy", "VerifiedPartner",
     "ManualBuiltInPolicy", "ManualBuiltIn", "ManualCustomPolicy", and "DynamicBuiltIn".
    :vartype assessment_type: str or ~azure.mgmt.security.models.AssessmentType
    :ivar partner_data: Describes the partner that created the assessment.
    :vartype partner_data: ~azure.mgmt.security.models.SecurityAssessmentMetadataPartnerData
    """

    _validation = {
        "display_name": {"required": True},
        "policy_definition_id": {"readonly": True},
        "severity": {"required": True},
        "assessment_type": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "remediation_description": {"key": "remediationDescription", "type": "str"},
        "categories": {"key": "categories", "type": "[str]"},
        "severity": {"key": "severity", "type": "str"},
        "user_impact": {"key": "userImpact", "type": "str"},
        "implementation_effort": {"key": "implementationEffort", "type": "str"},
        "threats": {"key": "threats", "type": "[str]"},
        "preview": {"key": "preview", "type": "bool"},
        "assessment_type": {"key": "assessmentType", "type": "str"},
        "partner_data": {"key": "partnerData", "type": "SecurityAssessmentMetadataPartnerData"},
    }

    def __init__(
        self,
        *,
        display_name: str,
        severity: Union[str, "_models.Severity"],
        assessment_type: Union[str, "_models.AssessmentType"],
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        categories: Optional[List[Union[str, "_models.Categories"]]] = None,
        user_impact: Optional[Union[str, "_models.UserImpact"]] = None,
        implementation_effort: Optional[Union[str, "_models.ImplementationEffort"]] = None,
        threats: Optional[List[Union[str, "_models.Threats"]]] = None,
        preview: Optional[bool] = None,
        partner_data: Optional["_models.SecurityAssessmentMetadataPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: User friendly display name of the assessment. Required.
        :paramtype display_name: str
        :keyword description: Human readable description of the assessment.
        :paramtype description: str
        :keyword remediation_description: Human readable description of what you should do to mitigate
         this security issue.
        :paramtype remediation_description: str
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.security.models.Categories]
        :keyword severity: The severity level of the assessment. Required. Known values are: "Low",
         "Medium", and "High".
        :paramtype severity: str or ~azure.mgmt.security.models.Severity
        :keyword user_impact: The user impact of the assessment. Known values are: "Low", "Moderate",
         and "High".
        :paramtype user_impact: str or ~azure.mgmt.security.models.UserImpact
        :keyword implementation_effort: The implementation effort required to remediate this
         assessment. Known values are: "Low", "Moderate", and "High".
        :paramtype implementation_effort: str or ~azure.mgmt.security.models.ImplementationEffort
        :keyword threats:
        :paramtype threats: list[str or ~azure.mgmt.security.models.Threats]
        :keyword preview: True if this assessment is in preview release status.
        :paramtype preview: bool
        :keyword assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
         Custom if the assessment based on custom Azure Policy definition. Required. Known values are:
         "BuiltIn", "CustomPolicy", "CustomerManaged", "BuiltInPolicy", "VerifiedPartner",
         "ManualBuiltInPolicy", "ManualBuiltIn", "ManualCustomPolicy", and "DynamicBuiltIn".
        :paramtype assessment_type: str or ~azure.mgmt.security.models.AssessmentType
        :keyword partner_data: Describes the partner that created the assessment.
        :paramtype partner_data: ~azure.mgmt.security.models.SecurityAssessmentMetadataPartnerData
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.policy_definition_id: Optional[str] = None
        self.description = description
        self.remediation_description = remediation_description
        self.categories = categories
        self.severity = severity
        self.user_impact = user_impact
        self.implementation_effort = implementation_effort
        self.threats = threats
        self.preview = preview
        self.assessment_type = assessment_type
        self.partner_data = partner_data


class SecurityAssessmentMetadataPropertiesResponse(
    SecurityAssessmentMetadataProperties
):  # pylint: disable=name-too-long
    """Describes properties of an assessment metadata response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: User friendly display name of the assessment. Required.
    :vartype display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition that turns this
     assessment calculation on.
    :vartype policy_definition_id: str
    :ivar description: Human readable description of the assessment.
    :vartype description: str
    :ivar remediation_description: Human readable description of what you should do to mitigate
     this security issue.
    :vartype remediation_description: str
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.security.models.Categories]
    :ivar severity: The severity level of the assessment. Required. Known values are: "Low",
     "Medium", and "High".
    :vartype severity: str or ~azure.mgmt.security.models.Severity
    :ivar user_impact: The user impact of the assessment. Known values are: "Low", "Moderate", and
     "High".
    :vartype user_impact: str or ~azure.mgmt.security.models.UserImpact
    :ivar implementation_effort: The implementation effort required to remediate this assessment.
     Known values are: "Low", "Moderate", and "High".
    :vartype implementation_effort: str or ~azure.mgmt.security.models.ImplementationEffort
    :ivar threats:
    :vartype threats: list[str or ~azure.mgmt.security.models.Threats]
    :ivar preview: True if this assessment is in preview release status.
    :vartype preview: bool
    :ivar assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
     Custom if the assessment based on custom Azure Policy definition. Required. Known values are:
     "BuiltIn", "CustomPolicy", "CustomerManaged", "BuiltInPolicy", "VerifiedPartner",
     "ManualBuiltInPolicy", "ManualBuiltIn", "ManualCustomPolicy", and "DynamicBuiltIn".
    :vartype assessment_type: str or ~azure.mgmt.security.models.AssessmentType
    :ivar partner_data: Describes the partner that created the assessment.
    :vartype partner_data: ~azure.mgmt.security.models.SecurityAssessmentMetadataPartnerData
    :ivar publish_dates:
    :vartype publish_dates:
     ~azure.mgmt.security.models.SecurityAssessmentMetadataPropertiesResponsePublishDates
    :ivar planned_deprecation_date:
    :vartype planned_deprecation_date: str
    :ivar tactics:
    :vartype tactics: list[str or ~azure.mgmt.security.models.Tactics]
    :ivar techniques:
    :vartype techniques: list[str or ~azure.mgmt.security.models.Techniques]
    """

    _validation = {
        "display_name": {"required": True},
        "policy_definition_id": {"readonly": True},
        "severity": {"required": True},
        "assessment_type": {"required": True},
        "planned_deprecation_date": {"pattern": r"^[0-9]{2}/[0-9]{4}$"},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "remediation_description": {"key": "remediationDescription", "type": "str"},
        "categories": {"key": "categories", "type": "[str]"},
        "severity": {"key": "severity", "type": "str"},
        "user_impact": {"key": "userImpact", "type": "str"},
        "implementation_effort": {"key": "implementationEffort", "type": "str"},
        "threats": {"key": "threats", "type": "[str]"},
        "preview": {"key": "preview", "type": "bool"},
        "assessment_type": {"key": "assessmentType", "type": "str"},
        "partner_data": {"key": "partnerData", "type": "SecurityAssessmentMetadataPartnerData"},
        "publish_dates": {"key": "publishDates", "type": "SecurityAssessmentMetadataPropertiesResponsePublishDates"},
        "planned_deprecation_date": {"key": "plannedDeprecationDate", "type": "str"},
        "tactics": {"key": "tactics", "type": "[str]"},
        "techniques": {"key": "techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        display_name: str,
        severity: Union[str, "_models.Severity"],
        assessment_type: Union[str, "_models.AssessmentType"],
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        categories: Optional[List[Union[str, "_models.Categories"]]] = None,
        user_impact: Optional[Union[str, "_models.UserImpact"]] = None,
        implementation_effort: Optional[Union[str, "_models.ImplementationEffort"]] = None,
        threats: Optional[List[Union[str, "_models.Threats"]]] = None,
        preview: Optional[bool] = None,
        partner_data: Optional["_models.SecurityAssessmentMetadataPartnerData"] = None,
        publish_dates: Optional["_models.SecurityAssessmentMetadataPropertiesResponsePublishDates"] = None,
        planned_deprecation_date: Optional[str] = None,
        tactics: Optional[List[Union[str, "_models.Tactics"]]] = None,
        techniques: Optional[List[Union[str, "_models.Techniques"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: User friendly display name of the assessment. Required.
        :paramtype display_name: str
        :keyword description: Human readable description of the assessment.
        :paramtype description: str
        :keyword remediation_description: Human readable description of what you should do to mitigate
         this security issue.
        :paramtype remediation_description: str
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.security.models.Categories]
        :keyword severity: The severity level of the assessment. Required. Known values are: "Low",
         "Medium", and "High".
        :paramtype severity: str or ~azure.mgmt.security.models.Severity
        :keyword user_impact: The user impact of the assessment. Known values are: "Low", "Moderate",
         and "High".
        :paramtype user_impact: str or ~azure.mgmt.security.models.UserImpact
        :keyword implementation_effort: The implementation effort required to remediate this
         assessment. Known values are: "Low", "Moderate", and "High".
        :paramtype implementation_effort: str or ~azure.mgmt.security.models.ImplementationEffort
        :keyword threats:
        :paramtype threats: list[str or ~azure.mgmt.security.models.Threats]
        :keyword preview: True if this assessment is in preview release status.
        :paramtype preview: bool
        :keyword assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
         Custom if the assessment based on custom Azure Policy definition. Required. Known values are:
         "BuiltIn", "CustomPolicy", "CustomerManaged", "BuiltInPolicy", "VerifiedPartner",
         "ManualBuiltInPolicy", "ManualBuiltIn", "ManualCustomPolicy", and "DynamicBuiltIn".
        :paramtype assessment_type: str or ~azure.mgmt.security.models.AssessmentType
        :keyword partner_data: Describes the partner that created the assessment.
        :paramtype partner_data: ~azure.mgmt.security.models.SecurityAssessmentMetadataPartnerData
        :keyword publish_dates:
        :paramtype publish_dates:
         ~azure.mgmt.security.models.SecurityAssessmentMetadataPropertiesResponsePublishDates
        :keyword planned_deprecation_date:
        :paramtype planned_deprecation_date: str
        :keyword tactics:
        :paramtype tactics: list[str or ~azure.mgmt.security.models.Tactics]
        :keyword techniques:
        :paramtype techniques: list[str or ~azure.mgmt.security.models.Techniques]
        """
        super().__init__(
            display_name=display_name,
            description=description,
            remediation_description=remediation_description,
            categories=categories,
            severity=severity,
            user_impact=user_impact,
            implementation_effort=implementation_effort,
            threats=threats,
            preview=preview,
            assessment_type=assessment_type,
            partner_data=partner_data,
            **kwargs
        )
        self.publish_dates = publish_dates
        self.planned_deprecation_date = planned_deprecation_date
        self.tactics = tactics
        self.techniques = techniques


class SecurityAssessmentMetadataPropertiesResponsePublishDates(_serialization.Model):  # pylint: disable=name-too-long
    """SecurityAssessmentMetadataPropertiesResponsePublishDates.

    All required parameters must be populated in order to send to server.

    :ivar ga:
    :vartype ga: str
    :ivar public: Required.
    :vartype public: str
    """

    _validation = {
        "ga": {"pattern": r"^([0-9]{2}/){2}[0-9]{4}$"},
        "public": {"required": True, "pattern": r"^([0-9]{2}/){2}[0-9]{4}$"},
    }

    _attribute_map = {
        "ga": {"key": "GA", "type": "str"},
        "public": {"key": "public", "type": "str"},
    }

    def __init__(self, *, public: str, ga: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ga:
        :paramtype ga: str
        :keyword public: Required.
        :paramtype public: str
        """
        super().__init__(**kwargs)
        self.ga = ga
        self.public = public


class SecurityAssessmentMetadataResponse(Resource):
    """Security assessment metadata response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition that turns this
     assessment calculation on.
    :vartype policy_definition_id: str
    :ivar description: Human readable description of the assessment.
    :vartype description: str
    :ivar remediation_description: Human readable description of what you should do to mitigate
     this security issue.
    :vartype remediation_description: str
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.security.models.Categories]
    :ivar severity: The severity level of the assessment. Known values are: "Low", "Medium", and
     "High".
    :vartype severity: str or ~azure.mgmt.security.models.Severity
    :ivar user_impact: The user impact of the assessment. Known values are: "Low", "Moderate", and
     "High".
    :vartype user_impact: str or ~azure.mgmt.security.models.UserImpact
    :ivar implementation_effort: The implementation effort required to remediate this assessment.
     Known values are: "Low", "Moderate", and "High".
    :vartype implementation_effort: str or ~azure.mgmt.security.models.ImplementationEffort
    :ivar threats:
    :vartype threats: list[str or ~azure.mgmt.security.models.Threats]
    :ivar preview: True if this assessment is in preview release status.
    :vartype preview: bool
    :ivar assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
     Custom if the assessment based on custom Azure Policy definition. Known values are: "BuiltIn",
     "CustomPolicy", "CustomerManaged", "BuiltInPolicy", "VerifiedPartner", "ManualBuiltInPolicy",
     "ManualBuiltIn", "ManualCustomPolicy", and "DynamicBuiltIn".
    :vartype assessment_type: str or ~azure.mgmt.security.models.AssessmentType
    :ivar partner_data: Describes the partner that created the assessment.
    :vartype partner_data: ~azure.mgmt.security.models.SecurityAssessmentMetadataPartnerData
    :ivar publish_dates:
    :vartype publish_dates:
     ~azure.mgmt.security.models.SecurityAssessmentMetadataPropertiesResponsePublishDates
    :ivar planned_deprecation_date:
    :vartype planned_deprecation_date: str
    :ivar tactics:
    :vartype tactics: list[str or ~azure.mgmt.security.models.Tactics]
    :ivar techniques:
    :vartype techniques: list[str or ~azure.mgmt.security.models.Techniques]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "policy_definition_id": {"readonly": True},
        "planned_deprecation_date": {"pattern": r"^[0-9]{2}/[0-9]{4}$"},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "policy_definition_id": {"key": "properties.policyDefinitionId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_description": {"key": "properties.remediationDescription", "type": "str"},
        "categories": {"key": "properties.categories", "type": "[str]"},
        "severity": {"key": "properties.severity", "type": "str"},
        "user_impact": {"key": "properties.userImpact", "type": "str"},
        "implementation_effort": {"key": "properties.implementationEffort", "type": "str"},
        "threats": {"key": "properties.threats", "type": "[str]"},
        "preview": {"key": "properties.preview", "type": "bool"},
        "assessment_type": {"key": "properties.assessmentType", "type": "str"},
        "partner_data": {"key": "properties.partnerData", "type": "SecurityAssessmentMetadataPartnerData"},
        "publish_dates": {
            "key": "properties.publishDates",
            "type": "SecurityAssessmentMetadataPropertiesResponsePublishDates",
        },
        "planned_deprecation_date": {"key": "properties.plannedDeprecationDate", "type": "str"},
        "tactics": {"key": "properties.tactics", "type": "[str]"},
        "techniques": {"key": "properties.techniques", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        categories: Optional[List[Union[str, "_models.Categories"]]] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        user_impact: Optional[Union[str, "_models.UserImpact"]] = None,
        implementation_effort: Optional[Union[str, "_models.ImplementationEffort"]] = None,
        threats: Optional[List[Union[str, "_models.Threats"]]] = None,
        preview: Optional[bool] = None,
        assessment_type: Optional[Union[str, "_models.AssessmentType"]] = None,
        partner_data: Optional["_models.SecurityAssessmentMetadataPartnerData"] = None,
        publish_dates: Optional["_models.SecurityAssessmentMetadataPropertiesResponsePublishDates"] = None,
        planned_deprecation_date: Optional[str] = None,
        tactics: Optional[List[Union[str, "_models.Tactics"]]] = None,
        techniques: Optional[List[Union[str, "_models.Techniques"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: User friendly display name of the assessment.
        :paramtype display_name: str
        :keyword description: Human readable description of the assessment.
        :paramtype description: str
        :keyword remediation_description: Human readable description of what you should do to mitigate
         this security issue.
        :paramtype remediation_description: str
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.security.models.Categories]
        :keyword severity: The severity level of the assessment. Known values are: "Low", "Medium", and
         "High".
        :paramtype severity: str or ~azure.mgmt.security.models.Severity
        :keyword user_impact: The user impact of the assessment. Known values are: "Low", "Moderate",
         and "High".
        :paramtype user_impact: str or ~azure.mgmt.security.models.UserImpact
        :keyword implementation_effort: The implementation effort required to remediate this
         assessment. Known values are: "Low", "Moderate", and "High".
        :paramtype implementation_effort: str or ~azure.mgmt.security.models.ImplementationEffort
        :keyword threats:
        :paramtype threats: list[str or ~azure.mgmt.security.models.Threats]
        :keyword preview: True if this assessment is in preview release status.
        :paramtype preview: bool
        :keyword assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
         Custom if the assessment based on custom Azure Policy definition. Known values are: "BuiltIn",
         "CustomPolicy", "CustomerManaged", "BuiltInPolicy", "VerifiedPartner", "ManualBuiltInPolicy",
         "ManualBuiltIn", "ManualCustomPolicy", and "DynamicBuiltIn".
        :paramtype assessment_type: str or ~azure.mgmt.security.models.AssessmentType
        :keyword partner_data: Describes the partner that created the assessment.
        :paramtype partner_data: ~azure.mgmt.security.models.SecurityAssessmentMetadataPartnerData
        :keyword publish_dates:
        :paramtype publish_dates:
         ~azure.mgmt.security.models.SecurityAssessmentMetadataPropertiesResponsePublishDates
        :keyword planned_deprecation_date:
        :paramtype planned_deprecation_date: str
        :keyword tactics:
        :paramtype tactics: list[str or ~azure.mgmt.security.models.Tactics]
        :keyword techniques:
        :paramtype techniques: list[str or ~azure.mgmt.security.models.Techniques]
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.policy_definition_id: Optional[str] = None
        self.description = description
        self.remediation_description = remediation_description
        self.categories = categories
        self.severity = severity
        self.user_impact = user_impact
        self.implementation_effort = implementation_effort
        self.threats = threats
        self.preview = preview
        self.assessment_type = assessment_type
        self.partner_data = partner_data
        self.publish_dates = publish_dates
        self.planned_deprecation_date = planned_deprecation_date
        self.tactics = tactics
        self.techniques = techniques


class SecurityAssessmentMetadataResponseList(_serialization.Model):
    """List of security assessment metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.SecurityAssessmentMetadataResponse]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityAssessmentMetadataResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SecurityAssessmentMetadataResponse"]] = None
        self.next_link: Optional[str] = None


class SecurityAssessmentPartnerData(_serialization.Model):
    """Data regarding 3rd party partner integration.

    All required parameters must be populated in order to send to server.

    :ivar partner_name: Name of the company of the partner. Required.
    :vartype partner_name: str
    :ivar secret: secret to authenticate the partner - write only. Required.
    :vartype secret: str
    """

    _validation = {
        "partner_name": {"required": True},
        "secret": {"required": True},
    }

    _attribute_map = {
        "partner_name": {"key": "partnerName", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(self, *, partner_name: str, secret: str, **kwargs: Any) -> None:
        """
        :keyword partner_name: Name of the company of the partner. Required.
        :paramtype partner_name: str
        :keyword secret: secret to authenticate the partner - write only. Required.
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.partner_name = partner_name
        self.secret = secret


class SecurityAssessmentPropertiesBase(_serialization.Model):
    """Describes properties of an assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar risk: External model of risk result.
    :vartype risk: ~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRisk
    :ivar resource_details: Details of the resource that was assessed. Required.
    :vartype resource_details: ~azure.mgmt.security.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.models.SecurityAssessmentPartnerData
    """

    _validation = {
        "resource_details": {"required": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
    }

    _attribute_map = {
        "risk": {"key": "risk", "type": "SecurityAssessmentPropertiesBaseRisk"},
        "resource_details": {"key": "resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "displayName", "type": "str"},
        "additional_data": {"key": "additionalData", "type": "{str}"},
        "links": {"key": "links", "type": "AssessmentLinks"},
        "metadata": {"key": "metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "partnersData", "type": "SecurityAssessmentPartnerData"},
    }

    def __init__(
        self,
        *,
        resource_details: "_models.ResourceDetails",
        risk: Optional["_models.SecurityAssessmentPropertiesBaseRisk"] = None,
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword risk: External model of risk result.
        :paramtype risk: ~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRisk
        :keyword resource_details: Details of the resource that was assessed. Required.
        :paramtype resource_details: ~azure.mgmt.security.models.ResourceDetails
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata: ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.models.SecurityAssessmentPartnerData
        """
        super().__init__(**kwargs)
        self.risk = risk
        self.resource_details = resource_details
        self.display_name: Optional[str] = None
        self.additional_data = additional_data
        self.links: Optional["_models.AssessmentLinks"] = None
        self.metadata = metadata
        self.partners_data = partners_data


class SecurityAssessmentProperties(SecurityAssessmentPropertiesBase):
    """Describes properties of an assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar risk: External model of risk result.
    :vartype risk: ~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRisk
    :ivar resource_details: Details of the resource that was assessed. Required.
    :vartype resource_details: ~azure.mgmt.security.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.models.SecurityAssessmentPartnerData
    :ivar status: The result of the assessment. Required.
    :vartype status: ~azure.mgmt.security.models.AssessmentStatus
    """

    _validation = {
        "resource_details": {"required": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
        "status": {"required": True},
    }

    _attribute_map = {
        "risk": {"key": "risk", "type": "SecurityAssessmentPropertiesBaseRisk"},
        "resource_details": {"key": "resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "displayName", "type": "str"},
        "additional_data": {"key": "additionalData", "type": "{str}"},
        "links": {"key": "links", "type": "AssessmentLinks"},
        "metadata": {"key": "metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "partnersData", "type": "SecurityAssessmentPartnerData"},
        "status": {"key": "status", "type": "AssessmentStatus"},
    }

    def __init__(
        self,
        *,
        resource_details: "_models.ResourceDetails",
        status: "_models.AssessmentStatus",
        risk: Optional["_models.SecurityAssessmentPropertiesBaseRisk"] = None,
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword risk: External model of risk result.
        :paramtype risk: ~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRisk
        :keyword resource_details: Details of the resource that was assessed. Required.
        :paramtype resource_details: ~azure.mgmt.security.models.ResourceDetails
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata: ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.models.SecurityAssessmentPartnerData
        :keyword status: The result of the assessment. Required.
        :paramtype status: ~azure.mgmt.security.models.AssessmentStatus
        """
        super().__init__(
            risk=risk,
            resource_details=resource_details,
            additional_data=additional_data,
            metadata=metadata,
            partners_data=partners_data,
            **kwargs
        )
        self.status = status


class SecurityAssessmentPropertiesBaseRisk(_serialization.Model):
    """External model of risk result.

    :ivar risk_factors: The factors of the risk adding base factor.
    :vartype risk_factors: list[str]
    :ivar level: The risk level. Known values are: "Low", "Medium", and "High".
    :vartype level: str or ~azure.mgmt.security.models.RiskLevel
    :ivar attack_paths_references: The attack paths references of the risk.
    :vartype attack_paths_references: list[str]
    :ivar paths:
    :vartype paths: list[~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRiskPathsItem]
    :ivar is_contextual_risk: Indicates if the risk is contextual or static.
    :vartype is_contextual_risk: bool
    """

    _validation = {
        "risk_factors": {"unique": True},
    }

    _attribute_map = {
        "risk_factors": {"key": "riskFactors", "type": "[str]"},
        "level": {"key": "level", "type": "str"},
        "attack_paths_references": {"key": "attackPathsReferences", "type": "[str]"},
        "paths": {"key": "paths", "type": "[SecurityAssessmentPropertiesBaseRiskPathsItem]"},
        "is_contextual_risk": {"key": "isContextualRisk", "type": "bool"},
    }

    def __init__(
        self,
        *,
        risk_factors: Optional[List[str]] = None,
        level: Optional[Union[str, "_models.RiskLevel"]] = None,
        attack_paths_references: Optional[List[str]] = None,
        paths: Optional[List["_models.SecurityAssessmentPropertiesBaseRiskPathsItem"]] = None,
        is_contextual_risk: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword risk_factors: The factors of the risk adding base factor.
        :paramtype risk_factors: list[str]
        :keyword level: The risk level. Known values are: "Low", "Medium", and "High".
        :paramtype level: str or ~azure.mgmt.security.models.RiskLevel
        :keyword attack_paths_references: The attack paths references of the risk.
        :paramtype attack_paths_references: list[str]
        :keyword paths:
        :paramtype paths:
         list[~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRiskPathsItem]
        :keyword is_contextual_risk: Indicates if the risk is contextual or static.
        :paramtype is_contextual_risk: bool
        """
        super().__init__(**kwargs)
        self.risk_factors = risk_factors
        self.level = level
        self.attack_paths_references = attack_paths_references
        self.paths = paths
        self.is_contextual_risk = is_contextual_risk


class SecurityAssessmentPropertiesBaseRiskPathsItem(_serialization.Model):  # pylint: disable=name-too-long
    """SecurityAssessmentPropertiesBaseRiskPathsItem.

    :ivar id: Unique identifier for the path.
    :vartype id: str
    :ivar nodes:
    :vartype nodes:
     list[~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRiskPathsPropertiesItemsItem]
    :ivar edges: Connections between nodes.
    :vartype edges:
     list[~azure.mgmt.security.models.Components1Uu4J47SchemasSecurityassessmentpropertiesbasePropertiesRiskPropertiesPathsItemsPropertiesEdgesItems]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "nodes": {"key": "nodes", "type": "[SecurityAssessmentPropertiesBaseRiskPathsPropertiesItemsItem]"},
        "edges": {
            "key": "edges",
            "type": "[Components1Uu4J47SchemasSecurityassessmentpropertiesbasePropertiesRiskPropertiesPathsItemsPropertiesEdgesItems]",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        nodes: Optional[List["_models.SecurityAssessmentPropertiesBaseRiskPathsPropertiesItemsItem"]] = None,
        edges: Optional[
            List[
                "_models.Components1Uu4J47SchemasSecurityassessmentpropertiesbasePropertiesRiskPropertiesPathsItemsPropertiesEdgesItems"
            ]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Unique identifier for the path.
        :paramtype id: str
        :keyword nodes:
        :paramtype nodes:
         list[~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRiskPathsPropertiesItemsItem]
        :keyword edges: Connections between nodes.
        :paramtype edges:
         list[~azure.mgmt.security.models.Components1Uu4J47SchemasSecurityassessmentpropertiesbasePropertiesRiskPropertiesPathsItemsPropertiesEdgesItems]
        """
        super().__init__(**kwargs)
        self.id = id
        self.nodes = nodes
        self.edges = edges


class SecurityAssessmentPropertiesBaseRiskPathsPropertiesItemsItem(
    _serialization.Model
):  # pylint: disable=name-too-long
    """SecurityAssessmentPropertiesBaseRiskPathsPropertiesItemsItem.

    :ivar id: Node identifier.
    :vartype id: str
    :ivar node_properties_label: Properties associated with the node.
    :vartype node_properties_label: list[str]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "node_properties_label": {"key": "nodePropertiesLabel", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        node_properties_label: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Node identifier.
        :paramtype id: str
        :keyword node_properties_label: Properties associated with the node.
        :paramtype node_properties_label: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.node_properties_label = node_properties_label


class SecurityAssessmentPropertiesResponse(SecurityAssessmentPropertiesBase):
    """Describes properties of an assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar risk: External model of risk result.
    :vartype risk: ~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRisk
    :ivar resource_details: Details of the resource that was assessed. Required.
    :vartype resource_details: ~azure.mgmt.security.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.models.SecurityAssessmentPartnerData
    :ivar status: The result of the assessment. Required.
    :vartype status: ~azure.mgmt.security.models.AssessmentStatusResponse
    """

    _validation = {
        "resource_details": {"required": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
        "status": {"required": True},
    }

    _attribute_map = {
        "risk": {"key": "risk", "type": "SecurityAssessmentPropertiesBaseRisk"},
        "resource_details": {"key": "resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "displayName", "type": "str"},
        "additional_data": {"key": "additionalData", "type": "{str}"},
        "links": {"key": "links", "type": "AssessmentLinks"},
        "metadata": {"key": "metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "partnersData", "type": "SecurityAssessmentPartnerData"},
        "status": {"key": "status", "type": "AssessmentStatusResponse"},
    }

    def __init__(
        self,
        *,
        resource_details: "_models.ResourceDetails",
        status: "_models.AssessmentStatusResponse",
        risk: Optional["_models.SecurityAssessmentPropertiesBaseRisk"] = None,
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword risk: External model of risk result.
        :paramtype risk: ~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRisk
        :keyword resource_details: Details of the resource that was assessed. Required.
        :paramtype resource_details: ~azure.mgmt.security.models.ResourceDetails
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata: ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.models.SecurityAssessmentPartnerData
        :keyword status: The result of the assessment. Required.
        :paramtype status: ~azure.mgmt.security.models.AssessmentStatusResponse
        """
        super().__init__(
            risk=risk,
            resource_details=resource_details,
            additional_data=additional_data,
            metadata=metadata,
            partners_data=partners_data,
            **kwargs
        )
        self.status = status


class SecurityAssessmentResponse(Resource):
    """Security assessment on a resource - response format.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar risk: External model of risk result.
    :vartype risk: ~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRisk
    :ivar resource_details: Details of the resource that was assessed.
    :vartype resource_details: ~azure.mgmt.security.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.models.SecurityAssessmentPartnerData
    :ivar status: The result of the assessment.
    :vartype status: ~azure.mgmt.security.models.AssessmentStatusResponse
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "risk": {"key": "properties.risk", "type": "SecurityAssessmentPropertiesBaseRisk"},
        "resource_details": {"key": "properties.resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "additional_data": {"key": "properties.additionalData", "type": "{str}"},
        "links": {"key": "properties.links", "type": "AssessmentLinks"},
        "metadata": {"key": "properties.metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "properties.partnersData", "type": "SecurityAssessmentPartnerData"},
        "status": {"key": "properties.status", "type": "AssessmentStatusResponse"},
    }

    def __init__(
        self,
        *,
        risk: Optional["_models.SecurityAssessmentPropertiesBaseRisk"] = None,
        resource_details: Optional["_models.ResourceDetails"] = None,
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        status: Optional["_models.AssessmentStatusResponse"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword risk: External model of risk result.
        :paramtype risk: ~azure.mgmt.security.models.SecurityAssessmentPropertiesBaseRisk
        :keyword resource_details: Details of the resource that was assessed.
        :paramtype resource_details: ~azure.mgmt.security.models.ResourceDetails
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata: ~azure.mgmt.security.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.models.SecurityAssessmentPartnerData
        :keyword status: The result of the assessment.
        :paramtype status: ~azure.mgmt.security.models.AssessmentStatusResponse
        """
        super().__init__(**kwargs)
        self.risk = risk
        self.resource_details = resource_details
        self.display_name: Optional[str] = None
        self.additional_data = additional_data
        self.links: Optional["_models.AssessmentLinks"] = None
        self.metadata = metadata
        self.partners_data = partners_data
        self.status = status


class SecurityConnector(TrackedResource):
    """The security connector resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.models.SystemData
    :ivar hierarchy_identifier: The multi cloud resource identifier (account id in case of AWS
     connector, project number in case of GCP connector).
    :vartype hierarchy_identifier: str
    :ivar hierarchy_identifier_trial_end_date: The date on which the trial period will end, if
     applicable. Trial period exists for 30 days after upgrading to payed offerings.
    :vartype hierarchy_identifier_trial_end_date: ~datetime.datetime
    :ivar environment_name: The multi cloud resource's cloud name. Known values are: "Azure",
     "AWS", "GCP", "Github", "AzureDevOps", "GitLab", "DockerHub", and "JFrog".
    :vartype environment_name: str or ~azure.mgmt.security.models.CloudName
    :ivar offerings: A collection of offerings for the security connector.
    :vartype offerings: list[~azure.mgmt.security.models.CloudOffering]
    :ivar environment_data: The security connector environment data.
    :vartype environment_data: ~azure.mgmt.security.models.EnvironmentData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "hierarchy_identifier_trial_end_date": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "hierarchy_identifier": {"key": "properties.hierarchyIdentifier", "type": "str"},
        "hierarchy_identifier_trial_end_date": {
            "key": "properties.hierarchyIdentifierTrialEndDate",
            "type": "iso-8601",
        },
        "environment_name": {"key": "properties.environmentName", "type": "str"},
        "offerings": {"key": "properties.offerings", "type": "[CloudOffering]"},
        "environment_data": {"key": "properties.environmentData", "type": "EnvironmentData"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        hierarchy_identifier: Optional[str] = None,
        environment_name: Optional[Union[str, "_models.CloudName"]] = None,
        offerings: Optional[List["_models.CloudOffering"]] = None,
        environment_data: Optional["_models.EnvironmentData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        :keyword hierarchy_identifier: The multi cloud resource identifier (account id in case of AWS
         connector, project number in case of GCP connector).
        :paramtype hierarchy_identifier: str
        :keyword environment_name: The multi cloud resource's cloud name. Known values are: "Azure",
         "AWS", "GCP", "Github", "AzureDevOps", "GitLab", "DockerHub", and "JFrog".
        :paramtype environment_name: str or ~azure.mgmt.security.models.CloudName
        :keyword offerings: A collection of offerings for the security connector.
        :paramtype offerings: list[~azure.mgmt.security.models.CloudOffering]
        :keyword environment_data: The security connector environment data.
        :paramtype environment_data: ~azure.mgmt.security.models.EnvironmentData
        """
        super().__init__(tags=tags, etag=etag, kind=kind, location=location, **kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.hierarchy_identifier = hierarchy_identifier
        self.hierarchy_identifier_trial_end_date: Optional[datetime.datetime] = None
        self.environment_name = environment_name
        self.offerings = offerings
        self.environment_data = environment_data


class SecurityConnectorsList(_serialization.Model):
    """List of security connectors response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of security connectors under the given scope. Required.
    :vartype value: list[~azure.mgmt.security.models.SecurityConnector]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityConnector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SecurityConnector"], **kwargs: Any) -> None:
        """
        :keyword value: The list of security connectors under the given scope. Required.
        :paramtype value: list[~azure.mgmt.security.models.SecurityConnector]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class SecurityContact(Resource):
    """Contact details and configurations for notifications coming from Microsoft Defender for Cloud.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar emails: List of email addresses which will get notifications from Microsoft Defender for
     Cloud by the configurations defined in this security contact.
    :vartype emails: str
    :ivar phone: The security contact's phone number.
    :vartype phone: str
    :ivar is_enabled: Indicates whether the security contact is enabled.
    :vartype is_enabled: bool
    :ivar notifications_sources: A collection of sources types which evaluate the email
     notification.
    :vartype notifications_sources: list[~azure.mgmt.security.models.NotificationsSource]
    :ivar notifications_by_role: Defines whether to send email notifications from Microsoft
     Defender for Cloud to persons with specific RBAC roles on the subscription.
    :vartype notifications_by_role:
     ~azure.mgmt.security.models.SecurityContactPropertiesNotificationsByRole
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "emails": {"key": "properties.emails", "type": "str"},
        "phone": {"key": "properties.phone", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "notifications_sources": {"key": "properties.notificationsSources", "type": "[NotificationsSource]"},
        "notifications_by_role": {
            "key": "properties.notificationsByRole",
            "type": "SecurityContactPropertiesNotificationsByRole",
        },
    }

    def __init__(
        self,
        *,
        emails: Optional[str] = None,
        phone: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        notifications_sources: Optional[List["_models.NotificationsSource"]] = None,
        notifications_by_role: Optional["_models.SecurityContactPropertiesNotificationsByRole"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword emails: List of email addresses which will get notifications from Microsoft Defender
         for Cloud by the configurations defined in this security contact.
        :paramtype emails: str
        :keyword phone: The security contact's phone number.
        :paramtype phone: str
        :keyword is_enabled: Indicates whether the security contact is enabled.
        :paramtype is_enabled: bool
        :keyword notifications_sources: A collection of sources types which evaluate the email
         notification.
        :paramtype notifications_sources: list[~azure.mgmt.security.models.NotificationsSource]
        :keyword notifications_by_role: Defines whether to send email notifications from Microsoft
         Defender for Cloud to persons with specific RBAC roles on the subscription.
        :paramtype notifications_by_role:
         ~azure.mgmt.security.models.SecurityContactPropertiesNotificationsByRole
        """
        super().__init__(**kwargs)
        self.emails = emails
        self.phone = phone
        self.is_enabled = is_enabled
        self.notifications_sources = notifications_sources
        self.notifications_by_role = notifications_by_role


class SecurityContactList(_serialization.Model):
    """List of security contacts response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: List of security contacts. Required.
    :vartype value: list[~azure.mgmt.security.models.SecurityContact]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityContact]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SecurityContact"], **kwargs: Any) -> None:
        """
        :keyword value: List of security contacts. Required.
        :paramtype value: list[~azure.mgmt.security.models.SecurityContact]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class SecurityContactPropertiesNotificationsByRole(_serialization.Model):  # pylint: disable=name-too-long
    """Defines whether to send email notifications from Microsoft Defender for Cloud to persons with
    specific RBAC roles on the subscription.

    :ivar state: Defines whether to send email notifications from AMicrosoft Defender for Cloud to
     persons with specific RBAC roles on the subscription. Known values are: "Passed", "Failed",
     "Skipped", and "Unsupported".
    :vartype state: str or ~azure.mgmt.security.models.State
    :ivar roles: Defines which RBAC roles will get email notifications from Microsoft Defender for
     Cloud. List of allowed RBAC roles:.
    :vartype roles: list[str or ~azure.mgmt.security.models.SecurityContactRole]
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "roles": {"key": "roles", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.State"]] = None,
        roles: Optional[List[Union[str, "_models.SecurityContactRole"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Defines whether to send email notifications from AMicrosoft Defender for Cloud
         to persons with specific RBAC roles on the subscription. Known values are: "Passed", "Failed",
         "Skipped", and "Unsupported".
        :paramtype state: str or ~azure.mgmt.security.models.State
        :keyword roles: Defines which RBAC roles will get email notifications from Microsoft Defender
         for Cloud. List of allowed RBAC roles:.
        :paramtype roles: list[str or ~azure.mgmt.security.models.SecurityContactRole]
        """
        super().__init__(**kwargs)
        self.state = state
        self.roles = roles


class SecurityOperator(Resource):
    """Security operator under a given subscription and pricing.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.security.models.Identity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
    }

    def __init__(self, *, identity: Optional["_models.Identity"] = None, **kwargs: Any) -> None:
        """
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.security.models.Identity
        """
        super().__init__(**kwargs)
        self.identity = identity


class SecurityOperatorList(_serialization.Model):
    """List of SecurityOperator response.

    All required parameters must be populated in order to send to server.

    :ivar value: List of SecurityOperator configurations. Required.
    :vartype value: list[~azure.mgmt.security.models.SecurityOperator]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityOperator]"},
    }

    def __init__(self, *, value: List["_models.SecurityOperator"], **kwargs: Any) -> None:
        """
        :keyword value: List of SecurityOperator configurations. Required.
        :paramtype value: list[~azure.mgmt.security.models.SecurityOperator]
        """
        super().__init__(**kwargs)
        self.value = value


class SecuritySolution(Resource, Location):
    """SecuritySolution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar security_family: The security family of the security solution. Known values are: "Waf",
     "Ngfw", "SaasWaf", and "Va".
    :vartype security_family: str or ~azure.mgmt.security.models.SecurityFamily
    :ivar provisioning_state: The security family provisioning State. Known values are:
     "Succeeded", "Failed", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.security.models.ProvisioningState
    :ivar template: The security solutions' template.
    :vartype template: str
    :ivar protection_status: The security solutions' status.
    :vartype protection_status: str
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "security_family": {"key": "properties.securityFamily", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "template": {"key": "properties.template", "type": "str"},
        "protection_status": {"key": "properties.protectionStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        security_family: Optional[Union[str, "_models.SecurityFamily"]] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        template: Optional[str] = None,
        protection_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword security_family: The security family of the security solution. Known values are:
         "Waf", "Ngfw", "SaasWaf", and "Va".
        :paramtype security_family: str or ~azure.mgmt.security.models.SecurityFamily
        :keyword provisioning_state: The security family provisioning State. Known values are:
         "Succeeded", "Failed", and "Updating".
        :paramtype provisioning_state: str or ~azure.mgmt.security.models.ProvisioningState
        :keyword template: The security solutions' template.
        :paramtype template: str
        :keyword protection_status: The security solutions' status.
        :paramtype protection_status: str
        """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.security_family = security_family
        self.provisioning_state = provisioning_state
        self.template = template
        self.protection_status = protection_status
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class SecuritySolutionList(_serialization.Model):
    """SecuritySolutionList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.SecuritySolution]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecuritySolution]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.SecuritySolution"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.models.SecuritySolution]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class SecuritySolutionsReferenceData(Resource, Location):
    """SecuritySolutionsReferenceData.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar security_family: The security family of the security solution. Required. Known values
     are: "Waf", "Ngfw", "SaasWaf", and "Va".
    :vartype security_family: str or ~azure.mgmt.security.models.SecurityFamily
    :ivar alert_vendor_name: The security solutions' vendor name. Required.
    :vartype alert_vendor_name: str
    :ivar package_info_url: The security solutions' package info url. Required.
    :vartype package_info_url: str
    :ivar product_name: The security solutions' product name. Required.
    :vartype product_name: str
    :ivar publisher: The security solutions' publisher. Required.
    :vartype publisher: str
    :ivar publisher_display_name: The security solutions' publisher display name. Required.
    :vartype publisher_display_name: str
    :ivar template: The security solutions' template. Required.
    :vartype template: str
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "security_family": {"required": True},
        "alert_vendor_name": {"required": True},
        "package_info_url": {"required": True},
        "product_name": {"required": True},
        "publisher": {"required": True},
        "publisher_display_name": {"required": True},
        "template": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "security_family": {"key": "properties.securityFamily", "type": "str"},
        "alert_vendor_name": {"key": "properties.alertVendorName", "type": "str"},
        "package_info_url": {"key": "properties.packageInfoUrl", "type": "str"},
        "product_name": {"key": "properties.productName", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "publisher_display_name": {"key": "properties.publisherDisplayName", "type": "str"},
        "template": {"key": "properties.template", "type": "str"},
    }

    def __init__(
        self,
        *,
        security_family: Union[str, "_models.SecurityFamily"],
        alert_vendor_name: str,
        package_info_url: str,
        product_name: str,
        publisher: str,
        publisher_display_name: str,
        template: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword security_family: The security family of the security solution. Required. Known values
         are: "Waf", "Ngfw", "SaasWaf", and "Va".
        :paramtype security_family: str or ~azure.mgmt.security.models.SecurityFamily
        :keyword alert_vendor_name: The security solutions' vendor name. Required.
        :paramtype alert_vendor_name: str
        :keyword package_info_url: The security solutions' package info url. Required.
        :paramtype package_info_url: str
        :keyword product_name: The security solutions' product name. Required.
        :paramtype product_name: str
        :keyword publisher: The security solutions' publisher. Required.
        :paramtype publisher: str
        :keyword publisher_display_name: The security solutions' publisher display name. Required.
        :paramtype publisher_display_name: str
        :keyword template: The security solutions' template. Required.
        :paramtype template: str
        """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.security_family = security_family
        self.alert_vendor_name = alert_vendor_name
        self.package_info_url = package_info_url
        self.product_name = product_name
        self.publisher = publisher
        self.publisher_display_name = publisher_display_name
        self.template = template
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class SecuritySolutionsReferenceDataList(_serialization.Model):
    """SecuritySolutionsReferenceDataList.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.SecuritySolutionsReferenceData]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SecuritySolutionsReferenceData]"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SecuritySolutionsReferenceData"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.models.SecuritySolutionsReferenceData]
        """
        super().__init__(**kwargs)
        self.value = value


class SecurityStandard(Resource):
    """Security Standard on a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Display name of the standard, equivalent to the standardId.
    :vartype display_name: str
    :ivar standard_type: Standard type (Custom or Default or Compliance only currently). Known
     values are: "Custom", "Default", and "Compliance".
    :vartype standard_type: str or ~azure.mgmt.security.models.StandardType
    :ivar description: Description of the standard.
    :vartype description: str
    :ivar assessments: List of assessment keys to apply to standard scope.
    :vartype assessments: list[~azure.mgmt.security.models.PartialAssessmentProperties]
    :ivar cloud_providers: List of all standard supported clouds.
    :vartype cloud_providers: list[str or ~azure.mgmt.security.models.StandardSupportedCloud]
    :ivar policy_set_definition_id: The policy set definition id associated with the standard.
    :vartype policy_set_definition_id: str
    :ivar metadata: The security standard metadata.
    :vartype metadata: ~azure.mgmt.security.models.StandardMetadata
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "standard_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "standard_type": {"key": "properties.standardType", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "assessments": {"key": "properties.assessments", "type": "[PartialAssessmentProperties]"},
        "cloud_providers": {"key": "properties.cloudProviders", "type": "[str]"},
        "policy_set_definition_id": {"key": "properties.policySetDefinitionId", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "StandardMetadata"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        assessments: Optional[List["_models.PartialAssessmentProperties"]] = None,
        cloud_providers: Optional[List[Union[str, "_models.StandardSupportedCloud"]]] = None,
        policy_set_definition_id: Optional[str] = None,
        metadata: Optional["_models.StandardMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the standard, equivalent to the standardId.
        :paramtype display_name: str
        :keyword description: Description of the standard.
        :paramtype description: str
        :keyword assessments: List of assessment keys to apply to standard scope.
        :paramtype assessments: list[~azure.mgmt.security.models.PartialAssessmentProperties]
        :keyword cloud_providers: List of all standard supported clouds.
        :paramtype cloud_providers: list[str or ~azure.mgmt.security.models.StandardSupportedCloud]
        :keyword policy_set_definition_id: The policy set definition id associated with the standard.
        :paramtype policy_set_definition_id: str
        :keyword metadata: The security standard metadata.
        :paramtype metadata: ~azure.mgmt.security.models.StandardMetadata
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.standard_type: Optional[Union[str, "_models.StandardType"]] = None
        self.description = description
        self.assessments = assessments
        self.cloud_providers = cloud_providers
        self.policy_set_definition_id = policy_set_definition_id
        self.metadata = metadata


class SecurityStandardList(_serialization.Model):
    """Page of a Standard list.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of standards in this page. Required.
    :vartype value: list[~azure.mgmt.security.models.SecurityStandard]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityStandard]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SecurityStandard"]] = None
        self.next_link: Optional[str] = None


class SecuritySubAssessment(Resource):
    """Security sub-assessment on a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar id_properties_id: Vulnerability ID.
    :vartype id_properties_id: str
    :ivar display_name: User friendly display name of the sub-assessment.
    :vartype display_name: str
    :ivar status: Status of the sub-assessment.
    :vartype status: ~azure.mgmt.security.models.SubAssessmentStatus
    :ivar remediation: Information on how to remediate this sub-assessment.
    :vartype remediation: str
    :ivar impact: Description of the impact of this sub-assessment.
    :vartype impact: str
    :ivar category: Category of the sub-assessment.
    :vartype category: str
    :ivar description: Human readable description of the assessment status.
    :vartype description: str
    :ivar time_generated: The date and time the sub-assessment was generated.
    :vartype time_generated: ~datetime.datetime
    :ivar resource_details: Details of the resource that was assessed.
    :vartype resource_details: ~azure.mgmt.security.models.ResourceDetails
    :ivar additional_data: Details of the sub-assessment.
    :vartype additional_data: ~azure.mgmt.security.models.AdditionalData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "id_properties_id": {"readonly": True},
        "display_name": {"readonly": True},
        "remediation": {"readonly": True},
        "impact": {"readonly": True},
        "category": {"readonly": True},
        "description": {"readonly": True},
        "time_generated": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "id_properties_id": {"key": "properties.id", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "status": {"key": "properties.status", "type": "SubAssessmentStatus"},
        "remediation": {"key": "properties.remediation", "type": "str"},
        "impact": {"key": "properties.impact", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "time_generated": {"key": "properties.timeGenerated", "type": "iso-8601"},
        "resource_details": {"key": "properties.resourceDetails", "type": "ResourceDetails"},
        "additional_data": {"key": "properties.additionalData", "type": "AdditionalData"},
    }

    def __init__(
        self,
        *,
        status: Optional["_models.SubAssessmentStatus"] = None,
        resource_details: Optional["_models.ResourceDetails"] = None,
        additional_data: Optional["_models.AdditionalData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the sub-assessment.
        :paramtype status: ~azure.mgmt.security.models.SubAssessmentStatus
        :keyword resource_details: Details of the resource that was assessed.
        :paramtype resource_details: ~azure.mgmt.security.models.ResourceDetails
        :keyword additional_data: Details of the sub-assessment.
        :paramtype additional_data: ~azure.mgmt.security.models.AdditionalData
        """
        super().__init__(**kwargs)
        self.id_properties_id: Optional[str] = None
        self.display_name: Optional[str] = None
        self.status = status
        self.remediation: Optional[str] = None
        self.impact: Optional[str] = None
        self.category: Optional[str] = None
        self.description: Optional[str] = None
        self.time_generated: Optional[datetime.datetime] = None
        self.resource_details = resource_details
        self.additional_data = additional_data


class SecuritySubAssessmentList(_serialization.Model):
    """List of security sub-assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.SecuritySubAssessment]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecuritySubAssessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SecuritySubAssessment"]] = None
        self.next_link: Optional[str] = None


class SecurityTask(Resource):
    """Security task that we recommend to do in order to strengthen security.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: State of the task (Active, Resolved etc.).
    :vartype state: str
    :ivar creation_time_utc: The time this task was discovered in UTC.
    :vartype creation_time_utc: ~datetime.datetime
    :ivar security_task_parameters: Changing set of properties, depending on the task type that is
     derived from the name field.
    :vartype security_task_parameters: ~azure.mgmt.security.models.SecurityTaskParameters
    :ivar last_state_change_time_utc: The time this task's details were last changed in UTC.
    :vartype last_state_change_time_utc: ~datetime.datetime
    :ivar sub_state: Additional data on the state of the task.
    :vartype sub_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
        "creation_time_utc": {"readonly": True},
        "last_state_change_time_utc": {"readonly": True},
        "sub_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "creation_time_utc": {"key": "properties.creationTimeUtc", "type": "iso-8601"},
        "security_task_parameters": {"key": "properties.securityTaskParameters", "type": "SecurityTaskParameters"},
        "last_state_change_time_utc": {"key": "properties.lastStateChangeTimeUtc", "type": "iso-8601"},
        "sub_state": {"key": "properties.subState", "type": "str"},
    }

    def __init__(
        self, *, security_task_parameters: Optional["_models.SecurityTaskParameters"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword security_task_parameters: Changing set of properties, depending on the task type that
         is derived from the name field.
        :paramtype security_task_parameters: ~azure.mgmt.security.models.SecurityTaskParameters
        """
        super().__init__(**kwargs)
        self.state: Optional[str] = None
        self.creation_time_utc: Optional[datetime.datetime] = None
        self.security_task_parameters = security_task_parameters
        self.last_state_change_time_utc: Optional[datetime.datetime] = None
        self.sub_state: Optional[str] = None


class SecurityTaskList(_serialization.Model):
    """List of security task recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.SecurityTask]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityTask]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SecurityTask"]] = None
        self.next_link: Optional[str] = None


class SecurityTaskParameters(_serialization.Model):
    """Changing set of properties, depending on the task type that is derived from the name field.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar name: Name of the task type.
    :vartype name: str
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, Any]] = None, **kwargs: Any) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name: Optional[str] = None


class SensitiveDataDiscoveryProperties(_serialization.Model):
    """Properties of Sensitive Data Discovery.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_enabled: Indicates whether Sensitive Data Discovery should be enabled.
    :vartype is_enabled: bool
    :ivar operation_status: Upon failure or partial success. Additional data describing Sensitive
     Data Discovery enable/disable operation.
    :vartype operation_status: ~azure.mgmt.security.models.OperationStatus
    """

    _validation = {
        "operation_status": {"readonly": True},
    }

    _attribute_map = {
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "operation_status": {"key": "operationStatus", "type": "OperationStatus"},
    }

    def __init__(self, *, is_enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_enabled: Indicates whether Sensitive Data Discovery should be enabled.
        :paramtype is_enabled: bool
        """
        super().__init__(**kwargs)
        self.is_enabled = is_enabled
        self.operation_status: Optional["_models.OperationStatus"] = None


class SensitivityLabel(_serialization.Model):
    """The sensitivity label.

    :ivar display_name: The name of the sensitivity label.
    :vartype display_name: str
    :ivar description: The description of the sensitivity label.
    :vartype description: str
    :ivar rank: The rank of the sensitivity label. Known values are: "None", "Low", "Medium",
     "High", and "Critical".
    :vartype rank: str or ~azure.mgmt.security.models.Rank
    :ivar order: The order of the sensitivity label.
    :vartype order: int
    :ivar enabled: Indicates whether the label is enabled or not.
    :vartype enabled: bool
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rank": {"key": "rank", "type": "str"},
        "order": {"key": "order", "type": "int"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        rank: Optional[Union[str, "_models.Rank"]] = None,
        order: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: The name of the sensitivity label.
        :paramtype display_name: str
        :keyword description: The description of the sensitivity label.
        :paramtype description: str
        :keyword rank: The rank of the sensitivity label. Known values are: "None", "Low", "Medium",
         "High", and "Critical".
        :paramtype rank: str or ~azure.mgmt.security.models.Rank
        :keyword order: The order of the sensitivity label.
        :paramtype order: int
        :keyword enabled: Indicates whether the label is enabled or not.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.rank = rank
        self.order = order
        self.enabled = enabled


class ServerVulnerabilityAssessment(Resource):
    """Describes the server vulnerability assessment details on a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The provisioningState of the vulnerability assessment capability on
     the VM. Known values are: "Succeeded", "Failed", "Canceled", "Provisioning", and
     "Deprovisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.models.ServerVulnerabilityAssessmentPropertiesProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[
            Union[str, "_models.ServerVulnerabilityAssessmentPropertiesProvisioningState"]
        ] = None


class ServerVulnerabilityAssessmentsList(_serialization.Model):
    """List of server vulnerability assessments.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.ServerVulnerabilityAssessment]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerVulnerabilityAssessment]"},
    }

    def __init__(self, *, value: Optional[List["_models.ServerVulnerabilityAssessment"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.models.ServerVulnerabilityAssessment]
        """
        super().__init__(**kwargs)
        self.value = value


class ServerVulnerabilityAssessmentsSettingsList(_serialization.Model):  # pylint: disable=name-too-long
    """A page of a server vulnerability assessments settings list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A collection of server vulnerability assessments settings in this page.
    :vartype value: list[~azure.mgmt.security.models.ServerVulnerabilityAssessmentsSetting]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerVulnerabilityAssessmentsSetting]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerVulnerabilityAssessmentsSetting"]] = None
        self.next_link: Optional[str] = None


class ServerVulnerabilityProperties(AdditionalData):
    """Additional context fields for server vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar assessed_resource_type: Sub-assessment resource type. Required. Known values are:
     "SqlServerVulnerability", "ContainerRegistryVulnerability", and "ServerVulnerability".
    :vartype assessed_resource_type: str or ~azure.mgmt.security.models.AssessedResourceType
    :ivar type: Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information
     Gathered.
    :vartype type: str
    :ivar cvss: Dictionary from cvss version to cvss details object.
    :vartype cvss: dict[str, ~azure.mgmt.security.models.CVSS]
    :ivar patchable: Indicates whether a patch is available or not.
    :vartype patchable: bool
    :ivar cve: List of CVEs.
    :vartype cve: list[~azure.mgmt.security.models.CVE]
    :ivar threat: Threat name.
    :vartype threat: str
    :ivar published_time: Published time.
    :vartype published_time: ~datetime.datetime
    :ivar vendor_references:
    :vartype vendor_references: list[~azure.mgmt.security.models.VendorReference]
    """

    _validation = {
        "assessed_resource_type": {"required": True},
        "type": {"readonly": True},
        "cvss": {"readonly": True},
        "patchable": {"readonly": True},
        "cve": {"readonly": True},
        "threat": {"readonly": True},
        "published_time": {"readonly": True},
        "vendor_references": {"readonly": True},
    }

    _attribute_map = {
        "assessed_resource_type": {"key": "assessedResourceType", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "cvss": {"key": "cvss", "type": "{CVSS}"},
        "patchable": {"key": "patchable", "type": "bool"},
        "cve": {"key": "cve", "type": "[CVE]"},
        "threat": {"key": "threat", "type": "str"},
        "published_time": {"key": "publishedTime", "type": "iso-8601"},
        "vendor_references": {"key": "vendorReferences", "type": "[VendorReference]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessed_resource_type: str = "ServerVulnerabilityAssessment"
        self.type: Optional[str] = None
        self.cvss: Optional[Dict[str, "_models.CVSS"]] = None
        self.patchable: Optional[bool] = None
        self.cve: Optional[List["_models.CVE"]] = None
        self.threat: Optional[str] = None
        self.published_time: Optional[datetime.datetime] = None
        self.vendor_references: Optional[List["_models.VendorReference"]] = None


class ServicePrincipalProperties(_serialization.Model):
    """Details of the service principal.

    :ivar application_id: Application ID of service principal.
    :vartype application_id: str
    :ivar secret: A secret string that the application uses to prove its identity, also can be
     referred to as application password (write only).
    :vartype secret: str
    """

    _attribute_map = {
        "application_id": {"key": "applicationId", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(self, *, application_id: Optional[str] = None, secret: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword application_id: Application ID of service principal.
        :paramtype application_id: str
        :keyword secret: A secret string that the application uses to prove its identity, also can be
         referred to as application password (write only).
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.application_id = application_id
        self.secret = secret


class SettingsList(_serialization.Model):
    """Subscription settings list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The settings list.
    :vartype value: list[~azure.mgmt.security.models.Setting]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Setting]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Setting"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The settings list.
        :paramtype value: list[~azure.mgmt.security.models.Setting]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class Software(Resource):
    """Represents a software data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar device_id: Unique identifier for the virtual machine in the service.
    :vartype device_id: str
    :ivar os_platform: Platform of the operating system running on the device.
    :vartype os_platform: str
    :ivar vendor: Name of the software vendor.
    :vartype vendor: str
    :ivar software_name: Name of the software product.
    :vartype software_name: str
    :ivar version: Version number of the software product.
    :vartype version: str
    :ivar end_of_support_status: End of support status. Known values are: "None",
     "noLongerSupported", "versionNoLongerSupported", "upcomingNoLongerSupported", and
     "upcomingVersionNoLongerSupported".
    :vartype end_of_support_status: str or ~azure.mgmt.security.models.EndOfSupportStatus
    :ivar end_of_support_date: The end of support date in case the product is upcoming end of
     support.
    :vartype end_of_support_date: str
    :ivar number_of_known_vulnerabilities: Number of weaknesses.
    :vartype number_of_known_vulnerabilities: int
    :ivar first_seen_at: First time that the software was seen in the device.
    :vartype first_seen_at: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "device_id": {"key": "properties.deviceId", "type": "str"},
        "os_platform": {"key": "properties.osPlatform", "type": "str"},
        "vendor": {"key": "properties.vendor", "type": "str"},
        "software_name": {"key": "properties.softwareName", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "end_of_support_status": {"key": "properties.endOfSupportStatus", "type": "str"},
        "end_of_support_date": {"key": "properties.endOfSupportDate", "type": "str"},
        "number_of_known_vulnerabilities": {"key": "properties.numberOfKnownVulnerabilities", "type": "int"},
        "first_seen_at": {"key": "properties.firstSeenAt", "type": "str"},
    }

    def __init__(
        self,
        *,
        device_id: Optional[str] = None,
        os_platform: Optional[str] = None,
        vendor: Optional[str] = None,
        software_name: Optional[str] = None,
        version: Optional[str] = None,
        end_of_support_status: Optional[Union[str, "_models.EndOfSupportStatus"]] = None,
        end_of_support_date: Optional[str] = None,
        number_of_known_vulnerabilities: Optional[int] = None,
        first_seen_at: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword device_id: Unique identifier for the virtual machine in the service.
        :paramtype device_id: str
        :keyword os_platform: Platform of the operating system running on the device.
        :paramtype os_platform: str
        :keyword vendor: Name of the software vendor.
        :paramtype vendor: str
        :keyword software_name: Name of the software product.
        :paramtype software_name: str
        :keyword version: Version number of the software product.
        :paramtype version: str
        :keyword end_of_support_status: End of support status. Known values are: "None",
         "noLongerSupported", "versionNoLongerSupported", "upcomingNoLongerSupported", and
         "upcomingVersionNoLongerSupported".
        :paramtype end_of_support_status: str or ~azure.mgmt.security.models.EndOfSupportStatus
        :keyword end_of_support_date: The end of support date in case the product is upcoming end of
         support.
        :paramtype end_of_support_date: str
        :keyword number_of_known_vulnerabilities: Number of weaknesses.
        :paramtype number_of_known_vulnerabilities: int
        :keyword first_seen_at: First time that the software was seen in the device.
        :paramtype first_seen_at: str
        """
        super().__init__(**kwargs)
        self.device_id = device_id
        self.os_platform = os_platform
        self.vendor = vendor
        self.software_name = software_name
        self.version = version
        self.end_of_support_status = end_of_support_status
        self.end_of_support_date = end_of_support_date
        self.number_of_known_vulnerabilities = number_of_known_vulnerabilities
        self.first_seen_at = first_seen_at


class SoftwaresList(_serialization.Model):
    """Represents the software inventory of the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.Software]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Software]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Software"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.models.Software]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class SqlServerVulnerabilityProperties(AdditionalData):
    """Details of the resource that was assessed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar assessed_resource_type: Sub-assessment resource type. Required. Known values are:
     "SqlServerVulnerability", "ContainerRegistryVulnerability", and "ServerVulnerability".
    :vartype assessed_resource_type: str or ~azure.mgmt.security.models.AssessedResourceType
    :ivar type: The resource type the sub assessment refers to in its resource details.
    :vartype type: str
    :ivar query: The T-SQL query that runs on your SQL database to perform the particular check.
    :vartype query: str
    """

    _validation = {
        "assessed_resource_type": {"required": True},
        "type": {"readonly": True},
        "query": {"readonly": True},
    }

    _attribute_map = {
        "assessed_resource_type": {"key": "assessedResourceType", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "query": {"key": "query", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessed_resource_type: str = "SqlServerVulnerability"
        self.type: Optional[str] = None
        self.query: Optional[str] = None


class StandardAssignment(Resource):
    """Security Assignment on a resource group over a given scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Display name of the standardAssignment.
    :vartype display_name: str
    :ivar description: Description of the standardAssignment.
    :vartype description: str
    :ivar assigned_standard: Standard item with key as applied to this standard assignment over the
     given scope.
    :vartype assigned_standard: ~azure.mgmt.security.models.AssignedStandardItem
    :ivar effect: Expected effect of this assignment (Audit/Exempt/Attest). Known values are:
     "Audit", "Exempt", and "Attest".
    :vartype effect: str or ~azure.mgmt.security.models.Effect
    :ivar excluded_scopes: Excluded scopes, filter out the descendants of the scope (on management
     scopes).
    :vartype excluded_scopes: list[str]
    :ivar expires_on: Expiration date of this assignment as a full ISO date.
    :vartype expires_on: ~datetime.datetime
    :ivar exemption_data: Additional data about assignment that has Exempt effect.
    :vartype exemption_data: ~azure.mgmt.security.models.StandardAssignmentPropertiesExemptionData
    :ivar attestation_data: Additional data about assignment that has Attest effect.
    :vartype attestation_data:
     ~azure.mgmt.security.models.StandardAssignmentPropertiesAttestationData
    :ivar metadata: The standard assignment metadata.
    :vartype metadata: ~azure.mgmt.security.models.StandardAssignmentMetadata
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "assigned_standard": {"key": "properties.assignedStandard", "type": "AssignedStandardItem"},
        "effect": {"key": "properties.effect", "type": "str"},
        "excluded_scopes": {"key": "properties.excludedScopes", "type": "[str]"},
        "expires_on": {"key": "properties.expiresOn", "type": "iso-8601"},
        "exemption_data": {"key": "properties.exemptionData", "type": "StandardAssignmentPropertiesExemptionData"},
        "attestation_data": {
            "key": "properties.attestationData",
            "type": "StandardAssignmentPropertiesAttestationData",
        },
        "metadata": {"key": "properties.metadata", "type": "StandardAssignmentMetadata"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        assigned_standard: Optional["_models.AssignedStandardItem"] = None,
        effect: Optional[Union[str, "_models.Effect"]] = None,
        excluded_scopes: Optional[List[str]] = None,
        expires_on: Optional[datetime.datetime] = None,
        exemption_data: Optional["_models.StandardAssignmentPropertiesExemptionData"] = None,
        attestation_data: Optional["_models.StandardAssignmentPropertiesAttestationData"] = None,
        metadata: Optional["_models.StandardAssignmentMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: Display name of the standardAssignment.
        :paramtype display_name: str
        :keyword description: Description of the standardAssignment.
        :paramtype description: str
        :keyword assigned_standard: Standard item with key as applied to this standard assignment over
         the given scope.
        :paramtype assigned_standard: ~azure.mgmt.security.models.AssignedStandardItem
        :keyword effect: Expected effect of this assignment (Audit/Exempt/Attest). Known values are:
         "Audit", "Exempt", and "Attest".
        :paramtype effect: str or ~azure.mgmt.security.models.Effect
        :keyword excluded_scopes: Excluded scopes, filter out the descendants of the scope (on
         management scopes).
        :paramtype excluded_scopes: list[str]
        :keyword expires_on: Expiration date of this assignment as a full ISO date.
        :paramtype expires_on: ~datetime.datetime
        :keyword exemption_data: Additional data about assignment that has Exempt effect.
        :paramtype exemption_data:
         ~azure.mgmt.security.models.StandardAssignmentPropertiesExemptionData
        :keyword attestation_data: Additional data about assignment that has Attest effect.
        :paramtype attestation_data:
         ~azure.mgmt.security.models.StandardAssignmentPropertiesAttestationData
        :keyword metadata: The standard assignment metadata.
        :paramtype metadata: ~azure.mgmt.security.models.StandardAssignmentMetadata
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.assigned_standard = assigned_standard
        self.effect = effect
        self.excluded_scopes = excluded_scopes
        self.expires_on = expires_on
        self.exemption_data = exemption_data
        self.attestation_data = attestation_data
        self.metadata = metadata


class StandardAssignmentMetadata(_serialization.Model):
    """The standard assignment metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_by: Standard assignment Created by object id (GUID).
    :vartype created_by: str
    :ivar created_on: Standard assignment creation date.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_by: Standard assignment last updated by object id (GUID).
    :vartype last_updated_by: str
    :ivar last_updated_on: Standard assignment last update date.
    :vartype last_updated_on: ~datetime.datetime
    """

    _validation = {
        "created_by": {"readonly": True},
        "created_on": {"readonly": True},
        "last_updated_by": {"readonly": True},
        "last_updated_on": {"readonly": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "last_updated_by": {"key": "lastUpdatedBy", "type": "str"},
        "last_updated_on": {"key": "lastUpdatedOn", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.created_by: Optional[str] = None
        self.created_on: Optional[datetime.datetime] = None
        self.last_updated_by: Optional[str] = None
        self.last_updated_on: Optional[datetime.datetime] = None


class StandardAssignmentPropertiesAttestationData(_serialization.Model):  # pylint: disable=name-too-long
    """Additional data about assignment that has Attest effect.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compliance_state: Attest category of this assignment. Known values are: "unknown",
     "compliant", and "nonCompliant".
    :vartype compliance_state: str or ~azure.mgmt.security.models.AttestationComplianceState
    :ivar assigned_assessment: Component item with key as applied to this standard assignment over
     the given scope.
    :vartype assigned_assessment: ~azure.mgmt.security.models.AssignedAssessmentItem
    :ivar compliance_date: Attestation compliance date.
    :vartype compliance_date: ~datetime.datetime
    :ivar evidence: Array of links to attestation evidence.
    :vartype evidence: list[~azure.mgmt.security.models.AttestationEvidence]
    """

    _validation = {
        "compliance_date": {"readonly": True},
    }

    _attribute_map = {
        "compliance_state": {"key": "complianceState", "type": "str"},
        "assigned_assessment": {"key": "assignedAssessment", "type": "AssignedAssessmentItem"},
        "compliance_date": {"key": "complianceDate", "type": "iso-8601"},
        "evidence": {"key": "evidence", "type": "[AttestationEvidence]"},
    }

    def __init__(
        self,
        *,
        compliance_state: Optional[Union[str, "_models.AttestationComplianceState"]] = None,
        assigned_assessment: Optional["_models.AssignedAssessmentItem"] = None,
        evidence: Optional[List["_models.AttestationEvidence"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword compliance_state: Attest category of this assignment. Known values are: "unknown",
         "compliant", and "nonCompliant".
        :paramtype compliance_state: str or ~azure.mgmt.security.models.AttestationComplianceState
        :keyword assigned_assessment: Component item with key as applied to this standard assignment
         over the given scope.
        :paramtype assigned_assessment: ~azure.mgmt.security.models.AssignedAssessmentItem
        :keyword evidence: Array of links to attestation evidence.
        :paramtype evidence: list[~azure.mgmt.security.models.AttestationEvidence]
        """
        super().__init__(**kwargs)
        self.compliance_state = compliance_state
        self.assigned_assessment = assigned_assessment
        self.compliance_date: Optional[datetime.datetime] = None
        self.evidence = evidence


class StandardAssignmentPropertiesExemptionData(_serialization.Model):  # pylint: disable=name-too-long
    """Additional data about assignment that has Exempt effect.

    :ivar exemption_category: Exemption category of this assignment. Known values are: "waiver" and
     "mitigated".
    :vartype exemption_category: str or ~azure.mgmt.security.models.ExemptionCategory
    :ivar assigned_assessment: Component item with key as applied to this standard assignment over
     the given scope.
    :vartype assigned_assessment: ~azure.mgmt.security.models.AssignedAssessmentItem
    """

    _attribute_map = {
        "exemption_category": {"key": "exemptionCategory", "type": "str"},
        "assigned_assessment": {"key": "assignedAssessment", "type": "AssignedAssessmentItem"},
    }

    def __init__(
        self,
        *,
        exemption_category: Optional[Union[str, "_models.ExemptionCategory"]] = None,
        assigned_assessment: Optional["_models.AssignedAssessmentItem"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword exemption_category: Exemption category of this assignment. Known values are: "waiver"
         and "mitigated".
        :paramtype exemption_category: str or ~azure.mgmt.security.models.ExemptionCategory
        :keyword assigned_assessment: Component item with key as applied to this standard assignment
         over the given scope.
        :paramtype assigned_assessment: ~azure.mgmt.security.models.AssignedAssessmentItem
        """
        super().__init__(**kwargs)
        self.exemption_category = exemption_category
        self.assigned_assessment = assigned_assessment


class StandardAssignmentsList(_serialization.Model):
    """Page of a standard assignment list.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of standardAssignments in this page. Required.
    :vartype value: list[~azure.mgmt.security.models.StandardAssignment]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True, "readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StandardAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.StandardAssignment"]] = None
        self.next_link: Optional[str] = None


class StandardMetadata(_serialization.Model):
    """The standard metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_by: Standard Created by object id (GUID).
    :vartype created_by: str
    :ivar created_on: Standard creation date.
    :vartype created_on: ~datetime.datetime
    :ivar last_updated_by: Standard last updated by object id (GUID).
    :vartype last_updated_by: str
    :ivar last_updated_on: Standard last update date.
    :vartype last_updated_on: ~datetime.datetime
    """

    _validation = {
        "created_by": {"readonly": True},
        "created_on": {"readonly": True},
        "last_updated_by": {"readonly": True},
        "last_updated_on": {"readonly": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_on": {"key": "createdOn", "type": "iso-8601"},
        "last_updated_by": {"key": "lastUpdatedBy", "type": "str"},
        "last_updated_on": {"key": "lastUpdatedOn", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.created_by: Optional[str] = None
        self.created_on: Optional[datetime.datetime] = None
        self.last_updated_by: Optional[str] = None
        self.last_updated_on: Optional[datetime.datetime] = None


class StatusAutoGenerated(_serialization.Model):
    """The status of the health report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The status of the health report. Known values are: "Healthy", "NotHealthy", and
     "NotApplicable".
    :vartype code: str or ~azure.mgmt.security.models.StatusName
    :ivar reason: The reason of the given status.
    :vartype reason: str
    :ivar last_scanned_date: The date of when the resource was scanned in the last time.
    :vartype last_scanned_date: ~datetime.datetime
    :ivar status_change_date: The date of when the status of the health report was changed in the
     last time.
    :vartype status_change_date: ~datetime.datetime
    :ivar first_evaluation_date: The date of when the resource of the health report was scanned in
     the first time.
    :vartype first_evaluation_date: ~datetime.datetime
    """

    _validation = {
        "reason": {"readonly": True},
        "last_scanned_date": {"readonly": True},
        "status_change_date": {"readonly": True},
        "first_evaluation_date": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "last_scanned_date": {"key": "lastScannedDate", "type": "iso-8601"},
        "status_change_date": {"key": "statusChangeDate", "type": "iso-8601"},
        "first_evaluation_date": {"key": "firstEvaluationDate", "type": "iso-8601"},
    }

    def __init__(self, *, code: Optional[Union[str, "_models.StatusName"]] = None, **kwargs: Any) -> None:
        """
        :keyword code: The status of the health report. Known values are: "Healthy", "NotHealthy", and
         "NotApplicable".
        :paramtype code: str or ~azure.mgmt.security.models.StatusName
        """
        super().__init__(**kwargs)
        self.code = code
        self.reason: Optional[str] = None
        self.last_scanned_date: Optional[datetime.datetime] = None
        self.status_change_date: Optional[datetime.datetime] = None
        self.first_evaluation_date: Optional[datetime.datetime] = None


class SubAssessmentStatus(_serialization.Model):
    """Status of the sub-assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Programmatic code for the status of the assessment. Known values are: "Healthy",
     "Unhealthy", and "NotApplicable".
    :vartype code: str or ~azure.mgmt.security.models.SubAssessmentStatusCode
    :ivar cause: Programmatic code for the cause of the assessment status.
    :vartype cause: str
    :ivar description: Human readable description of the assessment status.
    :vartype description: str
    :ivar severity: The sub-assessment severity level. Known values are: "Low", "Medium", and
     "High".
    :vartype severity: str or ~azure.mgmt.security.models.Severity
    """

    _validation = {
        "code": {"readonly": True},
        "cause": {"readonly": True},
        "description": {"readonly": True},
        "severity": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "cause": {"key": "cause", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[Union[str, "_models.SubAssessmentStatusCode"]] = None
        self.cause: Optional[str] = None
        self.description: Optional[str] = None
        self.severity: Optional[Union[str, "_models.Severity"]] = None


class SuppressionAlertsScope(_serialization.Model):
    """SuppressionAlertsScope.

    All required parameters must be populated in order to send to server.

    :ivar all_of: All the conditions inside need to be true in order to suppress the alert.
     Required.
    :vartype all_of: list[~azure.mgmt.security.models.ScopeElement]
    """

    _validation = {
        "all_of": {"required": True},
    }

    _attribute_map = {
        "all_of": {"key": "allOf", "type": "[ScopeElement]"},
    }

    def __init__(self, *, all_of: List["_models.ScopeElement"], **kwargs: Any) -> None:
        """
        :keyword all_of: All the conditions inside need to be true in order to suppress the alert.
         Required.
        :paramtype all_of: list[~azure.mgmt.security.models.ScopeElement]
        """
        super().__init__(**kwargs)
        self.all_of = all_of


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.security.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.security.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.security.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.security.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TargetBranchConfiguration(_serialization.Model):
    """Repository branch configuration for PR Annotations.

    :ivar branch_names: Gets or sets branches that should have annotations.
    :vartype branch_names: list[str]
    :ivar annotate_default_branch: Configuration of PR Annotations on default branch.

     Enabled - PR Annotations are enabled on the resource's default branch.
     Disabled - PR Annotations are disabled on the resource's default branch. Known values are:
     "Disabled" and "Enabled".
    :vartype annotate_default_branch: str or ~azure.mgmt.security.models.AnnotateDefaultBranchState
    """

    _attribute_map = {
        "branch_names": {"key": "branchNames", "type": "[str]"},
        "annotate_default_branch": {"key": "annotateDefaultBranch", "type": "str"},
    }

    def __init__(
        self,
        *,
        branch_names: Optional[List[str]] = None,
        annotate_default_branch: Optional[Union[str, "_models.AnnotateDefaultBranchState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword branch_names: Gets or sets branches that should have annotations.
        :paramtype branch_names: list[str]
        :keyword annotate_default_branch: Configuration of PR Annotations on default branch.

         Enabled - PR Annotations are enabled on the resource's default branch.
         Disabled - PR Annotations are disabled on the resource's default branch. Known values are:
         "Disabled" and "Enabled".
        :paramtype annotate_default_branch: str or
         ~azure.mgmt.security.models.AnnotateDefaultBranchState
        """
        super().__init__(**kwargs)
        self.branch_names = branch_names
        self.annotate_default_branch = annotate_default_branch


class TopologyList(_serialization.Model):
    """TopologyList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.models.TopologyResource]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TopologyResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.TopologyResource"]] = None
        self.next_link: Optional[str] = None


class TopologyResource(Resource, Location):
    """TopologyResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar calculated_date_time: The UTC time on which the topology was calculated.
    :vartype calculated_date_time: ~datetime.datetime
    :ivar topology_resources: Azure resources which are part of this topology resource.
    :vartype topology_resources: list[~azure.mgmt.security.models.TopologySingleResource]
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "calculated_date_time": {"readonly": True},
        "topology_resources": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "calculated_date_time": {"key": "properties.calculatedDateTime", "type": "iso-8601"},
        "topology_resources": {"key": "properties.topologyResources", "type": "[TopologySingleResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.calculated_date_time: Optional[datetime.datetime] = None
        self.topology_resources: Optional[List["_models.TopologySingleResource"]] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class TopologySingleResource(_serialization.Model):
    """TopologySingleResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: Azure resource id.
    :vartype resource_id: str
    :ivar severity: The security severity of the resource.
    :vartype severity: str
    :ivar recommendations_exist: Indicates if the resource has security recommendations.
    :vartype recommendations_exist: bool
    :ivar network_zones: Indicates the resource connectivity level to the Internet (InternetFacing,
     Internal ,etc.).
    :vartype network_zones: str
    :ivar topology_score: Score of the resource based on its security severity.
    :vartype topology_score: int
    :ivar location: The location of this resource.
    :vartype location: str
    :ivar parents: Azure resources connected to this resource which are in higher level in the
     topology view.
    :vartype parents: list[~azure.mgmt.security.models.TopologySingleResourceParent]
    :ivar children: Azure resources connected to this resource which are in lower level in the
     topology view.
    :vartype children: list[~azure.mgmt.security.models.TopologySingleResourceChild]
    """

    _validation = {
        "resource_id": {"readonly": True},
        "severity": {"readonly": True},
        "recommendations_exist": {"readonly": True},
        "network_zones": {"readonly": True},
        "topology_score": {"readonly": True},
        "location": {"readonly": True},
        "parents": {"readonly": True},
        "children": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "recommendations_exist": {"key": "recommendationsExist", "type": "bool"},
        "network_zones": {"key": "networkZones", "type": "str"},
        "topology_score": {"key": "topologyScore", "type": "int"},
        "location": {"key": "location", "type": "str"},
        "parents": {"key": "parents", "type": "[TopologySingleResourceParent]"},
        "children": {"key": "children", "type": "[TopologySingleResourceChild]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_id: Optional[str] = None
        self.severity: Optional[str] = None
        self.recommendations_exist: Optional[bool] = None
        self.network_zones: Optional[str] = None
        self.topology_score: Optional[int] = None
        self.location: Optional[str] = None
        self.parents: Optional[List["_models.TopologySingleResourceParent"]] = None
        self.children: Optional[List["_models.TopologySingleResourceChild"]] = None


class TopologySingleResourceChild(_serialization.Model):
    """TopologySingleResourceChild.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: Azure resource id which serves as child resource in topology view.
    :vartype resource_id: str
    """

    _validation = {
        "resource_id": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_id: Optional[str] = None


class TopologySingleResourceParent(_serialization.Model):
    """TopologySingleResourceParent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: Azure resource id which serves as parent resource in topology view.
    :vartype resource_id: str
    """

    _validation = {
        "resource_id": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_id: Optional[str] = None


class TwinUpdatesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of twin updates is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "TwinUpdatesNotInAllowedRange"


class UnauthorizedOperationsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of unauthorized operations is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type: str = "UnauthorizedOperationsNotInAllowedRange"


class UpdateIotSecuritySolutionData(TagsResource):
    """UpdateIotSecuritySolutionData.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar user_defined_resources: Properties of the IoT Security solution's user defined resources.
    :vartype user_defined_resources: ~azure.mgmt.security.models.UserDefinedResourcesProperties
    :ivar recommendations_configuration: List of the configuration status for each recommendation
     type.
    :vartype recommendations_configuration:
     list[~azure.mgmt.security.models.RecommendationConfigurationProperties]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "user_defined_resources": {"key": "properties.userDefinedResources", "type": "UserDefinedResourcesProperties"},
        "recommendations_configuration": {
            "key": "properties.recommendationsConfiguration",
            "type": "[RecommendationConfigurationProperties]",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        user_defined_resources: Optional["_models.UserDefinedResourcesProperties"] = None,
        recommendations_configuration: Optional[List["_models.RecommendationConfigurationProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword user_defined_resources: Properties of the IoT Security solution's user defined
         resources.
        :paramtype user_defined_resources: ~azure.mgmt.security.models.UserDefinedResourcesProperties
        :keyword recommendations_configuration: List of the configuration status for each
         recommendation type.
        :paramtype recommendations_configuration:
         list[~azure.mgmt.security.models.RecommendationConfigurationProperties]
        """
        super().__init__(tags=tags, **kwargs)
        self.user_defined_resources = user_defined_resources
        self.recommendations_configuration = recommendations_configuration


class UpdateSensitivitySettingsRequest(_serialization.Model):
    """Request to update data sensitivity settings for sensitive data discovery.

    All required parameters must be populated in order to send to server.

    :ivar sensitive_info_types_ids: List of selected sensitive info types' IDs. Required.
    :vartype sensitive_info_types_ids: list[str]
    :ivar sensitivity_threshold_label_order: The order of the sensitivity threshold label. Any
     label at or above this order will be considered sensitive. If set to -1, sensitivity by labels
     is turned off.
    :vartype sensitivity_threshold_label_order: float
    :ivar sensitivity_threshold_label_id: The id of the sensitivity threshold label. Any label at
     or above this rank will be considered sensitive.
    :vartype sensitivity_threshold_label_id: str
    """

    _validation = {
        "sensitive_info_types_ids": {"required": True},
    }

    _attribute_map = {
        "sensitive_info_types_ids": {"key": "sensitiveInfoTypesIds", "type": "[str]"},
        "sensitivity_threshold_label_order": {"key": "sensitivityThresholdLabelOrder", "type": "float"},
        "sensitivity_threshold_label_id": {"key": "sensitivityThresholdLabelId", "type": "str"},
    }

    def __init__(
        self,
        *,
        sensitive_info_types_ids: List[str],
        sensitivity_threshold_label_order: Optional[float] = None,
        sensitivity_threshold_label_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sensitive_info_types_ids: List of selected sensitive info types' IDs. Required.
        :paramtype sensitive_info_types_ids: list[str]
        :keyword sensitivity_threshold_label_order: The order of the sensitivity threshold label. Any
         label at or above this order will be considered sensitive. If set to -1, sensitivity by labels
         is turned off.
        :paramtype sensitivity_threshold_label_order: float
        :keyword sensitivity_threshold_label_id: The id of the sensitivity threshold label. Any label
         at or above this rank will be considered sensitive.
        :paramtype sensitivity_threshold_label_id: str
        """
        super().__init__(**kwargs)
        self.sensitive_info_types_ids = sensitive_info_types_ids
        self.sensitivity_threshold_label_order = sensitivity_threshold_label_order
        self.sensitivity_threshold_label_id = sensitivity_threshold_label_id


class UserDefinedResourcesProperties(_serialization.Model):
    """Properties of the IoT Security solution's user defined resources.

    All required parameters must be populated in order to send to server.

    :ivar query: Azure Resource Graph query which represents the security solution's user defined
     resources. Required to start with "where type != "Microsoft.Devices/IotHubs"". Required.
    :vartype query: str
    :ivar query_subscriptions: List of Azure subscription ids on which the user defined resources
     query should be executed. Required.
    :vartype query_subscriptions: list[str]
    """

    _validation = {
        "query": {"required": True},
        "query_subscriptions": {"required": True},
    }

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "query_subscriptions": {"key": "querySubscriptions", "type": "[str]"},
    }

    def __init__(self, *, query: str, query_subscriptions: List[str], **kwargs: Any) -> None:
        """
        :keyword query: Azure Resource Graph query which represents the security solution's user
         defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs"".
         Required.
        :paramtype query: str
        :keyword query_subscriptions: List of Azure subscription ids on which the user defined
         resources query should be executed. Required.
        :paramtype query_subscriptions: list[str]
        """
        super().__init__(**kwargs)
        self.query = query
        self.query_subscriptions = query_subscriptions


class VaRule(_serialization.Model):
    """vulnerability assessment rule metadata details.

    :ivar rule_id: The rule Id.
    :vartype rule_id: str
    :ivar severity: The rule severity. Known values are: "High", "Medium", "Low", "Informational",
     and "Obsolete".
    :vartype severity: str or ~azure.mgmt.security.models.RuleSeverity
    :ivar category: The rule category.
    :vartype category: str
    :ivar rule_type: The rule type. Known values are: "Binary", "BaselineExpected", "PositiveList",
     and "NegativeList".
    :vartype rule_type: str or ~azure.mgmt.security.models.RuleType
    :ivar title: The rule title.
    :vartype title: str
    :ivar description: The rule description.
    :vartype description: str
    :ivar rationale: The rule rationale.
    :vartype rationale: str
    :ivar query_check: The rule query details.
    :vartype query_check: ~azure.mgmt.security.models.QueryCheck
    :ivar benchmark_references: The benchmark references.
    :vartype benchmark_references: list[~azure.mgmt.security.models.BenchmarkReference]
    """

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rationale": {"key": "rationale", "type": "str"},
        "query_check": {"key": "queryCheck", "type": "QueryCheck"},
        "benchmark_references": {"key": "benchmarkReferences", "type": "[BenchmarkReference]"},
    }

    def __init__(
        self,
        *,
        rule_id: Optional[str] = None,
        severity: Optional[Union[str, "_models.RuleSeverity"]] = None,
        category: Optional[str] = None,
        rule_type: Optional[Union[str, "_models.RuleType"]] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        rationale: Optional[str] = None,
        query_check: Optional["_models.QueryCheck"] = None,
        benchmark_references: Optional[List["_models.BenchmarkReference"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_id: The rule Id.
        :paramtype rule_id: str
        :keyword severity: The rule severity. Known values are: "High", "Medium", "Low",
         "Informational", and "Obsolete".
        :paramtype severity: str or ~azure.mgmt.security.models.RuleSeverity
        :keyword category: The rule category.
        :paramtype category: str
        :keyword rule_type: The rule type. Known values are: "Binary", "BaselineExpected",
         "PositiveList", and "NegativeList".
        :paramtype rule_type: str or ~azure.mgmt.security.models.RuleType
        :keyword title: The rule title.
        :paramtype title: str
        :keyword description: The rule description.
        :paramtype description: str
        :keyword rationale: The rule rationale.
        :paramtype rationale: str
        :keyword query_check: The rule query details.
        :paramtype query_check: ~azure.mgmt.security.models.QueryCheck
        :keyword benchmark_references: The benchmark references.
        :paramtype benchmark_references: list[~azure.mgmt.security.models.BenchmarkReference]
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.severity = severity
        self.category = category
        self.rule_type = rule_type
        self.title = title
        self.description = description
        self.rationale = rationale
        self.query_check = query_check
        self.benchmark_references = benchmark_references


class VendorReference(_serialization.Model):
    """Vendor reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar title: Link title.
    :vartype title: str
    :ivar link: Link url.
    :vartype link: str
    """

    _validation = {
        "title": {"readonly": True},
        "link": {"readonly": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "link": {"key": "link", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.title: Optional[str] = None
        self.link: Optional[str] = None


class VmScannersBaseConfiguration(_serialization.Model):
    """Configuration for VM scanning.

    :ivar scanning_mode: The scanning mode for the VM scan. "Default"
    :vartype scanning_mode: str or ~azure.mgmt.security.models.ScanningMode
    :ivar exclusion_tags: Tags that indicates that a resource should not be scanned.
    :vartype exclusion_tags: dict[str, str]
    """

    _attribute_map = {
        "scanning_mode": {"key": "scanningMode", "type": "str"},
        "exclusion_tags": {"key": "exclusionTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        scanning_mode: Optional[Union[str, "_models.ScanningMode"]] = None,
        exclusion_tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scanning_mode: The scanning mode for the VM scan. "Default"
        :paramtype scanning_mode: str or ~azure.mgmt.security.models.ScanningMode
        :keyword exclusion_tags: Tags that indicates that a resource should not be scanned.
        :paramtype exclusion_tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.scanning_mode = scanning_mode
        self.exclusion_tags = exclusion_tags


class WorkspaceSetting(Resource):
    """Configures where to store the OMS agent data for workspaces under a scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar workspace_id: The full Azure ID of the workspace to save the data in.
    :vartype workspace_id: str
    :ivar scope: All the VMs in this scope will send their security data to the mentioned workspace
     unless overridden by a setting with more specific scope.
    :vartype scope: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "workspace_id": {"key": "properties.workspaceId", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
    }

    def __init__(self, *, workspace_id: Optional[str] = None, scope: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword workspace_id: The full Azure ID of the workspace to save the data in.
        :paramtype workspace_id: str
        :keyword scope: All the VMs in this scope will send their security data to the mentioned
         workspace unless overridden by a setting with more specific scope.
        :paramtype scope: str
        """
        super().__init__(**kwargs)
        self.workspace_id = workspace_id
        self.scope = scope


class WorkspaceSettingList(_serialization.Model):
    """List of workspace settings response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: List of workspace settings. Required.
    :vartype value: list[~azure.mgmt.security.models.WorkspaceSetting]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkspaceSetting]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.WorkspaceSetting"], **kwargs: Any) -> None:
        """
        :keyword value: List of workspace settings. Required.
        :paramtype value: list[~azure.mgmt.security.models.WorkspaceSetting]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None
