# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.eventhub import EventHubManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-eventhub
# USAGE
    python application_group_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = EventHubManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.application_group.create_or_update_application_group(
        resource_group_name="contosotest",
        namespace_name="contoso-ua-test-eh-system-1",
        application_group_name="appGroup1",
        parameters={
            "properties": {
                "clientAppGroupIdentifier": "SASKeyName=KeyName",
                "isEnabled": True,
                "policies": [
                    {
                        "metricId": "IncomingMessages",
                        "name": "ThrottlingPolicy1",
                        "rateLimitThreshold": 7912,
                        "type": "ThrottlingPolicy",
                    },
                    {
                        "metricId": "IncomingBytes",
                        "name": "ThrottlingPolicy2",
                        "rateLimitThreshold": 3951729,
                        "type": "ThrottlingPolicy",
                    },
                    {
                        "metricId": "OutgoingBytes",
                        "name": "ThrottlingPolicy3",
                        "rateLimitThreshold": 245175,
                        "type": "ThrottlingPolicy",
                    },
                ],
            }
        },
    )
    print(response)


# x-ms-original-file: specification/eventhub/resource-manager/Microsoft.EventHub/preview/2022-01-01-preview/examples/ApplicationGroup/ApplicationGroupCreate.json
if __name__ == "__main__":
    main()
