% Generated by ADiMat 0.5.6-2502
% Copyright 2009, 2010 Johannes Willkomm, Institute for Scientific Computing,
% Copyright 2001- 2008 Andre Vehreschild, Institute for Scientific Computing,
% RWTH Aachen University, 52056 Aachen, Germany.
% Visit us on the web at http://sc.rwth-aachen.de/adimat
% Report bugs to willkomm@sc.rwth-aachen.de
%
%
%                             DISCLAIMER
%
% ADiMat was prepared as part of an employment at the Institute
% for Scientific Computing, RWTH Aachen University, Germany and is
% provided AS IS. NEITHER THE AUTHOR(S), THE GOVERNMENT OF THE FEDERAL
% REPUBLIC OF GERMANY NOR ANY AGENCY THEREOF, NOR THE RWTH AACHEN UNIVERSITY,
% INCLUDING ANY OF THEIR EMPLOYEES OR OFFICERS, MAKES ANY WARRANTY,
% EXPRESS OR IMPLIED, OR ASSUMES ANY LEGAL LIABILITY OR RESPONSIBILITY
% FOR THE ACCURACY, COMPLETENESS, OR USEFULNESS OF ANY INFORMATION OR
% PROCESS DISCLOSED, OR REPRESENTS THAT ITS USE WOULD NOT INFRINGE
% PRIVATELY OWNED RIGHTS.
%
% Global flags were:
% HYBRIDMODE -- Apply hybrid mode to differentiate the files.
% NOOPEROPTIM -- Do not use optimized operators. I.e.:
%		 g_a*b*g_c -/-> mtimes3(g_a, b, g_c)
% FUNCMODE    -- Inputfile is a function (This flag can not be set explicitly).
% Unknown flag (cat: 01)!
% Unknown flag (cat: 01)!
% VERBOSITYLEVEL=10
% AD_IVARS= t
% AD_DVARS= fvec

function [g_fvec, fvec]= g_dfovec_1d(g_t, t, ind, m, n, g_x, x, nprob)
   %     This is based on a modified (evaluates along the coordinate
   %     direction for coordinate ind) version of dfovec.m 
   %     See jacobian.m for help/comments.
   
   % Set lots of constants:
   c13= 1.3d1; c14= 1.4d1; c29= 2.9d1; c45= 4.5d1; 
   v= [4.0d0, 2.0d0, 1.0d0, 5.0d-1, 2.5d-1, 1.67d-1, 1.25d-1, 1.0d-1, 8.33d-2, 7.14d-2, 6.25d-2]; 
   y1= [1.4d-1, 1.8d-1, 2.2d-1, 2.5d-1, 2.9d-1, 3.2d-1, 3.5d-1, 3.9d-1, 3.7d-1, 5.8d-1, 7.3d-1, 9.6d-1, 1.34d0, 2.1d0, 4.39d0]; 
   y2= [1.957d-1, 1.947d-1, 1.735d-1, 1.6d-1, 8.44d-2, 6.27d-2, 4.56d-2, 3.42d-2, 3.23d-2, 2.35d-2, 2.46d-2]; 
   y3= [3.478d4, 2.861d4, 2.365d4, 1.963d4, 1.637d4, 1.372d4, 1.154d4, 9.744d3, 8.261d3, 7.03d3, 6.005d3, 5.147d3, 4.427d3, 3.82d3, 3.307d3, 2.872d3]; 
   y4= [8.44d-1, 9.08d-1, 9.32d-1, 9.36d-1, 9.25d-1, 9.08d-1, 8.81d-1, 8.5d-1, 8.18d-1, 7.84d-1, 7.51d-1, 7.18d-1, 6.85d-1, 6.58d-1, 6.28d-1, 6.03d-1, 5.8d-1, 5.58d-1, 5.38d-1, 5.22d-1, 5.06d-1, 4.9d-1, 4.78d-1, 4.67d-1, 4.57d-1, 4.48d-1, 4.38d-1, 4.31d-1, 4.24d-1, 4.2d-1, 4.14d-1, 4.11d-1, 4.06d-1]; 
   y5= [1.366d0, 1.191d0, 1.112d0, 1.013d0, 9.91d-1, 8.85d-1, 8.31d-1, 8.47d-1, 7.86d-1, 7.25d-1, 7.46d-1, 6.79d-1, 6.08d-1, 6.55d-1, 6.16d-1, 6.06d-1, 6.02d-1, 6.26d-1, 6.51d-1, 7.24d-1, 6.49d-1, 6.49d-1, 6.94d-1, 6.44d-1, 6.24d-1, 6.61d-1, 6.12d-1, 5.58d-1, 5.33d-1, 4.95d-1, 5.0d-1, 4.23d-1, 3.95d-1, 3.75d-1, 3.72d-1, 3.91d-1, 3.96d-1, 4.05d-1, 4.28d-1, 4.29d-1, 5.23d-1, 5.62d-1, 6.07d-1, 6.53d-1, 6.72d-1, 7.08d-1, 6.33d-1, 6.68d-1, 6.45d-1, 6.32d-1, 5.91d-1, 5.59d-1, 5.97d-1, 6.25d-1, 7.39d-1, 7.1d-1, 7.29d-1, 7.2d-1, 6.36d-1, 5.81d-1, 4.28d-1, 2.92d-1, 1.62d-1, 9.8d-2, 5.4d-2]; 
   
   % Initialize things:
   fvec= zeros(m, 1); 
   g_fvec= zeros(size(fvec));
   sum= 0; 
   g_sum= zeros(size(sum));
   g_tmp_x_00000= g_x(ind);
   tmp_x_00000= x(ind);
   g_x(ind)= g_tmp_x_00000+ g_t;
   x(ind)= tmp_x_00000+ t; 
   
   switch nprob
      case 1
         for j= 1: n
            g_tmp_x_00001= g_x(j);
            tmp_x_00001= x(j);
            g_tmp_dfovec_1d_00191= g_sum+ g_tmp_x_00001;
            tmp_dfovec_1d_00191= sum+ tmp_x_00001; 
            % Update detected: sum= some_expression(sum,...)
            g_sum= g_tmp_dfovec_1d_00191;
            sum= tmp_dfovec_1d_00191;
         end
         g_tmp_dfovec_1d_00000= 2* g_sum;
         tmp_dfovec_1d_00000= 2* sum;
         g_tmp_dfovec_1d_00001= (m' \ g_tmp_dfovec_1d_00000' )' ;
         tmp_dfovec_1d_00001= tmp_dfovec_1d_00000/ m;
         g_temp= g_tmp_dfovec_1d_00001;
         temp= tmp_dfovec_1d_00001+ 1; 
         for i= 1: m
            g_fvec(i)= -g_temp;
            fvec(i)= -temp; 
            if (i<= n)
               g_tmp_fvec_00000= g_fvec(i);
               tmp_fvec_00000= fvec(i);
               g_tmp_x_00002= g_x(i);
               tmp_x_00002= x(i);
               g_fvec(i)= g_tmp_fvec_00000+ g_tmp_x_00002;
               fvec(i)= tmp_fvec_00000+ tmp_x_00002; 
            end
         end
      case 2
         for j= 1: n
            g_tmp_x_00003= g_x(j);
            tmp_x_00003= x(j);
            g_tmp_dfovec_1d_00002= j* g_tmp_x_00003;
            tmp_dfovec_1d_00002= j* tmp_x_00003;
            g_tmp_dfovec_1d_00192= g_sum+ g_tmp_dfovec_1d_00002;
            tmp_dfovec_1d_00192= sum+ tmp_dfovec_1d_00002; 
            % Update detected: sum= some_expression(sum,...)
            g_sum= g_tmp_dfovec_1d_00192;
            sum= tmp_dfovec_1d_00192;
         end
         for i= 1: m
            g_tmp_dfovec_1d_00003= i* g_sum;
            tmp_dfovec_1d_00003= i* sum;
            g_fvec(i)= g_tmp_dfovec_1d_00003;
            fvec(i)= tmp_dfovec_1d_00003- 1; 
         end
      case 3
         tmp_dfovec_1d_00004= n- 1;
         for j= 2: tmp_dfovec_1d_00004
            g_tmp_x_00004= g_x(j);
            tmp_x_00004= x(j);
            g_tmp_dfovec_1d_00005= j* g_tmp_x_00004;
            tmp_dfovec_1d_00005= j* tmp_x_00004;
            g_tmp_dfovec_1d_00193= g_sum+ g_tmp_dfovec_1d_00005;
            tmp_dfovec_1d_00193= sum+ tmp_dfovec_1d_00005; 
            % Update detected: sum= some_expression(sum,...)
            g_sum= g_tmp_dfovec_1d_00193;
            sum= tmp_dfovec_1d_00193;
            tmp_dfovec_1d_00004= n- 1;
         end
         tmp_dfovec_1d_00006= m- 1;
         for i= 1: tmp_dfovec_1d_00006
            tmp_dfovec_1d_00007= i- 1;
            g_tmp_dfovec_1d_00008= tmp_dfovec_1d_00007* g_sum;
            tmp_dfovec_1d_00008= tmp_dfovec_1d_00007* sum;
            g_fvec(i)= g_tmp_dfovec_1d_00008;
            fvec(i)= tmp_dfovec_1d_00008- 1; 
            tmp_dfovec_1d_00006= m- 1;
         end
         fvec(m)= -1; 
         g_fvec(m)= zeros(size(fvec(m)));
      case 4
         g_tmp_x_00005= g_x(2);
         tmp_x_00005= x(2);
         g_tmp_x_00006= g_x(1);
         tmp_x_00006= x(1);
         g_tmp_dfovec_1d_00009= adimat_g_pow_left(g_tmp_x_00006, tmp_x_00006, 2);
         tmp_dfovec_1d_00009= tmp_x_00006^ 2;
         g_tmp_dfovec_1d_00010= g_tmp_x_00005- g_tmp_dfovec_1d_00009;
         tmp_dfovec_1d_00010= tmp_x_00005- tmp_dfovec_1d_00009;
         g_fvec(1)= 10* g_tmp_dfovec_1d_00010;
         fvec(1)= 10* tmp_dfovec_1d_00010; 
         g_tmp_x_00007= g_x(1);
         tmp_x_00007= x(1);
         g_fvec(2)= -g_tmp_x_00007;
         fvec(2)= 1- tmp_x_00007; 
      case 5
         if (x(1)> 0)
            g_tmp_x_00008= g_x(2);
            tmp_x_00008= x(2);
            g_tmp_x_00009= g_x(1);
            tmp_x_00009= x(1);
            tmp_dfovec_1d_00011= tmp_x_00008/ tmp_x_00009;
            g_tmp_dfovec_1d_00011= (tmp_x_00009' \ (g_tmp_x_00008' - g_tmp_x_00009' * tmp_dfovec_1d_00011' ))' ;
            g_tmp_atan_00000= g_tmp_dfovec_1d_00011./ (1+ tmp_dfovec_1d_00011.^ 2);
            tmp_atan_00000= atan(tmp_dfovec_1d_00011);
            tmp_dfovec_1d_00012= 2* pi;
            g_th= ((tmp_dfovec_1d_00012)' \ g_tmp_atan_00000' )' ;
            th= tmp_atan_00000/ tmp_dfovec_1d_00012; 
         elseif (x(1)< 0)
            g_tmp_x_00010= g_x(2);
            tmp_x_00010= x(2);
            g_tmp_x_00011= g_x(1);
            tmp_x_00011= x(1);
            tmp_dfovec_1d_00013= tmp_x_00010/ tmp_x_00011;
            g_tmp_dfovec_1d_00013= (tmp_x_00011' \ (g_tmp_x_00010' - g_tmp_x_00011' * tmp_dfovec_1d_00013' ))' ;
            g_tmp_atan_00001= g_tmp_dfovec_1d_00013./ (1+ tmp_dfovec_1d_00013.^ 2);
            tmp_atan_00001= atan(tmp_dfovec_1d_00013);
            tmp_dfovec_1d_00014= 2* pi;
            g_tmp_dfovec_1d_00015= ((tmp_dfovec_1d_00014)' \ g_tmp_atan_00001' )' ;
            tmp_dfovec_1d_00015= tmp_atan_00001/ tmp_dfovec_1d_00014;
            g_th= g_tmp_dfovec_1d_00015;
            th= tmp_dfovec_1d_00015+ .5; 
         else % x(1)=0
            th= .25; 
            g_th= zeros(size(th));
         end
         g_tmp_x_00012= g_x(1);
         tmp_x_00012= x(1);
         g_tmp_dfovec_1d_00016= adimat_g_pow_left(g_tmp_x_00012, tmp_x_00012, 2);
         tmp_dfovec_1d_00016= tmp_x_00012^ 2;
         g_tmp_x_00013= g_x(2);
         tmp_x_00013= x(2);
         g_tmp_dfovec_1d_00017= adimat_g_pow_left(g_tmp_x_00013, tmp_x_00013, 2);
         tmp_dfovec_1d_00017= tmp_x_00013^ 2;
         g_tmp_dfovec_1d_00018= g_tmp_dfovec_1d_00016+ g_tmp_dfovec_1d_00017;
         tmp_dfovec_1d_00018= tmp_dfovec_1d_00016+ tmp_dfovec_1d_00017;
         r= sqrt(tmp_dfovec_1d_00018); 
         g_r= g_tmp_dfovec_1d_00018./ (2.* r);
         g_tmp_x_00014= g_x(3);
         tmp_x_00014= x(3);
         g_tmp_dfovec_1d_00019= 10* g_th;
         tmp_dfovec_1d_00019= 10* th;
         g_tmp_dfovec_1d_00020= g_tmp_x_00014- g_tmp_dfovec_1d_00019;
         tmp_dfovec_1d_00020= tmp_x_00014- tmp_dfovec_1d_00019;
         g_fvec(1)= 10* g_tmp_dfovec_1d_00020;
         fvec(1)= 10* tmp_dfovec_1d_00020; 
         g_tmp_dfovec_1d_00021= g_r;
         tmp_dfovec_1d_00021= r- 1;
         g_fvec(2)= 10* g_tmp_dfovec_1d_00021;
         fvec(2)= 10* tmp_dfovec_1d_00021; 
         g_tmp_x_00015= g_x(3);
         tmp_x_00015= x(3);
         g_fvec(3)= g_tmp_x_00015;
         fvec(3)= tmp_x_00015; 
      case 6
         g_tmp_x_00016= g_x(1);
         tmp_x_00016= x(1);
         g_tmp_x_00017= g_x(2);
         tmp_x_00017= x(2);
         g_tmp_dfovec_1d_00022= 10* g_tmp_x_00017;
         tmp_dfovec_1d_00022= 10* tmp_x_00017;
         g_fvec(1)= g_tmp_x_00016+ g_tmp_dfovec_1d_00022;
         fvec(1)= tmp_x_00016+ tmp_dfovec_1d_00022; 
         g_tmp_x_00018= g_x(3);
         tmp_x_00018= x(3);
         g_tmp_x_00019= g_x(4);
         tmp_x_00019= x(4);
         g_tmp_dfovec_1d_00023= g_tmp_x_00018- g_tmp_x_00019;
         tmp_dfovec_1d_00023= tmp_x_00018- tmp_x_00019;
         g_fvec(2)= sqrt(5)* g_tmp_dfovec_1d_00023;
         fvec(2)= sqrt(5)* tmp_dfovec_1d_00023; 
         g_tmp_x_00020= g_x(2);
         tmp_x_00020= x(2);
         g_tmp_x_00021= g_x(3);
         tmp_x_00021= x(3);
         g_tmp_dfovec_1d_00024= 2* g_tmp_x_00021;
         tmp_dfovec_1d_00024= 2* tmp_x_00021;
         g_tmp_dfovec_1d_00025= g_tmp_x_00020- g_tmp_dfovec_1d_00024;
         tmp_dfovec_1d_00025= tmp_x_00020- tmp_dfovec_1d_00024;
         g_fvec(3)= adimat_g_pow_left((g_tmp_dfovec_1d_00025), (tmp_dfovec_1d_00025), 2);
         fvec(3)= tmp_dfovec_1d_00025^ 2; 
         g_tmp_x_00022= g_x(1);
         tmp_x_00022= x(1);
         g_tmp_x_00023= g_x(4);
         tmp_x_00023= x(4);
         g_tmp_dfovec_1d_00026= g_tmp_x_00022- g_tmp_x_00023;
         tmp_dfovec_1d_00026= tmp_x_00022- tmp_x_00023;
         g_tmp_dfovec_1d_00027= adimat_g_pow_left((g_tmp_dfovec_1d_00026), (tmp_dfovec_1d_00026), 2);
         tmp_dfovec_1d_00027= tmp_dfovec_1d_00026^ 2;
         g_fvec(4)= sqrt(10)* g_tmp_dfovec_1d_00027;
         fvec(4)= sqrt(10)* tmp_dfovec_1d_00027; 
      case 7
         g_tmp_x_00024= g_x(1);
         tmp_x_00024= x(1);
         g_tmp_x_00025= g_x(2);
         tmp_x_00025= x(2);
         g_tmp_dfovec_1d_00028= -g_tmp_x_00025;
         tmp_dfovec_1d_00028= 5- tmp_x_00025;
         g_tmp_dfovec_1d_00029= g_tmp_dfovec_1d_00028* tmp_x_00025+ tmp_dfovec_1d_00028* g_tmp_x_00025;
         tmp_dfovec_1d_00029= tmp_dfovec_1d_00028* tmp_x_00025;
         g_tmp_dfovec_1d_00030= g_tmp_dfovec_1d_00029;
         tmp_dfovec_1d_00030= tmp_dfovec_1d_00029- 2;
         g_tmp_dfovec_1d_00031= g_tmp_dfovec_1d_00030* tmp_x_00025+ tmp_dfovec_1d_00030* g_tmp_x_00025;
         tmp_dfovec_1d_00031= tmp_dfovec_1d_00030* tmp_x_00025;
         g_fvec(1)= g_tmp_x_00024+ g_tmp_dfovec_1d_00031;
         fvec(1)= -c13+ tmp_x_00024+ tmp_dfovec_1d_00031; 
         g_tmp_x_00026= g_x(1);
         tmp_x_00026= x(1);
         g_tmp_x_00027= g_x(2);
         tmp_x_00027= x(2);
         g_tmp_dfovec_1d_00032= g_tmp_x_00027;
         tmp_dfovec_1d_00032= 1+ tmp_x_00027;
         g_tmp_dfovec_1d_00033= g_tmp_dfovec_1d_00032* tmp_x_00027+ tmp_dfovec_1d_00032* g_tmp_x_00027;
         tmp_dfovec_1d_00033= tmp_dfovec_1d_00032* tmp_x_00027;
         g_tmp_dfovec_1d_00034= g_tmp_dfovec_1d_00033;
         tmp_dfovec_1d_00034= tmp_dfovec_1d_00033- c14;
         g_tmp_dfovec_1d_00035= g_tmp_dfovec_1d_00034* tmp_x_00027+ tmp_dfovec_1d_00034* g_tmp_x_00027;
         tmp_dfovec_1d_00035= tmp_dfovec_1d_00034* tmp_x_00027;
         g_fvec(2)= g_tmp_x_00026+ g_tmp_dfovec_1d_00035;
         fvec(2)= -c29+ tmp_x_00026+ tmp_dfovec_1d_00035; 
      case 8
         for i= 1: 15
            tmp1= i; 
            g_tmp1= zeros(size(tmp1));
            tmp2= 16- i; 
            g_tmp2= zeros(size(tmp2));
            g_tmp3= g_tmp1;
            tmp3= tmp1; 
            if (i> 8)
               g_tmp3= g_tmp2;
               tmp3= tmp2; 
            end
            g_tmp_x_00028= g_x(1);
            tmp_x_00028= x(1);
            g_tmp_x_00029= g_x(2);
            tmp_x_00029= x(2);
            g_tmp_dfovec_1d_00036= g_tmp_x_00029* tmp2+ tmp_x_00029* g_tmp2;
            tmp_dfovec_1d_00036= tmp_x_00029* tmp2;
            g_tmp_x_00030= g_x(3);
            tmp_x_00030= x(3);
            g_tmp_dfovec_1d_00037= g_tmp_x_00030* tmp3+ tmp_x_00030* g_tmp3;
            tmp_dfovec_1d_00037= tmp_x_00030* tmp3;
            g_tmp_dfovec_1d_00038= g_tmp_dfovec_1d_00036+ g_tmp_dfovec_1d_00037;
            tmp_dfovec_1d_00038= tmp_dfovec_1d_00036+ tmp_dfovec_1d_00037;
            tmp_dfovec_1d_00039= tmp1/ tmp_dfovec_1d_00038;
            g_tmp_dfovec_1d_00039= ((tmp_dfovec_1d_00038)' \ (g_tmp1' - (g_tmp_dfovec_1d_00038)' * tmp_dfovec_1d_00039' ))' ;
            g_tmp_dfovec_1d_00040= g_tmp_x_00028+ g_tmp_dfovec_1d_00039;
            tmp_dfovec_1d_00040= tmp_x_00028+ tmp_dfovec_1d_00039;
            g_fvec(i)= -g_tmp_dfovec_1d_00040;
            fvec(i)= y1(i)- tmp_dfovec_1d_00040; 
         end
      case 9
         for i= 1: 11
            g_tmp_x_00031= g_x(2);
            tmp_x_00031= x(2);
            g_tmp_dfovec_1d_00041= g_tmp_x_00031;
            tmp_dfovec_1d_00041= v(i)+ tmp_x_00031;
            g_tmp1= v(i)* g_tmp_dfovec_1d_00041;
            tmp1= v(i)* tmp_dfovec_1d_00041; 
            g_tmp_x_00032= g_x(3);
            tmp_x_00032= x(3);
            g_tmp_dfovec_1d_00042= g_tmp_x_00032;
            tmp_dfovec_1d_00042= v(i)+ tmp_x_00032;
            g_tmp_dfovec_1d_00043= v(i)* g_tmp_dfovec_1d_00042;
            tmp_dfovec_1d_00043= v(i)* tmp_dfovec_1d_00042;
            g_tmp_x_00033= g_x(4);
            tmp_x_00033= x(4);
            g_tmp2= g_tmp_dfovec_1d_00043+ g_tmp_x_00033;
            tmp2= tmp_dfovec_1d_00043+ tmp_x_00033; 
            g_tmp_x_00034= g_x(1);
            tmp_x_00034= x(1);
            g_tmp_dfovec_1d_00044= g_tmp_x_00034* tmp1+ tmp_x_00034* g_tmp1;
            tmp_dfovec_1d_00044= tmp_x_00034* tmp1;
            tmp_dfovec_1d_00045= tmp_dfovec_1d_00044/ tmp2;
            g_tmp_dfovec_1d_00045= (tmp2' \ (g_tmp_dfovec_1d_00044' - g_tmp2' * tmp_dfovec_1d_00045' ))' ;
            g_fvec(i)= -g_tmp_dfovec_1d_00045;
            fvec(i)= y2(i)- tmp_dfovec_1d_00045; 
         end
      case 10
         for i= 1: 16
            tmp_dfovec_1d_00046= 5* i;
            g_tmp_x_00035= g_x(3);
            tmp_x_00035= x(3);
            g_temp= g_tmp_x_00035;
            temp= tmp_dfovec_1d_00046+ c45+ tmp_x_00035; 
            g_tmp_x_00036= g_x(2);
            tmp_x_00036= x(2);
            tmp1= tmp_x_00036/ temp; 
            g_tmp1= (temp' \ (g_tmp_x_00036' - g_temp' * tmp1' ))' ;
            g_tmp2= g_tmp1.* exp(tmp1);
            tmp2= exp(tmp1); 
            g_tmp_x_00037= g_x(1);
            tmp_x_00037= x(1);
            g_tmp_dfovec_1d_00047= g_tmp_x_00037* tmp2+ tmp_x_00037* g_tmp2;
            tmp_dfovec_1d_00047= tmp_x_00037* tmp2;
            g_fvec(i)= g_tmp_dfovec_1d_00047;
            fvec(i)= tmp_dfovec_1d_00047- y3(i); 
         end
      case 11
         for i= 1: 29
            div= i/ c29; 
            s1= 0; 
            g_s1= zeros(size(s1));
            dx= 1; 
            for j= 2: n
               tmp_dfovec_1d_00048= j- 1;
               g_tmp_x_00038= g_x(j);
               tmp_x_00038= x(j);
               g_tmp_dfovec_1d_00049= tmp_dfovec_1d_00048* dx* g_tmp_x_00038;
               tmp_dfovec_1d_00049= tmp_dfovec_1d_00048* dx* tmp_x_00038;
               g_tmp_dfovec_1d_00194= g_s1+ g_tmp_dfovec_1d_00049;
               tmp_dfovec_1d_00194= s1+ tmp_dfovec_1d_00049; 
               % Update detected: s1= some_expression(s1,...)
               g_s1= g_tmp_dfovec_1d_00194;
               s1= tmp_dfovec_1d_00194;
               tmp_dfovec_1d_00195= div* dx; 
               % Update detected: dx= some_expression(dx,...)
               dx= tmp_dfovec_1d_00195;
            end
            s2= 0; 
            g_s2= zeros(size(s2));
            dx= 1; 
            for j= 1: n
               g_tmp_x_00039= g_x(j);
               tmp_x_00039= x(j);
               g_tmp_dfovec_1d_00050= dx* g_tmp_x_00039;
               tmp_dfovec_1d_00050= dx* tmp_x_00039;
               g_tmp_dfovec_1d_00196= g_s2+ g_tmp_dfovec_1d_00050;
               tmp_dfovec_1d_00196= s2+ tmp_dfovec_1d_00050; 
               % Update detected: s2= some_expression(s2,...)
               g_s2= g_tmp_dfovec_1d_00196;
               s2= tmp_dfovec_1d_00196;
               tmp_dfovec_1d_00197= div* dx; 
               % Update detected: dx= some_expression(dx,...)
               dx= tmp_dfovec_1d_00197;
            end
            g_tmp_dfovec_1d_00051= adimat_g_pow_left(g_s2, s2, 2);
            tmp_dfovec_1d_00051= s2^ 2;
            g_fvec(i)= g_s1- g_tmp_dfovec_1d_00051;
            fvec(i)= s1- tmp_dfovec_1d_00051- 1; 
         end
         g_tmp_x_00040= g_x(1);
         tmp_x_00040= x(1);
         g_fvec(30)= g_tmp_x_00040;
         fvec(30)= tmp_x_00040; 
         g_tmp_x_00041= g_x(2);
         tmp_x_00041= x(2);
         g_tmp_x_00042= g_x(1);
         tmp_x_00042= x(1);
         g_tmp_dfovec_1d_00052= adimat_g_pow_left(g_tmp_x_00042, tmp_x_00042, 2);
         tmp_dfovec_1d_00052= tmp_x_00042^ 2;
         g_fvec(31)= g_tmp_x_00041- g_tmp_dfovec_1d_00052;
         fvec(31)= tmp_x_00041- tmp_dfovec_1d_00052- 1; 
      case 12
         for i= 1: m
            temp= i; 
            g_temp= zeros(size(temp));
            g_tmp1= (10' \ g_temp' )' ;
            tmp1= temp/ 10; 
            g_tmp_dfovec_1d_00053= -g_tmp1;
            tmp_dfovec_1d_00053= -tmp1;
            g_tmp_x_00043= g_x(1);
            tmp_x_00043= x(1);
            g_tmp_dfovec_1d_00054= g_tmp_dfovec_1d_00053* tmp_x_00043+ tmp_dfovec_1d_00053* g_tmp_x_00043;
            tmp_dfovec_1d_00054= tmp_dfovec_1d_00053* tmp_x_00043;
            g_tmp_exp_00000= g_tmp_dfovec_1d_00054.* exp(tmp_dfovec_1d_00054);
            tmp_exp_00000= exp(tmp_dfovec_1d_00054);
            g_tmp_x_00044= g_x(2);
            tmp_x_00044= x(2);
            g_tmp_dfovec_1d_00055= g_tmp_dfovec_1d_00053* tmp_x_00044+ tmp_dfovec_1d_00053* g_tmp_x_00044;
            tmp_dfovec_1d_00055= tmp_dfovec_1d_00053* tmp_x_00044;
            g_tmp_exp_00001= g_tmp_dfovec_1d_00055.* exp(tmp_dfovec_1d_00055);
            tmp_exp_00001= exp(tmp_dfovec_1d_00055);
            g_tmp_dfovec_1d_00056= -g_temp;
            tmp_dfovec_1d_00056= -temp;
            g_tmp_exp_00002= g_tmp_dfovec_1d_00056.* exp(tmp_dfovec_1d_00056);
            tmp_exp_00002= exp(tmp_dfovec_1d_00056);
            g_tmp_exp_00003= g_tmp_dfovec_1d_00053.* exp(tmp_dfovec_1d_00053);
            tmp_exp_00003= exp(tmp_dfovec_1d_00053);
            g_tmp_dfovec_1d_00057= g_tmp_exp_00002- g_tmp_exp_00003;
            tmp_dfovec_1d_00057= tmp_exp_00002- tmp_exp_00003;
            g_tmp_x_00045= g_x(3);
            tmp_x_00045= x(3);
            g_tmp_dfovec_1d_00058= g_tmp_dfovec_1d_00057* tmp_x_00045+ tmp_dfovec_1d_00057* g_tmp_x_00045;
            tmp_dfovec_1d_00058= tmp_dfovec_1d_00057* tmp_x_00045;
            g_fvec(i)= g_tmp_exp_00000- g_tmp_exp_00001+ g_tmp_dfovec_1d_00058;
            fvec(i)= tmp_exp_00000- tmp_exp_00001+ tmp_dfovec_1d_00058; 
         end
      case 13
         for i= 1: m
            temp= i; 
            g_temp= zeros(size(temp));
            g_tmp_dfovec_1d_00059= 2* g_temp;
            tmp_dfovec_1d_00059= 2* temp;
            g_tmp_x_00046= g_x(1);
            tmp_x_00046= x(1);
            g_tmp_dfovec_1d_00060= g_temp* tmp_x_00046+ temp* g_tmp_x_00046;
            tmp_dfovec_1d_00060= temp* tmp_x_00046;
            g_tmp_exp_00004= g_tmp_dfovec_1d_00060.* exp(tmp_dfovec_1d_00060);
            tmp_exp_00004= exp(tmp_dfovec_1d_00060);
            g_tmp_x_00047= g_x(2);
            tmp_x_00047= x(2);
            g_tmp_dfovec_1d_00061= g_temp* tmp_x_00047+ temp* g_tmp_x_00047;
            tmp_dfovec_1d_00061= temp* tmp_x_00047;
            g_tmp_exp_00005= g_tmp_dfovec_1d_00061.* exp(tmp_dfovec_1d_00061);
            tmp_exp_00005= exp(tmp_dfovec_1d_00061);
            g_fvec(i)= g_tmp_dfovec_1d_00059- g_tmp_exp_00004- g_tmp_exp_00005;
            fvec(i)= 2+ tmp_dfovec_1d_00059- tmp_exp_00004- tmp_exp_00005; 
         end
      case 14
         for i= 1: m
            temp= i/ 5; 
            g_temp= zeros(size(temp));
            g_tmp_x_00048= g_x(1);
            tmp_x_00048= x(1);
            g_tmp_x_00049= g_x(2);
            tmp_x_00049= x(2);
            g_tmp_dfovec_1d_00062= g_temp* tmp_x_00049+ temp* g_tmp_x_00049;
            tmp_dfovec_1d_00062= temp* tmp_x_00049;
            g_tmp_exp_00006= g_temp.* exp(temp);
            tmp_exp_00006= exp(temp);
            g_tmp1= g_tmp_x_00048+ g_tmp_dfovec_1d_00062- g_tmp_exp_00006;
            tmp1= tmp_x_00048+ tmp_dfovec_1d_00062- tmp_exp_00006; 
            g_tmp_x_00050= g_x(3);
            tmp_x_00050= x(3);
            g_tmp_sin_00000= g_temp.* cos(temp);
            tmp_sin_00000= sin(temp);
            g_tmp_x_00051= g_x(4);
            tmp_x_00051= x(4);
            g_tmp_dfovec_1d_00063= g_tmp_sin_00000* tmp_x_00051+ tmp_sin_00000* g_tmp_x_00051;
            tmp_dfovec_1d_00063= tmp_sin_00000* tmp_x_00051;
            g_tmp_cos_00000= g_temp.* (-sin(temp));
            tmp_cos_00000= cos(temp);
            g_tmp2= g_tmp_x_00050+ g_tmp_dfovec_1d_00063- g_tmp_cos_00000;
            tmp2= tmp_x_00050+ tmp_dfovec_1d_00063- tmp_cos_00000; 
            g_tmp_dfovec_1d_00064= adimat_g_pow_left(g_tmp1, tmp1, 2);
            tmp_dfovec_1d_00064= tmp1^ 2;
            g_tmp_dfovec_1d_00065= adimat_g_pow_left(g_tmp2, tmp2, 2);
            tmp_dfovec_1d_00065= tmp2^ 2;
            g_fvec(i)= g_tmp_dfovec_1d_00064+ g_tmp_dfovec_1d_00065;
            fvec(i)= tmp_dfovec_1d_00064+ tmp_dfovec_1d_00065; 
         end
      case 15
         for j= 1: n
            t1= 1; 
            g_t1= zeros(size(t1));
            g_tmp_x_00052= g_x(j);
            tmp_x_00052= x(j);
            g_tmp_dfovec_1d_00066= 2* g_tmp_x_00052;
            tmp_dfovec_1d_00066= 2* tmp_x_00052;
            g_t2= g_tmp_dfovec_1d_00066;
            t2= tmp_dfovec_1d_00066- 1; 
            g_t= 2* g_t2;
            t= 2* t2; 
            for i= 1: m
               g_tmp_fvec_00001= g_fvec(i);
               tmp_fvec_00001= fvec(i);
               g_fvec(i)= g_tmp_fvec_00001+ g_t2;
               fvec(i)= tmp_fvec_00001+ t2; 
               g_tmp_dfovec_1d_00067= g_t* t2+ t* g_t2;
               tmp_dfovec_1d_00067= t* t2;
               g_th= g_tmp_dfovec_1d_00067- g_t1;
               th= tmp_dfovec_1d_00067- t1; 
               g_t1= g_t2;
               t1= t2; 
               g_t2= g_th;
               t2= th; 
            end
         end
         iev= -1; 
         for i= 1: m
            g_tmp_fvec_00002= g_fvec(i);
            tmp_fvec_00002= fvec(i);
            g_fvec(i)= (n' \ g_tmp_fvec_00002' )' ;
            fvec(i)= tmp_fvec_00002/ n; 
            if (iev> 0)
               g_tmp_fvec_00003= g_fvec(i);
               tmp_fvec_00003= fvec(i);
               tmp_dfovec_1d_00068= i^ 2;
               tmp_dfovec_1d_00069= tmp_dfovec_1d_00068- 1;
               tmp_dfovec_1d_00070= 1/ tmp_dfovec_1d_00069;
               g_fvec(i)= g_tmp_fvec_00003;
               fvec(i)= tmp_fvec_00003+ tmp_dfovec_1d_00070; 
            end
            tmp_dfovec_1d_00198= -iev; 
            % Update detected: iev= some_expression(iev,...)
            iev= tmp_dfovec_1d_00198;
         end
      case 16
         tmp_dfovec_1d_00071= n+ 1;
         sum1= -tmp_dfovec_1d_00071; 
         g_sum1= zeros(size(sum1));
         prod1= 1; 
         g_prod1= zeros(size(prod1));
         for j= 1: n
            g_tmp_x_00053= g_x(j);
            tmp_x_00053= x(j);
            g_tmp_dfovec_1d_00199= g_sum1+ g_tmp_x_00053;
            tmp_dfovec_1d_00199= sum1+ tmp_x_00053; 
            % Update detected: sum1= some_expression(sum1,...)
            g_sum1= g_tmp_dfovec_1d_00199;
            sum1= tmp_dfovec_1d_00199;
            g_tmp_x_00054= g_x(j);
            tmp_x_00054= x(j);
            g_tmp_dfovec_1d_00200= g_tmp_x_00054* prod1+ tmp_x_00054* g_prod1;
            tmp_dfovec_1d_00200= tmp_x_00054* prod1; 
            % Update detected: prod1= some_expression(prod1,...)
            g_prod1= g_tmp_dfovec_1d_00200;
            prod1= tmp_dfovec_1d_00200;
         end
         tmp_dfovec_1d_00072= n- 1;
         for i= 1: tmp_dfovec_1d_00072
            g_tmp_x_00055= g_x(i);
            tmp_x_00055= x(i);
            g_fvec(i)= g_tmp_x_00055+ g_sum1;
            fvec(i)= tmp_x_00055+ sum1; 
            tmp_dfovec_1d_00072= n- 1;
         end
         g_fvec(n)= g_prod1;
         fvec(n)= prod1- 1; 
      case 17
         for i= 1: 33
            tmp_dfovec_1d_00073= i- 1;
            temp= 10* tmp_dfovec_1d_00073; 
            g_temp= zeros(size(temp));
            g_tmp_x_00056= g_x(4);
            tmp_x_00056= x(4);
            g_tmp_dfovec_1d_00074= -g_tmp_x_00056;
            tmp_dfovec_1d_00074= -tmp_x_00056;
            g_tmp_dfovec_1d_00075= g_tmp_dfovec_1d_00074* temp+ tmp_dfovec_1d_00074* g_temp;
            tmp_dfovec_1d_00075= tmp_dfovec_1d_00074* temp;
            g_tmp1= g_tmp_dfovec_1d_00075.* exp(tmp_dfovec_1d_00075);
            tmp1= exp(tmp_dfovec_1d_00075); 
            g_tmp_x_00057= g_x(5);
            tmp_x_00057= x(5);
            g_tmp_dfovec_1d_00076= -g_tmp_x_00057;
            tmp_dfovec_1d_00076= -tmp_x_00057;
            g_tmp_dfovec_1d_00077= g_tmp_dfovec_1d_00076* temp+ tmp_dfovec_1d_00076* g_temp;
            tmp_dfovec_1d_00077= tmp_dfovec_1d_00076* temp;
            g_tmp2= g_tmp_dfovec_1d_00077.* exp(tmp_dfovec_1d_00077);
            tmp2= exp(tmp_dfovec_1d_00077); 
            g_tmp_x_00058= g_x(1);
            tmp_x_00058= x(1);
            g_tmp_x_00059= g_x(2);
            tmp_x_00059= x(2);
            g_tmp_dfovec_1d_00078= g_tmp_x_00059* tmp1+ tmp_x_00059* g_tmp1;
            tmp_dfovec_1d_00078= tmp_x_00059* tmp1;
            g_tmp_x_00060= g_x(3);
            tmp_x_00060= x(3);
            g_tmp_dfovec_1d_00079= g_tmp_x_00060* tmp2+ tmp_x_00060* g_tmp2;
            tmp_dfovec_1d_00079= tmp_x_00060* tmp2;
            g_tmp_dfovec_1d_00080= g_tmp_x_00058+ g_tmp_dfovec_1d_00078+ g_tmp_dfovec_1d_00079;
            tmp_dfovec_1d_00080= tmp_x_00058+ tmp_dfovec_1d_00078+ tmp_dfovec_1d_00079;
            g_fvec(i)= -g_tmp_dfovec_1d_00080;
            fvec(i)= y4(i)- tmp_dfovec_1d_00080; 
         end
      case 18
         for i= 1: 65
            tmp_dfovec_1d_00081= i- 1;
            temp= tmp_dfovec_1d_00081/ 10; 
            g_temp= zeros(size(temp));
            g_tmp_x_00061= g_x(5);
            tmp_x_00061= x(5);
            g_tmp_dfovec_1d_00082= -g_tmp_x_00061;
            tmp_dfovec_1d_00082= -tmp_x_00061;
            g_tmp_dfovec_1d_00083= g_tmp_dfovec_1d_00082* temp+ tmp_dfovec_1d_00082* g_temp;
            tmp_dfovec_1d_00083= tmp_dfovec_1d_00082* temp;
            g_tmp1= g_tmp_dfovec_1d_00083.* exp(tmp_dfovec_1d_00083);
            tmp1= exp(tmp_dfovec_1d_00083); 
            g_tmp_x_00062= g_x(6);
            tmp_x_00062= x(6);
            g_tmp_dfovec_1d_00084= -g_tmp_x_00062;
            tmp_dfovec_1d_00084= -tmp_x_00062;
            g_tmp_x_00063= g_x(9);
            tmp_x_00063= x(9);
            g_tmp_dfovec_1d_00085= g_temp- g_tmp_x_00063;
            tmp_dfovec_1d_00085= temp- tmp_x_00063;
            g_tmp_dfovec_1d_00086= adimat_g_pow_left((g_tmp_dfovec_1d_00085), (tmp_dfovec_1d_00085), 2);
            tmp_dfovec_1d_00086= tmp_dfovec_1d_00085^ 2;
            g_tmp_dfovec_1d_00087= g_tmp_dfovec_1d_00084* tmp_dfovec_1d_00086+ tmp_dfovec_1d_00084* g_tmp_dfovec_1d_00086;
            tmp_dfovec_1d_00087= tmp_dfovec_1d_00084* tmp_dfovec_1d_00086;
            g_tmp2= g_tmp_dfovec_1d_00087.* exp(tmp_dfovec_1d_00087);
            tmp2= exp(tmp_dfovec_1d_00087); 
            g_tmp_x_00064= g_x(7);
            tmp_x_00064= x(7);
            g_tmp_dfovec_1d_00088= -g_tmp_x_00064;
            tmp_dfovec_1d_00088= -tmp_x_00064;
            g_tmp_x_00065= g_x(10);
            tmp_x_00065= x(10);
            g_tmp_dfovec_1d_00089= g_temp- g_tmp_x_00065;
            tmp_dfovec_1d_00089= temp- tmp_x_00065;
            g_tmp_dfovec_1d_00090= adimat_g_pow_left((g_tmp_dfovec_1d_00089), (tmp_dfovec_1d_00089), 2);
            tmp_dfovec_1d_00090= tmp_dfovec_1d_00089^ 2;
            g_tmp_dfovec_1d_00091= g_tmp_dfovec_1d_00088* tmp_dfovec_1d_00090+ tmp_dfovec_1d_00088* g_tmp_dfovec_1d_00090;
            tmp_dfovec_1d_00091= tmp_dfovec_1d_00088* tmp_dfovec_1d_00090;
            g_tmp3= g_tmp_dfovec_1d_00091.* exp(tmp_dfovec_1d_00091);
            tmp3= exp(tmp_dfovec_1d_00091); 
            g_tmp_x_00066= g_x(8);
            tmp_x_00066= x(8);
            g_tmp_dfovec_1d_00092= -g_tmp_x_00066;
            tmp_dfovec_1d_00092= -tmp_x_00066;
            g_tmp_x_00067= g_x(11);
            tmp_x_00067= x(11);
            g_tmp_dfovec_1d_00093= g_temp- g_tmp_x_00067;
            tmp_dfovec_1d_00093= temp- tmp_x_00067;
            g_tmp_dfovec_1d_00094= adimat_g_pow_left((g_tmp_dfovec_1d_00093), (tmp_dfovec_1d_00093), 2);
            tmp_dfovec_1d_00094= tmp_dfovec_1d_00093^ 2;
            g_tmp_dfovec_1d_00095= g_tmp_dfovec_1d_00092* tmp_dfovec_1d_00094+ tmp_dfovec_1d_00092* g_tmp_dfovec_1d_00094;
            tmp_dfovec_1d_00095= tmp_dfovec_1d_00092* tmp_dfovec_1d_00094;
            g_tmp4= g_tmp_dfovec_1d_00095.* exp(tmp_dfovec_1d_00095);
            tmp4= exp(tmp_dfovec_1d_00095); 
            g_tmp_x_00068= g_x(1);
            tmp_x_00068= x(1);
            g_tmp_dfovec_1d_00096= g_tmp_x_00068* tmp1+ tmp_x_00068* g_tmp1;
            tmp_dfovec_1d_00096= tmp_x_00068* tmp1;
            g_tmp_x_00069= g_x(2);
            tmp_x_00069= x(2);
            g_tmp_dfovec_1d_00097= g_tmp_x_00069* tmp2+ tmp_x_00069* g_tmp2;
            tmp_dfovec_1d_00097= tmp_x_00069* tmp2;
            g_tmp_x_00070= g_x(3);
            tmp_x_00070= x(3);
            g_tmp_dfovec_1d_00098= g_tmp_x_00070* tmp3+ tmp_x_00070* g_tmp3;
            tmp_dfovec_1d_00098= tmp_x_00070* tmp3;
            g_tmp_x_00071= g_x(4);
            tmp_x_00071= x(4);
            g_tmp_dfovec_1d_00099= g_tmp_x_00071* tmp4+ tmp_x_00071* g_tmp4;
            tmp_dfovec_1d_00099= tmp_x_00071* tmp4;
            g_tmp_dfovec_1d_00100= g_tmp_dfovec_1d_00096+ g_tmp_dfovec_1d_00097+ g_tmp_dfovec_1d_00098+ g_tmp_dfovec_1d_00099;
            tmp_dfovec_1d_00100= tmp_dfovec_1d_00096+ tmp_dfovec_1d_00097+ tmp_dfovec_1d_00098+ tmp_dfovec_1d_00099;
            g_fvec(i)= -g_tmp_dfovec_1d_00100;
            fvec(i)= y5(i)- tmp_dfovec_1d_00100; 
         end
      case 19% n>=5, m = (n-4)*2
         tmp_dfovec_1d_00101= n- 4;
         for i= 1: tmp_dfovec_1d_00101
            g_tmp_x_00072= g_x(i);
            tmp_x_00072= x(i);
            g_tmp_dfovec_1d_00102= -4* g_tmp_x_00072;
            tmp_dfovec_1d_00102= -4* tmp_x_00072;
            g_tmp_dfovec_1d_00103= g_tmp_dfovec_1d_00102;
            tmp_dfovec_1d_00103= tmp_dfovec_1d_00102+ 3.0;
            g_fvec(i)= g_tmp_dfovec_1d_00103;
            fvec(i)= tmp_dfovec_1d_00103; 
            g_tmp_x_00073= g_x(i);
            tmp_x_00073= x(i);
            g_tmp_dfovec_1d_00104= adimat_g_pow_left(g_tmp_x_00073, tmp_x_00073, 2);
            tmp_dfovec_1d_00104= tmp_x_00073^ 2;
            tmp_dfovec_1d_00105= i+ 1;
            g_tmp_x_00074= g_x(tmp_dfovec_1d_00105);
            tmp_x_00074= x(tmp_dfovec_1d_00105);
            g_tmp_dfovec_1d_00106= adimat_g_pow_left(g_tmp_x_00074, tmp_x_00074, 2);
            tmp_dfovec_1d_00106= tmp_x_00074^ 2;
            g_tmp_dfovec_1d_00107= 2* g_tmp_dfovec_1d_00106;
            tmp_dfovec_1d_00107= 2* tmp_dfovec_1d_00106;
            tmp_dfovec_1d_00108= i+ 2;
            g_tmp_x_00075= g_x(tmp_dfovec_1d_00108);
            tmp_x_00075= x(tmp_dfovec_1d_00108);
            g_tmp_dfovec_1d_00109= adimat_g_pow_left(g_tmp_x_00075, tmp_x_00075, 2);
            tmp_dfovec_1d_00109= tmp_x_00075^ 2;
            g_tmp_dfovec_1d_00110= 3* g_tmp_dfovec_1d_00109;
            tmp_dfovec_1d_00110= 3* tmp_dfovec_1d_00109;
            tmp_dfovec_1d_00111= i+ 3;
            g_tmp_x_00076= g_x(tmp_dfovec_1d_00111);
            tmp_x_00076= x(tmp_dfovec_1d_00111);
            g_tmp_dfovec_1d_00112= adimat_g_pow_left(g_tmp_x_00076, tmp_x_00076, 2);
            tmp_dfovec_1d_00112= tmp_x_00076^ 2;
            g_tmp_dfovec_1d_00113= 4* g_tmp_dfovec_1d_00112;
            tmp_dfovec_1d_00113= 4* tmp_dfovec_1d_00112;
            g_tmp_x_00077= g_x(n);
            tmp_x_00077= x(n);
            g_tmp_dfovec_1d_00114= adimat_g_pow_left(g_tmp_x_00077, tmp_x_00077, 2);
            tmp_dfovec_1d_00114= tmp_x_00077^ 2;
            g_tmp_dfovec_1d_00115= 5* g_tmp_dfovec_1d_00114;
            tmp_dfovec_1d_00115= 5* tmp_dfovec_1d_00114;
            g_tmp_dfovec_1d_00116= g_tmp_dfovec_1d_00104+ g_tmp_dfovec_1d_00107+ g_tmp_dfovec_1d_00110+ g_tmp_dfovec_1d_00113+ g_tmp_dfovec_1d_00115;
            tmp_dfovec_1d_00116= tmp_dfovec_1d_00104+ tmp_dfovec_1d_00107+ tmp_dfovec_1d_00110+ tmp_dfovec_1d_00113+ tmp_dfovec_1d_00115;
            g_fvec(n- 4+ i)= g_tmp_dfovec_1d_00116;
            fvec(n- 4+ i)= tmp_dfovec_1d_00116; 
            tmp_dfovec_1d_00101= n- 4;
         end
      case 20% n=2; m=n;
         g_tmp_x_00078= g_x(1);
         tmp_x_00078= x(1);
         g_tmp_dfovec_1d_00117= g_tmp_x_00078;
         tmp_dfovec_1d_00117= tmp_x_00078- 1.0;
         g_fvec(1)= g_tmp_dfovec_1d_00117;
         fvec(1)= tmp_dfovec_1d_00117; 
         for i= 2: n
            g_tmp_x_00079= g_x(i);
            tmp_x_00079= x(i);
            tmp_dfovec_1d_00118= i- 1;
            g_tmp_x_00080= g_x(tmp_dfovec_1d_00118);
            tmp_x_00080= x(tmp_dfovec_1d_00118);
            g_tmp_dfovec_1d_00119= adimat_g_pow_left(g_tmp_x_00080, tmp_x_00080, 3);
            tmp_dfovec_1d_00119= tmp_x_00080^ 3;
            g_tmp_dfovec_1d_00120= g_tmp_x_00079- g_tmp_dfovec_1d_00119;
            tmp_dfovec_1d_00120= tmp_x_00079- tmp_dfovec_1d_00119;
            g_fvec(i)= 10* g_tmp_dfovec_1d_00120;
            fvec(i)= 10* tmp_dfovec_1d_00120; 
         end
      case 21% n >=2; m=n
         for i= 1: n
            ss= 0; 
            g_ss= zeros(size(ss));
            for j= 1: n
               g_tmp_x_00081= g_x(i);
               tmp_x_00081= x(i);
               g_tmp_dfovec_1d_00121= adimat_g_pow_left(g_tmp_x_00081, tmp_x_00081, 2);
               tmp_dfovec_1d_00121= tmp_x_00081^ 2;
               tmp_dfovec_1d_00122= i/ j;
               g_tmp_dfovec_1d_00123= g_tmp_dfovec_1d_00121;
               tmp_dfovec_1d_00123= tmp_dfovec_1d_00121+ tmp_dfovec_1d_00122;
               v2= sqrt(tmp_dfovec_1d_00123); 
               g_v2= g_tmp_dfovec_1d_00123./ (2.* v2);
               g_tmp_log_00000= g_v2./ v2;
               tmp_log_00000= log(v2);
               g_tmp_sin_00001= g_tmp_log_00000.* cos(tmp_log_00000);
               tmp_sin_00001= sin(tmp_log_00000);
               g_tmp_dfovec_1d_00124= adimat_g_pow_left((g_tmp_sin_00001), (tmp_sin_00001), 5);
               tmp_dfovec_1d_00124= tmp_sin_00001^ 5;
               g_tmp_cos_00001= g_tmp_log_00000.* (-sin(tmp_log_00000));
               tmp_cos_00001= cos(tmp_log_00000);
               g_tmp_dfovec_1d_00125= adimat_g_pow_left((g_tmp_cos_00001), (tmp_cos_00001), 5);
               tmp_dfovec_1d_00125= tmp_cos_00001^ 5;
               g_tmp_dfovec_1d_00126= g_tmp_dfovec_1d_00124+ g_tmp_dfovec_1d_00125;
               tmp_dfovec_1d_00126= tmp_dfovec_1d_00124+ tmp_dfovec_1d_00125;
               g_tmp_dfovec_1d_00127= g_v2* tmp_dfovec_1d_00126+ v2* g_tmp_dfovec_1d_00126;
               tmp_dfovec_1d_00127= v2* tmp_dfovec_1d_00126;
               g_tmp_dfovec_1d_00201= g_ss+ g_tmp_dfovec_1d_00127;
               tmp_dfovec_1d_00201= ss+ tmp_dfovec_1d_00127; 
               % Update detected: ss= some_expression(ss,...)
               g_ss= g_tmp_dfovec_1d_00201;
               ss= tmp_dfovec_1d_00201;
            end
            g_tmp_x_00082= g_x(i);
            tmp_x_00082= x(i);
            g_tmp_dfovec_1d_00128= 1400* g_tmp_x_00082;
            tmp_dfovec_1d_00128= 1400* tmp_x_00082;
            tmp_dfovec_1d_00129= i- 50;
            tmp_dfovec_1d_00130= tmp_dfovec_1d_00129^ 3;
            g_fvec(i)= g_tmp_dfovec_1d_00128+ g_ss;
            fvec(i)= tmp_dfovec_1d_00128+ tmp_dfovec_1d_00130+ ss; 
         end
      case 22% m=n=8
         g_tmp_x_00083= g_x(1);
         tmp_x_00083= x(1);
         g_tmp_x_00084= g_x(2);
         tmp_x_00084= x(2);
         g_fvec(1)= g_tmp_x_00083+ g_tmp_x_00084;
         fvec(1)= tmp_x_00083+ tmp_x_00084+ 0.69; 
         g_tmp_x_00085= g_x(3);
         tmp_x_00085= x(3);
         g_tmp_x_00086= g_x(4);
         tmp_x_00086= x(4);
         g_fvec(2)= g_tmp_x_00085+ g_tmp_x_00086;
         fvec(2)= tmp_x_00085+ tmp_x_00086+ 0.044; 
         g_tmp_x_00087= g_x(5);
         tmp_x_00087= x(5);
         g_tmp_x_00088= g_x(1);
         tmp_x_00088= x(1);
         g_tmp_dfovec_1d_00131= g_tmp_x_00087* tmp_x_00088+ tmp_x_00087* g_tmp_x_00088;
         tmp_dfovec_1d_00131= tmp_x_00087* tmp_x_00088;
         g_tmp_x_00089= g_x(6);
         tmp_x_00089= x(6);
         g_tmp_x_00090= g_x(2);
         tmp_x_00090= x(2);
         g_tmp_dfovec_1d_00132= g_tmp_x_00089* tmp_x_00090+ tmp_x_00089* g_tmp_x_00090;
         tmp_dfovec_1d_00132= tmp_x_00089* tmp_x_00090;
         g_tmp_x_00091= g_x(7);
         tmp_x_00091= x(7);
         g_tmp_x_00092= g_x(3);
         tmp_x_00092= x(3);
         g_tmp_dfovec_1d_00133= g_tmp_x_00091* tmp_x_00092+ tmp_x_00091* g_tmp_x_00092;
         tmp_dfovec_1d_00133= tmp_x_00091* tmp_x_00092;
         g_tmp_x_00093= g_x(8);
         tmp_x_00093= x(8);
         g_tmp_x_00094= g_x(4);
         tmp_x_00094= x(4);
         g_tmp_dfovec_1d_00134= g_tmp_x_00093* tmp_x_00094+ tmp_x_00093* g_tmp_x_00094;
         tmp_dfovec_1d_00134= tmp_x_00093* tmp_x_00094;
         g_fvec(3)= g_tmp_dfovec_1d_00131+ g_tmp_dfovec_1d_00132- g_tmp_dfovec_1d_00133- g_tmp_dfovec_1d_00134;
         fvec(3)= tmp_dfovec_1d_00131+ tmp_dfovec_1d_00132- tmp_dfovec_1d_00133- tmp_dfovec_1d_00134+ 1.57; 
         g_tmp_x_00095= g_x(7);
         tmp_x_00095= x(7);
         g_tmp_x_00096= g_x(1);
         tmp_x_00096= x(1);
         g_tmp_dfovec_1d_00135= g_tmp_x_00095* tmp_x_00096+ tmp_x_00095* g_tmp_x_00096;
         tmp_dfovec_1d_00135= tmp_x_00095* tmp_x_00096;
         g_tmp_x_00097= g_x(8);
         tmp_x_00097= x(8);
         g_tmp_x_00098= g_x(2);
         tmp_x_00098= x(2);
         g_tmp_dfovec_1d_00136= g_tmp_x_00097* tmp_x_00098+ tmp_x_00097* g_tmp_x_00098;
         tmp_dfovec_1d_00136= tmp_x_00097* tmp_x_00098;
         g_tmp_x_00099= g_x(5);
         tmp_x_00099= x(5);
         g_tmp_x_00100= g_x(3);
         tmp_x_00100= x(3);
         g_tmp_dfovec_1d_00137= g_tmp_x_00099* tmp_x_00100+ tmp_x_00099* g_tmp_x_00100;
         tmp_dfovec_1d_00137= tmp_x_00099* tmp_x_00100;
         g_tmp_x_00101= g_x(6);
         tmp_x_00101= x(6);
         g_tmp_x_00102= g_x(4);
         tmp_x_00102= x(4);
         g_tmp_dfovec_1d_00138= g_tmp_x_00101* tmp_x_00102+ tmp_x_00101* g_tmp_x_00102;
         tmp_dfovec_1d_00138= tmp_x_00101* tmp_x_00102;
         g_fvec(4)= g_tmp_dfovec_1d_00135+ g_tmp_dfovec_1d_00136+ g_tmp_dfovec_1d_00137+ g_tmp_dfovec_1d_00138;
         fvec(4)= tmp_dfovec_1d_00135+ tmp_dfovec_1d_00136+ tmp_dfovec_1d_00137+ tmp_dfovec_1d_00138+ 1.31; 
         g_tmp_x_00103= g_x(1);
         tmp_x_00103= x(1);
         g_tmp_x_00104= g_x(5);
         tmp_x_00104= x(5);
         g_tmp_dfovec_1d_00139= adimat_g_pow_left(g_tmp_x_00104, tmp_x_00104, 2);
         tmp_dfovec_1d_00139= tmp_x_00104^ 2;
         g_tmp_x_00105= g_x(7);
         tmp_x_00105= x(7);
         g_tmp_dfovec_1d_00140= adimat_g_pow_left(g_tmp_x_00105, tmp_x_00105, 2);
         tmp_dfovec_1d_00140= tmp_x_00105^ 2;
         g_tmp_dfovec_1d_00141= g_tmp_dfovec_1d_00139- g_tmp_dfovec_1d_00140;
         tmp_dfovec_1d_00141= tmp_dfovec_1d_00139- tmp_dfovec_1d_00140;
         g_tmp_dfovec_1d_00142= g_tmp_x_00103* tmp_dfovec_1d_00141+ tmp_x_00103* g_tmp_dfovec_1d_00141;
         tmp_dfovec_1d_00142= tmp_x_00103* tmp_dfovec_1d_00141;
         g_tmp_x_00106= g_x(3);
         tmp_x_00106= x(3);
         g_tmp_dfovec_1d_00143= 2.0* g_tmp_x_00106* tmp_x_00104* tmp_x_00105+ 2.0* tmp_x_00106* g_tmp_x_00104* tmp_x_00105+ 2.0* tmp_x_00106* tmp_x_00104* g_tmp_x_00105;
         tmp_dfovec_1d_00143= 2.0* tmp_x_00106* tmp_x_00104* tmp_x_00105;
         g_tmp_x_00107= g_x(2);
         tmp_x_00107= x(2);
         g_tmp_x_00108= g_x(6);
         tmp_x_00108= x(6);
         g_tmp_dfovec_1d_00144= adimat_g_pow_left(g_tmp_x_00108, tmp_x_00108, 2);
         tmp_dfovec_1d_00144= tmp_x_00108^ 2;
         g_tmp_x_00109= g_x(8);
         tmp_x_00109= x(8);
         g_tmp_dfovec_1d_00145= adimat_g_pow_left(g_tmp_x_00109, tmp_x_00109, 2);
         tmp_dfovec_1d_00145= tmp_x_00109^ 2;
         g_tmp_dfovec_1d_00146= g_tmp_dfovec_1d_00144- g_tmp_dfovec_1d_00145;
         tmp_dfovec_1d_00146= tmp_dfovec_1d_00144- tmp_dfovec_1d_00145;
         g_tmp_dfovec_1d_00147= g_tmp_x_00107* tmp_dfovec_1d_00146+ tmp_x_00107* g_tmp_dfovec_1d_00146;
         tmp_dfovec_1d_00147= tmp_x_00107* tmp_dfovec_1d_00146;
         g_tmp_x_00110= g_x(4);
         tmp_x_00110= x(4);
         g_tmp_dfovec_1d_00148= 2.0* g_tmp_x_00110* tmp_x_00108* tmp_x_00109+ 2.0* tmp_x_00110* g_tmp_x_00108* tmp_x_00109+ 2.0* tmp_x_00110* tmp_x_00108* g_tmp_x_00109;
         tmp_dfovec_1d_00148= 2.0* tmp_x_00110* tmp_x_00108* tmp_x_00109;
         g_fvec(5)= g_tmp_dfovec_1d_00142- g_tmp_dfovec_1d_00143+ g_tmp_dfovec_1d_00147- g_tmp_dfovec_1d_00148;
         fvec(5)= tmp_dfovec_1d_00142- tmp_dfovec_1d_00143+ tmp_dfovec_1d_00147- tmp_dfovec_1d_00148+ 2.65; 
         g_tmp_x_00111= g_x(3);
         tmp_x_00111= x(3);
         g_tmp_x_00112= g_x(5);
         tmp_x_00112= x(5);
         g_tmp_dfovec_1d_00149= adimat_g_pow_left(g_tmp_x_00112, tmp_x_00112, 2);
         tmp_dfovec_1d_00149= tmp_x_00112^ 2;
         g_tmp_x_00113= g_x(7);
         tmp_x_00113= x(7);
         g_tmp_dfovec_1d_00150= adimat_g_pow_left(g_tmp_x_00113, tmp_x_00113, 2);
         tmp_dfovec_1d_00150= tmp_x_00113^ 2;
         g_tmp_dfovec_1d_00151= g_tmp_dfovec_1d_00149- g_tmp_dfovec_1d_00150;
         tmp_dfovec_1d_00151= tmp_dfovec_1d_00149- tmp_dfovec_1d_00150;
         g_tmp_dfovec_1d_00152= g_tmp_x_00111* tmp_dfovec_1d_00151+ tmp_x_00111* g_tmp_dfovec_1d_00151;
         tmp_dfovec_1d_00152= tmp_x_00111* tmp_dfovec_1d_00151;
         g_tmp_x_00114= g_x(1);
         tmp_x_00114= x(1);
         g_tmp_dfovec_1d_00153= 2.0* g_tmp_x_00114* tmp_x_00112* tmp_x_00113+ 2.0* tmp_x_00114* g_tmp_x_00112* tmp_x_00113+ 2.0* tmp_x_00114* tmp_x_00112* g_tmp_x_00113;
         tmp_dfovec_1d_00153= 2.0* tmp_x_00114* tmp_x_00112* tmp_x_00113;
         g_tmp_x_00115= g_x(4);
         tmp_x_00115= x(4);
         g_tmp_x_00116= g_x(6);
         tmp_x_00116= x(6);
         g_tmp_dfovec_1d_00154= adimat_g_pow_left(g_tmp_x_00116, tmp_x_00116, 2);
         tmp_dfovec_1d_00154= tmp_x_00116^ 2;
         g_tmp_x_00117= g_x(8);
         tmp_x_00117= x(8);
         g_tmp_dfovec_1d_00155= adimat_g_pow_left(g_tmp_x_00117, tmp_x_00117, 2);
         tmp_dfovec_1d_00155= tmp_x_00117^ 2;
         g_tmp_dfovec_1d_00156= g_tmp_dfovec_1d_00154- g_tmp_dfovec_1d_00155;
         tmp_dfovec_1d_00156= tmp_dfovec_1d_00154- tmp_dfovec_1d_00155;
         g_tmp_dfovec_1d_00157= g_tmp_x_00115* tmp_dfovec_1d_00156+ tmp_x_00115* g_tmp_dfovec_1d_00156;
         tmp_dfovec_1d_00157= tmp_x_00115* tmp_dfovec_1d_00156;
         g_tmp_x_00118= g_x(2);
         tmp_x_00118= x(2);
         g_tmp_dfovec_1d_00158= 2.0* g_tmp_x_00118* tmp_x_00116* tmp_x_00117+ 2.0* tmp_x_00118* g_tmp_x_00116* tmp_x_00117+ 2.0* tmp_x_00118* tmp_x_00116* g_tmp_x_00117;
         tmp_dfovec_1d_00158= 2.0* tmp_x_00118* tmp_x_00116* tmp_x_00117;
         g_fvec(6)= g_tmp_dfovec_1d_00152+ g_tmp_dfovec_1d_00153+ g_tmp_dfovec_1d_00157+ g_tmp_dfovec_1d_00158;
         fvec(6)= tmp_dfovec_1d_00152+ tmp_dfovec_1d_00153+ tmp_dfovec_1d_00157+ tmp_dfovec_1d_00158- 2.0; 
         g_tmp_x_00119= g_x(1);
         tmp_x_00119= x(1);
         g_tmp_x_00120= g_x(5);
         tmp_x_00120= x(5);
         g_tmp_dfovec_1d_00159= adimat_g_pow_left(g_tmp_x_00120, tmp_x_00120, 2);
         tmp_dfovec_1d_00159= tmp_x_00120^ 2;
         g_tmp_x_00121= g_x(7);
         tmp_x_00121= x(7);
         g_tmp_dfovec_1d_00160= adimat_g_pow_left(g_tmp_x_00121, tmp_x_00121, 2);
         tmp_dfovec_1d_00160= tmp_x_00121^ 2;
         g_tmp_dfovec_1d_00161= 3.0* g_tmp_dfovec_1d_00160;
         tmp_dfovec_1d_00161= 3.0* tmp_dfovec_1d_00160;
         g_tmp_dfovec_1d_00162= g_tmp_dfovec_1d_00159- g_tmp_dfovec_1d_00161;
         tmp_dfovec_1d_00162= tmp_dfovec_1d_00159- tmp_dfovec_1d_00161;
         g_tmp_dfovec_1d_00163= g_tmp_x_00119* tmp_x_00120* tmp_dfovec_1d_00162+ tmp_x_00119* g_tmp_x_00120* tmp_dfovec_1d_00162+ tmp_x_00119* tmp_x_00120* g_tmp_dfovec_1d_00162;
         tmp_dfovec_1d_00163= tmp_x_00119* tmp_x_00120* tmp_dfovec_1d_00162;
         g_tmp_x_00122= g_x(3);
         tmp_x_00122= x(3);
         g_tmp_dfovec_1d_00164= 3.0* g_tmp_dfovec_1d_00159;
         tmp_dfovec_1d_00164= 3.0* tmp_dfovec_1d_00159;
         g_tmp_dfovec_1d_00165= g_tmp_dfovec_1d_00160- g_tmp_dfovec_1d_00164;
         tmp_dfovec_1d_00165= tmp_dfovec_1d_00160- tmp_dfovec_1d_00164;
         g_tmp_dfovec_1d_00166= g_tmp_x_00122* tmp_x_00121* tmp_dfovec_1d_00165+ tmp_x_00122* g_tmp_x_00121* tmp_dfovec_1d_00165+ tmp_x_00122* tmp_x_00121* g_tmp_dfovec_1d_00165;
         tmp_dfovec_1d_00166= tmp_x_00122* tmp_x_00121* tmp_dfovec_1d_00165;
         g_tmp_x_00123= g_x(2);
         tmp_x_00123= x(2);
         g_tmp_x_00124= g_x(6);
         tmp_x_00124= x(6);
         g_tmp_dfovec_1d_00167= adimat_g_pow_left(g_tmp_x_00124, tmp_x_00124, 2);
         tmp_dfovec_1d_00167= tmp_x_00124^ 2;
         g_tmp_x_00125= g_x(8);
         tmp_x_00125= x(8);
         g_tmp_dfovec_1d_00168= adimat_g_pow_left(g_tmp_x_00125, tmp_x_00125, 2);
         tmp_dfovec_1d_00168= tmp_x_00125^ 2;
         g_tmp_dfovec_1d_00169= 3.0* g_tmp_dfovec_1d_00168;
         tmp_dfovec_1d_00169= 3.0* tmp_dfovec_1d_00168;
         g_tmp_dfovec_1d_00170= g_tmp_dfovec_1d_00167- g_tmp_dfovec_1d_00169;
         tmp_dfovec_1d_00170= tmp_dfovec_1d_00167- tmp_dfovec_1d_00169;
         g_tmp_dfovec_1d_00171= g_tmp_x_00123* tmp_x_00124* tmp_dfovec_1d_00170+ tmp_x_00123* g_tmp_x_00124* tmp_dfovec_1d_00170+ tmp_x_00123* tmp_x_00124* g_tmp_dfovec_1d_00170;
         tmp_dfovec_1d_00171= tmp_x_00123* tmp_x_00124* tmp_dfovec_1d_00170;
         g_tmp_x_00126= g_x(4);
         tmp_x_00126= x(4);
         g_tmp_dfovec_1d_00172= 3.0* g_tmp_dfovec_1d_00167;
         tmp_dfovec_1d_00172= 3.0* tmp_dfovec_1d_00167;
         g_tmp_dfovec_1d_00173= g_tmp_dfovec_1d_00168- g_tmp_dfovec_1d_00172;
         tmp_dfovec_1d_00173= tmp_dfovec_1d_00168- tmp_dfovec_1d_00172;
         g_tmp_dfovec_1d_00174= g_tmp_x_00126* tmp_x_00125* tmp_dfovec_1d_00173+ tmp_x_00126* g_tmp_x_00125* tmp_dfovec_1d_00173+ tmp_x_00126* tmp_x_00125* g_tmp_dfovec_1d_00173;
         tmp_dfovec_1d_00174= tmp_x_00126* tmp_x_00125* tmp_dfovec_1d_00173;
         g_fvec(7)= g_tmp_dfovec_1d_00163+ g_tmp_dfovec_1d_00166+ g_tmp_dfovec_1d_00171+ g_tmp_dfovec_1d_00174;
         fvec(7)= tmp_dfovec_1d_00163+ tmp_dfovec_1d_00166+ tmp_dfovec_1d_00171+ tmp_dfovec_1d_00174+ 12.6; 
         g_tmp_x_00127= g_x(3);
         tmp_x_00127= x(3);
         g_tmp_x_00128= g_x(5);
         tmp_x_00128= x(5);
         g_tmp_dfovec_1d_00175= adimat_g_pow_left(g_tmp_x_00128, tmp_x_00128, 2);
         tmp_dfovec_1d_00175= tmp_x_00128^ 2;
         g_tmp_x_00129= g_x(7);
         tmp_x_00129= x(7);
         g_tmp_dfovec_1d_00176= adimat_g_pow_left(g_tmp_x_00129, tmp_x_00129, 2);
         tmp_dfovec_1d_00176= tmp_x_00129^ 2;
         g_tmp_dfovec_1d_00177= 3.0* g_tmp_dfovec_1d_00176;
         tmp_dfovec_1d_00177= 3.0* tmp_dfovec_1d_00176;
         g_tmp_dfovec_1d_00178= g_tmp_dfovec_1d_00175- g_tmp_dfovec_1d_00177;
         tmp_dfovec_1d_00178= tmp_dfovec_1d_00175- tmp_dfovec_1d_00177;
         g_tmp_dfovec_1d_00179= g_tmp_x_00127* tmp_x_00128* tmp_dfovec_1d_00178+ tmp_x_00127* g_tmp_x_00128* tmp_dfovec_1d_00178+ tmp_x_00127* tmp_x_00128* g_tmp_dfovec_1d_00178;
         tmp_dfovec_1d_00179= tmp_x_00127* tmp_x_00128* tmp_dfovec_1d_00178;
         g_tmp_x_00130= g_x(1);
         tmp_x_00130= x(1);
         g_tmp_dfovec_1d_00180= 3.0* g_tmp_dfovec_1d_00175;
         tmp_dfovec_1d_00180= 3.0* tmp_dfovec_1d_00175;
         g_tmp_dfovec_1d_00181= g_tmp_dfovec_1d_00176- g_tmp_dfovec_1d_00180;
         tmp_dfovec_1d_00181= tmp_dfovec_1d_00176- tmp_dfovec_1d_00180;
         g_tmp_dfovec_1d_00182= g_tmp_x_00130* tmp_x_00129* tmp_dfovec_1d_00181+ tmp_x_00130* g_tmp_x_00129* tmp_dfovec_1d_00181+ tmp_x_00130* tmp_x_00129* g_tmp_dfovec_1d_00181;
         tmp_dfovec_1d_00182= tmp_x_00130* tmp_x_00129* tmp_dfovec_1d_00181;
         g_tmp_x_00131= g_x(4);
         tmp_x_00131= x(4);
         g_tmp_x_00132= g_x(6);
         tmp_x_00132= x(6);
         g_tmp_dfovec_1d_00183= adimat_g_pow_left(g_tmp_x_00132, tmp_x_00132, 2);
         tmp_dfovec_1d_00183= tmp_x_00132^ 2;
         g_tmp_x_00133= g_x(8);
         tmp_x_00133= x(8);
         g_tmp_dfovec_1d_00184= adimat_g_pow_left(g_tmp_x_00133, tmp_x_00133, 2);
         tmp_dfovec_1d_00184= tmp_x_00133^ 2;
         g_tmp_dfovec_1d_00185= 3.0* g_tmp_dfovec_1d_00184;
         tmp_dfovec_1d_00185= 3.0* tmp_dfovec_1d_00184;
         g_tmp_dfovec_1d_00186= g_tmp_dfovec_1d_00183- g_tmp_dfovec_1d_00185;
         tmp_dfovec_1d_00186= tmp_dfovec_1d_00183- tmp_dfovec_1d_00185;
         g_tmp_dfovec_1d_00187= g_tmp_x_00131* tmp_x_00132* tmp_dfovec_1d_00186+ tmp_x_00131* g_tmp_x_00132* tmp_dfovec_1d_00186+ tmp_x_00131* tmp_x_00132* g_tmp_dfovec_1d_00186;
         tmp_dfovec_1d_00187= tmp_x_00131* tmp_x_00132* tmp_dfovec_1d_00186;
         g_tmp_x_00134= g_x(2);
         tmp_x_00134= x(2);
         g_tmp_dfovec_1d_00188= 3.0* g_tmp_dfovec_1d_00183;
         tmp_dfovec_1d_00188= 3.0* tmp_dfovec_1d_00183;
         g_tmp_dfovec_1d_00189= g_tmp_dfovec_1d_00184- g_tmp_dfovec_1d_00188;
         tmp_dfovec_1d_00189= tmp_dfovec_1d_00184- tmp_dfovec_1d_00188;
         g_tmp_dfovec_1d_00190= g_tmp_x_00134* tmp_x_00133* tmp_dfovec_1d_00189+ tmp_x_00134* g_tmp_x_00133* tmp_dfovec_1d_00189+ tmp_x_00134* tmp_x_00133* g_tmp_dfovec_1d_00189;
         tmp_dfovec_1d_00190= tmp_x_00134* tmp_x_00133* tmp_dfovec_1d_00189;
         g_fvec(8)= g_tmp_dfovec_1d_00179- g_tmp_dfovec_1d_00182+ g_tmp_dfovec_1d_00187- g_tmp_dfovec_1d_00190;
         fvec(8)= tmp_dfovec_1d_00179- tmp_dfovec_1d_00182+ tmp_dfovec_1d_00187- tmp_dfovec_1d_00190- 9.48; 
         
   end
   
   % The one helper function left over from adimat
   function [g_z z] = adimat_g_pow_left(g_a, a, b)
        z = a^b;
        if isscalar(a) && isscalar(b)
            g_z = g_a .* b .* (a .^ (b - 1));
        elseif isscalar(b)
            if b == 1
                g_z = g_a;
            elseif mod(b, 1) == 0 && b > 1
                g_z = g_a * (a^(b-1));
                for i=1:b-1
                    g_z = g_z + (a^i) * g_a * (a^(b-i-1));
                end
            else
                error('adimat:adimat_g_pow', '%s', ...
                    ['Differentiation of A^b, where A is a square matrix and b is scalar, ' ...
                    'but not an integer > 1, is not supported.']);
            end
        elseif isscalar(a)
            error('adimat:adimat_g_pow', '%s', ...
                ['Differentiation of a^B, where a is scalar and B is a ' ...
                'square matrix, is not supported.']);
        else
            error('adimat:adimat_g_pow', '%s', ...
                'A^B, where both X and Y are matrices, is not allowed in Matlab');
        end
    end
end
