//   Copyright Naoki Shibata and contributors 2010 - 2021.
// Distributed under the Boost Software License, Version 1.0.
//        (See http://www.boost.org/LICENSE_1_0.txt)

// This file is generated by SLEEF 3.6.1

#ifndef SLEEF_ALWAYS_INLINE
#if defined (__GNUC__) || defined (__clang__) || defined(__INTEL_COMPILER)
#define SLEEF_ALWAYS_INLINE inline __attribute__((always_inline))
#elif defined(_MSC_VER)
#define SLEEF_ALWAYS_INLINE inline __forceinline
#else
#define SLEEF_ALWAYS_INLINE inline
#endif
#endif

#ifndef SLEEF_INLINE
#define SLEEF_INLINE static inline
#endif

#ifndef SLEEF_CONST
#define SLEEF_CONST
#endif

#if defined(_MSC_VER) && !defined (__clang__)
#pragma fp_contract (off)
#else
#pragma STDC FP_CONTRACT OFF
#endif

#ifndef SLEEF_FP_ILOGB0
#define SLEEF_FP_ILOGB0 ((int)0x80000000)
#endif

#ifndef SLEEF_FP_ILOGBNAN
#define SLEEF_FP_ILOGBNAN ((int)2147483647)
#endif

#define SLEEFINLINE_RVVM1_H_INCLUDED

#ifndef __SLEEF_REMPITAB__
#define __SLEEF_REMPITAB__
static const double Sleef_rempitabdp[] = {
  0.15915494309189531785, 1.7916237278037667488e-17, 2.5454160968749269937e-33, 2.1132476107887107169e-49,
  0.03415494309189533173, 4.0384494702232122736e-18, 1.0046721413651383112e-33, 2.1132476107887107169e-49,
  0.03415494309189533173, 4.0384494702232122736e-18, 1.0046721413651383112e-33, 2.1132476107887107169e-49,
  0.0029049430918953351999, 5.6900251826959904774e-19, 4.1707169171520598517e-35, -2.496415728504571394e-51,
  0.0029049430918953351999, 5.6900251826959904774e-19, 4.1707169171520598517e-35, -2.496415728504571394e-51,
  0.0029049430918953351999, 5.6900251826959904774e-19, 4.1707169171520598517e-35, -2.496415728504571394e-51,
  0.0029049430918953351999, 5.6900251826959904774e-19, 4.1707169171520598517e-35, -2.496415728504571394e-51,
  0.00095181809189533563356, 1.3532164927539732229e-19, -6.4410794381603004826e-36, 1.7634898158762436344e-52,
  0.00095181809189533563356, 1.3532164927539732229e-19, -6.4410794381603004826e-36, 1.7634898158762436344e-52,
  0.00046353684189533574198, 2.6901432026846872871e-20, -4.2254836195018827479e-37, 9.301187206862134399e-54,
  0.00021939621689533574198, 2.6901432026846872871e-20, -4.2254836195018827479e-37, 9.301187206862134399e-54,
  9.7325904395335769087e-05, -2.0362228529073840241e-22, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  3.6290748145335769087e-05, -2.0362228529073840241e-22, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  5.7731700203357690874e-06, -2.0362228529073840241e-22, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  5.7731700203357690874e-06, -2.0362228529073840241e-22, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  5.7731700203357690874e-06, -2.0362228529073840241e-22, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  1.9584727547107690874e-06, -2.0362228529073840241e-22, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  5.1124121898268875627e-08, 8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  5.1124121898268875627e-08, 8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  5.1124121898268875627e-08, 8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  5.1124121898268875627e-08, 8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  5.1124121898268875627e-08, 8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  5.1124121898268875627e-08, 8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369025999e-57,
  2.1321799510573569745e-08, 1.5185066224124613304e-24, 2.6226236120327253511e-40, 2.6283399642369025999e-57,
  6.4206383167259151492e-09, -1.3585460269359374382e-25, -1.3244127270701094468e-41, -2.4695541513869446866e-57,
  6.4206383167259151492e-09, -1.3585460269359374382e-25, -1.3244127270701094468e-41, -2.4695541513869446866e-57,
  2.6953480182640010867e-09, -1.3585460269359374382e-25, -1.3244127270701094468e-41, -2.4695541513869446866e-57,
  8.3270286903304384868e-10, 7.0940550444663151936e-26, 9.7147467687967058732e-42, 7.9392906424978921242e-59,
  8.3270286903304384868e-10, 7.0940550444663151936e-26, 9.7147467687967058732e-42, 7.9392906424978921242e-59,
  3.6704158172530459087e-10, 7.0940550444663151936e-26, 9.7147467687967058732e-42, 7.9392906424978921242e-59,
  1.3421093807143501366e-10, 1.9241762160098927996e-26, 3.9750282589222551507e-42, 7.9392906424978921242e-59,
  1.7795616244500218596e-11, -1.452834466126541428e-28, -1.5869767474823787636e-44, -2.6168913164368963837e-61,
  1.7795616244500218596e-11, -1.452834466126541428e-28, -1.5869767474823787636e-44, -2.6168913164368963837e-61,
  1.7795616244500218596e-11, -1.452834466126541428e-28, -1.5869767474823787636e-44, -2.6168913164368963837e-61,
  3.2437010161333667893e-12, -1.452834466126541428e-28, -1.5869767474823787636e-44, -2.6168913164368963837e-61,
  3.2437010161333667893e-12, -1.452834466126541428e-28, -1.5869767474823787636e-44, -2.6168913164368963837e-61,
  3.2437010161333667893e-12, -1.452834466126541428e-28, -1.5869767474823787636e-44, -2.6168913164368963837e-61,
  1.4247116125875099096e-12, 2.5861333686050385673e-28, 2.8971783383570358633e-44, -2.6168913164368963837e-61,
  5.1521691081458187359e-13, 5.6664945123924856962e-29, 6.5510079543732854985e-45, -2.6168913164368963837e-61,
  6.0469559928117805118e-14, 6.1778471897801070206e-30, 9.4581409707401690366e-46, 4.9461632249367446986e-62,
  6.0469559928117805118e-14, 6.1778471897801070206e-30, 9.4581409707401690366e-46, 4.9461632249367446986e-62,
  6.0469559928117805118e-14, 6.1778471897801070206e-30, 9.4581409707401690366e-46, 4.9461632249367446986e-62,
  3.6261410673097965595e-15, -1.3304005198798645927e-31, -1.7578597149294783985e-47, 8.4432539107728104262e-64,
  3.6261410673097965595e-15, -1.3304005198798645927e-31, -1.7578597149294783985e-47, 8.4432539107728104262e-64,
  3.6261410673097965595e-15, -1.3304005198798645927e-31, -1.7578597149294783985e-47, 8.4432539107728104262e-64,
  3.6261410673097965595e-15, -1.3304005198798645927e-31, -1.7578597149294783985e-47, 8.4432539107728104262e-64,
  7.3427388509295482183e-17, 1.4871367740953237822e-32, -1.1571307704883330232e-48, -6.7249112515659578102e-65,
  7.3427388509295482183e-17, 1.4871367740953237822e-32, -1.1571307704883330232e-48, -6.7249112515659578102e-65,
  7.3427388509295482183e-17, 1.4871367740953237822e-32, -1.1571307704883330232e-48, -6.7249112515659578102e-65,
  7.3427388509295482183e-17, 1.4871367740953237822e-32, -1.1571307704883330232e-48, -6.7249112515659578102e-65,
  7.3427388509295482183e-17, 1.4871367740953237822e-32, -1.1571307704883330232e-48, -6.7249112515659578102e-65,
  7.3427388509295482183e-17, 1.4871367740953237822e-32, -1.1571307704883330232e-48, -6.7249112515659578102e-65,
  1.7916237278037667488e-17, 2.5454160968749269937e-33, 2.1132476107887107169e-49, 8.7154294504188129325e-66,
  1.7916237278037667488e-17, 2.5454160968749269937e-33, 2.1132476107887107169e-49, 8.7154294504188129325e-66,
  4.0384494702232122736e-18, 1.0046721413651383112e-33, 2.1132476107887107169e-49, 8.7154294504188129325e-66,
  4.0384494702232122736e-18, 1.0046721413651383112e-33, 2.1132476107887107169e-49, 8.7154294504188129325e-66,
  5.6900251826959904774e-19, 4.1707169171520598517e-35, -2.4964157285045710972e-51, -1.866653112309982615e-67,
  5.6900251826959904774e-19, 4.1707169171520598517e-35, -2.4964157285045710972e-51, -1.866653112309982615e-67,
  5.6900251826959904774e-19, 4.1707169171520598517e-35, -2.4964157285045710972e-51, -1.866653112309982615e-67,
  1.3532164927539732229e-19, -6.4410794381603004826e-36, 1.7634898158762432635e-52, 3.5887057810247033998e-68,
  1.3532164927539732229e-19, -6.4410794381603004826e-36, 1.7634898158762432635e-52, 3.5887057810247033998e-68,
  2.6901432026846872871e-20, -4.2254836195018827479e-37, 9.3011872068621332399e-54, 1.113250147552460308e-69,
  2.6901432026846872871e-20, -4.2254836195018827479e-37, 9.3011872068621332399e-54, 1.113250147552460308e-69,
  2.6901432026846872871e-20, -4.2254836195018827479e-37, 9.3011872068621332399e-54, 1.113250147552460308e-69,
  1.3348904870778067446e-20, -4.2254836195018827479e-37, 9.3011872068621332399e-54, 1.113250147552460308e-69,
  6.5726412927436632287e-21, 1.0820844071023395684e-36, 1.7634898158762432635e-52, 3.5887057810247033998e-68,
  3.1845095037264626247e-21, 3.2976802257607573031e-37, 9.3011872068621332399e-54, 1.113250147552460308e-69,
  1.4904436092178623228e-21, -4.6390169687056261795e-38, -1.1392999419355048437e-54, -4.587677453735884283e-71,
  6.4341066196356198368e-22, -4.6390169687056261795e-38, -1.1392999419355048437e-54, -4.587677453735884283e-71,
  2.1989418833641172011e-22, 4.7649378378726728402e-38, 9.3011872068621332399e-54, 1.113250147552460308e-69,
  8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73,
  8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73,
  8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73,
  8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73,
  8.135951522836682362e-24, 6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73,
  1.5185066224124613304e-24, 2.6226236120327253511e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73,
  1.5185066224124613304e-24, 2.6226236120327253511e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73,
  1.5185066224124613304e-24, 2.6226236120327253511e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73,
  6.9132600985943383921e-25, 7.8591368887290111994e-41, 2.6283399642369020339e-57, 5.3358074162805516304e-73,
  2.7773570358292009361e-25, -1.3244127270701094468e-41, -2.4695541513869446866e-57, -3.2399200798614356002e-74,
  7.0940550444663151936e-26, 9.7147467687967058732e-42, 7.9392906424978921242e-59, 2.9745456030524896742e-75,
  7.0940550444663151936e-26, 9.7147467687967058732e-42, 7.9392906424978921242e-59, 2.9745456030524896742e-75,
  1.9241762160098927996e-26, 3.9750282589222551507e-42, 7.9392906424978921242e-59, 2.9745456030524896742e-75,
  1.9241762160098927996e-26, 3.9750282589222551507e-42, 7.9392906424978921242e-59, 2.9745456030524896742e-75,
  6.317065088957874881e-27, -3.2976062348358281152e-43, -2.6168913164368963837e-61, 3.7036201000008290615e-78,
  6.317065088957874881e-27, -3.2976062348358281152e-43, -2.6168913164368963837e-61, 3.7036201000008290615e-78,
  3.0858908211726098086e-27, 3.8770419025072344914e-43, 7.9392906424978921242e-59, 2.9745456030524896742e-75,
  1.4703036872799779898e-27, 2.8971783383570358633e-44, -2.6168913164368963837e-61, 3.7036201000008290615e-78,
  6.625101203336619011e-28, 2.8971783383570358633e-44, -2.6168913164368963837e-61, 3.7036201000008290615e-78,
  2.5861333686050385673e-28, 2.8971783383570358633e-44, -2.6168913164368963837e-61, 3.7036201000008290615e-78,
  5.6664945123924856962e-29, 6.5510079543732854985e-45, -2.6168913164368963837e-61, 3.7036201000008290615e-78,
  5.6664945123924856962e-29, 6.5510079543732854985e-45, -2.6168913164368963837e-61, 3.7036201000008290615e-78,
  6.1778471897801070206e-30, 9.4581409707401690366e-46, 4.9461632249367446986e-62, 3.7036201000008290615e-78,
  6.1778471897801070206e-30, 9.4581409707401690366e-46, 4.9461632249367446986e-62, 3.7036201000008290615e-78,
  6.1778471897801070206e-30, 9.4581409707401690366e-46, 4.9461632249367446986e-62, 3.7036201000008290615e-78,
  6.1778471897801070206e-30, 9.4581409707401690366e-46, 4.9461632249367446986e-62, 3.7036201000008290615e-78,
  3.0224035688960604996e-30, 2.451648649116083682e-46, 4.9461632249367446986e-62, 3.7036201000008290615e-78,
  1.4446817584540368888e-30, 2.451648649116083682e-46, 4.9461632249367446986e-62, 3.7036201000008290615e-78,
  6.5582085323302525856e-31, 7.0002556871006273225e-47, 1.0567786762735315635e-62, -6.1446417754639313137e-79,
  2.6139040062251944343e-31, -1.7578597149294783985e-47, 8.4432539107728090768e-64, 1.9517662449371102229e-79,
  6.4175174317266470186e-32, 4.3166913557804827486e-48, 8.4432539107728090768e-64, 1.9517662449371102229e-79,
  6.4175174317266470186e-32, 4.3166913557804827486e-48, 8.4432539107728090768e-64, 1.9517662449371102229e-79,
  1.4871367740953237822e-32, -1.1571307704883330232e-48, -6.7249112515659569668e-65, -7.2335760163150273591e-81,
  1.4871367740953237822e-32, -1.1571307704883330232e-48, -6.7249112515659569668e-65, -7.2335760163150273591e-81,
  2.5454160968749269937e-33, 2.1132476107887107169e-49, 8.7154294504188118783e-66, 1.2001823382693912203e-81,
  2.5454160968749269937e-33, 2.1132476107887107169e-49, 8.7154294504188118783e-66, 1.2001823382693912203e-81,
  2.5454160968749269937e-33, 2.1132476107887107169e-49, 8.7154294504188118783e-66, 1.2001823382693912203e-81,
  1.0046721413651383112e-33, 2.1132476107887107169e-49, 8.7154294504188118783e-66, 1.2001823382693912203e-81,
  2.3430016361024414106e-34, 4.0267819632970559834e-50, -7.8013829534098555144e-67, -1.1759240463442418271e-82,
  2.3430016361024414106e-34, 4.0267819632970559834e-50, -7.8013829534098555144e-67, -1.1759240463442418271e-82,
  4.1707169171520598517e-35, -2.4964157285045710972e-51, -1.866653112309982615e-67, 1.4185069655957361252e-83,
  4.1707169171520598517e-35, -2.4964157285045710972e-51, -1.866653112309982615e-67, 1.4185069655957361252e-83,
  4.1707169171520598517e-35, -2.4964157285045710972e-51, -1.866653112309982615e-67, 1.4185069655957361252e-83,
  1.7633044866680145008e-35, 2.8491136916798196016e-51, 4.0680767287898916022e-67, 1.4185069655957361252e-83,
  5.595982714259923599e-36, 1.7634898158762432635e-52, 3.588705781024702988e-68, 5.9489775128085140685e-84,
  5.595982714259923599e-36, 1.7634898158762432635e-52, 3.588705781024702988e-68, 5.9489775128085140685e-84,
  2.5867171761548675786e-36, 1.7634898158762432635e-52, 3.588705781024702988e-68, 5.9489775128085140685e-84,
  1.0820844071023395684e-36, 1.7634898158762432635e-52, 3.588705781024702988e-68, 5.9489775128085140685e-84,
  3.2976802257607573031e-37, 9.3011872068621332399e-54, 1.113250147552460308e-69, 2.9286284920280944778e-86,
  3.2976802257607573031e-37, 9.3011872068621332399e-54, 1.113250147552460308e-69, 2.9286284920280944778e-86,
  1.4168892644450972904e-37, 9.3011872068621332399e-54, 1.113250147552460308e-69, 2.9286284920280944778e-86,
  4.7649378378726728402e-38, 9.3011872068621332399e-54, 1.113250147552460308e-69, 2.9286284920280944778e-86,
  6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  6.2960434583523738135e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  2.6226236120327253511e-40, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  7.8591368887290111994e-41, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  7.8591368887290111994e-41, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  3.2673620808294506214e-41, 2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.524218473063975309e-90,
  9.7147467687967058732e-42, 7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257943935e-91,
  9.7147467687967058732e-42, 7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257943935e-91,
  3.9750282589222551507e-42, 7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257943935e-91,
  1.1051690039850297894e-42, 7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257943935e-91,
  1.1051690039850297894e-42, 7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257943935e-91,
  3.8770419025072344914e-43, 7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257943935e-91,
  2.8971783383570358633e-44, -2.6168913164368963837e-61, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  2.8971783383570358633e-44, -2.6168913164368963837e-61, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  2.8971783383570358633e-44, -2.6168913164368963837e-61, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  2.8971783383570358633e-44, -2.6168913164368963837e-61, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  6.5510079543732854985e-45, -2.6168913164368963837e-61, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  6.5510079543732854985e-45, -2.6168913164368963837e-61, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  9.4581409707401690366e-46, 4.9461632249367446986e-62, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  9.4581409707401690366e-46, 4.9461632249367446986e-62, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  9.4581409707401690366e-46, 4.9461632249367446986e-62, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  2.451648649116083682e-46, 4.9461632249367446986e-62, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  2.451648649116083682e-46, 4.9461632249367446986e-62, 3.7036201000008285821e-78, 5.6554937751584084315e-94,
  7.0002556871006273225e-47, 1.0567786762735315635e-62, -6.1446417754639301152e-79, -1.5355611056488084652e-94,
  7.0002556871006273225e-47, 1.0567786762735315635e-62, -6.1446417754639301152e-79, -1.5355611056488084652e-94,
  2.6211979860855749482e-47, 8.4432539107728090768e-64, 1.9517662449371099233e-79, 2.62202614552995759e-95,
  4.3166913557804827486e-48, 8.4432539107728090768e-64, 1.9517662449371099233e-79, 2.62202614552995759e-95,
  4.3166913557804827486e-48, 8.4432539107728090768e-64, 1.9517662449371099233e-79, 2.62202614552995759e-95,
  4.3166913557804827486e-48, 8.4432539107728090768e-64, 1.9517662449371099233e-79, 2.62202614552995759e-95,
  1.5797802926460750146e-48, 2.3660905534865399025e-64, -7.2335760163150273591e-81, 2.8738690232659205689e-99,
  2.1132476107887107169e-49, 8.7154294504188118783e-66, 1.2001823382693912203e-81, 2.8738690232659205689e-99,
  2.1132476107887107169e-49, 8.7154294504188118783e-66, 1.2001823382693912203e-81, 2.8738690232659205689e-99,
  2.1132476107887107169e-49, 8.7154294504188118783e-66, 1.2001823382693912203e-81, 2.8738690232659205689e-99,
  4.0267819632970559834e-50, -7.8013829534098555144e-67, -1.1759240463442418271e-82, 2.8738690232659205689e-99,
  4.0267819632970559834e-50, -7.8013829534098555144e-67, -1.1759240463442418271e-82, 2.8738690232659205689e-99,
  4.0267819632970559834e-50, -7.8013829534098555144e-67, -1.1759240463442418271e-82, 2.8738690232659205689e-99,
  1.8885701952232994665e-50, -7.8013829534098555144e-67, -1.1759240463442418271e-82, 2.8738690232659205689e-99,
  8.1946431118642097069e-51, 1.5937536410989638719e-66, 1.459625439463388979e-82, 2.8738690232659205689e-99,
  2.8491136916798196016e-51, 4.0680767287898916022e-67, 1.4185069655957361252e-83, -7.8369062883735917115e-100,
  1.7634898158762432635e-52, 3.588705781024702988e-68, 5.9489775128085131541e-84, 1.0450891972142808004e-99,
  1.7634898158762432635e-52, 3.588705781024702988e-68, 5.9489775128085131541e-84, 1.0450891972142808004e-99,
  1.7634898158762432635e-52, 3.588705781024702988e-68, 5.9489775128085131541e-84, 1.0450891972142808004e-99,
  1.7634898158762432635e-52, 3.588705781024702988e-68, 5.9489775128085131541e-84, 1.0450891972142808004e-99,
  9.3011872068621332399e-54, 1.113250147552460308e-69, 2.9286284920280941206e-86, 2.1132026692048600853e-102,
  9.3011872068621332399e-54, 1.113250147552460308e-69, 2.9286284920280941206e-86, 2.1132026692048600853e-102,
  9.3011872068621332399e-54, 1.113250147552460308e-69, 2.9286284920280941206e-86, 2.1132026692048600853e-102,
  9.3011872068621332399e-54, 1.113250147552460308e-69, 2.9286284920280941206e-86, 2.1132026692048600853e-102,
  9.3011872068621332399e-54, 1.113250147552460308e-69, 2.9286284920280941206e-86, 2.1132026692048600853e-102,
  4.0809436324633147776e-54, -4.587677453735884283e-71, -2.8859500138942368532e-87, -5.6567402911297190423e-103,
  1.470821845263904967e-54, -4.587677453735884283e-71, -2.8859500138942368532e-87, -5.6567402911297190423e-103,
  1.6576095166419998917e-55, 2.6568658093254848067e-71, 5.1571087196495574384e-87, 3.2728487032630537605e-103,
  1.6576095166419998917e-55, 2.6568658093254848067e-71, 5.1571087196495574384e-87, 3.2728487032630537605e-103,
  1.6576095166419998917e-55, 2.6568658093254848067e-71, 5.1571087196495574384e-87, 3.2728487032630537605e-103,
  2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.5242184730639744369e-90, 1.145584788913072936e-105,
  2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.5242184730639744369e-90, 1.145584788913072936e-105,
  2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.5242184730639744369e-90, 1.145584788913072936e-105,
  2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.5242184730639744369e-90, 1.145584788913072936e-105,
  2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.5242184730639744369e-90, 1.145584788913072936e-105,
  2.6283399642369020339e-57, 5.3358074162805516304e-73, 4.5242184730639744369e-90, 1.145584788913072936e-105,
  7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257942845e-91, 5.554706987098633963e-107,
  7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257942845e-91, 5.554706987098633963e-107,
  7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257942845e-91, 5.554706987098633963e-107,
  7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257942845e-91, 5.554706987098633963e-107,
  7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257942845e-91, 5.554706987098633963e-107,
  7.9392906424978921242e-59, 2.9745456030524891833e-75, 5.969437008257942845e-91, 5.554706987098633963e-107,
  3.9565608646667614317e-59, 2.9745456030524891833e-75, 5.969437008257942845e-91, 5.554706987098633963e-107,
  1.9651959757511960854e-59, 2.9745456030524891833e-75, 5.969437008257942845e-91, 5.554706987098633963e-107,
  9.6951353129341363331e-60, 7.6368645294831185015e-76, 1.0603435429602168369e-91, 1.0451839188820145747e-108,
  4.7167230906452229674e-60, 7.6368645294831185015e-76, 1.0603435429602168369e-91, 1.0451839188820145747e-108,
  2.2275169795007668372e-60, 2.1097166542226745549e-76, 4.4670685979800101779e-92, 1.0451839188820145747e-108,
  9.8291392392853877215e-61, -6.5385728340754726503e-77, -1.3520652573660833788e-93, -2.3220403312043059402e-109,
  3.6061239614242446325e-61, 7.2792968540756372162e-77, 1.3988851821689310822e-92, 1.0451839188820145747e-108,
  4.9461632249367446986e-62, 3.7036201000008285821e-78, 5.6554937751584084315e-94, -1.9306041120023063932e-110,
  4.9461632249367446986e-62, 3.7036201000008285821e-78, 5.6554937751584084315e-94, -1.9306041120023063932e-110,
  4.9461632249367446986e-62, 3.7036201000008285821e-78, 5.6554937751584084315e-94, -1.9306041120023063932e-110,
  1.0567786762735315635e-62, -6.1446417754639301152e-79, -1.535561105648808199e-94, -1.9306041120023063932e-110,
  1.0567786762735315635e-62, -6.1446417754639301152e-79, -1.535561105648808199e-94, -1.9306041120023063932e-110,
  8.4432539107728090768e-64, 1.9517662449371099233e-79, 2.62202614552995759e-95, 6.5314563001514358328e-112,
  8.4432539107728090768e-64, 1.9517662449371099233e-79, 2.62202614552995759e-95, 6.5314563001514358328e-112,
  8.4432539107728090768e-64, 1.9517662449371099233e-79, 2.62202614552995759e-95, 6.5314563001514358328e-112,
  8.4432539107728090768e-64, 1.9517662449371099233e-79, 2.62202614552995759e-95, 6.5314563001514358328e-112,
  2.3660905534865399025e-64, -7.2335760163150273591e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115,
  2.3660905534865399025e-64, -7.2335760163150273591e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115,
  8.4679971416497210292e-65, -7.2335760163150273591e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115,
  8.7154294504188118783e-66, 1.2001823382693912203e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115,
  8.7154294504188118783e-66, 1.2001823382693912203e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115,
  8.7154294504188118783e-66, 1.2001823382693912203e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115,
  8.7154294504188118783e-66, 1.2001823382693912203e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115,
  3.9676455775389135587e-66, 1.459625439463388979e-82, 2.8738690232659205689e-99, 1.8395411057335783574e-115,
  1.5937536410989638719e-66, 1.459625439463388979e-82, 2.8738690232659205689e-99, 1.8395411057335783574e-115,
  4.0680767287898916022e-67, 1.4185069655957361252e-83, -7.8369062883735917115e-100, -1.9081236411894110579e-116,
  4.0680767287898916022e-67, 1.4185069655957361252e-83, -7.8369062883735917115e-100, -1.9081236411894110579e-116,
  1.1007118082399544936e-67, 1.4185069655957361252e-83, -7.8369062883735917115e-100, -1.9081236411894110579e-116,
  1.1007118082399544936e-67, 1.4185069655957361252e-83, -7.8369062883735917115e-100, -1.9081236411894110579e-116,
  3.588705781024702988e-68, 5.9489775128085131541e-84, 1.0450891972142805974e-99, 1.8395411057335783574e-115,
  3.588705781024702988e-68, 5.9489775128085131541e-84, 1.0450891972142805974e-99, 1.8395411057335783574e-115,
  1.7341027056809927069e-68, 1.830931441234090934e-84, 1.3069928418846076386e-100, 3.1677600334418876704e-116,
  8.0680116800913756637e-69, -2.2809159455312046184e-85, -4.0748824503880445403e-101, -6.3915272253158644628e-117,
  3.4315039917320989315e-69, -2.2809159455312046184e-85, -4.0748824503880445403e-101, -6.3915272253158644628e-117,
  1.113250147552460308e-69, 2.9286284920280941206e-86, 2.1132026692048600853e-102, -4.6672632026740766185e-119,
  1.113250147552460308e-69, 2.9286284920280941206e-86, 2.1132026692048600853e-102, -4.6672632026740766185e-119,
  5.3368668650755071652e-70, 2.9286284920280941206e-86, 2.1132026692048600853e-102, -4.6672632026740766185e-119,
  2.4390495598509592076e-70, 2.9286284920280941206e-86, 2.1132026692048600853e-102, -4.6672632026740766185e-119,
  9.901409072386855505e-71, -2.8859500138942368532e-87, -5.6567402911297190423e-103, -4.6672632026740766185e-119,
  2.6568658093254848067e-71, 5.1571087196495574384e-87, 3.2728487032630532648e-103, 5.2465720993401781599e-119,
  2.6568658093254848067e-71, 5.1571087196495574384e-87, 3.2728487032630532648e-103, 5.2465720993401781599e-119,
  8.4572999356014273536e-72, 1.1355793528776598461e-87, 3.2728487032630532648e-103, 5.2465720993401781599e-119,
  8.4572999356014273536e-72, 1.1355793528776598461e-87, 3.2728487032630532648e-103, 5.2465720993401781599e-119,
  3.9294603961880721752e-72, 1.3019701118468578292e-88, -7.5747169634236195447e-105, -2.0152904854894729832e-121,
  1.6655406264813940833e-72, 1.3019701118468578292e-88, -7.5747169634236195447e-105, -2.0152904854894729832e-121,
  5.3358074162805516304e-73, 4.5242184730639744369e-90, 1.1455847889130727424e-105, 1.8573014293598455046e-121,
  5.3358074162805516304e-73, 4.5242184730639744369e-90, 1.1455847889130727424e-105, 1.8573014293598455046e-121,
  2.5059077041472040156e-73, 4.5242184730639744369e-90, 1.1455847889130727424e-105, 1.8573014293598455046e-121,
  1.0909578480805302081e-73, 4.5242184730639744369e-90, 1.1455847889130727424e-105, 1.8573014293598455046e-121,
  3.8348292004719330442e-74, 4.5242184730639744369e-90, 1.1455847889130727424e-105, 1.8573014293598455046e-121,
  2.9745456030524891833e-75, 5.969437008257942845e-91, 5.5547069870986327528e-107, 1.6304246661326865276e-122,
  2.9745456030524891833e-75, 5.969437008257942845e-91, 5.5547069870986327528e-107, 1.6304246661326865276e-122,
  2.9745456030524891833e-75, 5.969437008257942845e-91, 5.5547069870986327528e-107, 1.6304246661326865276e-122,
  2.9745456030524891833e-75, 5.969437008257942845e-91, 5.5547069870986327528e-107, 1.6304246661326865276e-122,
  7.6368645294831185015e-76, 1.0603435429602168369e-91, 1.0451839188820145747e-108, 4.2386081393205242443e-125,
  7.6368645294831185015e-76, 1.0603435429602168369e-91, 1.0451839188820145747e-108, 4.2386081393205242443e-125,
  2.1097166542226745549e-76, 4.4670685979800101779e-92, 1.0451839188820145747e-108, 4.2386081393205242443e-125,
  2.1097166542226745549e-76, 4.4670685979800101779e-92, 1.0451839188820145747e-108, 4.2386081393205242443e-125,
  7.2792968540756372162e-77, 1.3988851821689310822e-92, 1.0451839188820145747e-108, 4.2386081393205242443e-125,
  3.7036201000008285821e-78, 5.6554937751584084315e-94, -1.9306041120023063932e-110, 1.0223371855251472933e-126,
  3.7036201000008285821e-78, 5.6554937751584084315e-94, -1.9306041120023063932e-110, 1.0223371855251472933e-126,
  3.7036201000008285821e-78, 5.6554937751584084315e-94, -1.9306041120023063932e-110, 1.0223371855251472933e-126,
  3.7036201000008285821e-78, 5.6554937751584084315e-94, -1.9306041120023063932e-110, 1.0223371855251472933e-126,
  3.7036201000008285821e-78, 5.6554937751584084315e-94, -1.9306041120023063932e-110, 1.0223371855251472933e-126,
  1.5445779612272179051e-78, 8.6145718795359707834e-95, 7.3062078800278780675e-111, 1.0223371855251472933e-126,
  4.6505689184041232695e-79, 8.6145718795359707834e-95, 7.3062078800278780675e-111, 1.0223371855251472933e-126,
  4.6505689184041232695e-79, 8.6145718795359707834e-95, 7.3062078800278780675e-111, 1.0223371855251472933e-126,
  1.9517662449371099233e-79, 2.62202614552995759e-95, 6.5314563001514349095e-112, 9.9039323746573674262e-128,
  6.0236490820360325022e-80, -3.7424672147304925625e-96, -1.784871512364483542e-112, 6.7095375687163151728e-129,
  6.0236490820360325022e-80, -3.7424672147304925625e-96, -1.784871512364483542e-112, 6.7095375687163151728e-129,
  2.6501457402022643213e-80, 3.7482149527770239293e-96, 6.5314563001514349095e-112, 9.9039323746573674262e-128,
  9.6339406928538097998e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132,
  1.2001823382693912203e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132,
  1.2001823382693912203e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132,
  1.2001823382693912203e-81, 2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132,
  1.459625439463388979e-82, 2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132,
  1.459625439463388979e-82, 2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132,
  1.459625439463388979e-82, 2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132,
  1.4185069655957361252e-83, -7.8369062883735917115e-100, -1.9081236411894107761e-116, -2.1796760241698337334e-132,
  1.4185069655957361252e-83, -7.8369062883735917115e-100, -1.9081236411894107761e-116, -2.1796760241698337334e-132,
  1.4185069655957361252e-83, -7.8369062883735917115e-100, -1.9081236411894107761e-116, -2.1796760241698337334e-132,
  1.4185069655957361252e-83, -7.8369062883735917115e-100, -1.9081236411894107761e-116, -2.1796760241698337334e-132,
  5.9489775128085131541e-84, 1.0450891972142805974e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132,
  1.830931441234090934e-84, 1.3069928418846076386e-100, 3.1677600334418871069e-116, 3.4556869017247800778e-132,
  1.830931441234090934e-84, 1.3069928418846076386e-100, 3.1677600334418871069e-116, 3.4556869017247800778e-132,
  8.0141992334048515034e-85, 1.3069928418846076386e-100, 3.1677600334418871069e-116, 3.4556869017247800778e-132,
  2.8666416439368237283e-85, 1.6400545060233297363e-101, -4.6672632026740766185e-119, -3.755176715260116501e-136,
  2.9286284920280941206e-86, 2.1132026692048600853e-102, -4.6672632026740766185e-119, -3.755176715260116501e-136,
  2.9286284920280941206e-86, 2.1132026692048600853e-102, -4.6672632026740766185e-119, -3.755176715260116501e-136,
  2.9286284920280941206e-86, 2.1132026692048600853e-102, -4.6672632026740766185e-119, -3.755176715260116501e-136,
  2.9286284920280941206e-86, 2.1132026692048600853e-102, -4.6672632026740766185e-119, -3.755176715260116501e-136,
  1.3200167453193350837e-86, 2.1132026692048600853e-102, -4.6672632026740766185e-119, -3.755176715260116501e-136,
  5.1571087196495574384e-87, 3.2728487032630532648e-103, 5.2465720993401781599e-119, -3.755176715260116501e-136,
  1.1355793528776598461e-87, 3.2728487032630532648e-103, 5.2465720993401781599e-119, -3.755176715260116501e-136,
  1.1355793528776598461e-87, 3.2728487032630532648e-103, 5.2465720993401781599e-119, -3.755176715260116501e-136,
  1.3019701118468578292e-88, -7.5747169634236195447e-105, -2.0152904854894725532e-121, -3.1562414818576682143e-137,
  1.3019701118468578292e-88, -7.5747169634236195447e-105, -2.0152904854894725532e-121, -3.1562414818576682143e-137,
  1.3019701118468578292e-88, -7.5747169634236195447e-105, -2.0152904854894725532e-121, -3.1562414818576682143e-137,
  4.5242184730639744369e-90, 1.1455847889130727424e-105, 1.8573014293598452896e-121, 1.1431992269852683481e-137,
  4.5242184730639744369e-90, 1.1455847889130727424e-105, 1.8573014293598452896e-121, 1.1431992269852683481e-137,
  4.5242184730639744369e-90, 1.1455847889130727424e-105, 1.8573014293598452896e-121, 1.1431992269852683481e-137,
  4.5242184730639744369e-90, 1.1455847889130727424e-105, 1.8573014293598452896e-121, 1.1431992269852683481e-137,
  4.5242184730639744369e-90, 1.1455847889130727424e-105, 1.8573014293598452896e-121, 1.1431992269852683481e-137,
  5.969437008257942845e-91, 5.5547069870986327528e-107, 1.6304246661326865276e-122, 6.8339049774534162772e-139,
  5.969437008257942845e-91, 5.5547069870986327528e-107, 1.6304246661326865276e-122, 6.8339049774534162772e-139,
  5.969437008257942845e-91, 5.5547069870986327528e-107, 1.6304246661326865276e-122, 6.8339049774534162772e-139,
  1.0603435429602168369e-91, 1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591188256e-141,
  1.0603435429602168369e-91, 1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591188256e-141,
  1.0603435429602168369e-91, 1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591188256e-141,
  4.4670685979800101779e-92, 1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591188256e-141,
  1.3988851821689310822e-92, 1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591188256e-141,
  1.3988851821689310822e-92, 1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591188256e-141,
  6.3183932821616130831e-93, 1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591188256e-141,
  2.4831640123977650651e-93, 1.9359195088038447797e-109, -4.8867691298577234423e-126, -2.0587960670007823264e-142,
  5.6554937751584084315e-94, -1.9306041120023063932e-110, 1.0223371855251471293e-126, 1.2214168761472102282e-142,
  5.6554937751584084315e-94, -1.9306041120023063932e-110, 1.0223371855251471293e-126, 1.2214168761472102282e-142,
  8.6145718795359707834e-95, 7.3062078800278780675e-111, 1.0223371855251471293e-126, 1.2214168761472102282e-142,
  8.6145718795359707834e-95, 7.3062078800278780675e-111, 1.0223371855251471293e-126, 1.2214168761472102282e-142,
  8.6145718795359707834e-95, 7.3062078800278780675e-111, 1.0223371855251471293e-126, 1.2214168761472102282e-142,
  2.62202614552995759e-95, 6.5314563001514349095e-112, 9.9039323746573674262e-128, -8.6629775332868987041e-145,
  2.62202614552995759e-95, 6.5314563001514349095e-112, 9.9039323746573674262e-128, -8.6629775332868987041e-145,
  1.1238897120284541253e-95, 6.5314563001514349095e-112, 9.9039323746573674262e-128, -8.6629775332868987041e-145,
  3.7482149527770239293e-96, 6.5314563001514349095e-112, 9.9039323746573674262e-128, -8.6629775332868987041e-145,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  2.8738690232659205689e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  1.0450891972142805974e-99, 1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148,
  1.3069928418846076386e-100, 3.1677600334418871069e-116, 3.4556869017247794521e-132, 8.5448727249069983612e-148,
  1.3069928418846076386e-100, 3.1677600334418871069e-116, 3.4556869017247794521e-132, 8.5448727249069983612e-148,
  1.3069928418846076386e-100, 3.1677600334418871069e-116, 3.4556869017247794521e-132, 8.5448727249069983612e-148,
  1.6400545060233297363e-101, -4.6672632026740766185e-119, -3.755176715260116501e-136, 2.1571619860435652883e-152,
  1.6400545060233297363e-101, -4.6672632026740766185e-119, -3.755176715260116501e-136, 2.1571619860435652883e-152,
  1.6400545060233297363e-101, -4.6672632026740766185e-119, -3.755176715260116501e-136, 2.1571619860435652883e-152,
  2.1132026692048600853e-102, -4.6672632026740766185e-119, -3.755176715260116501e-136, 2.1571619860435652883e-152,
  2.1132026692048600853e-102, -4.6672632026740766185e-119, -3.755176715260116501e-136, 2.1571619860435652883e-152,
  2.1132026692048600853e-102, -4.6672632026740766185e-119, -3.755176715260116501e-136, 2.1571619860435652883e-152,
  3.2728487032630532648e-103, 5.2465720993401781599e-119, -3.755176715260116501e-136, 2.1571619860435652883e-152,
  3.2728487032630532648e-103, 5.2465720993401781599e-119, -3.755176715260116501e-136, 2.1571619860435652883e-152,
  3.2728487032630532648e-103, 5.2465720993401781599e-119, -3.755176715260116501e-136, 2.1571619860435652883e-152,
  1.0404514546648604359e-103, 2.896544483330507019e-120, 3.1239284188885823808e-136, 2.1571619860435652883e-152,
  1.0404514546648604359e-103, 2.896544483330507019e-120, 3.1239284188885823808e-136, 2.1571619860435652883e-152,
  4.8235214251531210473e-104, 2.896544483330507019e-120, 3.1239284188885823808e-136, 2.1571619860435652883e-152,
  2.0330248644053793915e-104, 2.896544483330507019e-120, 3.1239284188885823808e-136, 2.1571619860435652883e-152,
  6.3777658403150887343e-105, -2.0152904854894725532e-121, -3.156241481857667737e-137, -7.0684085473731388916e-153,
  6.3777658403150887343e-105, -2.0152904854894725532e-121, -3.156241481857667737e-137, -7.0684085473731388916e-153,
  2.88964513938041089e-105, 5.7298933442091639924e-121, -3.156241481857667737e-137, -7.0684085473731388916e-153,
  1.1455847889130727424e-105, 1.8573014293598452896e-121, 1.1431992269852681095e-137, 2.4782675885631257398e-153,
  2.7355461367940366859e-106, -7.8994528064813712419e-123, -2.0037599452814940222e-138, 9.1598554579059548847e-155,
  2.7355461367940366859e-106, -7.8994528064813712419e-123, -2.0037599452814940222e-138, 9.1598554579059548847e-155,
  5.5547069870986327528e-107, 1.6304246661326865276e-122, 6.8339049774534147855e-139, 9.1598554579059548847e-155,
  5.5547069870986327528e-107, 1.6304246661326865276e-122, 6.8339049774534147855e-139, 9.1598554579059548847e-155,
  1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157,
  1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157,
  1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157,
  1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157,
  1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157,
  1.0451839188820145747e-108, 4.2386081393205242443e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157,
  1.9359195088038447797e-109, -4.8867691298577234423e-126, -2.0587960670007819622e-142, -2.8326669474241479263e-158,
  1.9359195088038447797e-109, -4.8867691298577234423e-126, -2.0587960670007819622e-142, -2.8326669474241479263e-158,
  1.9359195088038447797e-109, -4.8867691298577234423e-126, -2.0587960670007819622e-142, -2.8326669474241479263e-158,
  8.7142954880180709975e-110, -4.8867691298577234423e-126, -2.0587960670007819622e-142, -2.8326669474241479263e-158,
  3.3918456880078814158e-110, 6.931443500908017045e-126, 1.1062055705591186799e-141, 1.1734404793201255869e-157,
  7.3062078800278780675e-111, 1.0223371855251471293e-126, 1.2214168761472102282e-142, 8.0910098773220312367e-159,
  7.3062078800278780675e-111, 1.0223371855251471293e-126, 1.2214168761472102282e-142, 8.0910098773220312367e-159,
  6.5314563001514349095e-112, 9.9039323746573674262e-128, -8.6629775332868972816e-145, -1.5987060076657616072e-160,
  6.5314563001514349095e-112, 9.9039323746573674262e-128, -8.6629775332868972816e-145, -1.5987060076657616072e-160,
  6.5314563001514349095e-112, 9.9039323746573674262e-128, -8.6629775332868972816e-145, -1.5987060076657616072e-160,
  6.5314563001514349095e-112, 9.9039323746573674262e-128, -8.6629775332868972816e-145, -1.5987060076657616072e-160,
  2.3732923938934761454e-112, 6.7095375687163138915e-129, 1.6963686085056791706e-144, 1.2464251916751375716e-160,
  2.9421044076449630171e-113, 6.7095375687163138915e-129, 1.6963686085056791706e-144, 1.2464251916751375716e-160,
  2.9421044076449630171e-113, 6.7095375687163138915e-129, 1.6963686085056791706e-144, 1.2464251916751375716e-160,
  2.9421044076449630171e-113, 6.7095375687163138915e-129, 1.6963686085056791706e-144, 1.2464251916751375716e-160,
  3.4325196623373878948e-114, 9.3892593260023063019e-130, 9.4702132359198537748e-146, 1.7950099192230045857e-161,
  3.4325196623373878948e-114, 9.3892593260023063019e-130, 9.4702132359198537748e-146, 1.7950099192230045857e-161,
  3.4325196623373878948e-114, 9.3892593260023063019e-130, 9.4702132359198537748e-146, 1.7950099192230045857e-161,
  1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148, 2.9106774506606945839e-164,
  1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148, 2.9106774506606945839e-164,
  1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148, 2.9106774506606945839e-164,
  1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148, 2.9106774506606945839e-164,
  1.8395411057335783574e-115, -7.8150389500644475446e-132, -3.9681466199873824165e-148, 2.9106774506606945839e-164,
  8.2436437080731844263e-116, 1.4726412753514008951e-131, -3.9681466199873824165e-148, 2.9106774506606945839e-164,
  3.1677600334418871069e-116, 3.4556869017247794521e-132, 8.544872724906996972e-148, 1.6802919634942429241e-163,
  6.2981819612623816536e-117, 6.3800543877747317218e-133, 7.2423563434801054878e-149, 1.1741471776254779927e-164,
  6.2981819612623816536e-117, 6.3800543877747317218e-133, 7.2423563434801054878e-149, 1.1741471776254779927e-164,
  6.2981819612623816536e-117, 6.3800543877747317218e-133, 7.2423563434801054878e-149, 1.1741471776254779927e-164,
  3.1257546646178208289e-117, -6.6414926959353515111e-134, -5.7828074707888119584e-150, -1.2825052715093464343e-165,
  1.5395410162955400644e-117, -6.6414926959353515111e-134, -5.7828074707888119584e-150, -1.2825052715093464343e-165,
  7.4643419213439950602e-118, 1.0969016447485317626e-133, -5.7828074707888119584e-150, -1.2825052715093464343e-165,
  3.4988078005382940294e-118, 2.1637618757749825688e-134, -8.9490928918944555247e-151, -1.9717385086233606481e-166,
  1.5160407401354430737e-118, 2.1637618757749825688e-134, -8.9490928918944555247e-151, -1.9717385086233606481e-166,
  5.2465720993401781599e-119, -3.755176715260116501e-136, 2.1571619860435648643e-152, 6.3257905089784152346e-168,
  2.896544483330507019e-120, 3.1239284188885823808e-136, 2.1571619860435648643e-152, 6.3257905089784152346e-168,
  2.896544483330507019e-120, 3.1239284188885823808e-136, 2.1571619860435648643e-152, 6.3257905089784152346e-168,
  2.896544483330507019e-120, 3.1239284188885823808e-136, 2.1571619860435648643e-152, 6.3257905089784152346e-168,
  2.896544483330507019e-120, 3.1239284188885823808e-136, 2.1571619860435648643e-152, 6.3257905089784152346e-168,
  2.896544483330507019e-120, 3.1239284188885823808e-136, 2.1571619860435648643e-152, 6.3257905089784152346e-168,
  1.3475077173907800538e-120, -3.156241481857667737e-137, -7.0684085473731388916e-153, -3.3573283875161501977e-170,
  5.7298933442091639924e-121, -3.156241481857667737e-137, -7.0684085473731388916e-153, -3.3573283875161501977e-170,
  1.8573014293598452896e-121, 1.1431992269852681095e-137, 2.4782675885631257398e-153, -3.3573283875161501977e-170,
  1.8573014293598452896e-121, 1.1431992269852681095e-137, 2.4782675885631257398e-153, -3.3573283875161501977e-170,
  8.8915345064751572143e-122, 1.1431992269852681095e-137, 2.4782675885631257398e-153, -3.3573283875161501977e-170,
  4.0507946129135104481e-122, 6.8339049774534147855e-139, 9.1598554579059548847e-155, -4.5159745404911825673e-172,
  1.6304246661326865276e-122, 6.8339049774534147855e-139, 9.1598554579059548847e-155, -4.5159745404911825673e-172,
  4.2023969274227456735e-123, 6.8339049774534147855e-139, 9.1598554579059548847e-155, -4.5159745404911825673e-172,
  4.2023969274227456735e-123, 6.8339049774534147855e-139, 9.1598554579059548847e-155, -4.5159745404911825673e-172,
  1.1769344939467164447e-123, 1.1602886988632691941e-140, 3.0307583960570927356e-156, 5.8345524661064369683e-172,
  1.1769344939467164447e-123, 1.1602886988632691941e-140, 3.0307583960570927356e-156, 5.8345524661064369683e-172,
  4.2056888557770896953e-124, 1.1602886988632691941e-140, 3.0307583960570927356e-156, 5.8345524661064369683e-172,
  4.2386081393205242443e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157, 1.2381024895275844856e-174,
  4.2386081393205242443e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157, 1.2381024895275844856e-174,
  4.2386081393205242443e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157, 1.2381024895275844856e-174,
  4.2386081393205242443e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157, 1.2381024895275844856e-174,
  1.8749656131673758844e-125, 1.1062055705591186799e-141, 1.1734404793201255869e-157, 1.2381024895275844856e-174,
  6.931443500908017045e-126, 1.1062055705591186799e-141, 1.1734404793201255869e-157, 1.2381024895275844856e-174,
  1.0223371855251471293e-126, 1.2214168761472102282e-142, 8.0910098773220302259e-159, 1.2381024895275844856e-174,
  1.0223371855251471293e-126, 1.2214168761472102282e-142, 8.0910098773220302259e-159, 1.2381024895275844856e-174,
  1.0223371855251471293e-126, 1.2214168761472102282e-142, 8.0910098773220302259e-159, 1.2381024895275844856e-174,
  2.8369889610228834887e-127, 4.0136364036021218058e-143, -1.0134099605688458828e-159, -2.5389576707476506925e-176,
  2.8369889610228834887e-127, 4.0136364036021218058e-143, -1.0134099605688458828e-159, -2.5389576707476506925e-176,
  9.9039323746573674262e-128, -8.6629775332868972816e-145, -1.5987060076657612913e-160, -2.5389576707476506925e-176,
  6.7095375687163138915e-129, 1.6963686085056791706e-144, 1.2464251916751375716e-160, 6.197724948400014906e-177,
  6.7095375687163138915e-129, 1.6963686085056791706e-144, 1.2464251916751375716e-160, 6.197724948400014906e-177,
  6.7095375687163138915e-129, 1.6963686085056791706e-144, 1.2464251916751375716e-160, 6.197724948400014906e-177,
  6.7095375687163138915e-129, 1.6963686085056791706e-144, 1.2464251916751375716e-160, 6.197724948400014906e-177,
  9.3892593260023063019e-130, 9.4702132359198537748e-146, 1.7950099192230045857e-161, -1.6991004655691155518e-177,
  9.3892593260023063019e-130, 9.4702132359198537748e-146, 1.7950099192230045857e-161, -1.6991004655691155518e-177,
  9.3892593260023063019e-130, 9.4702132359198537748e-146, 1.7950099192230045857e-161, -1.6991004655691155518e-177,
  2.175994780857201024e-130, 1.4618808551874518553e-146, 1.6802919634942426156e-163, 2.8330093736631818036e-179,
  2.175994780857201024e-130, 1.4618808551874518553e-146, 1.6802919634942426156e-163, 2.8330093736631818036e-179,
  3.7267864457092460442e-131, 4.6083930759590139305e-147, 1.6802919634942426156e-163, 2.8330093736631818036e-179,
  3.7267864457092460442e-131, 4.6083930759590139305e-147, 1.6802919634942426156e-163, 2.8330093736631818036e-179,
  3.7267864457092460442e-131, 4.6083930759590139305e-147, 1.6802919634942426156e-163, 2.8330093736631818036e-179,
  1.4726412753514008951e-131, -3.9681466199873824165e-148, 2.9106774506606941983e-164, 5.1948630316441296498e-180,
  3.4556869017247794521e-132, 8.544872724906996972e-148, 1.6802919634942426156e-163, 2.8330093736631818036e-179,
  3.4556869017247794521e-132, 8.544872724906996972e-148, 1.6802919634942426156e-163, 2.8330093736631818036e-179,
  6.3800543877747317218e-133, 7.2423563434801054878e-149, 1.1741471776254777999e-164, 1.3389912474795152755e-180,
  6.3800543877747317218e-133, 7.2423563434801054878e-149, 1.1741471776254777999e-164, 1.3389912474795152755e-180,
  6.3800543877747317218e-133, 7.2423563434801054878e-149, 1.1741471776254777999e-164, 1.3389912474795152755e-180,
  2.8579525590905986764e-133, -5.7828074707888119584e-150, -1.2825052715093464343e-165, -1.0696067158221530218e-181,
  1.0969016447485317626e-133, -5.7828074707888119584e-150, -1.2825052715093464343e-165, -1.0696067158221530218e-181,
  2.1637618757749825688e-134, -8.9490928918944555247e-151, -1.9717385086233606481e-166, 1.3535321672928907047e-182,
  2.1637618757749825688e-134, -8.9490928918944555247e-151, -1.9717385086233606481e-166, 1.3535321672928907047e-182,
  2.1637618757749825688e-134, -8.9490928918944555247e-151, -1.9717385086233606481e-166, 1.3535321672928907047e-182,
  1.0631050543111905033e-134, 1.5490398016102376505e-150, 3.4549185946116918017e-166, 1.3535321672928907047e-182,
  5.1277664357929471499e-135, 3.2706525621039604902e-151, 7.4159004299416557678e-167, 1.3535321672928907047e-182,
  2.3761243821334675971e-135, 3.2706525621039604902e-151, 7.4159004299416557678e-167, 1.3535321672928907047e-182,
  1.0003033553037281263e-135, 2.1571619860435648643e-152, 6.3257905089784152346e-168, 3.5607241064750984115e-184,
  3.1239284188885823808e-136, 2.1571619860435648643e-152, 6.3257905089784152346e-168, 3.5607241064750984115e-184,
  3.1239284188885823808e-136, 2.1571619860435648643e-152, 6.3257905089784152346e-168, 3.5607241064750984115e-184,
  1.4041521353514076604e-136, 2.1571619860435648643e-152, 6.3257905089784152346e-168, 3.5607241064750984115e-184,
  5.4426399358282049106e-137, 2.4782675885631257398e-153, -3.3573283875161501977e-170, 3.0568054078295488291e-186,
  1.1431992269852681095e-137, 2.4782675885631257398e-153, -3.3573283875161501977e-170, 3.0568054078295488291e-186,
  1.1431992269852681095e-137, 2.4782675885631257398e-153, -3.3573283875161501977e-170, 3.0568054078295488291e-186,
  6.8339049774534147855e-139, 9.1598554579059548847e-155, -4.5159745404911819927e-172, -4.5870810097328578981e-188,
  6.8339049774534147855e-139, 9.1598554579059548847e-155, -4.5159745404911819927e-172, -4.5870810097328578981e-188,
  6.8339049774534147855e-139, 9.1598554579059548847e-155, -4.5159745404911819927e-172, -4.5870810097328578981e-188,
  6.8339049774534147855e-139, 9.1598554579059548847e-155, -4.5159745404911819927e-172, -4.5870810097328578981e-188,
  1.1602886988632691941e-140, 3.0307583960570927356e-156, 5.8345524661064358191e-172, 6.9043123899963188689e-188,
  1.1602886988632691941e-140, 3.0307583960570927356e-156, 5.8345524661064358191e-172, 6.9043123899963188689e-188,
  1.1602886988632691941e-140, 3.0307583960570927356e-156, 5.8345524661064358191e-172, 6.9043123899963188689e-188,
  1.1602886988632691941e-140, 3.0307583960570927356e-156, 5.8345524661064358191e-172, 6.9043123899963188689e-188,
  1.1602886988632691941e-140, 3.0307583960570927356e-156, 5.8345524661064358191e-172, 6.9043123899963188689e-188,
  1.1602886988632691941e-140, 3.0307583960570927356e-156, 5.8345524661064358191e-172, 6.9043123899963188689e-188,
  1.1062055705591186799e-141, 1.1734404793201255869e-157, 1.2381024895275844856e-174, -8.4789520282639751913e-191,
  1.1062055705591186799e-141, 1.1734404793201255869e-157, 1.2381024895275844856e-174, -8.4789520282639751913e-191,
  1.1062055705591186799e-141, 1.1734404793201255869e-157, 1.2381024895275844856e-174, -8.4789520282639751913e-191,
  1.1062055705591186799e-141, 1.1734404793201255869e-157, 1.2381024895275844856e-174, -8.4789520282639751913e-191,
  4.5016298192952031469e-142, -2.8326669474241479263e-158, 1.2381024895275844856e-174, -8.4789520282639751913e-191,
  1.2214168761472102282e-142, 8.0910098773220302259e-159, 1.2381024895275844856e-174, -8.4789520282639751913e-191,
  1.2214168761472102282e-142, 8.0910098773220302259e-159, 1.2381024895275844856e-174, -8.4789520282639751913e-191,
  4.0136364036021218058e-143, -1.0134099605688458828e-159, -2.5389576707476506925e-176, -6.2404128071707654958e-193,
  4.0136364036021218058e-143, -1.0134099605688458828e-159, -2.5389576707476506925e-176, -6.2404128071707654958e-193,
  1.9635033141346264592e-143, -1.0134099605688458828e-159, -2.5389576707476506925e-176, -6.2404128071707654958e-193,
  9.3843676940087855824e-144, 1.2626949989038732076e-159, 2.2730883653953564668e-175, 2.7431118386590483722e-191,
  4.2590349703400483539e-144, 1.2464251916751375716e-160, 6.1977249484000140293e-177, 1.1294061984896458822e-192,
  1.6963686085056791706e-144, 1.2464251916751375716e-160, 6.1977249484000140293e-177, 1.1294061984896458822e-192,
  4.1503542758849472122e-145, -1.7614040799531193879e-161, -1.6991004655691153326e-177, -1.856794109153959173e-193,
  4.1503542758849472122e-145, -1.7614040799531193879e-161, -1.6991004655691153326e-177, -1.856794109153959173e-193,
  9.4702132359198537748e-146, 1.7950099192230045857e-161, -1.6991004655691153326e-177, -1.856794109153959173e-193,
  9.4702132359198537748e-146, 1.7950099192230045857e-161, -1.6991004655691153326e-177, -1.856794109153959173e-193,
  1.4618808551874518553e-146, 1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196,
  1.4618808551874518553e-146, 1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196,
  1.4618808551874518553e-146, 1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196,
  4.6083930759590139305e-147, 1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196,
  4.6083930759590139305e-147, 1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196,
  2.105789206980137775e-147, 1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196,
  8.544872724906996972e-148, 1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196,
  2.2883630524598079723e-148, 2.9106774506606941983e-164, 5.1948630316441287936e-180, 9.6685396110091032843e-196,
  2.2883630524598079723e-148, 2.9106774506606941983e-164, 5.1948630316441287936e-180, 9.6685396110091032843e-196,
  7.2423563434801054878e-149, 1.1741471776254777999e-164, 1.3389912474795150614e-180, 1.1067843414450286726e-196,
  7.2423563434801054878e-149, 1.1741471776254777999e-164, 1.3389912474795150614e-180, 1.1067843414450286726e-196,
  3.3320377982006123631e-149, 3.0588204110786950436e-165, 3.7502330143836152136e-181, 3.6564932749519464998e-198,
  1.3768785255608653665e-149, 3.0588204110786950436e-165, 3.7502330143836152136e-181, 3.6564932749519464998e-198,
  3.9929888924099219388e-150, -1.9717385086233606481e-166, 1.3535321672928907047e-182, 3.1205762277848031878e-199,
  3.9929888924099219388e-150, -1.9717385086233606481e-166, 1.3535321672928907047e-182, 3.1205762277848031878e-199,
  1.5490398016102376505e-150, 3.4549185946116918017e-166, 1.3535321672928907047e-182, 3.1205762277848031878e-199,
  3.2706525621039604902e-151, 7.4159004299416557678e-167, 1.3535321672928907047e-182, 3.1205762277848031878e-199,
  3.2706525621039604902e-151, 7.4159004299416557678e-167, 1.3535321672928907047e-182, 3.1205762277848031878e-199,
  2.1571619860435648643e-152, 6.3257905089784152346e-168, 3.5607241064750984115e-184, -1.4832196127821708615e-201,
  2.1571619860435648643e-152, 6.3257905089784152346e-168, 3.5607241064750984115e-184, -1.4832196127821708615e-201,
  2.1571619860435648643e-152, 6.3257905089784152346e-168, 3.5607241064750984115e-184, -1.4832196127821708615e-201,
  2.1571619860435648643e-152, 6.3257905089784152346e-168, 3.5607241064750984115e-184, -1.4832196127821708615e-201,
  2.4782675885631257398e-153, -3.3573283875161501977e-170, 3.0568054078295488291e-186, 1.4980560800565462618e-202,
  2.4782675885631257398e-153, -3.3573283875161501977e-170, 3.0568054078295488291e-186, 1.4980560800565462618e-202,
  2.4782675885631257398e-153, -3.3573283875161501977e-170, 3.0568054078295488291e-186, 1.4980560800565462618e-202,
  9.1598554579059548847e-155, -4.5159745404911819927e-172, -4.5870810097328572602e-188, -3.2905064432040069127e-204,
  9.1598554579059548847e-155, -4.5159745404911819927e-172, -4.5870810097328572602e-188, -3.2905064432040069127e-204,
  9.1598554579059548847e-155, -4.5159745404911819927e-172, -4.5870810097328572602e-188, -3.2905064432040069127e-204,
  9.1598554579059548847e-155, -4.5159745404911819927e-172, -4.5870810097328572602e-188, -3.2905064432040069127e-204,
  9.1598554579059548847e-155, -4.5159745404911819927e-172, -4.5870810097328572602e-188, -3.2905064432040069127e-204,
  1.7015147267057481414e-155, -4.5159745404911819927e-172, -4.5870810097328572602e-188, -3.2905064432040069127e-204,
  1.7015147267057481414e-155, -4.5159745404911819927e-172, -4.5870810097328572602e-188, -3.2905064432040069127e-204,
  1.7015147267057481414e-155, -4.5159745404911819927e-172, -4.5870810097328572602e-188, -3.2905064432040069127e-204,
  7.6922213530572229852e-156, -4.5159745404911819927e-172, -4.5870810097328572602e-188, -3.2905064432040069127e-204,
  3.0307583960570927356e-156, 5.8345524661064358191e-172, 6.9043123899963188689e-188, -3.2905064432040069127e-204,
  7.0002691755702864582e-157, 6.5928896280762691321e-173, 1.1586156901317304854e-188, -1.0100405885278530137e-205,
  7.0002691755702864582e-157, 6.5928896280762691321e-173, 1.1586156901317304854e-188, -1.0100405885278530137e-205,
  1.1734404793201255869e-157, 1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.3321093418096261919e-207,
  1.1734404793201255869e-157, 1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.3321093418096261919e-207,
  1.1734404793201255869e-157, 1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.3321093418096261919e-207,
  4.4508689228885539715e-158, 1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.3321093418096261919e-207,
  8.0910098773220302259e-159, 1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.3321093418096261919e-207,
  8.0910098773220302259e-159, 1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.3321093418096261919e-207,
  8.0910098773220302259e-159, 1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.3321093418096261919e-207,
  3.5387999583765925506e-159, 2.2730883653953564668e-175, 2.7431118386590483722e-191, -1.3321093418096261919e-207,
  1.2626949989038732076e-159, 2.2730883653953564668e-175, 2.7431118386590483722e-191, -1.3321093418096261919e-207,
  1.2464251916751375716e-160, 6.1977249484000140293e-177, 1.1294061984896456875e-192, 2.2526486929936882202e-208,
  1.2464251916751375716e-160, 6.1977249484000140293e-177, 1.1294061984896456875e-192, 2.2526486929936882202e-208,
  1.2464251916751375716e-160, 6.1977249484000140293e-177, 1.1294061984896456875e-192, 2.2526486929936882202e-208,
  1.2464251916751375716e-160, 6.1977249484000140293e-177, 1.1294061984896456875e-192, 2.2526486929936882202e-208,
  5.3514239183991277695e-161, 6.1977249484000140293e-177, 1.1294061984896456875e-192, 2.2526486929936882202e-208,
  1.7950099192230045857e-161, -1.6991004655691153326e-177, -1.8567941091539589297e-193, -1.8074851186411640793e-209,
  1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212,
  1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212,
  1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212,
  1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212,
  1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212,
  1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212,
  1.6802919634942426156e-163, 2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212,
  2.9106774506606941983e-164, 5.1948630316441287936e-180, 9.6685396110091013832e-196, 1.7562785002189357559e-211,
  2.9106774506606941983e-164, 5.1948630316441287936e-180, 9.6685396110091013832e-196, 1.7562785002189357559e-211,
  2.9106774506606941983e-164, 5.1948630316441287936e-180, 9.6685396110091013832e-196, 1.7562785002189357559e-211,
  1.1741471776254777999e-164, 1.3389912474795150614e-180, 1.106784341445028435e-196, 3.3045982549756583552e-212,
  3.0588204110786950436e-165, 3.7502330143836152136e-181, 3.6564932749519464998e-198, 3.7097125405852507464e-214,
  3.0588204110786950436e-165, 3.7502330143836152136e-181, 3.6564932749519464998e-198, 3.7097125405852507464e-214,
  8.8815756978467430465e-166, 1.3403131492807310959e-181, 3.6564932749519464998e-198, 3.7097125405852507464e-214,
  8.8815756978467430465e-166, 1.3403131492807310959e-181, 3.6564932749519464998e-198, 3.7097125405852507464e-214,
  3.4549185946116918017e-166, 1.3535321672928907047e-182, 3.1205762277848031878e-199, -3.3569248349832580936e-217,
  7.4159004299416557678e-167, 1.3535321672928907047e-182, 3.1205762277848031878e-199, -3.3569248349832580936e-217,
  7.4159004299416557678e-167, 1.3535321672928907047e-182, 3.1205762277848031878e-199, -3.3569248349832580936e-217,
  6.3257905089784152346e-168, 3.5607241064750984115e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218,
  6.3257905089784152346e-168, 3.5607241064750984115e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218,
  6.3257905089784152346e-168, 3.5607241064750984115e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218,
  6.3257905089784152346e-168, 3.5607241064750984115e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218,
  2.0862146470760309789e-168, -1.146150630053972131e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218,
  2.0862146470760309789e-168, -1.146150630053972131e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218,
  1.026320681600434562e-168, 1.2072867382105631402e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218,
  4.9637369886263658882e-169, 3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218,
  2.3140020749373754342e-169, 3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218,
  9.8913461809288020723e-170, 3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218,
  3.2670088967063259373e-170, 3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218,
  3.2670088967063259373e-170, 3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218,
  1.6109245756507072713e-170, -6.2044048008378732802e-187, -5.4322544592823556944e-203, 4.2491789852161138683e-219,
  7.8288241512289757055e-171, 1.2181824638728806485e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218,
  3.6886133485899290404e-171, 2.9887099189454666024e-187, 4.774153170641553462e-203, 4.2491789852161138683e-219,
  1.6185079472704052482e-171, 2.9887099189454666024e-187, 4.774153170641553462e-203, 4.2491789852161138683e-219,
  5.8345524661064358191e-172, 6.9043123899963188689e-188, -3.2905064432040069127e-204, -9.1795828160190082842e-224,
  6.5928896280762691321e-173, 1.1586156901317304854e-188, -1.0100405885278530137e-205, -9.1795828160190082842e-224,
  6.5928896280762691321e-173, 1.1586156901317304854e-188, -1.0100405885278530137e-205, -9.1795828160190082842e-224,
  6.5928896280762691321e-173, 1.1586156901317304854e-188, -1.0100405885278530137e-205, -9.1795828160190082842e-224,
  1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.332109341809626019e-207, -9.1795828160190082842e-224,
  1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.332109341809626019e-207, -9.1795828160190082842e-224,
  1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.332109341809626019e-207, -9.1795828160190082842e-224,
  1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.332109341809626019e-207, -9.1795828160190082842e-224,
  1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.332109341809626019e-207, -9.1795828160190082842e-224,
  1.2381024895275844856e-174, -8.4789520282639751913e-191, -1.332109341809626019e-207, -9.1795828160190082842e-224,
  2.2730883653953564668e-175, 2.7431118386590483722e-191, -1.332109341809626019e-207, -9.1795828160190082842e-224,
  2.2730883653953564668e-175, 2.7431118386590483722e-191, -1.332109341809626019e-207, -9.1795828160190082842e-224,
  2.2730883653953564668e-175, 2.7431118386590483722e-191, -1.332109341809626019e-207, -9.1795828160190082842e-224,
  1.0095962991602958391e-175, -6.2404128071707654958e-193, 3.0593092910744445285e-209, 5.4622616159087170031e-225,
  3.7785026604276538491e-176, -6.2404128071707654958e-193, 3.0593092910744445285e-209, 5.4622616159087170031e-225,
  6.1977249484000140293e-177, 1.1294061984896456875e-192, 2.2526486929936882202e-208, -5.3441928036578162463e-225,
  6.1977249484000140293e-177, 1.1294061984896456875e-192, 2.2526486929936882202e-208, -5.3441928036578162463e-225,
  6.1977249484000140293e-177, 1.1294061984896456875e-192, 2.2526486929936882202e-208, -5.3441928036578162463e-225,
  2.2493122414154495675e-177, 2.5268245888628466632e-193, 3.0593092910744445285e-209, 5.4622616159087170031e-225,
  2.7510588792316711745e-178, 3.3501523985444386676e-194, 6.2591208621664049475e-210, 5.9034406125450500218e-227,
  2.7510588792316711745e-178, 3.3501523985444386676e-194, 6.2591208621664049475e-210, 5.9034406125450500218e-227,
  2.7510588792316711745e-178, 3.3501523985444386676e-194, 6.2591208621664049475e-210, 5.9034406125450500218e-227,
  2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212, 9.9192633285681635836e-229,
  2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212, 9.9192633285681635836e-229,
  2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212, 9.9192633285681635836e-229,
  2.8330093736631818036e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212, 9.9192633285681635836e-229,
  1.2906606599973359683e-179, -7.4549709281190454638e-196, -1.4481306607622412036e-212, 9.9192633285681635836e-229,
  5.1948630316441287936e-180, 9.6685396110091013832e-196, 1.7562785002189355449e-211, 1.6821693549018732055e-227,
  1.3389912474795150614e-180, 1.106784341445028435e-196, 3.3045982549756578275e-212, 6.2685154049107876715e-228,
  1.3389912474795150614e-180, 1.106784341445028435e-196, 3.3045982549756578275e-212, 6.2685154049107876715e-228,
  3.7502330143836152136e-181, 3.6564932749519464998e-198, 3.7097125405852507464e-214, 2.5658818466966882188e-231,
  3.7502330143836152136e-181, 3.6564932749519464998e-198, 3.7097125405852507464e-214, 2.5658818466966882188e-231,
  1.3403131492807310959e-181, 3.6564932749519464998e-198, 3.7097125405852507464e-214, 2.5658818466966882188e-231,
  1.3535321672928907047e-182, 3.1205762277848031878e-199, -3.3569248349832580936e-217, -1.0577661142165146927e-233,
  1.3535321672928907047e-182, 3.1205762277848031878e-199, -3.3569248349832580936e-217, -1.0577661142165146927e-233,
  1.3535321672928907047e-182, 3.1205762277848031878e-199, -3.3569248349832580936e-217, -1.0577661142165146927e-233,
  1.3535321672928907047e-182, 3.1205762277848031878e-199, -3.3569248349832580936e-217, -1.0577661142165146927e-233,
  6.0043220944823941786e-183, 3.1205762277848031878e-199, -3.3569248349832580936e-217, -1.0577661142165146927e-233,
  2.2388223052591377446e-183, 3.1205762277848031878e-199, -3.3569248349832580936e-217, -1.0577661142165146927e-233,
  3.5607241064750984115e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  3.5607241064750984115e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  3.5607241064750984115e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  1.2072867382105631402e-184, -1.4832196127821708615e-201, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  3.0568054078295488291e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  1.2181824638728806485e-186, 1.4980560800565460352e-202, 2.6911956484118910092e-218, -5.1336618966962585332e-235,
  2.9887099189454666024e-187, 4.774153170641553462e-203, 4.2491789852161132393e-219, 7.4467067939231424594e-235,
  2.9887099189454666024e-187, 4.774153170641553462e-203, 4.2491789852161132393e-219, 7.4467067939231424594e-235,
  6.9043123899963188689e-188, -3.2905064432040069127e-204, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  6.9043123899963188689e-188, -3.2905064432040069127e-204, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  1.1586156901317304854e-188, -1.0100405885278530137e-205, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  1.1586156901317304854e-188, -1.0100405885278530137e-205, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  1.1586156901317304854e-188, -1.0100405885278530137e-205, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  4.4040360264865697732e-189, -1.0100405885278530137e-205, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  8.129755890712020335e-190, 9.8339840169166049336e-206, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  8.129755890712020335e-190, 9.8339840169166049336e-206, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  8.129755890712020335e-190, 9.8339840169166049336e-206, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  3.6409303439428119063e-190, -1.332109341809626019e-207, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  1.3965175705582071936e-190, -1.332109341809626019e-207, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  2.7431118386590483722e-191, -1.332109341809626019e-207, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  2.7431118386590483722e-191, -1.332109341809626019e-207, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  2.7431118386590483722e-191, -1.332109341809626019e-207, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  1.3403538552936701153e-191, 1.7826390804083638359e-207, -9.1795828160190063645e-224, -2.3569545504732004486e-239,
  6.389748636109812983e-192, 2.2526486929936882202e-208, -5.3441928036578156465e-225, -7.741539335184153052e-241,
  2.8828536776963681193e-192, 2.2526486929936882202e-208, -5.3441928036578156465e-225, -7.741539335184153052e-241,
  1.1294061984896456875e-192, 2.2526486929936882202e-208, -5.3441928036578156465e-225, -7.741539335184153052e-241,
  2.5268245888628466632e-193, 3.0593092910744445285e-209, 5.4622616159087170031e-225, 4.2560351759808952526e-241,
  2.5268245888628466632e-193, 3.0593092910744445285e-209, 5.4622616159087170031e-225, 4.2560351759808952526e-241,
  3.3501523985444386676e-194, 6.2591208621664049475e-210, 5.9034406125450490845e-227, 1.3186893776791012681e-242,
  3.3501523985444386676e-194, 6.2591208621664049475e-210, 5.9034406125450490845e-227, 1.3186893776791012681e-242,
  3.3501523985444386676e-194, 6.2591208621664049475e-210, 5.9034406125450490845e-227, 1.3186893776791012681e-242,
  6.1039071228393547627e-195, 1.7562785002189355449e-211, 1.6821693549018732055e-227, -8.7276385348052817035e-244,
  6.1039071228393547627e-195, 1.7562785002189355449e-211, 1.6821693549018732055e-227, -8.7276385348052817035e-244,
  6.1039071228393547627e-195, 1.7562785002189355449e-211, 1.6821693549018732055e-227, -8.7276385348052817035e-244,
  2.6792050150137250131e-195, 1.7562785002189355449e-211, 1.6821693549018732055e-227, -8.7276385348052817035e-244,
  9.6685396110091013832e-196, 1.7562785002189355449e-211, 1.6821693549018732055e-227, -8.7276385348052817035e-244,
  2.0416567491425607157e-177, 6.0959078275963141821e-193, 1.156336993964950812e-208, 2.7126166236326293347e-224,
  2.0416567491425607157e-177, 6.0959078275963141821e-193, 1.156336993964950812e-208, 2.7126166236326293347e-224,
  2.0416567491425607157e-177, 6.0959078275963141821e-193, 1.156336993964950812e-208, 2.7126166236326293347e-224,
  6.7450395650278649168e-179, 6.8432117823206978686e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228,
  6.7450395650278649168e-179, 6.8432117823206978686e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228,
  6.7450395650278649168e-179, 6.8432117823206978686e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228,
  6.7450395650278649168e-179, 6.8432117823206978686e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228,
  6.7450395650278649168e-179, 6.8432117823206978686e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228,
  5.756447103644822603e-180, -6.1924333305615830735e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  5.756447103644822603e-180, -6.1924333305615830735e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  5.756447103644822603e-180, -6.1924333305615830735e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  5.756447103644822603e-180, -6.1924333305615830735e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  1.9005753194802080146e-180, -6.1924333305615830735e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  1.9005753194802080146e-180, -6.1924333305615830735e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  9.3660737343905436753e-181, -6.1924333305615830735e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  4.5462340041847754398e-181, -6.1924333305615830735e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  2.1363141390818913221e-181, -6.1924333305615830735e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  9.3135420653044926323e-182, -6.1924333305615830735e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  3.2887424025472810002e-182, 7.185309278132283136e-198, -1.9512340798794268979e-214, -3.6162764918921697356e-230,
  2.7634257116867652192e-183, 4.9643797378534984559e-199, -9.4699347169310243473e-216, -9.2331809177749095611e-233,
  2.7634257116867652192e-183, 4.9643797378534984559e-199, -9.4699347169310243473e-216, -9.2331809177749095611e-233,
  2.7634257116867652192e-183, 4.9643797378534984559e-199, -9.4699347169310243473e-216, -9.2331809177749095611e-233,
  2.7634257116867652192e-183, 4.9643797378534984559e-199, -9.4699347169310243473e-216, -9.2331809177749095611e-233,
  8.806758170751374203e-184, 7.8383517263666503337e-200, 1.3736749441945438342e-215, -9.2331809177749095611e-233,
  8.806758170751374203e-184, 7.8383517263666503337e-200, 1.3736749441945438342e-215, -9.2331809177749095611e-233,
  4.0998834342223036605e-184, 7.8383517263666503337e-200, 1.3736749441945438342e-215, -9.2331809177749095611e-233,
  1.7464460659577689118e-184, 2.612671019845610006e-200, 2.1334073625072069974e-216, -9.2331809177749095611e-233,
  5.697273818255015375e-185, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  5.697273818255015375e-185, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  2.755477107924346286e-185, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  1.2845787527590117414e-185, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  5.4912957517634446918e-186, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  1.8140498638501083305e-186, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  1.8140498638501083305e-186, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  8.9473839187177424013e-187, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  4.3508265588260719497e-187, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  2.0525478788802367239e-187, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  9.0340853890731911095e-188, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  3.288388689208603045e-188, -1.6933341491052464293e-204, -4.3478137385944270631e-220, -2.3353910329236990725e-236,
  4.1554033927630885323e-189, -9.8582956929636044137e-206, -1.4280619485269765742e-221, 1.2171222696290252021e-237,
  4.1554033927630885323e-189, -9.8582956929636044137e-206, -1.4280619485269765742e-221, 1.2171222696290252021e-237,
  4.1554033927630885323e-189, -9.8582956929636044137e-206, -1.4280619485269765742e-221, 1.2171222696290252021e-237,
  5.643429553477207926e-190, 1.0076094209231528444e-205, 7.8509991660024955813e-222, 1.2171222696290252021e-237,
  5.643429553477207926e-190, 1.0076094209231528444e-205, 7.8509991660024955813e-222, 1.2171222696290252021e-237,
  5.643429553477207926e-190, 1.0076094209231528444e-205, 7.8509991660024955813e-222, 1.2171222696290252021e-237,
  1.1546040067079994973e-190, 1.0889925813396166947e-207, 2.4325525462765697993e-223, -1.1429360314275701698e-239,
  1.1546040067079994973e-190, 1.0889925813396166947e-207, 2.4325525462765697993e-223, -1.1429360314275701698e-239,
  3.2397620015697148712e-192, 3.1030547578511949035e-208, -1.609965144193984205e-224, -1.8313007053436627876e-240,
  3.2397620015697148712e-192, 3.1030547578511949035e-208, -1.609965144193984205e-224, -1.8313007053436627876e-240,
  3.2397620015697148712e-192, 3.1030547578511949035e-208, -1.609965144193984205e-224, -1.8313007053436627876e-240,
  3.2397620015697148712e-192, 3.1030547578511949035e-208, -1.609965144193984205e-224, -1.8313007053436627876e-240,
  3.2397620015697148712e-192, 3.1030547578511949035e-208, -1.609965144193984205e-224, -1.8313007053436627876e-240,
  3.2397620015697148712e-192, 3.1030547578511949035e-208, -1.609965144193984205e-224, -1.8313007053436627876e-240,
  1.4863145223629928288e-192, -7.9038076992129241506e-209, -1.609965144193984205e-224, -1.8313007053436627876e-240,
  6.0959078275963141821e-193, 1.156336993964950812e-208, 2.7126166236326293347e-224, -1.8313007053436627876e-240,
  1.712289129579509076e-193, 1.8297811202182925249e-209, 1.1003018740995688645e-226, 5.827891678485165325e-243,
  1.712289129579509076e-193, 1.8297811202182925249e-209, 1.1003018740995688645e-226, 5.827891678485165325e-243,
  6.1638445507530779946e-194, -6.0361608463951204924e-210, 1.1003018740995688645e-226, 5.827891678485165325e-243,
  6.8432117823206978686e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.029900079464340522e-245,
  6.8432117823206978686e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.029900079464340522e-245,
  6.8432117823206978686e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.029900079464340522e-245,
  6.8432117823206978686e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.029900079464340522e-245,
  3.418509674495068119e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.029900079464340522e-245,
  1.7061586205822532442e-195, 4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.029900079464340522e-245,
  8.499830936258458068e-196, 4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.029900079464340522e-245,
  4.218953301476420881e-196, 4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.029900079464340522e-245,
  2.0785144840854027628e-196, -1.9512340798794268979e-214, -3.6162764918921692779e-230, -2.8387319855193022476e-246,
  1.008295075389893466e-196, -1.9512340798794268979e-214, -3.6162764918921692779e-230, -2.8387319855193022476e-246,
  4.7318537104213881764e-197, -1.9512340798794268979e-214, -3.6162764918921692779e-230, -2.8387319855193022476e-246,
  2.0563051886826149345e-197, -1.9512340798794268979e-214, -3.6162764918921692779e-230, -2.8387319855193022476e-246,
  7.185309278132283136e-198, -1.9512340798794268979e-214, -3.6162764918921692779e-230, -2.8387319855193022476e-246,
  4.9643797378534984559e-199, -9.4699347169310243473e-216, -9.2331809177749077733e-233, -1.4042876247421728101e-248,
  4.9643797378534984559e-199, -9.4699347169310243473e-216, -9.2331809177749077733e-233, -1.4042876247421728101e-248,
  4.9643797378534984559e-199, -9.4699347169310243473e-216, -9.2331809177749077733e-233, -1.4042876247421728101e-248,
  4.9643797378534984559e-199, -9.4699347169310243473e-216, -9.2331809177749077733e-233, -1.4042876247421728101e-248,
  7.8383517263666503337e-200, 1.3736749441945438342e-215, -9.2331809177749077733e-233, -1.4042876247421728101e-248,
  7.8383517263666503337e-200, 1.3736749441945438342e-215, -9.2331809177749077733e-233, -1.4042876247421728101e-248,
  7.8383517263666503337e-200, 1.3736749441945438342e-215, -9.2331809177749077733e-233, -1.4042876247421728101e-248,
  2.612671019845610006e-200, 2.1334073625072069974e-216, -9.2331809177749077733e-233, -1.4042876247421728101e-248,
  2.612671019845610006e-200, 2.1334073625072069974e-216, -9.2331809177749077733e-233, -1.4042876247421728101e-248,
  1.306250843215349634e-200, 2.1334073625072069974e-216, -9.2331809177749077733e-233, -1.4042876247421728101e-248,
  6.5304075490021959302e-201, 6.8298960257742791824e-217, 6.8696910062179237095e-233, 3.8349029251851101018e-249,
  3.2643571074265457254e-201, -4.2219277387461470355e-218, -1.753154605289404553e-234, -7.5861268822635538093e-251,
  1.6313318866387202604e-201, -4.2219277387461470355e-218, -1.753154605289404553e-234, -7.5861268822635538093e-251,
  8.1481927624480752786e-202, -4.2219277387461470355e-218, -1.753154605289404553e-234, -7.5861268822635538093e-251,
  4.0656297104785107096e-202, 4.8431832608149701961e-218, 8.3111403472061145651e-234, 1.6001805286092554504e-249,
  2.0243481844937293316e-202, 3.1062776103441183191e-219, 7.6291913283447536617e-235, 2.0347903074934629333e-250,
  1.0037074215013384159e-202, 3.1062776103441183191e-219, 7.6291913283447536617e-235, 2.0347903074934629333e-250,
  4.9338704000514295811e-203, 3.1062776103441183191e-219, 7.6291913283447536617e-235, 2.0347903074934629333e-250,
  2.3822684925704522921e-203, 3.1062776103441183191e-219, 7.6291913283447536617e-235, 2.0347903074934629333e-250,
  1.1064675388299639308e-203, 2.7343042298126957741e-220, 5.5273393987134252385e-236, 1.1432574793608782288e-251,
  4.6856706195971960852e-204, 2.7343042298126957741e-220, 5.5273393987134252385e-236, 1.1432574793608782288e-251,
  1.4961682352459748279e-204, -8.0675475439086544798e-221, -3.6970842501441777651e-237, -5.7032870362481275794e-253,
  1.4961682352459748279e-204, -8.0675475439086544798e-221, -3.6970842501441777651e-237, -5.7032870362481275794e-253,
  6.9879263915816924805e-205, 9.6377473771091526132e-221, 1.5959741828948633012e-236, 2.7031904319843495713e-252,
  3.0010484111426663515e-205, 7.8509991660024955813e-222, 1.2171222696290252021e-237, -2.4742181023285720738e-254,
  1.0076094209231528444e-205, 7.8509991660024955813e-222, 1.2171222696290252021e-237, -2.4742181023285720738e-254,
  1.0889925813396166947e-207, 2.4325525462765697993e-223, -1.1429360314275701698e-239, 8.3218722366085688343e-256,
  1.0889925813396166947e-207, 2.4325525462765697993e-223, -1.1429360314275701698e-239, 8.3218722366085688343e-256,
  1.0889925813396166947e-207, 2.4325525462765697993e-223, -1.1429360314275701698e-239, 8.3218722366085688343e-256,
  1.0889925813396166947e-207, 2.4325525462765697993e-223, -1.1429360314275701698e-239, 8.3218722366085688343e-256,
  1.0889925813396166947e-207, 2.4325525462765697993e-223, -1.1429360314275701698e-239, 8.3218722366085688343e-256,
  1.0889925813396166947e-207, 2.4325525462765697993e-223, -1.1429360314275701698e-239, 8.3218722366085688343e-256,
  1.0889925813396166947e-207, 2.4325525462765697993e-223, -1.1429360314275701698e-239, 8.3218722366085688343e-256,
  3.1030547578511949035e-208, -1.609965144193984205e-224, -1.8313007053436625212e-240, -2.3341145329525059632e-256,
  3.1030547578511949035e-208, -1.609965144193984205e-224, -1.8313007053436625212e-240, -2.3341145329525059632e-256,
  1.156336993964950812e-208, 2.7126166236326293347e-224, -1.8313007053436625212e-240, -2.3341145329525059632e-256,
  1.8297811202182925249e-209, 1.1003018740995688645e-226, 5.827891678485165325e-243, -3.1174271110208206547e-259,
  1.8297811202182925249e-209, 1.1003018740995688645e-226, 5.827891678485165325e-243, -3.1174271110208206547e-259,
  1.8297811202182925249e-209, 1.1003018740995688645e-226, 5.827891678485165325e-243, -3.1174271110208206547e-259,
  6.1308251778939023781e-210, 1.1003018740995688645e-226, 5.827891678485165325e-243, -3.1174271110208206547e-259,
  4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  4.7332165749391048364e-212, 4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  2.3568521170701555846e-212, -7.7818310317651142243e-229, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  1.1686698881356804311e-212, 1.8601114328504743806e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  5.7457877366844311816e-213, 5.409641648369814791e-229, -3.0299000794643401155e-245, -2.8075477999879273582e-261,
  2.7753321643482446169e-213, -1.1860946916976500828e-229, 6.3146909508553973881e-246, 1.2573885592501532045e-261,
  1.290104378180150675e-213, 2.1117734783360818049e-229, 4.2928382696354204061e-245, -2.8075477999879273582e-261,
  5.4749048509610403382e-214, 4.6283939331921604413e-230, 6.3146909508553973881e-246, 1.2573885592501532045e-261,
  1.7618353855408067201e-214, 5.060587206499956961e-231, 5.9380161562121075096e-247, -1.2904053011746964278e-263,
  1.7618353855408067201e-214, 5.060587206499956961e-231, 5.9380161562121075096e-247, -1.2904053011746964278e-263,
  8.3356801918574821257e-215, 5.060587206499956961e-231, 5.9380161562121075096e-247, -1.2904053011746964278e-263,
  3.6943433600821895879e-215, 5.060587206499956961e-231, 5.9380161562121075096e-247, -1.2904053011746964278e-263,
  1.3736749441945438342e-215, -9.2331809177749077733e-233, -1.4042876247421726117e-248, -9.9505977179164858712e-265,
  2.1334073625072069974e-216, -9.2331809177749077733e-233, -1.4042876247421726117e-248, -9.9505977179164858712e-265,
  2.1334073625072069974e-216, -9.2331809177749077733e-233, -1.4042876247421726117e-248, -9.9505977179164858712e-265,
  2.1334073625072069974e-216, -9.2331809177749077733e-233, -1.4042876247421726117e-248, -9.9505977179164858712e-265,
  6.8298960257742791824e-217, 6.8696910062179237095e-233, 3.8349029251851101018e-249, -2.6436684620390282645e-267,
  6.8298960257742791824e-217, 6.8696910062179237095e-233, 3.8349029251851101018e-249, -2.6436684620390282645e-267,
  3.2038516259498326923e-217, -1.1817449557784924788e-233, -6.3454186796659920093e-250, -2.6436684620390282645e-267,
  1.3908294260376086421e-217, 2.8439730252197153919e-233, 3.8349029251851101018e-249, -2.6436684620390282645e-267,
  4.8431832608149701961e-218, 8.3111403472061145651e-234, 1.6001805286092554504e-249, -2.6436684620390282645e-267,
  3.1062776103441183191e-219, 7.6291913283447536617e-235, 2.0347903074934629333e-250, -2.6436684620390282645e-267,
  3.1062776103441183191e-219, 7.6291913283447536617e-235, 2.0347903074934629333e-250, -2.6436684620390282645e-267,
  3.1062776103441183191e-219, 7.6291913283447536617e-235, 2.0347903074934629333e-250, -2.6436684620390282645e-267,
  3.1062776103441183191e-219, 7.6291913283447536617e-235, 2.0347903074934629333e-250, -2.6436684620390282645e-267,
  2.7343042298126957741e-220, 5.5273393987134252385e-236, 1.1432574793608780349e-251, 1.2329569415922591084e-267,
  2.7343042298126957741e-220, 5.5273393987134252385e-236, 1.1432574793608780349e-251, 1.2329569415922591084e-267,
  2.7343042298126957741e-220, 5.5273393987134252385e-236, 1.1432574793608780349e-251, 1.2329569415922591084e-267,
  2.7343042298126957741e-220, 5.5273393987134252385e-236, 1.1432574793608780349e-251, 1.2329569415922591084e-267,
  9.6377473771091526132e-221, 1.5959741828948633012e-236, 2.7031904319843490867e-252, 2.638005906844372114e-268,
  7.8509991660024955813e-222, 1.2171222696290252021e-237, -2.4742181023285720738e-254, -1.2030990169203137715e-270,
  7.8509991660024955813e-222, 1.2171222696290252021e-237, -2.4742181023285720738e-254, -1.2030990169203137715e-270,
  7.8509991660024955813e-222, 1.2171222696290252021e-237, -2.4742181023285720738e-254, -1.2030990169203137715e-270,
  7.8509991660024955813e-222, 1.2171222696290252021e-237, -2.4742181023285720738e-254, -1.2030990169203137715e-270,
  2.318094503184431479e-222, -1.1429360314275701698e-239, 8.3218722366085688343e-256, -2.0046830753539155726e-272,
  2.318094503184431479e-222, -1.1429360314275701698e-239, 8.3218722366085688343e-256, -2.0046830753539155726e-272,
  9.3486833747991514629e-223, -1.1429360314275701698e-239, 8.3218722366085688343e-256, -2.0046830753539155726e-272,
  2.4325525462765697993e-223, -1.1429360314275701698e-239, 8.3218722366085688343e-256, -2.0046830753539155726e-272,
  2.4325525462765697993e-223, -1.1429360314275701698e-239, 8.3218722366085688343e-256, -2.0046830753539155726e-272,
  7.0351983914592419146e-224, 7.766758903588374524e-240, 8.3218722366085688343e-256, -2.0046830753539155726e-272,
  7.0351983914592419146e-224, 7.766758903588374524e-240, 8.3218722366085688343e-256, -2.0046830753539155726e-272,
  2.7126166236326293347e-224, -1.8313007053436625212e-240, -2.3341145329525056675e-256, -2.0046830753539155726e-272,
  5.5132573971932232487e-225, 5.6821419688934674008e-241, 3.2988215943776273615e-257, 2.1353977370878701046e-273,
  5.5132573971932232487e-225, 5.6821419688934674008e-241, 3.2988215943776273615e-257, 2.1353977370878701046e-273,
  1.1003018740995688645e-226, 5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275,
  1.1003018740995688645e-226, 5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275,
  1.1003018740995688645e-226, 5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275,
  1.1003018740995688645e-226, 5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275,
  1.1003018740995688645e-226, 5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275,
  1.1003018740995688645e-226, 5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275,
  2.560476225709334075e-227, 5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275,
  2.560476225709334075e-227, 5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275,
  4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261, -1.472095602234059958e-277,
  4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261, -1.472095602234059958e-277,
  4.4984059688774601837e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261, -1.472095602234059958e-277,
  1.8601114328504743806e-228, -3.0299000794643401155e-245, -2.8075477999879273582e-261, -1.472095602234059958e-277,
  5.409641648369814791e-229, -3.0299000794643401155e-245, -2.8075477999879273582e-261, -1.472095602234059958e-277,
  5.409641648369814791e-229, -3.0299000794643401155e-245, -2.8075477999879273582e-261, -1.472095602234059958e-277,
  2.1117734783360818049e-229, 4.2928382696354204061e-245, -2.8075477999879273582e-261, -1.472095602234059958e-277,
  4.6283939331921604413e-230, 6.3146909508553973881e-246, 1.2573885592501529789e-261, 3.0408903374280139822e-277,
  4.6283939331921604413e-230, 6.3146909508553973881e-246, 1.2573885592501529789e-261, 3.0408903374280139822e-277,
  5.060587206499956961e-231, 5.9380161562121075096e-247, -1.2904053011746964278e-263, 8.7279092175580820317e-280,
  5.060587206499956961e-231, 5.9380161562121075096e-247, -1.2904053011746964278e-263, 8.7279092175580820317e-280,
  5.060587206499956961e-231, 5.9380161562121075096e-247, -1.2904053011746964278e-263, 8.7279092175580820317e-280,
  5.060587206499956961e-231, 5.9380161562121075096e-247, -1.2904053011746964278e-263, 8.7279092175580820317e-280,
  2.4841276986611042098e-231, 2.1712682097791944335e-248, 2.9746046415267896827e-264, -8.6516445844406224413e-282,
  1.1958979447416775482e-231, 2.1712682097791944335e-248, 2.9746046415267896827e-264, -8.6516445844406224413e-282,
  5.5178306778196421733e-232, 2.1712682097791944335e-248, 2.9746046415267896827e-264, -8.6516445844406224413e-282,
  2.2972562930210755192e-232, 2.1712682097791944335e-248, 2.9746046415267896827e-264, -8.6516445844406224413e-282,
  6.8696910062179237095e-233, 3.8349029251851101018e-249, -2.6436684620390282645e-267, -4.3807022524130141006e-284,
  6.8696910062179237095e-233, 3.8349029251851101018e-249, -2.6436684620390282645e-267, -4.3807022524130141006e-284,
  2.8439730252197153919e-233, 3.8349029251851101018e-249, -2.6436684620390282645e-267, -4.3807022524130141006e-284,
  8.3111403472061145651e-234, 1.6001805286092554504e-249, -2.6436684620390282645e-267, -4.3807022524130141006e-284,
  8.3111403472061145651e-234, 1.6001805286092554504e-249, -2.6436684620390282645e-267, -4.3807022524130141006e-284,
  3.2789928709583552854e-234, 4.8281933032132812475e-250, -2.6436684620390282645e-267, -4.3807022524130141006e-284,
  7.6291913283447536617e-235, 2.0347903074934629333e-250, -2.6436684620390282645e-267, -4.3807022524130141006e-284,
  7.6291913283447536617e-235, 2.0347903074934629333e-250, -2.6436684620390282645e-267, -4.3807022524130141006e-284,
  1.3390069830350552605e-235, -6.026193929640082176e-252, -7.0535576022338457803e-268, -4.3807022524130141006e-284,
  1.3390069830350552605e-235, -6.026193929640082176e-252, -7.0535576022338457803e-268, -4.3807022524130141006e-284,
  1.3390069830350552605e-235, -6.026193929640082176e-252, -7.0535576022338457803e-268, -4.3807022524130141006e-284,
  5.5273393987134252385e-236, 1.1432574793608780349e-251, 1.2329569415922591084e-267, -4.3807022524130141006e-284,
  1.5959741828948633012e-236, 2.7031904319843490867e-252, 2.638005906844371576e-268, 6.3790946999826013345e-284,
  1.5959741828948633012e-236, 2.7031904319843490867e-252, 2.638005906844371576e-268, 6.3790946999826013345e-284,
  6.1313287894022281692e-237, 5.2084434157824127104e-253, 2.1511502957481757317e-269, 3.2670891426006739096e-285,
  1.2171222696290252021e-237, -2.4742181023285720738e-254, -1.2030990169203137715e-270, -9.5347405022956042207e-287,
  1.2171222696290252021e-237, -2.4742181023285720738e-254, -1.2030990169203137715e-270, -9.5347405022956042207e-287,
  1.2171222696290252021e-237, -2.4742181023285720738e-254, -1.2030990169203137715e-270, -9.5347405022956042207e-287,
  6.0284645465737476297e-238, -2.4742181023285720738e-254, -1.2030990169203137715e-270, -9.5347405022956042207e-287,
  2.9570854717154947523e-238, 4.3456134301905148502e-254, 6.3684349745470443788e-270, -9.5347405022956042207e-287,
  1.4213959342863689955e-238, 9.3569766393097138822e-255, 2.5826679788133653036e-270, -9.5347405022956042207e-287,
  6.5355116557180594664e-239, 9.3569766393097138822e-255, 2.5826679788133653036e-270, -9.5347405022956042207e-287,
  2.6962878121452450746e-239, 8.3218722366085688343e-256, -2.0046830753539152442e-272, -3.4057806738724185961e-288,
  7.766758903588374524e-240, 8.3218722366085688343e-256, -2.0046830753539152442e-272, -3.4057806738724185961e-288,
  7.766758903588374524e-240, 8.3218722366085688343e-256, -2.0046830753539152442e-272, -3.4057806738724185961e-288,
  2.9677290991223565342e-240, -2.3341145329525056675e-256, -2.0046830753539152442e-272, -3.4057806738724185961e-288,
  5.6821419688934674008e-241, 3.2988215943776273615e-257, 2.1353977370878701046e-273, -1.2215123283371736879e-289,
  5.6821419688934674008e-241, 3.2988215943776273615e-257, 2.1353977370878701046e-273, -1.2215123283371736879e-289,
  5.6821419688934674008e-241, 3.2988215943776273615e-257, 2.1353977370878701046e-273, -1.2215123283371736879e-289,
  2.6827483411022054912e-241, 3.2988215943776273615e-257, 2.1353977370878701046e-273, -1.2215123283371736879e-289,
  1.1830515272065748694e-241, -3.117427111020820077e-259, -5.9718623963762788119e-275, 6.1155422068568954053e-291,
  4.3320312025875939195e-242, -3.117427111020820077e-259, -5.9718623963762788119e-275, 6.1155422068568954053e-291,
  5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275, 6.1155422068568954053e-291,
  5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275, 6.1155422068568954053e-291,
  5.827891678485165325e-243, -3.117427111020820077e-259, -5.9718623963762788119e-275, 6.1155422068568954053e-291,
  1.1413391350613183311e-243, -5.1586784110844895013e-260, -1.9524039360882352712e-276, -2.9779654517181717279e-292,
  1.1413391350613183311e-243, -5.1586784110844895013e-260, -1.9524039360882352712e-276, -2.9779654517181717279e-292,
  1.1413391350613183311e-243, -5.1586784110844895013e-260, -1.9524039360882352712e-276, -2.9779654517181717279e-292,
  5.5552006713333735927e-244, 7.8491179384773690214e-260, -1.9524039360882352712e-276, -2.9779654517181717279e-292,
  2.6261053316934700345e-244, 1.345219763696439399e-260, 1.6579848156414234801e-276, 1.0303712682997740506e-292,
  1.1615576618735179302e-244, 1.345219763696439399e-260, 1.6579848156414234801e-276, 1.0303712682997740506e-292,
  4.2928382696354204061e-245, -2.8075477999879273582e-261, -1.472095602234059958e-277, 2.8287088295287585094e-294,
  6.3146909508553973881e-246, 1.2573885592501529789e-261, 3.0408903374280139822e-277, 2.8287088295287585094e-294,
  6.3146909508553973881e-246, 1.2573885592501529789e-261, 3.0408903374280139822e-277, 2.8287088295287585094e-294,
  6.3146909508553973881e-246, 1.2573885592501529789e-261, 3.0408903374280139822e-277, 2.8287088295287585094e-294,
  1.7379794826680480784e-246, 2.4115446944063306384e-262, 2.202741251392177696e-278, 2.8287088295287585094e-294,
  1.7379794826680480784e-246, 2.4115446944063306384e-262, 2.202741251392177696e-278, 2.8287088295287585094e-294,
  5.9380161562121075096e-247, -1.2904053011746964278e-263, 8.7279092175580810531e-280, 8.8634899828990930877e-296,
  2.1712682097791944335e-248, 2.9746046415267896827e-264, -8.6516445844406224413e-282, -5.0528699238150276549e-299,
  2.1712682097791944335e-248, 2.9746046415267896827e-264, -8.6516445844406224413e-282, -5.0528699238150276549e-299,
  2.1712682097791944335e-248, 2.9746046415267896827e-264, -8.6516445844406224413e-282, -5.0528699238150276549e-299,
  2.1712682097791944335e-248, 2.9746046415267896827e-264, -8.6516445844406224413e-282, -5.0528699238150276549e-299,
  2.1712682097791944335e-248, 2.9746046415267896827e-264, -8.6516445844406224413e-282, -5.0528699238150276549e-299,
  3.8349029251851101018e-249, -2.6436684620390282645e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  3.8349029251851101018e-249, -2.6436684620390282645e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  3.8349029251851101018e-249, -2.6436684620390282645e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  1.6001805286092554504e-249, -2.6436684620390282645e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  4.8281933032132812475e-250, -2.6436684620390282645e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  4.8281933032132812475e-250, -2.6436684620390282645e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  2.0347903074934629333e-250, -2.6436684620390282645e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  6.3808880963355377617e-251, -2.6436684620390282645e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  6.3808880963355377617e-251, -2.6436684620390282645e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  2.8891343516857640937e-251, 5.1095823452235464813e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  1.1432574793608780349e-251, 1.2329569415922591084e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300,
  2.7031904319843490867e-252, 2.638005906844371576e-268, 6.3790946999826013345e-284, -2.7456019707854725967e-300,
  2.7031904319843490867e-252, 2.638005906844371576e-268, 6.3790946999826013345e-284, -2.7456019707854725967e-300,
  5.2084434157824127104e-253, 2.1511502957481757317e-269, 3.2670891426006735363e-285, 2.4084160842482777461e-301,
  5.2084434157824127104e-253, 2.1511502957481757317e-269, 3.2670891426006735363e-285, 2.4084160842482777461e-301,
  5.2084434157824127104e-253, 2.1511502957481757317e-269, 3.2670891426006735363e-285, 2.4084160842482777461e-301,
  2.4805108027747776379e-253, 2.1511502957481757317e-269, 3.2670891426006735363e-285, 2.4084160842482777461e-301,
  1.1165444962709601017e-253, 2.1511502957481757317e-269, 3.2670891426006735363e-285, 2.4084160842482777461e-301,
  4.3456134301905148502e-254, 6.3684349745470443788e-270, -9.5347405022956030541e-287, -1.5805886663557401565e-302,
  9.3569766393097138822e-255, 2.5826679788133653036e-270, -9.5347405022956030541e-287, -1.5805886663557401565e-302,
  9.3569766393097138822e-255, 2.5826679788133653036e-270, -9.5347405022956030541e-287, -1.5805886663557401565e-302,
  8.3218722366085688343e-256, -2.0046830753539152442e-272, -3.4057806738724185961e-288, 2.3458177946667328156e-304,
  8.3218722366085688343e-256, -2.0046830753539152442e-272, -3.4057806738724185961e-288, 2.3458177946667328156e-304,
  8.3218722366085688343e-256, -2.0046830753539152442e-272, -3.4057806738724185961e-288, 2.3458177946667328156e-304,
  8.3218722366085688343e-256, -2.0046830753539152442e-272, -3.4057806738724185961e-288, 2.3458177946667328156e-304,
  2.9938788518280315834e-256, -2.0046830753539152442e-272, -3.4057806738724185961e-288, 2.3458177946667328156e-304,
  3.2988215943776273615e-257, 2.1353977370878701046e-273, -1.2215123283371736879e-289, 6.7342163555358599277e-306,
  3.2988215943776273615e-257, 2.1353977370878701046e-273, -1.2215123283371736879e-289, 6.7342163555358599277e-306,
  3.2988215943776273615e-257, 2.1353977370878701046e-273, -1.2215123283371736879e-289, 6.7342163555358599277e-306,
  3.2988215943776273615e-257, 2.1353977370878701046e-273, -1.2215123283371736879e-289, 6.7342163555358599277e-306,
  1.6338236616337094706e-257, 2.1353977370878701046e-273, -1.2215123283371736879e-289, 6.7342163555358599277e-306,
  8.0132469526175071002e-258, 2.8687869620228451614e-274, -1.9537812801257956865e-290, 1.0380272777574237546e-306,
  3.850752120757712373e-258, 2.8687869620228451614e-274, -1.9537812801257956865e-290, 1.0380272777574237546e-306,
  1.7695047048278150093e-258, 2.8687869620228451614e-274, -1.9537812801257956865e-290, 1.0380272777574237546e-306,
  7.2888099686286655858e-259, 5.581381609158630475e-275, 6.1155422068568946933e-291, 1.0380272777574237546e-306,
  2.0856914288039227544e-259, -1.9524039360882352712e-276, -2.9779654517181712829e-292, -3.000817432603284506e-308,
  2.0856914288039227544e-259, -1.9524039360882352712e-276, -2.9779654517181712829e-292, -3.000817432603284506e-308,
  7.8491179384773690214e-260, -1.9524039360882352712e-276, -2.9779654517181712829e-292, -3.000817432603284506e-308,
  1.345219763696439399e-260, 1.6579848156414234801e-276, 1.0303712682997738281e-292, 1.4493302844111182601e-308,
  1.345219763696439399e-260, 1.6579848156414234801e-276, 1.0303712682997738281e-292, 1.4493302844111182601e-308,
  1.345219763696439399e-260, 1.6579848156414234801e-276, 1.0303712682997738281e-292, 1.4493302844111182601e-308,
  5.3223249184882342185e-261, -1.472095602234059958e-277, 2.8287088295287585094e-294, -1.0874435234232647519e-310,
  1.2573885592501529789e-261, 3.0408903374280139822e-277, 2.8287088295287585094e-294, -1.0874435234232647519e-310,
  1.2573885592501529789e-261, 3.0408903374280139822e-277, 2.8287088295287585094e-294, -1.0874435234232647519e-310,
  2.4115446944063306384e-262, 2.202741251392177696e-278, 2.8287088295287585094e-294, -1.0874435234232647519e-310,
  2.4115446944063306384e-262, 2.202741251392177696e-278, 2.8287088295287585094e-294, -1.0874435234232647519e-310,
  2.4115446944063306384e-262, 2.202741251392177696e-278, 2.8287088295287585094e-294, -1.0874435234232647519e-310,
  1.1412520821444306741e-262, -6.1787496089661820348e-279, -3.028042329852615431e-295, -2.182740474438892116e-311,
  5.0610577601348040988e-263, 7.9243314524777990283e-279, -3.028042329852615431e-295, -2.182740474438892116e-311,
  1.8853262294800541881e-263, 8.7279092175580810531e-280, 8.8634899828990930877e-296, -9.8167844904532653004e-314,
  2.9746046415267896827e-264, -8.6516445844406224413e-282, -5.0528699238150265939e-299, -1.3288013265921760399e-314,
  2.9746046415267896827e-264, -8.6516445844406224413e-282, -5.0528699238150265939e-299, -1.3288013265921760399e-314,
  2.9746046415267896827e-264, -8.6516445844406224413e-282, -5.0528699238150265939e-299, -1.3288013265921760399e-314,
  9.8977243486757054781e-265, -8.6516445844406224413e-282, -5.0528699238150265939e-299, -1.3288013265921760399e-314,
  9.8977243486757054781e-265, -8.6516445844406224413e-282, -5.0528699238150265939e-299, -1.3288013265921760399e-314,
  4.9356438320276576408e-265, -8.6516445844406224413e-282, -5.0528699238150265939e-299, -1.3288013265921760399e-314,
  2.4546035737036337221e-265, -8.6516445844406224413e-282, -5.0528699238150265939e-299, -1.3288013265921760399e-314,
  1.2140834445416214873e-265, 1.8893435613692150014e-281, 3.0075895258731974416e-297, -9.8167844904532653004e-314,
  5.9382337996061564537e-266, 5.1208955146257653156e-282, -5.0528699238150265939e-299, -1.3288013265921760399e-314,
  2.8369334767011265554e-266, 5.1208955146257653156e-282, -5.0528699238150265939e-299, -1.3288013265921760399e-314,
  1.2862833152486119506e-266, 1.6777604898591683764e-282, -5.0528699238150265939e-299, -1.3288013265921760399e-314,
  5.1095823452235464813e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300, -2.5539572388808429997e-317,
  1.2329569415922591084e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300, -2.5539572388808429997e-317,
  1.2329569415922591084e-267, -4.3807022524130141006e-284, -2.7456019707854725967e-300, -2.5539572388808429997e-317,
  2.638005906844371576e-268, 6.3790946999826013345e-284, -2.7456019707854725967e-300, -2.5539572388808429997e-317,
  2.638005906844371576e-268, 6.3790946999826013345e-284, -2.7456019707854725967e-300, -2.5539572388808429997e-317,
  2.1511502957481757317e-269, 3.2670891426006735363e-285, 2.4084160842482773317e-301, 5.7350888195772519812e-317,
  2.1511502957481757317e-269, 3.2670891426006735363e-285, 2.4084160842482773317e-301, 5.7350888195772519812e-317,
  2.1511502957481757317e-269, 3.2670891426006735363e-285, 2.4084160842482773317e-301, 5.7350888195772519812e-317,
  2.1511502957481757317e-269, 3.2670891426006735363e-285, 2.4084160842482773317e-301, 5.7350888195772519812e-317,
  6.3684349745470443788e-270, -9.5347405022956030541e-287, -1.5805886663557401565e-302, 3.6369654387311681856e-319,
  6.3684349745470443788e-270, -9.5347405022956030541e-287, -1.5805886663557401565e-302, 3.6369654387311681856e-319,
  2.5826679788133653036e-270, -9.5347405022956030541e-287, -1.5805886663557401565e-302, 3.6369654387311681856e-319,
  6.8978448094652555593e-271, 1.1480487920352081009e-286, 7.5257037990230704094e-303, 3.6369654387311681856e-319,
  6.8978448094652555593e-271, 1.1480487920352081009e-286, 7.5257037990230704094e-303, 3.6369654387311681856e-319,
  2.1656360647981577662e-271, 9.7287370902823839435e-288, 1.6928061833779524157e-303, 3.6369654387311681856e-319,
  2.1656360647981577662e-271, 9.7287370902823839435e-288, 1.6928061833779524157e-303, 3.6369654387311681856e-319,
  9.825838786313830552e-272, 9.7287370902823839435e-288, 1.6928061833779524157e-303, 3.6369654387311681856e-319,
  3.9105778554799569972e-272, 9.7287370902823839435e-288, 1.6928061833779524157e-303, 3.6369654387311681856e-319,
  9.5294739006302120482e-273, -1.2215123283371736879e-289, 6.7342163555358599277e-306, -5.681754927174335258e-322,
  9.5294739006302120482e-273, -1.2215123283371736879e-289, 6.7342163555358599277e-306, -5.681754927174335258e-322,
  2.1353977370878701046e-273, -1.2215123283371736879e-289, 6.7342163555358599277e-306, -5.681754927174335258e-322,
  2.1353977370878701046e-273, -1.2215123283371736879e-289, 6.7342163555358599277e-306, -5.681754927174335258e-322,
  2.8687869620228451614e-274, -1.9537812801257956865e-290, 1.0380272777574237546e-306, 6.4228533959362050743e-323,
};

static const float Sleef_rempitabsp[] = {
  0.159154892, 5.112411827e-08, 3.626141271e-15, -2.036222915e-22,
  0.03415493667, 6.420638243e-09, 7.342738037e-17, 8.135951656e-24,
  0.03415493667, 6.420638243e-09, 7.342738037e-17, 8.135951656e-24,
  0.002904943191, -9.861969574e-11, -9.839336547e-18, -1.790215892e-24,
  0.002904943191, -9.861969574e-11, -9.839336547e-18, -1.790215892e-24,
  0.002904943191, -9.861969574e-11, -9.839336547e-18, -1.790215892e-24,
  0.002904943191, -9.861969574e-11, -9.839336547e-18, -1.790215892e-24,
  0.0009518179577, 1.342109202e-10, 1.791623576e-17, 1.518506657e-24,
  0.0009518179577, 1.342109202e-10, 1.791623576e-17, 1.518506657e-24,
  0.0004635368241, 1.779561221e-11, 4.038449606e-18, -1.358546052e-25,
  0.0002193961991, 1.779561221e-11, 4.038449606e-18, -1.358546052e-25,
  9.73258866e-05, 1.779561221e-11, 4.038449606e-18, -1.358546052e-25,
  3.62907449e-05, 3.243700447e-12, 5.690024473e-19, 7.09405479e-26,
  5.773168596e-06, 1.424711477e-12, 1.3532163e-19, 1.92417627e-26,
  5.773168596e-06, 1.424711477e-12, 1.3532163e-19, 1.92417627e-26,
  5.773168596e-06, 1.424711477e-12, 1.3532163e-19, 1.92417627e-26,
  1.958472239e-06, 5.152167755e-13, 1.3532163e-19, 1.92417627e-26,
  5.112411827e-08, 3.626141271e-15, -2.036222915e-22, 6.177847236e-30,
  5.112411827e-08, 3.626141271e-15, -2.036222915e-22, 6.177847236e-30,
  5.112411827e-08, 3.626141271e-15, -2.036222915e-22, 6.177847236e-30,
  5.112411827e-08, 3.626141271e-15, -2.036222915e-22, 6.177847236e-30,
  5.112411827e-08, 3.626141271e-15, -2.036222915e-22, 6.177847236e-30,
  5.112411827e-08, 3.626141271e-15, -2.036222915e-22, 6.177847236e-30,
  2.132179588e-08, 3.626141271e-15, -2.036222915e-22, 6.177847236e-30,
  6.420638243e-09, 7.342738037e-17, 8.135951656e-24, -1.330400526e-31,
  6.420638243e-09, 7.342738037e-17, 8.135951656e-24, -1.330400526e-31,
  2.695347945e-09, 7.342738037e-17, 8.135951656e-24, -1.330400526e-31,
  8.327027956e-10, 7.342738037e-17, 8.135951656e-24, -1.330400526e-31,
  8.327027956e-10, 7.342738037e-17, 8.135951656e-24, -1.330400526e-31,
  3.670415083e-10, 7.342738037e-17, 8.135951656e-24, -1.330400526e-31,
  1.342109202e-10, 1.791623576e-17, 1.518506361e-24, 2.613904e-31,
  1.779561221e-11, 4.038449606e-18, -1.358545683e-25, -3.443243946e-32,
  1.779561221e-11, 4.038449606e-18, -1.358545683e-25, -3.443243946e-32,
  1.779561221e-11, 4.038449606e-18, -1.358545683e-25, -3.443243946e-32,
  3.243700447e-12, 5.690024473e-19, 7.094053557e-26, 1.487136711e-32,
  3.243700447e-12, 5.690024473e-19, 7.094053557e-26, 1.487136711e-32,
  3.243700447e-12, 5.690024473e-19, 7.094053557e-26, 1.487136711e-32,
  1.424711477e-12, 1.3532163e-19, 1.924175961e-26, 2.545416018e-33,
  5.152167755e-13, 1.3532163e-19, 1.924175961e-26, 2.545416018e-33,
  6.046956013e-14, -2.036222915e-22, 6.177846108e-30, 1.082084378e-36,
  6.046956013e-14, -2.036222915e-22, 6.177846108e-30, 1.082084378e-36,
  6.046956013e-14, -2.036222915e-22, 6.177846108e-30, 1.082084378e-36,
  3.626141271e-15, -2.036222915e-22, 6.177846108e-30, 1.082084378e-36,
  3.626141271e-15, -2.036222915e-22, 6.177846108e-30, 1.082084378e-36,
  3.626141271e-15, -2.036222915e-22, 6.177846108e-30, 1.082084378e-36,
  3.626141271e-15, -2.036222915e-22, 6.177846108e-30, 1.082084378e-36,
  7.342738037e-17, 8.135951656e-24, -1.330400526e-31, 6.296048013e-40,
  7.342738037e-17, 8.135951656e-24, -1.330400526e-31, 6.296048013e-40,
  7.342738037e-17, 8.135951656e-24, -1.330400526e-31, 6.296048013e-40,
  7.342738037e-17, 8.135951656e-24, -1.330400526e-31, 6.296048013e-40,
  7.342738037e-17, 8.135951656e-24, -1.330400526e-31, 6.296048013e-40,
  7.342738037e-17, 8.135951656e-24, -1.330400526e-31, 6.296048013e-40,
  1.791623576e-17, 1.518506361e-24, 2.61390353e-31, 4.764937743e-38,
  1.791623576e-17, 1.518506361e-24, 2.61390353e-31, 4.764937743e-38,
  4.038449606e-18, -1.358545683e-25, -3.443243946e-32, 6.296048013e-40,
  4.038449606e-18, -1.358545683e-25, -3.443243946e-32, 6.296048013e-40,
  5.690024473e-19, 7.094053557e-26, 1.487136711e-32, 6.296048013e-40,
  5.690024473e-19, 7.094053557e-26, 1.487136711e-32, 6.296048013e-40,
  5.690024473e-19, 7.094053557e-26, 1.487136711e-32, 6.296048013e-40,
  1.3532163e-19, 1.924175961e-26, 2.545415467e-33, 6.296048013e-40,
  1.3532163e-19, 1.924175961e-26, 2.545415467e-33, 6.296048013e-40,
  2.690143217e-20, -1.452834402e-28, -6.441077673e-36, -1.764234767e-42,
  2.690143217e-20, -1.452834402e-28, -6.441077673e-36, -1.764234767e-42,
  2.690143217e-20, -1.452834402e-28, -6.441077673e-36, -1.764234767e-42,
  1.334890502e-20, -1.452834402e-28, -6.441077673e-36, -1.764234767e-42,
  6.572641438e-21, -1.452834402e-28, -6.441077673e-36, -1.764234767e-42,
  0.05874381959, 1.222115387e-08, 7.693612965e-16, 1.792054435e-22,
  0.02749382704, 4.77057327e-09, 7.693612965e-16, 1.792054435e-22,
  0.01186883077, 1.045283415e-09, 3.252721926e-16, 7.332633139e-23,
  0.00405633077, 1.045283415e-09, 3.252721926e-16, 7.332633139e-23,
  0.000150081818, -2.454155802e-12, 1.161414894e-20, 1.291319272e-27,
  0.000150081818, -2.454155802e-12, 1.161414894e-20, 1.291319272e-27,
  0.000150081818, -2.454155802e-12, 1.161414894e-20, 1.291319272e-27,
  0.000150081818, -2.454155802e-12, 1.161414894e-20, 1.291319272e-27,
  0.000150081818, -2.454155802e-12, 1.161414894e-20, 1.291319272e-27,
  2.801149822e-05, 4.821800945e-12, 8.789757674e-19, 1.208447639e-25,
  2.801149822e-05, 4.821800945e-12, 8.789757674e-19, 1.208447639e-25,
  2.801149822e-05, 4.821800945e-12, 8.789757674e-19, 1.208447639e-25,
  1.275271279e-05, 1.183823005e-12, 1.161414894e-20, 1.291319272e-27,
  5.12331826e-06, 1.183823005e-12, 1.161414894e-20, 1.291319272e-27,
  1.308621904e-06, 2.743283031e-13, 1.161414894e-20, 1.291319272e-27,
  1.308621904e-06, 2.743283031e-13, 1.161414894e-20, 1.291319272e-27,
  3.549478151e-07, 4.695462769e-14, 1.161414894e-20, 1.291319272e-27,
  3.549478151e-07, 4.695462769e-14, 1.161414894e-20, 1.291319272e-27,
  1.165292645e-07, 1.853292503e-14, 4.837885366e-21, 1.291319272e-27,
  1.165292645e-07, 1.853292503e-14, 4.837885366e-21, 1.291319272e-27,
  5.69246339e-08, 4.322073705e-15, 1.449754789e-21, 7.962890365e-29,
  2.712231151e-08, 4.322073705e-15, 1.449754789e-21, 7.962890365e-29,
  1.222115387e-08, 7.693612965e-16, 1.792054182e-22, 2.91418027e-29,
  4.77057327e-09, 7.693612965e-16, 1.792054182e-22, 2.91418027e-29,
  1.045283415e-09, 3.252721926e-16, 7.332632508e-23, 3.898253736e-30,
  1.045283415e-09, 3.252721926e-16, 7.332632508e-23, 3.898253736e-30,
  1.139611461e-10, 1.996093359e-17, 5.344349223e-25, 1.511644828e-31,
  1.139611461e-10, 1.996093359e-17, 5.344349223e-25, 1.511644828e-31,
  1.139611461e-10, 1.996093359e-17, 5.344349223e-25, 1.511644828e-31,
  1.139611461e-10, 1.996093359e-17, 5.344349223e-25, 1.511644828e-31,
  5.575349904e-11, 6.083145782e-18, 5.344349223e-25, 1.511644828e-31,
  2.664967552e-11, -8.557475018e-19, -8.595036458e-26, -2.139883875e-32,
  1.209775682e-11, 2.61369883e-18, 5.344349223e-25, 1.511644828e-31,
  4.821800945e-12, 8.789757674e-19, 1.208447639e-25, 3.253064536e-33,
  1.183823005e-12, 1.161414894e-20, 1.29131908e-27, 1.715766248e-34,
  1.183823005e-12, 1.161414894e-20, 1.29131908e-27, 1.715766248e-34,
  2.743283031e-13, 1.161414894e-20, 1.29131908e-27, 1.715766248e-34,
};
#endif // #ifndef __SLEEF_REMPITAB__

#if !defined(__NVCC__) && ((defined(__SIZEOF_FLOAT128__) && __SIZEOF_FLOAT128__ == 16) || (defined(__linux__) && defined(__GNUC__) && (defined(__i386__) || defined(__x86_64__))) || (defined(__PPC64__) && defined(__GNUC__) && !defined(__clang__) && __GNUC__ >= 8))
#define SLEEF_FLOAT128_IS_IEEEQP
#endif

#if !defined(SLEEF_FLOAT128_IS_IEEEQP) && !defined(__NVCC__) && defined(__SIZEOF_LONG_DOUBLE__) && __SIZEOF_LONG_DOUBLE__ == 16 && (defined(__aarch64__) || defined(__zarch__))
#define SLEEF_LONGDOUBLE_IS_IEEEQP
#endif

#if !defined(Sleef_quad_DEFINED)
#define Sleef_quad_DEFINED
typedef struct { uint64_t x, y; } Sleef_uint64_2t;
#if defined(SLEEF_FLOAT128_IS_IEEEQP)
typedef __float128 Sleef_quad;
#define SLEEF_QUAD_C(x) (x ## Q)
#elif defined(SLEEF_LONGDOUBLE_IS_IEEEQP)
typedef long double Sleef_quad;
#define SLEEF_QUAD_C(x) (x ## L)
#else
typedef Sleef_uint64_2t Sleef_quad;
#endif
#endif

extern const double Sleef_rempitabdp[];

static SLEEF_ALWAYS_INLINE vfloat64m1x4_t __riscv_vcreate_v_f64m1x4(vfloat64m1_t x, vfloat64m1_t y, vfloat64m1_t z, vfloat64m1_t w) {
    vfloat64m1x4_t unused;
    return __riscv_vset(__riscv_vset(__riscv_vset(__riscv_vset(unused, 0, x), 1, y), 2, z), 3, w);
}
static SLEEF_ALWAYS_INLINE vfloat64m2x4_t __riscv_vcreate_v_f64m2x4(vfloat64m2_t x, vfloat64m2_t y, vfloat64m2_t z, vfloat64m2_t w) {
    vfloat64m2x4_t unused;
    return __riscv_vset(__riscv_vset(__riscv_vset(__riscv_vset(unused, 0, x), 1, y), 2, z), 3, w);
}

typedef vuint32m1_t rvv_vmask32;
typedef vuint64m1_t vmask_rvvm1_sleef;
typedef vbool32_t rvv_sp_vopmask_rvvm1_sleef;
typedef vbool64_t rvv_dp_vopmask_rvvm1_sleef;

typedef vint32mf2_t vint_rvvm1_sleef;
typedef vint64m1_t vint64_rvvm1_sleef;
typedef vuint64m1_t vuint64_rvvm1_sleef;
typedef vfloat64m1_t vdouble_rvvm1_sleef;
typedef vfloat64m2_t vdouble2_rvvm1_sleef;
typedef vfloat64m4_t vdouble3_rvvm1_sleef;
typedef vfloat64m4_t dd2_rvvm1_sleef;
typedef vuint64m2_t vquad_rvvm1_sleef;
typedef vint32m2_t di_t_rvvm1_sleef;
typedef vint32m4_t ddi_t_rvvm1_sleef;
typedef vfloat32m1_t vfloat_rvvm1_sleef;
typedef vfloat32m2_t vfloat2_rvvm1_sleef;
typedef vfloat32m4_t df2_rvvm1_sleef;
typedef vint32m1_t vint2_rvvm1_sleef;
typedef vint32m2_t fi_t_rvvm1_sleef;
typedef vint32m4_t dfi_t_rvvm1_sleef;
typedef vuint64m1_t rvv_dp_vuint2;

typedef vfloat64m1x4_t tdx_rvvm1_sleef;
typedef vfloat64m1x4_t tdi_t_rvvm1_sleef;

typedef vquad_rvvm1_sleef vargquad_rvvm1_sleef;

static SLEEF_ALWAYS_INLINE int vavailability_i_rvvm1_sleef(int name) {

  return (__riscv_vsetvlmax_e64m1() >= __riscv_vsetvlmax_e64m1()) ? 3 : 0;
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef figetd_vf_di_rvvm1_sleef(fi_t_rvvm1_sleef d) {
  return __riscv_vreinterpret_f32m1(__riscv_vget_i32m1(d, 0));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef figeti_vi2_di_rvvm1_sleef(fi_t_rvvm1_sleef d) {
  return __riscv_vget_i32m1(d, 1);
}
static SLEEF_ALWAYS_INLINE fi_t_rvvm1_sleef fisetdi_fi_vf_vi2_rvvm1_sleef(vfloat_rvvm1_sleef d, vint2_rvvm1_sleef i) {
  vint2_rvvm1_sleef vdi = __riscv_vreinterpret_i32m1(d);
  return __riscv_vset(__riscv_vlmul_ext_v_i32m1_i32m2(vdi), 1, i);
}
static SLEEF_ALWAYS_INLINE vfloat2_rvvm1_sleef dfigetdf_vf2_dfi_rvvm1_sleef(dfi_t_rvvm1_sleef d) {
  return __riscv_vreinterpret_f32m2(__riscv_vget_i32m2(d, 0));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef dfigeti_vi2_dfi_rvvm1_sleef(dfi_t_rvvm1_sleef d) {
  return __riscv_vget_i32m1(d, 2);
}
static SLEEF_ALWAYS_INLINE dfi_t_rvvm1_sleef dfisetdfi_dfi_vf2_vi2_rvvm1_sleef(vfloat2_rvvm1_sleef v, vint2_rvvm1_sleef i) {
  fi_t_rvvm1_sleef vi = __riscv_vreinterpret_i32m2(v);
  fi_t_rvvm1_sleef ix = __riscv_vmv_v(__riscv_vlmul_ext_v_i32m1_i32m2(i), __riscv_vsetvlmax_e32m1());
  return __riscv_vset(__riscv_vlmul_ext_v_i32m2_i32m4(vi), 1, ix);
}
static SLEEF_ALWAYS_INLINE dfi_t_rvvm1_sleef dfisetdf_dfi_dfi_vf2_rvvm1_sleef(dfi_t_rvvm1_sleef dfi_rvvm1_sleef, vfloat2_rvvm1_sleef v) {
  return __riscv_vset(dfi_rvvm1_sleef, 0, __riscv_vreinterpret_i32m2(v));
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vf2getx_vf_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef v) {
  return __riscv_vget_f32m1(v, 0);
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vf2gety_vf_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef v) {
  return __riscv_vget_f32m1(v, 1);
}
static SLEEF_ALWAYS_INLINE vfloat2_rvvm1_sleef vf2setxy_vf2_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vset(__riscv_vlmul_ext_v_f32m1_f32m2(x), 1, y);
}
static SLEEF_ALWAYS_INLINE vfloat2_rvvm1_sleef vf2setx_vf2_vf2_vf_rvvm1_sleef(vfloat2_rvvm1_sleef v, vfloat_rvvm1_sleef d) {
  return __riscv_vset(v, 0, d);
}
static SLEEF_ALWAYS_INLINE vfloat2_rvvm1_sleef vf2sety_vf2_vf2_vf_rvvm1_sleef(vfloat2_rvvm1_sleef v, vfloat_rvvm1_sleef d) {
  return __riscv_vset(v, 1, d);
}

static df2_rvvm1_sleef df2setab_df2_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef a, vfloat2_rvvm1_sleef b) {
  return __riscv_vset(__riscv_vlmul_ext_v_f32m2_f32m4(a), 1, b);
}
static vfloat2_rvvm1_sleef df2geta_vf2_df2_rvvm1_sleef(df2_rvvm1_sleef d) { return __riscv_vget_f32m2(d, 0); }
static vfloat2_rvvm1_sleef df2getb_vf2_df2_rvvm1_sleef(df2_rvvm1_sleef d) { return __riscv_vget_f32m2(d, 1); }
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vreinterpret_vi2_vf_rvvm1_sleef(vfloat_rvvm1_sleef vf) {
  return __riscv_vreinterpret_i32m1(vf);
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vreinterpret_vf_vi2_rvvm1_sleef(vint2_rvvm1_sleef vi) {
  return __riscv_vreinterpret_f32m1(vi);
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vcast_vf_f_rvvm1_sleef(float f) {
  return __riscv_vfmv_v_f_f32m1(f, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vrint_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef vd_rvvm1_sleef) {
  return __riscv_vfcvt_f_x_v_f32m1(__riscv_vfcvt_x_f_v_i32m1_rm(vd_rvvm1_sleef, __RISCV_FRM_RNE, (__riscv_vsetvlmax_e32m1())), (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vcast_vf_vi2_rvvm1_sleef(vint2_rvvm1_sleef vi) {
  return __riscv_vfcvt_f(vi, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vcast_vi2_i_rvvm1_sleef(int i) {
  return __riscv_vmv_v_x_i32m1(i, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vrint_vi2_vf_rvvm1_sleef(vfloat_rvvm1_sleef vf) {
  return __riscv_vfcvt_x_f_v_i32m1_rm(vf, __RISCV_FRM_RNE, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vtruncate_vi2_vf_rvvm1_sleef(vfloat_rvvm1_sleef vf) {
  return __riscv_vfcvt_rtz_x(vf, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vtruncate_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef vf) {
  return vcast_vf_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(vf));
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vload_vf_p_rvvm1_sleef(const float *ptr) {
  return __riscv_vle32_v_f32m1(ptr, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vloadu_vf_p_rvvm1_sleef(const float *ptr) {
  return __riscv_vle32_v_f32m1(ptr, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE void vstore_v_p_vf_rvvm1_sleef(float *ptr, vfloat_rvvm1_sleef v) {
  __riscv_vse32(ptr, v, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE void vstoreu_v_p_vf_rvvm1_sleef(float *ptr, vfloat_rvvm1_sleef v) {
  __riscv_vse32(ptr, v, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE void vstoreu_v_p_vi2_rvvm1_sleef(int32_t *ptr, vint2_rvvm1_sleef v) {
  __riscv_vse32(ptr, v, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vgather_vf_p_vi2_rvvm1_sleef(const float *ptr, vint2_rvvm1_sleef vi2) {
  return __riscv_vluxei32(ptr, __riscv_vmul(__riscv_vreinterpret_u32m1(vi2), sizeof(float), (__riscv_vsetvlmax_e32m1())), (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vadd_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vfadd(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vsub_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vfsub(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vmul_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vfmul(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vdiv_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vfdiv(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vmax_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vfmax(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vmin_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vfmin(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vrec_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  return __riscv_vfdiv(vcast_vf_f_rvvm1_sleef(1.0f), d, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vsqrt_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  return __riscv_vfsqrt(d, (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vmla_vf_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef z) {
  return __riscv_vfmadd(x, y, z, (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vmlanp_vf_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef z) {
  return __riscv_vfnmsub(x, y, z, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vmlapn_vf_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef z) {
  return __riscv_vfmsub(x, y, z, (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vfma_vf_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef z) {
  return __riscv_vfmadd(x, y, z, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vfmanp_vf_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef z) {
  return __riscv_vfnmsub(x, y, z, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vfmapn_vf_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef z) {
  return __riscv_vfmsub(x, y, z, (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vmulsign_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vfsgnjx(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vcopysign_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vfsgnj(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vsign_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef f) {
  return __riscv_vfsgnj(__riscv_vfmv_v_f_f32m1(1.0f, (__riscv_vsetvlmax_e32m1())), f, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vorsign_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vint2_rvvm1_sleef xi = __riscv_vreinterpret_i32m1(x);
  vint2_rvvm1_sleef yi = __riscv_vreinterpret_i32m1(y);
  vint2_rvvm1_sleef xioryi = __riscv_vor(xi, yi, (__riscv_vsetvlmax_e32m1()));
  vfloat_rvvm1_sleef xory = __riscv_vreinterpret_f32m1(xioryi);
  return __riscv_vfsgnj(x, xory, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vabs_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef f) {
  return __riscv_vfabs(f, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vneg_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef f) {
  return __riscv_vfneg(f, (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vadd_vi2_vi2_vi2_rvvm1_sleef(vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return __riscv_vadd(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vsub_vi2_vi2_vi2_rvvm1_sleef(vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return __riscv_vsub(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vneg_vi2_vi2_rvvm1_sleef(vint2_rvvm1_sleef x) {
  return __riscv_vneg(x, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vand_vi2_vi2_vi2_rvvm1_sleef(vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return __riscv_vand(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vandnot_vi2_vi2_vi2_rvvm1_sleef(vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return __riscv_vand(__riscv_vnot(x, (__riscv_vsetvlmax_e32m1())), y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vor_vi2_vi2_vi2_rvvm1_sleef(vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return __riscv_vor(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vxor_vi2_vi2_vi2_rvvm1_sleef(vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return __riscv_vxor(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vsll_vi2_vi2_i_rvvm1_sleef(vint2_rvvm1_sleef x, int c) {
  return __riscv_vsll(x, c, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vsra_vi2_vi2_i_rvvm1_sleef(vint2_rvvm1_sleef x, int c) {
  return __riscv_vsra(x, c, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vsrl_vi2_vi2_i_rvvm1_sleef(vint2_rvvm1_sleef x, int c) {
  return __riscv_vreinterpret_i32m1(__riscv_vsrl(__riscv_vreinterpret_u32m1(x), c, (__riscv_vsetvlmax_e32m1())));
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vreinterpret_vf_vm_rvvm1_sleef(vmask_rvvm1_sleef vm) {
  return __riscv_vreinterpret_f32m1(__riscv_vreinterpret_u32m1(vm));
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vreinterpret_vm_vf_rvvm1_sleef(vfloat_rvvm1_sleef vf) {
  return __riscv_vreinterpret_u64m1(__riscv_vreinterpret_u32m1(vf));
}

static SLEEF_ALWAYS_INLINE int vtestallones_i_vo32_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef g) {
  return __riscv_vcpop(g, (__riscv_vsetvlmax_e32m1())) == (__riscv_vsetvlmax_e32m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  rvv_vmask32 y32 = __riscv_vreinterpret_u32m1(y);
  return __riscv_vreinterpret_u64m1(__riscv_vmerge(y32, -1, x, (__riscv_vsetvlmax_e32m1())));
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vand_vm_vo32_vm_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  rvv_vmask32 y32 = __riscv_vreinterpret_u32m1(y);
  return __riscv_vreinterpret_u64m1(__riscv_vmerge(y32, 0, __riscv_vmnot(x, (__riscv_vsetvlmax_e32m1())), (__riscv_vsetvlmax_e32m1())));
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vandnot_vm_vo32_vm_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  rvv_vmask32 y32 = __riscv_vreinterpret_u32m1(y);
  return __riscv_vreinterpret_u64m1(__riscv_vmerge(y32, 0, x, (__riscv_vsetvlmax_e32m1())));
}

static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef rvv_sp_vand_vo_vo_vo(rvv_sp_vopmask_rvvm1_sleef x, rvv_sp_vopmask_rvvm1_sleef y) {
  return __riscv_vmand(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef rvv_sp_vandnot_vo_vo_vo(rvv_sp_vopmask_rvvm1_sleef x, rvv_sp_vopmask_rvvm1_sleef y) {
  return __riscv_vmandn(y, x, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef rvv_sp_vor_vo_vo_vo(rvv_sp_vopmask_rvvm1_sleef x, rvv_sp_vopmask_rvvm1_sleef y) {
  return __riscv_vmor(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef rvv_sp_vxor_vo_vo_vo(rvv_sp_vopmask_rvvm1_sleef x, rvv_sp_vopmask_rvvm1_sleef y) {
  return __riscv_vmxor(x, y, (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef veq_vo_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vmfeq(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef vneq_vo_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vmfne(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef vgt_vo_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vmfgt(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef vge_vo_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vmfge(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef vlt_vo_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vmflt(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef vle_vo_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vmfle(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef visnan_vo_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  return __riscv_vmfne(d, d, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef visinf_vo_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  return __riscv_vmfeq(__riscv_vfabs(d, (__riscv_vsetvlmax_e32m1())), __builtin_inff(), (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef vispinf_vo_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  return __riscv_vmfeq(d, __builtin_inff(), (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef mask, vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  return __riscv_vmerge(y, x, mask, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vsel_vf_vo_f_f_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef mask, float v1, float v0) {
  return __riscv_vfmerge(vcast_vf_f_rvvm1_sleef(v0), v1, mask, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vsel_vf_vo_vo_f_f_f_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef o0, rvv_sp_vopmask_rvvm1_sleef o1, float d0, float d1, float d2) {
  return __riscv_vfmerge(__riscv_vfmerge(vcast_vf_f_rvvm1_sleef(d2), d1, o1, (__riscv_vsetvlmax_e32m1())), d0, o0, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vsel_vf_vo_vo_vo_f_f_f_f_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef o0, rvv_sp_vopmask_rvvm1_sleef o1, rvv_sp_vopmask_rvvm1_sleef o2, float d0, float d1, float d2, float d3) {
  return __riscv_vfmerge(__riscv_vfmerge(__riscv_vfmerge(vcast_vf_f_rvvm1_sleef(d3), d2, o2, (__riscv_vsetvlmax_e32m1())), d1, o1, (__riscv_vsetvlmax_e32m1())), d0, o0, (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef veq_vo_vi2_vi2_rvvm1_sleef(vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return __riscv_vmseq(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef vgt_vo_vi2_vi2_rvvm1_sleef(vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return __riscv_vmsgt(x, y, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vgt_vi2_vi2_vi2_rvvm1_sleef(vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  vint2_rvvm1_sleef zero = vcast_vi2_i_rvvm1_sleef(0);
  return __riscv_vmerge(zero, -1, __riscv_vmsgt(x, y, (__riscv_vsetvlmax_e32m1())), (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vsel_vi2_vo_vi2_vi2_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef m, vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return __riscv_vmerge(y, x, m, (__riscv_vsetvlmax_e32m1()));
}
static SLEEF_ALWAYS_INLINE vint2_rvvm1_sleef vand_vi2_vo_vi2_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return __riscv_vmerge(y, 0, __riscv_vmnot(x, (__riscv_vsetvlmax_e32m1())), (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE const vdouble_rvvm1_sleef vd2getx_vd_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef v) {
  return __riscv_vget_f64m1(v, 0);
}
static SLEEF_ALWAYS_INLINE const vdouble_rvvm1_sleef vd2gety_vd_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef v) {
  return __riscv_vget_f64m1(v, 1);
}
static SLEEF_ALWAYS_INLINE const vdouble2_rvvm1_sleef vd2setxy_vd2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vset(__riscv_vlmul_ext_v_f64m1_f64m2(x), 1, y);
}
static SLEEF_ALWAYS_INLINE const vdouble2_rvvm1_sleef vd2setx_vd2_vd2_vd_rvvm1_sleef(vdouble2_rvvm1_sleef v, vdouble_rvvm1_sleef d) {
  return __riscv_vset(v, 0, d);
}
static SLEEF_ALWAYS_INLINE const vdouble2_rvvm1_sleef vd2sety_vd2_vd2_vd_rvvm1_sleef(vdouble2_rvvm1_sleef v, vdouble_rvvm1_sleef d) {
  return __riscv_vset(v, 1, d);
}

static dd2_rvvm1_sleef dd2setab_dd2_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef a, vdouble2_rvvm1_sleef b) {
  return __riscv_vset(__riscv_vlmul_ext_v_f64m2_f64m4(a), 1, b);
}
static vdouble2_rvvm1_sleef dd2geta_vd2_dd2_rvvm1_sleef(dd2_rvvm1_sleef d) { return __riscv_vget_f64m2(d, 0); }
static vdouble2_rvvm1_sleef dd2getb_vd2_dd2_rvvm1_sleef(dd2_rvvm1_sleef d) { return __riscv_vget_f64m2(d, 1); }

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vd3getx_vd_vd3_rvvm1_sleef(vdouble3_rvvm1_sleef v) { return __riscv_vget_f64m1(v, 0); }
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vd3gety_vd_vd3_rvvm1_sleef(vdouble3_rvvm1_sleef v) { return __riscv_vget_f64m1(v, 1); }
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vd3getz_vd_vd3_rvvm1_sleef(vdouble3_rvvm1_sleef v) { return __riscv_vget_f64m1(v, 2); }
static SLEEF_ALWAYS_INLINE vdouble3_rvvm1_sleef vd3setxyz_vd3_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) {
  return __riscv_vset(__riscv_vlmul_ext_v_f64m2_f64m4(__riscv_vset(__riscv_vlmul_ext_v_f64m1_f64m2(x), 1, y)), 1, __riscv_vmv_v(__riscv_vlmul_ext_v_f64m1_f64m2(z), __riscv_vsetvlmax_e64m1()));
}
static SLEEF_ALWAYS_INLINE vdouble3_rvvm1_sleef vd3setx_vd3_vd3_vd_rvvm1_sleef(vdouble3_rvvm1_sleef v, vdouble_rvvm1_sleef d) { return __riscv_vset(v, 0, d); }
static SLEEF_ALWAYS_INLINE vdouble3_rvvm1_sleef vd3sety_vd3_vd3_vd_rvvm1_sleef(vdouble3_rvvm1_sleef v, vdouble_rvvm1_sleef d) { return __riscv_vset(v, 1, d); }
static SLEEF_ALWAYS_INLINE vdouble3_rvvm1_sleef vd3setz_vd3_vd3_vd_rvvm1_sleef(vdouble3_rvvm1_sleef v, vdouble_rvvm1_sleef d) { return __riscv_vset(v, 2, d); }

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef digetd_vd_di_rvvm1_sleef(di_t_rvvm1_sleef d) {
  vint2_rvvm1_sleef vi = __riscv_vget_i32m1(d, 0);
  return __riscv_vreinterpret_f64m1(__riscv_vreinterpret_i64m1(vi));
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef digeti_vi_di_rvvm1_sleef(di_t_rvvm1_sleef d) {
  vint2_rvvm1_sleef vi = __riscv_vget_i32m1(d, 1);
  return __riscv_vlmul_trunc_i32mf2(vi);
}
static SLEEF_ALWAYS_INLINE di_t_rvvm1_sleef disetdi_di_vd_vi_rvvm1_sleef(vdouble_rvvm1_sleef d, vint_rvvm1_sleef i) {
  vint2_rvvm1_sleef vd_rvvm1_sleef = __riscv_vreinterpret_i32m1(__riscv_vreinterpret_i64m1(d));
  vint2_rvvm1_sleef vi = __riscv_vmv_v(__riscv_vlmul_ext_v_i32mf2_i32m1(i), __riscv_vsetvlmax_e32mf2());
  return __riscv_vset(__riscv_vlmul_ext_v_i32m1_i32m2(vd_rvvm1_sleef), 1, vi);
}

static SLEEF_ALWAYS_INLINE vdouble2_rvvm1_sleef ddigetdd_vd2_ddi_rvvm1_sleef(ddi_t_rvvm1_sleef d) {
  return __riscv_vget_f64m2(__riscv_vreinterpret_f64m4(__riscv_vreinterpret_v_i32m4_i64m4(d)), 0);
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef ddigeti_vi_ddi_rvvm1_sleef(ddi_t_rvvm1_sleef d) {
  vint2_rvvm1_sleef vi2 = __riscv_vget_i32m1(d, 2);
  return __riscv_vlmul_trunc_i32mf2(vi2);
}
static SLEEF_ALWAYS_INLINE ddi_t_rvvm1_sleef ddisetddi_ddi_vd2_vi_rvvm1_sleef(vdouble2_rvvm1_sleef v, vint_rvvm1_sleef i) {
  di_t_rvvm1_sleef vdi = __riscv_vreinterpret_i32m2(__riscv_vreinterpret_i64m2(v));
  return __riscv_vset(__riscv_vlmul_ext_v_i32m2_i32m4(vdi), 1, __riscv_vmv_v(__riscv_vlmul_ext_v_i32mf2_i32m2(i), __riscv_vsetvlmax_e32mf2()));
}
static SLEEF_ALWAYS_INLINE ddi_t_rvvm1_sleef ddisetdd_ddi_ddi_vd2_rvvm1_sleef(ddi_t_rvvm1_sleef ddi_rvvm1_sleef, vdouble2_rvvm1_sleef v) {
  di_t_rvvm1_sleef vdi = __riscv_vreinterpret_i32m2(__riscv_vreinterpret_i64m2(v));
  return __riscv_vset(ddi_rvvm1_sleef, 0, vdi);
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vcast_vd_d_rvvm1_sleef(double d) {
  return __riscv_vfmv_v_f_f64m1(d, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vcast_vd_vi_rvvm1_sleef(vint_rvvm1_sleef i) {
  return __riscv_vfwcvt_f(i, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vcast_vi_i_rvvm1_sleef(int32_t i) {
  return __riscv_vmv_v_x_i32mf2(i, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vrint_vi_vd_rvvm1_sleef(vdouble_rvvm1_sleef vd_rvvm1_sleef) {
  return __riscv_vfncvt_x_f_w_i32mf2_rm(vd_rvvm1_sleef, __RISCV_FRM_RNE, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vrint_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef vd_rvvm1_sleef) {
  return __riscv_vfcvt_f_x_v_f64m1(__riscv_vfcvt_x_f_v_i64m1_rm(vd_rvvm1_sleef, __RISCV_FRM_RNE, __riscv_vsetvlmax_e64m1()), __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vtruncate_vi_vd_rvvm1_sleef(vdouble_rvvm1_sleef vd_rvvm1_sleef) {
  return __riscv_vfncvt_rtz_x(vd_rvvm1_sleef, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vtruncate_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef vd_rvvm1_sleef) {
  return vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(vd_rvvm1_sleef));
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vload_vd_p_rvvm1_sleef(const double *ptr) {
  return __riscv_vle64_v_f64m1(ptr, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vloadu_vd_p_rvvm1_sleef(const double *ptr) {
  return __riscv_vle64_v_f64m1(ptr, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vloadu_vi_p_rvvm1_sleef(int32_t *p) {
  return __riscv_vle32_v_i32mf2(p, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE void vstore_v_p_vd_rvvm1_sleef(double *ptr, vdouble_rvvm1_sleef v) {
  __riscv_vse64(ptr, v, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE void vstoreu_v_p_vd_rvvm1_sleef(double *ptr, vdouble_rvvm1_sleef v) {
  __riscv_vse64(ptr, v, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE void vstoreu_v_p_vi_rvvm1_sleef(int32_t *ptr, vint_rvvm1_sleef v) {
  __riscv_vse32(ptr, v, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vgather_vd_p_vi_rvvm1_sleef(const double *ptr, vint_rvvm1_sleef vi) {
  return __riscv_vluxei64(ptr, __riscv_vwmulu(__riscv_vreinterpret_u32mf2(vi), sizeof(double), __riscv_vsetvlmax_e64m1()), __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vadd_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vfadd(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vsub_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vfsub(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vrec_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return __riscv_vfdiv(vcast_vd_d_rvvm1_sleef(1.0), d, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vabs_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return __riscv_vfabs(d, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vsqrt_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return __riscv_vfsqrt(d, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vmul_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vfmul(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vdiv_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vfdiv(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vmax_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vfmax(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vmin_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vfmin(x, y, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vmla_vd_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) {
  return __riscv_vfmadd(x, y, z, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vmlapn_vd_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) {
  return __riscv_vfmsub(x, y, z, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vmlanp_vd_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) {
  return __riscv_vfnmsac(z, x, y, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vfma_vd_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) {
  return __riscv_vfmadd(x, y, z, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vfmanp_vd_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) {
  return __riscv_vfnmsub(x, y, z, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vfmapn_vd_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) {
  return __riscv_vfmsub(x, y, z, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vmulsign_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vfsgnjx(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vcopysign_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vfsgnj(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vorsign_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vfsgnj(x, __riscv_vreinterpret_f64m1(__riscv_vreinterpret_i64m1(__riscv_vor(__riscv_vreinterpret_u64m1(x), __riscv_vreinterpret_u64m1(y), __riscv_vsetvlmax_e64m1()))), __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vneg_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return __riscv_vfneg(d, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vadd_vi_vi_vi_rvvm1_sleef(vint_rvvm1_sleef x, vint_rvvm1_sleef y) {
  return __riscv_vadd(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vsub_vi_vi_vi_rvvm1_sleef(vint_rvvm1_sleef x, vint_rvvm1_sleef y) {
  return __riscv_vsub(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vneg_vi_vi_rvvm1_sleef(vint_rvvm1_sleef x) {
  return __riscv_vneg(x, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vand_vi_vi_vi_rvvm1_sleef(vint_rvvm1_sleef x, vint_rvvm1_sleef y) {
  return __riscv_vand(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vandnot_vi_vi_vi_rvvm1_sleef(vint_rvvm1_sleef x, vint_rvvm1_sleef y) {
  return __riscv_vand(__riscv_vnot(x, __riscv_vsetvlmax_e64m1()), y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vor_vi_vi_vi_rvvm1_sleef(vint_rvvm1_sleef x, vint_rvvm1_sleef y) {
  return __riscv_vor(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vxor_vi_vi_vi_rvvm1_sleef(vint_rvvm1_sleef x, vint_rvvm1_sleef y) {
  return __riscv_vxor(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vsll_vi_vi_i_rvvm1_sleef(vint_rvvm1_sleef x, int c) {
  return __riscv_vsll(x, c, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vsra_vi_vi_i_rvvm1_sleef(vint_rvvm1_sleef x, int c) {
  return __riscv_vsra(x, c, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vsrl_vi_vi_i_rvvm1_sleef(vint_rvvm1_sleef x, int c) {
  return __riscv_vreinterpret_i32mf2(__riscv_vsrl(__riscv_vreinterpret_u32mf2(x), c, __riscv_vsetvlmax_e64m1()));
}

static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vcast_vm_i64_rvvm1_sleef(int64_t c) {
  return __riscv_vmv_v_x_u64m1(c, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vcast_vm_u64_rvvm1_sleef(uint64_t c) {
  return __riscv_vmv_v_x_u64m1(c, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vcast_vm_i_i_rvvm1_sleef(int64_t h, int64_t l) {
  return __riscv_vmv_v_x_u64m1((((uint64_t)h) << 32) | (uint32_t) l, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vcast_vm_vi_rvvm1_sleef(vint_rvvm1_sleef vi) {
  return __riscv_vreinterpret_u64m1(__riscv_vwcvt_x(vi, __riscv_vsetvlmax_e64m1()));
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vcastu_vm_vi_rvvm1_sleef(vint_rvvm1_sleef vi) {
  return __riscv_vsll(__riscv_vreinterpret_u64m1(__riscv_vwcvt_x(vi, __riscv_vsetvlmax_e64m1())), 32, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vcastu_vi_vm_rvvm1_sleef(vmask_rvvm1_sleef vm) {
  return __riscv_vreinterpret_i32mf2(__riscv_vnsrl(vm, 32, __riscv_vsetvlmax_e64m1()));
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vcast_vi_vm_rvvm1_sleef(vmask_rvvm1_sleef vm) {
  return __riscv_vreinterpret_i32mf2(__riscv_vncvt_x(vm, __riscv_vsetvlmax_e64m1()));
}

static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vand_vm_vo64_vm_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vmerge(y, 0, __riscv_vmnot(x, __riscv_vsetvlmax_e64m1()), __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vand_vm_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vand(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vor_vm_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vor(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vxor_vm_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vxor(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vandnot_vm_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vand(__riscv_vnot(x, __riscv_vsetvlmax_e64m1()), y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vandnot_vm_vo64_vm_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vmerge(y, 0, x, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vsll64_vm_vm_i(vmask_rvvm1_sleef mask, int64_t c) {
  return __riscv_vsll(mask, c, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vsub64_vm_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vsub(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vsrl64_vm_vm_i(vmask_rvvm1_sleef mask, int64_t c) {
  return __riscv_vsrl(mask, c, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vadd64_vm_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vadd(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vmerge(y, -1, x, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vsel_vm_vo64_vm_vm_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef mask, vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vmerge(y, x, mask, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vneg64_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef mask) {
  return __riscv_vreinterpret_u64m1(__riscv_vneg(__riscv_vreinterpret_i64m1(mask), __riscv_vsetvlmax_e64m1()));
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vreinterpret_vd_vm_rvvm1_sleef(vmask_rvvm1_sleef vm) {
  return __riscv_vreinterpret_f64m1(__riscv_vreinterpret_i64m1(vm));
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vreinterpret_vm_vd_rvvm1_sleef(vdouble_rvvm1_sleef vd_rvvm1_sleef) {
  return __riscv_vreinterpret_u64m1(vd_rvvm1_sleef);
}

static SLEEF_ALWAYS_INLINE const vmask_rvvm1_sleef vqgetx_vm_vq_rvvm1_sleef(vquad_rvvm1_sleef v) { return __riscv_vget_u64m1(v, 0); }
static SLEEF_ALWAYS_INLINE const vmask_rvvm1_sleef vqgety_vm_vq_rvvm1_sleef(vquad_rvvm1_sleef v) { return __riscv_vget_u64m1(v, 1); }
static SLEEF_ALWAYS_INLINE vquad_rvvm1_sleef vqsetxy_vq_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vset(__riscv_vlmul_ext_v_u64m1_u64m2(x), 1, y);
}
static SLEEF_ALWAYS_INLINE vquad_rvvm1_sleef vqsetx_vq_vq_vm_rvvm1_sleef(vquad_rvvm1_sleef v, vmask_rvvm1_sleef x) { return __riscv_vset(v, 0, x); }
static SLEEF_ALWAYS_INLINE vquad_rvvm1_sleef vqsety_vq_vq_vm_rvvm1_sleef(vquad_rvvm1_sleef v, vmask_rvvm1_sleef y) { return __riscv_vset(v, 1, y); }

static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vcast_vo64_vo32_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef vo) {
  return vo;
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vcast_vo32_vo64_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef vo) {
  return vo;
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef rvv_dp_vand_vo_vo_vo(rvv_dp_vopmask_rvvm1_sleef x, rvv_dp_vopmask_rvvm1_sleef y) {
  return __riscv_vmand(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef rvv_dp_vandnot_vo_vo_vo(rvv_dp_vopmask_rvvm1_sleef x, rvv_dp_vopmask_rvvm1_sleef y) {
  return __riscv_vmandn(y, x, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef rvv_dp_vor_vo_vo_vo(rvv_dp_vopmask_rvvm1_sleef x, rvv_dp_vopmask_rvvm1_sleef y) {
  return __riscv_vmor(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef rvv_dp_vxor_vo_vo_vo(rvv_dp_vopmask_rvvm1_sleef x, rvv_dp_vopmask_rvvm1_sleef y) {
  return __riscv_vmxor(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef veq64_vo_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vmseq(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vgt64_vo_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  return __riscv_vmsgt(__riscv_vreinterpret_i64m1(x), __riscv_vreinterpret_i64m1(y), __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef visinf_vo_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return __riscv_vmfeq(__riscv_vfabs(d, __riscv_vsetvlmax_e64m1()), __builtin_inf(), __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vispinf_vo_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return __riscv_vmfeq(d, __builtin_inf(), __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef veq_vo_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vmfeq(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vneq_vo_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vmfne(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vlt_vo_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vmflt(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vle_vo_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vmfle(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vgt_vo_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vmfgt(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vge_vo_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vmfge(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef visnan_vo_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return __riscv_vmfne(d, d, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef mask, vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  return __riscv_vmerge(y, x, mask, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vsel_vd_vo_d_d_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef mask, double v0, double v1) {
  return __riscv_vfmerge(vcast_vd_d_rvvm1_sleef(v1), v0, mask, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vsel_vd_vo_vo_d_d_d_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef o0, rvv_dp_vopmask_rvvm1_sleef o1, double d0, double d1, double d2) {
  return __riscv_vfmerge(__riscv_vfmerge(vcast_vd_d_rvvm1_sleef(d2), d1, o1, __riscv_vsetvlmax_e64m1()), d0, o0, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef o0, rvv_dp_vopmask_rvvm1_sleef o1, rvv_dp_vopmask_rvvm1_sleef o2, double d0, double d1, double d2, double d3) {
  return __riscv_vfmerge(__riscv_vfmerge(__riscv_vfmerge(vcast_vd_d_rvvm1_sleef(d3), d2, o2, __riscv_vsetvlmax_e64m1()), d1, o1, __riscv_vsetvlmax_e64m1()), d0, o0, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE int vtestallones_i_vo64_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef g) {
  return __riscv_vcpop(g, __riscv_vsetvlmax_e64m1()) == __riscv_vsetvlmax_e64m1();
}

static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef veq_vo_vi_vi_rvvm1_sleef(vint_rvvm1_sleef x, vint_rvvm1_sleef y) {
  return __riscv_vmseq(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vgt_vo_vi_vi_rvvm1_sleef(vint_rvvm1_sleef x, vint_rvvm1_sleef y) {
  return __riscv_vmsgt(x, y, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vgt_vi_vi_vi_rvvm1_sleef(vint_rvvm1_sleef x, vint_rvvm1_sleef y) {
  vint_rvvm1_sleef zero = vcast_vi_i_rvvm1_sleef(0);
  return __riscv_vmerge(zero, -1, __riscv_vmsgt(x, y, __riscv_vsetvlmax_e64m1()), __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vsel_vi_vo_vi_vi_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef m, vint_rvvm1_sleef x, vint_rvvm1_sleef y) {
  return __riscv_vmerge(y, x, m, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vandnot_vi_vo_vi_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef mask, vint_rvvm1_sleef vi) {
  return __riscv_vmerge(vi, 0, mask, __riscv_vsetvlmax_e64m1());
}
static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef vand_vi_vo_vi_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef x, vint_rvvm1_sleef y) {
  return __riscv_vmerge(y, 0, __riscv_vmnot(x, __riscv_vsetvlmax_e64m1()), __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vposneg_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef mask = __riscv_vreinterpret_b64(__riscv_vmv_v_x_u8m1(0x55, __riscv_vsetvlmax_e8m1()));
  vdouble_rvvm1_sleef nd = __riscv_vfneg(d, __riscv_vsetvlmax_e64m1());
  return __riscv_vmerge(nd, d, mask, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vnegpos_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef mask = __riscv_vreinterpret_b64(__riscv_vmv_v_x_u8m1(0xaa, __riscv_vsetvlmax_e8m1()));
  vdouble_rvvm1_sleef nd = __riscv_vfneg(d, __riscv_vsetvlmax_e64m1());
  return __riscv_vmerge(nd, d, mask, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vposneg_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef mask = __riscv_vreinterpret_b32(__riscv_vmv_v_x_u8m1(0x55, __riscv_vsetvlmax_e8m1()));
  vfloat_rvvm1_sleef nd = __riscv_vfneg(d, (__riscv_vsetvlmax_e32m1()));
  return __riscv_vmerge(nd, d, mask, (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vnegpos_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef mask = __riscv_vreinterpret_b32(__riscv_vmv_v_x_u8m1(0xaa, __riscv_vsetvlmax_e8m1()));
  vfloat_rvvm1_sleef nd = __riscv_vfneg(d, (__riscv_vsetvlmax_e32m1()));
  return __riscv_vmerge(nd, d, mask, (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vsubadd_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) { return vadd_vd_vd_vd_rvvm1_sleef(x, vnegpos_vd_vd_rvvm1_sleef(y)); }
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vsubadd_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef d0, vfloat_rvvm1_sleef d1) { return vadd_vf_vf_vf_rvvm1_sleef(d0, vnegpos_vf_vf_rvvm1_sleef(d1)); }
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vmlsubadd_vd_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) { return vfma_vd_vd_vd_vd_rvvm1_sleef(x, y, vnegpos_vd_vd_rvvm1_sleef(z)); }
static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vmlsubadd_vf_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef z) { return vfma_vf_vf_vf_vf_rvvm1_sleef(x, y, vnegpos_vf_vf_rvvm1_sleef(z)); }

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vrev21_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef vd_rvvm1_sleef) {
  rvv_dp_vuint2 id = __riscv_vid_v_u64m1(__riscv_vsetvlmax_e64m1());
  id = __riscv_vxor(id, 1, __riscv_vsetvlmax_e64m1());
  return __riscv_vrgather(vd_rvvm1_sleef, id, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vrev21_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef vf) {
  vint2_rvvm1_sleef id = __riscv_vreinterpret_i32m1(__riscv_vid_v_u32m1((__riscv_vsetvlmax_e32m1())));
  id = __riscv_vxor(id, 1, (__riscv_vsetvlmax_e32m1()));
  return __riscv_vrgather(vf, __riscv_vreinterpret_u32m1(id), (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vreva2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef vd_rvvm1_sleef) {
  rvv_dp_vuint2 id = __riscv_vid_v_u64m1(__riscv_vsetvlmax_e64m1());
  id = __riscv_vxor(id, __riscv_vsetvlmax_e64m1() - 2, __riscv_vsetvlmax_e64m1());
  return __riscv_vrgather(vd_rvvm1_sleef, id, __riscv_vsetvlmax_e64m1());
}

static SLEEF_ALWAYS_INLINE vfloat_rvvm1_sleef vreva2_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef vf) {
  vint2_rvvm1_sleef id = __riscv_vreinterpret_i32m1(__riscv_vid_v_u32m1((__riscv_vsetvlmax_e32m1())));
  id = __riscv_vxor(id, (__riscv_vsetvlmax_e32m1()) - 2, (__riscv_vsetvlmax_e32m1()));
  return __riscv_vrgather(vf, __riscv_vreinterpret_u32m1(id), (__riscv_vsetvlmax_e32m1()));
}

static SLEEF_ALWAYS_INLINE void vscatter2_v_p_i_i_vd_rvvm1_sleef(double *ptr, int offset, int step, vdouble_rvvm1_sleef v) {

  ptr += offset * 2;
  for (int i = 0; i < __riscv_vsetvlmax_e64m1(); i += 2) {

    vdouble_rvvm1_sleef vv = __riscv_vslidedown(v, i, 2);
    __riscv_vse64(ptr, vv, 2);
    ptr += step * 2;
  }
}

static SLEEF_ALWAYS_INLINE void vscatter2_v_p_i_i_vf_rvvm1_sleef(float *ptr, int offset, int step, vfloat_rvvm1_sleef v) {

  ptr += offset * 2;
  for (int i = 0; i < (__riscv_vsetvlmax_e32m1()); i += 2) {
    vfloat_rvvm1_sleef vv = __riscv_vslidedown(v, i, 2);
    __riscv_vse32(ptr, vv, 2);
    ptr += step * 2;
  }
}

static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef tdxgete_vm_tdx_rvvm1_sleef(tdx_rvvm1_sleef t) {
  return __riscv_vreinterpret_u64m1(__riscv_vget_f64m1(t, 0));
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef tdxgetd3x_vd_tdx_rvvm1_sleef(tdx_rvvm1_sleef t) {
  return __riscv_vget_f64m1(t, 1);
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef tdxgetd3y_vd_tdx_rvvm1_sleef(tdx_rvvm1_sleef t) {
  return __riscv_vget_f64m1(t, 2);
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef tdxgetd3z_vd_tdx_rvvm1_sleef(tdx_rvvm1_sleef t) {
  return __riscv_vget_f64m1(t, 3);
}
static SLEEF_ALWAYS_INLINE tdx_rvvm1_sleef tdxsete_tdx_tdx_vm_rvvm1_sleef(tdx_rvvm1_sleef t, vmask_rvvm1_sleef e) {
  return __riscv_vset(t, 0, __riscv_vreinterpret_f64m1(__riscv_vreinterpret_i64m1(e)));
}
static SLEEF_ALWAYS_INLINE tdx_rvvm1_sleef tdxsetx_tdx_tdx_vd_rvvm1_sleef(tdx_rvvm1_sleef t, vdouble_rvvm1_sleef x) {
  return __riscv_vset(t, 1, x);
}
static SLEEF_ALWAYS_INLINE tdx_rvvm1_sleef tdxsety_tdx_tdx_vd_rvvm1_sleef(tdx_rvvm1_sleef t, vdouble_rvvm1_sleef y) {
  return __riscv_vset(t, 2, y);
}
static SLEEF_ALWAYS_INLINE tdx_rvvm1_sleef tdxsetz_tdx_tdx_vd_rvvm1_sleef(tdx_rvvm1_sleef t, vdouble_rvvm1_sleef z) {
  return __riscv_vset(t, 3, z);
}

static SLEEF_ALWAYS_INLINE vdouble3_rvvm1_sleef tdxgetd3_vd3_tdx_rvvm1_sleef(tdx_rvvm1_sleef t) {
  return vd3setxyz_vd3_vd_vd_vd_rvvm1_sleef(tdxgetd3x_vd_tdx_rvvm1_sleef(t), tdxgetd3y_vd_tdx_rvvm1_sleef(t), tdxgetd3z_vd_tdx_rvvm1_sleef(t));
}

static SLEEF_ALWAYS_INLINE tdx_rvvm1_sleef tdxsetxyz_tdx_tdx_vd_vd_vd_rvvm1_sleef(tdx_rvvm1_sleef t, vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) {
  t = tdxsetx_tdx_tdx_vd_rvvm1_sleef(t, x);
  t = tdxsety_tdx_tdx_vd_rvvm1_sleef(t, y);
  t = tdxsetz_tdx_tdx_vd_rvvm1_sleef(t, z);
  return t;
}
static SLEEF_ALWAYS_INLINE tdx_rvvm1_sleef tdxsetd3_tdx_tdx_vd3_rvvm1_sleef(tdx_rvvm1_sleef t, vdouble3_rvvm1_sleef d3) {
  return tdxsetxyz_tdx_tdx_vd_vd_vd_rvvm1_sleef(t, vd3getx_vd_vd3_rvvm1_sleef(d3), vd3gety_vd_vd3_rvvm1_sleef(d3), vd3getz_vd_vd3_rvvm1_sleef(d3));
}

static SLEEF_ALWAYS_INLINE tdx_rvvm1_sleef tdxseted3_tdx_vm_vd3_rvvm1_sleef(vmask_rvvm1_sleef e, vdouble3_rvvm1_sleef d3) {
  return __riscv_vcreate_v_f64m1x4(__riscv_vreinterpret_f64m1(__riscv_vreinterpret_i64m1(e)),
            vd3getx_vd_vd3_rvvm1_sleef(d3), vd3gety_vd_vd3_rvvm1_sleef(d3), vd3getz_vd_vd3_rvvm1_sleef(d3));
}
static SLEEF_ALWAYS_INLINE tdx_rvvm1_sleef tdxsetexyz_tdx_vm_vd_vd_vd_rvvm1_sleef(vmask_rvvm1_sleef e, vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) {
  return __riscv_vcreate_v_f64m1x4(__riscv_vreinterpret_f64m1(__riscv_vreinterpret_i64m1(e)), x, y, z);
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef tdigetx_vd_tdi_rvvm1_sleef(tdi_t_rvvm1_sleef d) {
  return __riscv_vget_f64m1(d, 0);
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef tdigety_vd_tdi(tdi_t_rvvm1_sleef d) {
  return __riscv_vget_f64m1(d, 1);
}
static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef tdigetz_vd_tdi(tdi_t_rvvm1_sleef d) {
  return __riscv_vget_f64m1(d, 2);
}

static SLEEF_ALWAYS_INLINE vint_rvvm1_sleef tdigeti_vi_tdi_rvvm1_sleef(tdi_t_rvvm1_sleef d) {
  vdouble_rvvm1_sleef vd_rvvm1_sleef = __riscv_vget_f64m1(d, 3);
  vint2_rvvm1_sleef vi2 = __riscv_vreinterpret_i32m1(__riscv_vreinterpret_i64m1(vd_rvvm1_sleef));
  vint_rvvm1_sleef vi = __riscv_vlmul_trunc_i32mf2(vi2);
  return vi;
}
static SLEEF_ALWAYS_INLINE tdi_t_rvvm1_sleef tdisetx_tdi_tdi_vd(tdi_t_rvvm1_sleef t, vdouble_rvvm1_sleef x) {
  return __riscv_vset(t, 0, x);
}
static SLEEF_ALWAYS_INLINE tdi_t_rvvm1_sleef tdisety_tdi_tdi_vd(tdi_t_rvvm1_sleef t, vdouble_rvvm1_sleef y) {
  return __riscv_vset(t, 1, y);
}
static SLEEF_ALWAYS_INLINE tdi_t_rvvm1_sleef tdisetz_tdi_tdi_vd(tdi_t_rvvm1_sleef t, vdouble_rvvm1_sleef z) {
  return __riscv_vset(t, 2, z);
}
static SLEEF_ALWAYS_INLINE tdi_t_rvvm1_sleef tdiseti_tdi_tdi_vi(tdi_t_rvvm1_sleef t, vint_rvvm1_sleef i) {
  vint2_rvvm1_sleef vi2 = __riscv_vmv_v(__riscv_vlmul_ext_v_i32mf2_i32m1(i), __riscv_vsetvlmax_e32mf2());
  vdouble_rvvm1_sleef vd_rvvm1_sleef = __riscv_vreinterpret_f64m1(__riscv_vreinterpret_i64m1(vi2));
  return __riscv_vset(t, 3, vd_rvvm1_sleef);
}

static SLEEF_ALWAYS_INLINE vdouble3_rvvm1_sleef tdigettd_vd3_tdi_rvvm1_sleef(tdi_t_rvvm1_sleef d) {
  return vd3setxyz_vd3_vd_vd_vd_rvvm1_sleef(tdigetx_vd_tdi_rvvm1_sleef(d), tdigety_vd_tdi(d), tdigetz_vd_tdi(d));
}
static SLEEF_ALWAYS_INLINE tdi_t_rvvm1_sleef tdisettd_tdi_tdi_vd3(tdi_t_rvvm1_sleef tdi, vdouble3_rvvm1_sleef v) {
  tdi = tdisetx_tdi_tdi_vd(tdi, vd3getx_vd_vd3_rvvm1_sleef(v));
  tdi = tdisety_tdi_tdi_vd(tdi, vd3gety_vd_vd3_rvvm1_sleef(v));
  tdi = tdisetz_tdi_tdi_vd(tdi, vd3getz_vd_vd3_rvvm1_sleef(v));
  return tdi;
}
static SLEEF_ALWAYS_INLINE tdi_t_rvvm1_sleef tdisettdi_tdi_vd3_vi_rvvm1_sleef(vdouble3_rvvm1_sleef v, vint_rvvm1_sleef i) {
  tdi_t_rvvm1_sleef ret = __riscv_vcreate_v_f64m1x4(vd3getx_vd_vd3_rvvm1_sleef(v), vd3gety_vd_vd3_rvvm1_sleef(v), vd3getz_vd_vd3_rvvm1_sleef(v), vd3getz_vd_vd3_rvvm1_sleef(v));
  return tdiseti_tdi_tdi_vi(ret, i);
}

static SLEEF_ALWAYS_INLINE rvv_dp_vopmask_rvvm1_sleef vcast_vo_i_rvvm1_sleef(int i) {
  return __riscv_vreinterpret_b64(__riscv_vmv_v_x_u32m1(i, (__riscv_vsetvlmax_e32m1())));
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vreinterpret_vm_vi64_rvvm1_sleef(vint64_rvvm1_sleef v) {
  return __riscv_vreinterpret_u64m1(v);
}
static SLEEF_ALWAYS_INLINE vint64_rvvm1_sleef vreinterpret_vi64_vm_rvvm1_sleef(vmask_rvvm1_sleef m) {
  return __riscv_vreinterpret_i64m1(m);
}
static SLEEF_ALWAYS_INLINE vmask_rvvm1_sleef vreinterpret_vm_vu64_rvvm1_sleef(vuint64_rvvm1_sleef v) {
  return v;
}
static SLEEF_ALWAYS_INLINE vuint64_rvvm1_sleef vreinterpret_vu64_vm_rvvm1_sleef(vmask_rvvm1_sleef m) {
  return m;
}
static SLEEF_ALWAYS_INLINE int vtestallzeros_i_vo64_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef g) {
   return __riscv_vcpop(g, __riscv_vsetvlmax_e64m1()) == 0;
}

static SLEEF_ALWAYS_INLINE void vstream_v_p_vd_rvvm1_sleef(double *ptr, vdouble_rvvm1_sleef v) { vstore_v_p_vd_rvvm1_sleef(ptr, v); }
static SLEEF_ALWAYS_INLINE void vstream_v_p_vf_rvvm1_sleef(float *ptr, vfloat_rvvm1_sleef v) { vstore_v_p_vf_rvvm1_sleef(ptr, v); }
static SLEEF_ALWAYS_INLINE void vsscatter2_v_p_i_i_vd_rvvm1_sleef(double *ptr, int offset, int step, vdouble_rvvm1_sleef v) { vscatter2_v_p_i_i_vd_rvvm1_sleef(ptr, offset, step, v); }
static SLEEF_ALWAYS_INLINE void vsscatter2_v_p_i_i_vf_rvvm1_sleef(float *ptr, int offset, int step, vfloat_rvvm1_sleef v) { vscatter2_v_p_i_i_vf_rvvm1_sleef(ptr, offset, step, v); }

static double vcast_d_vd_rvvm1_sleef(vdouble_rvvm1_sleef v) {
  return __riscv_vfmv_f(v);
}

static float vcast_f_vf_rvvm1_sleef(vfloat_rvvm1_sleef v) {
  return __riscv_vfmv_f(v);
}

static int vcast_i_vi(vint_rvvm1_sleef v) {
  return __riscv_vmv_x(v);
}

static int vcast_i_vi2(vint2_rvvm1_sleef v) {
  return __riscv_vmv_x(v);
}

static vquad_rvvm1_sleef loadu_vq_p_rvvm1_sleef(const int32_t *ptr) {

  return __riscv_vreinterpret_u64m2(__riscv_vreinterpret_u32m2(__riscv_vle32_v_i32m2(ptr, (__riscv_vsetvlmax_e32m1()) * 2)));
}

static SLEEF_ALWAYS_INLINE vquad_rvvm1_sleef cast_vq_aq_rvvm1_sleef(vargquad_rvvm1_sleef aq) { return aq; }
static SLEEF_ALWAYS_INLINE vargquad_rvvm1_sleef cast_aq_vq_rvvm1_sleef(vquad_rvvm1_sleef vq) { return vq; }

static SLEEF_ALWAYS_INLINE void vprefetch_v_p_rvvm1_sleef(const void *ptr) {}

typedef struct {
  double x, y;
} double2_rvvm1_sleef;

static SLEEF_ALWAYS_INLINE SLEEF_CONST double2_rvvm1_sleef dd_rvvm1_sleef(double h, double l) {
  double2_rvvm1_sleef ret = { h, l };
  return ret;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vupper_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return vreinterpret_vd_vm_rvvm1_sleef(vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(d), vcast_vm_i_i_rvvm1_sleef(0xffffffff, 0xf8000000)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef vcast_vd2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef h, vdouble_rvvm1_sleef l) {
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(h, l);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef vcast_vd2_d_d_rvvm1_sleef(double h, double l) {
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(h), vcast_vd_d_rvvm1_sleef(l));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef vcast_vd2_d2_rvvm1_sleef(double2_rvvm1_sleef dd_rvvm1_sleef) {
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(dd_rvvm1_sleef.x), vcast_vd_d_rvvm1_sleef(dd_rvvm1_sleef.y));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef vsel_vd2_vo_vd2_vd2_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef m, vdouble2_rvvm1_sleef x, vdouble2_rvvm1_sleef y) {
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(vsel_vd_vo_vd_vd_rvvm1_sleef(m, vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y)),
                            vsel_vd_vo_vd_vd_rvvm1_sleef(m, vd2gety_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(y)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef vsel_vd2_vo_d_d_d_d_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef o, double x1, double y1, double x0, double y0) {
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(vsel_vd_vo_d_d_rvvm1_sleef(o, x1, x0),
                            vsel_vd_vo_d_d_rvvm1_sleef(o, y1, y0));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vadd_vd_3vd_rvvm1_sleef(vdouble_rvvm1_sleef v0, vdouble_rvvm1_sleef v1, vdouble_rvvm1_sleef v2) {
  return vadd_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(v0, v1), v2);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vadd_vd_4vd_rvvm1_sleef(vdouble_rvvm1_sleef v0, vdouble_rvvm1_sleef v1, vdouble_rvvm1_sleef v2, vdouble_rvvm1_sleef v3) {
  return vadd_vd_3vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(v0, v1), v2, v3);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vadd_vd_5vd_rvvm1_sleef(vdouble_rvvm1_sleef v0, vdouble_rvvm1_sleef v1, vdouble_rvvm1_sleef v2, vdouble_rvvm1_sleef v3, vdouble_rvvm1_sleef v4) {
  return vadd_vd_4vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(v0, v1), v2, v3, v4);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vadd_vd_6vd_rvvm1_sleef(vdouble_rvvm1_sleef v0, vdouble_rvvm1_sleef v1, vdouble_rvvm1_sleef v2, vdouble_rvvm1_sleef v3, vdouble_rvvm1_sleef v4, vdouble_rvvm1_sleef v5) {
  return vadd_vd_5vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(v0, v1), v2, v3, v4, v5);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vadd_vd_7vd_rvvm1_sleef(vdouble_rvvm1_sleef v0, vdouble_rvvm1_sleef v1, vdouble_rvvm1_sleef v2, vdouble_rvvm1_sleef v3, vdouble_rvvm1_sleef v4, vdouble_rvvm1_sleef v5, vdouble_rvvm1_sleef v6) {
  return vadd_vd_6vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(v0, v1), v2, v3, v4, v5, v6);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vsub_vd_3vd_rvvm1_sleef(vdouble_rvvm1_sleef v0, vdouble_rvvm1_sleef v1, vdouble_rvvm1_sleef v2) {
  return vsub_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(v0, v1), v2);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vsub_vd_4vd_rvvm1_sleef(vdouble_rvvm1_sleef v0, vdouble_rvvm1_sleef v1, vdouble_rvvm1_sleef v2, vdouble_rvvm1_sleef v3) {
  return vsub_vd_3vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(v0, v1), v2, v3);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vsub_vd_5vd_rvvm1_sleef(vdouble_rvvm1_sleef v0, vdouble_rvvm1_sleef v1, vdouble_rvvm1_sleef v2, vdouble_rvvm1_sleef v3, vdouble_rvvm1_sleef v4) {
  return vsub_vd_4vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(v0, v1), v2, v3, v4);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vsub_vd_6vd_rvvm1_sleef(vdouble_rvvm1_sleef v0, vdouble_rvvm1_sleef v1, vdouble_rvvm1_sleef v2, vdouble_rvvm1_sleef v3, vdouble_rvvm1_sleef v4, vdouble_rvvm1_sleef v5) {
  return vsub_vd_5vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(v0, v1), v2, v3, v4, v5);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddneg_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef x) {
  return vcast_vd2_vd_vd_rvvm1_sleef(vneg_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x)), vneg_vd_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(x)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddabs_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef x) {
  return vcast_vd2_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x)),
                         vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(x)),
                                                          vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x)),
                                                                        vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddnormalize_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef t) {
  vdouble_rvvm1_sleef s = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(t), vd2gety_vd_vd2_rvvm1_sleef(t));
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vadd_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(t), s), vd2gety_vd_vd2_rvvm1_sleef(t)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddscale_vd2_vd2_vd_rvvm1_sleef(vdouble2_rvvm1_sleef d, vdouble_rvvm1_sleef s) {
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), s), vmul_vd_vd_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(d), s));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddscale_vd2_vd2_d_rvvm1_sleef(vdouble2_rvvm1_sleef d, double s) { return ddscale_vd2_vd2_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(s)); }

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddadd_vd2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vadd_vd_vd_vd_rvvm1_sleef(x, y);
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vadd_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(x, s), y));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddadd2_vd2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vadd_vd_vd_vd_rvvm1_sleef(x, y);
  vdouble_rvvm1_sleef v = vsub_vd_vd_vd_rvvm1_sleef(s, x);
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vadd_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(x, vsub_vd_vd_vd_rvvm1_sleef(s, v)), vsub_vd_vd_vd_rvvm1_sleef(y, v)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddadd_vd2_vd2_vd_rvvm1_sleef(vdouble2_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), y);
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vadd_vd_3vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), s), y, vd2gety_vd_vd2_rvvm1_sleef(x)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddsub_vd2_vd2_vd_rvvm1_sleef(vdouble2_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), y);
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vadd_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), s), y), vd2gety_vd_vd2_rvvm1_sleef(x)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddadd2_vd2_vd2_vd_rvvm1_sleef(vdouble2_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), y);
  vdouble_rvvm1_sleef v = vsub_vd_vd_vd_rvvm1_sleef(s, vd2getx_vd_vd2_rvvm1_sleef(x));
  vdouble_rvvm1_sleef w = vadd_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vsub_vd_vd_vd_rvvm1_sleef(s, v)), vsub_vd_vd_vd_rvvm1_sleef(y, v));
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vadd_vd_vd_vd_rvvm1_sleef(w, vd2gety_vd_vd2_rvvm1_sleef(x)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddadd_vd2_vd_vd2_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble2_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vadd_vd_vd_vd_rvvm1_sleef(x, vd2getx_vd_vd2_rvvm1_sleef(y));
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vadd_vd_3vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(x, s), vd2getx_vd_vd2_rvvm1_sleef(y), vd2gety_vd_vd2_rvvm1_sleef(y)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddadd2_vd2_vd_vd2_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble2_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vadd_vd_vd_vd_rvvm1_sleef(x, vd2getx_vd_vd2_rvvm1_sleef(y));
  vdouble_rvvm1_sleef v = vsub_vd_vd_vd_rvvm1_sleef(s, x);
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vadd_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(x, vsub_vd_vd_vd_rvvm1_sleef(s, v)),
                                                           vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(y), v)), vd2gety_vd_vd2_rvvm1_sleef(y)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddadd_vd2_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef x, vdouble2_rvvm1_sleef y) {

  vdouble_rvvm1_sleef s = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y));
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vadd_vd_4vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), s), vd2getx_vd_vd2_rvvm1_sleef(y), vd2gety_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(y)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddadd2_vd2_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef x, vdouble2_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y));
  vdouble_rvvm1_sleef v = vsub_vd_vd_vd_rvvm1_sleef(s, vd2getx_vd_vd2_rvvm1_sleef(x));
  vdouble_rvvm1_sleef t = vadd_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vsub_vd_vd_vd_rvvm1_sleef(s, v)), vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(y), v));
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vadd_vd_vd_vd_rvvm1_sleef(t, vadd_vd_vd_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(y))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddsub_vd2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {

  vdouble_rvvm1_sleef s = vsub_vd_vd_vd_rvvm1_sleef(x, y);
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vsub_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(x, s), y));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddsub_vd2_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef x, vdouble2_rvvm1_sleef y) {

  vdouble_rvvm1_sleef s = vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y));
  vdouble_rvvm1_sleef t = vsub_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), s);
  t = vsub_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(y));
  t = vadd_vd_vd_vd_rvvm1_sleef(t, vd2gety_vd_vd2_rvvm1_sleef(x));
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vsub_vd_vd_vd_rvvm1_sleef(t, vd2gety_vd_vd2_rvvm1_sleef(y)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef dddiv_vd2_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef n, vdouble2_rvvm1_sleef d) {
  vdouble_rvvm1_sleef t = vrec_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d));
  vdouble_rvvm1_sleef s = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(n), t);
  vdouble_rvvm1_sleef u = vfmapn_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(n), s);
  vdouble_rvvm1_sleef v = vfmanp_vd_vd_vd_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(d), t, vfmanp_vd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), t, vcast_vd_d_rvvm1_sleef(1)));
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vfma_vd_vd_vd_vd_rvvm1_sleef(s, v, vfma_vd_vd_vd_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(n), t, u)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddmul_vd2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vmul_vd_vd_vd_rvvm1_sleef(x, y);
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vfmapn_vd_vd_vd_vd_rvvm1_sleef(x, y, s));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddsqu_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef x) {
  vdouble_rvvm1_sleef s = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(x));
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vfma_vd_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(x)), vd2gety_vd_vd2_rvvm1_sleef(x), vfmapn_vd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(x), s)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddmul_vd2_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef x, vdouble2_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y));
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vfma_vd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(y), vfma_vd_vd_vd_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y), vfmapn_vd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y), s))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef ddmul_vd_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef x, vdouble2_rvvm1_sleef y) {
  return vfma_vd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y), vfma_vd_vd_vd_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y), vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(y))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef ddsqu_vd_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef x) {
  return vfma_vd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(x), vadd_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(x)), vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(x))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddmul_vd2_vd2_vd_rvvm1_sleef(vdouble2_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  vdouble_rvvm1_sleef s = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), y);
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vfma_vd_vd_vd_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(x), y, vfmapn_vd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), y, s)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddrec_vd2_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef s = vrec_vd_vd_rvvm1_sleef(d);
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(s, vfmanp_vd_vd_vd_vd_rvvm1_sleef(d, s, vcast_vd_d_rvvm1_sleef(1))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddrec_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef d) {
  vdouble_rvvm1_sleef s = vrec_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d));
  return vd2setxy_vd2_vd_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(s, vfmanp_vd_vd_vd_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(d), s, vfmanp_vd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), s, vcast_vd_d_rvvm1_sleef(1)))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddsqrt_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef d) {
  vdouble_rvvm1_sleef t = vsqrt_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d)));
  return ddscale_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd2_rvvm1_sleef(d, ddmul_vd2_vd_vd_rvvm1_sleef(t, t)), ddrec_vd2_vd_rvvm1_sleef(t)), vcast_vd_d_rvvm1_sleef(0.5));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddsqrt_vd2_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef t = vsqrt_vd_vd_rvvm1_sleef(d);
  return ddscale_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd_vd2_rvvm1_sleef(d, ddmul_vd2_vd_vd_rvvm1_sleef(t, t)), ddrec_vd2_vd_rvvm1_sleef(t)), vcast_vd_d_rvvm1_sleef(0.5));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddmla_vd2_vd2_vd2_vd2_rvvm1_sleef(vdouble2_rvvm1_sleef x, vdouble2_rvvm1_sleef y, vdouble2_rvvm1_sleef z) {
  return ddadd_vd2_vd2_vd2_rvvm1_sleef(z, ddmul_vd2_vd2_vd2_rvvm1_sleef(x, y));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_dp_vopmask_rvvm1_sleef visnegzero_vo_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return veq64_vo_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(d), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_dp_vopmask_rvvm1_sleef visnumber_vo_vd_rvvm1_sleef(vdouble_rvvm1_sleef x) {
  return rvv_dp_vandnot_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(x), veq_vo_vd_vd_rvvm1_sleef(x, x));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_dp_vopmask_rvvm1_sleef visnonfinite_vo_vd_rvvm1_sleef(vdouble_rvvm1_sleef x) {
  return veq64_vo_vm_vm_rvvm1_sleef(vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(x), vcast_vm_i64_rvvm1_sleef(INT64_C(0x7ff0000000000000))), vcast_vm_i64_rvvm1_sleef(INT64_C(0x7ff0000000000000)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vmask_rvvm1_sleef vsignbit_vm_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(d), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_dp_vopmask_rvvm1_sleef vsignbit_vo_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return veq64_vo_vm_vm_rvvm1_sleef(vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(d), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vclearlsb_vd_vd_i_rvvm1_sleef(vdouble_rvvm1_sleef d, int n) {
  return vreinterpret_vd_vm_rvvm1_sleef(vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(d), vcast_vm_u64_rvvm1_sleef((~UINT64_C(0)) << n)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vtoward0_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef t = vreinterpret_vd_vm_rvvm1_sleef(vadd64_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(x), vcast_vm_i64_rvvm1_sleef(-1)));
  return vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(0), t);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vsign_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1.0), d);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vtruncate2_vd_vd_rvvm1_sleef_rvvm1_sleef(vdouble_rvvm1_sleef x) {

  vdouble_rvvm1_sleef fr = vsub_vd_vd_vd_rvvm1_sleef(x, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(INT64_C(1) << 31), vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1.0 / (INT64_C(1) << 31)))))));
  fr = vsub_vd_vd_vd_rvvm1_sleef(fr, vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(fr)));
  return vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(x), vge_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52))), x, vcopysign_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(x, fr), x));

}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vfloor2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef fr = vsub_vd_vd_vd_rvvm1_sleef(x, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(INT64_C(1) << 31), vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1.0 / (INT64_C(1) << 31)))))));
  fr = vsub_vd_vd_vd_rvvm1_sleef(fr, vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(fr)));
  fr = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(fr, vcast_vd_d_rvvm1_sleef(0)), vadd_vd_vd_vd_rvvm1_sleef(fr, vcast_vd_d_rvvm1_sleef(1.0)), fr);
  return vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(x), vge_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52))), x, vcopysign_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(x, fr), x));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vceil2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef fr = vsub_vd_vd_vd_rvvm1_sleef(x, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(INT64_C(1) << 31), vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1.0 / (INT64_C(1) << 31)))))));
  fr = vsub_vd_vd_vd_rvvm1_sleef(fr, vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(fr)));
  fr = vsel_vd_vo_vd_vd_rvvm1_sleef(vle_vo_vd_vd_rvvm1_sleef(fr, vcast_vd_d_rvvm1_sleef(0)), fr, vsub_vd_vd_vd_rvvm1_sleef(fr, vcast_vd_d_rvvm1_sleef(1.0)));
  return vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(x), vge_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52))), x, vcopysign_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(x, fr), x));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vround2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef x = vadd_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.5));
  vdouble_rvvm1_sleef fr = vsub_vd_vd_vd_rvvm1_sleef(x, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(INT64_C(1) << 31), vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1.0 / (INT64_C(1) << 31)))))));
  fr = vsub_vd_vd_vd_rvvm1_sleef(fr, vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(fr)));
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vand_vo_vo_vo(vle_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0)), veq_vo_vd_vd_rvvm1_sleef(fr, vcast_vd_d_rvvm1_sleef(0))), vsub_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1.0)), x);
  fr = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(fr, vcast_vd_d_rvvm1_sleef(0)), vadd_vd_vd_vd_rvvm1_sleef(fr, vcast_vd_d_rvvm1_sleef(1.0)), fr);
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.49999999999999994449)), vcast_vd_d_rvvm1_sleef(0), x);
  return vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(d), vge_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52))), d, vcopysign_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(x, fr), d));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vrint2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {

  vdouble_rvvm1_sleef c = vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52), d);
  return vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52)),
                          d, vorsign_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(d, c), c), d));

}

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_dp_vopmask_rvvm1_sleef visint_vo_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  return veq_vo_vd_vd_rvvm1_sleef(vrint2_vd_vd_rvvm1_sleef(d), d);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_dp_vopmask_rvvm1_sleef visodd_vo_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef x = vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.5));
  return vneq_vo_vd_vd_rvvm1_sleef(vrint2_vd_vd_rvvm1_sleef(x), x);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vint_rvvm1_sleef vilogbk_vi_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(4.9090934652977266E-91));
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(2.037035976334486E90), d), d);
  vint_rvvm1_sleef q = vcastu_vi_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(d));
  q = vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef((int)(((1U << 12) - 1) << 20)));
  q = vsrl_vi_vi_i_rvvm1_sleef(q, 20);
  q = vsub_vi_vi_vi_rvvm1_sleef(q, vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(o), vcast_vi_i_rvvm1_sleef(300 + 0x3ff), vcast_vi_i_rvvm1_sleef(0x3ff)));
  return q;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vint_rvvm1_sleef vilogb2k_vi_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  vint_rvvm1_sleef q = vcastu_vi_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(d));
  q = vsrl_vi_vi_i_rvvm1_sleef(q, 20);
  q = vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(0x7ff));
  q = vsub_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(0x3ff));
  return q;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vmask_rvvm1_sleef vilogb2k_vm_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  vmask_rvvm1_sleef m = vreinterpret_vm_vd_rvvm1_sleef(d);
  m = vsrl64_vm_vm_i(m, 20 + 32);
  m = vand_vm_vm_vm_rvvm1_sleef(m, vcast_vm_i64_rvvm1_sleef(0x7ff));
  m = vsub64_vm_vm_vm_rvvm1_sleef(m, vcast_vm_i64_rvvm1_sleef(0x3ff));
  return m;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vmask_rvvm1_sleef vilogb3k_vm_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  vmask_rvvm1_sleef m = vreinterpret_vm_vd_rvvm1_sleef(d);
  m = vsrl64_vm_vm_i(m, 20 + 32);
  m = vand_vm_vm_vm_rvvm1_sleef(m, vcast_vm_i64_rvvm1_sleef(0x7ff));
  return m;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vpow2i_vd_vi_rvvm1_sleef(vint_rvvm1_sleef q) {
  q = vadd_vi_vi_vi_rvvm1_sleef(vcast_vi_i_rvvm1_sleef(0x3ff), q);
  vmask_rvvm1_sleef r = vcastu_vm_vi_rvvm1_sleef(vsll_vi_vi_i_rvvm1_sleef(q, 20));
  return vreinterpret_vd_vm_rvvm1_sleef(r);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vpow2i_vd_vm_rvvm1_sleef(vmask_rvvm1_sleef q) {
  q = vadd64_vm_vm_vm_rvvm1_sleef(vcast_vm_i64_rvvm1_sleef(0x3ff), q);
  return vreinterpret_vd_vm_rvvm1_sleef(vsll64_vm_vm_i(q, 52));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vldexp_vd_vd_vi_rvvm1_sleef(vdouble_rvvm1_sleef x, vint_rvvm1_sleef q) {
  vint_rvvm1_sleef m = vsra_vi_vi_i_rvvm1_sleef(q, 31);
  m = vsll_vi_vi_i_rvvm1_sleef(vsub_vi_vi_vi_rvvm1_sleef(vsra_vi_vi_i_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(m, q), 9), m), 7);
  q = vsub_vi_vi_vi_rvvm1_sleef(q, vsll_vi_vi_i_rvvm1_sleef(m, 2));
  m = vadd_vi_vi_vi_rvvm1_sleef(vcast_vi_i_rvvm1_sleef(0x3ff), m);
  m = vandnot_vi_vo_vi_rvvm1_sleef(vgt_vo_vi_vi_rvvm1_sleef(vcast_vi_i_rvvm1_sleef(0), m), m);
  m = vsel_vi_vo_vi_vi_rvvm1_sleef(vgt_vo_vi_vi_rvvm1_sleef(m, vcast_vi_i_rvvm1_sleef(0x7ff)), vcast_vi_i_rvvm1_sleef(0x7ff), m);
  vmask_rvvm1_sleef r = vcastu_vm_vi_rvvm1_sleef(vsll_vi_vi_i_rvvm1_sleef(m, 20));
  vdouble_rvvm1_sleef y = vreinterpret_vd_vm_rvvm1_sleef(r);
  return vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x, y), y), y), y), vpow2i_vd_vi_rvvm1_sleef(q));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vldexp2_vd_vd_vi_rvvm1_sleef(vdouble_rvvm1_sleef d, vint_rvvm1_sleef e) {
  return vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vpow2i_vd_vi_rvvm1_sleef(vsra_vi_vi_i_rvvm1_sleef(e, 1))), vpow2i_vd_vi_rvvm1_sleef(vsub_vi_vi_vi_rvvm1_sleef(e, vsra_vi_vi_i_rvvm1_sleef(e, 1))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vldexp3_vd_vd_vi_rvvm1_sleef(vdouble_rvvm1_sleef d, vint_rvvm1_sleef q) {
  return vreinterpret_vd_vm_rvvm1_sleef(vadd64_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(d), vcastu_vm_vi_rvvm1_sleef(vsll_vi_vi_i_rvvm1_sleef(q, 20))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vldexp1_vd_vd_vm_rvvm1_sleef(vdouble_rvvm1_sleef d, vmask_rvvm1_sleef e) {
  vmask_rvvm1_sleef m = vsrl64_vm_vm_i(e, 2);
  e = vsub64_vm_vm_vm_rvvm1_sleef(vsub64_vm_vm_vm_rvvm1_sleef(vsub64_vm_vm_vm_rvvm1_sleef(e, m), m), m);
  d = vmul_vd_vd_vd_rvvm1_sleef(d, vpow2i_vd_vm_rvvm1_sleef(m));
  d = vmul_vd_vd_vd_rvvm1_sleef(d, vpow2i_vd_vm_rvvm1_sleef(m));
  d = vmul_vd_vd_vd_rvvm1_sleef(d, vpow2i_vd_vm_rvvm1_sleef(m));
  d = vmul_vd_vd_vd_rvvm1_sleef(d, vpow2i_vd_vm_rvvm1_sleef(e));
  return d;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vldexp2_vd_vd_vm_rvvm1_sleef(vdouble_rvvm1_sleef d, vmask_rvvm1_sleef e) {
  return vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vpow2i_vd_vm_rvvm1_sleef(vsrl64_vm_vm_i(e, 1))), vpow2i_vd_vm_rvvm1_sleef(vsub64_vm_vm_vm_rvvm1_sleef(e, vsrl64_vm_vm_i(e, 1))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vldexp3_vd_vd_vm_rvvm1_sleef(vdouble_rvvm1_sleef d, vmask_rvvm1_sleef q) {
  return vreinterpret_vd_vm_rvvm1_sleef(vadd64_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(d), vsll64_vm_vm_i(q, 52)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vcast_vd_vm_rvvm1_sleef(vmask_rvvm1_sleef m) { return vcast_vd_vi_rvvm1_sleef(vcast_vi_vm_rvvm1_sleef(m)); }
static SLEEF_ALWAYS_INLINE SLEEF_CONST vmask_rvvm1_sleef vtruncate_vm_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) { return vcast_vm_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(d)); }

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_dp_vopmask_rvvm1_sleef vlt64_vo_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) { return vgt64_vo_vm_vm_rvvm1_sleef(y, x); }

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_dp_vopmask_rvvm1_sleef vnot_vo64_vo64_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef x) {
  return rvv_dp_vxor_vo_vo_vo(x, veq64_vo_vm_vm_rvvm1_sleef(vcast_vm_i64_rvvm1_sleef(0), vcast_vm_i64_rvvm1_sleef(0)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_dp_vopmask_rvvm1_sleef vugt64_vo_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) {
  x = vxor_vm_vm_vm_rvvm1_sleef(vcast_vm_u64_rvvm1_sleef(UINT64_C(0x8000000000000000)), x);
  y = vxor_vm_vm_vm_rvvm1_sleef(vcast_vm_u64_rvvm1_sleef(UINT64_C(0x8000000000000000)), y);
  return vgt64_vo_vm_vm_rvvm1_sleef(x, y);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vmask_rvvm1_sleef vilogbk_vm_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(4.9090934652977266E-91));
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(2.037035976334486E90), d), d);
  vmask_rvvm1_sleef q = vreinterpret_vm_vd_rvvm1_sleef(d);
  q = vsrl64_vm_vm_i(q, 20 + 32);
  q = vand_vm_vm_vm_rvvm1_sleef(q, vcast_vm_i64_rvvm1_sleef(0x7ff));
  q = vsub64_vm_vm_vm_rvvm1_sleef(q, vsel_vm_vo64_vm_vm_rvvm1_sleef(o, vcast_vm_i64_rvvm1_sleef(300 + 0x3ff), vcast_vm_i64_rvvm1_sleef(0x3ff)));
  return q;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vquad_rvvm1_sleef sel_vq_vo_vq_vq_rvvm1_sleef(rvv_dp_vopmask_rvvm1_sleef o, vquad_rvvm1_sleef x, vquad_rvvm1_sleef y) {
  return vqsetxy_vq_vm_vm_rvvm1_sleef(vsel_vm_vo64_vm_vm_rvvm1_sleef(o, vqgetx_vm_vq_rvvm1_sleef(x), vqgetx_vm_vq_rvvm1_sleef(y)), vsel_vm_vo64_vm_vm_rvvm1_sleef(o, vqgety_vm_vq_rvvm1_sleef(x), vqgety_vm_vq_rvvm1_sleef(y)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vquad_rvvm1_sleef add128_vq_vq_vq_rvvm1_sleef(vquad_rvvm1_sleef x, vquad_rvvm1_sleef y) {
  vquad_rvvm1_sleef r = vqsetxy_vq_vm_vm_rvvm1_sleef(vadd64_vm_vm_vm_rvvm1_sleef(vqgetx_vm_vq_rvvm1_sleef(x), vqgetx_vm_vq_rvvm1_sleef(y)), vadd64_vm_vm_vm_rvvm1_sleef(vqgety_vm_vq_rvvm1_sleef(x), vqgety_vm_vq_rvvm1_sleef(y)));
  r = vqsety_vq_vq_vm_rvvm1_sleef(r, vadd64_vm_vm_vm_rvvm1_sleef(vqgety_vm_vq_rvvm1_sleef(r), vand_vm_vo64_vm_rvvm1_sleef(vugt64_vo_vm_vm_rvvm1_sleef(vqgetx_vm_vq_rvvm1_sleef(x), vqgetx_vm_vq_rvvm1_sleef(r)), vcast_vm_i64_rvvm1_sleef(1))));
  return r;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vquad_rvvm1_sleef imdvq_vq_vm_vm_rvvm1_sleef(vmask_rvvm1_sleef x, vmask_rvvm1_sleef y) { vquad_rvvm1_sleef r = vqsetxy_vq_vm_vm_rvvm1_sleef(x, y); return r; }

static SLEEF_ALWAYS_INLINE SLEEF_CONST di_t_rvvm1_sleef rempisub_rvvm1_sleef(vdouble_rvvm1_sleef x) {

  vdouble_rvvm1_sleef c = vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52), x);
  vdouble_rvvm1_sleef rint4x = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(4), x)), vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52)),
                                    vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(4), x),
                                    vorsign_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vmla_vd_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(4), x, c), c), x));
  vdouble_rvvm1_sleef rintx = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52)),
                                    x, vorsign_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(x, c), c), x));
  return disetdi_di_vd_vi_rvvm1_sleef(vmla_vd_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.25), rint4x, x),
                          vtruncate_vi_vd_rvvm1_sleef(vmla_vd_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-4), rintx, rint4x)));

}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vint_rvvm1_sleef vsel_vi_vd_vd_vi_vi_rvvm1_sleef(vdouble_rvvm1_sleef d0, vdouble_rvvm1_sleef d1, vint_rvvm1_sleef x, vint_rvvm1_sleef y) { return vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(d0, d1)), x, y); }

static SLEEF_ALWAYS_INLINE SLEEF_CONST vint_rvvm1_sleef vsel_vi_vd_vi_rvvm1_sleef(vdouble_rvvm1_sleef d, vint_rvvm1_sleef x) { return vand_vi_vo_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(vsignbit_vo_vd_rvvm1_sleef(d)), x); }

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_ldexpdx_rvvm1(vdouble_rvvm1_sleef x, vint_rvvm1_sleef q) { return vldexp_vd_vd_vi_rvvm1_sleef(x, q); }

SLEEF_INLINE SLEEF_CONST vint_rvvm1_sleef Sleef_ilogbdx_rvvm1(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef e = vcast_vd_vi_rvvm1_sleef(vilogbk_vi_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d)));
  e = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(SLEEF_FP_ILOGB0), e);
  e = vsel_vd_vo_vd_vd_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(SLEEF_FP_ILOGBNAN), e);
  e = vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(2147483647), e);
  return vrint_vi_vd_rvvm1_sleef(e);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST ddi_t_rvvm1_sleef rempi_rvvm1_sleef(vdouble_rvvm1_sleef a) {
  vdouble2_rvvm1_sleef x, y;
  vint_rvvm1_sleef ex = vilogb2k_vi_vd_rvvm1_sleef(a);

  ex = vsub_vi_vi_vi_rvvm1_sleef(ex, vcast_vi_i_rvvm1_sleef(55));
  vint_rvvm1_sleef q = vand_vi_vo_vi_rvvm1_sleef(vgt_vo_vi_vi_rvvm1_sleef(ex, vcast_vi_i_rvvm1_sleef(700-55)), vcast_vi_i_rvvm1_sleef(-64));
  a = vldexp3_vd_vd_vi_rvvm1_sleef(a, q);
  ex = vandnot_vi_vi_vi_rvvm1_sleef(vsra_vi_vi_i_rvvm1_sleef(ex, 31), ex);
  ex = vsll_vi_vi_i_rvvm1_sleef(ex, 2);
  x = ddmul_vd2_vd_vd_rvvm1_sleef(a, vgather_vd_p_vi_rvvm1_sleef(Sleef_rempitabdp, ex));
  di_t_rvvm1_sleef di = rempisub_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x));
  q = digeti_vi_di_rvvm1_sleef(di);
  x = vd2setx_vd2_vd2_vd_rvvm1_sleef(x, digetd_vd_di_rvvm1_sleef(di));
  x = ddnormalize_vd2_vd2_rvvm1_sleef(x);
  y = ddmul_vd2_vd_vd_rvvm1_sleef(a, vgather_vd_p_vi_rvvm1_sleef(Sleef_rempitabdp+1, ex));
  x = ddadd2_vd2_vd2_vd2_rvvm1_sleef(x, y);
  di = rempisub_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x));
  q = vadd_vi_vi_vi_rvvm1_sleef(q, digeti_vi_di_rvvm1_sleef(di));
  x = vd2setx_vd2_vd2_vd_rvvm1_sleef(x, digetd_vd_di_rvvm1_sleef(di));
  x = ddnormalize_vd2_vd2_rvvm1_sleef(x);
  y = vcast_vd2_vd_vd_rvvm1_sleef(vgather_vd_p_vi_rvvm1_sleef(Sleef_rempitabdp+2, ex), vgather_vd_p_vi_rvvm1_sleef(Sleef_rempitabdp+3, ex));
  y = ddmul_vd2_vd2_vd_rvvm1_sleef(y, a);
  x = ddadd2_vd2_vd2_vd2_rvvm1_sleef(x, y);
  x = ddnormalize_vd2_vd2_rvvm1_sleef(x);
  x = ddmul_vd2_vd2_vd2_rvvm1_sleef(x, vcast_vd2_d_d_rvvm1_sleef(3.141592653589793116*2, 1.2246467991473532072e-16*2));
  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(a), vcast_vd_d_rvvm1_sleef(0.7));
  x = vd2setx_vd2_vd2_vd_rvvm1_sleef(x, vsel_vd_vo_vd_vd_rvvm1_sleef(o, a, vd2getx_vd_vd2_rvvm1_sleef(x)));
  x = vd2sety_vd2_vd2_vd_rvvm1_sleef(x, vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(x)))));
  return ddisetddi_ddi_vd2_vi_rvvm1_sleef(x, q);
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_sindx_u35rvvm1(vdouble_rvvm1_sleef d) {

  vdouble_rvvm1_sleef u, s, r = d;
  vint_rvvm1_sleef ql;

  if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(15)))), 1)) {
    vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724)));
    ql = vrint_vi_vd_rvvm1_sleef(dql);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.141592653589793116), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16), d);
  } else if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+14)))), 1)) {
    vdouble_rvvm1_sleef dqh = vtruncate_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724 / (1 << 24))));
    dqh = vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(1 << 24));
    vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vmlapn_vd_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724), dqh));
    ql = vrint_vi_vd_rvvm1_sleef(dql);

    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(dqh, dql), vcast_vd_d_rvvm1_sleef(-1.2736634327021899816e-24), d);
  } else {
    ddi_t_rvvm1_sleef ddi_rvvm1_sleef = rempi_rvvm1_sleef(d);
    ql = vand_vi_vi_vi_rvvm1_sleef(ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef), vcast_vi_i_rvvm1_sleef(3));
    ql = vadd_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(ql, ql), vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)), vcast_vd_d_rvvm1_sleef(0))), vcast_vi_i_rvvm1_sleef(2), vcast_vi_i_rvvm1_sleef(1)));
    ql = vsra_vi_vi_i_rvvm1_sleef(ql, 2);
    rvv_dp_vopmask_rvvm1_sleef o = veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef), vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(1));
    vdouble2_rvvm1_sleef x = vcast_vd2_vd_vd_rvvm1_sleef(vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-3.141592653589793116 * 0.5), vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef))),
                                 vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16 * 0.5), vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef))));
    x = ddadd2_vd2_vd2_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef), x);
    ddi_rvvm1_sleef = ddisetdd_ddi_ddi_vd2_rvvm1_sleef(ddi_rvvm1_sleef, vsel_vd2_vo_vd2_vd2_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(o), x, ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)));
    d = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)), vd2gety_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)));
    d = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(r), visnan_vo_vd_rvvm1_sleef(r)), vreinterpret_vm_vd_rvvm1_sleef(d)));
  }

  s = vmul_vd_vd_vd_rvvm1_sleef(d, d);

  d = vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(1))), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(d)));

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(s, s), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(-7.97255955009037868891952e-18)), (vcast_vd_d_rvvm1_sleef(2.81009972710863200091251e-15)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(-7.64712219118158833288484e-13)), (vcast_vd_d_rvvm1_sleef(1.60590430605664501629054e-10)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(-2.50521083763502045810755e-08)), (vcast_vd_d_rvvm1_sleef(2.75573192239198747630416e-06)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(-0.000198412698412696162806809)), (vcast_vd_d_rvvm1_sleef(0.00833333333333332974823815)))))))

                                         ;
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.166666666666666657414808));

  u = vadd_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(u, d)), d);

  u = vsel_vd_vo_vd_vd_rvvm1_sleef(visnegzero_vo_vd_rvvm1_sleef(r), r, u);

  return u;

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_sindx_u10rvvm1(vdouble_rvvm1_sleef d) {

  vdouble_rvvm1_sleef u;
  vdouble2_rvvm1_sleef s, t, x;
  vint_rvvm1_sleef ql;

  if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(15)))), 1)) {
    const vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724)));
    ql = vrint_vi_vd_rvvm1_sleef(dql);
    u = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.141592653589793116), d);
    s = ddadd_vd2_vd_vd_rvvm1_sleef (u, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16)));
  } else if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+14)))), 1)) {
    vdouble_rvvm1_sleef dqh = vtruncate_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724 / (1 << 24))));
    dqh = vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(1 << 24));
    const vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vmlapn_vd_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724), dqh));
    ql = vrint_vi_vd_rvvm1_sleef(dql);

    u = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914), d);
    s = ddadd_vd2_vd_vd_rvvm1_sleef (u, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16)));
    s = ddadd_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(dqh, dql), vcast_vd_d_rvvm1_sleef(-1.2736634327021899816e-24)));
  } else {
    ddi_t_rvvm1_sleef ddi_rvvm1_sleef = rempi_rvvm1_sleef(d);
    ql = vand_vi_vi_vi_rvvm1_sleef(ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef), vcast_vi_i_rvvm1_sleef(3));
    ql = vadd_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(ql, ql), vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)), vcast_vd_d_rvvm1_sleef(0))), vcast_vi_i_rvvm1_sleef(2), vcast_vi_i_rvvm1_sleef(1)));
    ql = vsra_vi_vi_i_rvvm1_sleef(ql, 2);
    rvv_dp_vopmask_rvvm1_sleef o = veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef), vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(1));
    vdouble2_rvvm1_sleef x = vcast_vd2_vd_vd_rvvm1_sleef(vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-3.141592653589793116 * 0.5), vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef))),
                                 vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16 * 0.5), vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef))));
    x = ddadd2_vd2_vd2_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef), x);
    ddi_rvvm1_sleef = ddisetdd_ddi_ddi_vd2_rvvm1_sleef(ddi_rvvm1_sleef, vsel_vd2_vo_vd2_vd2_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(o), x, ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)));
    s = ddnormalize_vd2_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef));
    s = vd2setx_vd2_vd2_vd_rvvm1_sleef(s, vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(d), visnan_vo_vd_rvvm1_sleef(d)), vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s)))));
  }

  t = s;
  s = ddsqu_vd2_vd2_rvvm1_sleef(s);

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2getx_vd_vd2_rvvm1_sleef(s)), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(2.72052416138529567917983e-15)), (vcast_vd_d_rvvm1_sleef(-7.6429259411395447190023e-13)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(1.60589370117277896211623e-10)), (vcast_vd_d_rvvm1_sleef(-2.5052106814843123359368e-08)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(2.75573192104428224777379e-06)), (vcast_vd_d_rvvm1_sleef(-0.000198412698412046454654947)))))))

                                           ;
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(0.00833333333333318056201922));

  x = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), ddmul_vd2_vd2_vd2_rvvm1_sleef(ddadd_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.166666666666666657414808), vmul_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s))), s));
  u = ddmul_vd_vd2_vd2_rvvm1_sleef(t, x);

  u = vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(1))),
                                                       vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(u)));
  u = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), d, u);

  return u;

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_cosdx_u35rvvm1(vdouble_rvvm1_sleef d) {

  vdouble_rvvm1_sleef u, s, r = d;
  vint_rvvm1_sleef ql;

  if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(15)))), 1)) {
    vdouble_rvvm1_sleef dql = vmla_vd_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(2),
                                   vrint_vd_vd_rvvm1_sleef(vmla_vd_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724), vcast_vd_d_rvvm1_sleef(-0.5))),
                                   vcast_vd_d_rvvm1_sleef(1));
    ql = vrint_vi_vd_rvvm1_sleef(dql);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.141592653589793116 * 0.5), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16 * 0.5), d);
  } else if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+14)))), 1)) {
    vdouble_rvvm1_sleef dqh = vtruncate_vd_vd_rvvm1_sleef(vmla_vd_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724 / (1 << 23)), vcast_vd_d_rvvm1_sleef(-0.318309886183790671537767526745028724 / (1 << 24))));
    ql = vrint_vi_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724)),
                                   vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-(1 << 23)), vcast_vd_d_rvvm1_sleef(-0.5))));
    dqh = vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(1 << 24));
    ql = vadd_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(ql, ql), vcast_vi_i_rvvm1_sleef(1));
    vdouble_rvvm1_sleef dql = vcast_vd_vi_rvvm1_sleef(ql);

    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914 * 0.5), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914 * 0.5), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08 * 0.5), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08 * 0.5), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16 * 0.5), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16 * 0.5), d);
    d = vmla_vd_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(dqh, dql), vcast_vd_d_rvvm1_sleef(-1.2736634327021899816e-24 * 0.5), d);
  } else {
    ddi_t_rvvm1_sleef ddi_rvvm1_sleef = rempi_rvvm1_sleef(d);
    ql = vand_vi_vi_vi_rvvm1_sleef(ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef), vcast_vi_i_rvvm1_sleef(3));
    ql = vadd_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(ql, ql), vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)), vcast_vd_d_rvvm1_sleef(0))), vcast_vi_i_rvvm1_sleef(8), vcast_vi_i_rvvm1_sleef(7)));
    ql = vsra_vi_vi_i_rvvm1_sleef(ql, 1);
    rvv_dp_vopmask_rvvm1_sleef o = veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef), vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(0));
    vdouble_rvvm1_sleef y = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)), vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(0), vcast_vd_d_rvvm1_sleef(-1));
    vdouble2_rvvm1_sleef x = vcast_vd2_vd_vd_rvvm1_sleef(vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-3.141592653589793116 * 0.5), y),
                                 vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16 * 0.5), y));
    x = ddadd2_vd2_vd2_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef), x);
    ddi_rvvm1_sleef = ddisetdd_ddi_ddi_vd2_rvvm1_sleef(ddi_rvvm1_sleef, vsel_vd2_vo_vd2_vd2_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(o), x, ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)));
    d = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)), vd2gety_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)));
    d = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(r), visnan_vo_vd_rvvm1_sleef(r)), vreinterpret_vm_vd_rvvm1_sleef(d)));
  }

  s = vmul_vd_vd_vd_rvvm1_sleef(d, d);

  d = vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(0))), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(d)));

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(s, s), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(-7.97255955009037868891952e-18)), (vcast_vd_d_rvvm1_sleef(2.81009972710863200091251e-15)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(-7.64712219118158833288484e-13)), (vcast_vd_d_rvvm1_sleef(1.60590430605664501629054e-10)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(-2.50521083763502045810755e-08)), (vcast_vd_d_rvvm1_sleef(2.75573192239198747630416e-06)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(-0.000198412698412696162806809)), (vcast_vd_d_rvvm1_sleef(0.00833333333333332974823815)))))))

                                         ;
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.166666666666666657414808));

  u = vadd_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(u, d)), d);

  return u;

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_cosdx_u10rvvm1(vdouble_rvvm1_sleef d) {

  vdouble_rvvm1_sleef u;
  vdouble2_rvvm1_sleef s, t, x;
  vint_rvvm1_sleef ql;

  if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(15)))), 1)) {
    vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vmla_vd_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724), vcast_vd_d_rvvm1_sleef(-0.5)));
    dql = vmla_vd_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(2), dql, vcast_vd_d_rvvm1_sleef(1));
    ql = vrint_vi_vd_rvvm1_sleef(dql);
    s = ddadd2_vd2_vd_vd_rvvm1_sleef(d, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.141592653589793116*0.5)));
    s = ddadd_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16*0.5)));
  } else if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+14)))), 1)) {
    vdouble_rvvm1_sleef dqh = vtruncate_vd_vd_rvvm1_sleef(vmla_vd_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724 / (1 << 23)), vcast_vd_d_rvvm1_sleef(-0.318309886183790671537767526745028724 / (1 << 24))));
    ql = vrint_vi_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.318309886183790671537767526745028724)),
                                        vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-(1 << 23)), vcast_vd_d_rvvm1_sleef(-0.5))));
    dqh = vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(1 << 24));
    ql = vadd_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(ql, ql), vcast_vi_i_rvvm1_sleef(1));
    const vdouble_rvvm1_sleef dql = vcast_vd_vi_rvvm1_sleef(ql);

    u = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914 * 0.5), d);
    s = ddadd2_vd2_vd_vd_rvvm1_sleef(u, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914*0.5)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08*0.5)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08*0.5)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16*0.5)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16*0.5)));
    s = ddadd_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(dqh, dql), vcast_vd_d_rvvm1_sleef(-1.2736634327021899816e-24*0.5)));
  } else {
    ddi_t_rvvm1_sleef ddi_rvvm1_sleef = rempi_rvvm1_sleef(d);
    ql = vand_vi_vi_vi_rvvm1_sleef(ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef), vcast_vi_i_rvvm1_sleef(3));
    ql = vadd_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(ql, ql), vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)), vcast_vd_d_rvvm1_sleef(0))), vcast_vi_i_rvvm1_sleef(8), vcast_vi_i_rvvm1_sleef(7)));
    ql = vsra_vi_vi_i_rvvm1_sleef(ql, 1);
    rvv_dp_vopmask_rvvm1_sleef o = veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef), vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(0));
    vdouble_rvvm1_sleef y = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)), vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(0), vcast_vd_d_rvvm1_sleef(-1));
    vdouble2_rvvm1_sleef x = vcast_vd2_vd_vd_rvvm1_sleef(vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-3.141592653589793116 * 0.5), y),
                                 vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16 * 0.5), y));
    x = ddadd2_vd2_vd2_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef), x);
    ddi_rvvm1_sleef = ddisetdd_ddi_ddi_vd2_rvvm1_sleef(ddi_rvvm1_sleef, vsel_vd2_vo_vd2_vd2_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(o), x, ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)));
    s = ddnormalize_vd2_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef));
    s = vd2setx_vd2_vd2_vd_rvvm1_sleef(s, vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(d), visnan_vo_vd_rvvm1_sleef(d)), vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s)))));
  }

  t = s;
  s = ddsqu_vd2_vd2_rvvm1_sleef(s);

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2getx_vd_vd2_rvvm1_sleef(s)), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(2.72052416138529567917983e-15)), (vcast_vd_d_rvvm1_sleef(-7.6429259411395447190023e-13)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(1.60589370117277896211623e-10)), (vcast_vd_d_rvvm1_sleef(-2.5052106814843123359368e-08)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(2.75573192104428224777379e-06)), (vcast_vd_d_rvvm1_sleef(-0.000198412698412046454654947)))))))

                                           ;
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(0.00833333333333318056201922));

  x = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), ddmul_vd2_vd2_vd2_rvvm1_sleef(ddadd_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.166666666666666657414808), vmul_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s))), s));
  u = ddmul_vd_vd2_vd2_rvvm1_sleef(t, x);

  u = vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(0))), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(u)));

  return u;

}

SLEEF_INLINE vdouble2_rvvm1_sleef Sleef_sincosdx_u35rvvm1(vdouble_rvvm1_sleef d) {

  rvv_dp_vopmask_rvvm1_sleef o;
  vdouble_rvvm1_sleef u, t, rx, ry, s;
  vdouble2_rvvm1_sleef r;
  vint_rvvm1_sleef ql;

  if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(15)))), 1)) {
    vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2 * 0.318309886183790671537767526745028724)));
    ql = vrint_vi_vd_rvvm1_sleef(dql);
    s = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.141592653589793116 * 0.5), d);
    s = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16 * 0.5), s);
  } else if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+14)))), 1)) {
    vdouble_rvvm1_sleef dqh = vtruncate_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2*0.318309886183790671537767526745028724 / (1 << 24))));
    dqh = vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(1 << 24));
    vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2*0.318309886183790671537767526745028724)), dqh));
    ql = vrint_vi_vd_rvvm1_sleef(dql);

    s = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914 * 0.5), d);
    s = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914 * 0.5), s);
    s = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08 * 0.5), s);
    s = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08 * 0.5), s);
    s = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16 * 0.5), s);
    s = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16 * 0.5), s);
    s = vmla_vd_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(dqh, dql), vcast_vd_d_rvvm1_sleef(-1.2736634327021899816e-24 * 0.5), s);
  } else {
    ddi_t_rvvm1_sleef ddi_rvvm1_sleef = rempi_rvvm1_sleef(d);
    ql = ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef);
    s = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)), vd2gety_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)));
    s = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(d), visnan_vo_vd_rvvm1_sleef(d)), vreinterpret_vm_vd_rvvm1_sleef(s)));
  }

  t = s;

  s = vmul_vd_vd_vd_rvvm1_sleef(s, s);

  u = vcast_vd_d_rvvm1_sleef(1.58938307283228937328511e-10);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-2.50506943502539773349318e-08));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(2.75573131776846360512547e-06));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.000198412698278911770864914));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(0.0083333333333191845961746));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.166666666666666130709393));

  rx = vmla_vd_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(u, s), t, t);
  rx = vsel_vd_vo_vd_vd_rvvm1_sleef(visnegzero_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(-0.0), rx);

  u = vcast_vd_d_rvvm1_sleef(-1.13615350239097429531523e-11);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(2.08757471207040055479366e-09));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-2.75573144028847567498567e-07));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(2.48015872890001867311915e-05));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.00138888888888714019282329));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(0.0416666666666665519592062));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.5));

  ry = vmla_vd_vd_vd_vd_rvvm1_sleef(s, u, vcast_vd_d_rvvm1_sleef(1));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(0)));
  r = vd2setxy_vd2_vd_vd_rvvm1_sleef(vsel_vd_vo_vd_vd_rvvm1_sleef(o, rx, ry), vsel_vd_vo_vd_vd_rvvm1_sleef(o, ry, rx));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(2)));
  r = vd2setx_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)))));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(2)));
  r = vd2sety_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(r)))));

  return r;

}

SLEEF_INLINE vdouble2_rvvm1_sleef Sleef_sincosdx_u10rvvm1(vdouble_rvvm1_sleef d) {

  rvv_dp_vopmask_rvvm1_sleef o;
  vdouble_rvvm1_sleef u, rx, ry;
  vdouble2_rvvm1_sleef r, s, t, x;
  vint_rvvm1_sleef ql;

  if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(15)))), 1)) {
    const vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2 * 0.318309886183790671537767526745028724)));
    ql = vrint_vi_vd_rvvm1_sleef(dql);
    u = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.141592653589793116*0.5), d);
    s = ddadd_vd2_vd_vd_rvvm1_sleef (u, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16*0.5)));
  } else if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+14)))), 1)) {
    vdouble_rvvm1_sleef dqh = vtruncate_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2*0.318309886183790671537767526745028724 / (1 << 24))));
    dqh = vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(1 << 24));
    const vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2*0.318309886183790671537767526745028724)), dqh));
    ql = vrint_vi_vd_rvvm1_sleef(dql);

    u = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914 * 0.5), d);
    s = ddadd_vd2_vd_vd_rvvm1_sleef(u, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914*0.5)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08*0.5)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08*0.5)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16*0.5)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16*0.5)));
    s = ddadd_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(dqh, dql), vcast_vd_d_rvvm1_sleef(-1.2736634327021899816e-24*0.5)));
  } else {
    ddi_t_rvvm1_sleef ddi_rvvm1_sleef = rempi_rvvm1_sleef(d);
    ql = ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef);
    s = ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef);
    o = rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(d), visnan_vo_vd_rvvm1_sleef(d));
    s = vd2setxy_vd2_vd_vd_rvvm1_sleef(vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s)))),
                           vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(s)))));
  }

  t = s;

  s = vd2setx_vd2_vd2_vd_rvvm1_sleef(s, ddsqu_vd_vd2_rvvm1_sleef(s));

  u = vcast_vd_d_rvvm1_sleef(1.58938307283228937328511e-10);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(-2.50506943502539773349318e-08));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(2.75573131776846360512547e-06));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(-0.000198412698278911770864914));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(0.0083333333333191845961746));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(-0.166666666666666130709393));

  u = vmul_vd_vd_vd_rvvm1_sleef(u, vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2getx_vd_vd2_rvvm1_sleef(t)));

  x = ddadd_vd2_vd2_vd_rvvm1_sleef(t, u);
  rx = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(x));

  rx = vsel_vd_vo_vd_vd_rvvm1_sleef(visnegzero_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(-0.0), rx);

  u = vcast_vd_d_rvvm1_sleef(-1.13615350239097429531523e-11);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(2.08757471207040055479366e-09));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(-2.75573144028847567498567e-07));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(2.48015872890001867311915e-05));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(-0.00138888888888714019282329));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(0.0416666666666665519592062));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(-0.5));

  x = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), ddmul_vd2_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), u));
  ry = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(x));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(0)));
  r = vd2setxy_vd2_vd_vd_rvvm1_sleef(vsel_vd_vo_vd_vd_rvvm1_sleef(o, rx, ry), vsel_vd_vo_vd_vd_rvvm1_sleef(o, ry, rx));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(2)));
  r = vd2setx_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)))));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(2)));
  r = vd2sety_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(r)))));

  return r;

}

SLEEF_INLINE vdouble2_rvvm1_sleef Sleef_sincospidx_u05rvvm1(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef o;
  vdouble_rvvm1_sleef u, s, t, rx, ry;
  vdouble2_rvvm1_sleef r, x, s2;

  u = vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(4.0));
  vint_rvvm1_sleef q = vtruncate_vi_vd_rvvm1_sleef(u);
  q = vand_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(q, vxor_vi_vi_vi_rvvm1_sleef(vsrl_vi_vi_i_rvvm1_sleef(q, 31), vcast_vi_i_rvvm1_sleef(1))), vcast_vi_i_rvvm1_sleef(~1));
  s = vsub_vd_vd_vd_rvvm1_sleef(u, vcast_vd_vi_rvvm1_sleef(q));

  t = s;
  s = vmul_vd_vd_vd_rvvm1_sleef(s, s);
  s2 = ddmul_vd2_vd_vd_rvvm1_sleef(t, t);

  u = vcast_vd_d_rvvm1_sleef(-2.02461120785182399295868e-14);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(6.94821830580179461327784e-12));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-1.75724749952853179952664e-09));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(3.13361688966868392878422e-07));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-3.6576204182161551920361e-05));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(0.00249039457019271850274356));
  x = ddadd2_vd2_vd_vd2_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(u, s), vcast_vd2_d_d_rvvm1_sleef(-0.0807455121882807852484731, 3.61852475067037104849987e-18));
  x = ddadd2_vd2_vd2_vd2_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(s2, x), vcast_vd2_d_d_rvvm1_sleef(0.785398163397448278999491, 3.06287113727155002607105e-17));

  x = ddmul_vd2_vd2_vd_rvvm1_sleef(x, t);
  rx = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(x));

  rx = vsel_vd_vo_vd_vd_rvvm1_sleef(visnegzero_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(-0.0), rx);

  u = vcast_vd_d_rvvm1_sleef(9.94480387626843774090208e-16);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-3.89796226062932799164047e-13));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(1.15011582539996035266901e-10));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-2.4611369501044697495359e-08));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(3.59086044859052754005062e-06));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.000325991886927389905997954));
  x = ddadd2_vd2_vd_vd2_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(u, s), vcast_vd2_d_d_rvvm1_sleef(0.0158543442438155018914259, -1.04693272280631521908845e-18));
  x = ddadd2_vd2_vd2_vd2_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(s2, x), vcast_vd2_d_d_rvvm1_sleef(-0.308425137534042437259529, -1.95698492133633550338345e-17));

  x = ddadd2_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(x, s2), vcast_vd_d_rvvm1_sleef(1));
  ry = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(x));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(0)));
  r = vd2setxy_vd2_vd_vd_rvvm1_sleef(vsel_vd_vo_vd_vd_rvvm1_sleef(o, rx, ry), vsel_vd_vo_vd_vd_rvvm1_sleef(o, ry, rx));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(4)), vcast_vi_i_rvvm1_sleef(4)));
  r = vd2setx_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)))));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(4)), vcast_vi_i_rvvm1_sleef(4)));
  r = vd2sety_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(r)))));

  o = vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+9/4));
  r = vd2setx_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)))));
  r = vd2sety_vd2_vd2_vd_rvvm1_sleef(r, vsel_vd_vo_vd_vd_rvvm1_sleef(o, vcast_vd_d_rvvm1_sleef(1), vd2gety_vd_vd2_rvvm1_sleef(r)));

  o = visinf_vo_vd_rvvm1_sleef(d);
  r = vd2setx_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)))));
  r = vd2sety_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(r)))));

  return r;
}

SLEEF_INLINE vdouble2_rvvm1_sleef Sleef_sincospidx_u35rvvm1(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef o;
  vdouble_rvvm1_sleef u, s, t, rx, ry;
  vdouble2_rvvm1_sleef r;

  u = vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(4.0));
  vint_rvvm1_sleef q = vtruncate_vi_vd_rvvm1_sleef(u);
  q = vand_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(q, vxor_vi_vi_vi_rvvm1_sleef(vsrl_vi_vi_i_rvvm1_sleef(q, 31), vcast_vi_i_rvvm1_sleef(1))), vcast_vi_i_rvvm1_sleef(~1));
  s = vsub_vd_vd_vd_rvvm1_sleef(u, vcast_vd_vi_rvvm1_sleef(q));

  t = s;
  s = vmul_vd_vd_vd_rvvm1_sleef(s, s);

  u = vcast_vd_d_rvvm1_sleef(+0.6880638894766060136e-11);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.1757159564542310199e-8));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.3133616327257867311e-6));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.3657620416388486452e-4));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.2490394570189932103e-2));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.8074551218828056320e-1));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.7853981633974482790e+0));

  rx = vmul_vd_vd_vd_rvvm1_sleef(u, t);

  u = vcast_vd_d_rvvm1_sleef(-0.3860141213683794352e-12);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.1150057888029681415e-9));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.2461136493006663553e-7));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.3590860446623516713e-5));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.3259918869269435942e-3));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.1585434424381541169e-1));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(-0.3084251375340424373e+0));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(1));

  ry = u;

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(0)));
  r = vd2setxy_vd2_vd_vd_rvvm1_sleef(vsel_vd_vo_vd_vd_rvvm1_sleef(o, rx, ry), vsel_vd_vo_vd_vd_rvvm1_sleef(o, ry, rx));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(4)), vcast_vi_i_rvvm1_sleef(4)));
  r = vd2setx_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)))));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(4)), vcast_vi_i_rvvm1_sleef(4)));
  r = vd2sety_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(r)))));

  o = vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+9/4));
  r = vd2setx_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)))));
  r = vd2sety_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(r)))));

  o = visinf_vo_vd_rvvm1_sleef(d);
  r = vd2setx_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)))));
  r = vd2sety_vd2_vd2_vd_rvvm1_sleef(r, vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(r)))));

  return r;
}

SLEEF_INLINE SLEEF_CONST vdouble2_rvvm1_sleef Sleef_modfdx_rvvm1(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef fr = vsub_vd_vd_vd_rvvm1_sleef(x, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(INT64_C(1) << 31), vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1.0 / (INT64_C(1) << 31)))))));
  fr = vsub_vd_vd_vd_rvvm1_sleef(fr, vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(fr)));
  fr = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52)), vcast_vd_d_rvvm1_sleef(0), fr);

  vdouble2_rvvm1_sleef ret;

  ret = vd2setxy_vd2_vd_vd_rvvm1_sleef(vcopysign_vd_vd_vd_rvvm1_sleef(fr, x), vcopysign_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(x, fr), x));

  return ret;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef sinpik_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef o;
  vdouble_rvvm1_sleef u, s, t;
  vdouble2_rvvm1_sleef x, s2;

  u = vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(4.0));
  vint_rvvm1_sleef q = vtruncate_vi_vd_rvvm1_sleef(u);
  q = vand_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(q, vxor_vi_vi_vi_rvvm1_sleef(vsrl_vi_vi_i_rvvm1_sleef(q, 31), vcast_vi_i_rvvm1_sleef(1))), vcast_vi_i_rvvm1_sleef(~1));
  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(2)));

  s = vsub_vd_vd_vd_rvvm1_sleef(u, vcast_vd_vi_rvvm1_sleef(q));
  t = s;
  s = vmul_vd_vd_vd_rvvm1_sleef(s, s);
  s2 = ddmul_vd2_vd_vd_rvvm1_sleef(t, t);

  u = vsel_vd_vo_d_d_rvvm1_sleef(o, 9.94480387626843774090208e-16, -2.02461120785182399295868e-14);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vsel_vd_vo_d_d_rvvm1_sleef(o, -3.89796226062932799164047e-13, 6.948218305801794613277840e-12));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vsel_vd_vo_d_d_rvvm1_sleef(o, 1.150115825399960352669010e-10, -1.75724749952853179952664e-09));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vsel_vd_vo_d_d_rvvm1_sleef(o, -2.46113695010446974953590e-08, 3.133616889668683928784220e-07));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vsel_vd_vo_d_d_rvvm1_sleef(o, 3.590860448590527540050620e-06, -3.65762041821615519203610e-05));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vsel_vd_vo_d_d_rvvm1_sleef(o, -0.000325991886927389905997954, 0.0024903945701927185027435600));
  x = ddadd2_vd2_vd_vd2_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(u, s),
                        vsel_vd2_vo_d_d_d_d_rvvm1_sleef(o, 0.0158543442438155018914259, -1.04693272280631521908845e-18,
                                            -0.0807455121882807852484731, 3.61852475067037104849987e-18));
  x = ddadd2_vd2_vd2_vd2_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(s2, x),
                         vsel_vd2_vo_d_d_d_d_rvvm1_sleef(o, -0.308425137534042437259529, -1.95698492133633550338345e-17,
                                             0.785398163397448278999491, 3.06287113727155002607105e-17));

  x = ddmul_vd2_vd2_vd2_rvvm1_sleef(x, vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, s2, vcast_vd2_vd_vd_rvvm1_sleef(t, vcast_vd_d_rvvm1_sleef(0))));
  x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, ddadd2_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1)), x);

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(4)), vcast_vi_i_rvvm1_sleef(4)));
  x = vd2setx_vd2_vd2_vd_rvvm1_sleef(x, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x)))));
  x = vd2sety_vd2_vd2_vd_rvvm1_sleef(x, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(x)))));

  return x;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_sinpidx_u05rvvm1(vdouble_rvvm1_sleef d) {
  vdouble2_rvvm1_sleef x = sinpik_rvvm1_sleef(d);
  vdouble_rvvm1_sleef r = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(x));

  r = vsel_vd_vo_vd_vd_rvvm1_sleef(visnegzero_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(-0.0), r);
  r = vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+9/4)), vreinterpret_vm_vd_rvvm1_sleef(r)));
  r = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(d), vreinterpret_vm_vd_rvvm1_sleef(r)));

  return r;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef cospik_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef o;
  vdouble_rvvm1_sleef u, s, t;
  vdouble2_rvvm1_sleef x, s2;

  u = vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(4.0));
  vint_rvvm1_sleef q = vtruncate_vi_vd_rvvm1_sleef(u);
  q = vand_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(q, vxor_vi_vi_vi_rvvm1_sleef(vsrl_vi_vi_i_rvvm1_sleef(q, 31), vcast_vi_i_rvvm1_sleef(1))), vcast_vi_i_rvvm1_sleef(~1));
  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(0)));

  s = vsub_vd_vd_vd_rvvm1_sleef(u, vcast_vd_vi_rvvm1_sleef(q));
  t = s;
  s = vmul_vd_vd_vd_rvvm1_sleef(s, s);
  s2 = ddmul_vd2_vd_vd_rvvm1_sleef(t, t);

  u = vsel_vd_vo_d_d_rvvm1_sleef(o, 9.94480387626843774090208e-16, -2.02461120785182399295868e-14);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vsel_vd_vo_d_d_rvvm1_sleef(o, -3.89796226062932799164047e-13, 6.948218305801794613277840e-12));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vsel_vd_vo_d_d_rvvm1_sleef(o, 1.150115825399960352669010e-10, -1.75724749952853179952664e-09));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vsel_vd_vo_d_d_rvvm1_sleef(o, -2.46113695010446974953590e-08, 3.133616889668683928784220e-07));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vsel_vd_vo_d_d_rvvm1_sleef(o, 3.590860448590527540050620e-06, -3.65762041821615519203610e-05));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vsel_vd_vo_d_d_rvvm1_sleef(o, -0.000325991886927389905997954, 0.0024903945701927185027435600));
  x = ddadd2_vd2_vd_vd2_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(u, s),
                        vsel_vd2_vo_d_d_d_d_rvvm1_sleef(o, 0.0158543442438155018914259, -1.04693272280631521908845e-18,
                                            -0.0807455121882807852484731, 3.61852475067037104849987e-18));
  x = ddadd2_vd2_vd2_vd2_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(s2, x),
                         vsel_vd2_vo_d_d_d_d_rvvm1_sleef(o, -0.308425137534042437259529, -1.95698492133633550338345e-17,
                                             0.785398163397448278999491, 3.06287113727155002607105e-17));

  x = ddmul_vd2_vd2_vd2_rvvm1_sleef(x, vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, s2, vcast_vd2_vd_vd_rvvm1_sleef(t, vcast_vd_d_rvvm1_sleef(0))));
  x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, ddadd2_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1)), x);

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(vadd_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(4)), vcast_vi_i_rvvm1_sleef(4)));
  x = vd2setx_vd2_vd2_vd_rvvm1_sleef(x, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x)))));
  x = vd2sety_vd2_vd2_vd_rvvm1_sleef(x, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(x)))));

  return x;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_cospidx_u05rvvm1(vdouble_rvvm1_sleef d) {
  vdouble2_rvvm1_sleef x = cospik_rvvm1_sleef(d);
  vdouble_rvvm1_sleef r = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(x));

  r = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+9/4)), vcast_vd_d_rvvm1_sleef(1), r);
  r = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(d), vreinterpret_vm_vd_rvvm1_sleef(r)));

  return r;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_tandx_u35rvvm1(vdouble_rvvm1_sleef d) {

  vdouble_rvvm1_sleef u, s, x, y;
  rvv_dp_vopmask_rvvm1_sleef o;
  vint_rvvm1_sleef ql;

  if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(15)))), 1)) {
    vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2 * 0.318309886183790671537767526745028724)));
    ql = vrint_vi_vd_rvvm1_sleef(dql);
    x = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.141592653589793116 * 0.5), d);
    x = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16 * 0.5), x);
  } else if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+6)))), 1)) {
    vdouble_rvvm1_sleef dqh = vtruncate_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2*0.318309886183790671537767526745028724 / (1 << 24))));
    dqh = vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(1 << 24));
    vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2*0.318309886183790671537767526745028724)), dqh));
    ql = vrint_vi_vd_rvvm1_sleef(dql);

    x = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914 * 0.5), d);
    x = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914 * 0.5), x);
    x = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08 * 0.5), x);
    x = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08 * 0.5), x);
    x = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16 * 0.5), x);
    x = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16 * 0.5), x);
    x = vmla_vd_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(dqh, dql), vcast_vd_d_rvvm1_sleef(-1.2736634327021899816e-24 * 0.5), x);
  } else {
    ddi_t_rvvm1_sleef ddi_rvvm1_sleef = rempi_rvvm1_sleef(d);
    ql = ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef);
    x = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)), vd2gety_vd_vd2_rvvm1_sleef(ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef)));
    x = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(d), vreinterpret_vm_vd_rvvm1_sleef(x)));
    x = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(d), visnan_vo_vd_rvvm1_sleef(d)), vreinterpret_vm_vd_rvvm1_sleef(x)));
  }

  x = vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0.5));
  s = vmul_vd_vd_vd_rvvm1_sleef(x, x);

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(s, s), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.3245098826639276316e-3)), (vcast_vd_d_rvvm1_sleef(+0.5619219738114323735e-3)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1460781502402784494e-2)), (vcast_vd_d_rvvm1_sleef(+0.3591611540792499519e-2)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.8863268409563113126e-2)), (vcast_vd_d_rvvm1_sleef(+0.2186948728185535498e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.5396825399517272970e-1)), (vcast_vd_d_rvvm1_sleef(+0.1333333333330500581e+0)))))))

                                       ;

  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.3333333333333343695e+0));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(u, x), x);

  y = vmla_vd_vd_vd_vd_rvvm1_sleef(u, u, vcast_vd_d_rvvm1_sleef(-1));
  x = vmul_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(-2));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(1)));
  u = vdiv_vd_vd_vd_rvvm1_sleef(vsel_vd_vo_vd_vd_rvvm1_sleef(o, vneg_vd_vd_rvvm1_sleef(y), x),
                    vsel_vd_vo_vd_vd_rvvm1_sleef(o, x, y));
  u = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), d, u);

  return u;

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_tandx_u10rvvm1(vdouble_rvvm1_sleef d) {

  vdouble_rvvm1_sleef u;
  vdouble2_rvvm1_sleef s, t, x, y;
  rvv_dp_vopmask_rvvm1_sleef o;
  vint_rvvm1_sleef ql;

  if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(15)))), 1)) {
    vdouble_rvvm1_sleef dql = vrint_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2 * 0.318309886183790671537767526745028724)));
    ql = vrint_vi_vd_rvvm1_sleef(dql);
    u = vmla_vd_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.141592653589793116*0.5), d);
    s = ddadd_vd2_vd_vd_rvvm1_sleef (u, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467991473532072e-16*0.5)));
  } else if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1e+14)))), 1)) {
    vdouble_rvvm1_sleef dqh = vtruncate_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(2*0.318309886183790671537767526745028724 / (1 << 24))));
    dqh = vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(1 << 24));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd2_vd_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(0.63661977236758138243, -3.9357353350364971764e-17), d),
                          vsub_vd_vd_vd_rvvm1_sleef(vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)),
                                                         vcast_vd_d_rvvm1_sleef(-0.5), vcast_vd_d_rvvm1_sleef(0.5)), dqh));
    const vdouble_rvvm1_sleef dql = vtruncate_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2gety_vd_vd2_rvvm1_sleef(s)));
    ql = vrint_vi_vd_rvvm1_sleef(dql);

    u = vmla_vd_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914 * 0.5), d);
    s = ddadd_vd2_vd_vd_rvvm1_sleef(u, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1415926218032836914*0.5 )));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08*0.5)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-3.1786509424591713469e-08*0.5 )));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dqh, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16*0.5)));
    s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dql, vcast_vd_d_rvvm1_sleef(-1.2246467864107188502e-16*0.5 )));
    s = ddadd_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(dqh, dql), vcast_vd_d_rvvm1_sleef(-1.2736634327021899816e-24*0.5)));
  } else {
    ddi_t_rvvm1_sleef ddi_rvvm1_sleef = rempi_rvvm1_sleef(d);
    ql = ddigeti_vi_ddi_rvvm1_sleef(ddi_rvvm1_sleef);
    s = ddigetdd_vd2_ddi_rvvm1_sleef(ddi_rvvm1_sleef);
    o = rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(d), visnan_vo_vd_rvvm1_sleef(d));
    s = vd2setx_vd2_vd2_vd_rvvm1_sleef(s, vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s)))));
    s = vd2sety_vd2_vd2_vd_rvvm1_sleef(s, vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(o, vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(s)))));
  }

  t = ddscale_vd2_vd2_vd_rvvm1_sleef(s, vcast_vd_d_rvvm1_sleef(0.5));
  s = ddsqu_vd2_vd2_rvvm1_sleef(t);

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2getx_vd_vd2_rvvm1_sleef(s)), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(+0.3245098826639276316e-3)), (vcast_vd_d_rvvm1_sleef(+0.5619219738114323735e-3)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(+0.1460781502402784494e-2)), (vcast_vd_d_rvvm1_sleef(+0.3591611540792499519e-2)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(+0.8863268409563113126e-2)), (vcast_vd_d_rvvm1_sleef(+0.2186948728185535498e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(+0.5396825399517272970e-1)), (vcast_vd_d_rvvm1_sleef(+0.1333333333330500581e+0)))))))

                                       ;

  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(+0.3333333333333343695e+0));
  x = ddadd_vd2_vd2_vd2_rvvm1_sleef(t, ddmul_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(s, t), u));

  y = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-1), ddsqu_vd2_vd2_rvvm1_sleef(x));
  x = ddscale_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(-2));

  o = vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(ql, vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(1)));

  x = dddiv_vd2_vd2_vd2_rvvm1_sleef(vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, ddneg_vd2_vd2_rvvm1_sleef(y), x),
                        vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, x, y));

  u = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(x));

  u = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), d, u);

  return u;

}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef atan2k_rvvm1_sleef(vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef s, t, u;
  vint_rvvm1_sleef q;
  rvv_dp_vopmask_rvvm1_sleef p;

  q = vsel_vi_vd_vi_rvvm1_sleef(x, vcast_vi_i_rvvm1_sleef(-2));
  x = vabs_vd_vd_rvvm1_sleef(x);

  q = vsel_vi_vd_vd_vi_vi_rvvm1_sleef(x, y, vadd_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(1)), q);
  p = vlt_vo_vd_vd_rvvm1_sleef(x, y);
  s = vsel_vd_vo_vd_vd_rvvm1_sleef(p, vneg_vd_vd_rvvm1_sleef(x), y);
  t = vmax_vd_vd_vd_rvvm1_sleef(x, y);

  s = vdiv_vd_vd_vd_rvvm1_sleef(s, t);
  t = vmul_vd_vd_vd_rvvm1_sleef(s, s);

  vdouble_rvvm1_sleef t2 = vmul_vd_vd_vd_rvvm1_sleef(t, t), t4 = vmul_vd_vd_vd_rvvm1_sleef(t2, t2), t8 = vmul_vd_vd_vd_rvvm1_sleef(t4, t4), t16 = vmul_vd_vd_vd_rvvm1_sleef(t8, t8);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((t16), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vcast_vd_d_rvvm1_sleef(-1.88796008463073496563746e-05)), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.000209850076645816976906797)), (vcast_vd_d_rvvm1_sleef(-0.00110611831486672482563471)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t8), (vmla_vd_vd_vd_vd_rvvm1_sleef((t4), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.00370026744188713119232403)), (vcast_vd_d_rvvm1_sleef(-0.00889896195887655491740809)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.016599329773529201970117)), (vcast_vd_d_rvvm1_sleef(-0.0254517624932312641616861)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.0337852580001353069993897)), (vcast_vd_d_rvvm1_sleef(-0.0407629191276836500001934)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.0466667150077840625632675)), (vcast_vd_d_rvvm1_sleef(-0.0523674852303482457616113)))))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t4), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.0587666392926673580854313)), (vcast_vd_d_rvvm1_sleef(-0.0666573579361080525984562)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.0769219538311769618355029)), (vcast_vd_d_rvvm1_sleef(-0.090908995008245008229153)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.111111105648261418443745)), (vcast_vd_d_rvvm1_sleef(-0.14285714266771329383765)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.199999999996591265594148)), (vcast_vd_d_rvvm1_sleef(-0.333333333333311110369124)))))))))))

                                         ;

  t = vmla_vd_vd_vd_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(t, u), s);
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(vcast_vd_vi_rvvm1_sleef(q), vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/2), t);

  return t;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef atan2k_u1_rvvm1_sleef(vdouble2_rvvm1_sleef y, vdouble2_rvvm1_sleef x) {
  vdouble_rvvm1_sleef u;
  vdouble2_rvvm1_sleef s, t;
  vint_rvvm1_sleef q;
  rvv_dp_vopmask_rvvm1_sleef p;

  q = vsel_vi_vd_vi_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vcast_vi_i_rvvm1_sleef(-2));
  p = vlt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(0));
  vmask_rvvm1_sleef b = vand_vm_vo64_vm_rvvm1_sleef(p, vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0)));
  x = vd2setx_vd2_vd2_vd_rvvm1_sleef(x, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(b, vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x)))));
  x = vd2sety_vd2_vd2_vd_rvvm1_sleef(x, vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(b, vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(x)))));

  q = vsel_vi_vd_vd_vi_vi_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y), vadd_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(1)), q);
  p = vlt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(y));
  s = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(p, ddneg_vd2_vd2_rvvm1_sleef(x), y);
  t = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(p, y, x);

  s = dddiv_vd2_vd2_vd2_rvvm1_sleef(s, t);
  t = ddsqu_vd2_vd2_rvvm1_sleef(s);
  t = ddnormalize_vd2_vd2_rvvm1_sleef(t);

  vdouble_rvvm1_sleef t2 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(t), vd2getx_vd_vd2_rvvm1_sleef(t)), t4 = vmul_vd_vd_vd_rvvm1_sleef(t2, t2), t8 = vmul_vd_vd_vd_rvvm1_sleef(t4, t4);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((t8), (vmla_vd_vd_vd_vd_rvvm1_sleef((t4), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(t)), (vcast_vd_d_rvvm1_sleef(1.06298484191448746607415e-05)), (vcast_vd_d_rvvm1_sleef(-0.000125620649967286867384336)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(t)), (vcast_vd_d_rvvm1_sleef(0.00070557664296393412389774)), (vcast_vd_d_rvvm1_sleef(-0.00251865614498713360352999)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(t)), (vcast_vd_d_rvvm1_sleef(0.00646262899036991172313504)), (vcast_vd_d_rvvm1_sleef(-0.0128281333663399031014274)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(t)), (vcast_vd_d_rvvm1_sleef(0.0208024799924145797902497)), (vcast_vd_d_rvvm1_sleef(-0.0289002344784740315686289)))))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t4), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(t)), (vcast_vd_d_rvvm1_sleef(0.0359785005035104590853656)), (vcast_vd_d_rvvm1_sleef(-0.041848579703592507506027)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(t)), (vcast_vd_d_rvvm1_sleef(0.0470843011653283988193763)), (vcast_vd_d_rvvm1_sleef(-0.0524914210588448421068719)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(t)), (vcast_vd_d_rvvm1_sleef(0.0587946590969581003860434)), (vcast_vd_d_rvvm1_sleef(-0.0666620884778795497194182)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(t)), (vcast_vd_d_rvvm1_sleef(0.0769225330296203768654095)), (vcast_vd_d_rvvm1_sleef(-0.0909090442773387574781907)))))))))

                                          ;
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(t), vcast_vd_d_rvvm1_sleef(0.111111108376896236538123));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(t), vcast_vd_d_rvvm1_sleef(-0.142857142756268568062339));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(t), vcast_vd_d_rvvm1_sleef(0.199999999997977351284817));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(t), vcast_vd_d_rvvm1_sleef(-0.333333333333317605173818));

  t = ddadd_vd2_vd2_vd2_rvvm1_sleef(s, ddmul_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(s, t), u));

  t = ddadd_vd2_vd2_vd2_rvvm1_sleef(ddmul_vd2_vd2_vd_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(1.570796326794896557998982, 6.12323399573676603586882e-17), vcast_vd_vi_rvvm1_sleef(q)), t);

  return t;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef visinf2_vd_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d, vdouble_rvvm1_sleef m) {
  return vreinterpret_vd_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(d), vor_vm_vm_vm_rvvm1_sleef(vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(d), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(m))));
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_atan2dx_u35rvvm1(vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef r = atan2k_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(y), x);

  r = vmulsign_vd_vd_vd_rvvm1_sleef(r, x);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(x), veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0))), vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/2), visinf2_vd_vd_vd_rvvm1_sleef(x, vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/2), x))), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(y), vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/2), visinf2_vd_vd_vd_rvvm1_sleef(x, vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/4), x))), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(0.0)), vreinterpret_vd_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(vsignbit_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884)))), r);

  r = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visnan_vo_vd_rvvm1_sleef(x), visnan_vo_vd_rvvm1_sleef(y)), vreinterpret_vm_vd_rvvm1_sleef(vmulsign_vd_vd_vd_rvvm1_sleef(r, y))));
  return r;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_atan2dx_u10rvvm1(vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef x) {
  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(5.5626846462680083984e-309));
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(UINT64_C(1) << 53)), x);
  y = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(UINT64_C(1) << 53)), y);

  vdouble2_rvvm1_sleef d = atan2k_u1_rvvm1_sleef(vcast_vd2_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(y), vcast_vd_d_rvvm1_sleef(0)), vcast_vd2_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0)));
  vdouble_rvvm1_sleef r = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d));

  r = vmulsign_vd_vd_vd_rvvm1_sleef(r, x);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(x), veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0))), vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/2), visinf2_vd_vd_vd_rvvm1_sleef(x, vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/2), x))), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(y), vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/2), visinf2_vd_vd_vd_rvvm1_sleef(x, vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/4), x))), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(0.0)), vreinterpret_vd_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(vsignbit_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884)))), r);

  r = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visnan_vo_vd_rvvm1_sleef(x), visnan_vo_vd_rvvm1_sleef(y)), vreinterpret_vm_vd_rvvm1_sleef(vmulsign_vd_vd_vd_rvvm1_sleef(r, y))));
  return r;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_asindx_u35rvvm1(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(0.5));
  vdouble_rvvm1_sleef x2 = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, d), vmul_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), vabs_vd_vd_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(0.5)));
  vdouble_rvvm1_sleef x = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vabs_vd_vd_rvvm1_sleef(d), vsqrt_vd_vd_rvvm1_sleef(x2)), u;

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(x2, x2), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4), x16 = vmul_vd_vd_vd_rvvm1_sleef(x8, x8);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((x16), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.3161587650653934628e-1)), (vcast_vd_d_rvvm1_sleef(-0.1581918243329996643e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1929045477267910674e-1)), (vcast_vd_d_rvvm1_sleef(+0.6606077476277170610e-2)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1215360525577377331e-1)), (vcast_vd_d_rvvm1_sleef(+0.1388715184501609218e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1735956991223614604e-1)), (vcast_vd_d_rvvm1_sleef(+0.2237176181932048341e-1)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.3038195928038132237e-1)), (vcast_vd_d_rvvm1_sleef(+0.4464285681377102438e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.7500000000378581611e-1)), (vcast_vd_d_rvvm1_sleef(+0.1666666666666497543e+0)))))))))

                                       ;

  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vmul_vd_vd_vd_rvvm1_sleef(x, x2), x);

  vdouble_rvvm1_sleef r = vsel_vd_vo_vd_vd_rvvm1_sleef(o, u, vmla_vd_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(-2), vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/2)));
  return vmulsign_vd_vd_vd_rvvm1_sleef(r, d);
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_asindx_u10rvvm1(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(0.5));
  vdouble_rvvm1_sleef x2 = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, d), vmul_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), vabs_vd_vd_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(0.5))), u;
  vdouble2_rvvm1_sleef x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, vcast_vd2_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(0)), ddsqrt_vd2_vd_rvvm1_sleef(x2));
  x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1.0)), vcast_vd2_d_d_rvvm1_sleef(0, 0), x);

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(x2, x2), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4), x16 = vmul_vd_vd_vd_rvvm1_sleef(x8, x8);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((x16), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.3161587650653934628e-1)), (vcast_vd_d_rvvm1_sleef(-0.1581918243329996643e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1929045477267910674e-1)), (vcast_vd_d_rvvm1_sleef(+0.6606077476277170610e-2)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1215360525577377331e-1)), (vcast_vd_d_rvvm1_sleef(+0.1388715184501609218e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1735956991223614604e-1)), (vcast_vd_d_rvvm1_sleef(+0.2237176181932048341e-1)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.3038195928038132237e-1)), (vcast_vd_d_rvvm1_sleef(+0.4464285681377102438e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.7500000000378581611e-1)), (vcast_vd_d_rvvm1_sleef(+0.1666666666666497543e+0)))))))))

                                       ;

  u = vmul_vd_vd_vd_rvvm1_sleef(u, vmul_vd_vd_vd_rvvm1_sleef(x2, vd2getx_vd_vd2_rvvm1_sleef(x)));

  vdouble2_rvvm1_sleef y = ddsub_vd2_vd2_vd_rvvm1_sleef(ddsub_vd2_vd2_vd2_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(3.141592653589793116/4, 1.2246467991473532072e-16/4), x), u);

  vdouble_rvvm1_sleef r = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vadd_vd_vd_vd_rvvm1_sleef(u, vd2getx_vd_vd2_rvvm1_sleef(x)),
                               vmul_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(y), vd2gety_vd_vd2_rvvm1_sleef(y)), vcast_vd_d_rvvm1_sleef(2)));
  return vmulsign_vd_vd_vd_rvvm1_sleef(r, d);
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_acosdx_u35rvvm1(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(0.5));
  vdouble_rvvm1_sleef x2 = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, d),
                                vmul_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), vabs_vd_vd_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(0.5))), u;
  vdouble_rvvm1_sleef x = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vabs_vd_vd_rvvm1_sleef(d), vsqrt_vd_vd_rvvm1_sleef(x2));
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1.0)), vcast_vd_d_rvvm1_sleef(0), x);

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(x2, x2), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4), x16 = vmul_vd_vd_vd_rvvm1_sleef(x8, x8);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((x16), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.3161587650653934628e-1)), (vcast_vd_d_rvvm1_sleef(-0.1581918243329996643e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1929045477267910674e-1)), (vcast_vd_d_rvvm1_sleef(+0.6606077476277170610e-2)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1215360525577377331e-1)), (vcast_vd_d_rvvm1_sleef(+0.1388715184501609218e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1735956991223614604e-1)), (vcast_vd_d_rvvm1_sleef(+0.2237176181932048341e-1)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.3038195928038132237e-1)), (vcast_vd_d_rvvm1_sleef(+0.4464285681377102438e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.7500000000378581611e-1)), (vcast_vd_d_rvvm1_sleef(+0.1666666666666497543e+0)))))))))

                                       ;

  u = vmul_vd_vd_vd_rvvm1_sleef(u, vmul_vd_vd_vd_rvvm1_sleef(x2, x));

  vdouble_rvvm1_sleef y = vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/2), vadd_vd_vd_vd_rvvm1_sleef(vmulsign_vd_vd_vd_rvvm1_sleef(x, d), vmulsign_vd_vd_vd_rvvm1_sleef(u, d)));
  x = vadd_vd_vd_vd_rvvm1_sleef(x, u);
  vdouble_rvvm1_sleef r = vsel_vd_vo_vd_vd_rvvm1_sleef(o, y, vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(2)));
  return vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vandnot_vo_vo_vo(o, vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0))),
                          vd2getx_vd_vd2_rvvm1_sleef(ddadd_vd2_vd2_vd_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(3.141592653589793116, 1.2246467991473532072e-16),
                                                          vneg_vd_vd_rvvm1_sleef(r))), r);
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_acosdx_u10rvvm1(vdouble_rvvm1_sleef d) {
  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(0.5));
  vdouble_rvvm1_sleef x2 = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, d), vmul_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), vabs_vd_vd_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(0.5))), u;
  vdouble2_rvvm1_sleef x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, vcast_vd2_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(0)), ddsqrt_vd2_vd_rvvm1_sleef(x2));
  x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1.0)), vcast_vd2_d_d_rvvm1_sleef(0, 0), x);

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(x2, x2), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4), x16 = vmul_vd_vd_vd_rvvm1_sleef(x8, x8);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((x16), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.3161587650653934628e-1)), (vcast_vd_d_rvvm1_sleef(-0.1581918243329996643e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1929045477267910674e-1)), (vcast_vd_d_rvvm1_sleef(+0.6606077476277170610e-2)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1215360525577377331e-1)), (vcast_vd_d_rvvm1_sleef(+0.1388715184501609218e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1735956991223614604e-1)), (vcast_vd_d_rvvm1_sleef(+0.2237176181932048341e-1)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.3038195928038132237e-1)), (vcast_vd_d_rvvm1_sleef(+0.4464285681377102438e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.7500000000378581611e-1)), (vcast_vd_d_rvvm1_sleef(+0.1666666666666497543e+0)))))))))

                                       ;

  u = vmul_vd_vd_vd_rvvm1_sleef(u, vmul_vd_vd_vd_rvvm1_sleef(x2, vd2getx_vd_vd2_rvvm1_sleef(x)));

  vdouble2_rvvm1_sleef y = ddsub_vd2_vd2_vd2_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(3.141592653589793116/2, 1.2246467991473532072e-16/2),
                                 ddadd_vd2_vd_vd_rvvm1_sleef(vmulsign_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), d), vmulsign_vd_vd_vd_rvvm1_sleef(u, d)));
  x = ddadd_vd2_vd2_vd_rvvm1_sleef(x, u);

  y = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, y, ddscale_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(2)));

  y = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(rvv_dp_vandnot_vo_vo_vo(o, vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0))),
                          ddsub_vd2_vd2_vd2_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(3.141592653589793116, 1.2246467991473532072e-16), y), y);

  return vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(y), vd2gety_vd_vd2_rvvm1_sleef(y));
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_atandx_u10rvvm1(vdouble_rvvm1_sleef d) {
  vdouble2_rvvm1_sleef d2 = atan2k_u1_rvvm1_sleef(vcast_vd2_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(0)), vcast_vd2_d_d_rvvm1_sleef(1, 0));
  vdouble_rvvm1_sleef r = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d2), vd2gety_vd_vd2_rvvm1_sleef(d2));
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1.570796326794896557998982), r);
  return vmulsign_vd_vd_vd_rvvm1_sleef(r, d);
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_atandx_u35rvvm1(vdouble_rvvm1_sleef s) {
  vdouble_rvvm1_sleef t, u;
  vint_rvvm1_sleef q;

  q = vsel_vi_vd_vi_rvvm1_sleef(s, vcast_vi_i_rvvm1_sleef(2));
  s = vabs_vd_vd_rvvm1_sleef(s);

  q = vsel_vi_vd_vd_vi_vi_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), s, vadd_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(1)), q);
  s = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), s), vrec_vd_vd_rvvm1_sleef(s), s);

  t = vmul_vd_vd_vd_rvvm1_sleef(s, s);

  vdouble_rvvm1_sleef t2 = vmul_vd_vd_vd_rvvm1_sleef(t, t), t4 = vmul_vd_vd_vd_rvvm1_sleef(t2, t2), t8 = vmul_vd_vd_vd_rvvm1_sleef(t4, t4), t16 = vmul_vd_vd_vd_rvvm1_sleef(t8, t8);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((t16), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vcast_vd_d_rvvm1_sleef(-1.88796008463073496563746e-05)), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.000209850076645816976906797)), (vcast_vd_d_rvvm1_sleef(-0.00110611831486672482563471)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t8), (vmla_vd_vd_vd_vd_rvvm1_sleef((t4), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.00370026744188713119232403)), (vcast_vd_d_rvvm1_sleef(-0.00889896195887655491740809)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.016599329773529201970117)), (vcast_vd_d_rvvm1_sleef(-0.0254517624932312641616861)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.0337852580001353069993897)), (vcast_vd_d_rvvm1_sleef(-0.0407629191276836500001934)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.0466667150077840625632675)), (vcast_vd_d_rvvm1_sleef(-0.0523674852303482457616113)))))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t4), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.0587666392926673580854313)), (vcast_vd_d_rvvm1_sleef(-0.0666573579361080525984562)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.0769219538311769618355029)), (vcast_vd_d_rvvm1_sleef(-0.090908995008245008229153)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t2), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.111111105648261418443745)), (vcast_vd_d_rvvm1_sleef(-0.14285714266771329383765)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((t), (vcast_vd_d_rvvm1_sleef(0.199999999996591265594148)), (vcast_vd_d_rvvm1_sleef(-0.333333333333311110369124)))))))))))

                                         ;

  t = vmla_vd_vd_vd_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(t, u), s);

  t = vsel_vd_vo_vd_vd_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(1)), vcast_vi_i_rvvm1_sleef(1))), vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3.141592653589793238462643383279502884/2), t), t);
  t = vreinterpret_vd_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo64_vm_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(2)), vcast_vi_i_rvvm1_sleef(2))), vreinterpret_vm_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-0.0))), vreinterpret_vm_vd_rvvm1_sleef(t)));

  return t;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_logdx_u35rvvm1(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef x, x2;
  vdouble_rvvm1_sleef t, m;

  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0x1p-1022));
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef((double)(INT64_C(1) << 32) * (double)(INT64_C(1) << 32))), d);
  vint_rvvm1_sleef e = vilogb2k_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1.0/0.75)));
  m = vldexp3_vd_vd_vi_rvvm1_sleef(d, vneg_vi_vi_rvvm1_sleef(e));
  e = vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(o), vsub_vi_vi_vi_rvvm1_sleef(e, vcast_vi_i_rvvm1_sleef(64)), e);

  x = vdiv_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(m, vcast_vd_d_rvvm1_sleef(1)), vadd_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), m));
  x2 = vmul_vd_vd_vd_rvvm1_sleef(x, x);

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(x2, x2), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4), x3 = vmul_vd_vd_vd_rvvm1_sleef(x, x2);
  t = vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vcast_vd_d_rvvm1_sleef(0.153487338491425068243146)), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(0.152519917006351951593857)), (vcast_vd_d_rvvm1_sleef(0.181863266251982985677316)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(0.222221366518767365905163)), (vcast_vd_d_rvvm1_sleef(0.285714294746548025383248)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(0.399999999950799600689777)), (vcast_vd_d_rvvm1_sleef(0.6666666666667778740063)))))))

                                     ;

  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(2), vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0.693147180559945286226764), vcast_vd_vi_rvvm1_sleef(e)));
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x3, t, x);

  x = vsel_vd_vo_vd_vd_rvvm1_sleef(vispinf_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(__builtin_inf()), x);
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), visnan_vo_vd_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), x);
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(-__builtin_inf()), x);

  return x;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_expdx_u10rvvm1(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef u = vrint_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1.442695040888963407359924681001892137426645954152985934135449406931))), s;
  vint_rvvm1_sleef q = vrint_vi_vd_rvvm1_sleef(u);

  s = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(-.69314718055966295651160180568695068359375), d);
  s = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(-.28235290563031577122588448175013436025525412068e-12), s);

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(s, s), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2), s8 = vmul_vd_vd_vd_rvvm1_sleef(s4, s4);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s8), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.2081276378237164457e-8)), (vcast_vd_d_rvvm1_sleef(+0.2511210703042288022e-7)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.2755762628169491192e-6)), (vcast_vd_d_rvvm1_sleef(+0.2755723402025388239e-5)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.2480158687479686264e-4)), (vcast_vd_d_rvvm1_sleef(+0.1984126989855865850e-3)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1388888888914497797e-2)), (vcast_vd_d_rvvm1_sleef(+0.8333333333314938210e-2)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.4166666666666602598e-1)), (vcast_vd_d_rvvm1_sleef(+0.1666666666666669072e+0)))))))))

                                       ;
  u = vfma_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.5000000000000000000e+0));
  u = vfma_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.1000000000000000000e+1));
  u = vfma_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.1000000000000000000e+1));

  u = vldexp2_vd_vd_vi_rvvm1_sleef(u, q);

  u = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(709.78271114955742909217217426)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), u);
  u = vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(-1000)), vreinterpret_vm_vd_rvvm1_sleef(u)));

  return u;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef expm1k_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef u = vrint_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1.442695040888963407359924681001892137426645954152985934135449406931))), s;
  vint_rvvm1_sleef q = vrint_vi_vd_rvvm1_sleef(u);

  s = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(-.69314718055966295651160180568695068359375), d);
  s = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(-.28235290563031577122588448175013436025525412068e-12), s);

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(s, s), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2), s8 = vmul_vd_vd_vd_rvvm1_sleef(s4, s4);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s8), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(2.08860621107283687536341e-09)), (vcast_vd_d_rvvm1_sleef(2.51112930892876518610661e-08)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(2.75573911234900471893338e-07)), (vcast_vd_d_rvvm1_sleef(2.75572362911928827629423e-06)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(2.4801587159235472998791e-05)), (vcast_vd_d_rvvm1_sleef(0.000198412698960509205564975)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(0.00138888888889774492207962)), (vcast_vd_d_rvvm1_sleef(0.00833333333331652721664984)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(0.0416666666666665047591422)), (vcast_vd_d_rvvm1_sleef(0.166666666666666851703837)))))))))

                                        ;

  u = vadd_vd_vd_vd_rvvm1_sleef(vmla_vd_vd_vd_vd_rvvm1_sleef(s2, vcast_vd_d_rvvm1_sleef(0.5), vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(s2, s), u)), s);

  u = vsel_vd_vo_vd_vd_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(q, vcast_vi_i_rvvm1_sleef(0))), u,
                       vsub_vd_vd_vd_rvvm1_sleef(vldexp2_vd_vd_vi_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(1)), q), vcast_vd_d_rvvm1_sleef(1)));

  return u;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef logk_rvvm1_sleef(vdouble_rvvm1_sleef d) {
  vdouble2_rvvm1_sleef x, x2, s;
  vdouble_rvvm1_sleef t, m;

  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0x1p-1022));
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef((double)(INT64_C(1) << 32) * (double)(INT64_C(1) << 32))), d);
  vint_rvvm1_sleef e = vilogb2k_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1.0/0.75)));
  m = vldexp3_vd_vd_vi_rvvm1_sleef(d, vneg_vi_vi_rvvm1_sleef(e));
  e = vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(o), vsub_vi_vi_vi_rvvm1_sleef(e, vcast_vi_i_rvvm1_sleef(64)), e);

  x = dddiv_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-1), m), ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), m));
  x2 = ddsqu_vd2_vd2_rvvm1_sleef(x);

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x2), vd2getx_vd_vd2_rvvm1_sleef(x2)), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4), x16 = vmul_vd_vd_vd_rvvm1_sleef(x8, x8);
  t = vmla_vd_vd_vd_vd_rvvm1_sleef((x16), (vcast_vd_d_rvvm1_sleef(0.116255524079935043668677)), (vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(x2)), (vcast_vd_d_rvvm1_sleef(0.103239680901072952701192)), (vcast_vd_d_rvvm1_sleef(0.117754809412463995466069)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(x2)), (vcast_vd_d_rvvm1_sleef(0.13332981086846273921509)), (vcast_vd_d_rvvm1_sleef(0.153846227114512262845736)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(x2)), (vcast_vd_d_rvvm1_sleef(0.181818180850050775676507)), (vcast_vd_d_rvvm1_sleef(0.222222222230083560345903)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(x2)), (vcast_vd_d_rvvm1_sleef(0.285714285714249172087875)), (vcast_vd_d_rvvm1_sleef(0.400000000000000077715612)))))))))

                                       ;

  vdouble2_rvvm1_sleef c = vcast_vd2_d_d_rvvm1_sleef(0.666666666666666629659233, 3.80554962542412056336616e-17);

  s = ddmul_vd2_vd2_vd_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(0.693147180559945286226764, 2.319046813846299558417771e-17), vcast_vd_vi_rvvm1_sleef(e));

  s = ddadd_vd2_vd2_vd2_rvvm1_sleef(s, ddscale_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(2)));
  x = ddmul_vd2_vd2_vd2_rvvm1_sleef(x2, x);
  s = ddadd_vd2_vd2_vd2_rvvm1_sleef(s, ddmul_vd2_vd2_vd2_rvvm1_sleef(x, c));
  x = ddmul_vd2_vd2_vd2_rvvm1_sleef(x2, x);
  s = ddadd_vd2_vd2_vd2_rvvm1_sleef(s, ddmul_vd2_vd2_vd_rvvm1_sleef(x, t));

  return s;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_logdx_u10rvvm1(vdouble_rvvm1_sleef d) {
  vdouble2_rvvm1_sleef x;
  vdouble_rvvm1_sleef t, m, x2;

  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0x1p-1022));
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef((double)(INT64_C(1) << 32) * (double)(INT64_C(1) << 32))), d);
  vint_rvvm1_sleef e = vilogb2k_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1.0/0.75)));
  m = vldexp3_vd_vd_vi_rvvm1_sleef(d, vneg_vi_vi_rvvm1_sleef(e));
  e = vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(o), vsub_vi_vi_vi_rvvm1_sleef(e, vcast_vi_i_rvvm1_sleef(64)), e);

  x = dddiv_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-1), m), ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), m));
  x2 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(x));

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(x2, x2), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4);
  t = vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vcast_vd_d_rvvm1_sleef(0.1532076988502701353e+0)), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(0.1525629051003428716e+0)), (vcast_vd_d_rvvm1_sleef(0.1818605932937785996e+0)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(0.2222214519839380009e+0)), (vcast_vd_d_rvvm1_sleef(0.2857142932794299317e+0)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(0.3999999999635251990e+0)), (vcast_vd_d_rvvm1_sleef(0.6666666666667333541e+0)))))))

                                     ;

  vdouble2_rvvm1_sleef s = ddmul_vd2_vd2_vd_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(0.693147180559945286226764, 2.319046813846299558417771e-17), vcast_vd_vi_rvvm1_sleef(e));

  s = ddadd_vd2_vd2_vd2_rvvm1_sleef(s, ddscale_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(2)));
  s = ddadd_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x2, vd2getx_vd_vd2_rvvm1_sleef(x)), t));

  vdouble_rvvm1_sleef r = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2gety_vd_vd2_rvvm1_sleef(s));

  r = vsel_vd_vo_vd_vd_rvvm1_sleef(vispinf_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(__builtin_inf()), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), visnan_vo_vd_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(-__builtin_inf()), r);

  return r;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef expk_rvvm1_sleef(vdouble2_rvvm1_sleef d) {
  vdouble_rvvm1_sleef u = vmul_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(1.442695040888963407359924681001892137426645954152985934135449406931));
  vdouble_rvvm1_sleef dq = vrint_vd_vd_rvvm1_sleef(u);
  vint_rvvm1_sleef q = vrint_vi_vd_rvvm1_sleef(dq);
  vdouble2_rvvm1_sleef s, t;

  s = ddadd2_vd2_vd2_vd_rvvm1_sleef(d, vmul_vd_vd_vd_rvvm1_sleef(dq, vcast_vd_d_rvvm1_sleef(-.69314718055966295651160180568695068359375)));
  s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dq, vcast_vd_d_rvvm1_sleef(-.28235290563031577122588448175013436025525412068e-12)));

  s = ddnormalize_vd2_vd2_rvvm1_sleef(s);

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2getx_vd_vd2_rvvm1_sleef(s)), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2), s8 = vmul_vd_vd_vd_rvvm1_sleef(s4, s4);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s8), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(2.51069683420950419527139e-08)), (vcast_vd_d_rvvm1_sleef(2.76286166770270649116855e-07)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(2.75572496725023574143864e-06)), (vcast_vd_d_rvvm1_sleef(2.48014973989819794114153e-05)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(0.000198412698809069797676111)), (vcast_vd_d_rvvm1_sleef(0.0013888888939977128960529)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(0.00833333333332371417601081)), (vcast_vd_d_rvvm1_sleef(0.0416666666665409524128449)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(0.166666666666666740681535)), (vcast_vd_d_rvvm1_sleef(0.500000000000000999200722)))))))))

                                        ;

  t = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), s);
  t = ddadd_vd2_vd2_vd2_rvvm1_sleef(t, ddmul_vd2_vd2_vd_rvvm1_sleef(ddsqu_vd2_vd2_rvvm1_sleef(s), u));

  u = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(t), vd2gety_vd_vd2_rvvm1_sleef(t));
  u = vldexp2_vd_vd_vi_rvvm1_sleef(u, q);

  u = vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(-1000)), vreinterpret_vm_vd_rvvm1_sleef(u)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_powdx_u10rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {

  rvv_dp_vopmask_rvvm1_sleef yisint = visint_vo_vd_rvvm1_sleef(y);
  rvv_dp_vopmask_rvvm1_sleef yisodd = rvv_dp_vand_vo_vo_vo(visodd_vo_vd_rvvm1_sleef(y), yisint);

  vdouble2_rvvm1_sleef d = ddmul_vd2_vd2_vd_rvvm1_sleef(logk_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x)), y);
  vdouble_rvvm1_sleef result = expk_rvvm1_sleef(d);
  result = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(709.78271114955742909217217426)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), result);

  result = vmul_vd_vd_vd_rvvm1_sleef(result,
                         vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0)),
                                          vcast_vd_d_rvvm1_sleef(1),
                                          vsel_vd_vo_vd_vd_rvvm1_sleef(yisint, vsel_vd_vo_vd_vd_rvvm1_sleef(yisodd, vcast_vd_d_rvvm1_sleef(-1.0), vcast_vd_d_rvvm1_sleef(1)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")))));

  vdouble_rvvm1_sleef efx = vmulsign_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(1)), y);

  result = vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(y),
                            vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(efx, vcast_vd_d_rvvm1_sleef(0.0)),
                                                                  vreinterpret_vm_vd_rvvm1_sleef(vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(efx, vcast_vd_d_rvvm1_sleef(0.0)),
                                                                                                      vcast_vd_d_rvvm1_sleef(1.0),
                                                                                                      vcast_vd_d_rvvm1_sleef(__builtin_inf()))))),
                            result);

  result = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(x), veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0.0))),
                            vmulsign_vd_vd_vd_rvvm1_sleef(vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vxor_vo_vo_vo(vsignbit_vo_vd_rvvm1_sleef(y), veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0.0))),
                                                               vcast_vd_d_rvvm1_sleef(0), vcast_vd_d_rvvm1_sleef(__builtin_inf())),
                                              vsel_vd_vo_vd_vd_rvvm1_sleef(yisodd, x, vcast_vd_d_rvvm1_sleef(1))), result);

  result = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visnan_vo_vd_rvvm1_sleef(x), visnan_vo_vd_rvvm1_sleef(y)), vreinterpret_vm_vd_rvvm1_sleef(result)));

  result = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(veq_vo_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(0)), veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1))), vcast_vd_d_rvvm1_sleef(1), result);

  return result;

}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef expk2_rvvm1_sleef(vdouble2_rvvm1_sleef d) {
  vdouble_rvvm1_sleef u = vmul_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(1.442695040888963407359924681001892137426645954152985934135449406931));
  vdouble_rvvm1_sleef dq = vrint_vd_vd_rvvm1_sleef(u);
  vint_rvvm1_sleef q = vrint_vi_vd_rvvm1_sleef(dq);
  vdouble2_rvvm1_sleef s, t;

  s = ddadd2_vd2_vd2_vd_rvvm1_sleef(d, vmul_vd_vd_vd_rvvm1_sleef(dq, vcast_vd_d_rvvm1_sleef(-.69314718055966295651160180568695068359375)));
  s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(dq, vcast_vd_d_rvvm1_sleef(-.28235290563031577122588448175013436025525412068e-12)));

  vdouble2_rvvm1_sleef s2 = ddsqu_vd2_vd2_rvvm1_sleef(s), s4 = ddsqu_vd2_vd2_rvvm1_sleef(s2);
  vdouble_rvvm1_sleef s8 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s4), vd2getx_vd_vd2_rvvm1_sleef(s4));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s8), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(+0.1602472219709932072e-9)), (vcast_vd_d_rvvm1_sleef(+0.2092255183563157007e-8)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s4)), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s2)), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(+0.2505230023782644465e-7)), (vcast_vd_d_rvvm1_sleef(+0.2755724800902135303e-6)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(+0.2755731892386044373e-5)), (vcast_vd_d_rvvm1_sleef(+0.2480158735605815065e-4)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s2)), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(+0.1984126984148071858e-3)), (vcast_vd_d_rvvm1_sleef(+0.1388888888886763255e-2)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(s)), (vcast_vd_d_rvvm1_sleef(+0.8333333333333347095e-2)), (vcast_vd_d_rvvm1_sleef(+0.4166666666666669905e-1)))))))))

                                       ;

  t = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0.5), ddmul_vd2_vd2_vd_rvvm1_sleef(s, vcast_vd_d_rvvm1_sleef(+0.1666666666666666574e+0)));
  t = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1.0), ddmul_vd2_vd2_vd2_rvvm1_sleef(t, s));
  t = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1.0), ddmul_vd2_vd2_vd2_rvvm1_sleef(t, s));
  t = ddadd_vd2_vd2_vd2_rvvm1_sleef(t, ddmul_vd2_vd2_vd_rvvm1_sleef(s4, u));

  t = vd2setx_vd2_vd2_vd_rvvm1_sleef(t, vldexp2_vd_vd_vi_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(t), q));
  t = vd2sety_vd2_vd2_vd_rvvm1_sleef(t, vldexp2_vd_vd_vi_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(t), q));

  t = vd2setx_vd2_vd2_vd_rvvm1_sleef(t, vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(-1000)), vreinterpret_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(t)))));
  t = vd2sety_vd2_vd2_vd_rvvm1_sleef(t, vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(-1000)), vreinterpret_vm_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(t)))));

  return t;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_sinhdx_u10rvvm1(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef y = vabs_vd_vd_rvvm1_sleef(x);
  vdouble2_rvvm1_sleef d = expk2_rvvm1_sleef(vcast_vd2_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(0)));
  d = ddsub_vd2_vd2_vd2_rvvm1_sleef(d, ddrec_vd2_vd2_rvvm1_sleef(d));
  y = vmul_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(0.5));

  y = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(710)), visnan_vo_vd_rvvm1_sleef(y)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), y);
  y = vmulsign_vd_vd_vd_rvvm1_sleef(y, x);
  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_coshdx_u10rvvm1(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef y = vabs_vd_vd_rvvm1_sleef(x);
  vdouble2_rvvm1_sleef d = expk2_rvvm1_sleef(vcast_vd2_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(0)));
  d = ddadd_vd2_vd2_vd2_rvvm1_sleef(d, ddrec_vd2_vd2_rvvm1_sleef(d));
  y = vmul_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(0.5));

  y = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(710)), visnan_vo_vd_rvvm1_sleef(y)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), y);
  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_tanhdx_u10rvvm1(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef y = vabs_vd_vd_rvvm1_sleef(x);
  vdouble2_rvvm1_sleef d = expk2_rvvm1_sleef(vcast_vd2_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(0)));
  vdouble2_rvvm1_sleef e = ddrec_vd2_vd2_rvvm1_sleef(d);
  d = dddiv_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd2_rvvm1_sleef(d, ddneg_vd2_vd2_rvvm1_sleef(e)), ddadd2_vd2_vd2_vd2_rvvm1_sleef(d, e));
  y = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d));

  y = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(18.714973875)), visnan_vo_vd_rvvm1_sleef(y)), vcast_vd_d_rvvm1_sleef(1.0), y);
  y = vmulsign_vd_vd_vd_rvvm1_sleef(y, x);
  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_sinhdx_u35rvvm1(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef e = expm1k_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x));

  vdouble_rvvm1_sleef y = vdiv_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(e, vcast_vd_d_rvvm1_sleef(2)), vadd_vd_vd_vd_rvvm1_sleef(e, vcast_vd_d_rvvm1_sleef(1)));
  y = vmul_vd_vd_vd_rvvm1_sleef(y, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0.5), e));

  y = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(709)), visnan_vo_vd_rvvm1_sleef(y)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), y);
  y = vmulsign_vd_vd_vd_rvvm1_sleef(y, x);
  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_coshdx_u35rvvm1(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef e = Sleef_expdx_u10rvvm1(vabs_vd_vd_rvvm1_sleef(x));
  vdouble_rvvm1_sleef y = vmla_vd_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0.5), e, vdiv_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0.5), e));

  y = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(709)), visnan_vo_vd_rvvm1_sleef(y)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), y);
  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_tanhdx_u35rvvm1(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef d = expm1k_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(2), vabs_vd_vd_rvvm1_sleef(x)));
  vdouble_rvvm1_sleef y = vdiv_vd_vd_vd_rvvm1_sleef(d, vadd_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(2), d));

  y = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(18.714973875)), visnan_vo_vd_rvvm1_sleef(y)), vcast_vd_d_rvvm1_sleef(1.0), y);
  y = vmulsign_vd_vd_vd_rvvm1_sleef(y, x);
  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(y)));

  return y;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef logk2_rvvm1_sleef(vdouble2_rvvm1_sleef d) {
  vdouble2_rvvm1_sleef x, x2, m, s;
  vdouble_rvvm1_sleef t;
  vint_rvvm1_sleef e;

  e = vilogbk_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1.0/0.75)));

  m = vd2setxy_vd2_vd_vd_rvvm1_sleef(vldexp2_vd_vd_vi_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vneg_vi_vi_rvvm1_sleef(e)),
                         vldexp2_vd_vd_vi_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(d), vneg_vi_vi_rvvm1_sleef(e)));

  x = dddiv_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(m, vcast_vd_d_rvvm1_sleef(-1)), ddadd2_vd2_vd2_vd_rvvm1_sleef(m, vcast_vd_d_rvvm1_sleef(1)));
  x2 = ddsqu_vd2_vd2_rvvm1_sleef(x);

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x2), vd2getx_vd_vd2_rvvm1_sleef(x2)), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4);
  t = vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vcast_vd_d_rvvm1_sleef(0.13860436390467167910856)), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(x2)), (vcast_vd_d_rvvm1_sleef(0.131699838841615374240845)), (vcast_vd_d_rvvm1_sleef(0.153914168346271945653214)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(x2)), (vcast_vd_d_rvvm1_sleef(0.181816523941564611721589)), (vcast_vd_d_rvvm1_sleef(0.22222224632662035403996)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((vd2getx_vd_vd2_rvvm1_sleef(x2)), (vcast_vd_d_rvvm1_sleef(0.285714285511134091777308)), (vcast_vd_d_rvvm1_sleef(0.400000000000914013309483)))))))

                                       ;
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(x2), vcast_vd_d_rvvm1_sleef(0.666666666666664853302393));

  s = ddmul_vd2_vd2_vd_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(0.693147180559945286226764, 2.319046813846299558417771e-17), vcast_vd_vi_rvvm1_sleef(e));
  s = ddadd_vd2_vd2_vd2_rvvm1_sleef(s, ddscale_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(2)));
  s = ddadd_vd2_vd2_vd2_rvvm1_sleef(s, ddmul_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(x2, x), t));

  return s;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_asinhdx_u10rvvm1(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef y = vabs_vd_vd_rvvm1_sleef(x);
  rvv_dp_vopmask_rvvm1_sleef o = vgt_vo_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(1));
  vdouble2_rvvm1_sleef d;

  d = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, ddrec_vd2_vd_rvvm1_sleef(x), vcast_vd2_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(0)));
  d = ddsqrt_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(ddsqu_vd2_vd2_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(1)));
  d = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, ddmul_vd2_vd2_vd_rvvm1_sleef(d, y), d);

  d = logk2_rvvm1_sleef(ddnormalize_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(d, x)));
  y = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d));

  y = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(1.3407807929942596355e+154)),
                                    visnan_vo_vd_rvvm1_sleef(y)),
                       vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(__builtin_inf()), x), y);

  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(y)));
  y = vsel_vd_vo_vd_vd_rvvm1_sleef(visnegzero_vo_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(-0.0), y);

  return y;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_acoshdx_u10rvvm1(vdouble_rvvm1_sleef x) {
  vdouble2_rvvm1_sleef d = logk2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(ddsqrt_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1))), ddsqrt_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(-1)))), x));
  vdouble_rvvm1_sleef y = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d));

  y = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(1.3407807929942596355e+154)),
                                    visnan_vo_vd_rvvm1_sleef(y)),
                       vcast_vd_d_rvvm1_sleef(__builtin_inf()), y);
  y = vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1.0)), vreinterpret_vm_vd_rvvm1_sleef(y)));

  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1.0)), vreinterpret_vm_vd_rvvm1_sleef(y)));
  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_atanhdx_u10rvvm1(vdouble_rvvm1_sleef x) {
  vdouble_rvvm1_sleef y = vabs_vd_vd_rvvm1_sleef(x);
  vdouble2_rvvm1_sleef d = logk2_rvvm1_sleef(dddiv_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), y), ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), vneg_vd_vd_rvvm1_sleef(y))));
  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(1.0)), vreinterpret_vm_vd_rvvm1_sleef(vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(1.0)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), vmul_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(0.5))))));

  y = vmulsign_vd_vd_vd_rvvm1_sleef(y, x);
  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(x), visnan_vo_vd_rvvm1_sleef(y)), vreinterpret_vm_vd_rvvm1_sleef(y)));
  y = vreinterpret_vd_vm_rvvm1_sleef(vor_vm_vo64_vm_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(x), vreinterpret_vm_vd_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_cbrtdx_u35rvvm1(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef x, y, q = vcast_vd_d_rvvm1_sleef(1.0);
  vint_rvvm1_sleef e, qu, re;
  vdouble_rvvm1_sleef t;

  e = vadd_vi_vi_vi_rvvm1_sleef(vilogbk_vi_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d)), vcast_vi_i_rvvm1_sleef(1));
  d = vldexp2_vd_vd_vi_rvvm1_sleef(d, vneg_vi_vi_rvvm1_sleef(e));

  t = vadd_vd_vd_vd_rvvm1_sleef(vcast_vd_vi_rvvm1_sleef(e), vcast_vd_d_rvvm1_sleef(6144));
  qu = vtruncate_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(t, vcast_vd_d_rvvm1_sleef(1.0/3.0)));
  re = vtruncate_vi_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(t, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_vi_rvvm1_sleef(qu), vcast_vd_d_rvvm1_sleef(3))));

  q = vsel_vd_vo_vd_vd_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(re, vcast_vi_i_rvvm1_sleef(1))), vcast_vd_d_rvvm1_sleef(1.2599210498948731647672106), q);
  q = vsel_vd_vo_vd_vd_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(re, vcast_vi_i_rvvm1_sleef(2))), vcast_vd_d_rvvm1_sleef(1.5874010519681994747517056), q);
  q = vldexp2_vd_vd_vi_rvvm1_sleef(q, vsub_vi_vi_vi_rvvm1_sleef(qu, vcast_vi_i_rvvm1_sleef(2048)));

  q = vmulsign_vd_vd_vd_rvvm1_sleef(q, d);

  d = vabs_vd_vd_rvvm1_sleef(d);

  x = vcast_vd_d_rvvm1_sleef(-0.640245898480692909870982);
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, d, vcast_vd_d_rvvm1_sleef(2.96155103020039511818595));
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, d, vcast_vd_d_rvvm1_sleef(-5.73353060922947843636166));
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, d, vcast_vd_d_rvvm1_sleef(6.03990368989458747961407));
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, d, vcast_vd_d_rvvm1_sleef(-3.85841935510444988821632));
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, d, vcast_vd_d_rvvm1_sleef(2.2307275302496609725722));

  y = vmul_vd_vd_vd_rvvm1_sleef(x, x); y = vmul_vd_vd_vd_rvvm1_sleef(y, y); x = vsub_vd_vd_vd_rvvm1_sleef(x, vmul_vd_vd_vd_rvvm1_sleef(vmlapn_vd_vd_vd_vd_rvvm1_sleef(d, y, x), vcast_vd_d_rvvm1_sleef(1.0 / 3.0)));
  y = vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, x), x);
  y = vmul_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(y, vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(2.0 / 3.0), y), vmla_vd_vd_vd_vd_rvvm1_sleef(y, x, vcast_vd_d_rvvm1_sleef(-1.0)))), q);

  return y;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_cbrtdx_u10rvvm1(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef x, y, z, t;
  vdouble2_rvvm1_sleef q2 = vcast_vd2_d_d_rvvm1_sleef(1, 0), u, v;
  vint_rvvm1_sleef e, qu, re;

  e = vadd_vi_vi_vi_rvvm1_sleef(vilogbk_vi_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d)), vcast_vi_i_rvvm1_sleef(1));
  d = vldexp2_vd_vd_vi_rvvm1_sleef(d, vneg_vi_vi_rvvm1_sleef(e));

  t = vadd_vd_vd_vd_rvvm1_sleef(vcast_vd_vi_rvvm1_sleef(e), vcast_vd_d_rvvm1_sleef(6144));
  qu = vtruncate_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(t, vcast_vd_d_rvvm1_sleef(1.0/3.0)));
  re = vtruncate_vi_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(t, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_vi_rvvm1_sleef(qu), vcast_vd_d_rvvm1_sleef(3))));

  q2 = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(re, vcast_vi_i_rvvm1_sleef(1))), vcast_vd2_d_d_rvvm1_sleef(1.2599210498948731907, -2.5899333753005069177e-17), q2);
  q2 = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(vcast_vo64_vo32_rvvm1_sleef(veq_vo_vi_vi_rvvm1_sleef(re, vcast_vi_i_rvvm1_sleef(2))), vcast_vd2_d_d_rvvm1_sleef(1.5874010519681995834, -1.0869008194197822986e-16), q2);

  q2 = vd2setxy_vd2_vd_vd_rvvm1_sleef(vmulsign_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(q2), d), vmulsign_vd_vd_vd_rvvm1_sleef(vd2gety_vd_vd2_rvvm1_sleef(q2), d));
  d = vabs_vd_vd_rvvm1_sleef(d);

  x = vcast_vd_d_rvvm1_sleef(-0.640245898480692909870982);
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, d, vcast_vd_d_rvvm1_sleef(2.96155103020039511818595));
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, d, vcast_vd_d_rvvm1_sleef(-5.73353060922947843636166));
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, d, vcast_vd_d_rvvm1_sleef(6.03990368989458747961407));
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, d, vcast_vd_d_rvvm1_sleef(-3.85841935510444988821632));
  x = vmla_vd_vd_vd_vd_rvvm1_sleef(x, d, vcast_vd_d_rvvm1_sleef(2.2307275302496609725722));

  y = vmul_vd_vd_vd_rvvm1_sleef(x, x); y = vmul_vd_vd_vd_rvvm1_sleef(y, y); x = vsub_vd_vd_vd_rvvm1_sleef(x, vmul_vd_vd_vd_rvvm1_sleef(vmlapn_vd_vd_vd_vd_rvvm1_sleef(d, y, x), vcast_vd_d_rvvm1_sleef(1.0 / 3.0)));

  z = x;

  u = ddmul_vd2_vd_vd_rvvm1_sleef(x, x);
  u = ddmul_vd2_vd2_vd2_rvvm1_sleef(u, u);
  u = ddmul_vd2_vd2_vd_rvvm1_sleef(u, d);
  u = ddadd2_vd2_vd2_vd_rvvm1_sleef(u, vneg_vd_vd_rvvm1_sleef(x));
  y = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(u), vd2gety_vd_vd2_rvvm1_sleef(u));

  y = vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-2.0 / 3.0), y), z);
  v = ddadd2_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd_vd_rvvm1_sleef(z, z), y);
  v = ddmul_vd2_vd2_vd_rvvm1_sleef(v, d);
  v = ddmul_vd2_vd2_vd2_rvvm1_sleef(v, q2);
  z = vldexp2_vd_vd_vi_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(v), vd2gety_vd_vd2_rvvm1_sleef(v)), vsub_vi_vi_vi_rvvm1_sleef(qu, vcast_vi_i_rvvm1_sleef(2048)));

  z = vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(d), vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(__builtin_inf()), vd2getx_vd_vd2_rvvm1_sleef(q2)), z);
  z = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vreinterpret_vd_vm_rvvm1_sleef(vsignbit_vm_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(q2))), z);

  return z;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_exp2dx_u10rvvm1(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef u = vrint_vd_vd_rvvm1_sleef(d), s;
  vint_rvvm1_sleef q = vrint_vi_vd_rvvm1_sleef(u);

  s = vsub_vd_vd_vd_rvvm1_sleef(d, u);

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(s, s), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2), s8 = vmul_vd_vd_vd_rvvm1_sleef(s4, s4);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s8), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.4434359082926529454e-9)), (vcast_vd_d_rvvm1_sleef(+0.7073164598085707425e-8)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1017819260921760451e-6)), (vcast_vd_d_rvvm1_sleef(+0.1321543872511327615e-5)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1525273353517584730e-4)), (vcast_vd_d_rvvm1_sleef(+0.1540353045101147808e-3)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1333355814670499073e-2)), (vcast_vd_d_rvvm1_sleef(+0.9618129107597600536e-2)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.5550410866482046596e-1)), (vcast_vd_d_rvvm1_sleef(+0.2402265069591012214e+0)))))))))

                                       ;
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.6931471805599452862e+0));

  u = vfma_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(1));

  u = vldexp2_vd_vd_vi_rvvm1_sleef(u, q);

  u = vsel_vd_vo_vd_vd_rvvm1_sleef(vge_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1024)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), u);
  u = vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(-2000)), vreinterpret_vm_vd_rvvm1_sleef(u)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_exp2dx_u35rvvm1(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef u = vrint_vd_vd_rvvm1_sleef(d), s;
  vint_rvvm1_sleef q = vrint_vi_vd_rvvm1_sleef(u);

  s = vsub_vd_vd_vd_rvvm1_sleef(d, u);

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(s, s), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2), s8 = vmul_vd_vd_vd_rvvm1_sleef(s4, s4);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s8), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.4434359082926529454e-9)), (vcast_vd_d_rvvm1_sleef(+0.7073164598085707425e-8)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1017819260921760451e-6)), (vcast_vd_d_rvvm1_sleef(+0.1321543872511327615e-5)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1525273353517584730e-4)), (vcast_vd_d_rvvm1_sleef(+0.1540353045101147808e-3)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1333355814670499073e-2)), (vcast_vd_d_rvvm1_sleef(+0.9618129107597600536e-2)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.5550410866482046596e-1)), (vcast_vd_d_rvvm1_sleef(+0.2402265069591012214e+0)))))))))

                                       ;
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.6931471805599452862e+0));

  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(1));

  u = vldexp2_vd_vd_vi_rvvm1_sleef(u, q);

  u = vsel_vd_vo_vd_vd_rvvm1_sleef(vge_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1024)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), u);
  u = vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(-2000)), vreinterpret_vm_vd_rvvm1_sleef(u)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_exp10dx_u10rvvm1(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef u = vrint_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(3.3219280948873623478703194294893901758648313930))), s;
  vint_rvvm1_sleef q = vrint_vi_vd_rvvm1_sleef(u);

  s = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(-0.30102999566383914498), d);
  s = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(-1.4205023227266099418e-13), s);

  u = vcast_vd_d_rvvm1_sleef(+0.2411463498334267652e-3);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.1157488415217187375e-2));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.5013975546789733659e-2));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.1959762320720533080e-1));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.6808936399446784138e-1));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.2069958494722676234e+0));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.5393829292058536229e+0));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.1171255148908541655e+1));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.2034678592293432953e+1));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.2650949055239205876e+1));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(+0.2302585092994045901e+1));

  u = vfma_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(1));

  u = vldexp2_vd_vd_vi_rvvm1_sleef(u, q);

  u = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(308.25471555991671)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), u);
  u = vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(-350)), vreinterpret_vm_vd_rvvm1_sleef(u)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_exp10dx_u35rvvm1(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef u = vrint_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(3.3219280948873623478703194294893901758648313930))), s;
  vint_rvvm1_sleef q = vrint_vi_vd_rvvm1_sleef(u);

  s = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(-0.30102999566383914498), d);
  s = vmla_vd_vd_vd_vd_rvvm1_sleef(u, vcast_vd_d_rvvm1_sleef(-1.4205023227266099418e-13), s);

  vdouble_rvvm1_sleef s2 = vmul_vd_vd_vd_rvvm1_sleef(s, s), s4 = vmul_vd_vd_vd_rvvm1_sleef(s2, s2), s8 = vmul_vd_vd_vd_rvvm1_sleef(s4, s4);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef((s8), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vcast_vd_d_rvvm1_sleef(+0.2411463498334267652e-3)), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1157488415217187375e-2)), (vcast_vd_d_rvvm1_sleef(+0.5013975546789733659e-2)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s4), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1959762320720533080e-1)), (vcast_vd_d_rvvm1_sleef(+0.6808936399446784138e-1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.2069958494722676234e+0)), (vcast_vd_d_rvvm1_sleef(+0.5393829292058536229e+0)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s2), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.1171255148908541655e+1)), (vcast_vd_d_rvvm1_sleef(+0.2034678592293432953e+1)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((s), (vcast_vd_d_rvvm1_sleef(+0.2650949055239205876e+1)), (vcast_vd_d_rvvm1_sleef(+0.2302585092994045901e+1)))))))))

                                       ;

  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, s, vcast_vd_d_rvvm1_sleef(1));

  u = vldexp2_vd_vd_vi_rvvm1_sleef(u, q);

  u = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(308.25471555991671)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), u);
  u = vreinterpret_vd_vm_rvvm1_sleef(vandnot_vm_vo64_vm_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(-350)), vreinterpret_vm_vd_rvvm1_sleef(u)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_expm1dx_u10rvvm1(vdouble_rvvm1_sleef a) {
  vdouble2_rvvm1_sleef d = ddadd2_vd2_vd2_vd_rvvm1_sleef(expk2_rvvm1_sleef(vcast_vd2_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(0))), vcast_vd_d_rvvm1_sleef(-1.0));
  vdouble_rvvm1_sleef x = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(d), vd2gety_vd_vd2_rvvm1_sleef(d));
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(709.782712893383996732223)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), x);
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(-36.736800569677101399113302437)), vcast_vd_d_rvvm1_sleef(-1), x);
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(visnegzero_vo_vd_rvvm1_sleef(a), vcast_vd_d_rvvm1_sleef(-0.0), x);
  return x;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_log10dx_u10rvvm1(vdouble_rvvm1_sleef d) {
  vdouble2_rvvm1_sleef x;
  vdouble_rvvm1_sleef t, m, x2;

  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0x1p-1022));
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef((double)(INT64_C(1) << 32) * (double)(INT64_C(1) << 32))), d);
  vint_rvvm1_sleef e = vilogb2k_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1.0/0.75)));
  m = vldexp3_vd_vd_vi_rvvm1_sleef(d, vneg_vi_vi_rvvm1_sleef(e));
  e = vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(o), vsub_vi_vi_vi_rvvm1_sleef(e, vcast_vi_i_rvvm1_sleef(64)), e);

  x = dddiv_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-1), m), ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), m));
  x2 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(x));

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(x2, x2), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4);
  t = vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vcast_vd_d_rvvm1_sleef(+0.6653725819576758460e-1)), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.6625722782820833712e-1)), (vcast_vd_d_rvvm1_sleef(+0.7898105214313944078e-1)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.9650955035715275132e-1)), (vcast_vd_d_rvvm1_sleef(+0.1240841409721444993e+0)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.1737177927454605086e+0)), (vcast_vd_d_rvvm1_sleef(+0.2895296546021972617e+0)))))))

                                      ;

  vdouble2_rvvm1_sleef s = ddmul_vd2_vd2_vd_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(0.30102999566398119802, -2.803728127785170339e-18), vcast_vd_vi_rvvm1_sleef(e));

  s = ddadd_vd2_vd2_vd2_rvvm1_sleef(s, ddmul_vd2_vd2_vd2_rvvm1_sleef(x, vcast_vd2_d_d_rvvm1_sleef(0.86858896380650363334, 1.1430059694096389311e-17)));
  s = ddadd_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x2, vd2getx_vd_vd2_rvvm1_sleef(x)), t));

  vdouble_rvvm1_sleef r = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2gety_vd_vd2_rvvm1_sleef(s));

  r = vsel_vd_vo_vd_vd_rvvm1_sleef(vispinf_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(__builtin_inf()), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), visnan_vo_vd_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(-__builtin_inf()), r);

  return r;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_log2dx_u10rvvm1(vdouble_rvvm1_sleef d) {
  vdouble2_rvvm1_sleef x;
  vdouble_rvvm1_sleef t, m, x2;

  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0x1p-1022));
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef((double)(INT64_C(1) << 32) * (double)(INT64_C(1) << 32))), d);
  vint_rvvm1_sleef e = vilogb2k_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1.0/0.75)));
  m = vldexp3_vd_vd_vi_rvvm1_sleef(d, vneg_vi_vi_rvvm1_sleef(e));
  e = vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(o), vsub_vi_vi_vi_rvvm1_sleef(e, vcast_vi_i_rvvm1_sleef(64)), e);

  x = dddiv_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-1), m), ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), m));
  x2 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(x));

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(x2, x2), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4);
  t = vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vcast_vd_d_rvvm1_sleef(+0.2211941750456081490e+0)), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.2200768693152277689e+0)), (vcast_vd_d_rvvm1_sleef(+0.2623708057488514656e+0)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.3205977477944495502e+0)), (vcast_vd_d_rvvm1_sleef(+0.4121985945485324709e+0)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(+0.5770780162997058982e+0)), (vcast_vd_d_rvvm1_sleef(+0.96179669392608091449)))))))

                                    ;

  vdouble2_rvvm1_sleef s = ddadd2_vd2_vd_vd2_rvvm1_sleef(vcast_vd_vi_rvvm1_sleef(e),
                                 ddmul_vd2_vd2_vd2_rvvm1_sleef(x, vcast_vd2_d_d_rvvm1_sleef(2.885390081777926774, 6.0561604995516736434e-18)));

  s = ddadd2_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x2, vd2getx_vd_vd2_rvvm1_sleef(x)), t));

  vdouble_rvvm1_sleef r = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2gety_vd_vd2_rvvm1_sleef(s));

  r = vsel_vd_vo_vd_vd_rvvm1_sleef(vispinf_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(__builtin_inf()), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), visnan_vo_vd_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(-__builtin_inf()), r);

  return r;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_log2dx_u35rvvm1(vdouble_rvvm1_sleef d) {
  vdouble_rvvm1_sleef m, t, x, x2;

  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0x1p-1022));
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef((double)(INT64_C(1) << 32) * (double)(INT64_C(1) << 32))), d);
  vint_rvvm1_sleef e = vilogb2k_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1.0/0.75)));
  m = vldexp3_vd_vd_vi_rvvm1_sleef(d, vneg_vi_vi_rvvm1_sleef(e));
  e = vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(o), vsub_vi_vi_vi_rvvm1_sleef(e, vcast_vi_i_rvvm1_sleef(64)), e);

  x = vdiv_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(m, vcast_vd_d_rvvm1_sleef(1)), vadd_vd_vd_vd_rvvm1_sleef(m, vcast_vd_d_rvvm1_sleef(1)));
  x2 = vmul_vd_vd_vd_rvvm1_sleef(x, x);

  t = vcast_vd_d_rvvm1_sleef(+0.2211941750456081490e+0);
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, x2, vcast_vd_d_rvvm1_sleef(+0.2200768693152277689e+0));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, x2, vcast_vd_d_rvvm1_sleef(+0.2623708057488514656e+0));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, x2, vcast_vd_d_rvvm1_sleef(+0.3205977477944495502e+0));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, x2, vcast_vd_d_rvvm1_sleef(+0.4121985945485324709e+0));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, x2, vcast_vd_d_rvvm1_sleef(+0.5770780162997058982e+0));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, x2, vcast_vd_d_rvvm1_sleef(+0.96179669392608091449 ));

  vdouble2_rvvm1_sleef s = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_vi_rvvm1_sleef(e),
                                ddmul_vd2_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(2.885390081777926774)));

  vdouble_rvvm1_sleef r = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vmul_vd_vd_vd_rvvm1_sleef(x, x2), vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2gety_vd_vd2_rvvm1_sleef(s)));

  r = vsel_vd_vo_vd_vd_rvvm1_sleef(vispinf_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(__builtin_inf()), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), visnan_vo_vd_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(-__builtin_inf()), r);

  return r;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_log1pdx_u10rvvm1(vdouble_rvvm1_sleef d) {
  vdouble2_rvvm1_sleef x;
  vdouble_rvvm1_sleef t, m, x2;

  vdouble_rvvm1_sleef dp1 = vadd_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1));

  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(dp1, vcast_vd_d_rvvm1_sleef(0x1p-1022));
  dp1 = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(dp1, vcast_vd_d_rvvm1_sleef((double)(INT64_C(1) << 32) * (double)(INT64_C(1) << 32))), dp1);
  vint_rvvm1_sleef e = vilogb2k_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(dp1, vcast_vd_d_rvvm1_sleef(1.0/0.75)));
  t = vldexp3_vd_vd_vi_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), vneg_vi_vi_rvvm1_sleef(e));
  m = vmla_vd_vd_vd_vd_rvvm1_sleef(d, t, vsub_vd_vd_vd_rvvm1_sleef(t, vcast_vd_d_rvvm1_sleef(1)));
  e = vsel_vi_vo_vi_vi_rvvm1_sleef(vcast_vo32_vo64_rvvm1_sleef(o), vsub_vi_vi_vi_rvvm1_sleef(e, vcast_vi_i_rvvm1_sleef(64)), e);
  vdouble2_rvvm1_sleef s = ddmul_vd2_vd2_vd_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(0.693147180559945286226764, 2.319046813846299558417771e-17), vcast_vd_vi_rvvm1_sleef(e));

  x = dddiv_vd2_vd2_vd2_rvvm1_sleef(vcast_vd2_vd_vd_rvvm1_sleef(m, vcast_vd_d_rvvm1_sleef(0)), ddadd_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(2), m));
  x2 = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2getx_vd_vd2_rvvm1_sleef(x));

  vdouble_rvvm1_sleef x4 = vmul_vd_vd_vd_rvvm1_sleef(x2, x2), x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4);
  t = vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vcast_vd_d_rvvm1_sleef(0.1532076988502701353e+0)), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(0.1525629051003428716e+0)), (vcast_vd_d_rvvm1_sleef(0.1818605932937785996e+0)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(0.2222214519839380009e+0)), (vcast_vd_d_rvvm1_sleef(0.2857142932794299317e+0)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vcast_vd_d_rvvm1_sleef(0.3999999999635251990e+0)), (vcast_vd_d_rvvm1_sleef(0.6666666666667333541e+0)))))))

                                     ;

  s = ddadd_vd2_vd2_vd2_rvvm1_sleef(s, ddscale_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(2)));
  s = ddadd_vd2_vd2_vd_rvvm1_sleef(s, vmul_vd_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x2, vd2getx_vd_vd2_rvvm1_sleef(x)), t));

  vdouble_rvvm1_sleef r = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(s), vd2gety_vd_vd2_rvvm1_sleef(s));

  r = vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1e+307)), vcast_vd_d_rvvm1_sleef(__builtin_inf()), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(-1)), visnan_vo_vd_rvvm1_sleef(d)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(-1)), vcast_vd_d_rvvm1_sleef(-__builtin_inf()), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(visnegzero_vo_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(-0.0), r);

  return r;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_fabsdx_rvvm1(vdouble_rvvm1_sleef x) { return vabs_vd_vd_rvvm1_sleef(x); }

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_copysigndx_rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) { return vcopysign_vd_vd_vd_rvvm1_sleef(x, y); }

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_fmaxdx_rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {

  return vsel_vd_vo_vd_vd_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(y), x, vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(x, y), x, y));

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_fmindx_rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {

  return vsel_vd_vo_vd_vd_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(y), x, vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(y, x), x, y));

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_fdimdx_rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  vdouble_rvvm1_sleef ret = vsub_vd_vd_vd_rvvm1_sleef(x, y);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vlt_vo_vd_vd_rvvm1_sleef(ret, vcast_vd_d_rvvm1_sleef(0)), veq_vo_vd_vd_rvvm1_sleef(x, y)), vcast_vd_d_rvvm1_sleef(0), ret);
  return ret;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_truncdx_rvvm1(vdouble_rvvm1_sleef x) { return vtruncate2_vd_vd_rvvm1_sleef_rvvm1_sleef(x); }
SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_floordx_rvvm1(vdouble_rvvm1_sleef x) { return vfloor2_vd_vd_rvvm1_sleef(x); }
SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_ceildx_rvvm1(vdouble_rvvm1_sleef x) { return vceil2_vd_vd_rvvm1_sleef(x); }
SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_rounddx_rvvm1(vdouble_rvvm1_sleef x) { return vround2_vd_vd_rvvm1_sleef(x); }
SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_rintdx_rvvm1(vdouble_rvvm1_sleef x) { return vrint2_vd_vd_rvvm1_sleef(x); }

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_nextafterdx_rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0)), vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0), y), x);
  vmask_rvvm1_sleef xi2 = vreinterpret_vm_vd_rvvm1_sleef(x);
  rvv_dp_vopmask_rvvm1_sleef c = rvv_dp_vxor_vo_vo_vo(vsignbit_vo_vd_rvvm1_sleef(x), vge_vo_vd_vd_rvvm1_sleef(y, x));

  xi2 = vsel_vm_vo64_vm_vm_rvvm1_sleef(c, vneg64_vm_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(xi2, vcast_vm_i_i_rvvm1_sleef((int)(1U << 31), 0))), xi2);

  xi2 = vsel_vm_vo64_vm_vm_rvvm1_sleef(vneq_vo_vd_vd_rvvm1_sleef(x, y), vsub64_vm_vm_vm_rvvm1_sleef(xi2, vcast_vm_i_i_rvvm1_sleef(0, 1)), xi2);

  xi2 = vsel_vm_vo64_vm_vm_rvvm1_sleef(c, vneg64_vm_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(xi2, vcast_vm_i_i_rvvm1_sleef((int)(1U << 31), 0))), xi2);

  vdouble_rvvm1_sleef ret = vreinterpret_vd_vm_rvvm1_sleef(xi2);

  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vand_vo_vo_vo(veq_vo_vd_vd_rvvm1_sleef(ret, vcast_vd_d_rvvm1_sleef(0)), vneq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0))),
                         vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0), x), ret);

  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vand_vo_vo_vo(veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0)), veq_vo_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(0))), y, ret);

  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visnan_vo_vd_rvvm1_sleef(x), visnan_vo_vd_rvvm1_sleef(y)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), ret);

  return ret;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_frfrexpdx_rvvm1(vdouble_rvvm1_sleef x) {
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(0x1p-1022)), vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(UINT64_C(1) << 63)), x);

  vmask_rvvm1_sleef xm = vreinterpret_vm_vd_rvvm1_sleef(x);
  xm = vand_vm_vm_vm_rvvm1_sleef(xm, vcast_vm_i64_rvvm1_sleef(~INT64_C(0x7ff0000000000000)));
  xm = vor_vm_vm_vm_rvvm1_sleef (xm, vcast_vm_i64_rvvm1_sleef( INT64_C(0x3fe0000000000000)));

  vdouble_rvvm1_sleef ret = vreinterpret_vd_vm_rvvm1_sleef(xm);

  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(x), vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(__builtin_inf()), x), ret);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0)), x, ret);

  return ret;
}

SLEEF_INLINE SLEEF_CONST vint_rvvm1_sleef Sleef_expfrexpdx_rvvm1(vdouble_rvvm1_sleef x) {
  x = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(0x1p-1022)), vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(UINT64_C(1) << 63)), x);

  vint_rvvm1_sleef ret = vcastu_vi_vm_rvvm1_sleef(vreinterpret_vm_vd_rvvm1_sleef(x));
  ret = vsub_vi_vi_vi_rvvm1_sleef(vand_vi_vi_vi_rvvm1_sleef(vsrl_vi_vi_i_rvvm1_sleef(ret, 20), vcast_vi_i_rvvm1_sleef(0x7ff)), vcast_vi_i_rvvm1_sleef(0x3fe));

  ret = vsel_vi_vo_vi_vi_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(rvv_dp_vor_vo_vo_vo(veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(0)), visnan_vo_vd_rvvm1_sleef(x)), visinf_vo_vd_rvvm1_sleef(x)), vcast_vi_i_rvvm1_sleef(0), ret);

  return ret;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_fmadx_rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y, vdouble_rvvm1_sleef z) {

  return vfma_vd_vd_vd_vd_rvvm1_sleef(x, y, z);

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_sqrtdx_u05rvvm1(vdouble_rvvm1_sleef d) {

  vdouble_rvvm1_sleef q, w, x, y, z;

  d = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), d);

  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(8.636168555094445E-78));
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1.157920892373162E77)), d);
  q = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vcast_vd_d_rvvm1_sleef(2.9387358770557188E-39), vcast_vd_d_rvvm1_sleef(1));

  y = vreinterpret_vd_vm_rvvm1_sleef(vsub64_vm_vm_vm_rvvm1_sleef(vcast_vm_i_i_rvvm1_sleef(0x5fe6ec85, 0xe7de30da), vsrl64_vm_vm_i(vreinterpret_vm_vd_rvvm1_sleef(d), 1)));

  x = vmul_vd_vd_vd_rvvm1_sleef(d, y); w = vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0.5), y);
  y = vfmanp_vd_vd_vd_vd_rvvm1_sleef(x, w, vcast_vd_d_rvvm1_sleef(0.5));
  x = vfma_vd_vd_vd_vd_rvvm1_sleef(x, y, x); w = vfma_vd_vd_vd_vd_rvvm1_sleef(w, y, w);
  y = vfmanp_vd_vd_vd_vd_rvvm1_sleef(x, w, vcast_vd_d_rvvm1_sleef(0.5));
  x = vfma_vd_vd_vd_vd_rvvm1_sleef(x, y, x); w = vfma_vd_vd_vd_vd_rvvm1_sleef(w, y, w);
  y = vfmanp_vd_vd_vd_vd_rvvm1_sleef(x, w, vcast_vd_d_rvvm1_sleef(0.5));
  x = vfma_vd_vd_vd_vd_rvvm1_sleef(x, y, x); w = vfma_vd_vd_vd_vd_rvvm1_sleef(w, y, w);

  y = vfmanp_vd_vd_vd_vd_rvvm1_sleef(x, w, vcast_vd_d_rvvm1_sleef(1.5)); w = vadd_vd_vd_vd_rvvm1_sleef(w, w);
  w = vmul_vd_vd_vd_rvvm1_sleef(w, y);
  x = vmul_vd_vd_vd_rvvm1_sleef(w, d);
  y = vfmapn_vd_vd_vd_vd_rvvm1_sleef(w, d, x); z = vfmanp_vd_vd_vd_vd_rvvm1_sleef(w, x, vcast_vd_d_rvvm1_sleef(1));

  z = vfmanp_vd_vd_vd_vd_rvvm1_sleef(w, y, z); w = vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0.5), x);
  w = vfma_vd_vd_vd_vd_rvvm1_sleef(w, z, y);
  w = vadd_vd_vd_vd_rvvm1_sleef(w, x);

  w = vmul_vd_vd_vd_rvvm1_sleef(w, q);

  w = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)),
                                    veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(__builtin_inf()))), d, w);

  w = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), w);

  return w;

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_sqrtdx_rvvm1(vdouble_rvvm1_sleef d) {

  return Sleef_sqrtdx_u05rvvm1(d);

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_sqrtdx_u35rvvm1(vdouble_rvvm1_sleef d) { return Sleef_sqrtdx_u05rvvm1(d); }

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_hypotdx_u05rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  x = vabs_vd_vd_rvvm1_sleef(x);
  y = vabs_vd_vd_rvvm1_sleef(y);
  vdouble_rvvm1_sleef min = vmin_vd_vd_vd_rvvm1_sleef(x, y), n = min;
  vdouble_rvvm1_sleef max = vmax_vd_vd_vd_rvvm1_sleef(x, y), d = max;

  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(max, vcast_vd_d_rvvm1_sleef(0x1p-1022));
  n = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(n, vcast_vd_d_rvvm1_sleef(UINT64_C(1) << 54)), n);
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(UINT64_C(1) << 54)), d);

  vdouble2_rvvm1_sleef t = dddiv_vd2_vd2_vd2_rvvm1_sleef(vcast_vd2_vd_vd_rvvm1_sleef(n, vcast_vd_d_rvvm1_sleef(0)), vcast_vd2_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)));
  t = ddmul_vd2_vd2_vd_rvvm1_sleef(ddsqrt_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(ddsqu_vd2_vd2_rvvm1_sleef(t), vcast_vd_d_rvvm1_sleef(1))), max);
  vdouble_rvvm1_sleef ret = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(t), vd2gety_vd_vd2_rvvm1_sleef(t));
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(ret), vcast_vd_d_rvvm1_sleef(__builtin_inf()), ret);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(min, vcast_vd_d_rvvm1_sleef(0)), max, ret);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visnan_vo_vd_rvvm1_sleef(x), visnan_vo_vd_rvvm1_sleef(y)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), ret);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(__builtin_inf())), veq_vo_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(__builtin_inf()))), vcast_vd_d_rvvm1_sleef(__builtin_inf()), ret);

  return ret;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_hypotdx_u35rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  x = vabs_vd_vd_rvvm1_sleef(x);
  y = vabs_vd_vd_rvvm1_sleef(y);
  vdouble_rvvm1_sleef min = vmin_vd_vd_vd_rvvm1_sleef(x, y);
  vdouble_rvvm1_sleef max = vmax_vd_vd_vd_rvvm1_sleef(x, y);

  vdouble_rvvm1_sleef t = vdiv_vd_vd_vd_rvvm1_sleef(min, max);
  vdouble_rvvm1_sleef ret = vmul_vd_vd_vd_rvvm1_sleef(max, vsqrt_vd_vd_rvvm1_sleef(vmla_vd_vd_vd_vd_rvvm1_sleef(t, t, vcast_vd_d_rvvm1_sleef(1))));
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(min, vcast_vd_d_rvvm1_sleef(0)), max, ret);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(visnan_vo_vd_rvvm1_sleef(x), visnan_vo_vd_rvvm1_sleef(y)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), ret);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(veq_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(__builtin_inf())), veq_vo_vd_vd_rvvm1_sleef(y, vcast_vd_d_rvvm1_sleef(__builtin_inf()))), vcast_vd_d_rvvm1_sleef(__builtin_inf()), ret);

  return ret;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble_rvvm1_sleef vptrunc_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef x) {

  vdouble_rvvm1_sleef fr = vmla_vd_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-(double)(INT64_C(1) << 31)), vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1.0 / (INT64_C(1) << 31))))), x);
  fr = vsub_vd_vd_vd_rvvm1_sleef(fr, vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(fr)));
  return vsel_vd_vo_vd_vd_rvvm1_sleef(vge_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52)), x, vsub_vd_vd_vd_rvvm1_sleef(x, fr));

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_fmoddx_rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  vdouble_rvvm1_sleef n = vabs_vd_vd_rvvm1_sleef(x), d = vabs_vd_vd_rvvm1_sleef(y), s = vcast_vd_d_rvvm1_sleef(1), q;
  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0x1p-1022));
  n = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(n, vcast_vd_d_rvvm1_sleef(UINT64_C(1) << 54)), n);
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(UINT64_C(1) << 54)), d);
  s = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(s , vcast_vd_d_rvvm1_sleef(1.0 / (UINT64_C(1) << 54))), s);
  vdouble2_rvvm1_sleef r = vcast_vd2_vd_vd_rvvm1_sleef(n, vcast_vd_d_rvvm1_sleef(0));
  vdouble_rvvm1_sleef rd = vtoward0_vd_vd_rvvm1_sleef(vrec_vd_vd_rvvm1_sleef(d));

  for(int i=0;i<21;i++) {
    q = vptrunc_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vtoward0_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)), rd));

    q = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vand_vo_vo_vo(vgt_vo_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(3), d), vd2getx_vd_vd2_rvvm1_sleef(r)),
                                       vge_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r), d)),
                         vcast_vd_d_rvvm1_sleef(2), q);
    q = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vand_vo_vo_vo(vgt_vo_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(d, d), vd2getx_vd_vd2_rvvm1_sleef(r)),
                                       vge_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r), d)),
                         vcast_vd_d_rvvm1_sleef(1), q);
    r = ddnormalize_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd2_rvvm1_sleef(r, ddmul_vd2_vd_vd_rvvm1_sleef(q, vneg_vd_vd_rvvm1_sleef(d))));
    if (vtestallones_i_vo64_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r), d))) break;
  }

  vdouble_rvvm1_sleef ret = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r), s);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r), vd2gety_vd_vd2_rvvm1_sleef(r)), d), vcast_vd_d_rvvm1_sleef(0), ret);

  ret = vmulsign_vd_vd_vd_rvvm1_sleef(ret, x);

  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(n, d), x, ret);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), ret);

  return ret;
}

static SLEEF_ALWAYS_INLINE vdouble_rvvm1_sleef vrintk2_vd_vd_rvvm1_sleef(vdouble_rvvm1_sleef d) {

  vdouble_rvvm1_sleef c = vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52), d);
  return vsel_vd_vo_vd_vd_rvvm1_sleef(vgt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(d), vcast_vd_d_rvvm1_sleef(INT64_C(1) << 52)),
                          d, vorsign_vd_vd_vd_rvvm1_sleef(vsub_vd_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(d, c), c), d));

}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_remainderdx_rvvm1(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef y) {
  vdouble_rvvm1_sleef n = vabs_vd_vd_rvvm1_sleef(x), d = vabs_vd_vd_rvvm1_sleef(y), s = vcast_vd_d_rvvm1_sleef(1), q;
  rvv_dp_vopmask_rvvm1_sleef o = vlt_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0x1p-1022*2));
  n = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(n, vcast_vd_d_rvvm1_sleef(UINT64_C(1) << 54)), n);
  d = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(UINT64_C(1) << 54)), d);
  s = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmul_vd_vd_vd_rvvm1_sleef(s , vcast_vd_d_rvvm1_sleef(1.0 / (UINT64_C(1) << 54))), s);
  vdouble_rvvm1_sleef rd = vrec_vd_vd_rvvm1_sleef(d);
  vdouble2_rvvm1_sleef r = vcast_vd2_vd_vd_rvvm1_sleef(n, vcast_vd_d_rvvm1_sleef(0));
  rvv_dp_vopmask_rvvm1_sleef qisodd = vneq_vo_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0), vcast_vd_d_rvvm1_sleef(0));

  for(int i=0;i<21;i++) {
    q = vrintk2_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r), rd));

    q = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)), vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(1.5))), vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1.0), vd2getx_vd_vd2_rvvm1_sleef(r)), q);
    q = vsel_vd_vo_vd_vd_rvvm1_sleef(rvv_dp_vor_vo_vo_vo(vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)), vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.5))),
                                      rvv_dp_vandnot_vo_vo_vo(qisodd, veq_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r)), vmul_vd_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0.5))))),
                         vcast_vd_d_rvvm1_sleef(0.0), q);
    if (vtestallones_i_vo64_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(q, vcast_vd_d_rvvm1_sleef(0)))) break;
    q = vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(q, vneg_vd_vd_rvvm1_sleef(d))), vadd_vd_vd_vd_rvvm1_sleef(q, vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(-1), vd2getx_vd_vd2_rvvm1_sleef(r))), q);
    qisodd = rvv_dp_vxor_vo_vo_vo(qisodd, visodd_vo_vd_rvvm1_sleef(q));
    r = ddnormalize_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd2_rvvm1_sleef(r, ddmul_vd2_vd_vd_rvvm1_sleef(q, vneg_vd_vd_rvvm1_sleef(d))));
  }

  vdouble_rvvm1_sleef ret = vmul_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(r), s);
  ret = vmulsign_vd_vd_vd_rvvm1_sleef(ret, x);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(y), vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), x), ret);
  ret = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(d, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), ret);
  return ret;
}

static SLEEF_CONST dd2_rvvm1_sleef gammak_rvvm1_sleef(vdouble_rvvm1_sleef a) {
  vdouble2_rvvm1_sleef clc = vcast_vd2_d_d_rvvm1_sleef(0, 0), clln = vcast_vd2_d_d_rvvm1_sleef(1, 0), clld = vcast_vd2_d_d_rvvm1_sleef(1, 0);
  vdouble2_rvvm1_sleef x, y, z;
  vdouble_rvvm1_sleef t, u;

  rvv_dp_vopmask_rvvm1_sleef otiny = vlt_vo_vd_vd_rvvm1_sleef(vabs_vd_vd_rvvm1_sleef(a), vcast_vd_d_rvvm1_sleef(1e-306)), oref = vlt_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(0.5));

  x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(otiny, vcast_vd2_d_d_rvvm1_sleef(0, 0),
                          vsel_vd2_vo_vd2_vd2_rvvm1_sleef(oref, ddadd2_vd2_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), vneg_vd_vd_rvvm1_sleef(a)),
                                              vcast_vd2_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(0))));

  rvv_dp_vopmask_rvvm1_sleef o0 = rvv_dp_vand_vo_vo_vo(vle_vo_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(0.5), vd2getx_vd_vd2_rvvm1_sleef(x)), vle_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(1.1)));
  rvv_dp_vopmask_rvvm1_sleef o2 = vle_vo_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(2.3), vd2getx_vd_vd2_rvvm1_sleef(x));

  y = ddnormalize_vd2_vd2_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1)), x));
  y = ddnormalize_vd2_vd2_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(2)), y));
  y = ddnormalize_vd2_vd2_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(3)), y));
  y = ddnormalize_vd2_vd2_rvvm1_sleef(ddmul_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(4)), y));

  rvv_dp_vopmask_rvvm1_sleef o = rvv_dp_vand_vo_vo_vo(o2, vle_vo_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vcast_vd_d_rvvm1_sleef(7)));
  clln = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, y, clln);

  x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o, ddadd2_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(5)), x);

  t = vsel_vd_vo_vd_vd_rvvm1_sleef(o2, vrec_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x)), vd2getx_vd_vd2_rvvm1_sleef(ddnormalize_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(x, vsel_vd_vo_d_d_rvvm1_sleef(o0, -1, -2)))));

  u = vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -156.801412704022726379848862, +0.2947916772827614196e+2, +0.7074816000864609279e-7);
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +1.120804464289911606838558160000, +0.1281459691827820109e+3, +0.4009244333008730443e-6));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +13.39798545514258921833306020000, +0.2617544025784515043e+3, +0.1040114641628246946e-5));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -0.116546276599463200848033357000, +0.3287022855685790432e+3, +0.1508349150733329167e-5));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -1.391801093265337481495562410000, +0.2818145867730348186e+3, +0.1288143074933901020e-5));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +0.015056113040026424412918973400, +0.1728670414673559605e+3, +0.4744167749884993937e-6));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +0.179540117061234856098844714000, +0.7748735764030416817e+2, -0.6554816306542489902e-7));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -0.002481743600264997730942489280, +0.2512856643080930752e+2, -0.3189252471452599844e-6));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -0.029527880945699120504851034100, +0.5766792106140076868e+1, +0.1358883821470355377e-6));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +0.000540164767892604515196325186, +0.7270275473996180571e+0, -0.4343931277157336040e-6));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +0.006403362833808069794787256200, +0.8396709124579147809e-1, +0.9724785897406779555e-6));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -0.000162516262783915816896611252, -0.8211558669746804595e-1, -0.2036886057225966011e-5));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -0.001914438498565477526465972390, +0.6828831828341884458e-1, +0.4373363141819725815e-5));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +7.20489541602001055898311517e-05, -0.7712481339961671511e-1, -0.9439951268304008677e-5));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +0.000839498720672087279971000786, +0.8337492023017314957e-1, +0.2050727030376389804e-4));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -5.17179090826059219329394422e-05, -0.9094964931456242518e-1, -0.4492620183431184018e-4));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -0.000592166437353693882857342347, +0.1000996313575929358e+0, +0.9945751236071875931e-4));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +6.97281375836585777403743539e-05, -0.1113342861544207724e+0, -0.2231547599034983196e-3));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +0.000784039221720066627493314301, +0.1255096673213020875e+0, +0.5096695247101967622e-3));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -0.000229472093621399176949318732, -0.1440498967843054368e+0, -0.1192753911667886971e-2));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, -0.002681327160493827160473958490, +0.1695571770041949811e+0, +0.2890510330742210310e-2));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +0.003472222222222222222175164840, -0.2073855510284092762e+0, -0.7385551028674461858e-2));
  u = vmla_vd_vd_vd_vd_rvvm1_sleef(u, t, vsel_vd_vo_vo_d_d_d_rvvm1_sleef(o2, o0, +0.083333333333333333335592087900, +0.2705808084277815939e+0, +0.2058080842778455335e-1));

  y = ddmul_vd2_vd2_vd2_rvvm1_sleef(ddadd2_vd2_vd2_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(-0.5)), logk2_rvvm1_sleef(x));
  y = ddadd2_vd2_vd2_vd2_rvvm1_sleef(y, ddneg_vd2_vd2_rvvm1_sleef(x));
  y = ddadd2_vd2_vd2_vd2_rvvm1_sleef(y, vcast_vd2_d_d_rvvm1_sleef(0.91893853320467278056, -3.8782941580672414498e-17));

  z = ddadd2_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd_vd_rvvm1_sleef (u, t), vsel_vd_vo_d_d_rvvm1_sleef(o0, -0.4006856343865314862e+0, -0.6735230105319810201e-1));
  z = ddadd2_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd2_vd_rvvm1_sleef(z, t), vsel_vd_vo_d_d_rvvm1_sleef(o0, +0.8224670334241132030e+0, +0.3224670334241132030e+0));
  z = ddadd2_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd2_vd_rvvm1_sleef(z, t), vsel_vd_vo_d_d_rvvm1_sleef(o0, -0.5772156649015328655e+0, +0.4227843350984671345e+0));
  z = ddmul_vd2_vd2_vd_rvvm1_sleef(z, t);

  clc = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o2, y, z);

  clld = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o2, ddadd2_vd2_vd2_vd_rvvm1_sleef(ddmul_vd2_vd_vd_rvvm1_sleef(u, t), vcast_vd_d_rvvm1_sleef(1)), clld);

  y = clln;

  clc = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(otiny, vcast_vd2_d_d_rvvm1_sleef(83.1776616671934334590333, 3.67103459631568507221878e-15),
                            vsel_vd2_vo_vd2_vd2_rvvm1_sleef(oref, ddadd2_vd2_vd2_vd2_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(1.1447298858494001639, 1.026595116270782638e-17), ddneg_vd2_vd2_rvvm1_sleef(clc)), clc));
  clln = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(otiny, vcast_vd2_d_d_rvvm1_sleef(1, 0), vsel_vd2_vo_vd2_vd2_rvvm1_sleef(oref, clln, clld));

  if (!vtestallones_i_vo64_rvvm1_sleef(vnot_vo64_vo64_rvvm1_sleef(oref))) {
    t = vsub_vd_vd_vd_rvvm1_sleef(a, vmul_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(INT64_C(1) << 28), vcast_vd_vi_rvvm1_sleef(vtruncate_vi_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(1.0 / (INT64_C(1) << 28)))))));
    x = ddmul_vd2_vd2_vd2_rvvm1_sleef(clld, sinpik_rvvm1_sleef(t));
  }

  clld = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(otiny, vcast_vd2_vd_vd_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef((INT64_C(1) << 60)*(double)(INT64_C(1) << 60))), vcast_vd_d_rvvm1_sleef(0)),
                             vsel_vd2_vo_vd2_vd2_rvvm1_sleef(oref, x, y));

  return dd2setab_dd2_vd2_vd2_rvvm1_sleef(clc, dddiv_vd2_vd2_vd2_rvvm1_sleef(clln, clld));
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_tgammadx_u10rvvm1(vdouble_rvvm1_sleef a) {
  dd2_rvvm1_sleef d = gammak_rvvm1_sleef(a);
  vdouble2_rvvm1_sleef y = ddmul_vd2_vd2_vd2_rvvm1_sleef(expk2_rvvm1_sleef(dd2geta_vd2_dd2_rvvm1_sleef(d)), dd2getb_vd2_dd2_rvvm1_sleef(d));
  vdouble_rvvm1_sleef r = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(y), vd2gety_vd_vd2_rvvm1_sleef(y));
  rvv_dp_vopmask_rvvm1_sleef o;

  o = rvv_dp_vor_vo_vo_vo(rvv_dp_vor_vo_vo_vo(veq_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(-__builtin_inf())),
                                rvv_dp_vand_vo_vo_vo(vlt_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(0)), visint_vo_vd_rvvm1_sleef(a))),
                   rvv_dp_vand_vo_vo_vo(rvv_dp_vand_vo_vo_vo(visnumber_vo_vd_rvvm1_sleef(a), vlt_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(0))), visnan_vo_vd_rvvm1_sleef(r)));
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vcast_vd_d_rvvm1_sleef(__builtin_nan("")), r);

  o = rvv_dp_vand_vo_vo_vo(rvv_dp_vand_vo_vo_vo(rvv_dp_vor_vo_vo_vo(veq_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(__builtin_inf())), visnumber_vo_vd_rvvm1_sleef(a)),
                                  vge_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(-0x1p-1022))),
                    rvv_dp_vor_vo_vo_vo(rvv_dp_vor_vo_vo_vo(veq_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(0)), vgt_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(200))), visnan_vo_vd_rvvm1_sleef(r)));
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vmulsign_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(__builtin_inf()), a), r);

  return r;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_lgammadx_u10rvvm1(vdouble_rvvm1_sleef a) {
  dd2_rvvm1_sleef d = gammak_rvvm1_sleef(a);
  vdouble2_rvvm1_sleef y = ddadd2_vd2_vd2_vd2_rvvm1_sleef(dd2geta_vd2_dd2_rvvm1_sleef(d), logk2_rvvm1_sleef(ddabs_vd2_vd2_rvvm1_sleef(dd2getb_vd2_dd2_rvvm1_sleef(d))));
  vdouble_rvvm1_sleef r = vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(y), vd2gety_vd_vd2_rvvm1_sleef(y));
  rvv_dp_vopmask_rvvm1_sleef o;

  o = rvv_dp_vor_vo_vo_vo(visinf_vo_vd_rvvm1_sleef(a),
                   rvv_dp_vor_vo_vo_vo(rvv_dp_vand_vo_vo_vo(vle_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(0)), visint_vo_vd_rvvm1_sleef(a)),
                                rvv_dp_vand_vo_vo_vo(visnumber_vo_vd_rvvm1_sleef(a), visnan_vo_vd_rvvm1_sleef(r))));
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(o, vcast_vd_d_rvvm1_sleef(__builtin_inf()), r);

  return r;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef ddmla_vd2_vd_vd2_vd2_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble2_rvvm1_sleef y, vdouble2_rvvm1_sleef z) {
  return ddadd_vd2_vd2_vd2_rvvm1_sleef(z, ddmul_vd2_vd2_vd_rvvm1_sleef(y, x));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef poly2dd_b_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble2_rvvm1_sleef c1, vdouble2_rvvm1_sleef c0) { return ddmla_vd2_vd_vd2_vd2_rvvm1_sleef(x, c1, c0); }
static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef poly2dd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef c1, vdouble2_rvvm1_sleef c0) { return ddmla_vd2_vd_vd2_vd2_rvvm1_sleef(x, vcast_vd2_vd_vd_rvvm1_sleef(c1, vcast_vd_d_rvvm1_sleef(0)), c0); }
static SLEEF_ALWAYS_INLINE SLEEF_CONST vdouble2_rvvm1_sleef poly4dd_rvvm1_sleef(vdouble_rvvm1_sleef x, vdouble_rvvm1_sleef c3, vdouble2_rvvm1_sleef c2, vdouble2_rvvm1_sleef c1, vdouble2_rvvm1_sleef c0) {
  return ddmla_vd2_vd_vd2_vd2_rvvm1_sleef(vmul_vd_vd_vd_rvvm1_sleef(x, x), poly2dd_rvvm1_sleef(x, c3, c2), poly2dd_b_rvvm1_sleef(x, c1, c0));
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_erfdx_u10rvvm1(vdouble_rvvm1_sleef a) {
  vdouble_rvvm1_sleef t, x = vabs_vd_vd_rvvm1_sleef(a);
  vdouble2_rvvm1_sleef t2;
  vdouble_rvvm1_sleef x2 = vmul_vd_vd_vd_rvvm1_sleef(x, x), x4 = vmul_vd_vd_vd_rvvm1_sleef(x2, x2);
  vdouble_rvvm1_sleef x8 = vmul_vd_vd_vd_rvvm1_sleef(x4, x4), x16 = vmul_vd_vd_vd_rvvm1_sleef(x8, x8);
  rvv_dp_vopmask_rvvm1_sleef o25 = vle_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(2.5));

  if (__builtin_expect(!!(vtestallones_i_vo64_rvvm1_sleef(o25)), 1)) {

    t = vmla_vd_vd_vd_vd_rvvm1_sleef((x16), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vcast_vd_d_rvvm1_sleef(-0.2083271002525222097e-14)), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), (vcast_vd_d_rvvm1_sleef(+0.7151909970790897009e-13)), (vcast_vd_d_rvvm1_sleef(-0.1162238220110999364e-11)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), (vcast_vd_d_rvvm1_sleef(+0.1186474230821585259e-10)), (vcast_vd_d_rvvm1_sleef(-0.8499973178354613440e-10)))))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), (vcast_vd_d_rvvm1_sleef(+0.4507647462598841629e-9)), (vcast_vd_d_rvvm1_sleef(-0.1808044474288848915e-8)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), (vcast_vd_d_rvvm1_sleef(+0.5435081826716212389e-8)), (vcast_vd_d_rvvm1_sleef(-0.1143939895758628484e-7)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), (vcast_vd_d_rvvm1_sleef(+0.1215442362680889243e-7)), (vcast_vd_d_rvvm1_sleef(+0.1669878756181250355e-7)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), (vcast_vd_d_rvvm1_sleef(-0.9808074602255194288e-7)), (vcast_vd_d_rvvm1_sleef(+0.1389000557865837204e-6)))))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), (vcast_vd_d_rvvm1_sleef(+0.2945514529987331866e-6)), (vcast_vd_d_rvvm1_sleef(-0.1842918273003998283e-5)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), (vcast_vd_d_rvvm1_sleef(+0.3417987836115362136e-5)), (vcast_vd_d_rvvm1_sleef(+0.3860236356493129101e-5)))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), (vcast_vd_d_rvvm1_sleef(-0.3309403072749947546e-4)), (vcast_vd_d_rvvm1_sleef(+0.1060862922597579532e-3)))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), (vcast_vd_d_rvvm1_sleef(+0.2323253155213076174e-3)), (vcast_vd_d_rvvm1_sleef(+0.1490149719145544729e-3)))))))))))

                                         ;
    t2 = poly4dd_rvvm1_sleef(x, t,
                 vcast_vd2_d_d_rvvm1_sleef(0.0092877958392275604405, 7.9287559463961107493e-19),
                 vcast_vd2_d_d_rvvm1_sleef(0.042275531758784692937, 1.3785226620501016138e-19),
                 vcast_vd2_d_d_rvvm1_sleef(0.07052369794346953491, 9.5846628070792092842e-19));
    t2 = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), ddmul_vd2_vd2_vd_rvvm1_sleef(t2, x));
    t2 = ddsqu_vd2_vd2_rvvm1_sleef(t2);
    t2 = ddsqu_vd2_vd2_rvvm1_sleef(t2);
    t2 = ddsqu_vd2_vd2_rvvm1_sleef(t2);
    t2 = ddsqu_vd2_vd2_rvvm1_sleef(t2);
    t2 = ddrec_vd2_vd2_rvvm1_sleef(t2);
  } else {

    t = vmla_vd_vd_vd_vd_rvvm1_sleef((x16), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, -0.2083271002525222097e-14, -0.4024015130752621932e-18))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.7151909970790897009e-13, +0.3847193332817048172e-16))), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, -0.1162238220110999364e-11, -0.1749316241455644088e-14))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.1186474230821585259e-10, +0.5029618322872872715e-13))), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, -0.8499973178354613440e-10, -0.1025221466851463164e-11))))))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x8), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.4507647462598841629e-9, +0.1573695559331945583e-10))), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, -0.1808044474288848915e-8, -0.1884658558040203709e-9))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.5435081826716212389e-8, +0.1798167853032159309e-8))), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, -0.1143939895758628484e-7, -0.1380745342355033142e-7))))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.1215442362680889243e-7, +0.8525705726469103499e-7))), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.1669878756181250355e-7, -0.4160448058101303405e-6))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, -0.9808074602255194288e-7, +0.1517272660008588485e-5))), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.1389000557865837204e-6, -0.3341634127317201697e-5))))))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x4), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.2945514529987331866e-6, -0.2515023395879724513e-5))), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, -0.1842918273003998283e-5, +0.6539731269664907554e-4))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.3417987836115362136e-5, -0.3551065097428388658e-3))), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.3860236356493129101e-5, +0.1210736097958368864e-2))))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x2), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, -0.3309403072749947546e-4, -0.2605566912579998680e-2))), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.1060862922597579532e-3, +0.1252823202436093193e-2))))), (vmla_vd_vd_vd_vd_rvvm1_sleef((x), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.2323253155213076174e-3, +0.1820191395263313222e-1))), ((vsel_vd_vo_d_d_rvvm1_sleef(o25, +0.1490149719145544729e-3, -0.1021557155453465954e+0))))))))))))

                                                                                         ;
    t2 = poly4dd_rvvm1_sleef(x, t,
                 vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o25, vcast_vd2_d_d_rvvm1_sleef(0.0092877958392275604405, 7.9287559463961107493e-19),
                                     vcast_vd2_d_d_rvvm1_sleef(-0.63691044383641748361, -2.4249477526539431839e-17)),
                 vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o25, vcast_vd2_d_d_rvvm1_sleef(0.042275531758784692937, 1.3785226620501016138e-19),
                                     vcast_vd2_d_d_rvvm1_sleef(-1.1282926061803961737, -6.2970338860410996505e-17)),
                 vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o25, vcast_vd2_d_d_rvvm1_sleef(0.07052369794346953491, 9.5846628070792092842e-19),
                                     vcast_vd2_d_d_rvvm1_sleef(-1.2261313785184804967e-05, -5.5329707514490107044e-22)));
    vdouble2_rvvm1_sleef s2 = ddadd_vd2_vd_vd2_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(1), ddmul_vd2_vd2_vd_rvvm1_sleef(t2, x));
    s2 = ddsqu_vd2_vd2_rvvm1_sleef(s2);
    s2 = ddsqu_vd2_vd2_rvvm1_sleef(s2);
    s2 = ddsqu_vd2_vd2_rvvm1_sleef(s2);
    s2 = ddsqu_vd2_vd2_rvvm1_sleef(s2);
    s2 = ddrec_vd2_vd2_rvvm1_sleef(s2);
    t2 = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o25, s2, vcast_vd2_vd_vd_rvvm1_sleef(expk_rvvm1_sleef(t2), vcast_vd_d_rvvm1_sleef(0)));
  }

  t2 = ddadd2_vd2_vd2_vd_rvvm1_sleef(t2, vcast_vd_d_rvvm1_sleef(-1));

  vdouble_rvvm1_sleef z = vneg_vd_vd_rvvm1_sleef(vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(t2), vd2gety_vd_vd2_rvvm1_sleef(t2)));
  z = vsel_vd_vo_vd_vd_rvvm1_sleef(vlt_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1e-8)), vmul_vd_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(1.12837916709551262756245475959)), z);
  z = vsel_vd_vo_vd_vd_rvvm1_sleef(vge_vo_vd_vd_rvvm1_sleef(x, vcast_vd_d_rvvm1_sleef(6)), vcast_vd_d_rvvm1_sleef(1), z);
  z = vsel_vd_vo_vd_vd_rvvm1_sleef(visinf_vo_vd_rvvm1_sleef(a), vcast_vd_d_rvvm1_sleef(1), z);
  z = vsel_vd_vo_vd_vd_rvvm1_sleef(veq_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(0)), vcast_vd_d_rvvm1_sleef(0), z);
  z = vmulsign_vd_vd_vd_rvvm1_sleef(z, a);

  return z;
}

SLEEF_INLINE SLEEF_CONST vdouble_rvvm1_sleef Sleef_erfcdx_u15rvvm1(vdouble_rvvm1_sleef a) {
  vdouble_rvvm1_sleef s = a, r = vcast_vd_d_rvvm1_sleef(0), t;
  vdouble2_rvvm1_sleef u, d, x;
  a = vabs_vd_vd_rvvm1_sleef(a);
  rvv_dp_vopmask_rvvm1_sleef o0 = vlt_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(1.0));
  rvv_dp_vopmask_rvvm1_sleef o1 = vlt_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(2.2));
  rvv_dp_vopmask_rvvm1_sleef o2 = vlt_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(4.2));
  rvv_dp_vopmask_rvvm1_sleef o3 = vlt_vo_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(27.3));

  u = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o0, ddmul_vd2_vd_vd_rvvm1_sleef(a, a), vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o1, vcast_vd2_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(0)), dddiv_vd2_vd2_vd2_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(1, 0), vcast_vd2_vd_vd_rvvm1_sleef(a, vcast_vd_d_rvvm1_sleef(0)))));

  t = vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, +0.6801072401395386139e-20, +0.3438010341362585303e-12, -0.5757819536420710449e+2, +0.2334249729638701319e+5);
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.2161766247570055669e-18, -0.1237021188160598264e-10, +0.4669289654498104483e+3, -0.4695661044933107769e+5));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, +0.4695919173301595670e-17, +0.2117985839877627852e-09, -0.1796329879461355858e+4, +0.3173403108748643353e+5));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.9049140419888007122e-16, -0.2290560929177369506e-08, +0.4355892193699575728e+4, +0.3242982786959573787e+4));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, +0.1634018903557410728e-14, +0.1748931621698149538e-07, -0.7456258884965764992e+4, -0.2014717999760347811e+5));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.2783485786333451745e-13, -0.9956602606623249195e-07, +0.9553977358167021521e+4, +0.1554006970967118286e+5));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, +0.4463221276786415752e-12, +0.4330010240640327080e-06, -0.9470019905444229153e+4, -0.6150874190563554293e+4));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.6711366622850136563e-11, -0.1435050600991763331e-05, +0.7387344321849855078e+4, +0.1240047765634815732e+4));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, +0.9422759050232662223e-10, +0.3460139479650695662e-05, -0.4557713054166382790e+4, -0.8210325475752699731e+2));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.1229055530100229098e-08, -0.4988908180632898173e-05, +0.2207866967354055305e+4, +0.3242443880839930870e+2));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, +0.1480719281585086512e-07, -0.1308775976326352012e-05, -0.8217975658621754746e+3, -0.2923418863833160586e+2));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.1636584469123399803e-06, +0.2825086540850310103e-04, +0.2268659483507917400e+3, +0.3457461732814383071e+0));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, +0.1646211436588923575e-05, -0.6393913713069986071e-04, -0.4633361260318560682e+2, +0.5489730155952392998e+1));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.1492565035840623511e-04, -0.2566436514695078926e-04, +0.9557380123733945965e+1, +0.1559934132251294134e-2));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, +0.1205533298178967851e-03, +0.5895792375659440364e-03, -0.2958429331939661289e+1, -0.1541741566831520638e+1));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.8548327023450850081e-03, -0.1695715579163588598e-02, +0.1670329508092765480e+0, +0.2823152230558364186e-5));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, +0.5223977625442187932e-02, +0.2089116434918055149e-03, +0.6096615680115419211e+0, +0.6249999184195342838e+0));
  t = vmla_vd_vd_vd_vd_rvvm1_sleef(t, vd2getx_vd_vd2_rvvm1_sleef(u), vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.2686617064513125222e-01, +0.1912855949584917753e-01, +0.1059212443193543585e-2, +0.1741749416408701288e-8));

  d = ddmul_vd2_vd2_vd_rvvm1_sleef(u, t);
  d = ddadd2_vd2_vd2_vd2_rvvm1_sleef(d, vcast_vd2_vd_vd_rvvm1_sleef(vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, 0.11283791670955126141, -0.10277263343147646779, -0.50005180473999022439, -0.5000000000258444377),
                                            vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -4.0175691625932118483e-18, -6.2338714083404900225e-18, 2.6362140569041995803e-17, -4.0074044712386992281e-17)));
  d = ddmul_vd2_vd2_vd2_rvvm1_sleef(d, u);
  d = ddadd2_vd2_vd2_vd2_rvvm1_sleef(d, vcast_vd2_vd_vd_rvvm1_sleef(vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.37612638903183753802, -0.63661976742916359662, 1.601106273924963368e-06, 2.3761973137523364792e-13),
                                            vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, 1.3391897206042552387e-17, 7.6321019159085724662e-18, 1.1974001857764476775e-23, -1.1670076950531026582e-29)));
  d = ddmul_vd2_vd2_vd2_rvvm1_sleef(d, u);
  d = ddadd2_vd2_vd2_vd2_rvvm1_sleef(d, vcast_vd2_vd_vd_rvvm1_sleef(vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, 1.1283791670955125586, -1.1283791674717296161, -0.57236496645145429341, -0.57236494292470108114),
                                            vsel_vd_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, 1.5335459613165822674e-17, 8.0896847755965377194e-17, 3.0704553245872027258e-17, -2.3984352208056898003e-17)));

  x = ddmul_vd2_vd2_vd_rvvm1_sleef(vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o1, d, vcast_vd2_vd_vd_rvvm1_sleef(vneg_vd_vd_rvvm1_sleef(a), vcast_vd_d_rvvm1_sleef(0))), a);
  x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o1, x, ddadd2_vd2_vd2_vd2_rvvm1_sleef(x, d));
  x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o0, ddsub_vd2_vd2_vd2_rvvm1_sleef(vcast_vd2_d_d_rvvm1_sleef(1, 0), x), expk2_rvvm1_sleef(x));
  x = vsel_vd2_vo_vd2_vd2_rvvm1_sleef(o1, x, ddmul_vd2_vd2_vd2_rvvm1_sleef(x, u));

  r = vsel_vd_vo_vd_vd_rvvm1_sleef(o3, vadd_vd_vd_vd_rvvm1_sleef(vd2getx_vd_vd2_rvvm1_sleef(x), vd2gety_vd_vd2_rvvm1_sleef(x)), vcast_vd_d_rvvm1_sleef(0));
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(vsignbit_vo_vd_rvvm1_sleef(s), vsub_vd_vd_vd_rvvm1_sleef(vcast_vd_d_rvvm1_sleef(2), r), r);
  r = vsel_vd_vo_vd_vd_rvvm1_sleef(visnan_vo_vd_rvvm1_sleef(s), vcast_vd_d_rvvm1_sleef(__builtin_nan("")), r);
  return r;
}

#if !defined(__NVCC__) && ((defined(__SIZEOF_FLOAT128__) && __SIZEOF_FLOAT128__ == 16) || (defined(__linux__) && defined(__GNUC__) && (defined(__i386__) || defined(__x86_64__))) || (defined(__PPC64__) && defined(__GNUC__) && !defined(__clang__) && __GNUC__ >= 8))
#define SLEEF_FLOAT128_IS_IEEEQP
#endif

#if !defined(SLEEF_FLOAT128_IS_IEEEQP) && !defined(__NVCC__) && defined(__SIZEOF_LONG_DOUBLE__) && __SIZEOF_LONG_DOUBLE__ == 16 && (defined(__aarch64__) || defined(__zarch__))
#define SLEEF_LONGDOUBLE_IS_IEEEQP
#endif

#if !defined(Sleef_quad_DEFINED)
#define Sleef_quad_DEFINED
typedef struct { uint64_t x, y; } Sleef_uint64_2t;
#if defined(SLEEF_FLOAT128_IS_IEEEQP)
typedef __float128 Sleef_quad;
#define SLEEF_QUAD_C(x) (x ## Q)
#elif defined(SLEEF_LONGDOUBLE_IS_IEEEQP)
typedef long double Sleef_quad;
#define SLEEF_QUAD_C(x) (x ## L)
#else
typedef Sleef_uint64_2t Sleef_quad;
#endif
#endif

extern const float Sleef_rempitabsp[];

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vupper_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  return vreinterpret_vf_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(vreinterpret_vi2_vf_rvvm1_sleef(d), vcast_vi2_i_rvvm1_sleef(0xfffff000)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef vcast_vf2_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef h, vfloat_rvvm1_sleef l) {
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(h, l);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef vcast_vf2_f_f_rvvm1_sleef(float h, float l) {
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(h), vcast_vf_f_rvvm1_sleef(l));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef vcast_vf2_d_rvvm1_sleef(double d) {
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(d - (float)d));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef vsel_vf2_vo_vf2_vf2_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef m, vfloat2_rvvm1_sleef x, vfloat2_rvvm1_sleef y) {
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(vsel_vf_vo_vf_vf_rvvm1_sleef(m, vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y)), vsel_vf_vo_vf_vf_rvvm1_sleef(m, vf2gety_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(y)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef vsel_vf2_vo_f_f_f_f_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef o, float x1, float y1, float x0, float y0) {
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(vsel_vf_vo_f_f_rvvm1_sleef(o, x1, x0), vsel_vf_vo_f_f_rvvm1_sleef(o, y1, y0));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef vsel_vf2_vo_vo_d_d_d_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef o0, rvv_sp_vopmask_rvvm1_sleef o1, double d0, double d1, double d2) {
  return vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o0, vcast_vf2_d_rvvm1_sleef(d0), vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o1, vcast_vf2_d_rvvm1_sleef(d1), vcast_vf2_d_rvvm1_sleef(d2)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef vsel_vf2_vo_vo_vo_d_d_d_d_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef o0, rvv_sp_vopmask_rvvm1_sleef o1, rvv_sp_vopmask_rvvm1_sleef o2, double d0, double d1, double d2, double d3) {
  return vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o0, vcast_vf2_d_rvvm1_sleef(d0), vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o1, vcast_vf2_d_rvvm1_sleef(d1), vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o2, vcast_vf2_d_rvvm1_sleef(d2), vcast_vf2_d_rvvm1_sleef(d3))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef vabs_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef x) {
  return vcast_vf2_vf_vf_rvvm1_sleef(vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0)), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x))), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x)))),
                         vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0)), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x))), vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(x)))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vadd_vf_3vf_rvvm1_sleef(vfloat_rvvm1_sleef v0, vfloat_rvvm1_sleef v1, vfloat_rvvm1_sleef v2) {
  return vadd_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(v0, v1), v2);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vadd_vf_4vf_rvvm1_sleef(vfloat_rvvm1_sleef v0, vfloat_rvvm1_sleef v1, vfloat_rvvm1_sleef v2, vfloat_rvvm1_sleef v3) {
  return vadd_vf_3vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(v0, v1), v2, v3);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vadd_vf_5vf_rvvm1_sleef(vfloat_rvvm1_sleef v0, vfloat_rvvm1_sleef v1, vfloat_rvvm1_sleef v2, vfloat_rvvm1_sleef v3, vfloat_rvvm1_sleef v4) {
  return vadd_vf_4vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(v0, v1), v2, v3, v4);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vadd_vf_6vf_rvvm1_sleef(vfloat_rvvm1_sleef v0, vfloat_rvvm1_sleef v1, vfloat_rvvm1_sleef v2, vfloat_rvvm1_sleef v3, vfloat_rvvm1_sleef v4, vfloat_rvvm1_sleef v5) {
  return vadd_vf_5vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(v0, v1), v2, v3, v4, v5);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vadd_vf_7vf_rvvm1_sleef(vfloat_rvvm1_sleef v0, vfloat_rvvm1_sleef v1, vfloat_rvvm1_sleef v2, vfloat_rvvm1_sleef v3, vfloat_rvvm1_sleef v4, vfloat_rvvm1_sleef v5, vfloat_rvvm1_sleef v6) {
  return vadd_vf_6vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(v0, v1), v2, v3, v4, v5, v6);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vsub_vf_3vf_rvvm1_sleef(vfloat_rvvm1_sleef v0, vfloat_rvvm1_sleef v1, vfloat_rvvm1_sleef v2) {
  return vsub_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(v0, v1), v2);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vsub_vf_4vf_rvvm1_sleef(vfloat_rvvm1_sleef v0, vfloat_rvvm1_sleef v1, vfloat_rvvm1_sleef v2, vfloat_rvvm1_sleef v3) {
  return vsub_vf_3vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(v0, v1), v2, v3);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vsub_vf_5vf_rvvm1_sleef(vfloat_rvvm1_sleef v0, vfloat_rvvm1_sleef v1, vfloat_rvvm1_sleef v2, vfloat_rvvm1_sleef v3, vfloat_rvvm1_sleef v4) {
  return vsub_vf_4vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(v0, v1), v2, v3, v4);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfneg_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef x) {
  return vcast_vf2_vf_vf_rvvm1_sleef(vneg_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x)), vneg_vf_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(x)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfabs_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef x) {
  return vcast_vf2_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x)),
                         vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(x)), vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x)), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0f))))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfnormalize_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef t) {
  vfloat_rvvm1_sleef s = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(t), vf2gety_vf_vf2_rvvm1_sleef(t));
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vadd_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(t), s), vf2gety_vf_vf2_rvvm1_sleef(t)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfscale_vf2_vf2_vf_rvvm1_sleef(vfloat2_rvvm1_sleef d, vfloat_rvvm1_sleef s) {
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), s), vmul_vf_vf_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(d), s));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfadd_vf2_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vadd_vf_vf_vf_rvvm1_sleef(x, y);
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vadd_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(x, s), y));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfadd2_vf2_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vadd_vf_vf_vf_rvvm1_sleef(x, y);
  vfloat_rvvm1_sleef v = vsub_vf_vf_vf_rvvm1_sleef(s, x);
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vadd_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(x, vsub_vf_vf_vf_rvvm1_sleef(s, v)), vsub_vf_vf_vf_rvvm1_sleef(y, v)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfadd2_vf2_vf_vf2_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat2_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vadd_vf_vf_vf_rvvm1_sleef(x, vf2getx_vf_vf2_rvvm1_sleef(y));
  vfloat_rvvm1_sleef v = vsub_vf_vf_vf_rvvm1_sleef(s, x);
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vadd_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(x, vsub_vf_vf_vf_rvvm1_sleef(s, v)), vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(y), v)), vf2gety_vf_vf2_rvvm1_sleef(y)));

}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfadd_vf2_vf2_vf_rvvm1_sleef(vfloat2_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), y);
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vadd_vf_3vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), s), y, vf2gety_vf_vf2_rvvm1_sleef(x)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfsub_vf2_vf2_vf_rvvm1_sleef(vfloat2_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), y);
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vadd_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), s), y), vf2gety_vf_vf2_rvvm1_sleef(x)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfadd2_vf2_vf2_vf_rvvm1_sleef(vfloat2_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), y);
  vfloat_rvvm1_sleef v = vsub_vf_vf_vf_rvvm1_sleef(s, vf2getx_vf_vf2_rvvm1_sleef(x));
  vfloat_rvvm1_sleef t = vadd_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vsub_vf_vf_vf_rvvm1_sleef(s, v)), vsub_vf_vf_vf_rvvm1_sleef(y, v));
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vadd_vf_vf_vf_rvvm1_sleef(t, vf2gety_vf_vf2_rvvm1_sleef(x)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfadd_vf2_vf_vf2_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat2_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vadd_vf_vf_vf_rvvm1_sleef(x, vf2getx_vf_vf2_rvvm1_sleef(y));
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vadd_vf_3vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(x, s), vf2getx_vf_vf2_rvvm1_sleef(y), vf2gety_vf_vf2_rvvm1_sleef(y)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfadd_vf2_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef x, vfloat2_rvvm1_sleef y) {

  vfloat_rvvm1_sleef s = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y));
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vadd_vf_4vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), s), vf2getx_vf_vf2_rvvm1_sleef(y), vf2gety_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(y)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfadd2_vf2_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef x, vfloat2_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y));
  vfloat_rvvm1_sleef v = vsub_vf_vf_vf_rvvm1_sleef(s, vf2getx_vf_vf2_rvvm1_sleef(x));
  vfloat_rvvm1_sleef t = vadd_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vsub_vf_vf_vf_rvvm1_sleef(s, v)), vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(y), v));
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vadd_vf_vf_vf_rvvm1_sleef(t, vadd_vf_vf_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(y))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfsub_vf2_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {

  vfloat_rvvm1_sleef s = vsub_vf_vf_vf_rvvm1_sleef(x, y);
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vsub_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(x, s), y));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfsub_vf2_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef x, vfloat2_rvvm1_sleef y) {

  vfloat_rvvm1_sleef s = vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y));
  vfloat_rvvm1_sleef t = vsub_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), s);
  t = vsub_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(y));
  t = vadd_vf_vf_vf_rvvm1_sleef(t, vf2gety_vf_vf2_rvvm1_sleef(x));
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vsub_vf_vf_vf_rvvm1_sleef(t, vf2gety_vf_vf2_rvvm1_sleef(y)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfdiv_vf2_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef n, vfloat2_rvvm1_sleef d) {
  vfloat_rvvm1_sleef t = vrec_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d));
  vfloat_rvvm1_sleef s = vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(n), t);
  vfloat_rvvm1_sleef u = vfmapn_vf_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(n), s);
  vfloat_rvvm1_sleef v = vfmanp_vf_vf_vf_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(d), t, vfmanp_vf_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), t, vcast_vf_f_rvvm1_sleef(1)));
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vfma_vf_vf_vf_vf_rvvm1_sleef(s, v, vfma_vf_vf_vf_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(n), t, u)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfmul_vf2_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vmul_vf_vf_vf_rvvm1_sleef(x, y);
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vfmapn_vf_vf_vf_vf_rvvm1_sleef(x, y, s));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfsqu_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef x) {
  vfloat_rvvm1_sleef s = vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(x));
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vfma_vf_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(x)), vf2gety_vf_vf2_rvvm1_sleef(x), vfmapn_vf_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(x), s)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef dfsqu_vf_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef x) {
  return vfma_vf_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(x), vadd_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(x)), vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(x))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfmul_vf2_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef x, vfloat2_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y));
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vfma_vf_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(y), vfma_vf_vf_vf_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y), vfmapn_vf_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y), s))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef dfmul_vf_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef x, vfloat2_rvvm1_sleef y) {
  return vfma_vf_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y), vfma_vf_vf_vf_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y), vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(y))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfmul_vf2_vf2_vf_rvvm1_sleef(vfloat2_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef s = vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), y);
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vfma_vf_vf_vf_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(x), y, vfmapn_vf_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), y, s)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfrec_vf2_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef s = vrec_vf_vf_rvvm1_sleef(d);
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(s, vfmanp_vf_vf_vf_vf_rvvm1_sleef(d, s, vcast_vf_f_rvvm1_sleef(1))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfrec_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef d) {
  vfloat_rvvm1_sleef s = vrec_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d));
  return vf2setxy_vf2_vf_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(s, vfmanp_vf_vf_vf_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(d), s, vfmanp_vf_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), s, vcast_vf_f_rvvm1_sleef(1)))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfsqrt_vf2_vf2_rvvm1_sleef(vfloat2_rvvm1_sleef d) {

  vfloat_rvvm1_sleef t = vsqrt_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d)));
  return dfscale_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf2_rvvm1_sleef(d, dfmul_vf2_vf_vf_rvvm1_sleef(t, t)), dfrec_vf2_vf_rvvm1_sleef(t)), vcast_vf_f_rvvm1_sleef(0.5));

}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfsqrt_vf2_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef t = vsqrt_vf_vf_rvvm1_sleef(d);
  return dfscale_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf_vf2_rvvm1_sleef(d, dfmul_vf2_vf_vf_rvvm1_sleef(t, t)), dfrec_vf2_vf_rvvm1_sleef(t)), vcast_vf_f_rvvm1_sleef(0.5f));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_sp_vopmask_rvvm1_sleef visnegzero_vo_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  return veq_vo_vi2_vi2_rvvm1_sleef(vreinterpret_vi2_vf_rvvm1_sleef(d), vreinterpret_vi2_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0)));
}

static SLEEF_ALWAYS_INLINE rvv_sp_vopmask_rvvm1_sleef vnot_vo32_vo32_rvvm1_sleef(rvv_sp_vopmask_rvvm1_sleef x) {
  return rvv_sp_vxor_vo_vo_vo(x, veq_vo_vi2_vi2_rvvm1_sleef(vcast_vi2_i_rvvm1_sleef(0), vcast_vi2_i_rvvm1_sleef(0)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vmask_rvvm1_sleef vsignbit_vm_vf_rvvm1_sleef(vfloat_rvvm1_sleef f) {
  return vand_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vf_rvvm1_sleef(f), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0f)));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_sp_vopmask_rvvm1_sleef vsignbit_vo_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  return veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(vreinterpret_vi2_vf_rvvm1_sleef(d), vcast_vi2_i_rvvm1_sleef(0x80000000)), vcast_vi2_i_rvvm1_sleef(0x80000000));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vint2_rvvm1_sleef vsel_vi2_vf_vf_vi2_vi2_rvvm1_sleef(vfloat_rvvm1_sleef f0, vfloat_rvvm1_sleef f1, vint2_rvvm1_sleef x, vint2_rvvm1_sleef y) {
  return vsel_vi2_vo_vi2_vi2_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(f0, f1), x, y);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vint2_rvvm1_sleef vsel_vi2_vf_vi2_rvvm1_sleef(vfloat_rvvm1_sleef d, vint2_rvvm1_sleef x) {
  return vand_vi2_vo_vi2_rvvm1_sleef(vsignbit_vo_vf_rvvm1_sleef(d), x);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_sp_vopmask_rvvm1_sleef visint_vo_vf_rvvm1_sleef(vfloat_rvvm1_sleef y) { return veq_vo_vf_vf_rvvm1_sleef(vtruncate_vf_vf_rvvm1_sleef(y), y); }

static SLEEF_ALWAYS_INLINE SLEEF_CONST rvv_sp_vopmask_rvvm1_sleef visnumber_vo_vf_rvvm1_sleef(vfloat_rvvm1_sleef x) { return vnot_vo32_vo32_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(x), visnan_vo_vf_rvvm1_sleef(x))); }

static SLEEF_ALWAYS_INLINE SLEEF_CONST vint2_rvvm1_sleef vilogbk_vi2_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(5.421010862427522E-20f));
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1.8446744073709552E19f), d), d);
  vint2_rvvm1_sleef q = vand_vi2_vi2_vi2_rvvm1_sleef(vsrl_vi2_vi2_i_rvvm1_sleef(vreinterpret_vi2_vf_rvvm1_sleef(d), 23), vcast_vi2_i_rvvm1_sleef(0xff));
  q = vsub_vi2_vi2_vi2_rvvm1_sleef(q, vsel_vi2_vo_vi2_vi2_rvvm1_sleef(o, vcast_vi2_i_rvvm1_sleef(64 + 0x7f), vcast_vi2_i_rvvm1_sleef(0x7f)));
  return q;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vint2_rvvm1_sleef vilogb2k_vi2_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  vint2_rvvm1_sleef q = vreinterpret_vi2_vf_rvvm1_sleef(d);
  q = vsrl_vi2_vi2_i_rvvm1_sleef(q, 23);
  q = vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(0xff));
  q = vsub_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(0x7f));
  return q;
}

SLEEF_INLINE SLEEF_CONST vint2_rvvm1_sleef Sleef_ilogbfx_rvvm1(vfloat_rvvm1_sleef d) {
  vint2_rvvm1_sleef e = vilogbk_vi2_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d));
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0.0f)), vcast_vi2_i_rvvm1_sleef(SLEEF_FP_ILOGB0), e);
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(d), vcast_vi2_i_rvvm1_sleef(SLEEF_FP_ILOGBNAN), e);
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(d), vcast_vi2_i_rvvm1_sleef(2147483647), e);
  return e;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vpow2i_vf_vi2_rvvm1_sleef(vint2_rvvm1_sleef q) {
  return vreinterpret_vf_vi2_rvvm1_sleef(vsll_vi2_vi2_i_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(0x7f)), 23));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vldexp_vf_vf_vi2_rvvm1_sleef(vfloat_rvvm1_sleef x, vint2_rvvm1_sleef q) {
  vfloat_rvvm1_sleef u;
  vint2_rvvm1_sleef m = vsra_vi2_vi2_i_rvvm1_sleef(q, 31);
  m = vsll_vi2_vi2_i_rvvm1_sleef(vsub_vi2_vi2_vi2_rvvm1_sleef(vsra_vi2_vi2_i_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(m, q), 6), m), 4);
  q = vsub_vi2_vi2_vi2_rvvm1_sleef(q, vsll_vi2_vi2_i_rvvm1_sleef(m, 2));
  m = vadd_vi2_vi2_vi2_rvvm1_sleef(m, vcast_vi2_i_rvvm1_sleef(0x7f));
  m = vand_vi2_vi2_vi2_rvvm1_sleef(vgt_vi2_vi2_vi2_rvvm1_sleef(m, vcast_vi2_i_rvvm1_sleef(0)), m);
  vint2_rvvm1_sleef n = vgt_vi2_vi2_vi2_rvvm1_sleef(m, vcast_vi2_i_rvvm1_sleef(0xff));
  m = vor_vi2_vi2_vi2_rvvm1_sleef(vandnot_vi2_vi2_vi2_rvvm1_sleef(n, m), vand_vi2_vi2_vi2_rvvm1_sleef(n, vcast_vi2_i_rvvm1_sleef(0xff)));
  u = vreinterpret_vf_vi2_rvvm1_sleef(vsll_vi2_vi2_i_rvvm1_sleef(m, 23));
  x = vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(x, u), u), u), u);
  u = vreinterpret_vf_vi2_rvvm1_sleef(vsll_vi2_vi2_i_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(0x7f)), 23));
  return vmul_vf_vf_vf_rvvm1_sleef(x, u);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vldexp2_vf_vf_vi2_rvvm1_sleef(vfloat_rvvm1_sleef d, vint2_rvvm1_sleef e) {
  return vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vpow2i_vf_vi2_rvvm1_sleef(vsra_vi2_vi2_i_rvvm1_sleef(e, 1))), vpow2i_vf_vi2_rvvm1_sleef(vsub_vi2_vi2_vi2_rvvm1_sleef(e, vsra_vi2_vi2_i_rvvm1_sleef(e, 1))));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vldexp3_vf_vf_vi2_rvvm1_sleef(vfloat_rvvm1_sleef d, vint2_rvvm1_sleef q) {
  return vreinterpret_vf_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(vreinterpret_vi2_vf_rvvm1_sleef(d), vsll_vi2_vi2_i_rvvm1_sleef(q, 23)));
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_ldexpfx_rvvm1(vfloat_rvvm1_sleef x, vint2_rvvm1_sleef q) { return vldexp_vf_vf_vi2_rvvm1_sleef(x, q); }

static SLEEF_ALWAYS_INLINE SLEEF_CONST fi_t_rvvm1_sleef rempisubf_rvvm1_sleef(vfloat_rvvm1_sleef x) {

  vfloat_rvvm1_sleef c = vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1 << 23), x);
  vfloat_rvvm1_sleef rint4x = vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(4), x)), vcast_vf_f_rvvm1_sleef(1 << 23)),
                                   vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(4), x),
                                   vorsign_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(4), x, c), c), x));
  vfloat_rvvm1_sleef rintx = vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(1 << 23)),
                                   x, vorsign_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(x, c), c), x));
  return fisetdi_fi_vf_vi2_rvvm1_sleef(vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.25), rint4x, x),
                           vtruncate_vi2_vf_rvvm1_sleef(vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-4), rintx, rint4x)));

}

static SLEEF_ALWAYS_INLINE SLEEF_CONST dfi_t_rvvm1_sleef rempif_rvvm1_sleef(vfloat_rvvm1_sleef a) {
  vfloat2_rvvm1_sleef x, y;
  vint2_rvvm1_sleef ex = vilogb2k_vi2_vf_rvvm1_sleef(a);

  ex = vsub_vi2_vi2_vi2_rvvm1_sleef(ex, vcast_vi2_i_rvvm1_sleef(25));
  vint2_rvvm1_sleef q = vand_vi2_vo_vi2_rvvm1_sleef(vgt_vo_vi2_vi2_rvvm1_sleef(ex, vcast_vi2_i_rvvm1_sleef(90-25)), vcast_vi2_i_rvvm1_sleef(-64));
  a = vldexp3_vf_vf_vi2_rvvm1_sleef(a, q);
  ex = vandnot_vi2_vi2_vi2_rvvm1_sleef(vsra_vi2_vi2_i_rvvm1_sleef(ex, 31), ex);
  ex = vsll_vi2_vi2_i_rvvm1_sleef(ex, 2);
  x = dfmul_vf2_vf_vf_rvvm1_sleef(a, vgather_vf_p_vi2_rvvm1_sleef(Sleef_rempitabsp, ex));
  fi_t_rvvm1_sleef di = rempisubf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x));
  q = figeti_vi2_di_rvvm1_sleef(di);
  x = vf2setx_vf2_vf2_vf_rvvm1_sleef(x, figetd_vf_di_rvvm1_sleef(di));
  x = dfnormalize_vf2_vf2_rvvm1_sleef(x);
  y = dfmul_vf2_vf_vf_rvvm1_sleef(a, vgather_vf_p_vi2_rvvm1_sleef(Sleef_rempitabsp+1, ex));
  x = dfadd2_vf2_vf2_vf2_rvvm1_sleef(x, y);
  di = rempisubf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x));
  q = vadd_vi2_vi2_vi2_rvvm1_sleef(q, figeti_vi2_di_rvvm1_sleef(di));
  x = vf2setx_vf2_vf2_vf_rvvm1_sleef(x, figetd_vf_di_rvvm1_sleef(di));
  x = dfnormalize_vf2_vf2_rvvm1_sleef(x);
  y = vcast_vf2_vf_vf_rvvm1_sleef(vgather_vf_p_vi2_rvvm1_sleef(Sleef_rempitabsp+2, ex), vgather_vf_p_vi2_rvvm1_sleef(Sleef_rempitabsp+3, ex));
  y = dfmul_vf2_vf2_vf_rvvm1_sleef(y, a);
  x = dfadd2_vf2_vf2_vf2_rvvm1_sleef(x, y);
  x = dfnormalize_vf2_vf2_rvvm1_sleef(x);
  x = dfmul_vf2_vf2_vf2_rvvm1_sleef(x, vcast_vf2_f_f_rvvm1_sleef(3.1415927410125732422f*2, -8.7422776573475857731e-08f*2));
  x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(a), vcast_vf_f_rvvm1_sleef(0.7f)), vcast_vf2_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0)), x);
  return dfisetdfi_dfi_vf2_vi2_rvvm1_sleef(x, q);
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_sinfx_u35rvvm1(vfloat_rvvm1_sleef d) {

  vint2_rvvm1_sleef q;
  vfloat_rvvm1_sleef u, s, r = d;

  if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(125.0f)))), 1)) {
    q = vrint_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)0.318309886183790671537767526745028724)));
    u = vcast_vf_vi2_rvvm1_sleef(q);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.1414794921875f), d);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.00011315941810607910156f), d);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.9841872589410058936e-09f), d);
  } else if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(39000)))), 1)) {
    q = vrint_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)0.318309886183790671537767526745028724)));
    u = vcast_vf_vi2_rvvm1_sleef(q);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.140625f), d);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.0009670257568359375f), d);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-6.2771141529083251953e-07f), d);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.2154201256553420762e-10f), d);
  } else {
    dfi_t_rvvm1_sleef dfi_rvvm1_sleef = rempif_rvvm1_sleef(d);
    q = vand_vi2_vi2_vi2_rvvm1_sleef(dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), vcast_vi2_i_rvvm1_sleef(3));
    q = vadd_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, q), vsel_vi2_vo_vi2_vi2_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)), vcast_vf_f_rvvm1_sleef(0)), vcast_vi2_i_rvvm1_sleef(2), vcast_vi2_i_rvvm1_sleef(1)));
    q = vsra_vi2_vi2_i_rvvm1_sleef(q, 2);
    rvv_sp_vopmask_rvvm1_sleef o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1));
    vfloat2_rvvm1_sleef x = vcast_vf2_vf_vf_rvvm1_sleef(vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(3.1415927410125732422f*-0.5), vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef))),
                                vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-8.7422776573475857731e-08f*-0.5), vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef))));
    x = dfadd2_vf2_vf2_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), x);
    dfi_rvvm1_sleef = dfisetdf_dfi_dfi_vf2_rvvm1_sleef(dfi_rvvm1_sleef, vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, x, dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)));
    d = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)), vf2gety_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)));

    d = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(r), visnan_vo_vf_rvvm1_sleef(r)), vreinterpret_vm_vf_rvvm1_sleef(d)));
  }

  s = vmul_vf_vf_vf_rvvm1_sleef(d, d);

  d = vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1)), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0f))), vreinterpret_vm_vf_rvvm1_sleef(d)));

  u = vcast_vf_f_rvvm1_sleef(2.6083159809786593541503e-06f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.0001981069071916863322258f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.00833307858556509017944336f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.166666597127914428710938f));

  u = vadd_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(u, d)), d);

  u = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(r), r, u);

  return u;

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_cosfx_u35rvvm1(vfloat_rvvm1_sleef d) {

  vint2_rvvm1_sleef q;
  vfloat_rvvm1_sleef u, s, r = d;

  if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(125.0f)))), 1)) {
    q = vrint_vi2_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)0.318309886183790671537767526745028724)), vcast_vf_f_rvvm1_sleef(0.5f)));
    q = vadd_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, q), vcast_vi2_i_rvvm1_sleef(1));

    u = vcast_vf_vi2_rvvm1_sleef(q);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.1414794921875f*0.5f), d);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.00011315941810607910156f*0.5f), d);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.9841872589410058936e-09f*0.5f), d);
  } else if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(39000)))), 1)) {
    q = vrint_vi2_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)0.318309886183790671537767526745028724)), vcast_vf_f_rvvm1_sleef(0.5f)));
    q = vadd_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, q), vcast_vi2_i_rvvm1_sleef(1));

    u = vcast_vf_vi2_rvvm1_sleef(q);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.140625f*0.5f), d);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.0009670257568359375f*0.5f), d);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-6.2771141529083251953e-07f*0.5f), d);
    d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.2154201256553420762e-10f*0.5f), d);
  } else {
    dfi_t_rvvm1_sleef dfi_rvvm1_sleef = rempif_rvvm1_sleef(d);
    q = vand_vi2_vi2_vi2_rvvm1_sleef(dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), vcast_vi2_i_rvvm1_sleef(3));
    q = vadd_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, q), vsel_vi2_vo_vi2_vi2_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)), vcast_vf_f_rvvm1_sleef(0)), vcast_vi2_i_rvvm1_sleef(8), vcast_vi2_i_rvvm1_sleef(7)));
    q = vsra_vi2_vi2_i_rvvm1_sleef(q, 1);
    rvv_sp_vopmask_rvvm1_sleef o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(0));
    vfloat_rvvm1_sleef y = vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)), vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(0), vcast_vf_f_rvvm1_sleef(-1));
    vfloat2_rvvm1_sleef x = vcast_vf2_vf_vf_rvvm1_sleef(vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(3.1415927410125732422f*-0.5), y),
                                vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-8.7422776573475857731e-08f*-0.5), y));
    x = dfadd2_vf2_vf2_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), x);
    dfi_rvvm1_sleef = dfisetdf_dfi_dfi_vf2_rvvm1_sleef(dfi_rvvm1_sleef, vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, x, dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)));
    d = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)), vf2gety_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)));

    d = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(r), visnan_vo_vf_rvvm1_sleef(r)), vreinterpret_vm_vf_rvvm1_sleef(d)));
  }

  s = vmul_vf_vf_vf_rvvm1_sleef(d, d);

  d = vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(0)), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0f))), vreinterpret_vm_vf_rvvm1_sleef(d)));

  u = vcast_vf_f_rvvm1_sleef(2.6083159809786593541503e-06f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.0001981069071916863322258f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.00833307858556509017944336f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.166666597127914428710938f));

  u = vadd_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(u, d)), d);

  return u;

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_tanfx_u35rvvm1(vfloat_rvvm1_sleef d) {

  vint2_rvvm1_sleef q;
  rvv_sp_vopmask_rvvm1_sleef o;
  vfloat_rvvm1_sleef u, s, x;

  x = d;

  if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(125.0f*0.5f)))), 1)) {
    q = vrint_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)(2 * 0.318309886183790671537767526745028724))));
    u = vcast_vf_vi2_rvvm1_sleef(q);
    x = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.1414794921875f*0.5f), x);
    x = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.00011315941810607910156f*0.5f), x);
    x = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.9841872589410058936e-09f*0.5f), x);
  } else if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(39000)))), 1)) {
    q = vrint_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)(2 * 0.318309886183790671537767526745028724))));
    u = vcast_vf_vi2_rvvm1_sleef(q);
    x = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.140625f*0.5f), x);
    x = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.0009670257568359375f*0.5f), x);
    x = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-6.2771141529083251953e-07f*0.5f), x);
    x = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.2154201256553420762e-10f*0.5f), x);
  } else {
    dfi_t_rvvm1_sleef dfi_rvvm1_sleef = rempif_rvvm1_sleef(d);
    q = dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef);
    x = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)), vf2gety_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)));
    x = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(d), visnan_vo_vf_rvvm1_sleef(d)), vreinterpret_vm_vf_rvvm1_sleef(x)));
    x = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(d), d, x);
  }

  s = vmul_vf_vf_vf_rvvm1_sleef(x, x);

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1));
  x = vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0f))), vreinterpret_vm_vf_rvvm1_sleef(x)));

  vfloat_rvvm1_sleef s2 = vmul_vf_vf_vf_rvvm1_sleef(s, s), s4 = vmul_vf_vf_vf_rvvm1_sleef(s2, s2);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef((s4), (vmla_vf_vf_vf_vf_rvvm1_sleef((s), (vcast_vf_f_rvvm1_sleef(0.00927245803177356719970703f)), (vcast_vf_f_rvvm1_sleef(0.00331984995864331722259521f)))), (vmla_vf_vf_vf_vf_rvvm1_sleef((s2), (vmla_vf_vf_vf_vf_rvvm1_sleef((s), (vcast_vf_f_rvvm1_sleef(0.0242998078465461730957031f)), (vcast_vf_f_rvvm1_sleef(0.0534495301544666290283203f)))), (vmla_vf_vf_vf_vf_rvvm1_sleef((s), (vcast_vf_f_rvvm1_sleef(0.133383005857467651367188f)), (vcast_vf_f_rvvm1_sleef(0.333331853151321411132812f)))))))

                                        ;

  u = vmla_vf_vf_vf_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(u, x), x);

  u = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vrec_vf_vf_rvvm1_sleef(u), u);

  return u;

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_sinfx_u10rvvm1(vfloat_rvvm1_sleef d) {

  vint2_rvvm1_sleef q;
  vfloat_rvvm1_sleef u, v;
  vfloat2_rvvm1_sleef s, t, x;

  if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(125.0f)))), 1)) {
    u = vrint_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0.318309886183790671537767526745028724)));
    q = vrint_vi2_vf_rvvm1_sleef(u);
    v = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.1414794921875f), d);
    s = dfadd2_vf2_vf_vf_rvvm1_sleef(v, vmul_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.00011315941810607910156f)));
    s = dfadd_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.9841872589410058936e-09f)));
  } else {
    dfi_t_rvvm1_sleef dfi_rvvm1_sleef = rempif_rvvm1_sleef(d);
    q = vand_vi2_vi2_vi2_rvvm1_sleef(dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), vcast_vi2_i_rvvm1_sleef(3));
    q = vadd_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, q), vsel_vi2_vo_vi2_vi2_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)), vcast_vf_f_rvvm1_sleef(0)), vcast_vi2_i_rvvm1_sleef(2), vcast_vi2_i_rvvm1_sleef(1)));
    q = vsra_vi2_vi2_i_rvvm1_sleef(q, 2);
    rvv_sp_vopmask_rvvm1_sleef o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1));
    vfloat2_rvvm1_sleef x = vcast_vf2_vf_vf_rvvm1_sleef(vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(3.1415927410125732422f*-0.5), vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef))),
                                vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-8.7422776573475857731e-08f*-0.5), vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef))));
    x = dfadd2_vf2_vf2_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), x);
    dfi_rvvm1_sleef = dfisetdf_dfi_dfi_vf2_rvvm1_sleef(dfi_rvvm1_sleef, vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, x, dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)));
    s = dfnormalize_vf2_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef));

    s = vf2setx_vf2_vf2_vf_rvvm1_sleef(s, vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(d), visnan_vo_vf_rvvm1_sleef(d)), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s)))));

  }

  t = s;
  s = dfsqu_vf2_vf2_rvvm1_sleef(s);

  u = vcast_vf_f_rvvm1_sleef(2.6083159809786593541503e-06f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(-0.0001981069071916863322258f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.00833307858556509017944336f));

  x = dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), dfmul_vf2_vf2_vf2_rvvm1_sleef(dfadd_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.166666597127914428710938f), vmul_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s))), s));

  u = dfmul_vf_vf2_vf2_rvvm1_sleef(t, x);

  u = vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1)), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(u)));

  u = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(d), d, u);

  return u;

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_cosfx_u10rvvm1(vfloat_rvvm1_sleef d) {

  vint2_rvvm1_sleef q;
  vfloat_rvvm1_sleef u;
  vfloat2_rvvm1_sleef s, t, x;

  if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(125.0f)))), 1)) {
    vfloat_rvvm1_sleef dq = vmla_vf_vf_vf_vf_rvvm1_sleef(vrint_vf_vf_rvvm1_sleef(vmla_vf_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0.318309886183790671537767526745028724), vcast_vf_f_rvvm1_sleef(-0.5f))),
                                 vcast_vf_f_rvvm1_sleef(2), vcast_vf_f_rvvm1_sleef(1));
    q = vrint_vi2_vf_rvvm1_sleef(dq);
    s = dfadd2_vf2_vf_vf_rvvm1_sleef (d, vmul_vf_vf_vf_rvvm1_sleef(dq, vcast_vf_f_rvvm1_sleef(-3.1414794921875f*0.5f)));
    s = dfadd2_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(dq, vcast_vf_f_rvvm1_sleef(-0.00011315941810607910156f*0.5f)));
    s = dfadd2_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(dq, vcast_vf_f_rvvm1_sleef(-1.9841872589410058936e-09f*0.5f)));
  } else {
    dfi_t_rvvm1_sleef dfi_rvvm1_sleef = rempif_rvvm1_sleef(d);
    q = vand_vi2_vi2_vi2_rvvm1_sleef(dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), vcast_vi2_i_rvvm1_sleef(3));
    q = vadd_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, q), vsel_vi2_vo_vi2_vi2_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)), vcast_vf_f_rvvm1_sleef(0)), vcast_vi2_i_rvvm1_sleef(8), vcast_vi2_i_rvvm1_sleef(7)));
    q = vsra_vi2_vi2_i_rvvm1_sleef(q, 1);
    rvv_sp_vopmask_rvvm1_sleef o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(0));
    vfloat_rvvm1_sleef y = vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)), vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(0), vcast_vf_f_rvvm1_sleef(-1));
    vfloat2_rvvm1_sleef x = vcast_vf2_vf_vf_rvvm1_sleef(vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(3.1415927410125732422f*-0.5), y),
                                vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-8.7422776573475857731e-08f*-0.5), y));
    x = dfadd2_vf2_vf2_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef), x);
    dfi_rvvm1_sleef = dfisetdf_dfi_dfi_vf2_rvvm1_sleef(dfi_rvvm1_sleef, vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, x, dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)));
    s = dfnormalize_vf2_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef));

    s = vf2setx_vf2_vf2_vf_rvvm1_sleef(s, vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(d), visnan_vo_vf_rvvm1_sleef(d)), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s)))));

  }

  t = s;
  s = dfsqu_vf2_vf2_rvvm1_sleef(s);

  u = vcast_vf_f_rvvm1_sleef(2.6083159809786593541503e-06f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(-0.0001981069071916863322258f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.00833307858556509017944336f));

  x = dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), dfmul_vf2_vf2_vf2_rvvm1_sleef(dfadd_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.166666597127914428710938f), vmul_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s))), s));

  u = dfmul_vf_vf2_vf2_rvvm1_sleef(t, x);

  u = vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(0)), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(u)));

  return u;

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_fastsinfx_u3500rvvm1(vfloat_rvvm1_sleef d) {
  vint2_rvvm1_sleef q;
  vfloat_rvvm1_sleef u, s, t = d;

  s = vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)0.318309886183790671537767526745028724));
  u = vrint_vf_vf_rvvm1_sleef(s);
  q = vrint_vi2_vf_rvvm1_sleef(s);
  d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-(float)3.141592653589793238462643383279502884), d);

  s = vmul_vf_vf_vf_rvvm1_sleef(d, d);

  u = vcast_vf_f_rvvm1_sleef(-0.1881748176e-3);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.8323502727e-2));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.1666651368e+0));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(s, d), u, d);

  u = vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1)), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0f))), vreinterpret_vm_vf_rvvm1_sleef(u)));

  rvv_sp_vopmask_rvvm1_sleef g = vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(t), vcast_vf_f_rvvm1_sleef(30.0f));
  if (!__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(g)), 1)) return vsel_vf_vo_vf_vf_rvvm1_sleef(g, u, Sleef_sinfx_u35rvvm1(t));

  return u;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_fastcosfx_u3500rvvm1(vfloat_rvvm1_sleef d) {
  vint2_rvvm1_sleef q;
  vfloat_rvvm1_sleef u, s, t = d;

  s = vmla_vf_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)0.318309886183790671537767526745028724), vcast_vf_f_rvvm1_sleef(-0.5f));
  u = vrint_vf_vf_rvvm1_sleef(s);
  q = vrint_vi2_vf_rvvm1_sleef(s);
  d = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-(float)3.141592653589793238462643383279502884), vsub_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)3.141592653589793238462643383279502884 * 0.5f)));

  s = vmul_vf_vf_vf_rvvm1_sleef(d, d);

  u = vcast_vf_f_rvvm1_sleef(-0.1881748176e-3);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.8323502727e-2));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.1666651368e+0));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(s, d), u, d);

  u = vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(0)), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0f))), vreinterpret_vm_vf_rvvm1_sleef(u)));

  rvv_sp_vopmask_rvvm1_sleef g = vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(t), vcast_vf_f_rvvm1_sleef(30.0f));
  if (!__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(g)), 1)) return vsel_vf_vo_vf_vf_rvvm1_sleef(g, u, Sleef_cosfx_u35rvvm1(t));

  return u;
}

SLEEF_INLINE SLEEF_CONST vfloat2_rvvm1_sleef Sleef_sincosfx_u35rvvm1(vfloat_rvvm1_sleef d) {

  vint2_rvvm1_sleef q;
  rvv_sp_vopmask_rvvm1_sleef o;
  vfloat_rvvm1_sleef u, s, t, rx, ry;
  vfloat2_rvvm1_sleef r;

  s = d;

  if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(125.0f)))), 1)) {
    q = vrint_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)0.636619772367581343075535053490057448)));
    u = vcast_vf_vi2_rvvm1_sleef(q);
    s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.1414794921875f*0.5f), s);
    s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.00011315941810607910156f*0.5f), s);
    s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.9841872589410058936e-09f*0.5f), s);
  } else if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(39000)))), 1)) {
    q = vrint_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)0.636619772367581343075535053490057448)));
    u = vcast_vf_vi2_rvvm1_sleef(q);
    s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.140625f*0.5f), s);
    s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.0009670257568359375f*0.5f), s);
    s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-6.2771141529083251953e-07f*0.5f), s);
    s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.2154201256553420762e-10f*0.5f), s);
  } else {
    dfi_t_rvvm1_sleef dfi_rvvm1_sleef = rempif_rvvm1_sleef(d);
    q = dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef);
    s = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)), vf2gety_vf_vf2_rvvm1_sleef(dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef)));
    s = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(d), visnan_vo_vf_rvvm1_sleef(d)), vreinterpret_vm_vf_rvvm1_sleef(s)));
  }

  t = s;

  s = vmul_vf_vf_vf_rvvm1_sleef(s, s);

  u = vcast_vf_f_rvvm1_sleef(-0.000195169282960705459117889f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.00833215750753879547119141f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.166666537523269653320312f));

  rx = vmla_vf_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(u, s), t, t);
  rx = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(-0.0f), rx);

  u = vcast_vf_f_rvvm1_sleef(-2.71811842367242206819355e-07f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(2.47990446951007470488548e-05f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.00138888787478208541870117f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.0416666641831398010253906f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.5));

  ry = vmla_vf_vf_vf_vf_rvvm1_sleef(s, u, vcast_vf_f_rvvm1_sleef(1));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(0));
  r = vf2setxy_vf2_vf_vf_rvvm1_sleef(vsel_vf_vo_vf_vf_rvvm1_sleef(o, rx, ry), vsel_vf_vo_vf_vf_rvvm1_sleef(o, ry, rx));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(2));
  r = vf2setx_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)))));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(2));
  r = vf2sety_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(r)))));

  return r;

}

SLEEF_INLINE SLEEF_CONST vfloat2_rvvm1_sleef Sleef_sincosfx_u10rvvm1(vfloat_rvvm1_sleef d) {

  vint2_rvvm1_sleef q;
  rvv_sp_vopmask_rvvm1_sleef o;
  vfloat_rvvm1_sleef u, v, rx, ry;
  vfloat2_rvvm1_sleef r, s, t, x;

  if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(125.0f)))), 1)) {
    u = vrint_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(2 * 0.318309886183790671537767526745028724)));
    q = vrint_vi2_vf_rvvm1_sleef(u);
    v = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.1414794921875f*0.5f), d);
    s = dfadd2_vf2_vf_vf_rvvm1_sleef(v, vmul_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.00011315941810607910156f*0.5f)));
    s = dfadd_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.9841872589410058936e-09f*0.5f)));
  } else {
    dfi_t_rvvm1_sleef dfi_rvvm1_sleef = rempif_rvvm1_sleef(d);
    q = dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef);
    s = dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef);
    o = rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(d), visnan_vo_vf_rvvm1_sleef(d));
    s = vf2setx_vf2_vf2_vf_rvvm1_sleef(s, vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s)))));
  }

  t = s;

  s = vf2setx_vf2_vf2_vf_rvvm1_sleef(s, dfsqu_vf_vf2_rvvm1_sleef(s));

  u = vcast_vf_f_rvvm1_sleef(-0.000195169282960705459117889f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.00833215750753879547119141f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(-0.166666537523269653320312f));

  u = vmul_vf_vf_vf_rvvm1_sleef(u, vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s), vf2getx_vf_vf2_rvvm1_sleef(t)));

  x = dfadd_vf2_vf2_vf_rvvm1_sleef(t, u);
  rx = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(x));

  rx = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(-0.0f), rx);

  u = vcast_vf_f_rvvm1_sleef(-2.71811842367242206819355e-07f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(2.47990446951007470488548e-05f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(-0.00138888787478208541870117f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.0416666641831398010253906f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(-0.5));

  x = dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), dfmul_vf2_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s), u));
  ry = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(x));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(0));
  r = vf2setxy_vf2_vf_vf_rvvm1_sleef(vsel_vf_vo_vf_vf_rvvm1_sleef(o, rx, ry), vsel_vf_vo_vf_vf_rvvm1_sleef(o, ry, rx));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(2));
  r = vf2setx_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)))));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(2));
  r = vf2sety_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(r)))));

  return r;

}

SLEEF_INLINE SLEEF_CONST vfloat2_rvvm1_sleef Sleef_sincospifx_u05rvvm1(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef o;
  vfloat_rvvm1_sleef u, s, t, rx, ry;
  vfloat2_rvvm1_sleef r, x, s2;

  u = vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(4));
  vint2_rvvm1_sleef q = vtruncate_vi2_vf_rvvm1_sleef(u);
  q = vand_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vxor_vi2_vi2_vi2_rvvm1_sleef(vsrl_vi2_vi2_i_rvvm1_sleef(q, 31), vcast_vi2_i_rvvm1_sleef(1))), vcast_vi2_i_rvvm1_sleef(~1));
  s = vsub_vf_vf_vf_rvvm1_sleef(u, vcast_vf_vi2_rvvm1_sleef(q));

  t = s;
  s = vmul_vf_vf_vf_rvvm1_sleef(s, s);
  s2 = dfmul_vf2_vf_vf_rvvm1_sleef(t, t);

  u = vcast_vf_f_rvvm1_sleef(+0.3093842054e-6);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.3657307388e-4));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.2490393585e-2));
  x = dfadd2_vf2_vf_vf2_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(u, s), vcast_vf2_f_f_rvvm1_sleef(-0.080745510756969451904, -1.3373665339076936258e-09));
  x = dfadd2_vf2_vf2_vf2_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(s2, x), vcast_vf2_f_f_rvvm1_sleef(0.78539818525314331055, -2.1857338617566484855e-08));

  x = dfmul_vf2_vf2_vf_rvvm1_sleef(x, t);
  rx = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(x));

  rx = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(-0.0f), rx);

  u = vcast_vf_f_rvvm1_sleef(-0.2430611801e-7);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.3590577080e-5));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.3259917721e-3));
  x = dfadd2_vf2_vf_vf2_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(u, s), vcast_vf2_f_f_rvvm1_sleef(0.015854343771934509277, 4.4940051354032242811e-10));
  x = dfadd2_vf2_vf2_vf2_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(s2, x), vcast_vf2_f_f_rvvm1_sleef(-0.30842512845993041992, -9.0728339030733922277e-09));

  x = dfadd2_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(x, s2), vcast_vf_f_rvvm1_sleef(1));
  ry = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(x));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(0));
  r = vf2setxy_vf2_vf_vf_rvvm1_sleef(vsel_vf_vo_vf_vf_rvvm1_sleef(o, rx, ry), vsel_vf_vo_vf_vf_rvvm1_sleef(o, ry, rx));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(4)), vcast_vi2_i_rvvm1_sleef(4));
  r = vf2setx_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)))));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(4)), vcast_vi2_i_rvvm1_sleef(4));
  r = vf2sety_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(r)))));

  o = vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(1e+7f));
  r = vf2setx_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)))));
  r = vf2sety_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(r)))));

  o = visinf_vo_vf_rvvm1_sleef(d);
  r = vf2setx_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)))));
  r = vf2sety_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(r)))));

  return r;
}

SLEEF_INLINE SLEEF_CONST vfloat2_rvvm1_sleef Sleef_sincospifx_u35rvvm1(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef o;
  vfloat_rvvm1_sleef u, s, t, rx, ry;
  vfloat2_rvvm1_sleef r;

  u = vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(4));
  vint2_rvvm1_sleef q = vtruncate_vi2_vf_rvvm1_sleef(u);
  q = vand_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vxor_vi2_vi2_vi2_rvvm1_sleef(vsrl_vi2_vi2_i_rvvm1_sleef(q, 31), vcast_vi2_i_rvvm1_sleef(1))), vcast_vi2_i_rvvm1_sleef(~1));
  s = vsub_vf_vf_vf_rvvm1_sleef(u, vcast_vf_vi2_rvvm1_sleef(q));

  t = s;
  s = vmul_vf_vf_vf_rvvm1_sleef(s, s);

  u = vcast_vf_f_rvvm1_sleef(-0.3600925265e-4);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.2490088111e-2));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.8074551076e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.7853981853e+0));

  rx = vmul_vf_vf_vf_rvvm1_sleef(u, t);

  u = vcast_vf_f_rvvm1_sleef(+0.3539815225e-5);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.3259574005e-3));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.1585431583e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(-0.3084251285e+0));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(1));

  ry = u;

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(0));
  r = vf2setxy_vf2_vf_vf_rvvm1_sleef(vsel_vf_vo_vf_vf_rvvm1_sleef(o, rx, ry), vsel_vf_vo_vf_vf_rvvm1_sleef(o, ry, rx));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(4)), vcast_vi2_i_rvvm1_sleef(4));
  r = vf2setx_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)))));

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(4)), vcast_vi2_i_rvvm1_sleef(4));
  r = vf2sety_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(r)))));

  o = vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(1e+7f));
  r = vf2setx_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)))));
  r = vf2sety_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(r)))));

  o = visinf_vo_vf_rvvm1_sleef(d);
  r = vf2setx_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)))));
  r = vf2sety_vf2_vf2_vf_rvvm1_sleef(r, vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(r)))));

  return r;
}

SLEEF_INLINE vfloat2_rvvm1_sleef Sleef_modffx_rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef fr = vsub_vf_vf_vf_rvvm1_sleef(x, vcast_vf_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(x)));
  fr = vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(INT64_C(1) << 23)), vcast_vf_f_rvvm1_sleef(0), fr);

  vfloat2_rvvm1_sleef ret;

  ret = vf2setxy_vf2_vf_vf_rvvm1_sleef(vcopysign_vf_vf_vf_rvvm1_sleef(fr, x), vcopysign_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(x, fr), x));

  return ret;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_tanfx_u10rvvm1(vfloat_rvvm1_sleef d) {

  vint2_rvvm1_sleef q;
  vfloat_rvvm1_sleef u, v;
  vfloat2_rvvm1_sleef s, t, x;
  rvv_sp_vopmask_rvvm1_sleef o;

  if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(125.0f)))), 1)) {
    u = vrint_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(2 * 0.318309886183790671537767526745028724)));
    q = vrint_vi2_vf_rvvm1_sleef(u);
    v = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-3.1414794921875f*0.5f), d);
    s = dfadd2_vf2_vf_vf_rvvm1_sleef(v, vmul_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.00011315941810607910156f*0.5f)));
    s = dfadd_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-1.9841872589410058936e-09f*0.5f)));
  } else {
    dfi_t_rvvm1_sleef dfi_rvvm1_sleef = rempif_rvvm1_sleef(d);
    q = dfigeti_vi2_dfi_rvvm1_sleef(dfi_rvvm1_sleef);
    s = dfigetdf_vf2_dfi_rvvm1_sleef(dfi_rvvm1_sleef);
    o = rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(d), visnan_vo_vf_rvvm1_sleef(d));
    s = vf2setx_vf2_vf2_vf_rvvm1_sleef(s, vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s)))));
    s = vf2sety_vf2_vf2_vf_rvvm1_sleef(s, vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(s)))));
  }

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1));
  vmask_rvvm1_sleef n = vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0)));

  s = vf2setx_vf2_vf2_vf_rvvm1_sleef(s, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s)), n)));
  s = vf2sety_vf2_vf2_vf_rvvm1_sleef(s, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(s)), n)));

  t = s;
  s = dfsqu_vf2_vf2_rvvm1_sleef(s);
  s = dfnormalize_vf2_vf2_rvvm1_sleef(s);

  u = vcast_vf_f_rvvm1_sleef(0.00446636462584137916564941f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(-8.3920182078145444393158e-05f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.0109639242291450500488281f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.0212360303848981857299805f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.0540687143802642822265625f));

  x = dfadd_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.133325666189193725585938f), vmul_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s)));
  x = dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), dfmul_vf2_vf2_vf2_rvvm1_sleef(dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.33333361148834228515625f), dfmul_vf2_vf2_vf2_rvvm1_sleef(s, x)), s));
  x = dfmul_vf2_vf2_vf2_rvvm1_sleef(t, x);

  x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, dfrec_vf2_vf2_rvvm1_sleef(x), x);

  u = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(x));

  u = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(d), d, u);

  return u;

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_atanfx_u35rvvm1(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef s, t, u;
  vint2_rvvm1_sleef q;

  q = vsel_vi2_vf_vi2_rvvm1_sleef(d, vcast_vi2_i_rvvm1_sleef(2));
  s = vabs_vf_vf_rvvm1_sleef(d);

  q = vsel_vi2_vf_vf_vi2_vi2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1.0f), s, vadd_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), q);
  s = vsel_vf_vo_vf_vf_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1.0f), s), vrec_vf_vf_rvvm1_sleef(s), s);

  t = vmul_vf_vf_vf_rvvm1_sleef(s, s);

  vfloat_rvvm1_sleef t2 = vmul_vf_vf_vf_rvvm1_sleef(t, t), t4 = vmul_vf_vf_vf_rvvm1_sleef(t2, t2);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef((t4), (vmla_vf_vf_vf_vf_rvvm1_sleef((t2), (vmla_vf_vf_vf_vf_rvvm1_sleef((t), (vcast_vf_f_rvvm1_sleef(0.00282363896258175373077393f)), (vcast_vf_f_rvvm1_sleef(-0.0159569028764963150024414f)))), (vmla_vf_vf_vf_vf_rvvm1_sleef((t), (vcast_vf_f_rvvm1_sleef(0.0425049886107444763183594f)), (vcast_vf_f_rvvm1_sleef(-0.0748900920152664184570312f)))))), (vmla_vf_vf_vf_vf_rvvm1_sleef((t2), (vmla_vf_vf_vf_vf_rvvm1_sleef((t), (vcast_vf_f_rvvm1_sleef(0.106347933411598205566406f)), (vcast_vf_f_rvvm1_sleef(-0.142027363181114196777344f)))), (vmla_vf_vf_vf_vf_rvvm1_sleef((t), (vcast_vf_f_rvvm1_sleef(0.199926957488059997558594f)), (vcast_vf_f_rvvm1_sleef(-0.333331018686294555664062f)))))))

                                         ;

  t = vmla_vf_vf_vf_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(t, u), s);

  t = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1)), vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef((float)(3.141592653589793238462643383279502884/2)), t), t);

  t = vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(2)), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0f))), vreinterpret_vm_vf_rvvm1_sleef(t)));

  return t;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef atan2kf_rvvm1_sleef(vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef s, t, u;
  vint2_rvvm1_sleef q;
  rvv_sp_vopmask_rvvm1_sleef p;

  q = vsel_vi2_vf_vi2_rvvm1_sleef(x, vcast_vi2_i_rvvm1_sleef(-2));
  x = vabs_vf_vf_rvvm1_sleef(x);

  q = vsel_vi2_vf_vf_vi2_vi2_rvvm1_sleef(x, y, vadd_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), q);
  p = vlt_vo_vf_vf_rvvm1_sleef(x, y);
  s = vsel_vf_vo_vf_vf_rvvm1_sleef(p, vneg_vf_vf_rvvm1_sleef(x), y);
  t = vmax_vf_vf_vf_rvvm1_sleef(x, y);

  s = vdiv_vf_vf_vf_rvvm1_sleef(s, t);
  t = vmul_vf_vf_vf_rvvm1_sleef(s, s);

  vfloat_rvvm1_sleef t2 = vmul_vf_vf_vf_rvvm1_sleef(t, t), t4 = vmul_vf_vf_vf_rvvm1_sleef(t2, t2);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef((t4), (vmla_vf_vf_vf_vf_rvvm1_sleef((t2), (vmla_vf_vf_vf_vf_rvvm1_sleef((t), (vcast_vf_f_rvvm1_sleef(0.00282363896258175373077393f)), (vcast_vf_f_rvvm1_sleef(-0.0159569028764963150024414f)))), (vmla_vf_vf_vf_vf_rvvm1_sleef((t), (vcast_vf_f_rvvm1_sleef(0.0425049886107444763183594f)), (vcast_vf_f_rvvm1_sleef(-0.0748900920152664184570312f)))))), (vmla_vf_vf_vf_vf_rvvm1_sleef((t2), (vmla_vf_vf_vf_vf_rvvm1_sleef((t), (vcast_vf_f_rvvm1_sleef(0.106347933411598205566406f)), (vcast_vf_f_rvvm1_sleef(-0.142027363181114196777344f)))), (vmla_vf_vf_vf_vf_rvvm1_sleef((t), (vcast_vf_f_rvvm1_sleef(0.199926957488059997558594f)), (vcast_vf_f_rvvm1_sleef(-0.333331018686294555664062f)))))))

                                         ;

  t = vmla_vf_vf_vf_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(t, u), s);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef((float)(3.141592653589793238462643383279502884/2)), t);

  return t;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef visinf2_vf_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef d, vfloat_rvvm1_sleef m) {
  return vreinterpret_vf_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(d), vor_vm_vm_vm_rvvm1_sleef(vsignbit_vm_vf_rvvm1_sleef(d), vreinterpret_vm_vf_rvvm1_sleef(m))));
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_atan2fx_u35rvvm1(vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef r = atan2kf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(y), x);

  r = vmulsign_vf_vf_vf_rvvm1_sleef(r, x);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(x), veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0.0f))), vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef((float)(3.141592653589793238462643383279502884/2)), visinf2_vf_vf_vf_rvvm1_sleef(x, vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef((float)(3.141592653589793238462643383279502884/2)), x))), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(y), vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef((float)(3.141592653589793238462643383279502884/2)), visinf2_vf_vf_vf_rvvm1_sleef(x, vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef((float)(3.141592653589793238462643383279502884/4)), x))), r);

  r = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(0.0f)), vreinterpret_vf_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(vsignbit_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef((float)3.141592653589793238462643383279502884)))), r);

  r = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visnan_vo_vf_rvvm1_sleef(x), visnan_vo_vf_rvvm1_sleef(y)), vreinterpret_vm_vf_rvvm1_sleef(vmulsign_vf_vf_vf_rvvm1_sleef(r, y))));
  return r;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_asinfx_u35rvvm1(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(0.5f));
  vfloat_rvvm1_sleef x2 = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, d), vmul_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), vabs_vf_vf_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(0.5f)));
  vfloat_rvvm1_sleef x = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vabs_vf_vf_rvvm1_sleef(d), vsqrt_vf_vf_rvvm1_sleef(x2)), u;

  u = vcast_vf_f_rvvm1_sleef(+0.4197454825e-1);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.2424046025e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.4547423869e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.7495029271e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.1666677296e+0));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vmul_vf_vf_vf_rvvm1_sleef(x, x2), x);

  vfloat_rvvm1_sleef r = vsel_vf_vo_vf_vf_rvvm1_sleef(o, u, vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-2), vcast_vf_f_rvvm1_sleef(((float)3.141592653589793238462643383279502884)/2)));
  return vmulsign_vf_vf_vf_rvvm1_sleef(r, d);
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_acosfx_u35rvvm1(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(0.5f));
  vfloat_rvvm1_sleef x2 = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, d),
                                vmul_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), vabs_vf_vf_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(0.5f))), u;
  vfloat_rvvm1_sleef x = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vabs_vf_vf_rvvm1_sleef(d), vsqrt_vf_vf_rvvm1_sleef(x2));
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(1.0f)), vcast_vf_f_rvvm1_sleef(0), x);

  u = vcast_vf_f_rvvm1_sleef(+0.4197454825e-1);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.2424046025e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.4547423869e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.7495029271e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.1666677296e+0));
  u = vmul_vf_vf_vf_rvvm1_sleef(u, vmul_vf_vf_vf_rvvm1_sleef(x2, x));

  vfloat_rvvm1_sleef y = vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(3.1415926535897932f/2), vadd_vf_vf_vf_rvvm1_sleef(vmulsign_vf_vf_vf_rvvm1_sleef(x, d), vmulsign_vf_vf_vf_rvvm1_sleef(u, d)));
  x = vadd_vf_vf_vf_rvvm1_sleef(x, u);
  vfloat_rvvm1_sleef r = vsel_vf_vo_vf_vf_rvvm1_sleef(o, y, vmul_vf_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(2)));
  return vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vandnot_vo_vo_vo(o, vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0))),
                          vf2getx_vf_vf2_rvvm1_sleef(dfadd_vf2_vf2_vf_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(3.1415927410125732422f,-8.7422776573475857731e-08f),
                                                          vneg_vf_vf_rvvm1_sleef(r))), r);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef atan2kf_u1_rvvm1_sleef(vfloat2_rvvm1_sleef y, vfloat2_rvvm1_sleef x) {
  vfloat_rvvm1_sleef u;
  vfloat2_rvvm1_sleef s, t;
  vint2_rvvm1_sleef q;
  rvv_sp_vopmask_rvvm1_sleef p;
  vmask_rvvm1_sleef r;

  q = vsel_vi2_vf_vf_vi2_vi2_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(0), vcast_vi2_i_rvvm1_sleef(-2), vcast_vi2_i_rvvm1_sleef(0));
  p = vlt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(0));
  r = vand_vm_vo32_vm_rvvm1_sleef(p, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0)));
  x = vf2setx_vf2_vf2_vf_rvvm1_sleef(x, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x)), r)));
  x = vf2sety_vf2_vf2_vf_rvvm1_sleef(x, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(x)), r)));

  q = vsel_vi2_vf_vf_vi2_vi2_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y), vadd_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(1)), q);
  p = vlt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(y));
  s = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(p, dfneg_vf2_vf2_rvvm1_sleef(x), y);
  t = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(p, y, x);

  s = dfdiv_vf2_vf2_vf2_rvvm1_sleef(s, t);
  t = dfsqu_vf2_vf2_rvvm1_sleef(s);
  t = dfnormalize_vf2_vf2_rvvm1_sleef(t);

  u = vcast_vf_f_rvvm1_sleef(-0.00176397908944636583328247f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(t), vcast_vf_f_rvvm1_sleef(0.0107900900766253471374512f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(t), vcast_vf_f_rvvm1_sleef(-0.0309564601629972457885742f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(t), vcast_vf_f_rvvm1_sleef(0.0577365085482597351074219f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(t), vcast_vf_f_rvvm1_sleef(-0.0838950723409652709960938f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(t), vcast_vf_f_rvvm1_sleef(0.109463557600975036621094f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(t), vcast_vf_f_rvvm1_sleef(-0.142626821994781494140625f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(t), vcast_vf_f_rvvm1_sleef(0.199983194470405578613281f));

  t = dfmul_vf2_vf2_vf2_rvvm1_sleef(t, dfadd_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.333332866430282592773438f), vmul_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(t))));
  t = dfmul_vf2_vf2_vf2_rvvm1_sleef(s, dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), t));
  t = dfadd_vf2_vf2_vf2_rvvm1_sleef(dfmul_vf2_vf2_vf_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(1.5707963705062866211f, -4.3711388286737928865e-08f), vcast_vf_vi2_rvvm1_sleef(q)), t);

  return t;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_atan2fx_u10rvvm1(vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef x) {
  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(2.9387372783541830947e-39f));
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(1 << 24)), x);
  y = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(1 << 24)), y);

  vfloat2_rvvm1_sleef d = atan2kf_u1_rvvm1_sleef(vcast_vf2_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(y), vcast_vf_f_rvvm1_sleef(0)), vcast_vf2_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0)));
  vfloat_rvvm1_sleef r = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d));

  r = vmulsign_vf_vf_vf_rvvm1_sleef(r, x);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(x), veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0))), vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(3.141592653589793238462643383279502884/2), visinf2_vf_vf_vf_rvvm1_sleef(x, vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(3.141592653589793238462643383279502884/2), x))), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(y), vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(3.141592653589793238462643383279502884/2), visinf2_vf_vf_vf_rvvm1_sleef(x, vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(3.141592653589793238462643383279502884/4), x))), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(0.0f)), vreinterpret_vf_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(vsignbit_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef((float)3.141592653589793238462643383279502884)))), r);

  r = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visnan_vo_vf_rvvm1_sleef(x), visnan_vo_vf_rvvm1_sleef(y)), vreinterpret_vm_vf_rvvm1_sleef(vmulsign_vf_vf_vf_rvvm1_sleef(r, y))));
  return r;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_asinfx_u10rvvm1(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(0.5f));
  vfloat_rvvm1_sleef x2 = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, d), vmul_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), vabs_vf_vf_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(0.5f))), u;
  vfloat2_rvvm1_sleef x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, vcast_vf2_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(0)), dfsqrt_vf2_vf_rvvm1_sleef(x2));
  x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(1.0f)), vcast_vf2_f_f_rvvm1_sleef(0, 0), x);

  u = vcast_vf_f_rvvm1_sleef(+0.4197454825e-1);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.2424046025e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.4547423869e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.7495029271e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.1666677296e+0));
  u = vmul_vf_vf_vf_rvvm1_sleef(u, vmul_vf_vf_vf_rvvm1_sleef(x2, vf2getx_vf_vf2_rvvm1_sleef(x)));

  vfloat2_rvvm1_sleef y = dfsub_vf2_vf2_vf_rvvm1_sleef(dfsub_vf2_vf2_vf2_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(3.1415927410125732422f/4,-8.7422776573475857731e-08f/4), x), u);

  vfloat_rvvm1_sleef r = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vadd_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(x)),
                               vmul_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(y), vf2gety_vf_vf2_rvvm1_sleef(y)), vcast_vf_f_rvvm1_sleef(2)));
  return vmulsign_vf_vf_vf_rvvm1_sleef(r, d);
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_acosfx_u10rvvm1(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(0.5f));
  vfloat_rvvm1_sleef x2 = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, d), vmul_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), vabs_vf_vf_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(0.5f))), u;
  vfloat2_rvvm1_sleef x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, vcast_vf2_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(0)), dfsqrt_vf2_vf_rvvm1_sleef(x2));
  x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(1.0f)), vcast_vf2_f_f_rvvm1_sleef(0, 0), x);

  u = vcast_vf_f_rvvm1_sleef(+0.4197454825e-1);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.2424046025e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.4547423869e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.7495029271e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, x2, vcast_vf_f_rvvm1_sleef(+0.1666677296e+0));
  u = vmul_vf_vf_vf_rvvm1_sleef(u, vmul_vf_vf_vf_rvvm1_sleef(x2, vf2getx_vf_vf2_rvvm1_sleef(x)));

  vfloat2_rvvm1_sleef y = dfsub_vf2_vf2_vf2_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(3.1415927410125732422f/2, -8.7422776573475857731e-08f/2),
                                 dfadd_vf2_vf_vf_rvvm1_sleef(vmulsign_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), d), vmulsign_vf_vf_vf_rvvm1_sleef(u, d)));
  x = dfadd_vf2_vf2_vf_rvvm1_sleef(x, u);

  y = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, y, dfscale_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(2)));

  y = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(rvv_sp_vandnot_vo_vo_vo(o, vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0))),
                          dfsub_vf2_vf2_vf2_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(3.1415927410125732422f, -8.7422776573475857731e-08f), y), y);

  return vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(y), vf2gety_vf_vf2_rvvm1_sleef(y));
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_atanfx_u10rvvm1(vfloat_rvvm1_sleef d) {
  vfloat2_rvvm1_sleef d2 = atan2kf_u1_rvvm1_sleef(vcast_vf2_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(0)), vcast_vf2_f_f_rvvm1_sleef(1, 0));
  vfloat_rvvm1_sleef r = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d2), vf2gety_vf_vf2_rvvm1_sleef(d2));
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(1.570796326794896557998982), r);
  return vmulsign_vf_vf_vf_rvvm1_sleef(r, d);
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_logfx_u35rvvm1(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef x, x2, t, m;

  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0x1p-126));
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)(INT64_C(1) << 32) * (float)(INT64_C(1) << 32))), d);
  vint2_rvvm1_sleef e = vilogb2k_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.0f/0.75f)));
  m = vldexp3_vf_vf_vi2_rvvm1_sleef(d, vneg_vi2_vi2_rvvm1_sleef(e));
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(o, vsub_vi2_vi2_vi2_rvvm1_sleef(e, vcast_vi2_i_rvvm1_sleef(64)), e);

  x = vdiv_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(m, vcast_vf_f_rvvm1_sleef(1.0f)), vadd_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1.0f), m));
  x2 = vmul_vf_vf_vf_rvvm1_sleef(x, x);

  t = vcast_vf_f_rvvm1_sleef(0.2392828464508056640625f);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(0.28518211841583251953125f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(0.400005877017974853515625f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(0.666666686534881591796875f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(2.0f));

  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, t, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.693147180559945286226764f), vcast_vf_vi2_rvvm1_sleef(e)));
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(vispinf_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(__builtin_inff()), x);
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), visnan_vo_vf_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), x);
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(-__builtin_inff()), x);

  return x;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_expfx_u10rvvm1(vfloat_rvvm1_sleef d) {
  vint2_rvvm1_sleef q = vrint_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.442695040888963407359924681001892137426645954152985934135449406931f)));
  vfloat_rvvm1_sleef s, u;

  s = vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(-0.693145751953125f), d);
  s = vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(-1.428606765330187045e-06f), s);

  u = vcast_vf_f_rvvm1_sleef(0.000198527617612853646278381);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.00139304355252534151077271));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.00833336077630519866943359));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.0416664853692054748535156));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.166666671633720397949219));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.5));

  u = vadd_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1.0f), vmla_vf_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(s, s), u, s));

  u = vldexp2_vf_vf_vi2_rvvm1_sleef(u, q);

  u = vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(-104)), vreinterpret_vm_vf_rvvm1_sleef(u)));
  u = vsel_vf_vo_vf_vf_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(100), d), vcast_vf_f_rvvm1_sleef(__builtin_inff()), u);

  return u;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef expm1fk_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  vint2_rvvm1_sleef q = vrint_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.442695040888963407359924681001892137426645954152985934135449406931f)));
  vfloat_rvvm1_sleef s, u;

  s = vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(-0.693145751953125f), d);
  s = vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(-1.428606765330187045e-06f), s);

  vfloat_rvvm1_sleef s2 = vmul_vf_vf_vf_rvvm1_sleef(s, s), s4 = vmul_vf_vf_vf_rvvm1_sleef(s2, s2);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef((s4), (vmla_vf_vf_vf_vf_rvvm1_sleef((s), (vcast_vf_f_rvvm1_sleef(0.000198527617612853646278381)), (vcast_vf_f_rvvm1_sleef(0.00139304355252534151077271)))), (vmla_vf_vf_vf_vf_rvvm1_sleef((s2), (vmla_vf_vf_vf_vf_rvvm1_sleef((s), (vcast_vf_f_rvvm1_sleef(0.00833336077630519866943359)), (vcast_vf_f_rvvm1_sleef(0.0416664853692054748535156)))), (vmla_vf_vf_vf_vf_rvvm1_sleef((s), (vcast_vf_f_rvvm1_sleef(0.166666671633720397949219)), (vcast_vf_f_rvvm1_sleef(0.5)))))))

                ;

  u = vmla_vf_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(s, s), u, s);

  u = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(0)), u,
                       vsub_vf_vf_vf_rvvm1_sleef(vldexp2_vf_vf_vi2_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(1)), q), vcast_vf_f_rvvm1_sleef(1)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_sqrtfx_u35rvvm1(vfloat_rvvm1_sleef d) { return vsqrt_vf_vf_rvvm1_sleef(d); }

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_cbrtfx_u35rvvm1(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef x, y, q = vcast_vf_f_rvvm1_sleef(1.0), t;
  vint2_rvvm1_sleef e, qu, re;

  e = vadd_vi2_vi2_vi2_rvvm1_sleef(vilogbk_vi2_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d)), vcast_vi2_i_rvvm1_sleef(1));
  d = vldexp2_vf_vf_vi2_rvvm1_sleef(d, vneg_vi2_vi2_rvvm1_sleef(e));

  t = vadd_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(e), vcast_vf_f_rvvm1_sleef(6144));
  qu = vtruncate_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(t, vcast_vf_f_rvvm1_sleef(1.0f/3.0f)));
  re = vtruncate_vi2_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(t, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(qu), vcast_vf_f_rvvm1_sleef(3))));

  q = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(re, vcast_vi2_i_rvvm1_sleef(1)), vcast_vf_f_rvvm1_sleef(1.2599210498948731647672106f), q);
  q = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(re, vcast_vi2_i_rvvm1_sleef(2)), vcast_vf_f_rvvm1_sleef(1.5874010519681994747517056f), q);
  q = vldexp2_vf_vf_vi2_rvvm1_sleef(q, vsub_vi2_vi2_vi2_rvvm1_sleef(qu, vcast_vi2_i_rvvm1_sleef(2048)));

  q = vmulsign_vf_vf_vf_rvvm1_sleef(q, d);
  d = vabs_vf_vf_rvvm1_sleef(d);

  x = vcast_vf_f_rvvm1_sleef(-0.601564466953277587890625f);
  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, d, vcast_vf_f_rvvm1_sleef(2.8208892345428466796875f));
  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, d, vcast_vf_f_rvvm1_sleef(-5.532182216644287109375f));
  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, d, vcast_vf_f_rvvm1_sleef(5.898262500762939453125f));
  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, d, vcast_vf_f_rvvm1_sleef(-3.8095417022705078125f));
  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, d, vcast_vf_f_rvvm1_sleef(2.2241256237030029296875f));

  y = vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, x), x);
  y = vmul_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(y, vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(2.0f / 3.0f), y), vmla_vf_vf_vf_vf_rvvm1_sleef(y, x, vcast_vf_f_rvvm1_sleef(-1.0f)))), q);

  return y;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_cbrtfx_u10rvvm1(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef x, y, z, t;
  vfloat2_rvvm1_sleef q2 = vcast_vf2_f_f_rvvm1_sleef(1, 0), u, v;
  vint2_rvvm1_sleef e, qu, re;

  e = vadd_vi2_vi2_vi2_rvvm1_sleef(vilogbk_vi2_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d)), vcast_vi2_i_rvvm1_sleef(1));
  d = vldexp2_vf_vf_vi2_rvvm1_sleef(d, vneg_vi2_vi2_rvvm1_sleef(e));

  t = vadd_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(e), vcast_vf_f_rvvm1_sleef(6144));
  qu = vtruncate_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(t, vcast_vf_f_rvvm1_sleef(1.0/3.0)));
  re = vtruncate_vi2_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(t, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(qu), vcast_vf_f_rvvm1_sleef(3))));

  q2 = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(re, vcast_vi2_i_rvvm1_sleef(1)), vcast_vf2_f_f_rvvm1_sleef(1.2599210739135742188f, -2.4018701694217270415e-08), q2);
  q2 = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(veq_vo_vi2_vi2_rvvm1_sleef(re, vcast_vi2_i_rvvm1_sleef(2)), vcast_vf2_f_f_rvvm1_sleef(1.5874010324478149414f, 1.9520385308169352356e-08), q2);

  q2 = vf2setx_vf2_vf2_vf_rvvm1_sleef(q2, vmulsign_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(q2), d));
  q2 = vf2sety_vf2_vf2_vf_rvvm1_sleef(q2, vmulsign_vf_vf_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(q2), d));
  d = vabs_vf_vf_rvvm1_sleef(d);

  x = vcast_vf_f_rvvm1_sleef(-0.601564466953277587890625f);
  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, d, vcast_vf_f_rvvm1_sleef(2.8208892345428466796875f));
  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, d, vcast_vf_f_rvvm1_sleef(-5.532182216644287109375f));
  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, d, vcast_vf_f_rvvm1_sleef(5.898262500762939453125f));
  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, d, vcast_vf_f_rvvm1_sleef(-3.8095417022705078125f));
  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, d, vcast_vf_f_rvvm1_sleef(2.2241256237030029296875f));

  y = vmul_vf_vf_vf_rvvm1_sleef(x, x); y = vmul_vf_vf_vf_rvvm1_sleef(y, y); x = vsub_vf_vf_vf_rvvm1_sleef(x, vmul_vf_vf_vf_rvvm1_sleef(vmlanp_vf_vf_vf_vf_rvvm1_sleef(d, y, x), vcast_vf_f_rvvm1_sleef(-1.0 / 3.0)));

  z = x;

  u = dfmul_vf2_vf_vf_rvvm1_sleef(x, x);
  u = dfmul_vf2_vf2_vf2_rvvm1_sleef(u, u);
  u = dfmul_vf2_vf2_vf_rvvm1_sleef(u, d);
  u = dfadd2_vf2_vf2_vf_rvvm1_sleef(u, vneg_vf_vf_rvvm1_sleef(x));
  y = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(u), vf2gety_vf_vf2_rvvm1_sleef(u));

  y = vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-2.0 / 3.0), y), z);
  v = dfadd2_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf_vf_rvvm1_sleef(z, z), y);
  v = dfmul_vf2_vf2_vf_rvvm1_sleef(v, d);
  v = dfmul_vf2_vf2_vf2_rvvm1_sleef(v, q2);
  z = vldexp2_vf_vf_vi2_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(v), vf2gety_vf_vf2_rvvm1_sleef(v)), vsub_vi2_vi2_vi2_rvvm1_sleef(qu, vcast_vi2_i_rvvm1_sleef(2048)));

  z = vsel_vf_vo_vf_vf_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(d), vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(__builtin_inff()), vf2getx_vf_vf2_rvvm1_sleef(q2)), z);
  z = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), vreinterpret_vf_vm_rvvm1_sleef(vsignbit_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(q2))), z);

  return z;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef logkf_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  vfloat2_rvvm1_sleef x, x2;
  vfloat_rvvm1_sleef t, m;

  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0x1p-126));
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)(INT64_C(1) << 32) * (float)(INT64_C(1) << 32))), d);
  vint2_rvvm1_sleef e = vilogb2k_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.0f/0.75f)));
  m = vldexp3_vf_vf_vi2_rvvm1_sleef(d, vneg_vi2_vi2_rvvm1_sleef(e));
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(o, vsub_vi2_vi2_vi2_rvvm1_sleef(e, vcast_vi2_i_rvvm1_sleef(64)), e);

  x = dfdiv_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-1), m), dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), m));
  x2 = dfsqu_vf2_vf2_rvvm1_sleef(x);

  t = vcast_vf_f_rvvm1_sleef(0.240320354700088500976562);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(x2), vcast_vf_f_rvvm1_sleef(0.285112679004669189453125));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(x2), vcast_vf_f_rvvm1_sleef(0.400007992982864379882812));
  vfloat2_rvvm1_sleef c = vcast_vf2_f_f_rvvm1_sleef(0.66666662693023681640625f, 3.69183861259614332084311e-09f);

  vfloat2_rvvm1_sleef s = dfmul_vf2_vf2_vf_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(0.69314718246459960938f, -1.904654323148236017e-09f), vcast_vf_vi2_rvvm1_sleef(e));

  s = dfadd_vf2_vf2_vf2_rvvm1_sleef(s, dfscale_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(2)));
  s = dfadd_vf2_vf2_vf2_rvvm1_sleef(s, dfmul_vf2_vf2_vf2_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(x2, x),
                                             dfadd2_vf2_vf2_vf2_rvvm1_sleef(dfmul_vf2_vf2_vf_rvvm1_sleef(x2, t), c)));
  return s;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef logk3f_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef x, x2, t, m;

  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0x1p-126));
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)(INT64_C(1) << 32) * (float)(INT64_C(1) << 32))), d);
  vint2_rvvm1_sleef e = vilogb2k_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.0f/0.75f)));
  m = vldexp3_vf_vf_vi2_rvvm1_sleef(d, vneg_vi2_vi2_rvvm1_sleef(e));
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(o, vsub_vi2_vi2_vi2_rvvm1_sleef(e, vcast_vi2_i_rvvm1_sleef(64)), e);

  x = vdiv_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(m, vcast_vf_f_rvvm1_sleef(1.0f)), vadd_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1.0f), m));
  x2 = vmul_vf_vf_vf_rvvm1_sleef(x, x);

  t = vcast_vf_f_rvvm1_sleef(0.2392828464508056640625f);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(0.28518211841583251953125f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(0.400005877017974853515625f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(0.666666686534881591796875f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(2.0f));

  x = vmla_vf_vf_vf_vf_rvvm1_sleef(x, t, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.693147180559945286226764f), vcast_vf_vi2_rvvm1_sleef(e)));

  return x;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_logfx_u10rvvm1(vfloat_rvvm1_sleef d) {
  vfloat2_rvvm1_sleef x;
  vfloat_rvvm1_sleef t, m, x2;

  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0x1p-126));
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)(INT64_C(1) << 32) * (float)(INT64_C(1) << 32))), d);
  vint2_rvvm1_sleef e = vilogb2k_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.0f/0.75f)));
  m = vldexp3_vf_vf_vi2_rvvm1_sleef(d, vneg_vi2_vi2_rvvm1_sleef(e));
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(o, vsub_vi2_vi2_vi2_rvvm1_sleef(e, vcast_vi2_i_rvvm1_sleef(64)), e);
  vfloat2_rvvm1_sleef s = dfmul_vf2_vf2_vf_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(0.69314718246459960938f, -1.904654323148236017e-09f), vcast_vf_vi2_rvvm1_sleef(e));

  x = dfdiv_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-1), m), dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), m));
  x2 = vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(x));

  t = vcast_vf_f_rvvm1_sleef(+0.3027294874e+0f);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(+0.3996108174e+0f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(+0.6666694880e+0f));

  s = dfadd_vf2_vf2_vf2_rvvm1_sleef(s, dfscale_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(2)));
  s = dfadd_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(x2, vf2getx_vf_vf2_rvvm1_sleef(x)), t));

  vfloat_rvvm1_sleef r = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s), vf2gety_vf_vf2_rvvm1_sleef(s));

  r = vsel_vf_vo_vf_vf_rvvm1_sleef(vispinf_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(__builtin_inff()), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), visnan_vo_vf_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(-__builtin_inff()), r);

  return r;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef expkf_rvvm1_sleef(vfloat2_rvvm1_sleef d) {
  vfloat_rvvm1_sleef u = vmul_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(1.442695040888963407359924681001892137426645954152985934135449406931f));
  vint2_rvvm1_sleef q = vrint_vi2_vf_rvvm1_sleef(u);
  vfloat2_rvvm1_sleef s, t;

  s = dfadd2_vf2_vf2_vf_rvvm1_sleef(d, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(-0.693145751953125f)));
  s = dfadd2_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(-1.428606765330187045e-06f)));

  s = dfnormalize_vf2_vf2_rvvm1_sleef(s);

  u = vcast_vf_f_rvvm1_sleef(0.00136324646882712841033936f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.00836596917361021041870117f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.0416710823774337768554688f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.166665524244308471679688f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(0.499999850988388061523438f));

  t = dfadd_vf2_vf2_vf2_rvvm1_sleef(s, dfmul_vf2_vf2_vf_rvvm1_sleef(dfsqu_vf2_vf2_rvvm1_sleef(s), u));

  t = dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), t);
  u = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(t), vf2gety_vf_vf2_rvvm1_sleef(t));
  u = vldexp_vf_vf_vi2_rvvm1_sleef(u, q);

  u = vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(-104)), vreinterpret_vm_vf_rvvm1_sleef(u)));

  return u;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef expk3f_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  vint2_rvvm1_sleef q = vrint_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.442695040888963407359924681001892137426645954152985934135449406931f)));
  vfloat_rvvm1_sleef s, u;

  s = vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(-0.693145751953125f), d);
  s = vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(-1.428606765330187045e-06f), s);

  u = vcast_vf_f_rvvm1_sleef(0.000198527617612853646278381);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.00139304355252534151077271));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.00833336077630519866943359));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.0416664853692054748535156));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.166666671633720397949219));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(0.5));

  u = vmla_vf_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(s, s), u, vadd_vf_vf_vf_rvvm1_sleef(s, vcast_vf_f_rvvm1_sleef(1.0f)));
  u = vldexp2_vf_vf_vi2_rvvm1_sleef(u, q);

  u = vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(-104)), vreinterpret_vm_vf_rvvm1_sleef(u)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_powfx_u10rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {

  rvv_sp_vopmask_rvvm1_sleef yisint = rvv_sp_vor_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(vtruncate_vf_vf_rvvm1_sleef(y), y), vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(y), vcast_vf_f_rvvm1_sleef(1 << 24)));
  rvv_sp_vopmask_rvvm1_sleef yisodd = rvv_sp_vand_vo_vo_vo(rvv_sp_vand_vo_vo_vo(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(y), vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1)), yisint),
                                 vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(y), vcast_vf_f_rvvm1_sleef(1 << 24)));

  vfloat_rvvm1_sleef result = expkf_rvvm1_sleef(dfmul_vf2_vf2_vf_rvvm1_sleef(logkf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x)), y));

  result = vsel_vf_vo_vf_vf_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(result), vcast_vf_f_rvvm1_sleef(__builtin_inff()), result);

  result = vmul_vf_vf_vf_rvvm1_sleef(result,
                         vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0)),
                                          vcast_vf_f_rvvm1_sleef(1),
                                          vsel_vf_vo_vf_vf_rvvm1_sleef(yisint, vsel_vf_vo_vf_vf_rvvm1_sleef(yisodd, vcast_vf_f_rvvm1_sleef(-1.0f), vcast_vf_f_rvvm1_sleef(1)), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")))));

  vfloat_rvvm1_sleef efx = vmulsign_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(1)), y);

  result = vsel_vf_vo_vf_vf_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(y),
                            vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(efx, vcast_vf_f_rvvm1_sleef(0.0f)),
                                                                  vreinterpret_vm_vf_rvvm1_sleef(vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(efx, vcast_vf_f_rvvm1_sleef(0.0f)),
                                                                                                      vcast_vf_f_rvvm1_sleef(1.0f),
                                                                                                      vcast_vf_f_rvvm1_sleef(__builtin_inff()))))),
                            result);

  result = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(x), veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0.0))),
                            vmulsign_vf_vf_vf_rvvm1_sleef(vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vxor_vo_vo_vo(vsignbit_vo_vf_rvvm1_sleef(y), veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0.0f))),
                                                               vcast_vf_f_rvvm1_sleef(0), vcast_vf_f_rvvm1_sleef(__builtin_inff())),
                                              vsel_vf_vo_vf_vf_rvvm1_sleef(yisodd, x, vcast_vf_f_rvvm1_sleef(1))), result);

  result = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visnan_vo_vf_rvvm1_sleef(x), visnan_vo_vf_rvvm1_sleef(y)), vreinterpret_vm_vf_rvvm1_sleef(result)));

  result = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(0)), veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(1))), vcast_vf_f_rvvm1_sleef(1), result);

  return result;

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_fastpowfx_u3500rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef result = expk3f_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(logk3f_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x)), y));
  rvv_sp_vopmask_rvvm1_sleef yisint = rvv_sp_vor_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(vtruncate_vf_vf_rvvm1_sleef(y), y), vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(y), vcast_vf_f_rvvm1_sleef(1 << 24)));
  rvv_sp_vopmask_rvvm1_sleef yisodd = rvv_sp_vand_vo_vo_vo(rvv_sp_vand_vo_vo_vo(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(y), vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1)), yisint),
                                 vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(y), vcast_vf_f_rvvm1_sleef(1 << 24)));

  result = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vand_vo_vo_vo(vsignbit_vo_vf_rvvm1_sleef(x), yisodd), vneg_vf_vf_rvvm1_sleef(result), result);

  result = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(0), result);
  result = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(1), result);

  return result;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef expk2f_rvvm1_sleef(vfloat2_rvvm1_sleef d) {
  vfloat_rvvm1_sleef u = vmul_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(1.442695040888963407359924681001892137426645954152985934135449406931f));
  vint2_rvvm1_sleef q = vrint_vi2_vf_rvvm1_sleef(u);
  vfloat2_rvvm1_sleef s, t;

  s = dfadd2_vf2_vf2_vf_rvvm1_sleef(d, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(-0.693145751953125f)));
  s = dfadd2_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(-1.428606765330187045e-06f)));

  u = vcast_vf_f_rvvm1_sleef(+0.1980960224e-3f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(+0.1394256484e-2f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(+0.8333456703e-2f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vf2getx_vf_vf2_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(+0.4166637361e-1f));

  t = dfadd2_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf2_vf_rvvm1_sleef(s, u), vcast_vf_f_rvvm1_sleef(+0.166666659414234244790680580464e+0f));
  t = dfadd2_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(s, t), vcast_vf_f_rvvm1_sleef(0.5));
  t = dfadd2_vf2_vf2_vf2_rvvm1_sleef(s, dfmul_vf2_vf2_vf2_rvvm1_sleef(dfsqu_vf2_vf2_rvvm1_sleef(s), t));

  t = dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), t);

  t = vf2setx_vf2_vf2_vf_rvvm1_sleef(t, vldexp2_vf_vf_vi2_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(t), q));
  t = vf2sety_vf2_vf2_vf_rvvm1_sleef(t, vldexp2_vf_vf_vi2_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(t), q));

  t = vf2setx_vf2_vf2_vf_rvvm1_sleef(t, vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(-104)), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(t)))));
  t = vf2sety_vf2_vf2_vf_rvvm1_sleef(t, vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(-104)), vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(t)))));

  return t;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_sinhfx_u10rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef y = vabs_vf_vf_rvvm1_sleef(x);
  vfloat2_rvvm1_sleef d = expk2f_rvvm1_sleef(vcast_vf2_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(0)));
  d = dfsub_vf2_vf2_vf2_rvvm1_sleef(d, dfrec_vf2_vf2_rvvm1_sleef(d));
  y = vmul_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(0.5));

  y = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(89)),
                                    visnan_vo_vf_rvvm1_sleef(y)), vcast_vf_f_rvvm1_sleef(__builtin_inff()), y);
  y = vmulsign_vf_vf_vf_rvvm1_sleef(y, x);
  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_coshfx_u10rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef y = vabs_vf_vf_rvvm1_sleef(x);
  vfloat2_rvvm1_sleef d = expk2f_rvvm1_sleef(vcast_vf2_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(0)));
  d = dfadd_vf2_vf2_vf2_rvvm1_sleef(d, dfrec_vf2_vf2_rvvm1_sleef(d));
  y = vmul_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(0.5));

  y = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(89)),
                                    visnan_vo_vf_rvvm1_sleef(y)), vcast_vf_f_rvvm1_sleef(__builtin_inff()), y);
  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_tanhfx_u10rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef y = vabs_vf_vf_rvvm1_sleef(x);
  vfloat2_rvvm1_sleef d = expk2f_rvvm1_sleef(vcast_vf2_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(0)));
  vfloat2_rvvm1_sleef e = dfrec_vf2_vf2_rvvm1_sleef(d);
  d = dfdiv_vf2_vf2_vf2_rvvm1_sleef(dfadd_vf2_vf2_vf2_rvvm1_sleef(d, dfneg_vf2_vf2_rvvm1_sleef(e)), dfadd_vf2_vf2_vf2_rvvm1_sleef(d, e));
  y = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d));

  y = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(8.664339742f)),
                                    visnan_vo_vf_rvvm1_sleef(y)), vcast_vf_f_rvvm1_sleef(1.0f), y);
  y = vmulsign_vf_vf_vf_rvvm1_sleef(y, x);
  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_sinhfx_u35rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef e = expm1fk_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x));
  vfloat_rvvm1_sleef y = vdiv_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(e, vcast_vf_f_rvvm1_sleef(2)), vadd_vf_vf_vf_rvvm1_sleef(e, vcast_vf_f_rvvm1_sleef(1)));
  y = vmul_vf_vf_vf_rvvm1_sleef(y, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.5f), e));

  y = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(88)),
                                    visnan_vo_vf_rvvm1_sleef(y)), vcast_vf_f_rvvm1_sleef(__builtin_inff()), y);
  y = vmulsign_vf_vf_vf_rvvm1_sleef(y, x);
  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_coshfx_u35rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef e = Sleef_expfx_u10rvvm1(vabs_vf_vf_rvvm1_sleef(x));
  vfloat_rvvm1_sleef y = vmla_vf_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.5f), e, vdiv_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.5), e));

  y = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(88)),
                                    visnan_vo_vf_rvvm1_sleef(y)), vcast_vf_f_rvvm1_sleef(__builtin_inff()), y);
  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_tanhfx_u35rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef d = expm1fk_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(2), vabs_vf_vf_rvvm1_sleef(x)));
  vfloat_rvvm1_sleef y = vdiv_vf_vf_vf_rvvm1_sleef(d, vadd_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(2), d));

  y = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(8.664339742f)),
                                    visnan_vo_vf_rvvm1_sleef(y)), vcast_vf_f_rvvm1_sleef(1.0f), y);
  y = vmulsign_vf_vf_vf_rvvm1_sleef(y, x);
  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(y)));

  return y;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef logk2f_rvvm1_sleef(vfloat2_rvvm1_sleef d) {
  vfloat2_rvvm1_sleef x, x2, m, s;
  vfloat_rvvm1_sleef t;
  vint2_rvvm1_sleef e;

  e = vilogbk_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(1.0f/0.75f)));

  m = dfscale_vf2_vf2_vf_rvvm1_sleef(d, vpow2i_vf_vi2_rvvm1_sleef(vneg_vi2_vi2_rvvm1_sleef(e)));

  x = dfdiv_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf_rvvm1_sleef(m, vcast_vf_f_rvvm1_sleef(-1)), dfadd2_vf2_vf2_vf_rvvm1_sleef(m, vcast_vf_f_rvvm1_sleef(1)));
  x2 = dfsqu_vf2_vf2_rvvm1_sleef(x);

  t = vcast_vf_f_rvvm1_sleef(0.2392828464508056640625f);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(x2), vcast_vf_f_rvvm1_sleef(0.28518211841583251953125f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(x2), vcast_vf_f_rvvm1_sleef(0.400005877017974853515625f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(x2), vcast_vf_f_rvvm1_sleef(0.666666686534881591796875f));

  s = dfmul_vf2_vf2_vf_rvvm1_sleef(vcast_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.69314718246459960938f), vcast_vf_f_rvvm1_sleef(-1.904654323148236017e-09f)), vcast_vf_vi2_rvvm1_sleef(e));
  s = dfadd_vf2_vf2_vf2_rvvm1_sleef(s, dfscale_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(2)));
  s = dfadd_vf2_vf2_vf2_rvvm1_sleef(s, dfmul_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(x2, x), t));

  return s;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_asinhfx_u10rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef y = vabs_vf_vf_rvvm1_sleef(x);
  rvv_sp_vopmask_rvvm1_sleef o = vgt_vo_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(1));
  vfloat2_rvvm1_sleef d;

  d = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, dfrec_vf2_vf_rvvm1_sleef(x), vcast_vf2_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(0)));
  d = dfsqrt_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf_rvvm1_sleef(dfsqu_vf2_vf2_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(1)));
  d = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, dfmul_vf2_vf2_vf_rvvm1_sleef(d, y), d);

  d = logk2f_rvvm1_sleef(dfnormalize_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf_rvvm1_sleef(d, x)));
  y = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d));

  y = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(18446743523953729536.0)),
                                    visnan_vo_vf_rvvm1_sleef(y)),
                       vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(__builtin_inff()), x), y);
  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(y)));
  y = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(-0.0), y);

  return y;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_acoshfx_u10rvvm1(vfloat_rvvm1_sleef x) {
  vfloat2_rvvm1_sleef d = logk2f_rvvm1_sleef(dfadd2_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(dfsqrt_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(1))), dfsqrt_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(-1)))), x));
  vfloat_rvvm1_sleef y = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d));

  y = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(18446743523953729536.0)),
                                    visnan_vo_vf_rvvm1_sleef(y)),
                       vcast_vf_f_rvvm1_sleef(__builtin_inff()), y);

  y = vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(1.0f)), vreinterpret_vm_vf_rvvm1_sleef(y)));

  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(1.0f)), vreinterpret_vm_vf_rvvm1_sleef(y)));
  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_atanhfx_u10rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef y = vabs_vf_vf_rvvm1_sleef(x);
  vfloat2_rvvm1_sleef d = logk2f_rvvm1_sleef(dfdiv_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), y), dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), vneg_vf_vf_rvvm1_sleef(y))));
  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(1.0)), vreinterpret_vm_vf_rvvm1_sleef(vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(1.0)), vcast_vf_f_rvvm1_sleef(__builtin_inff()), vmul_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(0.5))))));

  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(x), visnan_vo_vf_rvvm1_sleef(y)), vreinterpret_vm_vf_rvvm1_sleef(y)));
  y = vmulsign_vf_vf_vf_rvvm1_sleef(y, x);
  y = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(x), vreinterpret_vm_vf_rvvm1_sleef(y)));

  return y;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_exp2fx_u10rvvm1(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef u = vrint_vf_vf_rvvm1_sleef(d), s;
  vint2_rvvm1_sleef q = vrint_vi2_vf_rvvm1_sleef(u);

  s = vsub_vf_vf_vf_rvvm1_sleef(d, u);

  u = vcast_vf_f_rvvm1_sleef(+0.1535920892e-3);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.1339262701e-2));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.9618384764e-2));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.5550347269e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.2402264476e+0));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.6931471825e+0));

  u = vfma_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(1));

  u = vldexp2_vf_vf_vi2_rvvm1_sleef(u, q);

  u = vsel_vf_vo_vf_vf_rvvm1_sleef(vge_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(128)), vcast_vf_f_rvvm1_sleef(__builtin_inf()), u);
  u = vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(-150)), vreinterpret_vm_vf_rvvm1_sleef(u)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_exp2fx_u35rvvm1(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef u = vrint_vf_vf_rvvm1_sleef(d), s;
  vint2_rvvm1_sleef q = vrint_vi2_vf_rvvm1_sleef(u);

  s = vsub_vf_vf_vf_rvvm1_sleef(d, u);

  u = vcast_vf_f_rvvm1_sleef(+0.1535920892e-3);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.1339262701e-2));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.9618384764e-2));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.5550347269e-1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.2402264476e+0));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.6931471825e+0));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.1000000000e+1));

  u = vldexp2_vf_vf_vi2_rvvm1_sleef(u, q);

  u = vsel_vf_vo_vf_vf_rvvm1_sleef(vge_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(128)), vcast_vf_f_rvvm1_sleef(__builtin_inf()), u);
  u = vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(-150)), vreinterpret_vm_vf_rvvm1_sleef(u)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_exp10fx_u10rvvm1(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef u = vrint_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(3.3219280948873623478703194294893901758648313930))), s;
  vint2_rvvm1_sleef q = vrint_vi2_vf_rvvm1_sleef(u);

  s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.3010253906f), d);
  s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-4.605038981e-06f), s);

  u = vcast_vf_f_rvvm1_sleef(+0.6802555919e-1);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.2078080326e+0));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.5393903852e+0));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.1171245337e+1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.2034678698e+1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.2650949001e+1));
  vfloat2_rvvm1_sleef x = dfadd_vf2_vf2_vf_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(2.3025851249694824219, -3.1705172516493593157e-08), vmul_vf_vf_vf_rvvm1_sleef(u, s));
  u = vf2getx_vf_vf2_rvvm1_sleef(dfnormalize_vf2_vf2_rvvm1_sleef(dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), dfmul_vf2_vf2_vf_rvvm1_sleef(x, s))));

  u = vldexp2_vf_vf_vi2_rvvm1_sleef(u, q);

  u = vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(38.5318394191036238941387f)), vcast_vf_f_rvvm1_sleef(__builtin_inff()), u);
  u = vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(-50)), vreinterpret_vm_vf_rvvm1_sleef(u)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_exp10fx_u35rvvm1(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef u = vrint_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(3.3219280948873623478703194294893901758648313930))), s;
  vint2_rvvm1_sleef q = vrint_vi2_vf_rvvm1_sleef(u);

  s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-0.3010253906f), d);
  s = vmla_vf_vf_vf_vf_rvvm1_sleef(u, vcast_vf_f_rvvm1_sleef(-4.605038981e-06f), s);

  u = vcast_vf_f_rvvm1_sleef(+0.2064004987e+0);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.5417877436e+0));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.1171286821e+1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.2034656048e+1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.2650948763e+1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.2302585125e+1));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vcast_vf_f_rvvm1_sleef(+0.1000000000e+1));

  u = vldexp2_vf_vf_vi2_rvvm1_sleef(u, q);

  u = vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(38.5318394191036238941387f)), vcast_vf_f_rvvm1_sleef(__builtin_inff()), u);
  u = vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(-50)), vreinterpret_vm_vf_rvvm1_sleef(u)));

  return u;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_expm1fx_u10rvvm1(vfloat_rvvm1_sleef a) {
  vfloat2_rvvm1_sleef d = dfadd2_vf2_vf2_vf_rvvm1_sleef(expk2f_rvvm1_sleef(vcast_vf2_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0))), vcast_vf_f_rvvm1_sleef(-1.0));
  vfloat_rvvm1_sleef x = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(d), vf2gety_vf_vf2_rvvm1_sleef(d));
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(88.72283172607421875f)), vcast_vf_f_rvvm1_sleef(__builtin_inff()), x);
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(-16.635532333438687426013570f)), vcast_vf_f_rvvm1_sleef(-1), x);
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(a), vcast_vf_f_rvvm1_sleef(-0.0f), x);
  return x;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_log10fx_u10rvvm1(vfloat_rvvm1_sleef d) {
  vfloat2_rvvm1_sleef x;
  vfloat_rvvm1_sleef t, m, x2;

  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0x1p-126));
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)(INT64_C(1) << 32) * (float)(INT64_C(1) << 32))), d);
  vint2_rvvm1_sleef e = vilogb2k_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.0/0.75)));
  m = vldexp3_vf_vf_vi2_rvvm1_sleef(d, vneg_vi2_vi2_rvvm1_sleef(e));
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(o, vsub_vi2_vi2_vi2_rvvm1_sleef(e, vcast_vi2_i_rvvm1_sleef(64)), e);

  x = dfdiv_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-1), m), dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), m));
  x2 = vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(x));

  t = vcast_vf_f_rvvm1_sleef(+0.1314289868e+0);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef( +0.1735493541e+0));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef( +0.2895309627e+0));

  vfloat2_rvvm1_sleef s = dfmul_vf2_vf2_vf_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(0.30103001, -1.432098889e-08), vcast_vf_vi2_rvvm1_sleef(e));

  s = dfadd_vf2_vf2_vf2_rvvm1_sleef(s, dfmul_vf2_vf2_vf2_rvvm1_sleef(x, vcast_vf2_f_f_rvvm1_sleef(0.868588984, -2.170757285e-08)));
  s = dfadd_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(x2, vf2getx_vf_vf2_rvvm1_sleef(x)), t));

  vfloat_rvvm1_sleef r = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s), vf2gety_vf_vf2_rvvm1_sleef(s));

  r = vsel_vf_vo_vf_vf_rvvm1_sleef(vispinf_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(__builtin_inf()), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), visnan_vo_vf_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(__builtin_nan("")), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(-__builtin_inf()), r);

  return r;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_log2fx_u10rvvm1(vfloat_rvvm1_sleef d) {
  vfloat2_rvvm1_sleef x;
  vfloat_rvvm1_sleef t, m, x2;

  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0x1p-126));
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)(INT64_C(1) << 32) * (float)(INT64_C(1) << 32))), d);
  vint2_rvvm1_sleef e = vilogb2k_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.0/0.75)));
  m = vldexp3_vf_vf_vi2_rvvm1_sleef(d, vneg_vi2_vi2_rvvm1_sleef(e));
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(o, vsub_vi2_vi2_vi2_rvvm1_sleef(e, vcast_vi2_i_rvvm1_sleef(64)), e);

  x = dfdiv_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-1), m), dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), m));
  x2 = vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(x));

  t = vcast_vf_f_rvvm1_sleef(+0.4374550283e+0f);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(+0.5764790177e+0f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(+0.9618012905120f));

  vfloat2_rvvm1_sleef s = dfadd2_vf2_vf_vf2_rvvm1_sleef(vcast_vf_vi2_rvvm1_sleef(e),
                                dfmul_vf2_vf2_vf2_rvvm1_sleef(x, vcast_vf2_f_f_rvvm1_sleef(2.8853900432586669922, 3.2734474483568488616e-08)));

  s = dfadd2_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(x2, vf2getx_vf_vf2_rvvm1_sleef(x)), t));

  vfloat_rvvm1_sleef r = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s), vf2gety_vf_vf2_rvvm1_sleef(s));

  r = vsel_vf_vo_vf_vf_rvvm1_sleef(vispinf_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(__builtin_inf()), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), visnan_vo_vf_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(__builtin_nan("")), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(-__builtin_inf()), r);

  return r;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_log2fx_u35rvvm1(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef m, t, x, x2;

  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0x1p-126));
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef((float)(INT64_C(1) << 32) * (float)(INT64_C(1) << 32))), d);
  vint2_rvvm1_sleef e = vilogb2k_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.0/0.75)));
  m = vldexp3_vf_vf_vi2_rvvm1_sleef(d, vneg_vi2_vi2_rvvm1_sleef(e));
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(o, vsub_vi2_vi2_vi2_rvvm1_sleef(e, vcast_vi2_i_rvvm1_sleef(64)), e);

  x = vdiv_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(m, vcast_vf_f_rvvm1_sleef(1)), vadd_vf_vf_vf_rvvm1_sleef(m, vcast_vf_f_rvvm1_sleef(1)));
  x2 = vmul_vf_vf_vf_rvvm1_sleef(x, x);

  t = vcast_vf_f_rvvm1_sleef(+0.4374088347e+0);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(+0.5764843822e+0));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(+0.9618024230e+0));

  vfloat_rvvm1_sleef r = vmla_vf_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(x2, x), t,
                              vmla_vf_vf_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(+0.2885390043e+1), vcast_vf_vi2_rvvm1_sleef(e)));

  r = vsel_vf_vo_vf_vf_rvvm1_sleef(vispinf_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(__builtin_inf()), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), visnan_vo_vf_rvvm1_sleef(d)), vcast_vf_f_rvvm1_sleef(__builtin_nan("")), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(-__builtin_inf()), r);

  return r;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_log1pfx_u10rvvm1(vfloat_rvvm1_sleef d) {
  vfloat2_rvvm1_sleef x;
  vfloat_rvvm1_sleef t, m, x2;

  vfloat_rvvm1_sleef dp1 = vadd_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1));

  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(dp1, vcast_vf_f_rvvm1_sleef(0x1p-126));
  dp1 = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(dp1, vcast_vf_f_rvvm1_sleef((float)(INT64_C(1) << 32) * (float)(INT64_C(1) << 32))), dp1);
  vint2_rvvm1_sleef e = vilogb2k_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(dp1, vcast_vf_f_rvvm1_sleef(1.0f/0.75f)));
  t = vldexp3_vf_vf_vi2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), vneg_vi2_vi2_rvvm1_sleef(e));
  m = vmla_vf_vf_vf_vf_rvvm1_sleef(d, t, vsub_vf_vf_vf_rvvm1_sleef(t, vcast_vf_f_rvvm1_sleef(1)));
  e = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(o, vsub_vi2_vi2_vi2_rvvm1_sleef(e, vcast_vi2_i_rvvm1_sleef(64)), e);
  vfloat2_rvvm1_sleef s = dfmul_vf2_vf2_vf_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(0.69314718246459960938f, -1.904654323148236017e-09f), vcast_vf_vi2_rvvm1_sleef(e));

  x = dfdiv_vf2_vf2_vf2_rvvm1_sleef(vcast_vf2_vf_vf_rvvm1_sleef(m, vcast_vf_f_rvvm1_sleef(0)), dfadd_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(2), m));
  x2 = vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2getx_vf_vf2_rvvm1_sleef(x));

  t = vcast_vf_f_rvvm1_sleef(+0.3027294874e+0f);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(+0.3996108174e+0f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, x2, vcast_vf_f_rvvm1_sleef(+0.6666694880e+0f));

  s = dfadd_vf2_vf2_vf2_rvvm1_sleef(s, dfscale_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(2)));
  s = dfadd_vf2_vf2_vf_rvvm1_sleef(s, vmul_vf_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(x2, vf2getx_vf_vf2_rvvm1_sleef(x)), t));

  vfloat_rvvm1_sleef r = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(s), vf2gety_vf_vf2_rvvm1_sleef(s));

  r = vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1e+38)), vcast_vf_f_rvvm1_sleef(__builtin_inff()), r);
  r = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-1), d), vreinterpret_vm_vf_rvvm1_sleef(r)));
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(-1)), vcast_vf_f_rvvm1_sleef(-__builtin_inff()), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(-0.0f), r);

  return r;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_fabsfx_rvvm1(vfloat_rvvm1_sleef x) { return vabs_vf_vf_rvvm1_sleef(x); }

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_copysignfx_rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) { return vcopysign_vf_vf_vf_rvvm1_sleef(x, y); }

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_fmaxfx_rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {

  return vsel_vf_vo_vf_vf_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(y), x, vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(x, y), x, y));

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_fminfx_rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {

  return vsel_vf_vo_vf_vf_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(y), x, vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(y, x), x, y));

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_fdimfx_rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef ret = vsub_vf_vf_vf_rvvm1_sleef(x, y);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vlt_vo_vf_vf_rvvm1_sleef(ret, vcast_vf_f_rvvm1_sleef(0)), veq_vo_vf_vf_rvvm1_sleef(x, y)), vcast_vf_f_rvvm1_sleef(0), ret);
  return ret;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_truncfx_rvvm1(vfloat_rvvm1_sleef x) {

  vfloat_rvvm1_sleef fr = vsub_vf_vf_vf_rvvm1_sleef(x, vcast_vf_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(x)));
  return vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(x), vge_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(INT64_C(1) << 23))), x, vcopysign_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(x, fr), x));

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_floorfx_rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef fr = vsub_vf_vf_vf_rvvm1_sleef(x, vcast_vf_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(x)));
  fr = vsel_vf_vo_vf_vf_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(fr, vcast_vf_f_rvvm1_sleef(0)), vadd_vf_vf_vf_rvvm1_sleef(fr, vcast_vf_f_rvvm1_sleef(1.0f)), fr);
  return vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(x), vge_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(INT64_C(1) << 23))), x, vcopysign_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(x, fr), x));
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_ceilfx_rvvm1(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef fr = vsub_vf_vf_vf_rvvm1_sleef(x, vcast_vf_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(x)));
  fr = vsel_vf_vo_vf_vf_rvvm1_sleef(vle_vo_vf_vf_rvvm1_sleef(fr, vcast_vf_f_rvvm1_sleef(0)), fr, vsub_vf_vf_vf_rvvm1_sleef(fr, vcast_vf_f_rvvm1_sleef(1.0f)));
  return vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(x), vge_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(INT64_C(1) << 23))), x, vcopysign_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(x, fr), x));
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_roundfx_rvvm1(vfloat_rvvm1_sleef d) {
  vfloat_rvvm1_sleef x = vadd_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0.5f));
  vfloat_rvvm1_sleef fr = vsub_vf_vf_vf_rvvm1_sleef(x, vcast_vf_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(x)));
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vand_vo_vo_vo(vle_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0)), veq_vo_vf_vf_rvvm1_sleef(fr, vcast_vf_f_rvvm1_sleef(0))), vsub_vf_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(1.0f)), x);
  fr = vsel_vf_vo_vf_vf_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(fr, vcast_vf_f_rvvm1_sleef(0)), vadd_vf_vf_vf_rvvm1_sleef(fr, vcast_vf_f_rvvm1_sleef(1.0f)), fr);
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0.4999999701976776123f)), vcast_vf_f_rvvm1_sleef(0), x);
  return vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(d), vge_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(INT64_C(1) << 23))), d, vcopysign_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(x, fr), d));
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_rintfx_rvvm1(vfloat_rvvm1_sleef d) {

  vfloat_rvvm1_sleef c = vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1 << 23), d);
  return vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(1 << 23)),
                          d, vorsign_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(d, c), c), d));

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_fmafx_rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y, vfloat_rvvm1_sleef z) {

  return vfma_vf_vf_vf_vf_rvvm1_sleef(x, y, z);

}

SLEEF_INLINE vfloat_rvvm1_sleef Sleef_sqrtfx_u05rvvm1(vfloat_rvvm1_sleef d) {

  vfloat_rvvm1_sleef q, w, x, y, z;

  d = vsel_vf_vo_vf_vf_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), d);

  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(5.2939559203393770e-23f));
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.8889465931478580e+22f)), d);
  q = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vcast_vf_f_rvvm1_sleef(7.2759576141834260e-12f), vcast_vf_f_rvvm1_sleef(1.0f));

  y = vreinterpret_vf_vi2_rvvm1_sleef(vsub_vi2_vi2_vi2_rvvm1_sleef(vcast_vi2_i_rvvm1_sleef(0x5f3759df), vsrl_vi2_vi2_i_rvvm1_sleef(vreinterpret_vi2_vf_rvvm1_sleef(d), 1)));

  x = vmul_vf_vf_vf_rvvm1_sleef(d, y); w = vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.5), y);
  y = vfmanp_vf_vf_vf_vf_rvvm1_sleef(x, w, vcast_vf_f_rvvm1_sleef(0.5));
  x = vfma_vf_vf_vf_vf_rvvm1_sleef(x, y, x); w = vfma_vf_vf_vf_vf_rvvm1_sleef(w, y, w);
  y = vfmanp_vf_vf_vf_vf_rvvm1_sleef(x, w, vcast_vf_f_rvvm1_sleef(0.5));
  x = vfma_vf_vf_vf_vf_rvvm1_sleef(x, y, x); w = vfma_vf_vf_vf_vf_rvvm1_sleef(w, y, w);

  y = vfmanp_vf_vf_vf_vf_rvvm1_sleef(x, w, vcast_vf_f_rvvm1_sleef(1.5)); w = vadd_vf_vf_vf_rvvm1_sleef(w, w);
  w = vmul_vf_vf_vf_rvvm1_sleef(w, y);
  x = vmul_vf_vf_vf_rvvm1_sleef(w, d);
  y = vfmapn_vf_vf_vf_vf_rvvm1_sleef(w, d, x); z = vfmanp_vf_vf_vf_vf_rvvm1_sleef(w, x, vcast_vf_f_rvvm1_sleef(1));

  z = vfmanp_vf_vf_vf_vf_rvvm1_sleef(w, y, z); w = vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.5), x);
  w = vfma_vf_vf_vf_vf_rvvm1_sleef(w, z, y);
  w = vadd_vf_vf_vf_rvvm1_sleef(w, x);

  w = vmul_vf_vf_vf_rvvm1_sleef(w, q);

  w = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)),
                                    veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(__builtin_inff()))), d, w);

  w = vsel_vf_vo_vf_vf_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), w);

  return w;

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_sqrtfx_rvvm1(vfloat_rvvm1_sleef d) {

  return Sleef_sqrtfx_u05rvvm1(d);

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_hypotfx_u05rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  x = vabs_vf_vf_rvvm1_sleef(x);
  y = vabs_vf_vf_rvvm1_sleef(y);
  vfloat_rvvm1_sleef min = vmin_vf_vf_vf_rvvm1_sleef(x, y), n = min;
  vfloat_rvvm1_sleef max = vmax_vf_vf_vf_rvvm1_sleef(x, y), d = max;

  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(max, vcast_vf_f_rvvm1_sleef(0x1p-126));
  n = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(n, vcast_vf_f_rvvm1_sleef(UINT64_C(1) << 24)), n);
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(UINT64_C(1) << 24)), d);

  vfloat2_rvvm1_sleef t = dfdiv_vf2_vf2_vf2_rvvm1_sleef(vcast_vf2_vf_vf_rvvm1_sleef(n, vcast_vf_f_rvvm1_sleef(0)), vcast_vf2_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)));
  t = dfmul_vf2_vf2_vf_rvvm1_sleef(dfsqrt_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf_rvvm1_sleef(dfsqu_vf2_vf2_rvvm1_sleef(t), vcast_vf_f_rvvm1_sleef(1))), max);
  vfloat_rvvm1_sleef ret = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(t), vf2gety_vf_vf2_rvvm1_sleef(t));
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(ret), vcast_vf_f_rvvm1_sleef(__builtin_inff()), ret);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(min, vcast_vf_f_rvvm1_sleef(0)), max, ret);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visnan_vo_vf_rvvm1_sleef(x), visnan_vo_vf_rvvm1_sleef(y)), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), ret);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(__builtin_inff())), veq_vo_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(__builtin_inff()))), vcast_vf_f_rvvm1_sleef(__builtin_inff()), ret);

  return ret;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_hypotfx_u35rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  x = vabs_vf_vf_rvvm1_sleef(x);
  y = vabs_vf_vf_rvvm1_sleef(y);
  vfloat_rvvm1_sleef min = vmin_vf_vf_vf_rvvm1_sleef(x, y);
  vfloat_rvvm1_sleef max = vmax_vf_vf_vf_rvvm1_sleef(x, y);

  vfloat_rvvm1_sleef t = vdiv_vf_vf_vf_rvvm1_sleef(min, max);
  vfloat_rvvm1_sleef ret = vmul_vf_vf_vf_rvvm1_sleef(max, vsqrt_vf_vf_rvvm1_sleef(vmla_vf_vf_vf_vf_rvvm1_sleef(t, t, vcast_vf_f_rvvm1_sleef(1))));
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(min, vcast_vf_f_rvvm1_sleef(0)), max, ret);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visnan_vo_vf_rvvm1_sleef(x), visnan_vo_vf_rvvm1_sleef(y)), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), ret);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(__builtin_inff())), veq_vo_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(__builtin_inff()))), vcast_vf_f_rvvm1_sleef(__builtin_inff()), ret);

  return ret;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_nextafterfx_rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0)), vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0), y), x);
  vint2_rvvm1_sleef xi2 = vreinterpret_vi2_vf_rvvm1_sleef(x);
  rvv_sp_vopmask_rvvm1_sleef c = rvv_sp_vxor_vo_vo_vo(vsignbit_vo_vf_rvvm1_sleef(x), vge_vo_vf_vf_rvvm1_sleef(y, x));

  xi2 = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(c, vsub_vi2_vi2_vi2_rvvm1_sleef(vcast_vi2_i_rvvm1_sleef(0), vxor_vi2_vi2_vi2_rvvm1_sleef(xi2, vcast_vi2_i_rvvm1_sleef((int)(1U << 31)))), xi2);

  xi2 = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(vneq_vo_vf_vf_rvvm1_sleef(x, y), vsub_vi2_vi2_vi2_rvvm1_sleef(xi2, vcast_vi2_i_rvvm1_sleef(1)), xi2);

  xi2 = vsel_vi2_vo_vi2_vi2_rvvm1_sleef(c, vsub_vi2_vi2_vi2_rvvm1_sleef(vcast_vi2_i_rvvm1_sleef(0), vxor_vi2_vi2_vi2_rvvm1_sleef(xi2, vcast_vi2_i_rvvm1_sleef((int)(1U << 31)))), xi2);

  vfloat_rvvm1_sleef ret = vreinterpret_vf_vi2_rvvm1_sleef(xi2);

  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vand_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(ret, vcast_vf_f_rvvm1_sleef(0)), vneq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0))),
                         vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0), x), ret);

  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vand_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0)), veq_vo_vf_vf_rvvm1_sleef(y, vcast_vf_f_rvvm1_sleef(0))), y, ret);

  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(visnan_vo_vf_rvvm1_sleef(x), visnan_vo_vf_rvvm1_sleef(y)), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), ret);

  return ret;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_frfrexpfx_rvvm1(vfloat_rvvm1_sleef x) {
  x = vsel_vf_vo_vf_vf_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(0x1p-126)), vmul_vf_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(UINT64_C(1) << 30)), x);

  vmask_rvvm1_sleef xm = vreinterpret_vm_vf_rvvm1_sleef(x);
  xm = vand_vm_vm_vm_rvvm1_sleef(xm, vcast_vm_i_i_rvvm1_sleef(~0x7f800000U, ~0x7f800000U));
  xm = vor_vm_vm_vm_rvvm1_sleef (xm, vcast_vm_i_i_rvvm1_sleef( 0x3f000000U, 0x3f000000U));

  vfloat_rvvm1_sleef ret = vreinterpret_vf_vm_rvvm1_sleef(xm);

  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(x), vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(__builtin_inff()), x), ret);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0)), x, ret);

  return ret;
}

SLEEF_INLINE SLEEF_CONST vint2_rvvm1_sleef Sleef_expfrexpfx_rvvm1(vfloat_rvvm1_sleef x) {

  return vcast_vi2_i_rvvm1_sleef(0);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vtoward0_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x) {
  vfloat_rvvm1_sleef t = vreinterpret_vf_vi2_rvvm1_sleef(vsub_vi2_vi2_vi2_rvvm1_sleef(vreinterpret_vi2_vf_rvvm1_sleef(x), vcast_vi2_i_rvvm1_sleef(1)));
  return vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(0), t);
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vptrunc_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef x) {

  vfloat_rvvm1_sleef fr = vsub_vf_vf_vf_rvvm1_sleef(x, vcast_vf_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(x)));
  return vsel_vf_vo_vf_vf_rvvm1_sleef(vge_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(INT64_C(1) << 23)), x, vsub_vf_vf_vf_rvvm1_sleef(x, fr));

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_fmodfx_rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef nu = vabs_vf_vf_rvvm1_sleef(x), de = vabs_vf_vf_rvvm1_sleef(y), s = vcast_vf_f_rvvm1_sleef(1), q;
  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(de, vcast_vf_f_rvvm1_sleef(0x1p-126));
  nu = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(nu, vcast_vf_f_rvvm1_sleef(UINT64_C(1) << 25)), nu);
  de = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(de, vcast_vf_f_rvvm1_sleef(UINT64_C(1) << 25)), de);
  s = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(s , vcast_vf_f_rvvm1_sleef(1.0f / (UINT64_C(1) << 25))), s);
  vfloat_rvvm1_sleef rde = vtoward0_vf_vf_rvvm1_sleef(vrec_vf_vf_rvvm1_sleef(de));

  vfloat2_rvvm1_sleef r = vcast_vf2_vf_vf_rvvm1_sleef(nu, vcast_vf_f_rvvm1_sleef(0));

  for(int i=0;i<8;i++) {
    q = vptrunc_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vtoward0_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)), rde));
    q = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vand_vo_vo_vo(vgt_vo_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(3), de), vf2getx_vf_vf2_rvvm1_sleef(r)),
                                       vge_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r), de)),
                         vcast_vf_f_rvvm1_sleef(2), q);
    q = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vand_vo_vo_vo(vgt_vo_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(2), de), vf2getx_vf_vf2_rvvm1_sleef(r)),
                                       vge_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r), de)),
                         vcast_vf_f_rvvm1_sleef(1), q);
    r = dfnormalize_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf2_rvvm1_sleef(r, dfmul_vf2_vf_vf_rvvm1_sleef(vptrunc_vf_vf_rvvm1_sleef(q), vneg_vf_vf_rvvm1_sleef(de))));
    if (vtestallones_i_vo32_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r), de))) break;
  }

  vfloat_rvvm1_sleef ret = vmul_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r), vf2gety_vf_vf2_rvvm1_sleef(r)), s);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r), vf2gety_vf_vf2_rvvm1_sleef(r)), de), vcast_vf_f_rvvm1_sleef(0), ret);

  ret = vmulsign_vf_vf_vf_rvvm1_sleef(ret, x);

  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(nu, de), x, ret);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(de, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), ret);

  return ret;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat_rvvm1_sleef vrintfk2_vf_vf_rvvm1_sleef(vfloat_rvvm1_sleef d) {

  vfloat_rvvm1_sleef c = vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1 << 23), d);
  return vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(1 << 23)),
                          d, vorsign_vf_vf_vf_rvvm1_sleef(vsub_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(d, c), c), d));

}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_remainderfx_rvvm1(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef y) {
  vfloat_rvvm1_sleef n = vabs_vf_vf_rvvm1_sleef(x), d = vabs_vf_vf_rvvm1_sleef(y), s = vcast_vf_f_rvvm1_sleef(1), q;
  rvv_sp_vopmask_rvvm1_sleef o = vlt_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0x1p-126*2));
  n = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(n, vcast_vf_f_rvvm1_sleef(UINT64_C(1) << 25)), n);
  d = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(UINT64_C(1) << 25)), d);
  s = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmul_vf_vf_vf_rvvm1_sleef(s , vcast_vf_f_rvvm1_sleef(1.0f / (UINT64_C(1) << 25))), s);
  vfloat2_rvvm1_sleef r = vcast_vf2_vf_vf_rvvm1_sleef(n, vcast_vf_f_rvvm1_sleef(0));
  vfloat_rvvm1_sleef rd = vrec_vf_vf_rvvm1_sleef(d);
  rvv_sp_vopmask_rvvm1_sleef qisodd = vneq_vo_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0), vcast_vf_f_rvvm1_sleef(0));

  for(int i=0;i<8;i++) {
    q = vrintfk2_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r), rd));
    q = vsel_vf_vo_vf_vf_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)), vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(1.5f))), vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1.0f), vf2getx_vf_vf2_rvvm1_sleef(r)), q);
    q = vsel_vf_vo_vf_vf_rvvm1_sleef(rvv_sp_vor_vo_vo_vo(vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)), vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0.5f))),
                                      rvv_sp_vandnot_vo_vo_vo(qisodd, veq_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r)), vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0.5f))))),
                         vcast_vf_f_rvvm1_sleef(0.0), q);
    if (vtestallones_i_vo32_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(q, vcast_vf_f_rvvm1_sleef(0)))) break;
    q = vsel_vf_vo_vf_vf_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(q, vneg_vf_vf_rvvm1_sleef(d))), vadd_vf_vf_vf_rvvm1_sleef(q, vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-1), vf2getx_vf_vf2_rvvm1_sleef(r))), q);
    qisodd = rvv_sp_vxor_vo_vo_vo(qisodd, rvv_sp_vand_vo_vo_vo(veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(q), vcast_vi2_i_rvvm1_sleef(1)), vcast_vi2_i_rvvm1_sleef(1)),
                                                 vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(q), vcast_vf_f_rvvm1_sleef(1 << 24))));
    r = dfnormalize_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf2_rvvm1_sleef(r, dfmul_vf2_vf_vf_rvvm1_sleef(q, vneg_vf_vf_rvvm1_sleef(d))));
  }

  vfloat_rvvm1_sleef ret = vmul_vf_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(r), vf2gety_vf_vf2_rvvm1_sleef(r)), s);
  ret = vmulsign_vf_vf_vf_rvvm1_sleef(ret, x);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(y), vsel_vf_vo_vf_vf_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), x), ret);
  ret = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), ret);
  return ret;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef sinpifk_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef o;
  vfloat_rvvm1_sleef u, s, t;
  vfloat2_rvvm1_sleef x, s2;

  u = vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(4.0));
  vint2_rvvm1_sleef q = vtruncate_vi2_vf_rvvm1_sleef(u);
  q = vand_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vxor_vi2_vi2_vi2_rvvm1_sleef(vsrl_vi2_vi2_i_rvvm1_sleef(q, 31), vcast_vi2_i_rvvm1_sleef(1))), vcast_vi2_i_rvvm1_sleef(~1));
  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(2));

  s = vsub_vf_vf_vf_rvvm1_sleef(u, vcast_vf_vi2_rvvm1_sleef(q));
  t = s;
  s = vmul_vf_vf_vf_rvvm1_sleef(s, s);
  s2 = dfmul_vf2_vf_vf_rvvm1_sleef(t, t);

  u = vsel_vf_vo_f_f_rvvm1_sleef(o, -0.2430611801e-7f, +0.3093842054e-6f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vsel_vf_vo_f_f_rvvm1_sleef(o, +0.3590577080e-5f, -0.3657307388e-4f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vsel_vf_vo_f_f_rvvm1_sleef(o, -0.3259917721e-3f, +0.2490393585e-2f));
  x = dfadd2_vf2_vf_vf2_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(u, s),
                        vsel_vf2_vo_f_f_f_f_rvvm1_sleef(o, 0.015854343771934509277, 4.4940051354032242811e-10,
                                            -0.080745510756969451904, -1.3373665339076936258e-09));
  x = dfadd2_vf2_vf2_vf2_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(s2, x),
                         vsel_vf2_vo_f_f_f_f_rvvm1_sleef(o, -0.30842512845993041992, -9.0728339030733922277e-09,
                                             0.78539818525314331055, -2.1857338617566484855e-08));

  x = dfmul_vf2_vf2_vf2_rvvm1_sleef(x, vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, s2, vcast_vf2_vf_vf_rvvm1_sleef(t, vcast_vf_f_rvvm1_sleef(0))));
  x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, dfadd2_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(1)), x);

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(4)), vcast_vi2_i_rvvm1_sleef(4));
  x = vf2setx_vf2_vf2_vf_rvvm1_sleef(x, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x)))));
  x = vf2sety_vf2_vf2_vf_rvvm1_sleef(x, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(x)))));

  return x;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_sinpifx_u05rvvm1(vfloat_rvvm1_sleef d) {
  vfloat2_rvvm1_sleef x = sinpifk_rvvm1_sleef(d);
  vfloat_rvvm1_sleef r = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(x));

  r = vsel_vf_vo_vf_vf_rvvm1_sleef(visnegzero_vo_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(-0.0), r);
  r = vreinterpret_vf_vm_rvvm1_sleef(vandnot_vm_vo32_vm_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(8e+6f)), vreinterpret_vm_vf_rvvm1_sleef(r)));
  r = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(d), vreinterpret_vm_vf_rvvm1_sleef(r)));

  return r;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef cospifk_rvvm1_sleef(vfloat_rvvm1_sleef d) {
  rvv_sp_vopmask_rvvm1_sleef o;
  vfloat_rvvm1_sleef u, s, t;
  vfloat2_rvvm1_sleef x, s2;

  u = vmul_vf_vf_vf_rvvm1_sleef(d, vcast_vf_f_rvvm1_sleef(4.0));
  vint2_rvvm1_sleef q = vtruncate_vi2_vf_rvvm1_sleef(u);
  q = vand_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vxor_vi2_vi2_vi2_rvvm1_sleef(vsrl_vi2_vi2_i_rvvm1_sleef(q, 31), vcast_vi2_i_rvvm1_sleef(1))), vcast_vi2_i_rvvm1_sleef(~1));
  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(0));

  s = vsub_vf_vf_vf_rvvm1_sleef(u, vcast_vf_vi2_rvvm1_sleef(q));
  t = s;
  s = vmul_vf_vf_vf_rvvm1_sleef(s, s);
  s2 = dfmul_vf2_vf_vf_rvvm1_sleef(t, t);

  u = vsel_vf_vo_f_f_rvvm1_sleef(o, -0.2430611801e-7f, +0.3093842054e-6f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vsel_vf_vo_f_f_rvvm1_sleef(o, +0.3590577080e-5f, -0.3657307388e-4f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, s, vsel_vf_vo_f_f_rvvm1_sleef(o, -0.3259917721e-3f, +0.2490393585e-2f));
  x = dfadd2_vf2_vf_vf2_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(u, s),
                        vsel_vf2_vo_f_f_f_f_rvvm1_sleef(o, 0.015854343771934509277, 4.4940051354032242811e-10,
                                            -0.080745510756969451904, -1.3373665339076936258e-09));
  x = dfadd2_vf2_vf2_vf2_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(s2, x),
                         vsel_vf2_vo_f_f_f_f_rvvm1_sleef(o, -0.30842512845993041992, -9.0728339030733922277e-09,
                                             0.78539818525314331055, -2.1857338617566484855e-08));

  x = dfmul_vf2_vf2_vf2_rvvm1_sleef(x, vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, s2, vcast_vf2_vf_vf_rvvm1_sleef(t, vcast_vf_f_rvvm1_sleef(0))));
  x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, dfadd2_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(1)), x);

  o = veq_vo_vi2_vi2_rvvm1_sleef(vand_vi2_vi2_vi2_rvvm1_sleef(vadd_vi2_vi2_vi2_rvvm1_sleef(q, vcast_vi2_i_rvvm1_sleef(2)), vcast_vi2_i_rvvm1_sleef(4)), vcast_vi2_i_rvvm1_sleef(4));
  x = vf2setx_vf2_vf2_vf_rvvm1_sleef(x, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x)))));
  x = vf2sety_vf2_vf2_vf_rvvm1_sleef(x, vreinterpret_vf_vm_rvvm1_sleef(vxor_vm_vm_vm_rvvm1_sleef(vand_vm_vo32_vm_rvvm1_sleef(o, vreinterpret_vm_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(-0.0))), vreinterpret_vm_vf_rvvm1_sleef(vf2gety_vf_vf2_rvvm1_sleef(x)))));

  return x;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_cospifx_u05rvvm1(vfloat_rvvm1_sleef d) {
  vfloat2_rvvm1_sleef x = cospifk_rvvm1_sleef(d);
  vfloat_rvvm1_sleef r = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(x));

  r = vsel_vf_vo_vf_vf_rvvm1_sleef(vgt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(d), vcast_vf_f_rvvm1_sleef(8e+6f)), vcast_vf_f_rvvm1_sleef(1), r);
  r = vreinterpret_vf_vm_rvvm1_sleef(vor_vm_vo32_vm_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(d), vreinterpret_vm_vf_rvvm1_sleef(r)));

  return r;
}

static SLEEF_CONST df2_rvvm1_sleef gammafk_rvvm1_sleef(vfloat_rvvm1_sleef a) {
  vfloat2_rvvm1_sleef clc = vcast_vf2_f_f_rvvm1_sleef(0, 0), clln = vcast_vf2_f_f_rvvm1_sleef(1, 0), clld = vcast_vf2_f_f_rvvm1_sleef(1, 0);
  vfloat2_rvvm1_sleef x, y, z;
  vfloat_rvvm1_sleef t, u;

  rvv_sp_vopmask_rvvm1_sleef otiny = vlt_vo_vf_vf_rvvm1_sleef(vabs_vf_vf_rvvm1_sleef(a), vcast_vf_f_rvvm1_sleef(1e-30f)), oref = vlt_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0.5));

  x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(otiny, vcast_vf2_f_f_rvvm1_sleef(0, 0),
                          vsel_vf2_vo_vf2_vf2_rvvm1_sleef(oref, dfadd2_vf2_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), vneg_vf_vf_rvvm1_sleef(a)),
                                              vcast_vf2_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0))));

  rvv_sp_vopmask_rvvm1_sleef o0 = rvv_sp_vand_vo_vo_vo(vle_vo_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(0.5), vf2getx_vf_vf2_rvvm1_sleef(x)), vle_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(1.2)));
  rvv_sp_vopmask_rvvm1_sleef o2 = vle_vo_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(2.3), vf2getx_vf_vf2_rvvm1_sleef(x));

  y = dfnormalize_vf2_vf2_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(1)), x));
  y = dfnormalize_vf2_vf2_rvvm1_sleef(dfmul_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(2)), y));

  rvv_sp_vopmask_rvvm1_sleef o = rvv_sp_vand_vo_vo_vo(o2, vle_vo_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vcast_vf_f_rvvm1_sleef(7)));
  clln = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, y, clln);

  x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o, dfadd2_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(3)), x);
  t = vsel_vf_vo_vf_vf_rvvm1_sleef(o2, vrec_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x)), vf2getx_vf_vf2_rvvm1_sleef(dfnormalize_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf_rvvm1_sleef(x, vsel_vf_vo_f_f_rvvm1_sleef(o0, -1, -2)))));

  u = vsel_vf_vo_vo_f_f_f_rvvm1_sleef(o2, o0, +0.000839498720672087279971000786, +0.9435157776e+0f, +0.1102489550e-3f);
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, t, vsel_vf_vo_vo_f_f_f_rvvm1_sleef(o2, o0, -5.17179090826059219329394422e-05, +0.8670063615e+0f, +0.8160019934e-4f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, t, vsel_vf_vo_vo_f_f_f_rvvm1_sleef(o2, o0, -0.000592166437353693882857342347, +0.4826702476e+0f, +0.1528468856e-3f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, t, vsel_vf_vo_vo_f_f_f_rvvm1_sleef(o2, o0, +6.97281375836585777403743539e-05, -0.8855129778e-1f, -0.2355068718e-3f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, t, vsel_vf_vo_vo_f_f_f_rvvm1_sleef(o2, o0, +0.000784039221720066627493314301, +0.1013825238e+0f, +0.4962242092e-3f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, t, vsel_vf_vo_vo_f_f_f_rvvm1_sleef(o2, o0, -0.000229472093621399176949318732, -0.1493408978e+0f, -0.1193488017e-2f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, t, vsel_vf_vo_vo_f_f_f_rvvm1_sleef(o2, o0, -0.002681327160493827160473958490, +0.1697509140e+0f, +0.2891599433e-2f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, t, vsel_vf_vo_vo_f_f_f_rvvm1_sleef(o2, o0, +0.003472222222222222222175164840, -0.2072454542e+0f, -0.7385451812e-2f));
  u = vmla_vf_vf_vf_vf_rvvm1_sleef(u, t, vsel_vf_vo_vo_f_f_f_rvvm1_sleef(o2, o0, +0.083333333333333333335592087900, +0.2705872357e+0f, +0.2058077045e-1f));

  y = dfmul_vf2_vf2_vf2_rvvm1_sleef(dfadd2_vf2_vf2_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(-0.5)), logk2f_rvvm1_sleef(x));
  y = dfadd2_vf2_vf2_vf2_rvvm1_sleef(y, dfneg_vf2_vf2_rvvm1_sleef(x));
  y = dfadd2_vf2_vf2_vf2_rvvm1_sleef(y, vcast_vf2_d_rvvm1_sleef(0.91893853320467278056));

  z = dfadd2_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf_vf_rvvm1_sleef (u, t), vsel_vf_vo_f_f_rvvm1_sleef(o0, -0.400686534596170958447352690395e+0f, -0.673523028297382446749257758235e-1f));
  z = dfadd2_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf2_vf_rvvm1_sleef(z, t), vsel_vf_vo_f_f_rvvm1_sleef(o0, +0.822466960142643054450325495997e+0f, +0.322467033928981157743538726901e+0f));
  z = dfadd2_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf2_vf_rvvm1_sleef(z, t), vsel_vf_vo_f_f_rvvm1_sleef(o0, -0.577215665946766039837398973297e+0f, +0.422784335087484338986941629852e+0f));
  z = dfmul_vf2_vf2_vf_rvvm1_sleef(z, t);

  clc = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o2, y, z);

  clld = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o2, dfadd2_vf2_vf2_vf_rvvm1_sleef(dfmul_vf2_vf_vf_rvvm1_sleef(u, t), vcast_vf_f_rvvm1_sleef(1)), clld);

  y = clln;

  clc = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(otiny, vcast_vf2_d_rvvm1_sleef(41.58883083359671856503),
                            vsel_vf2_vo_vf2_vf2_rvvm1_sleef(oref, dfadd2_vf2_vf2_vf2_rvvm1_sleef(vcast_vf2_d_rvvm1_sleef(1.1447298858494001639), dfneg_vf2_vf2_rvvm1_sleef(clc)), clc));
  clln = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(otiny, vcast_vf2_f_f_rvvm1_sleef(1, 0), vsel_vf2_vo_vf2_vf2_rvvm1_sleef(oref, clln, clld));

  if (!vtestallones_i_vo32_rvvm1_sleef(vnot_vo32_vo32_rvvm1_sleef(oref))) {
    t = vsub_vf_vf_vf_rvvm1_sleef(a, vmul_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(INT64_C(1) << 12), vcast_vf_vi2_rvvm1_sleef(vtruncate_vi2_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(1.0 / (INT64_C(1) << 12)))))));
    x = dfmul_vf2_vf2_vf2_rvvm1_sleef(clld, sinpifk_rvvm1_sleef(t));
  }

  clld = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(otiny, vcast_vf2_vf_vf_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef((INT64_C(1) << 30)*(float)(INT64_C(1) << 30))), vcast_vf_f_rvvm1_sleef(0)),
                             vsel_vf2_vo_vf2_vf2_rvvm1_sleef(oref, x, y));

  return df2setab_df2_vf2_vf2_rvvm1_sleef(clc, dfdiv_vf2_vf2_vf2_rvvm1_sleef(clln, clld));
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_tgammafx_u10rvvm1(vfloat_rvvm1_sleef a) {
  df2_rvvm1_sleef d = gammafk_rvvm1_sleef(a);
  vfloat2_rvvm1_sleef y = dfmul_vf2_vf2_vf2_rvvm1_sleef(expk2f_rvvm1_sleef(df2geta_vf2_df2_rvvm1_sleef(d)), df2getb_vf2_df2_rvvm1_sleef(d));
  vfloat_rvvm1_sleef r = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(y), vf2gety_vf_vf2_rvvm1_sleef(y));
  rvv_sp_vopmask_rvvm1_sleef o;

  o = rvv_sp_vor_vo_vo_vo(rvv_sp_vor_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(-__builtin_inff())),
                                rvv_sp_vand_vo_vo_vo(vlt_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0)), visint_vo_vf_rvvm1_sleef(a))),
                   rvv_sp_vand_vo_vo_vo(rvv_sp_vand_vo_vo_vo(visnumber_vo_vf_rvvm1_sleef(a), vlt_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0))), visnan_vo_vf_rvvm1_sleef(r)));
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), r);

  o = rvv_sp_vand_vo_vo_vo(rvv_sp_vand_vo_vo_vo(rvv_sp_vor_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(__builtin_inff())), visnumber_vo_vf_rvvm1_sleef(a)),
                                  vge_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(-0x1p-126))),
                    rvv_sp_vor_vo_vo_vo(rvv_sp_vor_vo_vo_vo(veq_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0)), vgt_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(36))), visnan_vo_vf_rvvm1_sleef(r)));
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vmulsign_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(__builtin_inff()), a), r);

  return r;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_lgammafx_u10rvvm1(vfloat_rvvm1_sleef a) {
  df2_rvvm1_sleef d = gammafk_rvvm1_sleef(a);
  vfloat2_rvvm1_sleef y = dfadd2_vf2_vf2_vf2_rvvm1_sleef(df2geta_vf2_df2_rvvm1_sleef(d), logk2f_rvvm1_sleef(dfabs_vf2_vf2_rvvm1_sleef(df2getb_vf2_df2_rvvm1_sleef(d))));
  vfloat_rvvm1_sleef r = vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(y), vf2gety_vf_vf2_rvvm1_sleef(y));
  rvv_sp_vopmask_rvvm1_sleef o;

  o = rvv_sp_vor_vo_vo_vo(visinf_vo_vf_rvvm1_sleef(a),
                   rvv_sp_vor_vo_vo_vo(rvv_sp_vand_vo_vo_vo(vle_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0)), visint_vo_vf_rvvm1_sleef(a)),
                                rvv_sp_vand_vo_vo_vo(visnumber_vo_vf_rvvm1_sleef(a), visnan_vo_vf_rvvm1_sleef(r))));
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(o, vcast_vf_f_rvvm1_sleef(__builtin_inff()), r);

  return r;
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef dfmla_vf2_vf_vf2_vf2_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat2_rvvm1_sleef y, vfloat2_rvvm1_sleef z) {
  return dfadd_vf2_vf2_vf2_rvvm1_sleef(z, dfmul_vf2_vf2_vf_rvvm1_sleef(y, x));
}

static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef poly2df_b_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat2_rvvm1_sleef c1, vfloat2_rvvm1_sleef c0) { return dfmla_vf2_vf_vf2_vf2_rvvm1_sleef(x, c1, c0); }
static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef poly2df_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef c1, vfloat2_rvvm1_sleef c0) { return dfmla_vf2_vf_vf2_vf2_rvvm1_sleef(x, vcast_vf2_vf_vf_rvvm1_sleef(c1, vcast_vf_f_rvvm1_sleef(0)), c0); }
static SLEEF_ALWAYS_INLINE SLEEF_CONST vfloat2_rvvm1_sleef poly4df_rvvm1_sleef(vfloat_rvvm1_sleef x, vfloat_rvvm1_sleef c3, vfloat2_rvvm1_sleef c2, vfloat2_rvvm1_sleef c1, vfloat2_rvvm1_sleef c0) {
  return dfmla_vf2_vf_vf2_vf2_rvvm1_sleef(vmul_vf_vf_vf_rvvm1_sleef(x, x), poly2df_rvvm1_sleef(x, c3, c2), poly2df_b_rvvm1_sleef(x, c1, c0));
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_erffx_u10rvvm1(vfloat_rvvm1_sleef a) {
  vfloat_rvvm1_sleef t, x = vabs_vf_vf_rvvm1_sleef(a);
  vfloat2_rvvm1_sleef t2;
  vfloat_rvvm1_sleef x2 = vmul_vf_vf_vf_rvvm1_sleef(x, x), x4 = vmul_vf_vf_vf_rvvm1_sleef(x2, x2);
  rvv_sp_vopmask_rvvm1_sleef o25 = vle_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(2.5));

  if (__builtin_expect(!!(vtestallones_i_vo32_rvvm1_sleef(o25)), 1)) {

    t = vmla_vf_vf_vf_vf_rvvm1_sleef((x4), (vmla_vf_vf_vf_vf_rvvm1_sleef((x), (vcast_vf_f_rvvm1_sleef(-0.4360447008e-6)), (vcast_vf_f_rvvm1_sleef(+0.6867515367e-5)))), (vmla_vf_vf_vf_vf_rvvm1_sleef((x2), (vmla_vf_vf_vf_vf_rvvm1_sleef((x), (vcast_vf_f_rvvm1_sleef(-0.3045156700e-4)), (vcast_vf_f_rvvm1_sleef(+0.9808536561e-4)))), (vmla_vf_vf_vf_vf_rvvm1_sleef((x), (vcast_vf_f_rvvm1_sleef(+0.2395523916e-3)), (vcast_vf_f_rvvm1_sleef(+0.1459901541e-3)))))))

                               ;
    t2 = poly4df_rvvm1_sleef(x, t,
                 vcast_vf2_f_f_rvvm1_sleef(0.0092883445322513580322, -2.7863745897025330755e-11),
                 vcast_vf2_f_f_rvvm1_sleef(0.042275499552488327026, 1.3461399289988106057e-09),
                 vcast_vf2_f_f_rvvm1_sleef(0.070523701608180999756, -3.6616309318707365163e-09));
    t2 = dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), dfmul_vf2_vf2_vf_rvvm1_sleef(t2, x));
    t2 = dfsqu_vf2_vf2_rvvm1_sleef(t2);
    t2 = dfsqu_vf2_vf2_rvvm1_sleef(t2);
    t2 = dfsqu_vf2_vf2_rvvm1_sleef(t2);
    t2 = dfsqu_vf2_vf2_rvvm1_sleef(t2);
    t2 = dfrec_vf2_vf2_rvvm1_sleef(t2);
  } else {

    t = vmla_vf_vf_vf_vf_rvvm1_sleef((x4), (vmla_vf_vf_vf_vf_rvvm1_sleef((x), ((vsel_vf_vo_f_f_rvvm1_sleef(o25, -0.4360447008e-6, -0.1130012848e-6))), ((vsel_vf_vo_f_f_rvvm1_sleef(o25, +0.6867515367e-5, +0.4115272986e-5))))), (vmla_vf_vf_vf_vf_rvvm1_sleef((x2), (vmla_vf_vf_vf_vf_rvvm1_sleef((x), ((vsel_vf_vo_f_f_rvvm1_sleef(o25, -0.3045156700e-4, -0.6928304356e-4))), ((vsel_vf_vo_f_f_rvvm1_sleef(o25, +0.9808536561e-4, +0.7172692567e-3))))), (vmla_vf_vf_vf_vf_rvvm1_sleef((x), ((vsel_vf_vo_f_f_rvvm1_sleef(o25, +0.2395523916e-3, -0.5131045356e-2))), ((vsel_vf_vo_f_f_rvvm1_sleef(o25, +0.1459901541e-3, +0.2708637156e-1))))))))

                                                                       ;
    t2 = poly4df_rvvm1_sleef(x, t,
                 vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o25, vcast_vf2_f_f_rvvm1_sleef(0.0092883445322513580322, -2.7863745897025330755e-11),
                                     vcast_vf2_f_f_rvvm1_sleef(-0.11064319312572479248, 3.7050452777225283007e-09)),
                 vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o25, vcast_vf2_f_f_rvvm1_sleef(0.042275499552488327026, 1.3461399289988106057e-09),
                                     vcast_vf2_f_f_rvvm1_sleef(-0.63192230463027954102, -2.0200432585073177859e-08)),
                 vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o25, vcast_vf2_f_f_rvvm1_sleef(0.070523701608180999756, -3.6616309318707365163e-09),
                                     vcast_vf2_f_f_rvvm1_sleef(-1.1296638250350952148, 2.5515120196453259252e-08)));
    t2 = dfmul_vf2_vf2_vf_rvvm1_sleef(t2, x);
    vfloat2_rvvm1_sleef s2 = dfadd_vf2_vf_vf2_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(1), t2);
    s2 = dfsqu_vf2_vf2_rvvm1_sleef(s2);
    s2 = dfsqu_vf2_vf2_rvvm1_sleef(s2);
    s2 = dfsqu_vf2_vf2_rvvm1_sleef(s2);
    s2 = dfsqu_vf2_vf2_rvvm1_sleef(s2);
    s2 = dfrec_vf2_vf2_rvvm1_sleef(s2);
    t2 = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o25, s2, vcast_vf2_vf_vf_rvvm1_sleef(expkf_rvvm1_sleef(t2), vcast_vf_f_rvvm1_sleef(0)));
  }

  t2 = dfadd2_vf2_vf2_vf_rvvm1_sleef(t2, vcast_vf_f_rvvm1_sleef(-1));
  t2 = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(vlt_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(1e-4)), dfmul_vf2_vf2_vf_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(-1.1283792257308959961, 5.8635383422197591097e-08), x), t2);

  vfloat_rvvm1_sleef z = vneg_vf_vf_rvvm1_sleef(vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(t2), vf2gety_vf_vf2_rvvm1_sleef(t2)));
  z = vsel_vf_vo_vf_vf_rvvm1_sleef(vge_vo_vf_vf_rvvm1_sleef(x, vcast_vf_f_rvvm1_sleef(6)), vcast_vf_f_rvvm1_sleef(1), z);
  z = vsel_vf_vo_vf_vf_rvvm1_sleef(visinf_vo_vf_rvvm1_sleef(a), vcast_vf_f_rvvm1_sleef(1), z);
  z = vsel_vf_vo_vf_vf_rvvm1_sleef(veq_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0)), vcast_vf_f_rvvm1_sleef(0), z);
  z = vmulsign_vf_vf_vf_rvvm1_sleef(z, a);

  return z;
}

SLEEF_INLINE SLEEF_CONST vfloat_rvvm1_sleef Sleef_erfcfx_u15rvvm1(vfloat_rvvm1_sleef a) {
  vfloat_rvvm1_sleef s = a, r = vcast_vf_f_rvvm1_sleef(0), t;
  vfloat2_rvvm1_sleef u, d, x;
  a = vabs_vf_vf_rvvm1_sleef(a);
  rvv_sp_vopmask_rvvm1_sleef o0 = vlt_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(1.0));
  rvv_sp_vopmask_rvvm1_sleef o1 = vlt_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(2.2));
  rvv_sp_vopmask_rvvm1_sleef o2 = vlt_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(4.3));
  rvv_sp_vopmask_rvvm1_sleef o3 = vlt_vo_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(10.1));

  u = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o1, vcast_vf2_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0)), dfdiv_vf2_vf2_vf2_rvvm1_sleef(vcast_vf2_f_f_rvvm1_sleef(1, 0), vcast_vf2_vf_vf_rvvm1_sleef(a, vcast_vf_f_rvvm1_sleef(0))));

  t = vsel_vf_vo_vo_vo_f_f_f_f_rvvm1_sleef(o0, o1, o2, -0.8638041618e-4f, -0.6236977242e-5f, -0.3869504035e+0f, +0.1115344167e+1f);
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(u), vsel_vf_vo_vo_vo_f_f_f_f_rvvm1_sleef(o0, o1, o2, +0.6000166177e-3f, +0.5749821503e-4f, +0.1288077235e+1f, -0.9454904199e+0f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(u), vsel_vf_vo_vo_vo_f_f_f_f_rvvm1_sleef(o0, o1, o2, -0.1665703603e-2f, +0.6002851478e-5f, -0.1816803217e+1f, -0.3667259514e+0f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(u), vsel_vf_vo_vo_vo_f_f_f_f_rvvm1_sleef(o0, o1, o2, +0.1795156277e-3f, -0.2851036377e-2f, +0.1249150872e+1f, +0.7155663371e+0f));
  t = vmla_vf_vf_vf_vf_rvvm1_sleef(t, vf2getx_vf_vf2_rvvm1_sleef(u), vsel_vf_vo_vo_vo_f_f_f_f_rvvm1_sleef(o0, o1, o2, +0.1914106123e-1f, +0.2260518074e-1f, -0.1328857988e+0f, -0.1262947265e-1f));

  d = dfmul_vf2_vf2_vf_rvvm1_sleef(u, t);
  d = dfadd2_vf2_vf2_vf2_rvvm1_sleef(d, vsel_vf2_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.102775359343930288081655368891e+0, -0.105247583459338632253369014063e+0, -0.482365310333045318680618892669e+0, -0.498961546254537647970305302739e+0));
  d = dfmul_vf2_vf2_vf2_rvvm1_sleef(d, u);
  d = dfadd2_vf2_vf2_vf2_rvvm1_sleef(d, vsel_vf2_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.636619483208481931303752546439e+0, -0.635609463574589034216723775292e+0, -0.134450203224533979217859332703e-2, -0.471199543422848492080722832666e-4));
  d = dfmul_vf2_vf2_vf2_rvvm1_sleef(d, u);
  d = dfadd2_vf2_vf2_vf2_rvvm1_sleef(d, vsel_vf2_vo_vo_vo_d_d_d_d_rvvm1_sleef(o0, o1, o2, -0.112837917790537404939545770596e+1, -0.112855987376668622084547028949e+1, -0.572319781150472949561786101080e+0, -0.572364030327966044425932623525e+0));

  x = dfmul_vf2_vf2_vf_rvvm1_sleef(vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o1, d, vcast_vf2_vf_vf_rvvm1_sleef(vneg_vf_vf_rvvm1_sleef(a), vcast_vf_f_rvvm1_sleef(0))), a);
  x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o1, x, dfadd2_vf2_vf2_vf2_rvvm1_sleef(x, d));

  x = expk2f_rvvm1_sleef(x);
  x = vsel_vf2_vo_vf2_vf2_rvvm1_sleef(o1, x, dfmul_vf2_vf2_vf2_rvvm1_sleef(x, u));

  r = vsel_vf_vo_vf_vf_rvvm1_sleef(o3, vadd_vf_vf_vf_rvvm1_sleef(vf2getx_vf_vf2_rvvm1_sleef(x), vf2gety_vf_vf2_rvvm1_sleef(x)), vcast_vf_f_rvvm1_sleef(0));
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(vsignbit_vo_vf_rvvm1_sleef(s), vsub_vf_vf_vf_rvvm1_sleef(vcast_vf_f_rvvm1_sleef(2), r), r);
  r = vsel_vf_vo_vf_vf_rvvm1_sleef(visnan_vo_vf_rvvm1_sleef(s), vcast_vf_f_rvvm1_sleef(__builtin_nanf("")), r);
  return r;
}
