/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities on the wrap.utils pakage


module gstreamer.ParentBufferMeta;

private import gobject.ObjectG;
private import gstreamer.MetaInfo;
private import gstreamer.c.functions;
public  import gstreamer.c.types;
public  import gstreamerc.gstreamertypes;


/**
 * The #GstParentBufferMeta is a #GstMeta which can be attached to a #GstBuffer
 * to hold a reference to another buffer that is only released when the child
 * #GstBuffer is released.
 * 
 * Typically, #GstParentBufferMeta is used when the child buffer is directly
 * using the #GstMemory of the parent buffer, and wants to prevent the parent
 * buffer from being returned to a buffer pool until the #GstMemory is available
 * for re-use.
 *
 * Since: 1.6
 */
public struct ParentBufferMeta
{

	/**
	 * Gets the global #GstMetaInfo describing  the #GstParentBufferMeta meta.
	 *
	 * Returns: The #GstMetaInfo
	 *
	 * Since: 1.6
	 */
	public static MetaInfo getInfo()
	{
		auto __p = gst_parent_buffer_meta_get_info();

		if(__p is null)
		{
			return null;
		}

		return ObjectG.getDObject!(MetaInfo)(cast(GstMetaInfo*) __p);
	}

	/** */
	public static GType getType()
	{
		return gst_parent_buffer_meta_api_get_type();
	}
}
