/*
 * Copyright(C) 2017-2024 Marvell
 *
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:

 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 *   TO,THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 *   PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR HOLDER OR
 *   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 *   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 *   OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *   WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *   OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 *   EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __ATL2_HW_H
#define __ATL2_HW_H

FILE_LICENCE ( BSD2 );

#define ATL2_GLB_RST_CTRL2 0x3040
#define ATL2_HOST_FINISHED_WRITE 0xE00
#define ATL2_MCP_BUSY_WRITE 0xE04
#define ATL2_HOST_ITR_REQ 0xF00


#define ATL2_RESET_STATUS_REQ_GSR		( 1U << 0x0 )
#define ATL2_RESET_STATUS_REQ_HOST_BOOT		( 1U << 0x8 )
#define ATL2_RESET_STATUS_REQ_MAC_FAST_BOOT	( 1U << 0xA )
#define ATL2_RESET_STATUS_REQ_PHY_FAST_BOOT	( 1U << 0xB )

#define ATL2_RESET_STATUS_HOST_LOAD_COMPLETED	( 1U << 0x10 )
#define ATL2_RESET_STATUS_REQUIRE_HOST_LOAD	( 1U << 0x11 )
#define ATL2_RESET_STATUS_BC_STARTED		( 1U << 0x18 )
#define ATL2_RESET_STATUS_CRASH_DURING_INIT	( 1U << 0x1B )
#define ATL2_RESET_STATUS_BC_FAILED		( 1U << 0x1C )
#define ATL2_RESET_STATUS_FW_FAILED		( 1U << 0x1D )
#define ATL2_RESET_STATUS_FW_SUCCEED		( 1U << 0x1F )

#define ATL2_RESET_STATUS_BOOT_FAILED_MASK ( ATL2_RESET_STATUS_CRASH_DURING_INIT | ATL2_RESET_STATUS_BC_FAILED | ATL2_RESET_STATUS_FW_FAILED )
#define ATL2_RESET_STATUS_BOOT_COMPLETED_MASK ( ATL2_RESET_STATUS_BOOT_FAILED_MASK | ATL2_RESET_STATUS_FW_SUCCEED )

#define ATL2_FW_HOST_INTERRUPT_REQUEST_READY		0x0001
#define ATL2_FW_HOST_INTERRUPT_MAC_READY		0x0004
#define ATL2_FW_HOST_INTERRUPT_DATA_HANDLED		0x0100
#define ATL2_FW_HOST_INTERRUPT_LINK_UP			0x0200
#define ATL2_FW_HOST_INTERRUPT_LINK_DOWN		0x0400
#define ATL2_FW_HOST_INTERRUPT_PHY_FAULT		0x0800
#define ATL2_FW_HOST_INTERRUPT_MAC_FAULT		0x1000
#define ATL2_FW_HOST_INTERRUPT_TEMPERATURE_WARNING	0x2000
#define ATL2_FW_HOST_INTERRUPT_HEARTBEAT		0x4000

#define ATL2_FW_LINK_RATE_INVALID 0
#define ATL2_FW_LINK_RATE_10M     1
#define ATL2_FW_LINK_RATE_100M    2
#define ATL2_FW_LINK_RATE_1G      3
#define ATL2_FW_LINK_RATE_2G5     4
#define ATL2_FW_LINK_RATE_5G      5
#define ATL2_FW_LINK_RATE_10G     6

#define ATL2_HOST_MODE_INVALID      0U
#define ATL2_HOST_MODE_ACTIVE       1U
#define ATL2_HOST_MODE_SLEEP_PROXY  2U
#define ATL2_HOST_MODE_LOW_POWER    3U
#define ATL2_HOST_MODE_SHUTDOWN     4U

#define ATL2_MIF_SHARED_BUF_IN 0x12000
#define ATL2_MIF_SHARED_BUF_OUT 0x13000

#define ATL2_MTU_IN_OFF 0x0
#define ATL2_MAC_ADDR_IN_OFF 0x8
#define ATL2_LINK_CTRL_IN_OFF 0x10
#define ATL2_LINK_OPTS_IN_OFF 0x18

#define ATL2_FW_OUT_OFF 0x8
#define ATL2_LINK_STS_OUT_OFF 0x14

#define ATL2_DELAY_10  10
#define ATL2_DELAY_100  100

#endif
