/*
 * snmptest1.C: Test example program 1 for snmpkit
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later 
 * version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * See the AUTHORS file for a list of people who have hacked on 
 * this code. 
 * See the ChangeLog file for a list of changes.
 *
 */

#include <snmpkit>

#include <string.h>
#include <iostream.h>

static const char SYSDESC[]="1.3.6.1.2.1.1.1.0";

struct PrinterInfo{
  char *sysDesc;
};

void printer_info_insert_sysDesc(void *dest_ptr,const char *str){
  PrinterInfo *dest=reinterpret_cast<PrinterInfo*>(dest_ptr);
  dest->sysDesc=strdup(str);
}

void *do_req(SNMP_session *session){
  SNMP_session *printer=reinterpret_cast<SNMP_session*>(session);
  PrinterInfo prinfo;
  try{
    printer->setDebug();
    SNMP_structFiller table(*printer);
    table.append_string(SYSDESC,printer_info_insert_sysDesc);
    table.get(&prinfo);
  }catch(ProgrammerException e){
    cerr << "programmer error\n";
  }catch(DecodeException e){
    cerr << "decode error\n";
  }catch(...){
    cerr << "other error\n";
  }
  cout << printer->Hostname() << ' ' << prinfo.sysDesc << endl;
  return NULL;
}

int main(int argc,char **argv){
  if(argc!=2)
    exit(2);
  try{
    SNMP_session printer(argv[1],do_req);
    SNMP_sessions_done();
  }catch(ProgrammerException e){
    cerr << "programmer error\n";
  }catch(DecodeException e){
    cerr << "decode error\n";
  }catch(...){
    cerr << "other error\n";
  }
  exit(1);
}  

