#ifndef FINISHED_MODEL_H__
#define FINISHED_MODEL_H__

#include "global.h"

#include <QAbstractTableModel>
#include <QList>
#include "finisheditem.h"

class FinishedModel : public QAbstractTableModel
{
    Q_OBJECT
    public:
        FinishedModel() {}
        virtual ~FinishedModel() {}
                 
        int rowCount ( const QModelIndex& ) const {return itemList.size();}
        int columnCount ( const QModelIndex& ) const {return 4;}
        QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
        QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;

    public slots:
        void onItemAdded( const FinishedItem& );
        void onItemRemoved( int );
		void onAllRemoved(int);
    
    private:
        QMap<int,FinishedItem> items;
        QList<FinishedItem*> itemList;
};




#endif

