/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_SensorCapabilitiesAccess.h"

int Sensors_OpenDRIM_SensorCapabilities_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Sensors_CIM_Capabilities_load(broker, errorMessage));
	CF_assert(Sensors_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Sensors_OpenDRIM_SensorCapabilities_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(Sensors_CIM_Capabilities_unload(errorMessage));
	CF_assert(Sensors_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int Sensors_OpenDRIM_SensorCapabilities_isAssociated(const Instance& Capabilities, const Instance& ManagedElement, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int Sensors_OpenDRIM_SensorCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SensorCapabilities>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(Sensors_OpenDRIM_SensorCapabilities_enumerateCapabilitiess(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(Sensors_OpenDRIM_SensorCapabilities_enumerateCapabilitiess(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		Sensors_OpenDRIM_SensorCapabilities_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			Capabilities_classnames[0], ManagedElement_classnames[0],
			Capabilities_role.c_str(), ManagedElement_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(Sensors_OpenDRIM_SensorCapabilities_referenceCapabilitiesToManagedElement(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int Sensors_OpenDRIM_SensorCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SensorCapabilities& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath Capabilities_objectpath;
	instance.getCapabilities(Capabilities_objectpath);
	Instance Capabilities_instance;
	CF_assert(Sensors_OpenDRIM_SensorCapabilities_getCapabilities(broker, ctx, Capabilities_objectpath, Capabilities_instance, NULL, errorMessage));
	
	Objectpath ManagedElement_objectpath;
	instance.getManagedElement(ManagedElement_objectpath);
	Instance ManagedElement_instance;
	CF_assert(Sensors_OpenDRIM_SensorCapabilities_getManagedElement(broker, ctx, ManagedElement_objectpath, ManagedElement_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(Sensors_OpenDRIM_SensorCapabilities_isAssociated(Capabilities_instance, ManagedElement_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	CF_assert(Sensors_OpenDRIM_SensorCapabilities_populate(instance, errorMessage));
	_L_;
	return OK;
}

int Sensors_OpenDRIM_SensorCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SensorCapabilities& newInstance, const OpenDRIM_SensorCapabilities& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_SensorCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SensorCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_SensorCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SensorCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Sensors_OpenDRIM_SensorCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> ManagedElement_instances;
	if (discriminant=="a")
		CF_assert(Sensors_OpenDRIM_SensorCapabilities_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Sensors_OpenDRIM_SensorCapabilities_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Sensors_OpenDRIM_SensorCapabilities_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<ManagedElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Sensors_OpenDRIM_SensorCapabilities_isAssociated(Capabilities_instance, ManagedElement_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			ManagedElement_associatedInstances.push_back(ManagedElement_instances[i]);
	}
	_L_;
	return OK;
}

int Sensors_OpenDRIM_SensorCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Capabilities_instances;
	if (discriminant=="a")
		CF_assert(Sensors_OpenDRIM_SensorCapabilities_enumerateCapabilitiess(broker, ctx, Capabilities_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(Sensors_OpenDRIM_SensorCapabilities_enumerateCapabilitiess(broker, ctx, Capabilities_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(Sensors_OpenDRIM_SensorCapabilities_enumerateCapabilitiess(broker, ctx, Capabilities_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Capabilities_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(Sensors_OpenDRIM_SensorCapabilities_isAssociated(Capabilities_instances[i], ManagedElement_instance, isAssociated, errorMessage));
		if (isAssociated)
			Capabilities_associatedInstances.push_back(Capabilities_instances[i]);
	}
	_L_;
	return OK;
}

int Sensors_OpenDRIM_SensorCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_SensorCapabilities>& OpenDRIM_SensorCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < ManagedElement_instances.size(); i++) {
		OpenDRIM_SensorCapabilities instance;
		instance.setCapabilities(((Instance) Capabilities_instance).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instances[i]).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(Sensors_OpenDRIM_SensorCapabilities_populate(instance, errorMessage));
		}
		
		OpenDRIM_SensorCapabilities_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Sensors_OpenDRIM_SensorCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_SensorCapabilities>& OpenDRIM_SensorCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Capabilities_instances.size(); i++) {
		OpenDRIM_SensorCapabilities instance;
		instance.setCapabilities(((Instance) Capabilities_instances[i]).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instance).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(Sensors_OpenDRIM_SensorCapabilities_populate(instance, errorMessage));
		}
		
		OpenDRIM_SensorCapabilities_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int Sensors_OpenDRIM_SensorCapabilities_populate(OpenDRIM_SensorCapabilities& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

